/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.io.Serializable;
import java.util.List;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class URLRegExpExtractor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger log;
    private String url;

    public URLRegExpExtractor(String url, Logger log) {
        this.url = url;
        this.log = log;
    }

    public boolean match(String pattern) throws DynamicException {
        String v = this.read(pattern);
        return v != null && !"".equals(v);
    }

    private String getMessaggioNotFound(String tipo, String pattern, RegExpNotFoundException e) {
        return "Estrazione (" + tipo + ") '" + pattern + "' non ha trovato risultati: " + e.getMessage();
    }

    private String getMessaggioErrore(String tipo, String pattern, Exception e) {
        return "Estrazione (" + tipo + ") '" + pattern + "' fallita: " + e.getMessage();
    }

    public String read(String pattern) throws DynamicException {
        String valore = null;
        try {
            valore = RegularExpressionEngine.getStringMatchPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug(this.getMessaggioNotFound("read", pattern, e), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException(this.getMessaggioErrore("read", pattern, e), e);
        }
        return valore;
    }

    public List<String> readList(String pattern) throws DynamicException {
        List valore = null;
        try {
            valore = RegularExpressionEngine.getAllStringMatchPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug(this.getMessaggioNotFound("readList", pattern, e), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException(this.getMessaggioErrore("readList", pattern, e), e);
        }
        return valore;
    }

    public boolean found(String pattern) throws DynamicException {
        String v = this.find(pattern);
        return v != null && !"".equals(v);
    }

    public String find(String pattern) throws DynamicException {
        String valore = null;
        try {
            valore = RegularExpressionEngine.getStringFindPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug(this.getMessaggioNotFound("find", pattern, e), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException(this.getMessaggioErrore("find", pattern, e), e);
        }
        return valore;
    }

    public List<String> findAll(String pattern) throws DynamicException {
        List valore = null;
        try {
            valore = RegularExpressionEngine.getAllStringFindPattern((String)this.url, (String)pattern);
        }
        catch (RegExpNotFoundException e) {
            this.log.debug(this.getMessaggioNotFound("findAll", pattern, e), (Throwable)e);
        }
        catch (RegExpException e) {
            throw new DynamicException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DynamicException(this.getMessaggioErrore("findAll", pattern, e), e);
        }
        return valore;
    }
}

