/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.itwallet;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.ForcedResponseMessage;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.handlers.OutResponseHandler;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public class FonteAutenticaV131ResponseGenerator
implements OutResponseHandler {
    private static final String ERROR_INVALID_TOKEN = "Token not valid";
    private static final String ERROR_NOT_FOUND_HASH = "Message hash not found";
    private static final String ERROR_NOT_PRESENT_TOKEN = "Token not present";
    private static final String ERROR_MALFORMED_TOKEN = "Token malformed";
    private static final String ERROR_NOT_FOUND = "Resource not found";
    private static final String ERROR_PROCESSING = "Processing error";
    private static final String ERROR_BAD_REQUEST = "Invalid input";
    private static final String ERROR_NOT_FOUND_AGID_JWT = "AgID-JWT-Signature token not found";
    private static final String ERROR_MALFORMED_AGID_JWT = "AgID-JWT-Signature token malformed";
    private static final String HASH_NOT_FOUND_MATCHING = ".*Parameter 'If-Match' is required.*";

    @Override
    public void invoke(OutResponseContext context) throws HandlerException {
        if (context != null && context.getMessaggio() != null && MessageType.JSON.equals((Object)context.getMessaggio().getMessageType()) && MessageRole.FAULT.equals((Object)context.getMessaggio().getMessageRole())) {
            try {
                this.parseError(context);
            }
            catch (MessageException | ProtocolException e) {
                context.getLogCore().error("Conversione non riuscita: " + e.getMessage(), e);
            }
        }
    }

    private String getTransactionId(OutResponseContext context) throws HandlerException {
        String id = null;
        if (context.getPddContext() != null) {
            PdDContext pddContext = context.getPddContext();
            if (pddContext.getObject(Costanti.ID_TRANSAZIONE) == null) {
                throw new HandlerException("Identificativo della transazione assente");
            }
            id = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
        }
        if (id == null) {
            throw new HandlerException("Identificativo della transazione assente");
        }
        return id;
    }

    private Pair<FonteAutenticaError, String> parseValidazioneRichiesta(String idTransazione) {
        if (FonteAutenticaV131ResponseGenerator.isErroreValidazioneRichiestaHashNotFound(idTransazione)) {
            return Pair.of((Object)((Object)FonteAutenticaError.INVALID_REQUEST), (Object)ERROR_NOT_FOUND_HASH);
        }
        return Pair.of((Object)((Object)FonteAutenticaError.INVALID_REQUEST), (Object)ERROR_BAD_REQUEST);
    }

    private Optional<Eccezione> getEccezioneWithCodiceErrore(Transaction transaction) {
        return transaction.getTracciaRisposta().getBusta().getListaEccezioni().stream().filter(e -> e.getCodiceEccezione() != null).findAny();
    }

    private Pair<FonteAutenticaError, String> parsePddContext(OutResponseContext context, String idTransazione) throws ProtocolException {
        Transaction transaction = FonteAutenticaV131ResponseGenerator.getTransaction(idTransazione);
        if (transaction == null || transaction.getTracciaRisposta() == null || transaction.getTracciaRisposta().getBusta() == null || transaction.getTracciaRisposta().getBusta().getListaEccezioni() == null || transaction.getTracciaRisposta().getBusta().getListaEccezioni().isEmpty()) {
            return null;
        }
        Optional<Eccezione> eccezioneOpt = this.getEccezioneWithCodiceErrore(transaction);
        if (eccezioneOpt.isEmpty()) {
            return null;
        }
        Eccezione eccezione = eccezioneOpt.get();
        if (eccezione.getCodiceEccezione().equals(CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE.getCodice())) {
            String desc = eccezione.getDescrizione(context.getProtocolFactory());
            if (desc != null && "Header HTTP 'Agid-JWT-Signature' non presente".equals(desc)) {
                return Pair.of((Object)((Object)FonteAutenticaError.INVALID_TOKEN), (Object)ERROR_NOT_FOUND_AGID_JWT);
            }
        } else {
            if (eccezione.getCodiceEccezione().equals(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA.getCodice()) || CodiceErroreCooperazione.isEccezioneServizioApplicativoErogatore((CodiceErroreCooperazione)eccezione.getCodiceEccezione()) || CodiceErroreCooperazione.isEccezioneSicurezza((CodiceErroreCooperazione)eccezione.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneSicurezzaToken((CodiceErroreCooperazione)eccezione.getCodiceEccezione())) {
                String desc = eccezione.getDescrizione(context.getProtocolFactory());
                if (desc != null && desc.contains("Header 'Authorization'")) {
                    return Pair.of((Object)((Object)FonteAutenticaError.INVALID_TOKEN), (Object)ERROR_INVALID_TOKEN);
                }
                return Pair.of((Object)((Object)FonteAutenticaError.INVALID_TOKEN), (Object)ERROR_MALFORMED_AGID_JWT);
            }
            if (CodiceErroreCooperazione.isEccezioneSicurezzaToken((CodiceErroreCooperazione)eccezione.getCodiceEccezione())) {
                return Pair.of((Object)((Object)FonteAutenticaError.INVALID_TOKEN), (Object)ERROR_INVALID_TOKEN);
            }
        }
        return null;
    }

    private Pair<FonteAutenticaError, String> parseCode(OutResponseContext context) {
        if (context.getMessaggio().getTransportResponseContext() != null) {
            int code = NumberUtils.toInt((String)context.getMessaggio().getTransportResponseContext().getCodiceTrasporto(), (int)500);
            if (code == 404) {
                return Pair.of((Object)((Object)FonteAutenticaError.NOT_FOUND), (Object)ERROR_NOT_FOUND);
            }
            if (code == 401 || code == 403) {
                return Pair.of((Object)((Object)FonteAutenticaError.INVALID_TOKEN), (Object)ERROR_INVALID_TOKEN);
            }
            if (code >= 400 && code < 500) {
                return Pair.of((Object)((Object)FonteAutenticaError.INVALID_REQUEST), (Object)ERROR_BAD_REQUEST);
            }
        }
        return null;
    }

    private void parseError(OutResponseContext context) throws MessageException, HandlerException, ProtocolException {
        Pair error = Pair.of((Object)((Object)FonteAutenticaError.TEMPORARY_UNAVAILABLE), (Object)"The API is temporary unavailable");
        String idTransazione = this.getTransactionId(context);
        error = FonteAutenticaV131ResponseGenerator.isErroreValidazioneRichiesta(context) ? this.parseValidazioneRichiesta(idTransazione) : (FonteAutenticaV131ResponseGenerator.isRequestReadTimeout(context) || FonteAutenticaV131ResponseGenerator.isContenutiRichiestaNonRiconosciuto(context) || FonteAutenticaV131ResponseGenerator.isErroreCorrelazioneApplicativaRisposta(context) || FonteAutenticaV131ResponseGenerator.isErroreTrasformazioneRichiesta(context) ? Pair.of((Object)((Object)FonteAutenticaError.INVALID_REQUEST), (Object)ERROR_BAD_REQUEST) : (FonteAutenticaV131ResponseGenerator.isErroreTokenNonPresente(context) ? Pair.of((Object)((Object)FonteAutenticaError.INVALID_TOKEN), (Object)ERROR_NOT_PRESENT_TOKEN) : (FonteAutenticaV131ResponseGenerator.isErroreToken(context) ? Pair.of((Object)((Object)FonteAutenticaError.INVALID_TOKEN), (Object)ERROR_MALFORMED_TOKEN) : (FonteAutenticaV131ResponseGenerator.isOperazioneNonIndividuata(context) ? Pair.of((Object)((Object)FonteAutenticaError.NOT_FOUND), (Object)ERROR_NOT_FOUND) : (FonteAutenticaV131ResponseGenerator.isConnectorError(context) || FonteAutenticaV131ResponseGenerator.isConnectionTimeout(context) || FonteAutenticaV131ResponseGenerator.isReadTimeout(context) || FonteAutenticaV131ResponseGenerator.isResponseReadTimeout(context) || FonteAutenticaV131ResponseGenerator.isContenutiRispostaNonRiconosciuto(context) || FonteAutenticaV131ResponseGenerator.isErroreCorrelazioneApplicativaRisposta(context) || FonteAutenticaV131ResponseGenerator.isErroreSicurezzaMessaggioRisposta(context) || FonteAutenticaV131ResponseGenerator.isErroreAllegatiRisposta(context) || FonteAutenticaV131ResponseGenerator.isErroreValidazioneRisposta(context) || FonteAutenticaV131ResponseGenerator.isErroreTrasformazioneRisposta(context) || FonteAutenticaV131ResponseGenerator.isRispostaDuplicata(context) ? Pair.of((Object)((Object)FonteAutenticaError.SERVER_ERROR), (Object)ERROR_PROCESSING) : (context.getPddContext() != null ? Objects.requireNonNullElse(this.parsePddContext(context, idTransazione), Objects.requireNonNullElse(this.parseCode(context), error)) : Objects.requireNonNullElse(this.parseCode(context), error)))))));
        this.buildError(context, (FonteAutenticaError)((Object)error.getLeft()), (String)error.getRight());
    }

    private static Transaction getTransaction(String idTransazione) {
        Transaction transaction = null;
        try {
            transaction = TransactionContext.getTransaction(idTransazione);
        }
        catch (TransactionNotExistsException transactionNotExistsException) {
            // empty catch block
        }
        return transaction;
    }

    private static boolean isErroreValidazioneRichiesta(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_VALIDAZIONE_RICHIESTA, context);
    }

    private static boolean isErroreValidazioneRisposta(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_VALIDAZIONE_RISPOSTA, context);
    }

    private static boolean isErroreTokenNonPresente(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.TOKEN_NON_PRESENTE, context);
    }

    private static boolean isErroreToken(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_TOKEN, context);
    }

    private static boolean isOperazioneNonIndividuata(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.OPERAZIONE_NON_INDIVIDUATA, context);
    }

    private static boolean isReadTimeout(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoReadTimeout", context);
    }

    private static boolean isRequestReadTimeout(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoRequestReadTimeout", context);
    }

    private static boolean isResponseReadTimeout(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoResponseReadTimeout", context);
    }

    private static boolean isConnectionTimeout(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreString((MapKey<String>)org.openspcoop2.core.controllo_traffico.constants.Costanti.PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE, "controlloTrafficoConnectionTimeout", context);
    }

    private static boolean isConnectorError(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_UTILIZZO_CONNETTORE, context);
    }

    private static boolean isContenutiRichiestaNonRiconosciuto(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, context);
    }

    private static boolean isContenutiRispostaNonRiconosciuto(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, context);
    }

    private static boolean isErroreSicurezzaMessaggioRisposta(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_SICUREZZA_MESSAGGIO_RISPOSTA, context);
    }

    private static boolean isErroreAllegatiRisposta(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_ALLEGATI_MESSAGGIO_RISPOSTA, context);
    }

    private static boolean isErroreCorrelazioneApplicativaRisposta(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_CORRELAZIONE_APPLICATIVA_RISPOSTA, context);
    }

    private static boolean isErroreTrasformazioneRichiesta(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_TRASFORMAZIONE_RICHIESTA, context);
    }

    private static boolean isErroreTrasformazioneRisposta(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.ERRORE_TRASFORMAZIONE_RISPOSTA, context);
    }

    private static boolean isRispostaDuplicata(OutResponseContext context) {
        return FonteAutenticaV131ResponseGenerator.isErroreBoolean((MapKey<String>)Costanti.RISPOSTA_DUPLICATA, context);
    }

    static boolean isErroreValidazioneRichiestaHashNotFound(String idTransazione) {
        Transaction transaction = FonteAutenticaV131ResponseGenerator.getTransaction(idTransazione);
        if (transaction != null && transaction.getMsgDiagnostici() != null && !transaction.getMsgDiagnostici().isEmpty()) {
            for (MsgDiagnostico msg : transaction.getMsgDiagnostici()) {
                if (!FonteAutenticaV131ResponseGenerator.isMessaggioErroreValidazioneRichiestaHashNotFound(msg)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isMessaggioErroreValidazioneRichiestaHashNotFound(MsgDiagnostico msg) {
        if (msg.getSeverita() <= 2 && msg.getMessaggio() != null) {
            boolean match = false;
            try {
                match = RegularExpressionEngine.isFind((String)msg.getMessaggio(), (String)HASH_NOT_FOUND_MATCHING);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (match) {
                return true;
            }
        }
        return false;
    }

    static boolean isErroreBoolean(MapKey<String> key, OutResponseContext context) {
        if (context.getPddContext() != null && context.getPddContext().containsKey(key)) {
            Object o = context.getPddContext().get(key);
            if (o instanceof String) {
                String s = (String)o;
                return "true".equals(s);
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        return false;
    }

    static boolean isErroreString(String key, String value, OutResponseContext context) {
        MapKey k = Map.newMapKey((String)key);
        return FonteAutenticaV131ResponseGenerator.isErroreString((MapKey<String>)k, value, context);
    }

    static boolean isErroreString(MapKey<String> key, String value, OutResponseContext context) {
        Object o;
        if (context.getPddContext() != null && context.getPddContext().containsKey(key) && (o = context.getPddContext().get(key)) instanceof String) {
            String s = (String)o;
            return value.equals(s);
        }
        return false;
    }

    static boolean isRisposta5xxDifferenteJson(OutResponseContext context) {
        if (context != null && context.getMessaggio() != null && context.getMessaggio().getTransportResponseContext() != null && context.getMessaggio().getTransportResponseContext().getCodiceTrasporto() != null) {
            int codiceHttp = -1;
            try {
                codiceHttp = Integer.valueOf(context.getMessaggio().getTransportResponseContext().getCodiceTrasporto());
            }
            catch (Exception e) {
                context.getLogCore().error("isInternalRisposta5xxDifferenteJson: " + e.getMessage(), (Throwable)e);
            }
            if (codiceHttp >= 500 && codiceHttp <= 599) {
                return FonteAutenticaV131ResponseGenerator.isInternalRisposta5xxDifferenteJson(context);
            }
        }
        return false;
    }

    private static boolean isInternalRisposta5xxDifferenteJson(OutResponseContext context) {
        try {
            OpenSPCoop2RestMessage rest;
            String ct = context.getMessaggio().getContentType();
            if (ct == null) {
                return true;
            }
            if (context.getMessaggio() instanceof OpenSPCoop2RestMessage && !(rest = context.getMessaggio().castAsRest()).hasContent()) {
                return true;
            }
            String baseCT = null;
            if (ContentTypeUtilities.isMultipartType((String)ct)) {
                baseCT = ContentTypeUtilities.getInternalMultipartContentType((String)ct);
                if (baseCT != null) {
                    baseCT = ContentTypeUtilities.readBaseTypeFromContentType((String)baseCT);
                }
            } else {
                baseCT = ContentTypeUtilities.readBaseTypeFromContentType((String)ct);
            }
            if (!"application/json".equalsIgnoreCase(baseCT)) {
                return true;
            }
        }
        catch (Exception e) {
            context.getLogCore().error("isInternalRisposta5xxDifferenteJson failed: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private void buildError(OutResponseContext context, FonteAutenticaError error, String errorDetails) throws MessageException {
        ForcedResponseMessage frs = new ForcedResponseMessage();
        OpenSPCoop2RestJsonMessage json = context.getMessaggio().castAsRestJson();
        frs.setResponseCode("" + error.code);
        if (FonteAutenticaError.INVALID_TOKEN == error) {
            String msg = String.format("Bearer error=\"%s\", error_description=\"%s\"", error.name().toLowerCase(), errorDetails);
            frs.setHeadersValues(java.util.Map.of("WWW-Authenticate", List.of(msg)));
            frs.setContent(new byte[0]);
            frs.setContentType("text/plain");
        } else {
            String msg = String.format("{\"error\": \"%s\", \"error_description\": \"%s\"}", error.name().toLowerCase(), errorDetails);
            frs.setContent(msg.getBytes());
            frs.setContentType("application/json");
        }
        json.forceResponse(frs);
    }

    private static enum FonteAutenticaError {
        SERVER_ERROR(500),
        INVALID_REQUEST(400),
        INVALID_DPOP_PROOF(400),
        NOT_FOUND(404),
        TEMPORARY_UNAVAILABLE(503),
        INVALID_TOKEN(401);

        private Integer code;

        private FonteAutenticaError(Integer code) {
            this.code = code;
        }
    }
}

