/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import jakarta.xml.soap.SOAPHeaderElement;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class GestoreIntegrazionePDSoap
extends AbstractCore
implements IGestoreIntegrazionePDSoap {
    UtilitiesIntegrazione utilitiesRequest = null;
    UtilitiesIntegrazione utilitiesResponse = null;
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePDSoap() {
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(GestoreIntegrazionePDSoap.class);
        }
        try {
            this.utilitiesRequest = UtilitiesIntegrazione.getInstancePDRequest(this.log);
            this.utilitiesResponse = UtilitiesIntegrazione.getInstancePDResponse(this.log);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inRequestPDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesRequest.readHeader(soapMsg, integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInRequestHeader(InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inRequestPDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesRequest.deleteHeader(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInRequestHeader(InRequestPDMessage inRequestPDMessage, IDServizio idServizio, String idMessaggio, String servizioApplicativo, String correlazioneApplicativa) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inRequestPDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesRequest.updateHeader(soapMsg, inRequestPDMessage.getSoggettoPropeprietarioPortaDelegata(), idServizio, idMessaggio, servizioApplicativo, correlazioneApplicativa, null, UtilitiesIntegrazione.getIdTransazione(this.getPddContext()), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inRequestPDMessage.getBustaRichiesta(), true, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPDMessage outRequestPDMessage) throws HeaderIntegrazioneException {
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inResponsePDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesResponse.readHeader(soapMsg, integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInResponseHeader(InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inResponsePDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesResponse.deleteHeader(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInResponseHeader(InResponsePDMessage inResponsePDMessage, String idMessageRequest, String idMessageResponse, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inResponsePDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesResponse.updateHeader(soapMsg, inResponsePDMessage.getSoggettoMittente(), inResponsePDMessage.getServizio(), idMessageRequest, idMessageResponse, servizioApplicativo, correlazioneApplicativa, riferimentoCorrelazioneApplicativaRichiesta, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inResponsePDMessage.getBustaRichiesta(), false, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePDMessage outResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = outResponsePDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            SOAPHeaderElement header = this.utilitiesResponse.buildHeader(integrazione, this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), soapMsg, this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outResponsePDMessage.getBustaRichiesta(), false, TipoIntegrazione.SOAP));
            if (soapMsg.getSOAPHeader() == null) {
                soapMsg.getSOAPPart().getEnvelope().addHeader();
            }
            soapMsg.addHeaderElement(soapMsg.getSOAPHeader(), header);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }
}

