/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import jakarta.xml.soap.SOAPHeaderElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.integrazione.GestoreIntegrazionePDWSAddressing;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.OutRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazioneWSAddressing;

public class GestoreIntegrazionePDWSAddressingWithRequestOut
extends GestoreIntegrazionePDWSAddressing {
    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPDMessage outRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = outRequestPDMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            if (soapMsg.getSOAPHeader() == null) {
                soapMsg.getSOAPPart().getEnvelope().addHeader();
            }
            if (integrazione.getBusta() != null) {
                HeaderIntegrazioneBusta hBusta = integrazione.getBusta();
                if (hBusta.getDestinatario() != null && hBusta.getServizio() != null) {
                    SOAPHeaderElement wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getVersioneServizio());
                    soapMsg.addHeaderElement(soapMsg.getSOAPHeader(), wsaTO);
                    if (hBusta.getAzione() != null) {
                        SOAPHeaderElement wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getVersioneServizio(), hBusta.getAzione());
                        soapMsg.addHeaderElement(soapMsg.getSOAPHeader(), wsaAction);
                    }
                }
                if (hBusta.getMittente() != null) {
                    SOAPHeaderElement wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente());
                    soapMsg.addHeaderElement(soapMsg.getSOAPHeader(), wsaFROM);
                }
                if (hBusta.getID() != null) {
                    SOAPHeaderElement wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getID());
                    soapMsg.addHeaderElement(soapMsg.getSOAPHeader(), wsaID);
                }
                if (hBusta.getRiferimentoMessaggio() != null || hBusta.getIdCollaborazione() != null) {
                    String rif = hBusta.getRiferimentoMessaggio();
                    if (rif == null) {
                        rif = hBusta.getIdCollaborazione();
                    }
                    SOAPHeaderElement wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", rif);
                    soapMsg.addHeaderElement(soapMsg.getSOAPHeader(), wsaRelatesTo);
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDWSAddressing, " + e.getMessage(), e);
        }
    }
}

