/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.constants.StatoCheck;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.InvokerNodiRuntime;
import org.openspcoop2.protocol.registry.CertificateCheck;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.slf4j.Logger;

public abstract class AbstractConfigChecker {
    private InvokerNodiRuntime invoker;
    private ConfigurazioneNodiRuntime config;
    private List<String> nodiRuntime;

    private static String getErrorMessage(String risorsa, String nomeNodoRuntime, Exception e) {
        return "Errore durante la verifica dei certificati (jmxResource '" + risorsa + "') (node:" + nomeNodoRuntime + "): " + e.getMessage();
    }

    private static String getErrorMessageClasseNonGestita(Object o) {
        return "Classe '" + o.getClass().getName() + "' non gestita";
    }

    public static void addErrore(Map<String, List<String>> mapErrori, String errore, String nomeNodoRuntime) {
        if (mapErrori.containsKey(errore)) {
            List<String> l = mapErrori.get(errore);
            l.add(nomeNodoRuntime);
        } else {
            ArrayList<String> l = new ArrayList<String>();
            l.add(nomeNodoRuntime);
            mapErrori.put(errore, l);
        }
    }

    public static void printErrore(Map<String, List<String>> mapErrori, StringBuilder sbDetails) {
        AbstractConfigChecker.printErrore(mapErrori, sbDetails, -1, "");
    }

    public static void printErrore(Map<String, List<String>> mapErrori, StringBuilder sbDetails, int nodes, String multipleNodeSeparator) {
        if (!mapErrori.isEmpty()) {
            if (mapErrori.size() == 1) {
                if (sbDetails.length() > 0) {
                    sbDetails.append("\n");
                }
                String errore = mapErrori.keySet().iterator().next();
                List<String> nodiRuntimeErrore = mapErrori.get(errore);
                if (nodes > 1 && nodiRuntimeErrore != null && nodiRuntimeErrore.size() != nodes) {
                    String nodesLabel = AbstractConfigChecker.printNodes(mapErrori, errore);
                    sbDetails.append("(").append(nodesLabel).append(") ");
                }
                sbDetails.append(errore);
            } else {
                boolean first = true;
                for (String errore : mapErrori.keySet()) {
                    if (sbDetails.length() > 0) {
                        sbDetails.append("\n");
                        sbDetails.append(multipleNodeSeparator);
                    } else if (first) {
                        first = false;
                    } else {
                        sbDetails.append("\n");
                        sbDetails.append(multipleNodeSeparator);
                    }
                    String nodesLabel = AbstractConfigChecker.printNodes(mapErrori, errore);
                    sbDetails.append("(").append(nodesLabel).append(") ");
                    sbDetails.append(errore);
                }
            }
        }
    }

    private static String printNodes(Map<String, List<String>> mapErrori, String errore) {
        List<String> nodiRuntimeErrore = mapErrori.get(errore);
        StringBuilder sbNodir = new StringBuilder();
        for (String nodo : nodiRuntimeErrore) {
            if (sbNodir.length() > 0) {
                sbNodir.append(", ");
            }
            sbNodir.append(nodo);
        }
        return sbNodir.toString();
    }

    protected String getMultipleNodeSeparator() {
        return "";
    }

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract Logger getInternalLogger();

    public abstract boolean isUseApiCertificatoApplicativoById() throws CoreException;

    public abstract boolean isUseApiCertificatoSoggettoById() throws CoreException;

    public abstract String getJmxResourceType() throws CoreException;

    public abstract String getJmxResourceNomeRisorsaConfigurazionePdD() throws CoreException;

    public abstract String getJmxResourceNomeRisorsaAccessoRegistroServizi() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckConnettoreById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatoApplicativoById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatoModIApplicativoById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatoSoggettoById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiModIErogazioneById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiModIFruizioneById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiMessageSecurityErogazioneById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiMessageSecurityFruizioneById() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiJvm() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsTokenPolicyValidazione() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiValidazioneJwtTokenPolicyValidazione() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiForwardToJwtTokenPolicyValidazione() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsTokenPolicyNegoziazione() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiSignedJwtTokenPolicyNegoziazione() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiDpopJwtTokenPolicyNegoziazione() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsAttributeAuthority() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiAttributeAuthorityJwtRichiesta() throws CoreException;

    public abstract String getJmxResourceNomeMetodoCheckCertificatiAttributeAuthorityJwtRisposta() throws CoreException;

    protected AbstractConfigChecker(InvokerNodiRuntime invoker, ConfigurazioneNodiRuntime config, List<String> nodiRuntime) {
        this.invoker = invoker;
        this.config = config;
        this.nodiRuntime = nodiRuntime;
    }

    public void checkApplicativo(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean ssl, boolean sicurezzaModi, boolean connettoreHttps, ServizioApplicativo servizioApplicativo, int sogliaWarningGiorni) throws CoreException {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarning = new StringBuilder();
        StringBuilder sbWarningModi = new StringBuilder();
        StringBuilder sbWarningConnettore = new StringBuilder();
        if (ssl) {
            this.checkCertificate(sbError, sbWarning, sogliaWarningGiorni, servizioApplicativo);
        }
        if (sbError.length() <= 0 && sicurezzaModi) {
            this.checkCertificateModI(sbError, sbWarningModi, sogliaWarningGiorni, servizioApplicativo);
        }
        if (sbError.length() <= 0 && connettoreHttps) {
            org.openspcoop2.core.config.Connettore connettore = null;
            if (servizioApplicativo.getInvocazioneServizio() != null) {
                connettore = servizioApplicativo.getInvocazioneServizio().getConnettore();
            }
            if (connettore != null) {
                this.checkCertificate(sbError, sbWarningConnettore, sogliaWarningGiorni, connettore);
            }
        }
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarning.length() > 0) {
            sbDetailsWarning.append(sbWarning.toString());
        } else if (sbWarningModi.length() > 0) {
            sbDetailsWarning.append(sbWarningModi.toString());
        } else if (sbWarningConnettore.length() > 0) {
            sbDetailsWarning.append(sbWarningConnettore.toString());
        }
    }

    public void checkSoggetto(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean ssl, Soggetto soggetto, int sogliaWarningGiorni) throws CoreException {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarning = new StringBuilder();
        if (ssl) {
            this.checkCertificate(sbError, sbWarning, sogliaWarningGiorni, soggetto);
        }
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarning.length() > 0) {
            sbDetailsWarning.append(sbWarning.toString());
        }
    }

    public void checkErogazione(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean connettoreSsl, org.openspcoop2.core.config.Connettore connettore, boolean sicurezzaModi, boolean messageSecurity, AccordoServizioParteSpecifica asps, int sogliaWarningGiorni) throws CoreException {
        ArrayList<org.openspcoop2.core.config.Connettore> connettori = null;
        if (connettore != null) {
            connettori = new ArrayList<org.openspcoop2.core.config.Connettore>();
            connettori.add(connettore);
        }
        this.checkErogazione(sbDetailsError, sbDetailsWarning, connettoreSsl, connettori, sicurezzaModi, messageSecurity, asps, sogliaWarningGiorni);
    }

    public void checkErogazione(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean connettoreSsl, List<org.openspcoop2.core.config.Connettore> connettori, boolean sicurezzaModi, boolean messageSecurity, AccordoServizioParteSpecifica asps, int sogliaWarningGiorni) throws CoreException {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarning = new StringBuilder();
        StringBuilder sbWarningModi = new StringBuilder();
        StringBuilder sbWarningSicurezzaMessaggio = new StringBuilder();
        if (connettoreSsl && connettori != null && !connettori.isEmpty()) {
            for (org.openspcoop2.core.config.Connettore connettore : connettori) {
                StringBuilder sbWarningConnettore = new StringBuilder();
                if (sbError.length() <= 0) {
                    this.checkCertificate(sbError, sbWarningConnettore, sogliaWarningGiorni, connettore);
                }
                if (sbWarning.length() > 0 || sbWarningConnettore.length() <= 0) continue;
                sbWarning.append(sbWarningConnettore.toString());
            }
        }
        if (sbError.length() <= 0 && sicurezzaModi) {
            this.checkCertificateModI(sbError, sbWarningModi, sogliaWarningGiorni, asps);
        }
        if (sbError.length() <= 0 && messageSecurity) {
            this.checkCertificateMessageSecurity(sbError, sbWarningSicurezzaMessaggio, sogliaWarningGiorni, asps);
        }
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarning.length() > 0) {
            sbDetailsWarning.append(sbWarning.toString());
        } else if (sbWarningModi.length() > 0) {
            sbDetailsWarning.append(sbWarningModi.toString());
        } else if (sbWarningSicurezzaMessaggio.length() > 0) {
            sbDetailsWarning.append(sbWarningSicurezzaMessaggio.toString());
        }
    }

    public void checkFruizione(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean connettoreSsl, Connettore connettore, boolean sicurezzaModi, boolean messageSecurity, AccordoServizioParteSpecifica asps, Fruitore fruitore, int sogliaWarningGiorni) throws CoreException {
        ArrayList<Connettore> connettori = null;
        if (connettore != null) {
            connettori = new ArrayList<Connettore>();
            connettori.add(connettore);
        }
        this.checkFruizione(sbDetailsError, sbDetailsWarning, connettoreSsl, connettori, sicurezzaModi, messageSecurity, asps, fruitore, sogliaWarningGiorni);
    }

    public void checkFruizione(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean connettoreSsl, List<Connettore> connettori, boolean sicurezzaModi, boolean messageSecurity, AccordoServizioParteSpecifica asps, Fruitore fruitore, int sogliaWarningGiorni) throws CoreException {
        if (asps != null) {
            // empty if block
        }
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarning = new StringBuilder();
        StringBuilder sbWarningModi = new StringBuilder();
        StringBuilder sbWarningSicurezzaMessaggio = new StringBuilder();
        if (connettoreSsl && connettori != null && !connettori.isEmpty()) {
            for (Connettore connettore : connettori) {
                StringBuilder sbWarningConnettore = new StringBuilder();
                if (sbError.length() <= 0) {
                    this.checkCertificate(sbError, sbWarningConnettore, sogliaWarningGiorni, connettore);
                }
                if (sbWarning.length() > 0 || sbWarningConnettore.length() <= 0) continue;
                sbWarning.append(sbWarningConnettore.toString());
            }
        }
        if (sbError.length() <= 0 && sicurezzaModi) {
            this.checkCertificateModI(sbError, sbWarningModi, sogliaWarningGiorni, fruitore);
        }
        if (sbError.length() <= 0 && messageSecurity) {
            this.checkCertificateMessageSecurity(sbError, sbWarningSicurezzaMessaggio, sogliaWarningGiorni, fruitore);
        }
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarning.length() > 0) {
            sbDetailsWarning.append(sbWarning.toString());
        } else if (sbWarningModi.length() > 0) {
            sbDetailsWarning.append(sbWarningModi.toString());
        } else if (sbWarningSicurezzaMessaggio.length() > 0) {
            sbDetailsWarning.append(sbWarningSicurezzaMessaggio.toString());
        }
    }

    public void checkConfigurazioneJvm(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, int sogliaWarningGiorni) throws CoreException {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarning = new StringBuilder();
        this.checkCertificate(sbError, sbWarning, sogliaWarningGiorni, new Configurazione());
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarning.length() > 0) {
            sbDetailsWarning.append(sbWarning.toString());
        }
    }

    public void checkTokenPolicyValidazione(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean httpsDynamicDiscovery, boolean httpsValidazioneJWT, boolean httpsIntrospection, boolean httpsUserInfo, boolean validazioneJwt, boolean forwardToJwt, GenericProperties gp, int sogliaWarningGiorni) throws CoreException {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarningDynamicDiscovery = new StringBuilder();
        StringBuilder sbWarningValidazioneJwtHttps = new StringBuilder();
        StringBuilder sbWarningIntrospection = new StringBuilder();
        StringBuilder sbWarningUserInfo = new StringBuilder();
        StringBuilder sbWarningValidazioneJwt = new StringBuilder();
        StringBuilder sbWarningForwardToJwt = new StringBuilder();
        if (httpsDynamicDiscovery) {
            this.checkCertificateGenericProperties(sbError, sbWarningDynamicDiscovery, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsTokenPolicyValidazione(), gp.getNome(), "DynamicDiscovery");
        }
        if (sbError.length() <= 0 && httpsValidazioneJWT) {
            this.checkCertificateGenericProperties(sbError, sbWarningValidazioneJwtHttps, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsTokenPolicyValidazione(), gp.getNome(), "ValidazioneJWT");
        }
        if (sbError.length() <= 0 && httpsIntrospection) {
            this.checkCertificateGenericProperties(sbError, sbWarningIntrospection, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsTokenPolicyValidazione(), gp.getNome(), "Introspection");
        }
        if (sbError.length() <= 0 && httpsUserInfo) {
            this.checkCertificateGenericProperties(sbError, sbWarningUserInfo, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsTokenPolicyValidazione(), gp.getNome(), "UserInfo");
        }
        if (sbError.length() <= 0 && validazioneJwt) {
            this.checkCertificateGenericProperties(sbError, sbWarningValidazioneJwt, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiValidazioneJwtTokenPolicyValidazione(), gp.getNome());
        }
        if (sbError.length() <= 0 && forwardToJwt) {
            this.checkCertificateGenericProperties(sbError, sbWarningForwardToJwt, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiForwardToJwtTokenPolicyValidazione(), gp.getNome());
        }
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarningDynamicDiscovery.length() > 0) {
            sbDetailsWarning.append(sbWarningDynamicDiscovery.toString());
        } else if (sbWarningValidazioneJwtHttps.length() > 0) {
            sbDetailsWarning.append(sbWarningValidazioneJwtHttps.toString());
        } else if (sbWarningIntrospection.length() > 0) {
            sbDetailsWarning.append(sbWarningIntrospection.toString());
        } else if (sbWarningUserInfo.length() > 0) {
            sbDetailsWarning.append(sbWarningUserInfo.toString());
        } else if (sbWarningValidazioneJwt.length() > 0) {
            sbDetailsWarning.append(sbWarningValidazioneJwt.toString());
        } else if (sbWarningForwardToJwt.length() > 0) {
            sbDetailsWarning.append(sbWarningForwardToJwt.toString());
        }
    }

    public void checkTokenPolicyNegoziazione(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean https, boolean signedJwt, boolean dpopJwt, GenericProperties gp, int sogliaWarningGiorni) throws CoreException {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarning = new StringBuilder();
        StringBuilder sbWarningSignedJwt = new StringBuilder();
        StringBuilder sbWarningDpopJwt = new StringBuilder();
        if (https) {
            this.checkCertificateGenericProperties(sbError, sbWarning, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsTokenPolicyNegoziazione(), gp.getNome());
        }
        if (sbError.length() <= 0 && signedJwt) {
            this.checkCertificateGenericProperties(sbError, sbWarningSignedJwt, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiSignedJwtTokenPolicyNegoziazione(), gp.getNome());
        }
        if (sbError.length() <= 0 && dpopJwt) {
            this.checkCertificateGenericProperties(sbError, sbWarningDpopJwt, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiDpopJwtTokenPolicyNegoziazione(), gp.getNome());
        }
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarning.length() > 0) {
            sbDetailsWarning.append(sbWarning.toString());
        } else if (sbWarningSignedJwt.length() > 0) {
            sbDetailsWarning.append(sbWarningSignedJwt.toString());
        } else if (sbWarningDpopJwt.length() > 0) {
            sbDetailsWarning.append(sbWarningDpopJwt.toString());
        }
    }

    public void checkAttributeAuthority(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, boolean https, boolean jwtRichiesta, boolean jwtRisposta, GenericProperties gp, int sogliaWarningGiorni) throws CoreException {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarning = new StringBuilder();
        StringBuilder sbWarningJwtRichiesta = new StringBuilder();
        StringBuilder sbWarningJwtRisposta = new StringBuilder();
        if (https) {
            this.checkCertificateGenericProperties(sbError, sbWarning, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsAttributeAuthority(), gp.getNome());
        }
        if (sbError.length() <= 0 && jwtRichiesta) {
            this.checkCertificateGenericProperties(sbError, sbWarningJwtRichiesta, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiAttributeAuthorityJwtRichiesta(), gp.getNome());
        }
        if (sbError.length() <= 0 && jwtRisposta) {
            this.checkCertificateGenericProperties(sbError, sbWarningJwtRisposta, sogliaWarningGiorni, this.getJmxResourceNomeMetodoCheckCertificatiAttributeAuthorityJwtRisposta(), gp.getNome());
        }
        if (sbError.length() > 0) {
            sbDetailsError.append(sbError.toString());
        } else if (sbWarning.length() > 0) {
            sbDetailsWarning.append(sbWarning.toString());
        } else if (sbWarningJwtRichiesta.length() > 0) {
            sbDetailsWarning.append(sbWarningJwtRichiesta.toString());
        } else if (sbWarningJwtRisposta.length() > 0) {
            sbDetailsWarning.append(sbWarningJwtRisposta.toString());
        }
    }

    private void checkCertificate(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, int sogliaWarningGiorni, Object o) throws CoreException {
        String risorsa = null;
        String metodo = null;
        boolean useApi = false;
        boolean applicativo = false;
        boolean soggetto = false;
        boolean connettoreErogazione = false;
        boolean connettoreFruizione = false;
        long idObject = -1L;
        boolean withId = true;
        if (o instanceof ServizioApplicativo) {
            applicativo = true;
        } else if (o instanceof Soggetto) {
            soggetto = true;
        } else if (o instanceof org.openspcoop2.core.config.Connettore) {
            connettoreErogazione = true;
        } else if (o instanceof Connettore) {
            connettoreFruizione = true;
        } else if (o instanceof Configurazione) {
            risorsa = this.getJmxResourceNomeRisorsaConfigurazionePdD();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatiJvm();
            withId = false;
        } else {
            throw new CoreException(AbstractConfigChecker.getErrorMessageClasseNonGestita(o));
        }
        if (applicativo) {
            idObject = ((ServizioApplicativo)o).getId();
            useApi = this.isUseApiCertificatoApplicativoById();
            if (!useApi) {
                risorsa = this.getJmxResourceNomeRisorsaConfigurazionePdD();
                metodo = this.getJmxResourceNomeMetodoCheckCertificatoApplicativoById();
            }
        } else if (soggetto) {
            idObject = ((Soggetto)o).getId();
            useApi = this.isUseApiCertificatoSoggettoById();
            if (!useApi) {
                risorsa = this.getJmxResourceNomeRisorsaAccessoRegistroServizi();
                metodo = this.getJmxResourceNomeMetodoCheckCertificatoSoggettoById();
            }
        } else if (connettoreErogazione) {
            idObject = ((org.openspcoop2.core.config.Connettore)o).getId();
            risorsa = this.getJmxResourceNomeRisorsaConfigurazionePdD();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsById();
        } else if (connettoreFruizione) {
            idObject = ((Connettore)o).getId();
            risorsa = this.getJmxResourceNomeRisorsaAccessoRegistroServizi();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatiConnettoreHttpsById();
        }
        HashMap<String, List<String>> mapErrori = new HashMap<String, List<String>>();
        HashMap<String, List<String>> mapWarning = new HashMap<String, List<String>>();
        String error = StatoCheck.ERROR.toString();
        String warn = StatoCheck.WARN.toString();
        String ok = StatoCheck.OK.toString();
        ArrayList<String> nodiRuntimeEsaminati = new ArrayList<String>();
        if (useApi) {
            nodiRuntimeEsaminati.add("SDK");
        } else {
            nodiRuntimeEsaminati.addAll(this.nodiRuntime);
        }
        for (String nomeNodoRuntime : nodiRuntimeEsaminati) {
            Object stato = null;
            String descrizione = null;
            Object errorDetail = null;
            String warnDetail = null;
            try {
                if (useApi) {
                    boolean addCertificateDetails = true;
                    String separator = ": ";
                    String newLine = "\n";
                    try {
                        CertificateCheck statoCheck = null;
                        if (applicativo) {
                            statoCheck = ConfigurazionePdDReader.checkCertificatoApplicativo((ServizioApplicativo)o, sogliaWarningGiorni, addCertificateDetails, separator, newLine, this.getInternalLogger());
                        } else if (soggetto) {
                            statoCheck = RegistroServiziReader.checkCertificatoSoggetto((Soggetto)((Soggetto)o), (int)sogliaWarningGiorni, (boolean)addCertificateDetails, (String)separator, (String)newLine, (Logger)this.getInternalLogger());
                        } else {
                            throw new CoreException("Incorrect invocation: (useApi:" + useApi + " applicativo:" + applicativo + " soggetto:" + soggetto + ")");
                        }
                        stato = statoCheck.toString(newLine);
                    }
                    catch (Exception e) {
                        stato = "Operazione non riuscita: " + e.getMessage();
                    }
                } else {
                    if (this.config.containsNode(nomeNodoRuntime)) {
                        descrizione = this.config.getDescrizione(nomeNodoRuntime);
                    }
                    stato = withId ? this.invoker.invokeJMXMethod(nomeNodoRuntime, this.getJmxResourceType(), risorsa, metodo, idObject, sogliaWarningGiorni) : this.invoker.invokeJMXMethod(nomeNodoRuntime, this.getJmxResourceType(), risorsa, metodo, sogliaWarningGiorni);
                }
                if (stato != null && ((String)stato).equals(error)) {
                    errorDetail = stato;
                } else if (stato != null && ((String)stato).startsWith(error + "\n")) {
                    errorDetail = ((String)stato).substring((error + "\n").length());
                } else if (stato != null && ((String)stato).equals(warn)) {
                    warnDetail = warn;
                } else if (stato != null && ((String)stato).startsWith(warn + "\n")) {
                    warnDetail = ((String)stato).substring((warn + "\n").length());
                } else if (stato == null || !((String)stato).startsWith(ok)) {
                    errorDetail = stato;
                }
            }
            catch (Exception e) {
                this.error(AbstractConfigChecker.getErrorMessage(risorsa, nomeNodoRuntime, e), e);
                errorDetail = stato = e.getMessage();
            }
            if (errorDetail != null) {
                AbstractConfigChecker.addErrore(mapErrori, (String)errorDetail, descrizione != null ? descrizione : nomeNodoRuntime);
                continue;
            }
            if (warnDetail == null) continue;
            AbstractConfigChecker.addErrore(mapWarning, warnDetail, descrizione != null ? descrizione : nomeNodoRuntime);
        }
        if (!mapErrori.isEmpty()) {
            AbstractConfigChecker.printErrore(mapErrori, sbDetailsError, nodiRuntimeEsaminati.size(), this.getMultipleNodeSeparator());
        } else if (!mapWarning.isEmpty()) {
            AbstractConfigChecker.printErrore(mapWarning, sbDetailsWarning, nodiRuntimeEsaminati.size(), this.getMultipleNodeSeparator());
        }
    }

    private void checkCertificateModI(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, int sogliaWarningGiorni, Object o) throws CoreException {
        String risorsa = null;
        String metodo = null;
        boolean applicativo = false;
        boolean erogazione = false;
        boolean fruizione = false;
        long idObject = -1L;
        if (o instanceof ServizioApplicativo) {
            applicativo = true;
        } else if (o instanceof AccordoServizioParteSpecifica) {
            erogazione = true;
        } else if (o instanceof Fruitore) {
            fruizione = true;
        } else {
            throw new CoreException(AbstractConfigChecker.getErrorMessageClasseNonGestita(o));
        }
        if (applicativo) {
            idObject = ((ServizioApplicativo)o).getId();
            risorsa = this.getJmxResourceNomeRisorsaConfigurazionePdD();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatoModIApplicativoById();
        } else if (erogazione) {
            idObject = ((AccordoServizioParteSpecifica)o).getId();
            risorsa = this.getJmxResourceNomeRisorsaAccessoRegistroServizi();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatiModIErogazioneById();
        } else if (fruizione) {
            idObject = ((Fruitore)o).getId();
            risorsa = this.getJmxResourceNomeRisorsaAccessoRegistroServizi();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatiModIFruizioneById();
        }
        HashMap<String, List<String>> mapErrori = new HashMap<String, List<String>>();
        HashMap<String, List<String>> mapWarning = new HashMap<String, List<String>>();
        String error = StatoCheck.ERROR.toString();
        String warn = StatoCheck.WARN.toString();
        String ok = StatoCheck.OK.toString();
        for (String nomeNodoRuntime : this.nodiRuntime) {
            String stato = null;
            String descrizione = null;
            String errorDetail = null;
            String warnDetail = null;
            try {
                if (this.config.containsNode(nomeNodoRuntime)) {
                    descrizione = this.config.getDescrizione(nomeNodoRuntime);
                }
                if ((stato = this.invoker.invokeJMXMethod(nomeNodoRuntime, this.getJmxResourceType(), risorsa, metodo, idObject, sogliaWarningGiorni)) != null && stato.equals(error)) {
                    errorDetail = stato;
                } else if (stato != null && stato.startsWith(error + "\n")) {
                    errorDetail = stato.substring((error + "\n").length());
                } else if (stato != null && stato.equals(warn)) {
                    warnDetail = warn;
                } else if (stato != null && stato.startsWith(warn + "\n")) {
                    warnDetail = stato.substring((warn + "\n").length());
                } else if (stato == null || !stato.startsWith(ok)) {
                    errorDetail = stato;
                }
            }
            catch (Exception e) {
                this.error(AbstractConfigChecker.getErrorMessage(risorsa, nomeNodoRuntime, e), e);
                errorDetail = stato = e.getMessage();
            }
            if (errorDetail != null) {
                AbstractConfigChecker.addErrore(mapErrori, errorDetail, descrizione != null ? descrizione : nomeNodoRuntime);
                continue;
            }
            if (warnDetail == null) continue;
            AbstractConfigChecker.addErrore(mapWarning, warnDetail, descrizione != null ? descrizione : nomeNodoRuntime);
        }
        if (!mapErrori.isEmpty()) {
            AbstractConfigChecker.printErrore(mapErrori, sbDetailsError, this.nodiRuntime.size(), this.getMultipleNodeSeparator());
        } else if (!mapWarning.isEmpty()) {
            AbstractConfigChecker.printErrore(mapWarning, sbDetailsWarning, this.nodiRuntime.size(), this.getMultipleNodeSeparator());
        }
    }

    private void checkCertificateMessageSecurity(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, int sogliaWarningGiorni, Object o) throws CoreException {
        String risorsa = null;
        String metodo = null;
        boolean erogazione = false;
        boolean fruizione = false;
        long idObject = -1L;
        if (o instanceof AccordoServizioParteSpecifica) {
            erogazione = true;
        } else if (o instanceof Fruitore) {
            fruizione = true;
        } else {
            throw new CoreException(AbstractConfigChecker.getErrorMessageClasseNonGestita(o));
        }
        if (erogazione) {
            idObject = ((AccordoServizioParteSpecifica)o).getId();
            risorsa = this.getJmxResourceNomeRisorsaConfigurazionePdD();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatiMessageSecurityErogazioneById();
        } else if (fruizione) {
            idObject = ((Fruitore)o).getId();
            risorsa = this.getJmxResourceNomeRisorsaConfigurazionePdD();
            metodo = this.getJmxResourceNomeMetodoCheckCertificatiMessageSecurityFruizioneById();
        }
        HashMap<String, List<String>> mapErrori = new HashMap<String, List<String>>();
        HashMap<String, List<String>> mapWarning = new HashMap<String, List<String>>();
        String error = StatoCheck.ERROR.toString();
        String warn = StatoCheck.WARN.toString();
        String ok = StatoCheck.OK.toString();
        for (String nomeNodoRuntime : this.nodiRuntime) {
            String stato = null;
            String descrizione = null;
            String errorDetail = null;
            String warnDetail = null;
            try {
                if (this.config.containsNode(nomeNodoRuntime)) {
                    descrizione = this.config.getDescrizione(nomeNodoRuntime);
                }
                if ((stato = this.invoker.invokeJMXMethod(nomeNodoRuntime, this.getJmxResourceType(), risorsa, metodo, idObject, sogliaWarningGiorni)) != null && stato.equals(error)) {
                    errorDetail = stato;
                } else if (stato != null && stato.startsWith(error + "\n")) {
                    errorDetail = stato.substring((error + "\n").length());
                } else if (stato != null && stato.equals(warn)) {
                    warnDetail = warn;
                } else if (stato != null && stato.startsWith(warn + "\n")) {
                    warnDetail = stato.substring((warn + "\n").length());
                } else if (stato == null || !stato.startsWith(ok)) {
                    errorDetail = stato;
                }
            }
            catch (Exception e) {
                this.error(AbstractConfigChecker.getErrorMessage(risorsa, nomeNodoRuntime, e), e);
                errorDetail = stato = e.getMessage();
            }
            if (errorDetail != null) {
                AbstractConfigChecker.addErrore(mapErrori, errorDetail, descrizione != null ? descrizione : nomeNodoRuntime);
                continue;
            }
            if (warnDetail == null) continue;
            AbstractConfigChecker.addErrore(mapWarning, warnDetail, descrizione != null ? descrizione : nomeNodoRuntime);
        }
        if (!mapErrori.isEmpty()) {
            AbstractConfigChecker.printErrore(mapErrori, sbDetailsError, this.nodiRuntime.size(), this.getMultipleNodeSeparator());
        } else if (!mapWarning.isEmpty()) {
            AbstractConfigChecker.printErrore(mapWarning, sbDetailsWarning, this.nodiRuntime.size(), this.getMultipleNodeSeparator());
        }
    }

    private void checkCertificateGenericProperties(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, int sogliaWarningGiorni, String metodo, String nomePolicy) throws CoreException {
        this.checkCertificateGenericProperties(sbDetailsError, sbDetailsWarning, sogliaWarningGiorni, metodo, nomePolicy, null);
    }

    private void checkCertificateGenericProperties(StringBuilder sbDetailsError, StringBuilder sbDetailsWarning, int sogliaWarningGiorni, String metodo, String nomePolicy, String tipo) throws CoreException {
        String risorsa = this.getJmxResourceNomeRisorsaConfigurazionePdD();
        HashMap<String, List<String>> mapErrori = new HashMap<String, List<String>>();
        HashMap<String, List<String>> mapWarning = new HashMap<String, List<String>>();
        String error = StatoCheck.ERROR.toString();
        String warn = StatoCheck.WARN.toString();
        String ok = StatoCheck.OK.toString();
        for (String nomeNodoRuntime : this.nodiRuntime) {
            String stato = null;
            String descrizione = null;
            String errorDetail = null;
            String warnDetail = null;
            try {
                if (this.config.containsNode(nomeNodoRuntime)) {
                    descrizione = this.config.getDescrizione(nomeNodoRuntime);
                }
                if ((stato = tipo != null ? this.invoker.invokeJMXMethod(nomeNodoRuntime, this.getJmxResourceType(), risorsa, metodo, nomePolicy, tipo, sogliaWarningGiorni) : this.invoker.invokeJMXMethod(nomeNodoRuntime, this.getJmxResourceType(), risorsa, metodo, nomePolicy, sogliaWarningGiorni)) != null && stato.equals(error)) {
                    errorDetail = stato;
                } else if (stato != null && stato.startsWith(error + "\n")) {
                    errorDetail = stato.substring((error + "\n").length());
                } else if (stato != null && stato.equals(warn)) {
                    warnDetail = warn;
                } else if (stato != null && stato.startsWith(warn + "\n")) {
                    warnDetail = stato.substring((warn + "\n").length());
                } else if (stato == null || !stato.startsWith(ok)) {
                    errorDetail = stato;
                }
            }
            catch (Exception e) {
                this.error(AbstractConfigChecker.getErrorMessage(risorsa, nomeNodoRuntime, e), e);
                errorDetail = stato = e.getMessage();
            }
            if (errorDetail != null) {
                AbstractConfigChecker.addErrore(mapErrori, errorDetail, descrizione != null ? descrizione : nomeNodoRuntime);
                continue;
            }
            if (warnDetail == null) continue;
            AbstractConfigChecker.addErrore(mapWarning, warnDetail, descrizione != null ? descrizione : nomeNodoRuntime);
        }
        if (!mapErrori.isEmpty()) {
            AbstractConfigChecker.printErrore(mapErrori, sbDetailsError, this.nodiRuntime.size(), this.getMultipleNodeSeparator());
        } else if (!mapWarning.isEmpty()) {
            AbstractConfigChecker.printErrore(mapWarning, sbDetailsWarning, this.nodiRuntime.size(), this.getMultipleNodeSeparator());
        }
    }
}

