/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyShutdownException;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.GestoreControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.policy.GestoreCacheControlloTraffico;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttive;
import org.openspcoop2.pdd.core.jmx.JMXUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.slf4j.Logger;

public class ControlloTraffico
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private String statoControlloMaxThreads;
    public long maxThreads = 0L;
    public long activeThreads = 0L;
    public boolean pddCongestionata = false;
    public boolean cacheAbilitata = false;
    private Logger log;
    private GestoreControlloTraffico gestoreControlloTraffico;

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this._getAttribute(attributeName, true);
    }

    public Object _getAttribute(String attributeName, boolean refresh) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (refresh) {
            this.refreshDati();
        }
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals("statoControlloNumeroRichiesteComplessiveGestibiliPdD")) {
            return this.statoControlloMaxThreads;
        }
        if (attributeName.equals("numeroRichiesteComplessiveGestibiliPdD")) {
            return this.maxThreads;
        }
        if (attributeName.equals("threadsAttivi")) {
            return this.activeThreads;
        }
        if (attributeName.equals("portaDominioCongestionata")) {
            return this.pddCongestionata;
        }
        if (attributeName.equals("cacheAbilitata")) {
            return this.cacheAbilitata;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        try {
            this.refreshDati();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this._getAttribute(attributesNames[i], false)));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block11: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals("statoControlloNumeroRichiesteComplessiveGestibiliPdD")) {
                    this.statoControlloMaxThreads = (String)attribute.getValue();
                }
                if (attribute.getName().equals("numeroRichiesteComplessiveGestibiliPdD")) {
                    this.maxThreads = (Long)attribute.getValue();
                }
                if (attribute.getName().equals("threadsAttivi")) {
                    this.activeThreads = (Long)attribute.getValue();
                }
                if (attribute.getName().equals("portaDominioCongestionata")) {
                    this.pddCongestionata = (Boolean)attribute.getValue();
                }
                if (attribute.getName().equals("cacheAbilitata")) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v) {
                        this.abilitaCache();
                    } else {
                        this.disabilitaCache();
                    }
                    break block11;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + String.valueOf(attribute.getValue().getClass()) + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals("getAllIdPolicies")) {
            return this.getAllIdPolicy();
        }
        if (actionName.equals("getPolicy")) {
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getStatoPolicy(param1);
        }
        if (actionName.equals("removeAllPolicies")) {
            return this.removeAllPolicies();
        }
        if (actionName.equals("resetAllPoliciesCounters")) {
            return this.resetAllPolicies();
        }
        if (actionName.equals("removePolicy")) {
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removePolicy(param1);
        }
        if (actionName.equals("resetPolicyCounters")) {
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.resetPolicy(param1);
        }
        if (actionName.equals("resetCache")) {
            return this.resetCache();
        }
        if (actionName.equals("printStatsCache")) {
            return this.printStatCache();
        }
        if (actionName.equals("disabilitaCache")) {
            return this.disabilitaCacheConEsito();
        }
        if (actionName.equals("abilitaCache")) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[AbilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = (Long)params[0]) < 0L) {
                param1 = null;
            }
            Boolean param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (Boolean)params[1];
            }
            Long param3 = null;
            if (params[2] != null && !"".equals(params[2]) && (param3 = (Long)params[2]) < 0L) {
                param3 = null;
            }
            Long param4 = null;
            if (params[3] != null && !"".equals(params[3]) && (param4 = (Long)params[3]) < 0L) {
                param4 = null;
            }
            return this.abilitaCache(param1, param2, param3, param4);
        }
        if (actionName.equals("listKeysCache")) {
            return this.listKeysCache();
        }
        if (actionName.equals("getObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getObjectCache(param1);
        }
        if (actionName.equals("removeObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeObjectCache(param1);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Risorsa per la gestione del Controllo del Traffico (" + OpenSPCoop2Properties.getInstance().getVersione() + ")";
        MBeanAttributeInfo maxThreadsStatoVAR = new MBeanAttributeInfo("statoControlloNumeroRichiesteComplessiveGestibiliPdD", String.class.getName(), "Stato del controllo sul numero massimo di threads attivi", true, false, false);
        MBeanAttributeInfo maxThreadsSogliaVAR = new MBeanAttributeInfo("numeroRichiesteComplessiveGestibiliPdD", Long.TYPE.getName(), "Numero massimo di threads attivi", true, false, false);
        MBeanAttributeInfo activeThreadsVAR = new MBeanAttributeInfo("threadsAttivi", Long.TYPE.getName(), "Numero di threads attivi", true, false, false);
        MBeanAttributeInfo pddCongestionataVAR = new MBeanAttributeInfo("portaDominioCongestionata", Boolean.TYPE.getName(), "Indicazione se la PdD risulta congestionata dalle richieste", true, false, false);
        MBeanAttributeInfo cacheAbilitataVAR = JMXUtils.MBEAN_ATTRIBUTE_INFO_CACHE_ABILITATA;
        MBeanOperationInfo getAllIdPolicyOP = new MBeanOperationInfo("getAllIdPolicies", "Ritorna gli identificativi delle policy attivate tramite Rate Limiting", null, String.class.getName(), 1);
        MBeanOperationInfo getStatoPolicyOP = new MBeanOperationInfo("getPolicy", "Ritorna lo stato della policy identificata dal parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "identificativo della policy")}, String.class.getName(), 1);
        MBeanOperationInfo removeAllPoliciesOP = new MBeanOperationInfo("removeAllPolicies", "Elimina le istanza attive di tutte le policy", null, String.class.getName(), 1);
        MBeanOperationInfo removePolicyOP = new MBeanOperationInfo("removePolicy", "Elimina l'istanza attiva della policy di Rate Limiting identificata dal parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "identificativo della policy")}, String.class.getName(), 1);
        MBeanOperationInfo resetAllPoliciesOP = new MBeanOperationInfo("resetAllPoliciesCounters", "Effettua i reset dei contatori di tutte le policy attivate tramite Rate Limiting", null, String.class.getName(), 1);
        MBeanOperationInfo resetPolicyOP = new MBeanOperationInfo("resetPolicyCounters", "Effettua i reset dei contatori presenti nella policy di Rate Limiting identificata dal parametro", new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "identificativo della policy")}, String.class.getName(), 1);
        MBeanOperationInfo resetCacheOP = JMXUtils.MBEAN_OPERATION_RESET_CACHE;
        MBeanOperationInfo printStatCacheOP = JMXUtils.MBEAN_OPERATION_PRINT_STATS_CACHE;
        MBeanOperationInfo disabilitaCacheOP = JMXUtils.MBEAN_OPERATION_DISABILITA_CACHE;
        MBeanOperationInfo abilitaCacheParametriOP = JMXUtils.MBEAN_OPERATION_ABILITA_CACHE_CON_PARAMETRI;
        MBeanOperationInfo listKeysCacheOP = JMXUtils.MBEAN_OPERATION_LIST_KEYS_CACHE;
        MBeanOperationInfo getObjectCacheOP = JMXUtils.MBEAN_OPERATION_GET_OBJECT_CACHE;
        MBeanOperationInfo removeObjectCacheOP = JMXUtils.MBEAN_OPERATION_REMOVE_OBJECT_CACHE;
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{maxThreadsStatoVAR, maxThreadsSogliaVAR, activeThreadsVAR, pddCongestionataVAR, cacheAbilitataVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{getAllIdPolicyOP, getStatoPolicyOP, removeAllPoliciesOP, removePolicyOP, resetAllPoliciesOP, resetPolicyOP, resetCacheOP, printStatCacheOP, disabilitaCacheOP, abilitaCacheParametriOP, listKeysCacheOP, getObjectCacheOP, removeObjectCacheOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public ControlloTraffico() throws Exception {
        boolean force = true;
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(force);
        this.refreshDati();
        this.cacheAbilitata = GestoreCacheControlloTraffico.isCacheAbilitata();
    }

    private void refreshDati() throws MBeanException {
        ConfigurazioneGenerale configurazioneGenerale = null;
        try {
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance();
            configurazioneGenerale = configPdDManager.getConfigurazioneControlloTraffico(null);
            this.statoControlloMaxThreads = configurazioneGenerale.getControlloTraffico().isControlloMaxThreadsEnabled() ? (configurazioneGenerale.getControlloTraffico().isControlloMaxThreadsWarningOnly() ? CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.getValue() : CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.getValue()) : CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.getValue();
            this.maxThreads = configurazioneGenerale.getControlloTraffico().getControlloMaxThreadsSoglia();
            this.gestoreControlloTraffico = GestoreControlloTraffico.getInstance();
            this.activeThreads = this.gestoreControlloTraffico.sizeActiveThreads();
            this.pddCongestionata = this.gestoreControlloTraffico.isPortaDominioCongestionata(this.maxThreads, configurazioneGenerale.getControlloTraffico().getControlloCongestioneThreshold());
        }
        catch (Exception e) {
            try {
                this.log.error("Configurazione non disponibile: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MBeanException(e, "Configurazione non disponibile: " + e.getMessage());
        }
    }

    public boolean isCacheAbilitata() {
        return this.cacheAbilitata;
    }

    public String getAllIdPolicy() {
        try {
            List<PolicyGroupByActiveThreadsType> tipiGestorePolicyAttivi = GestorePolicyAttive.getTipiGestoriAttivi();
            if (tipiGestorePolicyAttivi == null || tipiGestorePolicyAttivi.isEmpty()) {
                throw new Exception("GestorePolicyAttive non abilitato");
            }
            StringBuilder sb = new StringBuilder();
            for (PolicyGroupByActiveThreadsType type : tipiGestorePolicyAttivi) {
                String p = GestorePolicyAttive.getInstance(type).printKeysPolicy("\n");
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(p);
            }
            return sb.toString();
        }
        catch (PolicyShutdownException notFound) {
            return "GestorePolicyAttive in shutdown; controllare lo stato di GovWay";
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getStatoPolicy(String id) {
        try {
            List<PolicyGroupByActiveThreadsType> tipiGestorePolicyAttivi = GestorePolicyAttive.getTipiGestoriAttivi();
            if (tipiGestorePolicyAttivi == null || tipiGestorePolicyAttivi.isEmpty()) {
                throw new Exception("GestorePolicyAttive non abilitato");
            }
            if (id == null) {
                throw new Exception("Parametro non fornito");
            }
            try {
                HashMap<PolicyGroupByActiveThreadsType, String> infos = new HashMap<PolicyGroupByActiveThreadsType, String>();
                PolicyNotFoundException notFound = null;
                for (PolicyGroupByActiveThreadsType type : tipiGestorePolicyAttivi) {
                    try {
                        infos.put(type, GestorePolicyAttive.getInstance(type).printInfoPolicy(id, "================================================================"));
                    }
                    catch (PolicyNotFoundException notFoundE) {
                        notFound = notFoundE;
                    }
                }
                if (infos.isEmpty()) {
                    if (notFound != null) {
                        throw notFound;
                    }
                    throw new PolicyNotFoundException();
                }
                if (infos.size() == 1) {
                    return (String)infos.get(infos.keySet().iterator().next());
                }
                StringBuilder sb = new StringBuilder();
                for (PolicyGroupByActiveThreadsType policyGroupByActiveThreadsType : infos.keySet()) {
                    if (sb.length() > 0) {
                        sb.append("\n\n");
                    }
                    sb.append("*** Gestore '").append(policyGroupByActiveThreadsType.name()).append("' ***\n");
                    sb.append((String)infos.get(policyGroupByActiveThreadsType));
                }
                return sb.toString();
            }
            catch (PolicyNotFoundException notFound) {
                return "Informazioni sulla Policy non disponibili; non sono ancora transitate richieste che soddisfano i criteri di filtro impostati";
            }
            catch (PolicyShutdownException notFound) {
                return "GestorePolicyAttive in shutdown; controllare lo stato di GovWay";
            }
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeAllPolicies() {
        try {
            List<PolicyGroupByActiveThreadsType> tipiGestorePolicyAttivi = GestorePolicyAttive.getTipiGestoriAttivi();
            if (tipiGestorePolicyAttivi == null || tipiGestorePolicyAttivi.isEmpty()) {
                throw new Exception("GestorePolicyAttive non abilitato");
            }
            for (PolicyGroupByActiveThreadsType type : tipiGestorePolicyAttivi) {
                GestorePolicyAttive.getInstance(type).removeAllActiveThreadsPolicy();
            }
            return "Operazione 'remove' effettuata con successo";
        }
        catch (PolicyShutdownException notFound) {
            return "GestorePolicyAttive in shutdown; controllare lo stato di GovWay";
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String resetAllPolicies() {
        try {
            List<PolicyGroupByActiveThreadsType> tipiGestorePolicyAttivi = GestorePolicyAttive.getTipiGestoriAttivi();
            if (tipiGestorePolicyAttivi == null || tipiGestorePolicyAttivi.isEmpty()) {
                throw new Exception("GestorePolicyAttive non abilitato");
            }
            for (PolicyGroupByActiveThreadsType type : tipiGestorePolicyAttivi) {
                GestorePolicyAttive.getInstance(type).resetCountersAllActiveThreadsPolicy();
            }
            return "Operazione di reset effettuata con successo";
        }
        catch (PolicyShutdownException notFound) {
            return "GestorePolicyAttive in shutdown; controllare lo stato di GovWay";
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removePolicy(String id) {
        try {
            List<PolicyGroupByActiveThreadsType> tipiGestorePolicyAttivi = GestorePolicyAttive.getTipiGestoriAttivi();
            if (tipiGestorePolicyAttivi == null || tipiGestorePolicyAttivi.isEmpty()) {
                throw new Exception("GestorePolicyAttive non abilitato");
            }
            if (id == null) {
                throw new Exception("Parametro non fornito");
            }
            for (PolicyGroupByActiveThreadsType type : tipiGestorePolicyAttivi) {
                GestorePolicyAttive.getInstance(type).removeActiveThreadsPolicy(id);
            }
            return "Operazione 'remove' effettuata con successo";
        }
        catch (PolicyShutdownException notFound) {
            return "GestorePolicyAttive in shutdown; controllare lo stato di GovWay";
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String resetPolicy(String id) {
        try {
            List<PolicyGroupByActiveThreadsType> tipiGestorePolicyAttivi = GestorePolicyAttive.getTipiGestoriAttivi();
            if (tipiGestorePolicyAttivi == null || tipiGestorePolicyAttivi.isEmpty()) {
                throw new Exception("GestorePolicyAttive non abilitato");
            }
            if (id == null) {
                throw new Exception("Parametro non fornito");
            }
            for (PolicyGroupByActiveThreadsType type : tipiGestorePolicyAttivi) {
                GestorePolicyAttive.getInstance(type).resetCountersActiveThreadsPolicy(id);
            }
            return "Operazione di reset effettuata con successo";
        }
        catch (PolicyShutdownException notFound) {
            return "GestorePolicyAttive in shutdown; controllare lo stato di GovWay";
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            GestoreCacheControlloTraffico.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return GestoreCacheControlloTraffico.printStatsCache("\n");
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void abilitaCache() throws JMException {
        try {
            GestoreCacheControlloTraffico.abilitaCache();
            this.cacheAbilitata = true;
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
        }
    }

    public String abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) {
        try {
            GestoreCacheControlloTraffico.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, this.log);
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            GestoreCacheControlloTraffico.disabilitaCache();
            this.cacheAbilitata = false;
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw new JMException(e.getMessage());
        }
    }

    public String disabilitaCacheConEsito() {
        try {
            this.disabilitaCache();
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String listKeysCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return GestoreCacheControlloTraffico.listKeysCache("\n");
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return GestoreCacheControlloTraffico.getObjectCache(key);
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            GestoreCacheControlloTraffico.removeObjectCache(key);
            return "Rimozione elemento dalla cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

