/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.jmx.JMXUtils;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.dpop.jti.LocalJtiCacheManager;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.slf4j.Logger;

public class EngineGestioneToken
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private boolean cacheAbilitata = false;
    private static final String DPOP_JTI_CACHE_METHOD_NAME_LIST_POLICIES = "listDPoPJtiCachePolicies";
    private static final String DPOP_JTI_CACHE_METHOD_NAME_PRINT_STATS = "printStatsDPoPJtiCache";
    private static final String DPOP_JTI_CACHE_METHOD_NAME_PRINT_STATS_ALL = "printStatsDPoPJtiCaches";
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals("cacheAbilitata")) {
            return this.cacheAbilitata;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block9: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals("cacheAbilitata")) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v) {
                        if (!this.cacheAbilitata) {
                            this.abilitaCache();
                        }
                    } else if (this.cacheAbilitata) {
                        this.disabilitaCache();
                    }
                    break block9;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + String.valueOf(attribute.getValue().getClass()) + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals("resetCache")) {
            return this.resetCache();
        }
        if (actionName.equals("printStatsCache")) {
            return this.printStatCache();
        }
        if (actionName.equals("disabilitaCache")) {
            return this.disabilitaCacheConEsito();
        }
        if (actionName.equals("abilitaCache")) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[AbilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = (Long)params[0]) < 0L) {
                param1 = null;
            }
            Boolean param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (Boolean)params[1];
            }
            Long param3 = null;
            if (params[2] != null && !"".equals(params[2]) && (param3 = (Long)params[2]) < 0L) {
                param3 = null;
            }
            Long param4 = null;
            if (params[3] != null && !"".equals(params[3]) && (param4 = (Long)params[3]) < 0L) {
                param4 = null;
            }
            return this.abilitaCache(param1, param2, param3, param4);
        }
        if (actionName.equals("listKeysCache")) {
            return this.listKeysCache();
        }
        if (actionName.equals("getObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getObjectCache(param1);
        }
        if (actionName.equals("removeObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeObjectCache(param1);
        }
        if (actionName.equals(DPOP_JTI_CACHE_METHOD_NAME_LIST_POLICIES)) {
            return this.listDPoPJtiCachePolicies();
        }
        if (actionName.equals(DPOP_JTI_CACHE_METHOD_NAME_PRINT_STATS_ALL)) {
            return this.printStatsDPoPJtiCaches();
        }
        if (actionName.equals(DPOP_JTI_CACHE_METHOD_NAME_PRINT_STATS)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[printStatsDPoPJtiCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.printStatsDPoPJtiCache(param1);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Gestione dei token transitati sul Gateway (" + OpenSPCoop2Properties.getInstance().getVersione() + ")";
        MBeanAttributeInfo cacheAbilitataVAR = JMXUtils.MBEAN_ATTRIBUTE_INFO_CACHE_ABILITATA;
        MBeanOperationInfo resetCacheOP = JMXUtils.MBEAN_OPERATION_RESET_CACHE;
        MBeanOperationInfo printStatCacheOP = JMXUtils.MBEAN_OPERATION_PRINT_STATS_CACHE;
        MBeanOperationInfo disabilitaCacheOP = JMXUtils.MBEAN_OPERATION_DISABILITA_CACHE;
        MBeanOperationInfo abilitaCacheParametriOP = JMXUtils.MBEAN_OPERATION_ABILITA_CACHE_CON_PARAMETRI;
        MBeanOperationInfo listKeysCacheOP = JMXUtils.MBEAN_OPERATION_LIST_KEYS_CACHE;
        MBeanOperationInfo getObjectCacheOP = JMXUtils.MBEAN_OPERATION_GET_OBJECT_CACHE;
        MBeanOperationInfo removeObjectCacheOP = JMXUtils.MBEAN_OPERATION_REMOVE_OBJECT_CACHE;
        MBeanOperationInfo listDPoPJtiCachePoliciesOP = new MBeanOperationInfo(DPOP_JTI_CACHE_METHOD_NAME_LIST_POLICIES, "Lista le policy per cui \u00e8 attiva una cache DPoP JTI", null, String.class.getName(), 1);
        MBeanOperationInfo printStatsDPoPJtiCacheOP = new MBeanOperationInfo(DPOP_JTI_CACHE_METHOD_NAME_PRINT_STATS, "Visualizza statistiche della cache DPoP JTI per una policy specifica", new MBeanParameterInfo[]{new MBeanParameterInfo("policyName", String.class.getName(), "Nome della policy")}, String.class.getName(), 1);
        MBeanOperationInfo printStatsDPoPJtiCachesOP = new MBeanOperationInfo(DPOP_JTI_CACHE_METHOD_NAME_PRINT_STATS_ALL, "Visualizza statistiche di tutte le cache DPoP JTI", null, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{cacheAbilitataVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{resetCacheOP, printStatCacheOP, disabilitaCacheOP, abilitaCacheParametriOP, listKeysCacheOP, getObjectCacheOP, removeObjectCacheOP, listDPoPJtiCachePoliciesOP, printStatsDPoPJtiCacheOP, printStatsDPoPJtiCachesOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    private void logError(String msg, Throwable e) {
        if (this.log != null) {
            this.log.error(msg, e);
        }
    }

    public EngineGestioneToken() {
        this.cacheAbilitata = GestoreToken.isGestioneTokenCacheAbilitata();
    }

    public boolean isCacheAbilitata() {
        return this.cacheAbilitata;
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            GestoreToken.resetGestioneTokenCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return GestoreToken.printStatsGestioneTokenCache("\n");
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String abilitaCache() {
        try {
            GestoreToken.abilitaGestioneTokenCache();
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) {
        try {
            GestoreToken.abilitaGestioneTokenCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            GestoreToken.disabilitaGestioneTokenCache();
            this.cacheAbilitata = false;
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new JMException(e.getMessage());
        }
    }

    public String disabilitaCacheConEsito() {
        try {
            this.disabilitaCache();
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String listKeysCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return GestoreToken.listKeysGestioneTokenCache("\n");
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            return GestoreToken.getObjectGestioneTokenCache(key);
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new CoreException("Cache non abilitata");
            }
            GestoreToken.removeObjectGestioneTokenCache(key);
            return "Rimozione elemento dalla cache effettuata con successo";
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String listDPoPJtiCachePolicies() {
        try {
            return LocalJtiCacheManager.listPolicyNames("\n");
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatsDPoPJtiCache(String policyName) {
        try {
            return LocalJtiCacheManager.printStatsForPolicy(policyName);
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatsDPoPJtiCaches() {
        try {
            return LocalJtiCacheManager.printStatsAllPolicies();
        }
        catch (Exception e) {
            this.logError("Operazione non riuscita: " + e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

