/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.Date;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.openspcoop2.pdd.core.handlers.statistics.StatisticsCollection;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;

public class StatisticsJMXResource
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String INTERVALLO_STATISTICO = "Intervallo Temporale dei dati Statistici";
    public static final String NUMERO_TRANSAZIONI = "Numero transazioni PdD";
    public static final String TXT_NUMERO_TRANSAZIONI = "Numero di transazioni (totale/ok/inErrore) gestite dalla PdD";
    public static final String NUMERO_TRANSAZIONI_PD = "Numero transazioni PortaDelegata";
    public static final String TXT_NUMERO_TRANSAZIONI_PD = "Numero di transazioni (totale/ok/inErrore) gestite sulla PortaDelegata";
    public static final String NUMERO_TRANSAZIONI_PA = "Numero transazioni PortaApplicativa";
    public static final String TXT_NUMERO_TRANSAZIONI_PA = "Numero di transazioni (totale/ok/inErrore) gestite sulla PortaApplicativa";
    public static final String LATENZA_ATTRAVERSAMENTO = "Tempo attraversamento PdD";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO = "Tempo di attraversamento (min/avg/max) della PdD";
    public static final String LATENZA_ATTRAVERSAMENTO_REQUEST = "Tempo attraversamento richieste";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_REQUEST = "Tempo di attraversamento (min/avg/max) della PdD per i messaggi di richiesta";
    public static final String LATENZA_ATTRAVERSAMENTO_RESPONSE = "Tempo attraversamento risposte";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_RESPONSE = "Tempo di attraversamento (min/avg/max) della PdD per i messaggi di risposta";
    public static final String LATENZA_ATTRAVERSAMENTO_PD = "Tempo attraversamento PortaDelegata";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_PD = "Tempo di attraversamento (min/avg/max) della PortaDelegata";
    public static final String LATENZA_ATTRAVERSAMENTO_PD_REQUEST = "Tempo attraversamento richieste sulla PortaDelegata";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_PD_REQUEST = "Tempo di attraversamento (min/avg/max) della PortaDelegata per i messaggi di richiesta";
    public static final String LATENZA_ATTRAVERSAMENTO_PD_RESPONSE = "Tempo attraversamento risposte sulla PortaDelegata";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_PD_RESPONSE = "Tempo di attraversamento (min/avg/max) della PortaDelegata per i messaggi di risposta";
    public static final String LATENZA_ATTRAVERSAMENTO_PA = "Tempo attraversamento PortaApplicativa";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_PA = "Tempo di attraversamento (min/avg/max) della PortaApplicativa";
    public static final String LATENZA_ATTRAVERSAMENTO_PA_REQUEST = "Tempo attraversamento richieste sulla PortaApplicativa";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_PA_REQUEST = "Tempo di attraversamento (min/avg/max) della PortaApplicativa per i messaggi di richiesta";
    public static final String LATENZA_ATTRAVERSAMENTO_PA_RESPONSE = "Tempo attraversamento risposte sulla PortaApplicativa";
    public static final String TXT_LATENZA_ATTRAVERSAMENTO_PA_RESPONSE = "Tempo di attraversamento (min/avg/max) della PortaApplicativa per i messaggi di risposta";
    public static final String DIMENSIONE_MESSAGGI = "Dimensione messaggi PdD";
    public static final String DIMENSIONE_MESSAGGI_IN_REQUEST = "Dimensione richieste in ingresso sulla PdD";
    public static final String DIMENSIONE_MESSAGGI_OUT_REQUEST = "Dimensione richieste in uscita dalla PdD";
    public static final String DIMENSIONE_MESSAGGI_IN_RESPONSE = "Dimensione risposte in ingresso sulla PdD";
    public static final String DIMENSIONE_MESSAGGI_OUT_RESPONSE = "Dimensione risposte in uscita dalla PdD";
    public static final String TXT_DIMENSIONE_MESSAGGI = "Dimensione dei messaggi (min/avg/max) gestiti dalla PdD";
    public static final String TXT_DIMENSIONE_MESSAGGI_IN_REQUEST = "Dimensione dei messaggi di richiesta (min/avg/max) in ingresso sulla PdD";
    public static final String TXT_DIMENSIONE_MESSAGGI_OUT_REQUEST = "Dimensione dei messaggi di richiesta (min/avg/max) in uscita dalla PdD";
    public static final String TXT_DIMENSIONE_MESSAGGI_IN_RESPONSE = "Dimensione dei messaggi di risposta (min/avg/max) in ingresso sulla PdD";
    public static final String TXT_DIMENSIONE_MESSAGGI_OUT_RESPONSE = "Dimensione dei messaggi di risposta (min/avg/max) in uscita dalla PdD";
    public static final String DIMENSIONE_MESSAGGI_PD = "Dimensione messaggi PortaDelegata";
    public static final String DIMENSIONE_MESSAGGI_PD_IN_REQUEST = "Dimensione richieste in ingresso sulla PortaDelegata";
    public static final String DIMENSIONE_MESSAGGI_PD_OUT_REQUEST = "Dimensione richieste in uscita dalla PortaDelegata";
    public static final String DIMENSIONE_MESSAGGI_PD_IN_RESPONSE = "Dimensione risposte in ingresso sulla PortaDelegata";
    public static final String DIMENSIONE_MESSAGGI_PD_OUT_RESPONSE = "Dimensione risposte in uscita dalla PortaDelegata";
    public static final String TXT_DIMENSIONE_MESSAGGI_PD = "Dimensione dei messaggi (min/avg/max) gestiti dalla PortaDelegata";
    public static final String TXT_DIMENSIONE_MESSAGGI_PD_IN_REQUEST = "Dimensione dei messaggi di richiesta (min/avg/max) in ingresso sulla PortaDelegata";
    public static final String TXT_DIMENSIONE_MESSAGGI_PD_OUT_REQUEST = "Dimensione dei messaggi di richiesta (min/avg/max) in uscita dalla PortaDelegata";
    public static final String TXT_DIMENSIONE_MESSAGGI_PD_IN_RESPONSE = "Dimensione dei messaggi di risposta (min/avg/max) in ingresso sulla PortaDelegata";
    public static final String TXT_DIMENSIONE_MESSAGGI_PD_OUT_RESPONSE = "Dimensione dei messaggi di risposta (min/avg/max) in uscita dalla PortaDelegata";
    public static final String DIMENSIONE_MESSAGGI_PA = "Dimensione messaggi PortaApplicativa";
    public static final String DIMENSIONE_MESSAGGI_PA_IN_REQUEST = "Dimensione richieste in ingresso sulla PortaApplicativa";
    public static final String DIMENSIONE_MESSAGGI_PA_OUT_REQUEST = "Dimensione richieste in uscita dalla PortaApplicativa";
    public static final String DIMENSIONE_MESSAGGI_PA_IN_RESPONSE = "Dimensione risposte in ingresso sulla PortaApplicativa";
    public static final String DIMENSIONE_MESSAGGI_PA_OUT_RESPONSE = "Dimensione risposte in uscita dalla PortaApplicativa";
    public static final String TXT_DIMENSIONE_MESSAGGI_PA = "Dimensione dei messaggi (min/avg/max) gestiti dalla PortaApplicativa";
    public static final String TXT_DIMENSIONE_MESSAGGI_PA_IN_REQUEST = "Dimensione dei messaggi di richiesta (min/avg/max) in ingresso sulla PortaApplicativa";
    public static final String TXT_DIMENSIONE_MESSAGGI_PA_OUT_REQUEST = "Dimensione dei messaggi di richiesta (min/avg/max) in uscita dalla PortaApplicativa";
    public static final String TXT_DIMENSIONE_MESSAGGI_PA_IN_RESPONSE = "Dimensione dei messaggi di risposta (min/avg/max) in ingresso sulla PortaApplicativa";
    public static final String TXT_DIMENSIONE_MESSAGGI_PA_OUT_RESPONSE = "Dimensione dei messaggi di risposta (min/avg/max) in uscita dalla PortaApplicativa";
    public static final String REFRESH = "refresh";
    public static final String RESET = "reset";
    private String intervallo_statistico = "";
    private String numero_transazioni = "";
    private String numero_transazioni_pd = "";
    private String numero_transazioni_pa = "";
    private String latenza_attraversamento = "";
    private String latenza_attraversamento_request = "";
    private String latenza_attraversamento_response = "";
    private String latenza_attraversamento_pd = "";
    private String latenza_attraversamento_pd_request = "";
    private String latenza_attraversamento_pd_response = "";
    private String latenza_attraversamento_pa = "";
    private String latenza_attraversamento_pa_request = "";
    private String latenza_attraversamento_pa_response = "";
    private String dimensione_messaggi = "";
    private String dimensione_messaggi_in_request = "";
    private String dimensione_messaggi_out_request = "";
    private String dimensione_messaggi_in_response = "";
    private String dimensione_messaggi_out_response = "";
    private String dimensione_messaggi_pd = "";
    private String dimensione_messaggi_pd_in_request = "";
    private String dimensione_messaggi_pd_out_request = "";
    private String dimensione_messaggi_pd_in_response = "";
    private String dimensione_messaggi_pd_out_response = "";
    private String dimensione_messaggi_pa = "";
    private String dimensione_messaggi_pa_in_request = "";
    private String dimensione_messaggi_pa_out_request = "";
    private String dimensione_messaggi_pa_in_response = "";
    private String dimensione_messaggi_pa_out_response = "";

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(INTERVALLO_STATISTICO)) {
            return this.intervallo_statistico;
        }
        if (attributeName.equals(NUMERO_TRANSAZIONI)) {
            return this.numero_transazioni;
        }
        if (attributeName.equals(NUMERO_TRANSAZIONI_PD)) {
            return this.numero_transazioni_pd;
        }
        if (attributeName.equals(NUMERO_TRANSAZIONI_PA)) {
            return this.numero_transazioni_pa;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO)) {
            return this.latenza_attraversamento;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_REQUEST)) {
            return this.latenza_attraversamento_request;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_RESPONSE)) {
            return this.latenza_attraversamento_response;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_PD)) {
            return this.latenza_attraversamento_pd;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_PD_REQUEST)) {
            return this.latenza_attraversamento_pd_request;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_PD_RESPONSE)) {
            return this.latenza_attraversamento_pd_response;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_PA)) {
            return this.latenza_attraversamento_pa;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_PA_REQUEST)) {
            return this.latenza_attraversamento_pa_request;
        }
        if (attributeName.equals(LATENZA_ATTRAVERSAMENTO_PA_RESPONSE)) {
            return this.latenza_attraversamento_pa_response;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI)) {
            return this.dimensione_messaggi;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_IN_REQUEST)) {
            return this.dimensione_messaggi_in_request;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_OUT_REQUEST)) {
            return this.dimensione_messaggi_out_request;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_IN_RESPONSE)) {
            return this.dimensione_messaggi_in_response;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_OUT_RESPONSE)) {
            return this.dimensione_messaggi_out_response;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PD)) {
            return this.dimensione_messaggi_pd;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PD_IN_REQUEST)) {
            return this.dimensione_messaggi_pd_in_request;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PD_OUT_REQUEST)) {
            return this.dimensione_messaggi_pd_out_request;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PD_IN_RESPONSE)) {
            return this.dimensione_messaggi_pd_in_response;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PD_OUT_RESPONSE)) {
            return this.dimensione_messaggi_pd_out_response;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PA)) {
            return this.dimensione_messaggi_pa;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PA_IN_REQUEST)) {
            return this.dimensione_messaggi_pa_in_request;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PA_OUT_REQUEST)) {
            return this.dimensione_messaggi_pa_out_request;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PA_IN_RESPONSE)) {
            return this.dimensione_messaggi_pa_in_response;
        }
        if (attributeName.equals(DIMENSIONE_MESSAGGI_PA_OUT_RESPONSE)) {
            return this.dimensione_messaggi_pa_out_response;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
        }
        try {
            if (!(attribute.getName().equals(INTERVALLO_STATISTICO) || attribute.getName().equals(NUMERO_TRANSAZIONI) || attribute.getName().equals(NUMERO_TRANSAZIONI_PD) || attribute.getName().equals(NUMERO_TRANSAZIONI_PA) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_REQUEST) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_RESPONSE) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_PD) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_PD_REQUEST) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_PD_RESPONSE) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_PA) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_PA_REQUEST) || attribute.getName().equals(LATENZA_ATTRAVERSAMENTO_PA_RESPONSE) || attribute.getName().equals(DIMENSIONE_MESSAGGI) || attribute.getName().equals(DIMENSIONE_MESSAGGI_IN_REQUEST) || attribute.getName().equals(DIMENSIONE_MESSAGGI_OUT_REQUEST) || attribute.getName().equals(DIMENSIONE_MESSAGGI_IN_RESPONSE) || attribute.getName().equals(DIMENSIONE_MESSAGGI_OUT_RESPONSE) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PD) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PD_IN_REQUEST) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PD_OUT_REQUEST) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PD_IN_RESPONSE) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PD_OUT_RESPONSE) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PA) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PA_IN_REQUEST) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PA_OUT_REQUEST) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PA_IN_RESPONSE) || attribute.getName().equals(DIMENSIONE_MESSAGGI_PA_OUT_RESPONSE))) {
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
        }
        catch (ClassCastException ce) {
            throw new InvalidAttributeValueException("il tipo " + String.valueOf(attribute.getValue().getClass()) + " dell'attributo " + attribute.getName() + " non e' valido");
        }
        catch (JMException j) {
            throw new MBeanException(j);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException jMException) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(REFRESH)) {
            return this.refresh();
        }
        if (actionName.equals(RESET)) {
            return this.reset();
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Stato dei servizi attivi";
        MBeanAttributeInfo intervalloStatistico_VAR = new MBeanAttributeInfo(INTERVALLO_STATISTICO, String.class.getName(), "Intervallo temporale a cui si riferisce il rilevamento statistico", true, false, false);
        MBeanAttributeInfo numeroTransazioni_VAR = new MBeanAttributeInfo(NUMERO_TRANSAZIONI, String.class.getName(), TXT_NUMERO_TRANSAZIONI, true, false, false);
        MBeanAttributeInfo numeroTransazioniPD_VAR = new MBeanAttributeInfo(NUMERO_TRANSAZIONI_PD, String.class.getName(), TXT_NUMERO_TRANSAZIONI_PD, true, false, false);
        MBeanAttributeInfo numeroTransazioniPA_VAR = new MBeanAttributeInfo(NUMERO_TRANSAZIONI_PA, String.class.getName(), TXT_NUMERO_TRANSAZIONI_PA, true, false, false);
        MBeanAttributeInfo latenzaAttraversamento_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoRequest_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_REQUEST, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_REQUEST, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoResponse_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_RESPONSE, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_RESPONSE, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoPD_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_PD, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_PD, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoPDRequest_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_PD_REQUEST, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_PD_REQUEST, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoPDResponse_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_PD_RESPONSE, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_PD_RESPONSE, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoPA_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_PA, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_PA, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoPARequest_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_PA_REQUEST, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_PA_REQUEST, true, false, false);
        MBeanAttributeInfo latenzaAttraversamentoPAResponse_VAR = new MBeanAttributeInfo(LATENZA_ATTRAVERSAMENTO_PA_RESPONSE, String.class.getName(), TXT_LATENZA_ATTRAVERSAMENTO_PA_RESPONSE, true, false, false);
        MBeanAttributeInfo dimensioneMessaggi_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI, String.class.getName(), TXT_DIMENSIONE_MESSAGGI, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiInRequest_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_IN_REQUEST, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_IN_REQUEST, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiOutRequest_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_OUT_REQUEST, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_OUT_REQUEST, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiInResponse_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_IN_RESPONSE, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_IN_RESPONSE, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiOutResponse_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_OUT_RESPONSE, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_OUT_RESPONSE, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPD_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PD, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PD, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPDInRequest_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PD_IN_REQUEST, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PD_IN_REQUEST, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPDOutRequest_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PD_OUT_REQUEST, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PD_OUT_REQUEST, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPDInResponse_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PD_IN_RESPONSE, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PD_IN_RESPONSE, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPDOutResponse_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PD_OUT_RESPONSE, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PD_OUT_RESPONSE, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPA_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PA, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PA, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPAInRequest_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PA_IN_REQUEST, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PA_IN_REQUEST, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPAOutRequest_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PA_OUT_REQUEST, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PA_OUT_REQUEST, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPAInResponse_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PA_IN_RESPONSE, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PA_IN_RESPONSE, true, false, false);
        MBeanAttributeInfo dimensioneMessaggiPAOutResponse_VAR = new MBeanAttributeInfo(DIMENSIONE_MESSAGGI_PA_OUT_RESPONSE, String.class.getName(), TXT_DIMENSIONE_MESSAGGI_PA_OUT_RESPONSE, true, false, false);
        MBeanOperationInfo refresh_OP = new MBeanOperationInfo(REFRESH, "Aggiorna le statistiche", null, String.class.getName(), 1);
        MBeanOperationInfo reset_OP = new MBeanOperationInfo(RESET, "Reset delle informazioni statistiche", null, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{intervalloStatistico_VAR, numeroTransazioni_VAR, numeroTransazioniPD_VAR, numeroTransazioniPA_VAR, latenzaAttraversamento_VAR, latenzaAttraversamentoRequest_VAR, latenzaAttraversamentoResponse_VAR, latenzaAttraversamentoPD_VAR, latenzaAttraversamentoPDRequest_VAR, latenzaAttraversamentoPDResponse_VAR, latenzaAttraversamentoPA_VAR, latenzaAttraversamentoPARequest_VAR, latenzaAttraversamentoPAResponse_VAR, dimensioneMessaggi_VAR, dimensioneMessaggiInRequest_VAR, dimensioneMessaggiOutRequest_VAR, dimensioneMessaggiInResponse_VAR, dimensioneMessaggiOutResponse_VAR, dimensioneMessaggiPD_VAR, dimensioneMessaggiPDInRequest_VAR, dimensioneMessaggiPDOutRequest_VAR, dimensioneMessaggiPDInResponse_VAR, dimensioneMessaggiPDOutResponse_VAR, dimensioneMessaggiPA_VAR, dimensioneMessaggiPAInRequest_VAR, dimensioneMessaggiPAOutRequest_VAR, dimensioneMessaggiPAInResponse_VAR, dimensioneMessaggiPAOutResponse_VAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{refresh_OP, reset_OP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public String refresh() {
        StatisticsCollection stat = StatisticsCollection.getStatisticsCollection();
        if (stat.getDataUltimoRefresh() > 0L) {
            Date rightBound = DateManager.getDate();
            Date leftBound = new Date(stat.getDataUltimoRefresh());
            DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss");
            this.intervallo_statistico = "[" + dateformat.format(leftBound) + "] - [" + dateformat.format(rightBound) + "]";
        } else {
            this.intervallo_statistico = "";
        }
        this.numero_transazioni = stat.getStatNumeroTransazioni().numeroTransazioni + "/" + stat.getStatNumeroTransazioni().numeroTransazioni_esitoOK + "/" + stat.getStatNumeroTransazioni().numeroTransazioni_esitoErrore;
        this.numero_transazioni_pd = stat.getStatNumeroTransazioniPD().numeroTransazioni + "/" + stat.getStatNumeroTransazioniPD().numeroTransazioni_esitoOK + "/" + stat.getStatNumeroTransazioniPD().numeroTransazioni_esitoErrore;
        this.numero_transazioni_pa = stat.getStatNumeroTransazioniPA().numeroTransazioni + "/" + stat.getStatNumeroTransazioniPA().numeroTransazioni_esitoOK + "/" + stat.getStatNumeroTransazioniPA().numeroTransazioni_esitoErrore;
        this.latenza_attraversamento = this.convertTime(stat.getStatLatenzaAttraversamento().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamento().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamento().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_request = this.convertTime(stat.getStatLatenzaAttraversamentoRequest().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoRequest().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoRequest().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_response = this.convertTime(stat.getStatLatenzaAttraversamentoResponse().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoResponse().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoResponse().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_pd = this.convertTime(stat.getStatLatenzaAttraversamentoPD().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPD().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPD().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_pd_request = this.convertTime(stat.getStatLatenzaAttraversamentoPDRequest().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPDRequest().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPDRequest().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_pd_response = this.convertTime(stat.getStatLatenzaAttraversamentoPDResponse().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPDResponse().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPDResponse().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_pa = this.convertTime(stat.getStatLatenzaAttraversamentoPA().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPA().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPA().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_pa_request = this.convertTime(stat.getStatLatenzaAttraversamentoPARequest().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPARequest().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPARequest().latenzaMassimaAttraversamento);
        this.latenza_attraversamento_pa_response = this.convertTime(stat.getStatLatenzaAttraversamentoPAResponse().latenzaMinimaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPAResponse().latenzaMediaAttraversamento) + "/" + this.convertTime(stat.getStatLatenzaAttraversamentoPAResponse().latenzaMassimaAttraversamento);
        this.dimensione_messaggi = this.convertSize(stat.getStatDimensioneMessaggio().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggio().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggio().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_in_request = this.convertSize(stat.getStatDimensioneMessaggioInRequest().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioInRequest().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioInRequest().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_out_request = this.convertSize(stat.getStatDimensioneMessaggioOutRequest().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioOutRequest().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioOutRequest().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_in_response = this.convertSize(stat.getStatDimensioneMessaggioInResponse().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioInResponse().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioInResponse().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_out_response = this.convertSize(stat.getStatDimensioneMessaggioOutResponse().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioOutResponse().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioOutResponse().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pd = this.convertSize(stat.getStatDimensioneMessaggioPD().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPD().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPD().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pd_in_request = this.convertSize(stat.getStatDimensioneMessaggioPDInRequest().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDInRequest().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDInRequest().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pd_out_request = this.convertSize(stat.getStatDimensioneMessaggioPDOutRequest().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDOutRequest().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDOutRequest().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pd_in_response = this.convertSize(stat.getStatDimensioneMessaggioPDInResponse().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDInResponse().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDInResponse().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pd_out_response = this.convertSize(stat.getStatDimensioneMessaggioPDOutResponse().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDOutResponse().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPDOutResponse().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pa = this.convertSize(stat.getStatDimensioneMessaggioPA().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPA().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPA().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pa_in_request = this.convertSize(stat.getStatDimensioneMessaggioPAInRequest().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAInRequest().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAInRequest().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pa_out_request = this.convertSize(stat.getStatDimensioneMessaggioPAOutRequest().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAOutRequest().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAOutRequest().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pa_in_response = this.convertSize(stat.getStatDimensioneMessaggioPAInResponse().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAInResponse().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAInResponse().dimensioneMassimaMessaggio);
        this.dimensione_messaggi_pa_out_response = this.convertSize(stat.getStatDimensioneMessaggioPAOutResponse().dimensioneMinimaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAOutResponse().dimensioneMediaMessaggio) + "/" + this.convertSize(stat.getStatDimensioneMessaggioPAOutResponse().dimensioneMassimaMessaggio);
        return "Refresh dati statistici effettuato";
    }

    private String convertTime(long time) {
        return Utilities.convertSystemTimeIntoStringMillisecondi((long)time, (boolean)true);
    }

    private String convertSize(long size) {
        return Utilities.convertBytesToFormatString((long)size);
    }

    public String reset() {
        StatisticsCollection.reset();
        this.refresh();
        return "Reset dati statistici effettuato";
    }
}

