/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;

class VersioneBaseDatiChecker
implements Callable<String> {
    private OpenSPCoop2Properties openspcoopProperties;
    private boolean isNodoRun;

    public VersioneBaseDatiChecker(OpenSPCoop2Properties openspcoopProperties, boolean isNodoRun) {
        this.openspcoopProperties = openspcoopProperties;
        this.isNodoRun = isNodoRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws Exception {
        if (!DBManager.isInitialized()) {
            throw new CoreException("Inizializzazione DBManager non effettuata");
        }
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        IDSoggetto dominio = this.openspcoopProperties.getIdentitaPortaDefaultWithoutProtocol();
        String modulo = this.getClass().getName();
        try {
            resource = dbManager.getResource(dominio, modulo, null);
            Connection c = (Connection)resource.getResource();
            StringBuilder bf = new StringBuilder();
            this.checkTable(c, bf);
            if (bf.length() <= 0) {
                throw new CoreException("BaseDati non possiede informazioni sul versionamento");
            }
            String string = bf.toString();
            return string;
        }
        finally {
            try {
                dbManager.releaseResource(dominio, modulo, resource);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTable(Connection c, StringBuilder bf) throws UtilsMultiException, SQLException {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String table1 = this.isNodoRun ? "db_info" : "db_info_console";
            String sql = "select * from " + table1 + " order by id DESC";
            pstmt = c.prepareStatement(sql);
            try {
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int majorVersion = rs.getInt("major_version");
                    int minorVersion = rs.getInt("minor_version");
                    String details = rs.getString("notes");
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append("[" + majorVersion + "." + minorVersion + "] " + details);
                }
            }
            catch (Throwable t) {
                JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
                rs = null;
                pstmt = null;
                this.checkTable2(c, bf, t);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTable2(Connection c, StringBuilder bf, Throwable t) throws UtilsMultiException, SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String table2 = this.isNodoRun ? "db_info_console" : "db_info";
            String sql = "select * from " + table2 + " order by id DESC";
            pstmt = c.prepareStatement(sql);
            rs = pstmt.executeQuery();
            try {
                while (rs.next()) {
                    int majorVersion = rs.getInt("major_version");
                    int minorVersion = rs.getInt("minor_version");
                    String details = rs.getString("notes");
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append("[" + majorVersion + "." + minorVersion + "] " + details);
                }
            }
            catch (Throwable tInternal) {
                throw new UtilsMultiException(new Throwable[]{t, tInternal});
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs, pstmt);
            throw throwable;
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)pstmt);
    }
}

