/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.keystore;

import java.security.cert.X509Certificate;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.ExternalResource;
import org.openspcoop2.security.keystore.HttpStore;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.MultiKeystore;
import org.openspcoop2.security.keystore.OCSPResponse;
import org.openspcoop2.security.keystore.PublicKeyStore;
import org.openspcoop2.security.keystore.RemoteStore;
import org.openspcoop2.security.keystore.SSLConfigProps;
import org.openspcoop2.security.keystore.SSLSocketFactory;
import org.openspcoop2.security.keystore.SecretKeyStore;
import org.openspcoop2.security.keystore.SymmetricKeystore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;
import org.openspcoop2.utils.transport.http.HttpOptions;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.slf4j.Logger;

public class GestoreKeystoreCaching {
    private static final String KEYSTORE_CACHE_NAME = "keystore";
    private static Cache cache = null;
    private static volatile long itemCrlLifeSecond;
    private static GestoreKeystoreCaching staticInstance;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    private static KeystoreException newKeystoreExceptionGenericError(Exception e) {
        return new KeystoreException("Abilitazione cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
    }

    public static boolean isCacheAbilitata() {
        return cache != null;
    }

    public static void resetCache() throws KeystoreException {
        try {
            if (cache != null) {
                cache.clear();
            }
        }
        catch (Exception e) {
            throw new KeystoreException("Reset della cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
        }
    }

    public static String printStatsCache(String separator) throws KeystoreException {
        try {
            if (cache != null) {
                return GestoreKeystoreCaching.getStatsCache(separator);
            }
            throw new KeystoreException("Cache non abilitata");
        }
        catch (Exception e) {
            throw new KeystoreException("Visualizzazione Statistiche riguardante la cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
        }
    }

    private static String getStatsCache(String separator) throws KeystoreException {
        try {
            String stats = cache.printStats(separator);
            String lifeTimeLabel = "LifeTime:";
            if (stats.contains(lifeTimeLabel)) {
                StringBuilder bf = new StringBuilder();
                bf.append("CRLsLifeTime:");
                long lifeTime = GestoreKeystoreCaching.getItemCrlLifeSecond();
                if (lifeTime > 0L) {
                    bf.append(Utilities.convertSystemTimeIntoStringMillisecondi((long)(lifeTime * 1000L), (boolean)false));
                } else if (lifeTime == 0L) {
                    bf.append("0");
                } else if (lifeTime < 0L) {
                    bf.append("Infinito");
                }
                bf.append(separator);
                return stats.replace(lifeTimeLabel, bf.toString() + lifeTimeLabel);
            }
            return stats;
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws KeystoreException {
        try {
            if (cache != null) {
                throw new KeystoreException("Cache gia' abilitata");
            }
            GestoreKeystoreCaching.abilitaCacheEngine();
        }
        catch (Exception e) {
            throw GestoreKeystoreCaching.newKeystoreExceptionGenericError(e);
        }
    }

    private static synchronized void abilitaCacheEngine() throws KeystoreException {
        try {
            if (cache == null) {
                cache = new Cache(CacheType.JCS, KEYSTORE_CACHE_NAME);
                cache.build();
            }
        }
        catch (Exception e) {
            throw GestoreKeystoreCaching.newKeystoreExceptionGenericError(e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger log) throws KeystoreException {
        try {
            if (cache != null) {
                throw new KeystoreException("Cache gia' abilitata");
            }
            int dimensione = -1;
            if (dimensioneCache != null) {
                dimensione = dimensioneCache.intValue();
            }
            GestoreKeystoreCaching.initCache(CacheType.JCS, (Integer)dimensione, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, log);
        }
        catch (Exception e) {
            throw GestoreKeystoreCaching.newKeystoreExceptionGenericError(e);
        }
    }

    public static void disabilitaCache() throws KeystoreException {
        try {
            if (cache == null) {
                throw new KeystoreException("Cache gia' disabilitata");
            }
            GestoreKeystoreCaching.disabilitaCacheEngine();
        }
        catch (Exception e) {
            throw new KeystoreException("Disabilitazione cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
        }
    }

    private static synchronized void disabilitaCacheEngine() throws KeystoreException {
        try {
            if (cache != null) {
                cache.clear();
                cache = null;
            }
        }
        catch (Exception e) {
            throw new KeystoreException("Disabilitazione cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
        }
    }

    public static String listKeysCache(String separator) throws KeystoreException {
        try {
            if (cache != null) {
                return GestoreKeystoreCaching.getKeysCache(separator);
            }
            throw new KeystoreException("Cache non abilitata");
        }
        catch (Exception e) {
            throw new KeystoreException("Visualizzazione chiavi presenti nella cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
        }
    }

    private static String getKeysCache(String separator) throws KeystoreException {
        try {
            return cache.printKeys(separator);
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
    }

    public static String getObjectCache(String key) throws KeystoreException {
        try {
            if (cache != null) {
                return GestoreKeystoreCaching.getByKey(key);
            }
            throw new KeystoreException("Cache non abilitata");
        }
        catch (Exception e) {
            throw new KeystoreException("Visualizzazione oggetto presente nella cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
        }
    }

    private static String getByKey(String key) throws KeystoreException {
        try {
            Object o = cache.get(key);
            if (o != null) {
                return o.toString();
            }
            return "oggetto con chiave [" + key + "] non presente";
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
    }

    public static void removeObjectCache(String key) throws KeystoreException {
        try {
            if (cache == null) {
                throw new KeystoreException("Cache non abilitata");
            }
            GestoreKeystoreCaching.removeByKey(key);
        }
        catch (Exception e) {
            throw new KeystoreException("Rimozione oggetto presente nella cache per i dati contenenti i keystore non riuscita: " + e.getMessage(), e);
        }
    }

    private static void removeByKey(String key) throws KeystoreException {
        try {
            cache.remove(key);
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
    }

    public static void initialize(Logger log) throws KeystoreException {
        GestoreKeystoreCaching.initialize(null, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws KeystoreException {
        GestoreKeystoreCaching.initialize(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws KeystoreException {
        if (cacheAbilitata) {
            GestoreKeystoreCaching.initCache(cacheType, (Integer)dimensioneCache, algoritmoCache, (Long)idleTime, (Long)itemLifeSecond, log);
        }
    }

    private static void initCache(CacheType cacheType, Integer dimensioneCache, String algoritmoCache, Long itemIdleTime, Long itemLifeSecond, Logger alog) throws KeystoreException {
        GestoreKeystoreCaching.initCache(cacheType, dimensioneCache, CostantiConfigurazione.CACHE_LRU.toString().equalsIgnoreCase(algoritmoCache), itemIdleTime, itemLifeSecond, alog);
    }

    private static void initCache(CacheType cacheType, Integer dimensioneCache, boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger alog) throws KeystoreException {
        try {
            cache = new Cache(cacheType, KEYSTORE_CACHE_NAME);
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        GestoreKeystoreCaching.initCacheSize(dimensioneCache, alog);
        Object msg = "Algoritmo di cache (ResponseCaching) impostato al valore: LRU";
        if (!algoritmoCacheLRU) {
            msg = "Algoritmo di cache (ResponseCaching) impostato al valore: MRU";
        }
        alog.info((String)msg);
        if (!algoritmoCacheLRU) {
            cache.setCacheAlgoritm(CacheAlgorithm.MRU);
        } else {
            cache.setCacheAlgoritm(CacheAlgorithm.LRU);
        }
        if (itemIdleTime != null && itemIdleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (ResponseCaching) impostato al valore: " + itemIdleTime;
                alog.info((String)msg);
                cache.setItemIdleTime(itemIdleTime.longValue());
            }
            catch (Exception error) {
                msg = "Parametro errato per l'attributo 'IdleTime' (ResponseCaching): " + error.getMessage();
                alog.error((String)msg);
                throw new KeystoreException((String)msg, error);
            }
        }
        long longItemLife = -1L;
        if (itemLifeSecond != null && itemLifeSecond > 0L) {
            longItemLife = itemLifeSecond;
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (ResponseCaching) impostato al valore: " + longItemLife;
            alog.info((String)msg);
            cache.setItemLifeTime(longItemLife);
        }
        catch (Exception error) {
            msg = "Parametro errato per l'attributo 'MaxLifeSecond' (ResponseCaching): " + error.getMessage();
            alog.error((String)msg);
            throw new KeystoreException((String)msg, error);
        }
        try {
            cache.build();
        }
        catch (Exception e) {
            throw new KeystoreException(e.getMessage(), e);
        }
        GestoreKeystoreCache.setKeystoreCacheJCS((boolean)true, (int)(longItemLife > 0L ? (int)longItemLife : 7200), (Cache)cache);
    }

    private static void initCacheSize(Integer dimensioneCache, Logger alog) throws KeystoreException {
        if (dimensioneCache != null && dimensioneCache > 0) {
            try {
                String msg = "Dimensione della cache (ResponseCaching) impostata al valore: " + dimensioneCache;
                alog.info(msg);
                cache.setCacheSize(dimensioneCache.intValue());
            }
            catch (Exception error) {
                String msg = "Parametro errato per la dimensione della cache (ResponseCaching): " + error.getMessage();
                alog.error(msg);
                throw new KeystoreException(msg, error);
            }
        }
    }

    public static void setCacheCrlLifeSeconds(long itemCrlLifeSecondParam) {
        itemCrlLifeSecond = itemCrlLifeSecondParam;
        GestoreKeystoreCache.setKeystoreCacheJCSCrlLifeSeconds((int)(itemCrlLifeSecond > 0L ? (int)itemCrlLifeSecond : 7200));
    }

    public static long getItemCrlLifeSecond() {
        return itemCrlLifeSecond;
    }

    public static synchronized void initialize() throws KeystoreException {
        if (staticInstance == null) {
            staticInstance = new GestoreKeystoreCaching();
        }
    }

    public static GestoreKeystoreCaching getInstance() throws KeystoreException {
        if (staticInstance == null) {
            Class<GestoreKeystoreCaching> clazz = GestoreKeystoreCaching.class;
            synchronized (GestoreKeystoreCaching.class) {
                throw new KeystoreException("GestoreKeystore non inizializzato");
            }
        }
        return staticInstance;
    }

    private GestoreKeystoreCaching() throws KeystoreException {
    }

    public static MerlinTruststore getMerlinTruststore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        return GestoreKeystoreCache.getMerlinTruststore((RequestInfo)requestInfo, (String)propertyFilePath);
    }

    public static MerlinTruststore getMerlinTruststore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore) throws SecurityException {
        return GestoreKeystoreCache.getMerlinTruststore((RequestInfo)requestInfo, (String)pathStore, (String)tipoStore, (String)passwordStore);
    }

    public static MerlinTruststore getMerlinTruststore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore) throws SecurityException {
        return GestoreKeystoreCache.getMerlinTruststore((RequestInfo)requestInfo, (byte[])bytesStore, (String)tipoStore, (String)passwordStore);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)propertyFilePath);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String propertyFilePath, String passwordPrivateKey) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)propertyFilePath, (String)passwordPrivateKey);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)pathStore, (String)tipoStore, (String)passwordStore);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)pathStore, (String)tipoStore, (String)passwordStore, (String)passwordPrivateKey);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (byte[])bytesStore, (String)tipoStore, (String)passwordStore);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (byte[])bytesStore, (String)tipoStore, (String)passwordStore, (String)passwordPrivateKey);
    }

    public static SymmetricKeystore getSymmetricKeystore(RequestInfo requestInfo, String alias, String key, String algoritmo) throws SecurityException {
        return GestoreKeystoreCache.getSymmetricKeystore((RequestInfo)requestInfo, (String)key, (String)alias, (String)algoritmo);
    }

    public static MultiKeystore getMultiKeystore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        return GestoreKeystoreCache.getMultiKeystore((RequestInfo)requestInfo, (String)propertyFilePath);
    }

    public static JWKSetStore getJwkSetStore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        return GestoreKeystoreCache.getJwkSetStore((RequestInfo)requestInfo, (String)propertyFilePath);
    }

    public static JWKSetStore getJwkSetStore(RequestInfo requestInfo, byte[] archive) throws SecurityException {
        return GestoreKeystoreCache.getJwkSetStore((RequestInfo)requestInfo, (byte[])archive);
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, String privateKeyPath, String publicKeyPath, String privateKeyPassword, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getKeyPairStore((RequestInfo)requestInfo, (String)privateKeyPath, (String)publicKeyPath, (String)privateKeyPassword, (String)algorithm);
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, byte[] privateKey, byte[] publicKey, String privateKeyPassword, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getKeyPairStore((RequestInfo)requestInfo, (byte[])privateKey, (byte[])publicKey, (String)privateKeyPassword, (String)algorithm);
    }

    public static PublicKeyStore getPublicKeyStore(RequestInfo requestInfo, String publicKeyPath, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getPublicKeyStore((RequestInfo)requestInfo, (String)publicKeyPath, (String)algorithm);
    }

    public static PublicKeyStore getPublicKeyStore(RequestInfo requestInfo, byte[] publicKey, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getPublicKeyStore((RequestInfo)requestInfo, (byte[])publicKey, (String)algorithm);
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, String secretKeyPath, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getSecretKeyStore((RequestInfo)requestInfo, (String)secretKeyPath, (String)algorithm);
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, byte[] secretKey, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getSecretKeyStore((RequestInfo)requestInfo, (byte[])secretKey, (String)algorithm);
    }

    public static RemoteStore getRemoteStore(RequestInfo requestInfo, String keyId, RemoteKeyType keyType, RemoteStoreConfig remoteStoreConfig, IRemoteStoreProvider provider) throws SecurityException {
        return GestoreKeystoreCache.getRemoteStore((RequestInfo)requestInfo, (String)keyId, (RemoteKeyType)keyType, (RemoteStoreConfig)remoteStoreConfig, (IRemoteStoreProvider)provider);
    }

    public static void removeRemoteStore(RequestInfo requestInfo, String keyId, RemoteKeyType keyType, RemoteStoreConfig remoteStoreConfig) throws SecurityException {
        GestoreKeystoreCache.removeRemoteStore((RequestInfo)requestInfo, (String)keyId, (RemoteKeyType)keyType, (RemoteStoreConfig)remoteStoreConfig);
    }

    public static RemoteStoreClientInfo getRemoteStoreClientInfo(RequestInfo requestInfo, String keyId, String clientId, RemoteStoreConfig remoteStoreConfig, IRemoteStoreProvider provider, Map<Object> context) throws SecurityException {
        return GestoreKeystoreCache.getRemoteStoreClientInfo((RequestInfo)requestInfo, (String)keyId, (String)clientId, (RemoteStoreConfig)remoteStoreConfig, (IRemoteStoreProvider)provider, context);
    }

    public static void removeRemoteStoreClientInfo(RequestInfo requestInfo, String keyId, RemoteStoreConfig remoteStoreConfig) throws SecurityException {
        GestoreKeystoreCache.removeRemoteStoreClientInfo((RequestInfo)requestInfo, (String)keyId, (RemoteStoreConfig)remoteStoreConfig);
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint) throws SecurityException {
        return GestoreKeystoreCache.getHttpStore((RequestInfo)requestInfo, (String)endpoint, (HttpOptions[])new HttpOptions[0]);
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Integer connectionTimeout, Integer readTimeout) throws SecurityException {
        return GestoreKeystoreCache.getHttpStore((RequestInfo)requestInfo, (String)endpoint, (Integer)connectionTimeout, (Integer)readTimeout, (HttpOptions[])new HttpOptions[0]);
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, MerlinTruststore trustStoreSsl) throws SecurityException {
        return GestoreKeystoreCache.getHttpStore((RequestInfo)requestInfo, (String)endpoint, (MerlinTruststore)trustStoreSsl, (HttpOptions[])new HttpOptions[0]);
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, MerlinTruststore trustStoreSsl, CRLCertstore crlTrustStoreSsl) throws SecurityException {
        return GestoreKeystoreCache.getHttpStore((RequestInfo)requestInfo, (String)endpoint, (MerlinTruststore)trustStoreSsl, (CRLCertstore)crlTrustStoreSsl, (HttpOptions[])new HttpOptions[0]);
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Integer connectionTimeout, Integer readTimeout, MerlinTruststore trustStoreSsl) throws SecurityException {
        return GestoreKeystoreCache.getHttpStore((RequestInfo)requestInfo, (String)endpoint, (Integer)connectionTimeout, (Integer)readTimeout, (MerlinTruststore)trustStoreSsl, (HttpOptions[])new HttpOptions[0]);
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Integer connectionTimeout, Integer readTimeout, MerlinTruststore trustStoreSsl, CRLCertstore crlTrustStoreSsl) throws SecurityException {
        return GestoreKeystoreCache.getHttpStore((RequestInfo)requestInfo, (String)endpoint, (Integer)connectionTimeout, (Integer)readTimeout, (MerlinTruststore)trustStoreSsl, (CRLCertstore)crlTrustStoreSsl, (HttpOptions[])new HttpOptions[0]);
    }

    public static CRLCertstore getCRLCertstore(RequestInfo requestInfo, String crlPath) throws SecurityException {
        return GestoreKeystoreCache.getCRLCertstore((RequestInfo)requestInfo, (String)crlPath);
    }

    public static CRLCertstore getCRLCertstore(RequestInfo requestInfo, String crlPath, java.util.Map<String, byte[]> localResources) throws SecurityException {
        return GestoreKeystoreCache.getCRLCertstore((RequestInfo)requestInfo, (String)crlPath, localResources);
    }

    public static SSLSocketFactory getSSLSocketFactory(RequestInfo requestInfo, SSLConfig sslConfig) throws SecurityException {
        return GestoreKeystoreCache.getSSLSocketFactory((RequestInfo)requestInfo, (SSLConfig)sslConfig);
    }

    public static ExternalResource getExternalResource(RequestInfo requestInfo, String resource, ExternalResourceConfig externalConfig) throws SecurityException {
        return GestoreKeystoreCache.getExternalResource((RequestInfo)requestInfo, (String)resource, (ExternalResourceConfig)externalConfig);
    }

    public static SSLConfigProps getSSLConfigProps(RequestInfo requestInfo, String resource, boolean sslConfigRequired) throws SecurityException {
        return GestoreKeystoreCache.getSSLConfigProps((RequestInfo)requestInfo, (String)resource, (boolean)sslConfigRequired);
    }

    public static OCSPResponse getOCSPResponse(RequestInfo requestInfo, IOCSPValidator ocspValidator, X509Certificate cert) throws SecurityException {
        return GestoreKeystoreCache.getOCSPResponse((RequestInfo)requestInfo, (IOCSPValidator)ocspValidator, (X509Certificate)cert);
    }

    public static OCSPResponse getOCSPResponse(RequestInfo requestInfo, IOCSPValidator ocspValidator, CertificateInfo cert) throws SecurityException {
        return GestoreKeystoreCache.getOCSPResponse((RequestInfo)requestInfo, (IOCSPValidator)ocspValidator, (CertificateInfo)cert);
    }

    static {
        staticInstance = null;
    }
}

