/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.keystore;

import java.io.ByteArrayOutputStream;
import java.security.PublicKey;
import org.openspcoop2.pdd.core.keystore.GestoreKeystoreCaching;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProviderDriver;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.RemoteStore;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;

public class RemoteStoreProvider
implements IRemoteStoreProvider {
    private RemoteKeyType keyType;
    private RequestInfo requestInfo;

    public RemoteStoreProvider(RequestInfo requestInfo, RemoteKeyType keyType) throws KeystoreException {
        this.requestInfo = requestInfo;
        if (keyType == null) {
            throw new KeystoreException("RemoteKeyType undefined");
        }
        this.keyType = keyType;
    }

    public JWK readJWK(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        try {
            return GestoreKeystoreCaching.getRemoteStore(this.requestInfo, keyId, this.keyType, remoteConfig, RemoteStoreProviderDriver.getProviderStore(remoteConfig.getStoreName())).getJWK();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public JWK readJWK(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        try {
            RemoteStore remoteStore = GestoreKeystoreCaching.getRemoteStore(this.requestInfo, keyId, this.keyType, remoteConfig, RemoteStoreProviderDriver.getProviderStore(remoteConfig.getStoreName()));
            if (bout != null) {
                bout.write(remoteStore.getResource());
            }
            return remoteStore.getJWK();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public Certificate readX509(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        try {
            return GestoreKeystoreCaching.getRemoteStore(this.requestInfo, keyId, this.keyType, remoteConfig, RemoteStoreProviderDriver.getProviderStore(remoteConfig.getStoreName())).getCertificate();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public Certificate readX509(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        try {
            RemoteStore remoteStore = GestoreKeystoreCaching.getRemoteStore(this.requestInfo, keyId, this.keyType, remoteConfig, RemoteStoreProviderDriver.getProviderStore(remoteConfig.getStoreName()));
            if (bout != null) {
                bout.write(remoteStore.getResource());
            }
            return remoteStore.getCertificate();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public PublicKey readPublicKey(String keyId, RemoteStoreConfig remoteConfig) throws UtilsException {
        try {
            return GestoreKeystoreCaching.getRemoteStore(this.requestInfo, keyId, this.keyType, remoteConfig, RemoteStoreProviderDriver.getProviderStore(remoteConfig.getStoreName())).getPublicKey();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public PublicKey readPublicKey(String keyId, RemoteStoreConfig remoteConfig, ByteArrayOutputStream bout) throws UtilsException {
        try {
            RemoteStore remoteStore = GestoreKeystoreCaching.getRemoteStore(this.requestInfo, keyId, this.keyType, remoteConfig, RemoteStoreProviderDriver.getProviderStore(remoteConfig.getStoreName()));
            if (bout != null) {
                bout.write(remoteStore.getResource());
            }
            return remoteStore.getPublicKey();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public RemoteStoreClientInfo readClientInfo(String keyId, String clientId, RemoteStoreConfig remoteConfig, Map<Object> context) throws UtilsException {
        try {
            return RemoteStoreProviderDriver.getProviderStore(remoteConfig.getStoreName()).readClientInfo(keyId, clientId, remoteConfig, context);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }
}

