/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.node;

import java.io.Serializable;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.JMSSender;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.GenericMessage;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.RequestInfoConfigUtilities;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;

public class NodeSenderJMS
extends AbstractCore
implements INodeSender {
    @Override
    public void send(Serializable msg, String destinazione, MsgDiagnostico msgDiag, IDSoggetto codicePorta, String idModulo, String idMessaggio, GestoreMessaggi gm) throws NodeException {
        java.util.Map dynamicContext;
        PdDContext pddContext;
        block10: {
            GenericMessage mm;
            RequestInfo requestInfoBackup = null;
            pddContext = null;
            dynamicContext = null;
            if (msg instanceof GenericMessage && (pddContext = (mm = (GenericMessage)msg).getPddContext()) != null) {
                requestInfoBackup = RequestInfoConfigUtilities.normalizeRequestInfoBeforeSerialization((Context)pddContext);
                dynamicContext = Costanti.removeDynamicMap((Map)pddContext);
            }
            try {
                JMSSender senderJMS = new JMSSender(codicePorta, idModulo, OpenSPCoop2Logger.getLoggerOpenSPCoopCore(), PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.getPddContext()));
                if (!senderJMS.send(destinazione, msg, idMessaggio)) {
                    if (senderJMS.getException() != null) {
                        throw new NodeException("Spedizione jms con errore: " + senderJMS.getErrore(), senderJMS.getException());
                    }
                    throw new NodeException("Spedizione jms con errore: " + senderJMS.getErrore());
                }
                msgDiag.highDebug("ObjectMessage send via JMS.");
                if (requestInfoBackup == null) break block10;
            }
            catch (Exception e) {
                try {
                    throw new NodeException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (requestInfoBackup != null) {
                        RequestInfoConfigUtilities.restoreRequestInfoAfterSerialization((Context)pddContext, requestInfoBackup);
                    }
                    if (dynamicContext != null) {
                        pddContext.put(Costanti.DYNAMIC_MAP_CONTEXT, dynamicContext);
                    }
                    throw throwable;
                }
            }
            RequestInfoConfigUtilities.restoreRequestInfoAfterSerialization((Context)pddContext, (RequestInfo)requestInfoBackup);
        }
        if (dynamicContext != null) {
            pddContext.put(Costanti.DYNAMIC_MAP_CONTEXT, dynamicContext);
        }
    }
}

