/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.response_caching;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.pdd.core.response_caching.ResponseCached;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.slf4j.Logger;

public class GestoreCacheResponseCaching {
    private static final String RESPONSE_CACHING_CACHE_NAME = "responseCaching";
    private static Cache cache = null;
    private static final Semaphore lock_cache = new Semaphore("GestoreCacheResponseCaching");
    private static GestoreCacheResponseCaching staticInstance = null;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public static boolean isCacheAbilitata() {
        return cache != null;
    }

    public static void resetCache() throws Exception {
        try {
            if (cache != null) {
                cache.clear();
            }
        }
        catch (Exception e) {
            throw new Exception("Reset della cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    public static String printStatsCache(String separator) throws Exception {
        try {
            if (cache != null) {
                try {
                    return cache.printStats(separator);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new Exception("Visualizzazione Statistiche riguardante la cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws Exception {
        try {
            if (cache != null) {
                throw new Exception("Cache gia' abilitata");
            }
            GestoreCacheResponseCaching._abilitaCache();
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    private static synchronized void _abilitaCache() throws Exception {
        try {
            if (cache == null) {
                cache = new Cache(CacheType.JCS, RESPONSE_CACHING_CACHE_NAME);
                cache.build();
            }
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger log) throws Exception {
        try {
            if (cache != null) {
                throw new Exception("Cache gia' abilitata");
            }
            int dimensione = -1;
            if (dimensioneCache != null) {
                dimensione = dimensioneCache.intValue();
            }
            GestoreCacheResponseCaching.initCache(CacheType.JCS, (Integer)dimensione, algoritmoCacheLRU, itemIdleTime, itemLifeSecond, log);
        }
        catch (Exception e) {
            throw new Exception("Abilitazione cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws Exception {
        try {
            if (cache == null) {
                throw new Exception("Cache gia' disabilitata");
            }
            GestoreCacheResponseCaching._disabilitaCache();
        }
        catch (Exception e) {
            throw new Exception("Disabilitazione cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    private static synchronized void _disabilitaCache() throws Exception {
        try {
            if (cache != null) {
                cache.clear();
                cache = null;
            }
        }
        catch (Exception e) {
            throw new Exception("Disabilitazione cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    public static String listKeysCache(String separator) throws Exception {
        try {
            if (cache != null) {
                try {
                    return cache.printKeys(separator);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new Exception("Visualizzazione chiavi presenti nella cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getObjectCache(String key) throws Exception {
        if (cache == null) throw new Exception("Cache non abilitata");
        try {
            Object o = cache.get(key);
            if (o == null) return "oggetto con chiave [" + key + "] non presente";
            return o.toString();
        }
        catch (Exception e) {
            try {
                throw new Exception(e.getMessage(), e);
            }
            catch (Exception e2) {
                throw new Exception("Visualizzazione oggetto presente nella cache per i dati contenenti le risposte salvate non riuscita: " + e2.getMessage(), e2);
            }
        }
    }

    public static void removeObjectCache(String key) throws Exception {
        block5: {
            try {
                if (cache != null) {
                    try {
                        cache.remove(key);
                        break block5;
                    }
                    catch (Exception e) {
                        throw new Exception(e.getMessage(), e);
                    }
                }
                throw new Exception("Cache non abilitata");
            }
            catch (Exception e) {
                throw new Exception("Rimozione oggetto presente nella cache per i dati contenenti le risposte salvate non riuscita: " + e.getMessage(), e);
            }
        }
    }

    public static void initialize(Logger log) throws Exception {
        GestoreCacheResponseCaching.initialize(null, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreCacheResponseCaching.initialize(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        if (cacheAbilitata) {
            GestoreCacheResponseCaching.initCache(cacheType, (Integer)dimensioneCache, algoritmoCache, (Long)idleTime, (Long)itemLifeSecond, log);
        }
    }

    private static void initCache(CacheType cacheType, Integer dimensioneCache, String algoritmoCache, Long itemIdleTime, Long itemLifeSecond, Logger alog) throws Exception {
        GestoreCacheResponseCaching.initCache(cacheType, dimensioneCache, CostantiConfigurazione.CACHE_LRU.toString().equalsIgnoreCase(algoritmoCache), itemIdleTime, itemLifeSecond, alog);
    }

    private static void initCache(CacheType cacheType, Integer dimensioneCache, boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond, Logger alog) throws Exception {
        Object msg;
        cache = new Cache(cacheType, RESPONSE_CACHING_CACHE_NAME);
        if (dimensioneCache != null && dimensioneCache > 0) {
            try {
                msg = "Dimensione della cache (ResponseCaching) impostata al valore: " + dimensioneCache;
                alog.info((String)msg);
                cache.setCacheSize(dimensioneCache.intValue());
            }
            catch (Exception error) {
                String msg2 = "Parametro errato per la dimensione della cache (ResponseCaching): " + error.getMessage();
                alog.error(msg2);
                throw new Exception(msg2, error);
            }
        }
        msg = "Algoritmo di cache (ResponseCaching) impostato al valore: LRU";
        if (!algoritmoCacheLRU) {
            msg = "Algoritmo di cache (ResponseCaching) impostato al valore: MRU";
        }
        alog.info((String)msg);
        if (!algoritmoCacheLRU) {
            cache.setCacheAlgoritm(CacheAlgorithm.MRU);
        } else {
            cache.setCacheAlgoritm(CacheAlgorithm.LRU);
        }
        if (itemIdleTime != null && itemIdleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (ResponseCaching) impostato al valore: " + itemIdleTime;
                alog.info((String)msg);
                cache.setItemIdleTime(itemIdleTime.longValue());
            }
            catch (Exception error) {
                msg = "Parametro errato per l'attributo 'IdleTime' (ResponseCaching): " + error.getMessage();
                alog.error((String)msg);
                throw new Exception((String)msg, error);
            }
        }
        long longItemLife = -1L;
        if (itemLifeSecond != null && itemLifeSecond > 0L) {
            longItemLife = itemLifeSecond;
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (ResponseCaching) impostato al valore: " + longItemLife;
            alog.info((String)msg);
            cache.setItemLifeTime(longItemLife);
        }
        catch (Exception error) {
            msg = "Parametro errato per l'attributo 'MaxLifeSecond' (ResponseCaching): " + error.getMessage();
            alog.error((String)msg);
            throw new Exception((String)msg, error);
        }
        cache.build();
    }

    @Deprecated
    public static void disableSyncronizedGet() throws UtilsException {
        if (cache == null) {
            throw new UtilsException("Cache disabled");
        }
        cache.disableSyncronizedGet();
    }

    @Deprecated
    public static boolean isDisableSyncronizedGet() throws UtilsException {
        if (cache == null) {
            throw new UtilsException("Cache disabled");
        }
        return cache.isDisableSyncronizedGet();
    }

    public static synchronized void initialize() {
        if (staticInstance == null) {
            staticInstance = new GestoreCacheResponseCaching();
        }
    }

    public static GestoreCacheResponseCaching getInstance() throws CoreException {
        if (staticInstance == null) {
            Class<GestoreCacheResponseCaching> clazz = GestoreCacheResponseCaching.class;
            synchronized (GestoreCacheResponseCaching.class) {
                throw new CoreException("GestoreCacheResponseCaching non inizializzato");
            }
        }
        return staticInstance;
    }

    private GestoreCacheResponseCaching() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String save(String digest, ResponseCached response) throws Exception {
        String uuid = null;
        try {
            if (cache == null) {
                throw new Exception("Cache per il salvataggio delle risposte non abilitata");
            }
            if (digest == null) {
                throw new Exception("Digest non definito");
            }
            if (response == null) {
                throw new Exception("Risposta non definita");
            }
            String digestKey = GestoreCacheResponseCaching.formatKeyDigest(digest);
            Object o = cache.get(digestKey);
            if (o != null) {
                CacheResponse responseCache = (CacheResponse)o;
                return ((ResponseCached)responseCache.getObject()).getUuid();
            }
            SemaphoreLock lock = lock_cache.acquire("save");
            try {
                o = cache.get(digestKey);
                if (o != null) {
                    CacheResponse responseCache = (CacheResponse)o;
                    String string = ((ResponseCached)responseCache.getObject()).getUuid();
                    return string;
                }
                uuid = UniqueIdentifierManager.newUniqueIdentifier().getAsString();
                String uuidKey = GestoreCacheResponseCaching.formatKeyUUID(uuid);
                try {
                    cache.put(uuidKey, (Serializable)((Object)digestKey));
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache con chiave [" + uuidKey + "] valore[" + digestKey + "]: " + e.getMessage());
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    response.setUuid(uuid);
                    response.setDigest(digest);
                    responseCache.setObject((Serializable)response);
                    cache.put(digestKey, responseCache);
                    return uuid;
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache con chiave [" + digestKey + "] della risposta: " + e.getMessage());
                    try {
                        cache.remove(uuidKey);
                        return uuid;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                        return uuid;
                    }
                }
            }
            finally {
                lock_cache.release(lock, "save");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("Salvataggio in Cache fallito: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseCached readByUUID(String uuid) throws Exception {
        try {
            Date now;
            if (cache == null) {
                throw new Exception("Cache per il salvataggio delle risposte non abilitata");
            }
            if (uuid == null) {
                throw new Exception("UUID non definito");
            }
            String uuidKey = GestoreCacheResponseCaching.formatKeyUUID(uuid);
            Object oDigest = cache.get(uuidKey);
            if (oDigest == null) {
                return null;
            }
            String digest = (String)oDigest;
            String digestKey = GestoreCacheResponseCaching.formatKeyDigest(digest);
            CacheResponse response = (CacheResponse)cache.get(digestKey);
            if (response != null && response.getObject() != null) {
                ResponseCached responseCached = (ResponseCached)response.getObject();
                now = DateManager.getDate();
                if (!now.after(responseCached.getScadenza())) return responseCached;
            }
            SemaphoreLock lock = lock_cache.acquire("readByUUID");
            try {
                oDigest = cache.get(uuidKey);
                if (oDigest == null) {
                    now = null;
                    return now;
                }
                digest = (String)oDigest;
                digestKey = GestoreCacheResponseCaching.formatKeyDigest(digest);
                response = (CacheResponse)cache.get(digestKey);
                if (response == null || response.getObject() == null) {
                    this.log.error("In cache non \u00e8 presente il mapping uuid (" + uuidKey + ") - digest (" + digestKey + ") ma poi non esiste l'oggetto??");
                    cache.remove(uuidKey);
                    now = null;
                    return now;
                }
                ResponseCached responseCached = (ResponseCached)response.getObject();
                Date now2 = DateManager.getDate();
                if (now2.after(responseCached.getScadenza())) {
                    SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
                    String scadenza = dateformat.format(responseCached.getScadenza());
                    String nowS = dateformat.format(now2);
                    this.log.debug("In cache \u00e8 presente un messaggio [uuid (" + uuidKey + ") - digest (" + digestKey + ")] scaduto (scadenza:" + scadenza + ") (now:" + nowS + ")");
                    cache.remove(uuidKey);
                    cache.remove(digestKey);
                    ResponseCached responseCached2 = null;
                    return responseCached2;
                }
                ResponseCached responseCached3 = responseCached;
                return responseCached3;
            }
            finally {
                lock_cache.release(lock, "readByUUID");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("Lettura messaggio in Cache fallito: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByUUID(String uuid) throws Exception {
        try {
            if (cache == null) {
                throw new Exception("Cache per il salvataggio delle risposte non abilitata");
            }
            if (uuid == null) {
                throw new Exception("UUID non definito");
            }
            String uuidKey = GestoreCacheResponseCaching.formatKeyUUID(uuid);
            Object oDigest = cache.get(uuidKey);
            if (oDigest == null) {
                return;
            }
            SemaphoreLock lock = lock_cache.acquire("removeByUUID");
            try {
                oDigest = cache.get(uuidKey);
                if (oDigest == null) {
                    return;
                }
                String digest = (String)oDigest;
                String digestKey = GestoreCacheResponseCaching.formatKeyDigest(digest);
                CacheResponse response = (CacheResponse)cache.get(digestKey);
                if (response == null || response.getObject() == null) {
                    this.log.error("In cache non \u00e8 presente il mapping uuid (" + uuidKey + ") - digest (" + digestKey + ") ma poi non esiste l'oggetto??");
                    cache.remove(uuidKey);
                    return;
                }
                cache.remove(uuidKey);
                cache.remove(digestKey);
            }
            finally {
                lock_cache.release(lock, "removeByUUID");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("Rimozione messaggio in Cache fallito: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseCached readByDigest(String digest) throws Exception {
        try {
            if (cache == null) {
                throw new Exception("Cache per il salvataggio delle risposte non abilitata");
            }
            if (digest == null) {
                throw new Exception("Digest non definito");
            }
            String digestKey = GestoreCacheResponseCaching.formatKeyDigest(digest);
            CacheResponse response = (CacheResponse)cache.get(digestKey);
            if (response == null) return null;
            if (response.getObject() == null) {
                return null;
            }
            ResponseCached responseCached = (ResponseCached)response.getObject();
            Date now = DateManager.getDate();
            if (!now.after(responseCached.getScadenza())) return responseCached;
            SemaphoreLock lock = lock_cache.acquire("readByDigest");
            try {
                response = (CacheResponse)cache.get(digestKey);
                if (response == null || response.getObject() == null) {
                    ResponseCached responseCached2 = null;
                    return responseCached2;
                }
                responseCached = (ResponseCached)response.getObject();
                now = DateManager.getDate();
                if (now.after(responseCached.getScadenza())) {
                    String uuidKey = GestoreCacheResponseCaching.formatKeyUUID(responseCached.getUuid());
                    SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
                    String scadenza = dateformat.format(responseCached.getScadenza());
                    String nowS = dateformat.format(now);
                    this.log.debug("In cache \u00e8 presente un messaggio [uuid (" + uuidKey + ") - digest (" + digestKey + ")] scaduto (scadenza:" + scadenza + ") (now:" + nowS + ")");
                    cache.remove(uuidKey);
                    cache.remove(digestKey);
                    ResponseCached responseCached3 = null;
                    return responseCached3;
                }
                ResponseCached responseCached4 = responseCached;
                return responseCached4;
            }
            finally {
                lock_cache.release(lock, "readByDigest");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Exception("Lettura messaggio in Cache fallito: " + e.getMessage(), e);
        }
    }

    public static String formatKeyUUID(String uuid) {
        String prefix = "uuid:";
        if (!uuid.startsWith(prefix)) {
            return prefix + uuid;
        }
        return uuid;
    }

    public static String formatKeyDigest(String digest) {
        String prefix = "digest:";
        if (!digest.startsWith(prefix)) {
            return prefix + digest;
        }
        return digest;
    }
}

