/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.utils.WWWAuthenticateErrorCode;
import org.openspcoop2.message.utils.WWWAuthenticateGenerator;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.token.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.DynamicDiscovery;
import org.openspcoop2.pdd.core.token.EsitoDynamicDiscovery;
import org.openspcoop2.pdd.core.token.EsitoGestioneToken;
import org.openspcoop2.pdd.core.token.EsitoNegoziazioneToken;
import org.openspcoop2.pdd.core.token.EsitoPresenzaToken;
import org.openspcoop2.pdd.core.token.GestoreTokenAttributeAuthorityUtilities;
import org.openspcoop2.pdd.core.token.GestoreTokenNegoziazioneUtilities;
import org.openspcoop2.pdd.core.token.GestoreTokenValidazioneUtilities;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken_DatiRichiesta;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.NegoziazioneTokenDynamicParameters;
import org.openspcoop2.pdd.core.token.NegoziazioneTokenProvider;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenCacheItem;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.TokenForward;
import org.openspcoop2.pdd.core.token.TokenProvider;
import org.openspcoop2.pdd.core.token.attribute_authority.AttributeAuthorityDynamicParameters;
import org.openspcoop2.pdd.core.token.attribute_authority.AttributeAuthorityProvider;
import org.openspcoop2.pdd.core.token.attribute_authority.EsitoRecuperoAttributi;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.core.token.attribute_authority.PolicyAttributeAuthority;
import org.openspcoop2.pdd.core.token.attribute_authority.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.token.attribute_authority.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.token.dpop.DPoPBackendCacheEntry;
import org.openspcoop2.pdd.core.token.dpop.DPoPParams;
import org.openspcoop2.pdd.core.token.dpop.EsitoDPoPBackend;
import org.openspcoop2.pdd.core.token.dpop.EsitoPresenzaDPoP;
import org.openspcoop2.pdd.core.token.dpop.EsitoValidazioneDPoP;
import org.openspcoop2.pdd.core.token.pa.EsitoPresenzaDPoPPortaApplicativa;
import org.openspcoop2.pdd.core.token.pa.EsitoPresenzaTokenPortaApplicativa;
import org.openspcoop2.pdd.core.token.pd.EsitoPresenzaDPoPPortaDelegata;
import org.openspcoop2.pdd.core.token.pd.EsitoPresenzaTokenPortaDelegata;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.RestMessageSecurityToken;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.jose.JOSEUtils;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class GestoreToken {
    public static final boolean PORTA_DELEGATA = true;
    public static final boolean PORTA_APPLICATIVA = false;
    private static final String GESTIONE_TOKEN_CACHE_NAME = "token";
    private static final String ATTRIBUTE_AUTHORITY_CACHE_NAME = "attributeAuthority";
    private static Cache cacheGestioneToken = null;
    private static Cache cacheAttributeAuthority = null;
    private static final Map<String, Semaphore> _lockDynamicDiscovery = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockJWT = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockIntrospection = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockUserInfo = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockNegoziazione = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockDPoPBackend = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockAttributeAuthority = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockGenericToken = new HashMap<String, Semaphore>();
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static Logger logger = null;
    private static Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
    private static final String MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE = "In cache non \u00e8 presente ne un oggetto ne un'eccezione.";
    static final String TOKEN_NON_VALIDO = "Token non valido";
    static final String CONNETTORE_RISPOSTA_NON_PERVENUTA = "; non \u00e8 pervenuta alcuna risposta";
    public static final String KEY_ALIAS_UNDEFINED = "JWT Signature key alias undefined";
    public static final String KEY_PASSWORD_UNDEFINED = "JWT Signature key password undefined";
    public static final String KEYSTORE_TYPE_UNDEFINED = "JWT Signature keystore type undefined";
    public static final String KEYSTORE_KEYPAIR_UNDEFINED = "JWT Signature keyPair undefined";
    public static final String KEYSTORE_KEYSTORE_UNDEFINED = "JWT Signature keystore undefined";
    public static final String KEYSTORE_KEYSTORE_FILE_UNDEFINED = "JWT Signature keystore file undefined";
    public static final String KEYSTORE_KEYSTORE_PASSWORD_UNDEFINED = "JWT Signature keystore password undefined";
    public static final String KEYSTORE_PRIVATE_KEY_UNDEFINED = "JWT Signature private key file undefined";
    public static final String KEYSTORE_PUBLIC_KEY_UNDEFINED = "JWT Signature public key file undefined";
    public static final String KEYSTORE_KEY_PAIR_ALGORITHM_UNDEFINED = "JWT Signature key pair algorithm undefined";
    private static final String INFO_TRASPORTO_NON_PRESENTI = "Informazioni di trasporto non presenti";
    private static final String CONTENENTE_IL_TOKEN = "contenente il token";
    private static final String CONTENENTE_IL_DPOP = "contenente il DPoP";
    public static final String DYNAMIC_DISCOVERY_FUNCTION = "DynamicDiscovery";
    public static final String VALIDAZIONE_JWT_FUNCTION = "ValidazioneJWT";
    public static final String INTROSPECTION_FUNCTION = "Introspection";
    public static final String USERINFO_FUNCTION = "UserInfo";
    public static final String RETRIEVE_FUNCTION = "Negoziazione";
    private static final String DPOP_BACKEND_FUNCTION = "DPoPBackend";
    public static final String ATTRIBUTE_AUTHORITY_FUNCTION = "AttributeAuthority";

    private GestoreToken() {
    }

    private static synchronized Semaphore initLockDynamicDiscovery(String nomePolicy) {
        Semaphore s = _lockDynamicDiscovery.get(nomePolicy);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneTokenDynamicDiscoveryLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenDynamicDiscovery_" + nomePolicy, permits.intValue()) : new Semaphore("GestoreTokenDynamicDiscovery_" + nomePolicy);
            _lockDynamicDiscovery.put(nomePolicy, s);
        }
        return s;
    }

    private static Semaphore getLockDynamicDiscovery(String nomePolicy) {
        Semaphore s = _lockDynamicDiscovery.get(nomePolicy);
        if (s == null) {
            s = GestoreToken.initLockDynamicDiscovery(nomePolicy);
        }
        return s;
    }

    private static synchronized Semaphore initLockJWT(String nomePolicy) {
        Semaphore s = _lockJWT.get(nomePolicy);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneTokenValidazioneJWTLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenValidazioneJWT_" + nomePolicy, permits.intValue()) : new Semaphore("GestoreTokenValidazioneJWT_" + nomePolicy);
            _lockJWT.put(nomePolicy, s);
        }
        return s;
    }

    private static Semaphore getLockJWT(String nomePolicy) {
        Semaphore s = _lockJWT.get(nomePolicy);
        if (s == null) {
            s = GestoreToken.initLockJWT(nomePolicy);
        }
        return s;
    }

    private static synchronized Semaphore initLockIntrospection(String nomePolicy) {
        Semaphore s = _lockIntrospection.get(nomePolicy);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneTokenIntrospectionLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenIntrospection_" + nomePolicy, permits.intValue()) : new Semaphore("GestoreTokenIntrospection_" + nomePolicy);
            _lockIntrospection.put(nomePolicy, s);
        }
        return s;
    }

    private static Semaphore getLockIntrospection(String nomePolicy) {
        Semaphore s = _lockIntrospection.get(nomePolicy);
        if (s == null) {
            s = GestoreToken.initLockIntrospection(nomePolicy);
        }
        return s;
    }

    private static synchronized Semaphore initLockUserInfo(String nomePolicy) {
        Semaphore s = _lockUserInfo.get(nomePolicy);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneTokenUserInfoLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenUserInfo_" + nomePolicy, permits.intValue()) : new Semaphore("GestoreTokenUserInfo_" + nomePolicy);
            _lockUserInfo.put(nomePolicy, s);
        }
        return s;
    }

    private static Semaphore getLockUserInfo(String nomePolicy) {
        Semaphore s = _lockUserInfo.get(nomePolicy);
        if (s == null) {
            s = GestoreToken.initLockUserInfo(nomePolicy);
        }
        return s;
    }

    private static synchronized Semaphore initLockNegoziazione(String nomePolicy) {
        Semaphore s = _lockNegoziazione.get(nomePolicy);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneRetrieveTokenLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenNegoziazione_" + nomePolicy, permits.intValue()) : new Semaphore("GestoreTokenNegoziazione_" + nomePolicy);
            _lockNegoziazione.put(nomePolicy, s);
        }
        return s;
    }

    private static Semaphore getLockNegoziazione(String nomePolicy) {
        Semaphore s = _lockNegoziazione.get(nomePolicy);
        if (s == null) {
            s = GestoreToken.initLockNegoziazione(nomePolicy);
        }
        return s;
    }

    private static synchronized Semaphore initLockDPoPBackend(String keyCache) {
        Semaphore s = _lockDPoPBackend.get(keyCache);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneRetrieveTokenLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenDPoPBackend_" + keyCache, permits.intValue()) : new Semaphore("GestoreTokenDPoPBackend_" + keyCache);
            _lockDPoPBackend.put(keyCache, s);
        }
        return s;
    }

    private static Semaphore getLockDPoPBackend(String keyCache) {
        Semaphore s = _lockDPoPBackend.get(keyCache);
        if (s == null) {
            s = GestoreToken.initLockDPoPBackend(keyCache);
        }
        return s;
    }

    private static synchronized Semaphore initLockAttributeAuthority(String nomePolicy) {
        Semaphore s = _lockAttributeAuthority.get(nomePolicy);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneAttributeAuthorityLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreTokenAttributeAuthority_" + nomePolicy, permits.intValue()) : new Semaphore("GestoreTokenAttributeAuthority_" + nomePolicy);
            _lockAttributeAuthority.put(nomePolicy, s);
        }
        return s;
    }

    private static Semaphore getLockAttributeAuthority(String nomePolicy) {
        Semaphore s = _lockAttributeAuthority.get(nomePolicy);
        if (s == null) {
            s = GestoreToken.initLockAttributeAuthority(nomePolicy);
        }
        return s;
    }

    private static synchronized Semaphore initLockGenericToken(String funzione) {
        Semaphore s = _lockGenericToken.get(funzione);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getGestioneRetrieveTokenLockPermits();
            s = permits != null && permits > 1 ? new Semaphore("GestoreGenericTokenCache_" + funzione, permits.intValue()) : new Semaphore("GestoreGenericTokenCache_" + funzione);
            _lockGenericToken.put(funzione, s);
        }
        return s;
    }

    private static Semaphore getLockGenericToken(String nomePolicy) {
        Semaphore s = _lockGenericToken.get(nomePolicy);
        if (s == null) {
            s = GestoreToken.initLockGenericToken(nomePolicy);
        }
        return s;
    }

    private static void loggerDebug(String msg) {
        logger.debug(msg);
    }

    private static void loggerInfo(String msg) {
        logger.info(msg);
    }

    private static void loggerError(String msg) {
        logger.error(msg);
    }

    private static void loggerError(String msg, Exception e) {
        logger.error(msg, (Throwable)e);
    }

    private static String getMessageObjectInCache(CacheResponse response, String keyCache, String funzione) {
        return "Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:" + funzione + ") in cache.";
    }

    private static String getMessageEccezioneInCache(CacheResponse response, String keyCache, String funzione) {
        return "Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:" + funzione + ") in cache.";
    }

    static String getMessageTokenNonValido(Exception e) {
        return "Token non valido: " + e.getMessage();
    }

    static String getMessageViaProxy(String hostProxy, String portProxy) {
        return " [via Proxy: " + hostProxy + ":" + portProxy + "] ";
    }

    static String getMessageErroreGovWayProxy(Exception e) {
        return "Configurazione errata per la funzionalit\u00e0 govway-proxy; " + e.getMessage();
    }

    static String getMessageConnettoreConnessioneSuccesso(ConnettoreBaseHTTP connettore) {
        return "Connessione completata con successo (codice trasporto: " + connettore.getCodiceTrasporto() + ")";
    }

    static String getMessageConnettoreConnessioneErrore(ConnettoreBaseHTTP connettore) {
        return "Connessione terminata con errore (codice trasporto: " + connettore.getCodiceTrasporto() + ")";
    }

    static void addProperties(ConnettoreMsg connettoreMsg, Properties p) {
        if (p != null && p.size() > 0) {
            Enumeration<?> en = p.propertyNames();
            while (en.hasMoreElements()) {
                Object oKey = en.nextElement();
                if (oKey == null) continue;
                String key = (String)oKey;
                String value = p.getProperty(key);
                connettoreMsg.getConnectorProperties().put(key, value);
            }
        }
    }

    private static String getPrefixOggettoConChiave(String key) {
        return "oggetto con chiave [" + key + "]";
    }

    private static String getSuffixEseguiOperazione(String funzione) {
        return " (method:" + funzione + ") eseguo operazione...";
    }

    private static String getMessaggioAggiuntaOggettoInCache(String keyCache) {
        return "Aggiungo oggetto [" + keyCache + "] in cache";
    }

    private static String getMessaggioErroreInserimentoInCache(String keyCache, Exception e) {
        return "Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage();
    }

    private static String getMessaggioErroreValoreEsitoNull(String funzione) {
        return "Metodo (GestoreToken." + funzione + ") ha ritornato un valore di esito null";
    }

    public static void resetGestioneTokenCache() throws TokenException {
        if (cacheGestioneToken != null) {
            try {
                cacheGestioneToken.clear();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
    }

    public static void resetAttributeAuthorityCache() throws TokenException {
        if (cacheAttributeAuthority != null) {
            try {
                cacheAttributeAuthority.clear();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
    }

    public static String printStatsGestioneTokenCache(String separator) throws TokenException {
        try {
            if (cacheGestioneToken != null) {
                return cacheGestioneToken.printStats(separator);
            }
            throw new TokenException("Cache non abilitata");
        }
        catch (Exception e) {
            throw new TokenException("Visualizzazione Statistiche riguardante la cache sulla gestione dei token non riuscita: " + e.getMessage(), e);
        }
    }

    public static String printStatsAttributeAuthorityCache(String separator) throws TokenException {
        try {
            if (cacheAttributeAuthority != null) {
                return cacheAttributeAuthority.printStats(separator);
            }
            throw new TokenException("Cache non abilitata");
        }
        catch (Exception e) {
            throw new TokenException("Visualizzazione Statistiche riguardante la cache sui dati delle Attribute Authority non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaGestioneTokenCache() throws TokenException {
        if (cacheGestioneToken != null) {
            throw new TokenException("Cache gi\u00e0 abilitata");
        }
        GestoreToken.abilitaGestioneTokenCacheEngine();
    }

    public static void abilitaAttributeAuthorityCache() throws TokenException {
        if (cacheAttributeAuthority != null) {
            throw new TokenException("Cache gi\u00e0 abilitata");
        }
        GestoreToken.abilitaAttributeAuthorityCacheEngine();
    }

    private static synchronized void abilitaGestioneTokenCacheEngine() throws TokenException {
        if (cacheGestioneToken == null) {
            try {
                cacheGestioneToken = new Cache(CacheType.JCS, GESTIONE_TOKEN_CACHE_NAME);
                cacheGestioneToken.build();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
    }

    private static synchronized void abilitaAttributeAuthorityCacheEngine() throws TokenException {
        if (cacheAttributeAuthority == null) {
            try {
                cacheAttributeAuthority = new Cache(CacheType.JCS, ATTRIBUTE_AUTHORITY_CACHE_NAME);
                cacheAttributeAuthority.build();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
    }

    public static void abilitaGestioneTokenCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws TokenException {
        if (cacheGestioneToken != null) {
            throw new TokenException("Cache gi\u00e0 abilitata");
        }
        try {
            GestoreToken.setGestioneTokenCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    public static void abilitaAttributeAuthorityCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws TokenException {
        if (cacheAttributeAuthority != null) {
            throw new TokenException("Cache gi\u00e0 abilitata");
        }
        try {
            GestoreToken.setAttributeAuthorityCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
    }

    private static void setGestioneTokenCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws TokenException, UtilsException {
        int dimensioneCacheInt = -1;
        if (dimensioneCache != null) {
            dimensioneCacheInt = dimensioneCache.intValue();
        }
        String algoritmoCache = null;
        algoritmoCache = algoritmoCacheLRU != null ? (algoritmoCacheLRU.booleanValue() ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString()) : CostantiConfigurazione.CACHE_LRU.toString();
        long itemIdleTimeLong = -1L;
        if (itemIdleTime != null) {
            itemIdleTimeLong = itemIdleTime;
        }
        long itemLifeSecondLong = -1L;
        if (itemLifeSecond != null) {
            itemLifeSecondLong = itemLifeSecond;
        }
        GestoreToken.initGestioneTokenCacheToken(CacheType.JCS, dimensioneCacheInt, algoritmoCache, itemIdleTimeLong, itemLifeSecondLong, null);
    }

    private static void setAttributeAuthorityCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws TokenException, UtilsException {
        int dimensioneCacheInt = -1;
        if (dimensioneCache != null) {
            dimensioneCacheInt = dimensioneCache.intValue();
        }
        String algoritmoCache = null;
        algoritmoCache = algoritmoCacheLRU != null ? (algoritmoCacheLRU.booleanValue() ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString()) : CostantiConfigurazione.CACHE_LRU.toString();
        long itemIdleTimeLong = -1L;
        if (itemIdleTime != null) {
            itemIdleTimeLong = itemIdleTime;
        }
        long itemLifeSecondLong = -1L;
        if (itemLifeSecond != null) {
            itemLifeSecondLong = itemLifeSecond;
        }
        GestoreToken.initAttributeAuthorityCacheToken(CacheType.JCS, dimensioneCacheInt, algoritmoCache, itemIdleTimeLong, itemLifeSecondLong, null);
    }

    public static void disabilitaGestioneTokenCache() throws TokenException {
        if (cacheGestioneToken == null) {
            throw new TokenException("Cache gi\u00e0 disabilitata");
        }
        GestoreToken.disabilitaGestioneTokenCacheEngine();
    }

    public static void disabilitaAttributeAuthorityCache() throws TokenException {
        if (cacheAttributeAuthority == null) {
            throw new TokenException("Cache gi\u00e0 disabilitata");
        }
        GestoreToken.disabilitaAttributeAuthorityCacheEngine();
    }

    private static synchronized void disabilitaGestioneTokenCacheEngine() throws TokenException {
        if (cacheGestioneToken != null) {
            try {
                cacheGestioneToken.clear();
                cacheGestioneToken = null;
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
    }

    private static synchronized void disabilitaAttributeAuthorityCacheEngine() throws TokenException {
        if (cacheAttributeAuthority != null) {
            try {
                cacheAttributeAuthority.clear();
                cacheAttributeAuthority = null;
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
    }

    public static boolean isGestioneTokenCacheAbilitata() {
        return cacheGestioneToken != null;
    }

    public static boolean isAttributeAuthorityCacheAbilitata() {
        return cacheAttributeAuthority != null;
    }

    public static String listKeysGestioneTokenCache(String separator) throws TokenException {
        if (cacheGestioneToken != null) {
            try {
                return cacheGestioneToken.printKeys(separator);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        throw new TokenException("Cache non abilitata");
    }

    public static String listKeysAttributeAuthorityCache(String separator) throws TokenException {
        if (cacheAttributeAuthority != null) {
            try {
                return cacheAttributeAuthority.printKeys(separator);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        throw new TokenException("Cache non abilitata");
    }

    public static List<String> keysGestioneTokenCache() throws TokenException {
        if (cacheGestioneToken != null) {
            try {
                return cacheGestioneToken.keys();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        throw new TokenException("Cache non abilitata");
    }

    public static List<String> keysAttributeAuthorityCache() throws TokenException {
        if (cacheAttributeAuthority != null) {
            try {
                return cacheAttributeAuthority.keys();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        throw new TokenException("Cache non abilitata");
    }

    public static String getObjectGestioneTokenCache(String key) throws TokenException {
        if (cacheGestioneToken != null) {
            try {
                Object o = cacheGestioneToken.get(key);
                if (o != null) {
                    return o.toString();
                }
                return GestoreToken.getPrefixOggettoConChiave(key) + " non presente";
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        throw new TokenException("Cache non abilitata");
    }

    public static String getObjectAttributeAuthorityCache(String key) throws TokenException {
        if (cacheAttributeAuthority != null) {
            try {
                Object o = cacheAttributeAuthority.get(key);
                if (o != null) {
                    return o.toString();
                }
                return GestoreToken.getPrefixOggettoConChiave(key) + " non presente";
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        throw new TokenException("Cache non abilitata");
    }

    public static void removeObjectGestioneTokenCache(String key) throws TokenException {
        if (cacheGestioneToken != null) {
            try {
                cacheGestioneToken.remove(key);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        } else {
            throw new TokenException("Cache non abilitata");
        }
    }

    public static void removeObjectAttributeAuthorityCache(String key) throws TokenException {
        if (cacheAttributeAuthority != null) {
            try {
                cacheAttributeAuthority.remove(key);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        } else {
            throw new TokenException("Cache non abilitata");
        }
    }

    public static void removeGenericPropertiesGestioneToken(IDGenericProperties idGP) throws TokenException {
        if (GestoreToken.isGestioneTokenCacheAbilitata()) {
            String prefixKeyValidazioneJwt = null;
            String prefixKeyIntrospection = null;
            String prefixKeyUserInfo = null;
            String prefixKeyRetrieveToken = null;
            boolean checkKeys = false;
            if ("gestionePolicyToken".equals(idGP.getTipologia())) {
                prefixKeyValidazioneJwt = GestoreTokenValidazioneUtilities.buildPrefixCacheKeyValidazione(idGP.getNome(), VALIDAZIONE_JWT_FUNCTION);
                prefixKeyIntrospection = GestoreTokenValidazioneUtilities.buildPrefixCacheKeyValidazione(idGP.getNome(), INTROSPECTION_FUNCTION);
                prefixKeyUserInfo = GestoreTokenValidazioneUtilities.buildPrefixCacheKeyValidazione(idGP.getNome(), USERINFO_FUNCTION);
                checkKeys = true;
            } else if ("retrievePolicyToken".equals(idGP.getTipologia())) {
                prefixKeyRetrieveToken = GestoreTokenNegoziazioneUtilities.buildPrefixCacheKeyNegoziazione(idGP.getNome(), RETRIEVE_FUNCTION);
                checkKeys = true;
            }
            if (checkKeys) {
                GestoreToken.checkKeys(prefixKeyValidazioneJwt, prefixKeyIntrospection, prefixKeyUserInfo, prefixKeyRetrieveToken);
            }
        }
    }

    public static void removeGenericPropertiesAttributeAuthority(IDGenericProperties idGP) throws TokenException {
        if (GestoreToken.isAttributeAuthorityCacheAbilitata()) {
            String prefixKeyAA = null;
            boolean checkKeys = false;
            if (ATTRIBUTE_AUTHORITY_CACHE_NAME.equals(idGP.getTipologia())) {
                prefixKeyAA = GestoreTokenAttributeAuthorityUtilities.buildCacheKeyRecuperoAttributiPrefix(idGP.getNome(), ATTRIBUTE_AUTHORITY_FUNCTION);
                checkKeys = true;
            }
            if (checkKeys) {
                GestoreToken.checkKeys(prefixKeyAA);
            }
        }
    }

    private static void checkKeys(String prefixKeyValidazioneJwt, String prefixKeyIntrospection, String prefixKeyUserInfo, String prefixKeyRetrieveToken) throws TokenException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List<String> keys = GestoreToken.keysGestioneTokenCache();
        if (keys != null && !keys.isEmpty()) {
            GestoreToken.fillKeyForClean(prefixKeyValidazioneJwt, prefixKeyIntrospection, prefixKeyUserInfo, prefixKeyRetrieveToken, null, keys, keyForClean);
        }
        if (!keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                GestoreToken.removeObjectGestioneTokenCache(key);
            }
        }
    }

    private static void checkKeys(String prefixKeyAA) throws TokenException {
        ArrayList<String> keyForClean = new ArrayList<String>();
        List<String> keys = GestoreToken.keysAttributeAuthorityCache();
        if (keys != null && !keys.isEmpty()) {
            GestoreToken.fillKeyForClean(null, null, null, null, prefixKeyAA, keys, keyForClean);
        }
        if (!keyForClean.isEmpty()) {
            for (String key : keyForClean) {
                GestoreToken.removeObjectAttributeAuthorityCache(key);
            }
        }
    }

    private static void fillKeyForClean(String prefixKeyValidazioneJwt, String prefixKeyIntrospection, String prefixKeyUserInfo, String prefixKeyRetrieveToken, String prefixKeyAA, List<String> keys, List<String> keyForClean) {
        for (String key : keys) {
            if (key == null || !(prefixKeyValidazioneJwt != null && key.startsWith(prefixKeyValidazioneJwt) || prefixKeyIntrospection != null && key.startsWith(prefixKeyIntrospection) || prefixKeyUserInfo != null && key.startsWith(prefixKeyUserInfo) || prefixKeyRetrieveToken != null && key.startsWith(prefixKeyRetrieveToken)) && (prefixKeyAA == null || !key.startsWith(prefixKeyAA))) continue;
            keyForClean.add(key);
        }
    }

    public static void initializeGestioneToken(Logger log) throws TokenException, UtilsException {
        GestoreToken.initializeGestioneToken(null, false, -1, null, -1L, -1L, log);
    }

    public static void initializeGestioneToken(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws TokenException, UtilsException {
        GestoreToken.initializeGestioneToken(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initializeGestioneToken(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws TokenException, UtilsException {
        logger = log;
        if (cacheAbilitata) {
            GestoreToken.initGestioneTokenCacheToken(cacheType, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
    }

    public static void initializeAttributeAuthority(Logger log) throws TokenException, UtilsException {
        GestoreToken.initializeAttributeAuthority(null, false, -1, null, -1L, -1L, log);
    }

    public static void initializeAttributeAuthority(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws TokenException, UtilsException {
        GestoreToken.initializeAttributeAuthority(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initializeAttributeAuthority(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws TokenException, UtilsException {
        logger = log;
        if (cacheAbilitata) {
            GestoreToken.initAttributeAuthorityCacheToken(cacheType, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
    }

    public static void initGestioneTokenCacheToken(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws TokenException, UtilsException {
        String msg;
        if (log != null) {
            log.info("Inizializzazione cache GestioneToken");
        }
        cacheGestioneToken = new Cache(cacheType, GESTIONE_TOKEN_CACHE_NAME);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            GestoreToken.initGestioneTokenCacheSize(dimensioneCache, algoritmoCache, log);
        }
        if (idleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (Token) impostato al valore: " + idleTime;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                cacheGestioneToken.setItemIdleTime(idleTime);
            }
            catch (Exception error) {
                throw new TokenException("Parametro errato per l'attributo 'IdleTime' (Token): " + error.getMessage(), error);
            }
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (Token) impostato al valore: " + itemLifeSecond;
            if (log != null) {
                log.info(msg);
            }
            logConsole.info(msg);
            cacheGestioneToken.setItemLifeTime(itemLifeSecond);
        }
        catch (Exception error) {
            throw new TokenException("Parametro errato per l'attributo 'MaxLifeSecond' (Token): " + error.getMessage(), error);
        }
        cacheGestioneToken.build();
    }

    public static void initAttributeAuthorityCacheToken(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws TokenException, UtilsException {
        String msg;
        if (log != null) {
            log.info("Inizializzazione cache Token");
        }
        cacheAttributeAuthority = new Cache(cacheType, ATTRIBUTE_AUTHORITY_CACHE_NAME);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            GestoreToken.initCacheSize(dimensioneCache, algoritmoCache, log);
        }
        if (idleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (AttributeAuthority) impostato al valore: " + idleTime;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                cacheAttributeAuthority.setItemIdleTime(idleTime);
            }
            catch (Exception error) {
                throw new TokenException("Parametro errato per l'attributo 'IdleTime' (AttributeAuthority): " + error.getMessage(), error);
            }
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (AttributeAuthority) impostato al valore: " + itemLifeSecond;
            if (log != null) {
                log.info(msg);
            }
            logConsole.info(msg);
            cacheAttributeAuthority.setItemLifeTime(itemLifeSecond);
        }
        catch (Exception error) {
            throw new TokenException("Parametro errato per l'attributo 'MaxLifeSecond' (AttributeAuthority): " + error.getMessage(), error);
        }
        cacheAttributeAuthority.build();
    }

    public static void initGestioneTokenCacheSize(int dimensioneCache, String algoritmoCache, Logger log) throws TokenException {
        String msg;
        if (dimensioneCache > 0) {
            try {
                msg = "Dimensione della cache (Token) impostata al valore: " + dimensioneCache;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                cacheGestioneToken.setCacheSize(dimensioneCache);
            }
            catch (Exception error) {
                throw new TokenException("Parametro errato per la dimensione della cache (Token): " + error.getMessage(), error);
            }
        }
        if (algoritmoCache != null) {
            msg = "Algoritmo di cache (Token) impostato al valore: " + algoritmoCache;
            if (log != null) {
                log.info(msg);
            }
            logConsole.info(msg);
            if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                cacheGestioneToken.setCacheAlgoritm(CacheAlgorithm.MRU);
            } else {
                cacheGestioneToken.setCacheAlgoritm(CacheAlgorithm.LRU);
            }
        }
    }

    public static void initCacheSize(int dimensioneCache, String algoritmoCache, Logger log) throws TokenException {
        String msg;
        if (dimensioneCache > 0) {
            try {
                msg = "Dimensione della cache (AttributeAuthority) impostata al valore: " + dimensioneCache;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                cacheAttributeAuthority.setCacheSize(dimensioneCache);
            }
            catch (Exception error) {
                throw new TokenException("Parametro errato per la dimensione della cache (AttributeAuthority): " + error.getMessage(), error);
            }
        }
        if (algoritmoCache != null) {
            msg = "Algoritmo di cache (AttributeAuthority) impostato al valore: " + algoritmoCache;
            if (log != null) {
                log.info(msg);
            }
            logConsole.info(msg);
            if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                cacheAttributeAuthority.setCacheAlgoritm(CacheAlgorithm.MRU);
            } else {
                cacheAttributeAuthority.setCacheAlgoritm(CacheAlgorithm.LRU);
            }
        }
    }

    public static void validazioneConfigurazione(AbstractDatiInvocazione datiInvocazione) throws ProviderException, ProviderValidationException {
        TokenProvider p = new TokenProvider();
        p.validate(datiInvocazione.getPolicyGestioneToken().getProperties());
    }

    private static String getDettaglioErroreHeaderPresentePiuVolte(String nome) {
        return "Sono stati rilevati pi\u00f9 di un header http '" + nome + "'";
    }

    private static String getDettaglioErroreHeaderPrefixErrato(String nome, String authPrefix, String primaryPrefix) {
        return "Riscontrato header http '" + nome + "' valorizzato tramite autenticazione '" + authPrefix + "'; la configurazione richiede invece la presenza di un token valorizzato tramite autenticazione '" + primaryPrefix + "' ";
    }

    public static EsitoPresenzaToken verificaPosizioneToken(AbstractDatiInvocazione datiInvocazione, boolean portaDelegata) {
        EsitoPresenzaToken esitoPresenzaToken = null;
        esitoPresenzaToken = portaDelegata ? new EsitoPresenzaTokenPortaDelegata() : new EsitoPresenzaTokenPortaApplicativa();
        esitoPresenzaToken.setPresente(false);
        try {
            List values;
            PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
            String source = policyGestioneToken.getTokenSource();
            String token = null;
            Object detailsErrorHeader = null;
            if ("RFC6750".equals(source) || "RFC6750_header".equals(source) || "CUSTOM_header".equals(source)) {
                if (datiInvocazione.getInfoConnettoreIngresso() == null || datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext() == null) {
                    detailsErrorHeader = INFO_TRASPORTO_NON_PRESENTI;
                } else {
                    URLProtocolContext urlProtocolContext = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext();
                    if (urlProtocolContext.getHeaders() == null || urlProtocolContext.getHeaders().size() <= 0) {
                        detailsErrorHeader = "Header di trasporto non presenti";
                    }
                    if ("RFC6750".equals(source) || "RFC6750_header".equals(source)) {
                        boolean dpopValidationEnabled = policyGestioneToken.isDPoPValidation();
                        boolean acceptBearerPrefix = dpopValidationEnabled && OpenSPCoop2Properties.getInstance().isGestioneTokenDPoPRfc6750AcceptBearerPrefix();
                        String primaryPrefix = dpopValidationEnabled ? "DPoP " : "Bearer ";
                        List authValues = urlProtocolContext.getHeaderValues("Authorization");
                        if (authValues != null && !authValues.isEmpty()) {
                            if (authValues.size() > 1) {
                                detailsErrorHeader = GestoreToken.getDettaglioErroreHeaderPresentePiuVolte("Authorization");
                            } else {
                                String authHeader = (String)authValues.get(0);
                                if (authHeader != null && authHeader.length() > 0) {
                                    if (authHeader.startsWith(primaryPrefix)) {
                                        token = authHeader.substring(primaryPrefix.length());
                                        esitoPresenzaToken.setHeaderHttp("Authorization");
                                    } else if (acceptBearerPrefix && authHeader.startsWith("Bearer ")) {
                                        token = authHeader.substring("Bearer ".length());
                                        esitoPresenzaToken.setHeaderHttp("Authorization");
                                    } else if (authHeader.startsWith("Basic ")) {
                                        detailsErrorHeader = GestoreToken.getDettaglioErroreHeaderPrefixErrato("Authorization", "Basic ", primaryPrefix);
                                    } else if (authHeader.startsWith("Bearer ") || authHeader.startsWith("DPoP ")) {
                                        String foundPrefix = authHeader.startsWith("Bearer ") ? "Bearer " : "DPoP ";
                                        detailsErrorHeader = GestoreToken.getDettaglioErroreHeaderPrefixErrato("Authorization", foundPrefix, primaryPrefix);
                                    } else {
                                        String detectedPrefix = authHeader.split("\\s+")[0];
                                        String expectedDescription = acceptBearerPrefix ? "'" + primaryPrefix + "' o 'Bearer '" : "'" + primaryPrefix + "'";
                                        detailsErrorHeader = GestoreToken.getDettaglioErroreHeaderPrefixErrato("Authorization", detectedPrefix, expectedDescription);
                                    }
                                } else {
                                    detailsErrorHeader = "Header http 'Authorization' presente ma vuoto";
                                }
                            }
                        } else {
                            String expectedDescription = acceptBearerPrefix ? "'" + primaryPrefix + "' o 'Bearer '" : "'" + primaryPrefix + "'";
                            detailsErrorHeader = "Non \u00e8 stato riscontrato un header http 'Authorization' valorizzato tramite autenticazione " + expectedDescription + " e contenente un token";
                        }
                    } else {
                        String headerName = policyGestioneToken.getTokenSourceHeaderName();
                        List values2 = urlProtocolContext.getHeaderValues(headerName);
                        if (values2 != null && !values2.isEmpty()) {
                            token = (String)values2.get(0);
                        }
                        if (token == null) {
                            detailsErrorHeader = "Non \u00e8 stato riscontrato l'header http '" + headerName + "' contenente il token";
                        } else if (values2.size() > 1) {
                            detailsErrorHeader = GestoreToken.getDettaglioErroreHeaderPresentePiuVolte(headerName);
                        } else {
                            esitoPresenzaToken.setHeaderHttp(headerName);
                        }
                    }
                }
            }
            Object detailsErrorUrl = null;
            if (token == null && "RFC6750".equals(source) || "RFC6750_url".equals(source) || "CUSTOM_url".equals(source)) {
                if (datiInvocazione.getInfoConnettoreIngresso() == null || datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext() == null) {
                    detailsErrorUrl = INFO_TRASPORTO_NON_PRESENTI;
                } else {
                    URLProtocolContext urlProtocolContext = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext();
                    if (urlProtocolContext.getParameters() == null || urlProtocolContext.getParameters().size() <= 0) {
                        detailsErrorUrl = "Parametri nella URL non presenti";
                    }
                    String propertyUrlName = null;
                    propertyUrlName = "RFC6750".equals(source) || "RFC6750_url".equals(source) ? "access_token" : policyGestioneToken.getTokenSourceUrlPropertyName();
                    values = urlProtocolContext.getParameterValues(propertyUrlName);
                    if (values != null && !values.isEmpty()) {
                        token = (String)values.get(0);
                    }
                    if (token == null) {
                        detailsErrorUrl = "Non \u00e8 stato riscontrata la propriet\u00e0 della URL '" + propertyUrlName + "' contenente il token";
                    } else if (values.size() > 1) {
                        detailsErrorHeader = "Sono state rilevate pi\u00f9 propriet\u00e0 della URL '" + propertyUrlName + "'";
                    } else {
                        esitoPresenzaToken.setPropertyUrl(propertyUrlName);
                    }
                }
            }
            String detailsErrorForm = null;
            if (token == null && "RFC6750".equals(source) || "RFC6750_form".equals(source)) {
                if (datiInvocazione.getInfoConnettoreIngresso() == null || datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext() == null || datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext().getHttpServletRequest() == null) {
                    detailsErrorForm = INFO_TRASPORTO_NON_PRESENTI;
                } else {
                    HttpServletRequest httpServletRequest = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext().getHttpServletRequest();
                    if (httpServletRequest instanceof FormUrlEncodedHttpServletRequest) {
                        FormUrlEncodedHttpServletRequest form = (FormUrlEncodedHttpServletRequest)httpServletRequest;
                        List<String> values3 = form.getFormUrlEncodedParameterValues("access_token");
                        if (values3 != null && !values3.isEmpty()) {
                            token = values3.get(0);
                        }
                        if (token == null) {
                            detailsErrorForm = "Non \u00e8 stato riscontrata la propriet\u00e0 della Form 'access_token' contenente il token";
                        } else if (values3.size() > 1) {
                            detailsErrorHeader = "Sono state rilevate pi\u00f9 propriet\u00e0 della Form 'access_token'";
                        } else {
                            esitoPresenzaToken.setPropertyFormBased("access_token");
                        }
                    } else if (FormUrlEncodedHttpServletRequest.isFormUrlEncodedRequest(httpServletRequest)) {
                        values = TransportUtils.getParameterValues((HttpServletRequest)httpServletRequest, (String)"access_token");
                        if (values != null && !values.isEmpty()) {
                            token = (String)values.get(0);
                        }
                        if (token == null) {
                            detailsErrorForm = "Non \u00e8 stato riscontrata la propriet\u00e0 della Form 'access_token' contenente il token";
                        } else if (values.size() > 1) {
                            detailsErrorHeader = "Sono state rilevate pi\u00f9 propriet\u00e0 della Form 'access_token'";
                        } else {
                            esitoPresenzaToken.setPropertyFormBased("access_token");
                        }
                    } else {
                        detailsErrorForm = "Non \u00e8 stato riscontrata la presenza di un contenuto 'Form-Encoded'";
                    }
                }
            }
            Object detailsError = null;
            if (detailsErrorHeader != null) {
                if ("RFC6750".equals(source)) {
                    detailsError = detailsErrorUrl != null || detailsErrorForm != null ? "\n" : "";
                    detailsError = (String)detailsError + "(Authorization Request Header) " + (String)detailsErrorHeader;
                } else {
                    detailsError = detailsErrorHeader;
                }
            }
            if (detailsErrorUrl != null) {
                if ("RFC6750".equals(source)) {
                    detailsError = detailsError != null ? (String)detailsError + "\n" : (detailsErrorForm != null ? "\n" : "");
                    detailsError = (String)detailsError + "(URI Query Parameter) " + (String)detailsErrorUrl;
                } else {
                    detailsError = detailsErrorUrl;
                }
            }
            if (detailsErrorForm != null) {
                if ("RFC6750".equals(source)) {
                    detailsError = detailsError != null ? (String)detailsError + "\n" : "";
                    detailsError = (String)detailsError + "(Form-Encoded Body Parameter) " + detailsErrorForm;
                } else {
                    detailsError = detailsErrorForm;
                }
            }
            if (token != null) {
                esitoPresenzaToken.setToken(token);
                esitoPresenzaToken.setPresente(true);
            } else {
                if (detailsError != null) {
                    esitoPresenzaToken.setDetails((String)detailsError);
                } else {
                    esitoPresenzaToken.setDetails("Token non individuato tramite la configurazione indicata");
                }
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoPresenzaToken.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_request, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoPresenzaToken.getDetails(), (String[])new String[0]));
                } else {
                    esitoPresenzaToken.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_request, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoPresenzaToken.getDetails(), (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            esitoPresenzaToken.setDetails(e.getMessage());
            esitoPresenzaToken.setEccezioneProcessamento(e);
        }
        return esitoPresenzaToken;
    }

    public static EsitoPresenzaDPoP verificaPostazioneDPoP(AbstractDatiInvocazione datiInvocazione, boolean portaDelegata) {
        EsitoPresenzaDPoP esitoPresenzaDPoP = null;
        esitoPresenzaDPoP = portaDelegata ? new EsitoPresenzaDPoPPortaDelegata() : new EsitoPresenzaDPoPPortaApplicativa();
        esitoPresenzaDPoP.setPresente(false);
        try {
            PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
            String source = policyGestioneToken.getDPoPSource();
            String dpopToken = null;
            Object detailsErrorHeader = null;
            if ("RFC9449_header".equals(source) || "CUSTOM_header".equals(source)) {
                if (datiInvocazione.getInfoConnettoreIngresso() == null || datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext() == null) {
                    detailsErrorHeader = INFO_TRASPORTO_NON_PRESENTI;
                } else {
                    URLProtocolContext urlProtocolContext = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext();
                    if (urlProtocolContext.getHeaders() == null || urlProtocolContext.getHeaders().size() <= 0) {
                        detailsErrorHeader = "Header di trasporto non presenti";
                    }
                    String headerName = null;
                    headerName = "RFC9449_header".equals(source) ? "DPoP" : policyGestioneToken.getDPoPSourceHeaderName();
                    List values = urlProtocolContext.getHeaderValues(headerName);
                    if (values != null && !values.isEmpty()) {
                        dpopToken = (String)values.get(0);
                    }
                    if (dpopToken == null) {
                        detailsErrorHeader = "Non \u00e8 stato riscontrato l'header http '" + headerName + "' contenente il DPoP";
                    } else if (values.size() > 1) {
                        detailsErrorHeader = GestoreToken.getDettaglioErroreHeaderPresentePiuVolte(headerName);
                    } else {
                        esitoPresenzaDPoP.setHeaderHttp(headerName);
                    }
                }
            }
            Object detailsErrorUrl = null;
            if ("CUSTOM_url".equals(source)) {
                if (datiInvocazione.getInfoConnettoreIngresso() == null || datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext() == null) {
                    detailsErrorUrl = INFO_TRASPORTO_NON_PRESENTI;
                } else {
                    String propertyUrlName;
                    List values;
                    URLProtocolContext urlProtocolContext = datiInvocazione.getInfoConnettoreIngresso().getUrlProtocolContext();
                    if (urlProtocolContext.getParameters() == null || urlProtocolContext.getParameters().size() <= 0) {
                        detailsErrorUrl = "Parametri nella URL non presenti";
                    }
                    if ((values = urlProtocolContext.getParameterValues(propertyUrlName = policyGestioneToken.getDPoPSourceQueryParameterName())) != null && !values.isEmpty()) {
                        dpopToken = (String)values.get(0);
                    }
                    if (dpopToken == null) {
                        detailsErrorUrl = "Non \u00e8 stato riscontrata la propriet\u00e0 della URL '" + propertyUrlName + "' contenente il DPoP";
                    } else if (values != null && values.size() > 1) {
                        detailsErrorUrl = "Sono state rilevate pi\u00f9 propriet\u00e0 della URL '" + propertyUrlName + "'";
                    } else {
                        esitoPresenzaDPoP.setPropertyUrl(propertyUrlName);
                    }
                }
            }
            String detailsError = null;
            if (detailsErrorHeader != null) {
                detailsError = detailsErrorHeader;
            }
            if (detailsErrorUrl != null) {
                detailsError = detailsErrorUrl;
            }
            if (dpopToken != null) {
                esitoPresenzaDPoP.setToken(dpopToken);
                esitoPresenzaDPoP.setPresente(true);
            } else {
                if (detailsError != null) {
                    esitoPresenzaDPoP.setDetails(detailsError);
                } else {
                    esitoPresenzaDPoP.setDetails("DPoP non individuato tramite la configurazione indicata");
                }
                if (policyGestioneToken.isMessageErrorGenerateEmptyMessage()) {
                    esitoPresenzaDPoP.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_request, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoPresenzaDPoP.getDetails(), (String[])new String[0]));
                } else {
                    esitoPresenzaDPoP.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.invalid_request, (String)policyGestioneToken.getRealm(), (boolean)policyGestioneToken.isMessageErrorGenerateGenericMessage(), (String)esitoPresenzaDPoP.getDetails(), (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            esitoPresenzaDPoP.setDetails(e.getMessage());
            esitoPresenzaDPoP.setEccezioneProcessamento(e);
        }
        return esitoPresenzaDPoP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsitoDynamicDiscovery dynamicDiscovery(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, EsitoPresenzaToken esitoPresenzaToken, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) throws Exception {
        EsitoDynamicDiscovery esitoDynamicDiscovery = null;
        String token = esitoPresenzaToken.getToken();
        Cache cache = null;
        cache = OpenSPCoop2Properties.getInstance().isGestioneTokenDynamicDiscoveryUseCacheConfig() ? ConfigurazionePdDReader.getCache() : cacheGestioneToken;
        if (cache == null) {
            esitoDynamicDiscovery = GestoreTokenValidazioneUtilities.dynamicDiscoveryEngine(log, datiInvocazione, pddContext, protocolFactory, token, portaDelegata, busta, idDominio, idServizio);
        } else {
            String keyCache;
            CacheResponse response;
            String policyName = datiInvocazione.getPolicyGestioneToken().getName();
            String endpoint = datiInvocazione.getPolicyGestioneToken().getDynamicDiscoveryEndpoint();
            String funzione = DYNAMIC_DISCOVERY_FUNCTION;
            Object tokenCache = "";
            if (OpenSPCoop2Properties.getInstance().isGestioneTokenDynamicDiscoveryKeyCacheUseToken()) {
                tokenCache = token;
            }
            if ((response = (CacheResponse)cache.get(keyCache = GestoreTokenValidazioneUtilities.buildCacheKeyValidazione(policyName, funzione, portaDelegata, (String)(tokenCache = (String)tokenCache + "_endpoint:" + endpoint)))) != null) {
                if (response.getObject() != null) {
                    GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                    esitoDynamicDiscovery = (EsitoDynamicDiscovery)response.getObject();
                    esitoDynamicDiscovery.setInCache(true);
                } else {
                    if (response.getException() != null) {
                        GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                        throw (Exception)response.getException();
                    }
                    GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                }
            }
            if (esitoDynamicDiscovery == null) {
                String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
                Semaphore lockDynamicDiscovery = GestoreToken.getLockDynamicDiscovery(policyName);
                SemaphoreLock lock = lockDynamicDiscovery.acquire("dynamicDiscovery", idTransazione);
                try {
                    response = (CacheResponse)cache.get(keyCache);
                    if (response != null) {
                        if (response.getObject() != null) {
                            GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                            esitoDynamicDiscovery = (EsitoDynamicDiscovery)response.getObject();
                            esitoDynamicDiscovery.setInCache(true);
                        } else {
                            if (response.getException() != null) {
                                GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                                throw (Exception)response.getException();
                            }
                            GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                        }
                    }
                    if (esitoDynamicDiscovery == null) {
                        GestoreToken.loggerDebug(GestoreToken.getPrefixOggettoConChiave(keyCache) + GestoreToken.getSuffixEseguiOperazione(funzione));
                        esitoDynamicDiscovery = GestoreTokenValidazioneUtilities.dynamicDiscoveryEngine(log, datiInvocazione, pddContext, protocolFactory, token, portaDelegata, busta, idDominio, idServizio);
                        esitoDynamicDiscovery.setInCache(false);
                        if (!esitoDynamicDiscovery.isNoCache()) {
                            GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                            try {
                                CacheResponse responseCache = new CacheResponse();
                                responseCache.setObject((Serializable)esitoDynamicDiscovery);
                                cache.put(keyCache, responseCache);
                            }
                            catch (UtilsException e) {
                                GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)((Object)e)));
                            }
                        }
                    }
                }
                finally {
                    lockDynamicDiscovery.release(lock, "dynamicDiscovery", idTransazione);
                }
            }
        }
        return esitoDynamicDiscovery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsitoGestioneToken validazioneJWTToken(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, EsitoPresenzaToken esitoPresenzaToken, EsitoDynamicDiscovery esitoDynamicDiscovery, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) throws Exception {
        EsitoGestioneToken esitoGestioneToken;
        block21: {
            DynamicDiscovery dynamicDiscovery;
            esitoGestioneToken = null;
            String token = esitoPresenzaToken.getToken();
            DynamicDiscovery dynamicDiscovery2 = dynamicDiscovery = esitoDynamicDiscovery != null ? esitoDynamicDiscovery.getDynamicDiscovery() : null;
            if (cacheGestioneToken == null) {
                esitoGestioneToken = GestoreTokenValidazioneUtilities.validazioneJWTTokenEngine(log, datiInvocazione, esitoPresenzaToken, dynamicDiscovery, token, portaDelegata, pddContext, busta, idDominio, idServizio);
            } else {
                String funzione;
                String policyName = datiInvocazione.getPolicyGestioneToken().getName();
                String keyCache = GestoreTokenValidazioneUtilities.buildCacheKeyValidazione(policyName, funzione = VALIDAZIONE_JWT_FUNCTION, portaDelegata, token);
                CacheResponse response = (CacheResponse)cacheGestioneToken.get(keyCache);
                if (response != null) {
                    if (response.getObject() != null) {
                        GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                        esitoGestioneToken = (EsitoGestioneToken)response.getObject();
                        esitoGestioneToken.setInCache(true);
                    } else {
                        if (response.getException() != null) {
                            GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                            throw (Exception)response.getException();
                        }
                        GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                    }
                }
                if (esitoGestioneToken == null) {
                    String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
                    Semaphore lockJWT = GestoreToken.getLockJWT(policyName);
                    SemaphoreLock lock = lockJWT.acquire("validazioneJWTToken", idTransazione);
                    try {
                        response = (CacheResponse)cacheGestioneToken.get(keyCache);
                        if (response != null) {
                            if (response.getObject() != null) {
                                GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                                esitoGestioneToken = (EsitoGestioneToken)response.getObject();
                                esitoGestioneToken.setInCache(true);
                            } else {
                                if (response.getException() != null) {
                                    GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                                    throw (Exception)response.getException();
                                }
                                GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                            }
                        }
                        if (esitoGestioneToken != null) break block21;
                        GestoreToken.loggerDebug(GestoreToken.getPrefixOggettoConChiave(keyCache) + GestoreToken.getSuffixEseguiOperazione(funzione));
                        esitoGestioneToken = GestoreTokenValidazioneUtilities.validazioneJWTTokenEngine(log, datiInvocazione, esitoPresenzaToken, dynamicDiscovery, token, portaDelegata, pddContext, busta, idDominio, idServizio);
                        if (esitoGestioneToken != null) {
                            esitoGestioneToken.setInCache(false);
                            if (!esitoGestioneToken.isNoCache()) {
                                GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                                try {
                                    CacheResponse responseCache = new CacheResponse();
                                    responseCache.setObject((Serializable)esitoGestioneToken);
                                    cacheGestioneToken.put(keyCache, responseCache);
                                }
                                catch (UtilsException e) {
                                    GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)((Object)e)));
                                }
                            }
                            break block21;
                        }
                        throw new TokenException(GestoreToken.getMessaggioErroreValoreEsitoNull(funzione));
                    }
                    finally {
                        lockJWT.release(lock, "validazioneJWTToken", idTransazione);
                    }
                }
            }
        }
        if (esitoGestioneToken.isValido()) {
            GestoreTokenValidazioneUtilities.validazioneInformazioniToken(true, log, datiInvocazione, protocolFactory, esitoGestioneToken, datiInvocazione.getPolicyGestioneToken(), datiInvocazione.getPolicyGestioneToken().isValidazioneJWTSaveErrorInCache());
        }
        SecurityToken securityToken = null;
        if (esitoGestioneToken.getRestSecurityToken() != null) {
            securityToken = SecurityTokenUtilities.newSecurityToken((Context)pddContext);
            securityToken.setAccessToken(esitoGestioneToken.getRestSecurityToken());
        }
        GestoreTokenValidazioneUtilities.validazioneInformazioniTokenEnrichPDNDClientInfo(esitoGestioneToken, datiInvocazione.getPolicyGestioneToken(), pddContext, protocolFactory, datiInvocazione, securityToken);
        if (datiInvocazione.getPolicyGestioneToken() != null && datiInvocazione.getPolicyGestioneToken().getName() != null && GestoreTokenValidazioneUtilities.isPdndTokenPolicy(log, datiInvocazione.getPolicyGestioneToken().getName()) && pddContext != null) {
            pddContext.put(CostantiPdD.TOKEN_VALIDAZIONE_PDND, "true");
        }
        return esitoGestioneToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsitoGestioneToken introspectionToken(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, EsitoPresenzaToken esitoPresenzaToken, EsitoDynamicDiscovery esitoDynamicDiscovery, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) throws Exception {
        DynamicDiscovery dynamicDiscovery;
        EsitoGestioneToken esitoGestioneToken = null;
        String token = esitoPresenzaToken.getToken();
        DynamicDiscovery dynamicDiscovery2 = dynamicDiscovery = esitoDynamicDiscovery != null ? esitoDynamicDiscovery.getDynamicDiscovery() : null;
        if (cacheGestioneToken == null) {
            esitoGestioneToken = GestoreTokenValidazioneUtilities.introspectionTokenEngine(log, datiInvocazione, pddContext, protocolFactory, dynamicDiscovery, token, portaDelegata, busta, idDominio, idServizio);
        } else {
            String funzione;
            String policyName = datiInvocazione.getPolicyGestioneToken().getName();
            String keyCache = GestoreTokenValidazioneUtilities.buildCacheKeyValidazione(policyName, funzione = INTROSPECTION_FUNCTION, portaDelegata, token);
            CacheResponse response = (CacheResponse)cacheGestioneToken.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                    esitoGestioneToken = (EsitoGestioneToken)response.getObject();
                    esitoGestioneToken.setInCache(true);
                } else {
                    if (response.getException() != null) {
                        GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                        throw (Exception)response.getException();
                    }
                    GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                }
            }
            if (esitoGestioneToken == null) {
                String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
                Semaphore lockIntrospection = GestoreToken.getLockIntrospection(policyName);
                SemaphoreLock lock = lockIntrospection.acquire("introspectionToken", idTransazione);
                try {
                    response = (CacheResponse)cacheGestioneToken.get(keyCache);
                    if (response != null) {
                        if (response.getObject() != null) {
                            GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                            esitoGestioneToken = (EsitoGestioneToken)response.getObject();
                            esitoGestioneToken.setInCache(true);
                        } else {
                            if (response.getException() != null) {
                                GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                                throw (Exception)response.getException();
                            }
                            GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                        }
                    }
                    if (esitoGestioneToken == null) {
                        GestoreToken.loggerDebug(GestoreToken.getPrefixOggettoConChiave(keyCache) + GestoreToken.getSuffixEseguiOperazione(funzione));
                        esitoGestioneToken = GestoreTokenValidazioneUtilities.introspectionTokenEngine(log, datiInvocazione, pddContext, protocolFactory, dynamicDiscovery, token, portaDelegata, busta, idDominio, idServizio);
                        esitoGestioneToken.setInCache(false);
                        if (!esitoGestioneToken.isNoCache()) {
                            GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                            try {
                                CacheResponse responseCache = new CacheResponse();
                                responseCache.setObject((Serializable)esitoGestioneToken);
                                cacheGestioneToken.put(keyCache, responseCache);
                            }
                            catch (UtilsException e) {
                                GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)((Object)e)));
                            }
                        }
                    }
                }
                finally {
                    lockIntrospection.release(lock, "introspectionToken", idTransazione);
                }
            }
        }
        if (esitoGestioneToken.isValido()) {
            GestoreTokenValidazioneUtilities.validazioneInformazioniToken(false, log, datiInvocazione, protocolFactory, esitoGestioneToken, datiInvocazione.getPolicyGestioneToken(), datiInvocazione.getPolicyGestioneToken().isIntrospectionSaveErrorInCache());
        }
        return esitoGestioneToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsitoGestioneToken userInfoToken(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, EsitoPresenzaToken esitoPresenzaToken, EsitoDynamicDiscovery esitoDynamicDiscovery, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) throws Exception {
        DynamicDiscovery dynamicDiscovery;
        EsitoGestioneToken esitoGestioneToken = null;
        String token = esitoPresenzaToken.getToken();
        DynamicDiscovery dynamicDiscovery2 = dynamicDiscovery = esitoDynamicDiscovery != null ? esitoDynamicDiscovery.getDynamicDiscovery() : null;
        if (cacheGestioneToken == null) {
            esitoGestioneToken = GestoreTokenValidazioneUtilities.userInfoTokenEngine(log, datiInvocazione, pddContext, protocolFactory, dynamicDiscovery, token, portaDelegata, busta, idDominio, idServizio);
        } else {
            String funzione;
            String policyName = datiInvocazione.getPolicyGestioneToken().getName();
            String keyCache = GestoreTokenValidazioneUtilities.buildCacheKeyValidazione(policyName, funzione = USERINFO_FUNCTION, portaDelegata, token);
            CacheResponse response = (CacheResponse)cacheGestioneToken.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                    esitoGestioneToken = (EsitoGestioneToken)response.getObject();
                    esitoGestioneToken.setInCache(true);
                } else {
                    if (response.getException() != null) {
                        GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                        throw (Exception)response.getException();
                    }
                    GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                }
            }
            if (esitoGestioneToken == null) {
                String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
                Semaphore lockUserInfo = GestoreToken.getLockUserInfo(policyName);
                SemaphoreLock lock = lockUserInfo.acquire("userInfoToken", idTransazione);
                try {
                    response = (CacheResponse)cacheGestioneToken.get(keyCache);
                    if (response != null) {
                        if (response.getObject() != null) {
                            GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                            esitoGestioneToken = (EsitoGestioneToken)response.getObject();
                            esitoGestioneToken.setInCache(true);
                        } else {
                            if (response.getException() != null) {
                                GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                                throw (Exception)response.getException();
                            }
                            GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                        }
                    }
                    if (esitoGestioneToken == null) {
                        GestoreToken.loggerDebug(GestoreToken.getPrefixOggettoConChiave(keyCache) + GestoreToken.getSuffixEseguiOperazione(funzione));
                        esitoGestioneToken = GestoreTokenValidazioneUtilities.userInfoTokenEngine(log, datiInvocazione, pddContext, protocolFactory, dynamicDiscovery, token, portaDelegata, busta, idDominio, idServizio);
                        esitoGestioneToken.setInCache(false);
                        if (!esitoGestioneToken.isNoCache()) {
                            GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                            try {
                                CacheResponse responseCache = new CacheResponse();
                                responseCache.setObject((Serializable)esitoGestioneToken);
                                cacheGestioneToken.put(keyCache, responseCache);
                            }
                            catch (UtilsException e) {
                                GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)((Object)e)));
                            }
                        }
                    }
                }
                finally {
                    lockUserInfo.release(lock, "userInfoToken", idTransazione);
                }
            }
        }
        if (esitoGestioneToken.isValido()) {
            GestoreTokenValidazioneUtilities.validazioneInformazioniToken(false, log, datiInvocazione, protocolFactory, esitoGestioneToken, datiInvocazione.getPolicyGestioneToken(), datiInvocazione.getPolicyGestioneToken().isUserInfoSaveErrorInCache());
        }
        return esitoGestioneToken;
    }

    public static EsitoValidazioneDPoP validazioneDPoP(Logger log, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, EsitoPresenzaDPoP esitoPresenzaDPoP, EsitoGestioneToken esitoGestioneToken, String accessToken, boolean portaDelegata, Busta busta, IDSoggetto idDominio, IDServizio idServizio) {
        EsitoValidazioneDPoP esitoValidazioneDPoP = GestoreTokenValidazioneUtilities.validazioneDPoPEngine(log, datiInvocazione, esitoPresenzaDPoP, esitoGestioneToken, protocolFactory, accessToken, portaDelegata, pddContext, busta, idDominio, idServizio);
        SecurityToken securityToken = null;
        if (esitoValidazioneDPoP.getRestSecurityToken() != null) {
            securityToken = SecurityTokenUtilities.newSecurityToken((Context)pddContext);
            securityToken.setDpopToken(esitoValidazioneDPoP.getRestSecurityToken());
        }
        return esitoValidazioneDPoP;
    }

    public static void forwardToken(Logger log, String idTransazione, AbstractDatiInvocazione datiInvocazione, EsitoPresenzaToken esitoPresenzaToken, EsitoPresenzaDPoP esitoPresenzaDPoP, EsitoGestioneToken esitoValidazioneJWT, EsitoGestioneToken esitoIntrospection, EsitoGestioneToken esitoUserInfo, InformazioniToken informazioniTokenNormalizzate, boolean portaDelegata, PdDContext pddContext, Busta busta) throws CoreException, SecurityException, TokenException, UtilsException {
        if (datiInvocazione == null) {
            throw new CoreException("Dati invocazioni is null");
        }
        PolicyGestioneToken policyGestioneToken = datiInvocazione.getPolicyGestioneToken();
        TokenForward tokenForward = new TokenForward();
        String token = esitoPresenzaToken.getToken();
        boolean trasparente = false;
        String forwardTrasparenteMode = null;
        String forwardTrasparenteModeHeader = null;
        String forwardTrasparenteModeUrl = null;
        if (policyGestioneToken.isForwardToken() && (trasparente = policyGestioneToken.isForwardTokenTrasparente())) {
            forwardTrasparenteMode = policyGestioneToken.getForwardTokenTrasparenteMode();
            if ("asReceived".equals(forwardTrasparenteMode)) {
                forwardTrasparenteModeHeader = esitoPresenzaToken.getHeaderHttp();
                forwardTrasparenteModeUrl = esitoPresenzaToken.getPropertyUrl();
            } else if ("RFC6750_header".equals(forwardTrasparenteMode)) {
                forwardTrasparenteModeHeader = "Authorization";
            } else if ("RFC6750_url".equals(forwardTrasparenteMode)) {
                forwardTrasparenteModeUrl = "access_token";
            } else if ("CUSTOM_header".equals(forwardTrasparenteMode)) {
                forwardTrasparenteModeHeader = policyGestioneToken.getForwardTokenTrasparenteModeCustomHeader();
            } else if ("CUSTOM_url".equals(forwardTrasparenteMode)) {
                forwardTrasparenteModeUrl = policyGestioneToken.getForwardTokenTrasparenteModeCustomUrl();
            }
        }
        boolean forwardDPoP = false;
        String forwardDPoPMode = null;
        String forwardDPoPModeHeader = null;
        String forwardDPoPModeUrl = null;
        if (policyGestioneToken.isForwardToken() && policyGestioneToken.isDPoPValidation() && esitoPresenzaDPoP != null && esitoPresenzaDPoP.isPresente() && (forwardDPoP = policyGestioneToken.isForwardDPoP())) {
            forwardDPoPMode = policyGestioneToken.getForwardDPoPMode();
            if ("asReceived".equals(forwardDPoPMode)) {
                forwardDPoPModeHeader = esitoPresenzaDPoP.getHeaderHttp();
                forwardDPoPModeUrl = esitoPresenzaDPoP.getPropertyUrl();
            } else if ("RFC9449_header".equals(forwardDPoPMode)) {
                forwardDPoPModeHeader = "DPoP";
            } else if ("CUSTOM_header".equals(forwardDPoPMode)) {
                forwardDPoPModeHeader = policyGestioneToken.getForwardDPoPModeCustomHeader();
            } else if ("CUSTOM_url".equals(forwardDPoPMode)) {
                forwardDPoPModeUrl = policyGestioneToken.getForwardDPoPModeCustomUrl();
            }
        }
        boolean infoRaccolte = false;
        String forwardInformazioniRaccolteMode = null;
        Properties jwtSecurity = null;
        boolean encodeBase64 = false;
        boolean forwardValidazioneJWT = false;
        String forwardValidazioneJWTMode = null;
        String forwardValidazioneJWTName = null;
        boolean forwardIntrospection = false;
        String forwardIntrospectionMode = null;
        String forwardIntrospectionName = null;
        boolean forwardUserInfo = false;
        String forwardUserInfoMode = null;
        String forwardUserInfoName = null;
        if (policyGestioneToken.isForwardToken() && (infoRaccolte = policyGestioneToken.isForwardTokenInformazioniRaccolte())) {
            forwardInformazioniRaccolteMode = policyGestioneToken.getForwardTokenInformazioniRaccolteMode();
            encodeBase64 = policyGestioneToken.isForwardTokenInformazioniRaccolteEncodeBase64();
            if ("op2jws".equals(forwardInformazioniRaccolteMode) || "jws".equals(forwardInformazioniRaccolteMode)) {
                jwtSecurity = policyGestioneToken.getProperties().get("signaturePropRefId");
            } else if ("jwe".equals(forwardInformazioniRaccolteMode)) {
                jwtSecurity = policyGestioneToken.getProperties().get("encryptionPropRefId");
            }
            if (jwtSecurity != null) {
                boolean throwError = true;
                Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, datiInvocazione.getRequestInfo(), pddContext, log);
                JOSEUtils.injectKeystore((RequestInfo)datiInvocazione.getRequestInfo(), dynamicMap, (Properties)jwtSecurity, (Logger)log, (boolean)throwError);
            }
            if (forwardValidazioneJWT = policyGestioneToken.isForwardTokenInformazioniRaccolteValidazioneJWT()) {
                forwardValidazioneJWTMode = policyGestioneToken.getForwardTokenInformazioniRaccolteValidazioneJWTMode();
                forwardValidazioneJWTName = "CUSTOM_header".equals(forwardValidazioneJWTMode) ? policyGestioneToken.getForwardTokenInformazioniRaccolteValidazioneJWTModeHeaderName() : policyGestioneToken.getForwardTokenInformazioniRaccolteValidazioneJWTModeQueryParameterName();
            }
            if (forwardIntrospection = policyGestioneToken.isForwardTokenInformazioniRaccolteIntrospection()) {
                forwardIntrospectionMode = policyGestioneToken.getForwardTokenInformazioniRaccolteIntrospectionMode();
                forwardIntrospectionName = "CUSTOM_header".equals(forwardIntrospectionMode) ? policyGestioneToken.getForwardTokenInformazioniRaccolteIntrospectionModeHeaderName() : policyGestioneToken.getForwardTokenInformazioniRaccolteIntrospectionModeQueryParameterName();
            }
            if (forwardUserInfo = policyGestioneToken.isForwardTokenInformazioniRaccolteUserInfo()) {
                forwardUserInfoMode = policyGestioneToken.getForwardTokenInformazioniRaccolteUserInfoMode();
                forwardUserInfoName = "CUSTOM_header".equals(forwardUserInfoMode) ? policyGestioneToken.getForwardTokenInformazioniRaccolteUserInfoModeHeaderName() : policyGestioneToken.getForwardTokenInformazioniRaccolteUserInfoModeQueryParameterName();
            }
        }
        boolean delete = GestoreTokenValidazioneUtilities.deleteTokenReceived(datiInvocazione, esitoPresenzaToken, trasparente, forwardTrasparenteModeHeader, forwardTrasparenteModeUrl);
        boolean soap = datiInvocazione != null && datiInvocazione.getMessage() != null && ServiceBinding.SOAP.equals((Object)datiInvocazione.getMessage().getServiceBinding());
        boolean deleteDPoP = false;
        if (esitoPresenzaDPoP != null && esitoPresenzaDPoP.isPresente()) {
            deleteDPoP = GestoreTokenValidazioneUtilities.deleteDPoPReceived(datiInvocazione, esitoPresenzaDPoP, forwardDPoP, forwardDPoPModeHeader, forwardDPoPModeUrl);
        }
        if (trasparente && (delete || soap)) {
            GestoreTokenValidazioneUtilities.forwardTokenTrasparenteEngine(token, esitoPresenzaToken, tokenForward, forwardTrasparenteMode, forwardTrasparenteModeHeader, forwardTrasparenteModeUrl);
        }
        if (forwardDPoP && esitoPresenzaDPoP != null && esitoPresenzaDPoP.isPresente() && (deleteDPoP || soap)) {
            String dpopToken = esitoPresenzaDPoP.getToken();
            GestoreTokenValidazioneUtilities.forwardDPoPTrasparenteEngine(dpopToken, esitoPresenzaDPoP, tokenForward, forwardDPoPMode, forwardDPoPModeHeader, forwardDPoPModeUrl);
        }
        if (infoRaccolte) {
            GestoreTokenValidazioneUtilities.forwardInfomazioniRaccolteEngine(portaDelegata, idTransazione, tokenForward, esitoValidazioneJWT, esitoIntrospection, esitoUserInfo, informazioniTokenNormalizzate, forwardInformazioniRaccolteMode, jwtSecurity, encodeBase64, forwardValidazioneJWT, forwardValidazioneJWTMode, forwardValidazioneJWTName, forwardIntrospection, forwardIntrospectionMode, forwardIntrospectionName, forwardUserInfo, forwardUserInfoMode, forwardUserInfoName);
        }
        if (tokenForward.getUrl().size() > 0 || tokenForward.getTrasporto().size() > 0) {
            datiInvocazione.getMessage().addContextProperty(Costanti.MSG_CONTEXT_TOKEN_FORWARD, (Object)tokenForward);
        }
    }

    public static List<InformazioniToken> getInformazioniTokenValide(EsitoGestioneToken esitoValidazioneJWT, EsitoGestioneToken esitoIntrospection, EsitoGestioneToken esitoUserInfo) {
        ArrayList<InformazioniToken> list = new ArrayList<InformazioniToken>();
        if (esitoValidazioneJWT != null && esitoValidazioneJWT.isValido() && esitoValidazioneJWT.getInformazioniToken() != null) {
            list.add(esitoValidazioneJWT.getInformazioniToken());
        }
        if (esitoIntrospection != null && esitoIntrospection.isValido() && esitoIntrospection.getInformazioniToken() != null) {
            list.add(esitoIntrospection.getInformazioniToken());
        }
        if (esitoUserInfo != null && esitoUserInfo.isValido() && esitoUserInfo.getInformazioniToken() != null) {
            list.add(esitoUserInfo.getInformazioniToken());
        }
        return list;
    }

    public static List<InformazioniToken> getInformazioniTokenNonValide(EsitoGestioneToken esitoValidazioneJWT, EsitoGestioneToken esitoIntrospection, EsitoGestioneToken esitoUserInfo) {
        ArrayList<InformazioniToken> list = new ArrayList<InformazioniToken>();
        if (esitoValidazioneJWT != null && esitoValidazioneJWT.getInformazioniToken() != null) {
            list.add(esitoValidazioneJWT.getInformazioniToken());
        }
        if (esitoIntrospection != null && esitoIntrospection.getInformazioniToken() != null) {
            list.add(esitoIntrospection.getInformazioniToken());
        }
        if (esitoUserInfo != null && esitoUserInfo.getInformazioniToken() != null) {
            list.add(esitoUserInfo.getInformazioniToken());
        }
        return list;
    }

    public static InformazioniToken normalizeInformazioniToken(List<InformazioniToken> list) throws UtilsException {
        if (list.size() == 1) {
            return list.get(0);
        }
        return new InformazioniToken(OpenSPCoop2Properties.getInstance().isGestioneTokenSaveSourceTokenInfo(), list.toArray(new InformazioniToken[1]));
    }

    public static void validazioneConfigurazione(PolicyNegoziazioneToken policyNegoziazioneToken) throws ProviderException, ProviderValidationException {
        NegoziazioneTokenProvider p = new NegoziazioneTokenProvider();
        p.validate(policyNegoziazioneToken.getProperties());
    }

    public static EsitoNegoziazioneToken endpointToken(boolean debug, Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, Busta busta, RequestInfo requestInfo, TipoPdD tipoPdD, String idModulo, PortaApplicativa pa, PortaDelegata pd, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws Exception {
        return GestoreToken.endpointTokenEngine(debug, log, policyNegoziazioneToken, busta, requestInfo, tipoPdD, idModulo, pa, pd, pddContext, protocolFactory, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static EsitoNegoziazioneToken endpointTokenEngine(boolean debug, Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, Busta busta, RequestInfo requestInfo, TipoPdD tipoPdD, String idModulo, PortaApplicativa pa, PortaDelegata pd, PdDContext pddContext, IProtocolFactory<?> protocolFactory, boolean rinegozia, InformazioniNegoziazioneToken previousToken, InformazioniNegoziazioneToken_DatiRichiesta datiRichiesta) throws Exception {
        esitoNegoziazioneToken = null;
        riavviaNegoziazione = rinegozia;
        riavviaNegoziazione = false;
        state = null;
        delegata = TipoPdD.DELEGATA.equals((Object)tipoPdD);
        idDominio = null;
        idServizio = null;
        if (busta != null) {
            if (delegata) {
                if (busta.getTipoMittente() != null && busta.getMittente() != null) {
                    idDominio = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                }
            } else if (busta.getTipoDestinatario() != null && busta.getDestinatario() != null) {
                idDominio = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            }
            if (busta.getTipoDestinatario() != null && busta.getDestinatario() != null && busta.getTipoServizio() != null && busta.getServizio() != null && busta.getVersioneServizio() != null) {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue());
            }
        }
        if (policyNegoziazioneToken == null) {
            throw new CoreException("PolicyNegoziazioneToken is null");
        }
        idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) != false ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
        op2Properties = OpenSPCoop2Properties.getInstance();
        if (datiRichiesta == null && op2Properties.isGestioneRetrieveTokenSaveAsTokenInfoSaveSourceRequest()) {
            datiRichiesta = new InformazioniNegoziazioneToken_DatiRichiesta();
            datiRichiesta.setPolicy(policyNegoziazioneToken.getName());
            datiRichiesta.setTransactionId(idTransazione);
            if (op2Properties.isGestioneRetrieveTokenSaveAsTokenInfoSaveSourceRequestDate()) {
                datiRichiesta.setPrepareRequest(DateManager.getDate());
            }
        }
        dynamicMap = GestoreTokenNegoziazioneUtilities.buildDynamicNegoziazioneTokenMap(busta, requestInfo, pddContext, log);
        dynamicParameters = new NegoziazioneTokenDynamicParameters(dynamicMap, pddContext, requestInfo, busta, state, protocolFactory, policyNegoziazioneToken);
        if (GestoreToken.cacheGestioneToken == null) {
            esitoNegoziazioneToken = GestoreTokenNegoziazioneUtilities.endpointTokenEngine(debug, log, policyNegoziazioneToken, busta, requestInfo, tipoPdD, dynamicParameters, protocolFactory, state, delegata, idModulo, pa, pd, idDominio, idServizio, previousToken, datiRichiesta);
            if (esitoNegoziazioneToken != null && esitoNegoziazioneToken.isValido()) {
                checkPerRinegoziazione = false;
                GestoreTokenNegoziazioneUtilities.validazioneInformazioniNegoziazioneToken(checkPerRinegoziazione, esitoNegoziazioneToken, policyNegoziazioneToken);
            }
        } else {
            policyName = policyNegoziazioneToken.getName();
            keyCache = GestoreTokenNegoziazioneUtilities.buildCacheKeyNegoziazione(policyName, funzione = "Negoziazione", delegata, dynamicParameters);
            response = (CacheResponse)GestoreToken.cacheGestioneToken.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                    esitoNegoziazioneToken = (EsitoNegoziazioneToken)response.getObject();
                    esitoNegoziazioneToken.setInCache(true);
                } else {
                    if (response.getException() != null) {
                        GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                        throw (Exception)response.getException();
                    }
                    GestoreToken.loggerError("In cache non \u00e8 presente ne un oggetto ne un'eccezione.");
                }
            }
            if (esitoNegoziazioneToken == null) {
                lockNegoziazione = GestoreToken.getLockNegoziazione(policyName);
                lock = lockNegoziazione.acquire("endpointToken", idTransazione);
                try {
                    response = (CacheResponse)GestoreToken.cacheGestioneToken.get(keyCache);
                    if (response != null) {
                        if (response.getObject() != null) {
                            GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                            esitoNegoziazioneToken = (EsitoNegoziazioneToken)response.getObject();
                            esitoNegoziazioneToken.setInCache(true);
                        } else {
                            if (response.getException() != null) {
                                GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                                throw (Exception)response.getException();
                            }
                            GestoreToken.loggerError("In cache non \u00e8 presente ne un oggetto ne un'eccezione.");
                        }
                    }
                    if (esitoNegoziazioneToken == null) {
                        GestoreToken.loggerDebug(GestoreToken.getPrefixOggettoConChiave(keyCache) + GestoreToken.getSuffixEseguiOperazione(funzione));
                        esitoNegoziazioneToken = GestoreTokenNegoziazioneUtilities.endpointTokenEngine(debug, log, policyNegoziazioneToken, busta, requestInfo, tipoPdD, dynamicParameters, protocolFactory, state, delegata, idModulo, pa, pd, idDominio, idServizio, previousToken, datiRichiesta);
                        if (esitoNegoziazioneToken != null) {
                            esitoNegoziazioneToken.setInCache(false);
                            if (!esitoNegoziazioneToken.isNoCache()) {
                                GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                                try {
                                    responseCache = new CacheResponse();
                                    responseCache.setObject((Serializable)esitoNegoziazioneToken);
                                    GestoreToken.cacheGestioneToken.put(keyCache, responseCache);
                                }
                                catch (UtilsException e) {
                                    GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)e));
                                }
                            }
                        } else {
                            throw new TokenException(GestoreToken.getMessaggioErroreValoreEsitoNull(funzione));
                        }
                        if (!esitoNegoziazioneToken.isValido()) ** GOTO lbl106
                        checkPerRinegoziazione = false;
                        GestoreTokenNegoziazioneUtilities.validazioneInformazioniNegoziazioneToken(checkPerRinegoziazione, esitoNegoziazioneToken, policyNegoziazioneToken);
                    }
                    if (!esitoNegoziazioneToken.isValido()) ** GOTO lbl106
                    checkPerRinegoziazione = true;
                    GestoreTokenNegoziazioneUtilities.validazioneInformazioniNegoziazioneToken(checkPerRinegoziazione, esitoNegoziazioneToken, policyNegoziazioneToken);
                    if (esitoNegoziazioneToken.isValido() || esitoNegoziazioneToken.isDateValide()) ** GOTO lbl106
                    GestoreToken.cacheGestioneToken.remove(keyCache);
                    riavviaNegoziazione = true;
                }
                finally {
                    lockNegoziazione.release(lock, "endpointToken", idTransazione);
                }
            } else if (esitoNegoziazioneToken.isValido()) {
                checkPerRinegoziazione = true;
                GestoreTokenNegoziazioneUtilities.validazioneInformazioniNegoziazioneToken(checkPerRinegoziazione, esitoNegoziazioneToken, policyNegoziazioneToken);
                if (!esitoNegoziazioneToken.isValido() && !esitoNegoziazioneToken.isDateValide()) {
                    lockNegoziazione = GestoreToken.getLockNegoziazione(policyName);
                    lock = lockNegoziazione.acquire("removeToken", idTransazione);
                    try {
                        GestoreToken.cacheGestioneToken.remove(keyCache);
                        riavviaNegoziazione = true;
                    }
                    finally {
                        lockNegoziazione.release(lock, "removeToken", idTransazione);
                    }
                }
            }
        }
        if (riavviaNegoziazione) {
            return GestoreToken.endpointTokenEngine(debug, log, policyNegoziazioneToken, busta, requestInfo, tipoPdD, idModulo, pa, pd, pddContext, protocolFactory, riavviaNegoziazione, esitoNegoziazioneToken.getInformazioniNegoziazioneToken(), datiRichiesta);
        }
        try {
            if (idTransazione != null) {
                t = TransactionContext.getTransaction(idTransazione);
                if (esitoNegoziazioneToken != null) {
                    t.setInformazioniNegoziazioneToken(esitoNegoziazioneToken.getInformazioniNegoziazioneToken());
                }
            }
        }
        catch (Exception t) {
            // empty catch block
        }
        securityToken = null;
        if (esitoNegoziazioneToken != null && esitoNegoziazioneToken.getToken() != null) {
            securityToken = SecurityTokenUtilities.newSecurityToken((Context)pddContext);
            accessToken = new RestMessageSecurityToken();
            accessToken.setToken((Serializable)esitoNegoziazioneToken.getToken());
            securityToken.setAccessToken(accessToken);
        }
        if (pddContext != null && policyNegoziazioneToken.isPDND()) {
            pddContext.put(CostantiPdD.TOKEN_NEGOZIAZIONE_PDND, "true");
        }
        if (esitoNegoziazioneToken != null && esitoNegoziazioneToken.getInformazioniNegoziazioneToken() != null) {
            esitoNegoziazioneToken.getInformazioniNegoziazioneToken().setDynamicParameters(dynamicParameters);
        }
        return esitoNegoziazioneToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsitoDPoPBackend getDPoPBackendProof(DPoPParams dpopParams) throws CoreException, TokenException, SecurityException, UtilsException {
        PolicyNegoziazioneToken policyNegoziazioneToken = dpopParams.getPolicyNegoziazioneToken();
        if (policyNegoziazioneToken == null) {
            throw new CoreException("PolicyNegoziazioneToken is null");
        }
        String policyName = policyNegoziazioneToken.getName();
        boolean dpopCacheEnabled = policyNegoziazioneToken.isDpopCacheEnabled();
        int ttlSeconds = policyNegoziazioneToken.getDpopCacheTtl();
        String idTransazione = dpopParams.getPddContext() != null && dpopParams.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, dpopParams.getPddContext()) : null;
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        EsitoDPoPBackend esito = new EsitoDPoPBackend();
        DPoPBackendCacheEntry dpopEntry = null;
        if (!dpopCacheEnabled || cacheGestioneToken == null) {
            String dpopProof = GestoreTokenNegoziazioneUtilities.signDPoP(dpopParams);
            esito.setDpopProof(dpopProof);
            esito.setInCache(false);
        } else {
            String funzione = DPOP_BACKEND_FUNCTION;
            String keyCache = GestoreTokenNegoziazioneUtilities.buildDPoPBackendCacheKey(policyName, dpopParams.getHttpMethod(), dpopParams.getHttpUri(), GestoreTokenNegoziazioneUtilities.computeAccessTokenHash(dpopParams.getAccessToken()));
            CacheResponse response = (CacheResponse)cacheGestioneToken.get(keyCache);
            if (response != null && response.getObject() != null) {
                GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                dpopEntry = (DPoPBackendCacheEntry)response.getObject();
                if (GestoreTokenNegoziazioneUtilities.isDPoPBackendCacheEntryValid(dpopEntry, ttlSeconds, op2Properties)) {
                    esito.setDpopProof(dpopEntry.getDpopProof());
                    esito.setInCache(true);
                } else {
                    dpopEntry = null;
                }
            }
            if (dpopEntry == null) {
                Semaphore lockDPoPBackend = GestoreToken.getLockDPoPBackend(keyCache);
                SemaphoreLock lock = lockDPoPBackend.acquire("getDPoPBackend", idTransazione);
                try {
                    response = (CacheResponse)cacheGestioneToken.get(keyCache);
                    if (response != null && response.getObject() != null) {
                        GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                        dpopEntry = (DPoPBackendCacheEntry)response.getObject();
                        if (GestoreTokenNegoziazioneUtilities.isDPoPBackendCacheEntryValid(dpopEntry, ttlSeconds, op2Properties)) {
                            esito.setDpopProof(dpopEntry.getDpopProof());
                            esito.setInCache(true);
                        } else {
                            dpopEntry = null;
                        }
                    }
                    if (dpopEntry == null) {
                        GestoreToken.loggerDebug(GestoreToken.getPrefixOggettoConChiave(keyCache) + GestoreToken.getSuffixEseguiOperazione(funzione));
                        String dpopProof = GestoreTokenNegoziazioneUtilities.signDPoP(dpopParams);
                        esito.setDpopProof(dpopProof);
                        esito.setInCache(false);
                        GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                        try {
                            DPoPBackendCacheEntry newEntry = new DPoPBackendCacheEntry(dpopProof);
                            CacheResponse responseCache = new CacheResponse();
                            responseCache.setObject((Serializable)newEntry);
                            cacheGestioneToken.put(keyCache, responseCache);
                        }
                        catch (UtilsException e) {
                            GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)((Object)e)));
                        }
                    }
                }
                finally {
                    lockDPoPBackend.release(lock, "getDPoPBackend", idTransazione);
                }
            }
        }
        SecurityToken securityToken = null;
        if (esito.getDpopProof() != null) {
            securityToken = SecurityTokenUtilities.newSecurityToken((Context)dpopParams.getPddContext());
            RestMessageSecurityToken dpop = new RestMessageSecurityToken();
            dpop.setToken((Serializable)((Object)esito.getDpopProof()));
            securityToken.setDpopToken(dpop);
        }
        return esito;
    }

    public static void validazioneConfigurazione(PolicyAttributeAuthority policyAttributeAuthority) throws ProviderException, ProviderValidationException {
        AttributeAuthorityProvider p = new AttributeAuthorityProvider();
        p.validate(policyAttributeAuthority.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static EsitoRecuperoAttributi readAttributes(Logger log, org.openspcoop2.pdd.core.token.attribute_authority.AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, boolean portaDelegata, IDSoggetto idDominio, IDServizio idServizio) throws Exception {
        esitoRecuperoAttributi = null;
        riavviaNegoziazione = false;
        policyAttributeAuthority = datiInvocazione.getPolicyAttributeAuthority();
        message = datiInvocazione.getMessage();
        busta = datiInvocazione.getBusta();
        requestInfo = datiInvocazione.getRequestInfo();
        dynamicMap = GestoreTokenAttributeAuthorityUtilities.buildDynamicAAMap(message, busta, requestInfo, pddContext, log, policyAttributeAuthority.getName(), datiInvocazione);
        dynamicParameters = new AttributeAuthorityDynamicParameters(dynamicMap, pddContext, requestInfo, policyAttributeAuthority);
        configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
        pa = null;
        pd = null;
        if (datiInvocazione instanceof DatiInvocazionePortaApplicativa) {
            pa = ((DatiInvocazionePortaApplicativa)datiInvocazione).getPa();
        } else if (datiInvocazione instanceof DatiInvocazionePortaDelegata) {
            pd = ((DatiInvocazionePortaDelegata)datiInvocazione).getPd();
        }
        if (GestoreToken.cacheAttributeAuthority == null) {
            addIdAndDate = true;
            request = GestoreTokenAttributeAuthorityUtilities.buildDynamicAARequest(configurazionePdDManager, protocolFactory, requestInfo, policyAttributeAuthority, dynamicParameters, addIdAndDate);
            esitoRecuperoAttributi = GestoreTokenAttributeAuthorityUtilities.readAttributes(log, policyAttributeAuthority, protocolFactory, dynamicParameters, request, portaDelegata, pddContext, datiInvocazione.getBusta(), datiInvocazione.getIdModulo(), pa, pd, datiInvocazione.getState(), idDominio, idServizio, requestInfo);
            if (esitoRecuperoAttributi != null && esitoRecuperoAttributi.isValido()) {
                GestoreTokenAttributeAuthorityUtilities.validazioneInformazioniAttributiRecuperati(esitoRecuperoAttributi, policyAttributeAuthority, policyAttributeAuthority.isSaveErrorInCache(), dynamicParameters, pa, pd);
            }
        } else {
            funzione = "AttributeAuthority";
            addIdAndDate = true;
            requestKeyCache = GestoreTokenAttributeAuthorityUtilities.buildDynamicAARequest(configurazionePdDManager, protocolFactory, requestInfo, policyAttributeAuthority, dynamicParameters, addIdAndDate == false);
            aaName = policyAttributeAuthority.getName();
            keyCache = GestoreTokenAttributeAuthorityUtilities.buildCacheKeyRecuperoAttributi(aaName, funzione, portaDelegata, dynamicParameters, requestKeyCache);
            response = (CacheResponse)GestoreToken.cacheAttributeAuthority.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                    esitoRecuperoAttributi = (EsitoRecuperoAttributi)response.getObject();
                    esitoRecuperoAttributi.setInCache(true);
                } else {
                    if (response.getException() != null) {
                        GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                        throw (Exception)response.getException();
                    }
                    GestoreToken.loggerError("In cache non \u00e8 presente ne un oggetto ne un'eccezione.");
                }
            }
            v0 = idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) != false ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
            if (esitoRecuperoAttributi == null) {
                lockAttributeAuthority = GestoreToken.getLockAttributeAuthority(aaName);
                lock = lockAttributeAuthority.acquire("readAttributes", idTransazione);
                try {
                    response = (CacheResponse)GestoreToken.cacheAttributeAuthority.get(keyCache);
                    if (response != null) {
                        if (response.getObject() != null) {
                            GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                            esitoRecuperoAttributi = (EsitoRecuperoAttributi)response.getObject();
                            esitoRecuperoAttributi.setInCache(true);
                        } else {
                            if (response.getException() != null) {
                                GestoreToken.loggerDebug(GestoreToken.getMessageEccezioneInCache(response, keyCache, funzione));
                                throw (Exception)response.getException();
                            }
                            GestoreToken.loggerError("In cache non \u00e8 presente ne un oggetto ne un'eccezione.");
                        }
                    }
                    if (esitoRecuperoAttributi == null) {
                        GestoreToken.loggerDebug(GestoreToken.getPrefixOggettoConChiave(keyCache) + GestoreToken.getSuffixEseguiOperazione(funzione));
                        request = null;
                        request = policyAttributeAuthority.isRequestDynamicPayloadJwt() != false ? GestoreTokenAttributeAuthorityUtilities.buildDynamicAARequest(configurazionePdDManager, protocolFactory, requestInfo, policyAttributeAuthority, dynamicParameters, addIdAndDate) : requestKeyCache;
                        esitoRecuperoAttributi = GestoreTokenAttributeAuthorityUtilities.readAttributes(log, policyAttributeAuthority, protocolFactory, dynamicParameters, request, portaDelegata, pddContext, datiInvocazione.getBusta(), datiInvocazione.getIdModulo(), pa, pd, datiInvocazione.getState(), idDominio, idServizio, requestInfo);
                        if (esitoRecuperoAttributi != null) {
                            esitoRecuperoAttributi.setInCache(false);
                            if (!esitoRecuperoAttributi.isNoCache()) {
                                GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                                try {
                                    responseCache = new CacheResponse();
                                    responseCache.setObject((Serializable)esitoRecuperoAttributi);
                                    GestoreToken.cacheAttributeAuthority.put(keyCache, responseCache);
                                }
                                catch (UtilsException e) {
                                    GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)e));
                                }
                            }
                        } else {
                            throw new TokenException(GestoreToken.getMessaggioErroreValoreEsitoNull(funzione));
                        }
                        if (!esitoRecuperoAttributi.isValido()) ** GOTO lbl98
                        GestoreTokenAttributeAuthorityUtilities.validazioneInformazioniAttributiRecuperati(esitoRecuperoAttributi, policyAttributeAuthority, policyAttributeAuthority.isSaveErrorInCache(), dynamicParameters, pa, pd);
                    }
                    if (!esitoRecuperoAttributi.isValido()) ** GOTO lbl98
                    GestoreTokenAttributeAuthorityUtilities.validazioneInformazioniAttributiRecuperati(esitoRecuperoAttributi, policyAttributeAuthority, policyAttributeAuthority.isSaveErrorInCache(), dynamicParameters, pa, pd);
                    if (esitoRecuperoAttributi.isValido() || esitoRecuperoAttributi.isDateValide()) ** GOTO lbl98
                    GestoreToken.cacheAttributeAuthority.remove(keyCache);
                    riavviaNegoziazione = true;
                }
                finally {
                    lockAttributeAuthority.release(lock, "readAttributes", idTransazione);
                }
            } else if (esitoRecuperoAttributi.isValido()) {
                GestoreTokenAttributeAuthorityUtilities.validazioneInformazioniAttributiRecuperati(esitoRecuperoAttributi, policyAttributeAuthority, policyAttributeAuthority.isSaveErrorInCache(), dynamicParameters, pa, pd);
                if (!esitoRecuperoAttributi.isValido() && !esitoRecuperoAttributi.isDateValide()) {
                    lockAttributeAuthority = GestoreToken.getLockAttributeAuthority(aaName);
                    lock = lockAttributeAuthority.acquire("removeAttributes", idTransazione);
                    try {
                        GestoreToken.cacheAttributeAuthority.remove(keyCache);
                        riavviaNegoziazione = true;
                    }
                    finally {
                        lockAttributeAuthority.release(lock, "removeAttributes", idTransazione);
                    }
                }
            }
        }
        if (riavviaNegoziazione) {
            return GestoreToken.readAttributes(log, datiInvocazione, pddContext, protocolFactory, portaDelegata, idDominio, idServizio);
        }
        return esitoRecuperoAttributi;
    }

    public static InformazioniAttributi normalizeInformazioniAttributi(List<InformazioniAttributi> list, List<AttributeAuthority> aaList) throws Exception {
        int size = aaList.size();
        if (size == 1) {
            return list.get(0);
        }
        return new InformazioniAttributi(OpenSPCoop2Properties.getInstance().isGestioneAttributeAuthoritySaveSourceAttributeResponseInfo(), list.toArray(new InformazioniAttributi[1]));
    }

    public static TokenCacheItem getTokenCacheItem(String keyCache, String funzione, Date now, String debugMetodoChiamante, Integer refreshTokenBeforeExpirePercent, Integer refreshTokenBeforeExpireSeconds) throws TokenException {
        TokenCacheItem item = null;
        if (cacheGestioneToken != null) {
            CacheResponse response = (CacheResponse)cacheGestioneToken.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                    item = (TokenCacheItem)response.getObject();
                    item.setInCache(true);
                } else {
                    if (response.getException() != null) {
                        Exception e = (Exception)response.getException();
                        throw new TokenException("Trovata eccezione '" + response.getException().getClass().getName() + "' in cache non prevista: " + e.getMessage(), e);
                    }
                    GestoreToken.loggerError(MESSAGE_ELEMENT_CACHE_NE_OGGETTO_NE_ECCEZIONE);
                }
            }
            if (item != null) {
                item = GestoreToken.checkTokenCacheItem(item, keyCache, now, true, debugMetodoChiamante, refreshTokenBeforeExpirePercent, refreshTokenBeforeExpireSeconds);
            }
        }
        return item;
    }

    private static TokenCacheItem checkTokenCacheItem(TokenCacheItem item, String keyCache, Date nowParam, boolean debug, String debugMetodoChiamante, Integer refreshTokenBeforeExpirePercent, Integer refreshTokenBeforeExpireSeconds) {
        boolean tokenExpired = false;
        if (item.getExp() != null) {
            try {
                Date now = GestoreTokenNegoziazioneUtilities.updateNowForExpire(debugMetodoChiamante, nowParam, item.getIat(), item.getExp(), refreshTokenBeforeExpirePercent, refreshTokenBeforeExpireSeconds);
                tokenExpired = !now.before(item.getExp());
            }
            catch (Exception e) {
                GestoreToken.loggerError("Token presente in cache con chiave '" + keyCache + "', verifica scadenza '" + DateUtils.getSimpleDateFormatMs().format(item.getExp()) + "' fallita: " + e.getMessage(), e);
            }
        }
        if (tokenExpired) {
            if (debug) {
                GestoreToken.loggerDebug("Token presente in cache con chiave '" + keyCache + "' risulta scaduto in data '" + DateUtils.getSimpleDateFormatMs().format(item.getExp()) + "'");
            }
            return null;
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putTokenCacheItem(TokenCacheItem item, String keyCache, String funzione, Date now, String debugMetodoChiamante, Integer refreshTokenBeforeExpirePercent, Integer refreshTokenBeforeExpireSeconds) {
        if (cacheGestioneToken != null) {
            Semaphore lockNegoziazione = GestoreToken.getLockGenericToken(funzione);
            SemaphoreLock lock = lockNegoziazione.acquireThrowRuntime("putTokenCacheItem", item.getIdTransazione());
            try {
                CacheResponse response = (CacheResponse)cacheGestioneToken.get(keyCache);
                TokenCacheItem itemInCache = null;
                if (response != null && response.getObject() != null) {
                    GestoreToken.loggerDebug(GestoreToken.getMessageObjectInCache(response, keyCache, funzione));
                    itemInCache = (TokenCacheItem)response.getObject();
                    itemInCache.setInCache(true);
                }
                if (itemInCache != null) {
                    itemInCache = GestoreToken.checkTokenCacheItem(itemInCache, keyCache, now, false, debugMetodoChiamante, refreshTokenBeforeExpirePercent, refreshTokenBeforeExpireSeconds);
                }
                if (itemInCache == null) {
                    item.setInCache(false);
                    GestoreToken.loggerInfo(GestoreToken.getMessaggioAggiuntaOggettoInCache(keyCache));
                    try {
                        CacheResponse responseCache = new CacheResponse();
                        responseCache.setObject((Serializable)item);
                        cacheGestioneToken.put(keyCache, responseCache);
                    }
                    catch (UtilsException e) {
                        GestoreToken.loggerError(GestoreToken.getMessaggioErroreInserimentoInCache(keyCache, (Exception)((Object)e)));
                    }
                }
            }
            finally {
                lockNegoziazione.release(lock, "putTokenCacheItem", item.getIdTransazione());
            }
        }
    }
}

