/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkReaderWriter;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.ForwardProxy;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreExtBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPS;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCORE;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPSCORE;
import org.openspcoop2.pdd.core.controllo_traffico.PolicyTimeoutConfig;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.token.EsitoNegoziazioneToken;
import org.openspcoop2.pdd.core.token.GestoreToken;
import org.openspcoop2.pdd.core.token.InformazioniJWTClientAssertion;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken_DatiRichiesta;
import org.openspcoop2.pdd.core.token.NegoziazioneTokenDynamicParameters;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.dpop.DPoPBackendCacheEntry;
import org.openspcoop2.pdd.core.token.dpop.DPoPParams;
import org.openspcoop2.pdd.core.token.dpop.InformazioniJWTDpop;
import org.openspcoop2.pdd.core.token.parser.INegoziazioneTokenParser;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.digest.DigestType;
import org.openspcoop2.utils.digest.DigestUtils;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWSOptions;
import org.openspcoop2.utils.security.JsonSignature;
import org.openspcoop2.utils.security.JwtHeaders;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.slf4j.Logger;

public class GestoreTokenNegoziazioneUtilities {
    private static final String DPOP_HTTP_METHOD = "htm";
    private static final String DPOP_HTTP_URI = "htu";
    private static final String DPOP_ACCESS_TOKEN_HASH = "ath";
    private static final String DPOP_TYPE = "dpop+jwt";
    private static final String DPOP_BACKEND_CACHE_PREFIX = "DPOP_BACKEND_";

    private GestoreTokenNegoziazioneUtilities() {
    }

    static EsitoNegoziazioneToken endpointTokenEngine(boolean debug, Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, Busta busta, RequestInfo requestInfo, TipoPdD tipoPdD, NegoziazioneTokenDynamicParameters dynamicParameters, IProtocolFactory<?> protocolFactory, IState state, boolean delegata, String idModulo, PortaApplicativa pa, PortaDelegata pd, IDSoggetto idDominio, IDServizio idServizio, InformazioniNegoziazioneToken previousToken, InformazioniNegoziazioneToken_DatiRichiesta datiRichiesta) {
        EsitoNegoziazioneToken esito = null;
        boolean refreshModeEnabled = false;
        try {
            if (policyNegoziazioneToken.isClientCredentialsGrant()) {
                refreshModeEnabled = OpenSPCoop2Properties.getInstance().isGestioneRetrieveTokenRefreshTokenGrantTypeClientCredentials();
                if (datiRichiesta != null) {
                    datiRichiesta.setGrantType("clientCredentials");
                }
            } else if (policyNegoziazioneToken.isUsernamePasswordGrant()) {
                refreshModeEnabled = OpenSPCoop2Properties.getInstance().isGestioneRetrieveTokenRefreshTokenGrantTypeUsernamePassword();
                if (datiRichiesta != null) {
                    datiRichiesta.setGrantType("usernamePassword");
                }
            } else if (policyNegoziazioneToken.isRfc7523x509Grant()) {
                refreshModeEnabled = OpenSPCoop2Properties.getInstance().isGestioneRetrieveTokenRefreshTokenGrantTypeRfc7523x509();
                if (datiRichiesta != null) {
                    datiRichiesta.setGrantType("rfc7523_x509");
                }
            } else if (policyNegoziazioneToken.isRfc7523ClientSecretGrant()) {
                refreshModeEnabled = OpenSPCoop2Properties.getInstance().isGestioneRetrieveTokenRefreshTokenGrantTypeRfc7523ClientSecret();
                if (datiRichiesta != null) {
                    datiRichiesta.setGrantType("rfc7523_clientSecret");
                }
            } else if (policyNegoziazioneToken.isCustomGrant()) {
                refreshModeEnabled = OpenSPCoop2Properties.getInstance().isGestioneRetrieveTokenRefreshTokenGrantTypeCustom();
                if (datiRichiesta != null) {
                    datiRichiesta.setGrantType("custom");
                }
            }
        }
        catch (Exception t) {
            log.error("Errore durante la comprensione della modalit\u00e0 di refresh: " + t.getMessage(), (Throwable)t);
        }
        if (refreshModeEnabled && previousToken != null && previousToken.getRefreshToken() != null) {
            try {
                if (previousToken.getRefreshExpiresIn() != null) {
                    Date now = DateManager.getDate();
                    OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
                    if (!(now = GestoreTokenNegoziazioneUtilities.updateNowForExpire("RefreshToken", now, previousToken.getRetrievedRefreshTokenIn(), previousToken.getRefreshExpiresIn(), properties.getGestioneRetrieveTokenRefreshTokenBeforeExpirePercent(), properties.getGestioneRetrieveTokenRefreshTokenBeforeExpireSeconds())).before(previousToken.getRefreshExpiresIn())) {
                        log.debug("Refresh token scaduto");
                        refreshModeEnabled = false;
                    }
                }
                if (refreshModeEnabled) {
                    esito = GestoreTokenNegoziazioneUtilities.invokeEndpointToken(debug, log, policyNegoziazioneToken, busta, requestInfo, tipoPdD, dynamicParameters, protocolFactory, state, delegata, idModulo, pa, pd, idDominio, idServizio, refreshModeEnabled, previousToken, datiRichiesta);
                    if (esito != null && esito.isValido()) {
                        boolean checkPerRinegoziazione = false;
                        GestoreTokenNegoziazioneUtilities.validazioneInformazioniNegoziazioneToken(checkPerRinegoziazione, esito, policyNegoziazioneToken);
                        if (datiRichiesta != null) {
                            datiRichiesta.setRefresh(true);
                        }
                        return esito;
                    }
                    if (esito == null || esito.getEccezioneProcessamento() == null) {
                        throw new TokenException("token not refreshed");
                    }
                    throw new TokenException("token not refreshed: " + String.valueOf(esito.getEccezioneProcessamento()));
                }
            }
            catch (Exception t) {
                String msgError = "Refresh token failed: " + t.getMessage();
                log.error(msgError);
            }
        }
        if (datiRichiesta != null) {
            datiRichiesta.setRefresh(null);
        }
        return GestoreTokenNegoziazioneUtilities.invokeEndpointToken(debug, log, policyNegoziazioneToken, busta, requestInfo, tipoPdD, dynamicParameters, protocolFactory, state, delegata, idModulo, pa, pd, idDominio, idServizio, false, null, datiRichiesta);
    }

    private static EsitoNegoziazioneToken invokeEndpointToken(boolean debug, Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, Busta busta, RequestInfo requestInfo, TipoPdD tipoPdD, NegoziazioneTokenDynamicParameters dynamicParameters, IProtocolFactory<?> protocolFactory, IState state, boolean delegata, String idModulo, PortaApplicativa pa, PortaDelegata pd, IDSoggetto idDominio, IDServizio idServizio, boolean refreshModeEnabled, InformazioniNegoziazioneToken previousToken, InformazioniNegoziazioneToken_DatiRichiesta datiRichiesta) {
        EsitoNegoziazioneToken esitoNegoziazioneToken = new EsitoNegoziazioneToken();
        esitoNegoziazioneToken.setTokenInternalError();
        try {
            String detailsError = null;
            InformazioniNegoziazioneToken informazioniToken = null;
            Exception eProcess = null;
            INegoziazioneTokenParser tokenParser = policyNegoziazioneToken.getNegoziazioneTokenParser();
            HttpResponse httpResponse = null;
            Integer httpResponseCode = null;
            byte[] risposta = null;
            try {
                httpResponse = GestoreTokenNegoziazioneUtilities.http(debug, log, policyNegoziazioneToken, busta, requestInfo, tipoPdD, dynamicParameters, protocolFactory, state, delegata, idModulo, pa, pd, idDominio, idServizio, refreshModeEnabled, refreshModeEnabled && previousToken != null ? previousToken.getRefreshToken() : null, datiRichiesta);
                risposta = httpResponse.getContent();
                httpResponseCode = httpResponse.getResultHTTPOperation();
            }
            catch (Exception e) {
                detailsError = "(Errore di Connessione) " + e.getMessage();
                eProcess = e;
            }
            if (detailsError == null) {
                try {
                    if (datiRichiesta != null && datiRichiesta.getPrepareRequest() != null) {
                        datiRichiesta.setParseResponse(DateManager.getDate());
                    }
                    informazioniToken = new InformazioniNegoziazioneToken(datiRichiesta, httpResponseCode, new String(risposta), tokenParser, previousToken);
                }
                catch (Exception e) {
                    detailsError = "Risposta del servizio di negoziazione token non valida: " + e.getMessage();
                    eProcess = e;
                }
            }
            if (informazioniToken != null && informazioniToken.isValid()) {
                esitoNegoziazioneToken.setTokenValido();
                esitoNegoziazioneToken.setInformazioniNegoziazioneToken(informazioniToken);
                esitoNegoziazioneToken.setToken(informazioniToken.getAccessToken());
                esitoNegoziazioneToken.setNoCache(false);
            } else {
                esitoNegoziazioneToken.setTokenValidazioneFallita();
                esitoNegoziazioneToken.setNoCache(!policyNegoziazioneToken.isSaveErrorInCache());
                esitoNegoziazioneToken.setEccezioneProcessamento(eProcess);
                if (detailsError != null) {
                    esitoNegoziazioneToken.setDetails(detailsError);
                } else {
                    esitoNegoziazioneToken.setDetails("AccessToken non recuperabile");
                }
                if (OpenSPCoop2Properties.getInstance().isGestioneRetrieveTokenSaveTokenInfoRetrieveFailed()) {
                    if (informazioniToken != null) {
                        if (httpResponseCode != null) {
                            informazioniToken.setHttpResponseCode("" + httpResponseCode);
                        }
                        informazioniToken.setErrorDetails(esitoNegoziazioneToken.getDetails());
                    } else {
                        informazioniToken = new InformazioniNegoziazioneToken(datiRichiesta, esitoNegoziazioneToken.getDetails(), httpResponseCode, risposta);
                    }
                    esitoNegoziazioneToken.setInformazioniNegoziazioneToken(informazioniToken);
                }
            }
        }
        catch (Exception e) {
            esitoNegoziazioneToken.setTokenInternalError();
            esitoNegoziazioneToken.setDetails(e.getMessage());
            esitoNegoziazioneToken.setEccezioneProcessamento(e);
        }
        if (datiRichiesta != null && datiRichiesta.getPrepareRequest() != null) {
            datiRichiesta.setProcessComplete(DateManager.getDate());
        }
        return esitoNegoziazioneToken;
    }

    static String buildPrefixCacheKeyNegoziazione(String policy, String funzione) {
        StringBuilder bf = new StringBuilder(funzione);
        bf.append("_");
        bf.append(policy);
        bf.append("_");
        return bf.toString();
    }

    static String buildCacheKeyNegoziazione(String policy, String funzione, boolean portaDelegata, NegoziazioneTokenDynamicParameters dynamicParameters) {
        StringBuilder bf = new StringBuilder();
        bf.append(GestoreTokenNegoziazioneUtilities.buildPrefixCacheKeyNegoziazione(policy, funzione));
        if (portaDelegata) {
            bf.append("PD");
        } else {
            bf.append("PA");
        }
        bf.append("_");
        String dynamicParametersKeyCache = dynamicParameters.toString("_", true);
        bf.append(dynamicParametersKeyCache);
        return bf.toString();
    }

    static void validazioneInformazioniNegoziazioneToken(boolean checkPerRinegoziazione, EsitoNegoziazioneToken esitoNegoziazioneToken, PolicyNegoziazioneToken policyNegoziazioneToken) {
        String actualTokenType;
        String expectedTokenType;
        Date now = DateManager.getDate();
        if (esitoNegoziazioneToken.isValido()) {
            esitoNegoziazioneToken.setDateValide(true);
        }
        if (!(!esitoNegoziazioneToken.isValido() || policyNegoziazioneToken == null || (expectedTokenType = policyNegoziazioneToken.getExpectedTokenType()) == null || expectedTokenType.trim().isEmpty() || (actualTokenType = esitoNegoziazioneToken.getInformazioniNegoziazioneToken().getTokenType()) != null && expectedTokenType.trim().equalsIgnoreCase(actualTokenType.trim()))) {
            esitoNegoziazioneToken.setTokenValidazioneFallita();
            esitoNegoziazioneToken.setDetails("Invalid token_type: expected '" + expectedTokenType + "', found '" + (actualTokenType != null ? actualTokenType : "null") + "'");
        }
        if (esitoNegoziazioneToken.isValido() && esitoNegoziazioneToken.getInformazioniNegoziazioneToken().getExpiresIn() != null) {
            if (checkPerRinegoziazione) {
                OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
                now = GestoreTokenNegoziazioneUtilities.updateNowForExpire("NegoziazioneToken", now, esitoNegoziazioneToken.getInformazioniNegoziazioneToken().getRetrievedIn(), esitoNegoziazioneToken.getInformazioniNegoziazioneToken().getExpiresIn(), properties.getGestioneRetrieveTokenRefreshTokenBeforeExpirePercent(), properties.getGestioneRetrieveTokenRefreshTokenBeforeExpireSeconds());
            }
            if (!now.before(esitoNegoziazioneToken.getInformazioniNegoziazioneToken().getExpiresIn())) {
                esitoNegoziazioneToken.setTokenScaduto();
                esitoNegoziazioneToken.setDateValide(false);
                esitoNegoziazioneToken.setDetails("AccessToken expired");
            }
        }
        if (!esitoNegoziazioneToken.isValido()) {
            boolean saveErrorInCache = policyNegoziazioneToken != null ? policyNegoziazioneToken.isSaveErrorInCache() : false;
            esitoNegoziazioneToken.setNoCache(!saveErrorInCache);
        }
    }

    static Map<String, Object> buildDynamicNegoziazioneTokenMap(Busta busta, RequestInfo requestInfo, PdDContext pddContext, Logger log) {
        return TokenUtilities.buildDynamicMap(busta, requestInfo, pddContext, log);
    }

    private static HttpResponse http(boolean debug, Logger log, PolicyNegoziazioneToken policyNegoziazioneToken, Busta busta, RequestInfo requestInfo, TipoPdD tipoPdD, NegoziazioneTokenDynamicParameters dynamicParameters, IProtocolFactory<?> protocolFactory, IState state, boolean delegata, String idModulo, PortaApplicativa pa, PortaDelegata pd, IDSoggetto idDominio, IDServizio idServizio, boolean refreshModeEnabled, String refreshToken, InformazioniNegoziazioneToken_DatiRichiesta datiRichiesta) throws TokenException, UtilsException, SecurityException {
        Properties convertTextToProperties;
        String httpHeaders;
        Properties convertTextToProperties2;
        boolean pdnd;
        String endpoint = dynamicParameters.getEndpoint();
        if (datiRichiesta != null) {
            datiRichiesta.setEndpoint(endpoint);
        }
        HttpRequestMethod httpMethod = dynamicParameters.getHttpMethod();
        Properties endpointConfig = policyNegoziazioneToken.getProperties().get("endpointConfig");
        boolean https = policyNegoziazioneToken.isEndpointHttps();
        boolean httpsClient = false;
        Properties sslConfig = null;
        Properties sslClientConfig = null;
        if (https) {
            sslConfig = policyNegoziazioneToken.getProperties().get("sslConfig");
            httpsClient = policyNegoziazioneToken.isHttpsAuthentication();
            if (httpsClient) {
                sslClientConfig = policyNegoziazioneToken.getProperties().get("sslClientConfig");
                TokenUtilities.injectSameKeystoreForHttpsClient(sslConfig, sslClientConfig);
            }
        }
        boolean basic = policyNegoziazioneToken.isBasicAuthentication();
        boolean basicAsAuthorizationHeader = policyNegoziazioneToken.isBasicAuthenticationAsAuthorizationHeader();
        String username = null;
        String password = null;
        if (basic) {
            username = dynamicParameters.getBasicUsername();
            password = dynamicParameters.getBasicPassword();
            if (datiRichiesta != null) {
                datiRichiesta.setClientId(username);
            }
        }
        boolean bearer = policyNegoziazioneToken.isBearerAuthentication();
        String bearerToken = null;
        if (bearer) {
            bearerToken = dynamicParameters.getBearerToken();
            if (datiRichiesta != null) {
                datiRichiesta.setClientToken(bearerToken);
            }
        }
        ConnettoreMsg connettoreMsg = new ConnettoreMsg();
        ConnettoreExtBaseHTTP connettore = null;
        List portProperty = List.of();
        if (pd != null) {
            portProperty = pd.getProprieta();
        }
        if (pa != null) {
            portProperty = pa.getProprieta();
        }
        HttpLibrary lib = CostantiProprieta.getConnettoreHttpLibrary(portProperty, "connettori.token.retrieve.httplibrary");
        if (https) {
            connettoreMsg.setTipoConnettore(TipiConnettore.HTTPS.getNome());
            connettore = lib.equals((Object)HttpLibrary.HTTP_CORE5) ? new ConnettoreHTTPSCORE() : new ConnettoreHTTPS();
        } else {
            connettoreMsg.setTipoConnettore(TipiConnettore.HTTP.getNome());
            connettore = lib.equals((Object)HttpLibrary.HTTP_CORE5) ? new ConnettoreHTTPCORE() : new ConnettoreHTTP();
        }
        connettoreMsg.setIdModulo(idModulo);
        connettoreMsg.setState(state);
        PolicyTimeoutConfig policyConfig = new PolicyTimeoutConfig();
        policyConfig.setPolicyNegoziazione(policyNegoziazioneToken.getName());
        connettoreMsg.setPolicyTimeoutConfig(policyConfig);
        ForwardProxy forwardProxy = null;
        ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
        if (configurazionePdDManager.isForwardProxyEnabled(requestInfo)) {
            try {
                IDGenericProperties policy = new IDGenericProperties();
                policy.setTipologia("retrievePolicyToken");
                policy.setNome(policyNegoziazioneToken.getName());
                forwardProxy = delegata ? configurazionePdDManager.getForwardProxyConfigFruizione(idDominio, idServizio, policy, requestInfo) : configurazionePdDManager.getForwardProxyConfigErogazione(idDominio, idServizio, policy, requestInfo);
            }
            catch (Exception e) {
                throw new TokenException(GestoreToken.getMessageErroreGovWayProxy(e), e);
            }
        }
        if (forwardProxy != null && forwardProxy.isEnabled() && forwardProxy.getConfigToken() != null && forwardProxy.getConfigToken().isTokenRetrieveEnabled()) {
            connettoreMsg.setForwardProxy(forwardProxy);
        }
        connettore.setForceDisableProxyPassReverse(true);
        connettore.init(dynamicParameters.getPddContext(), protocolFactory, new Object[0]);
        connettore.setRegisterSendIntoContext(false);
        if (basic && basicAsAuthorizationHeader) {
            InvocazioneCredenziali credenziali = new InvocazioneCredenziali();
            credenziali.setUser(username);
            credenziali.setPassword(password);
            connettoreMsg.setCredenziali(credenziali);
        }
        connettoreMsg.setConnectorProperties(new HashMap<String, String>());
        connettoreMsg.getConnectorProperties().put("location", endpoint);
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        Boolean debugTramiteProperties = properties.getGestioneRetrieveTokenDebug();
        if (debugTramiteProperties != null) {
            if (debugTramiteProperties.booleanValue()) {
                connettoreMsg.getConnectorProperties().put("debug", "true");
            }
        } else if (debug) {
            connettoreMsg.getConnectorProperties().put("debug", "true");
        }
        connettoreMsg.getConnectorProperties().put("dataTransferMode", TransferLengthModes.CONTENT_LENGTH.getNome());
        GestoreToken.addProperties(connettoreMsg, endpointConfig);
        if (https) {
            GestoreToken.addProperties(connettoreMsg, sslConfig);
            if (httpsClient) {
                GestoreToken.addProperties(connettoreMsg, sslClientConfig);
            }
        }
        TransportRequestContext transportRequestContext = new TransportRequestContext(log);
        transportRequestContext.setRequestType(httpMethod.name());
        transportRequestContext.setHeaders(new HashMap());
        if (bearer) {
            String authorizationHeader = "Bearer " + bearerToken;
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Authorization", (String)authorizationHeader);
        }
        HashMap pContent = new HashMap();
        boolean custom = false;
        if (refreshModeEnabled) {
            TransportUtils.setParameter(pContent, (String)"grant_type", (String)"refresh_token");
            TransportUtils.setParameter(pContent, (String)"refresh_token", (String)refreshToken);
        } else if (policyNegoziazioneToken.isClientCredentialsGrant()) {
            TransportUtils.setParameter(pContent, (String)"grant_type", (String)"client_credentials");
        } else if (policyNegoziazioneToken.isRfc7523x509Grant() || policyNegoziazioneToken.isRfc7523ClientSecretGrant()) {
            TransportUtils.setParameter(pContent, (String)"grant_type", (String)"client_credentials");
            TransportUtils.setParameter(pContent, (String)"client_assertion_type", (String)"urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        } else if (policyNegoziazioneToken.isUsernamePasswordGrant()) {
            TransportUtils.setParameter(pContent, (String)"grant_type", (String)"password");
        } else if (policyNegoziazioneToken.isCustomGrant()) {
            custom = true;
        } else {
            throw new TokenException("Nessuna modalit\u00e0 definita");
        }
        transportRequestContext.removeHeader("Content-Type");
        String contentType = null;
        if (custom) {
            contentType = dynamicParameters.getHttpContentType();
            if (contentType != null && StringUtils.isNotEmpty((CharSequence)contentType)) {
                TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Content-Type", (String)contentType);
            }
        } else {
            contentType = "application/x-www-form-urlencoded";
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"Content-Type", (String)contentType);
        }
        if (!custom && basic && !basicAsAuthorizationHeader) {
            TransportUtils.setParameter(pContent, (String)"client_id", (String)username);
            TransportUtils.setParameter(pContent, (String)"client_secret", (String)password);
        }
        if (policyNegoziazioneToken.isUsernamePasswordGrant()) {
            String usernamePasswordGrantUsername = dynamicParameters.getUsernamePasswordGrantUsername();
            String usernamePasswordGrantPassword = dynamicParameters.getUsernamePasswordGrantPassword();
            TransportUtils.setParameter(pContent, (String)"username", (String)usernamePasswordGrantUsername);
            TransportUtils.setParameter(pContent, (String)"password", (String)usernamePasswordGrantPassword);
            if (datiRichiesta != null) {
                datiRichiesta.setUsername(usernamePasswordGrantUsername);
            }
        }
        if (policyNegoziazioneToken.isRfc7523x509Grant() || policyNegoziazioneToken.isRfc7523ClientSecretGrant()) {
            String jwt = GestoreTokenNegoziazioneUtilities.buildJwt(policyNegoziazioneToken, busta, tipoPdD, dynamicParameters, protocolFactory, requestInfo);
            String signedJwt = GestoreTokenNegoziazioneUtilities.signJwt(policyNegoziazioneToken, jwt, contentType, dynamicParameters, busta, requestInfo, log);
            TransportUtils.setParameter(pContent, (String)"client_assertion", (String)signedJwt);
            if (datiRichiesta != null) {
                boolean infoNormalizzate = properties.isGestioneRetrieveTokenGrantTypeRfc7523SaveClientAssertionJWTInfoTransazioniRegistrazioneInformazioniNormalizzate();
                datiRichiesta.setJwtClientAssertion(new InformazioniJWTClientAssertion(log, signedJwt, infoNormalizzate));
            }
        }
        if (!custom) {
            String aud;
            List<String> scopes = policyNegoziazioneToken.getScopes(dynamicParameters);
            if (scopes != null && !scopes.isEmpty()) {
                StringBuilder bf = new StringBuilder();
                for (String scope : scopes) {
                    if (bf.length() > 0) {
                        bf.append(" ");
                    }
                    bf.append(scope);
                }
                if (bf.length() > 0) {
                    TransportUtils.setParameter(pContent, (String)"scope", (String)bf.toString());
                    if (datiRichiesta != null) {
                        datiRichiesta.setScope(scopes);
                    }
                }
            }
            if ((aud = dynamicParameters.getAudience()) != null && !"".equals(aud)) {
                TransportUtils.setParameter(pContent, (String)"audience", (String)aud);
                if (datiRichiesta != null) {
                    datiRichiesta.setAudience(aud);
                }
            }
        }
        if (pdnd = GestoreTokenNegoziazioneUtilities.isTokenPolicyVersoPDND(policyNegoziazioneToken, OpenSPCoop2Properties.getInstance(), protocolFactory)) {
            String formResource;
            String nomeSoggettoInterno;
            OpenSPCoop2Properties op2Properties;
            String formClientId = dynamicParameters.getFormClientId();
            if (formClientId == null && (op2Properties = OpenSPCoop2Properties.getInstance()).isGestioneRetrieveTokenPdndDatiRichiestaForceClientId(protocolFactory != null ? protocolFactory.getProtocol() : null, nomeSoggettoInterno = GestoreTokenNegoziazioneUtilities.getNomeSoggettoInterno(busta, tipoPdD, protocolFactory, requestInfo, op2Properties))) {
                formClientId = dynamicParameters.getSignedJwtClientId();
            }
            if (formClientId != null && !"".equals(formClientId) && !"${undefined}".equals(formClientId)) {
                TransportUtils.setParameter(pContent, (String)"client_id", (String)formClientId);
                if (datiRichiesta != null && datiRichiesta.getClientId() == null) {
                    datiRichiesta.setClientId(formClientId);
                }
            }
            if ((formResource = dynamicParameters.getFormResource()) != null && !"".equals(formResource) && !"${undefined}".equals(formResource)) {
                TransportUtils.setParameter(pContent, (String)"resource", (String)formResource);
            }
        }
        String parameters = dynamicParameters.getParameters();
        if (!(custom || parameters == null || "".equals(parameters) || (convertTextToProperties2 = PropertiesUtilities.convertTextToProperties((String)parameters)) == null || convertTextToProperties2.isEmpty())) {
            HashMap<String, String> mapParameters = new HashMap<String, String>();
            Enumeration<Object> keys = convertTextToProperties2.keys();
            while (keys.hasMoreElements()) {
                String valore;
                String nome = (String)keys.nextElement();
                if (nome == null || "".equals(nome) || (valore = convertTextToProperties2.getProperty(nome)) == null) continue;
                TransportUtils.setParameter(pContent, (String)nome, (String)valore);
                mapParameters.put(nome, valore);
            }
            if (datiRichiesta != null && !mapParameters.isEmpty()) {
                datiRichiesta.setParameters(mapParameters);
            }
        }
        if ((httpHeaders = dynamicParameters.getHttpHeaders()) != null && !"".equals(httpHeaders) && (convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)httpHeaders)) != null && !convertTextToProperties.isEmpty()) {
            HashMap<String, String> mapHttpHeaders = new HashMap<String, String>();
            Enumeration<Object> keys = convertTextToProperties.keys();
            while (keys.hasMoreElements()) {
                String valore;
                String nome = (String)keys.nextElement();
                if (nome == null || "".equals(nome) || (valore = convertTextToProperties.getProperty(nome)) == null) continue;
                TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)nome, (String)valore);
                mapHttpHeaders.put(nome, valore);
            }
            if (datiRichiesta != null && !mapHttpHeaders.isEmpty()) {
                datiRichiesta.setHttpHeaders(mapHttpHeaders);
            }
        }
        if (policyNegoziazioneToken.isDpop()) {
            DPoPParams dpopParams = new DPoPParams();
            dpopParams.setPolicyNegoziazioneToken(policyNegoziazioneToken);
            dpopParams.setHttpMethod(HttpRequestMethod.POST.name());
            dpopParams.setHttpUri(endpoint);
            dpopParams.setBusta(busta);
            dpopParams.setRequestInfo(requestInfo);
            dpopParams.setLog(log);
            String dpopProof = GestoreTokenNegoziazioneUtilities.signDPoP(dpopParams, dynamicParameters);
            TransportUtils.setHeader((Map)transportRequestContext.getHeaders(), (String)"DPoP", (String)dpopProof);
            if (datiRichiesta != null) {
                boolean infoNormalizzate = properties.isGestioneRetrieveTokenDpopSaveDpopInfoTransazioniRegistrazioneInformazioniNormalizzate();
                datiRichiesta.setDpop(new InformazioniJWTDpop(log, dpopProof, infoNormalizzate));
            }
        }
        String prefixUrl = "PREFIX?";
        byte[] content = null;
        if (custom) {
            contentString = dynamicParameters.getHttpPayload();
            if (contentString != null && StringUtils.isNotEmpty((CharSequence)contentString)) {
                content = contentString.getBytes();
                connettoreMsg.forceSendContent();
            }
        } else {
            contentString = TransportUtils.buildUrlWithParameters(pContent, (String)prefixUrl, (Logger)log);
            if ((contentString = contentString.substring(prefixUrl.length())).startsWith("&") && contentString.length() > 1) {
                contentString = contentString.substring(1);
            }
            content = contentString.getBytes();
        }
        try {
            OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(MessageType.BINARY, transportRequestContext, content);
            OpenSPCoop2Message msg = pr.getMessage_throwParseException();
            connettoreMsg.setRequestMessage(msg);
            connettoreMsg.setGenerateErrorWithConnectorPrefix(false);
            connettore.setHttpMethod(msg);
            connettore.setPa(pa);
            connettore.setPd(pd);
        }
        catch (Exception e) {
            throw new TokenException(e.getMessage(), e);
        }
        ResponseCachingConfigurazione responseCachingConfigurazione = new ResponseCachingConfigurazione();
        responseCachingConfigurazione.setStato(StatoFunzionalita.DISABILITATO);
        String prefixConnettore = "[EndpointNegoziazioneToken: " + endpoint + "] ";
        if (endpointConfig.containsKey("proxyHostname")) {
            String hostProxy = endpointConfig.getProperty("proxyHostname");
            String portProxy = endpointConfig.getProperty("proxyPort");
            prefixConnettore = prefixConnettore + GestoreToken.getMessageViaProxy(hostProxy, portProxy);
        }
        if (datiRichiesta != null && datiRichiesta.getPrepareRequest() != null) {
            datiRichiesta.setSendRequest(DateManager.getDate());
        }
        boolean send = connettore.send(responseCachingConfigurazione, connettoreMsg);
        if (datiRichiesta != null && datiRichiesta.getPrepareRequest() != null) {
            datiRichiesta.setReceiveResponse(DateManager.getDate());
        }
        if (!send) {
            if (connettore.getEccezioneProcessamento() != null) {
                throw new TokenException(prefixConnettore + connettore.getErrore(), connettore.getEccezioneProcessamento());
            }
            throw new TokenException(prefixConnettore + connettore.getErrore());
        }
        OpenSPCoop2Message msgResponse = connettore.getResponse();
        ByteArrayOutputStream bout = null;
        if (msgResponse != null) {
            try {
                bout = new ByteArrayOutputStream();
                if (msgResponse != null) {
                    msgResponse.writeTo((OutputStream)bout, true);
                }
                bout.flush();
                bout.close();
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setResultHTTPOperation(connettore.getCodiceTrasporto());
        if (connettore.getCodiceTrasporto() >= 200 && connettore.getCodiceTrasporto() < 299) {
            String msgSuccess = prefixConnettore + GestoreToken.getMessageConnettoreConnessioneSuccesso(connettore);
            if (bout != null && bout.size() > 0) {
                log.debug(msgSuccess);
                httpResponse.setContent(bout.toByteArray());
                return httpResponse;
            }
            throw new TokenException(msgSuccess + "; non \u00e8 pervenuta alcuna risposta");
        }
        String msgError = prefixConnettore + GestoreToken.getMessageConnettoreConnessioneErrore(connettore);
        if (bout != null && bout.size() > 0) {
            String e = msgError + ": " + bout.toString();
            log.debug(e);
            httpResponse.setContent(bout.toByteArray());
            return httpResponse;
        }
        log.error(msgError);
        throw new TokenException(msgError);
    }

    private static String getNomeSoggettoInterno(Busta busta, TipoPdD tipoPdD, IProtocolFactory<?> protocolFactory, RequestInfo requestInfo, OpenSPCoop2Properties op2Properties) {
        String nomeSoggettoInterno = null;
        nomeSoggettoInterno = TipoPdD.APPLICATIVA.equals((Object)tipoPdD) && busta != null && busta.getDestinatario() != null ? busta.getDestinatario() : (TipoPdD.DELEGATA.equals((Object)tipoPdD) && busta != null && busta.getMittente() != null ? busta.getMittente() : op2Properties.getIdentitaPortaDefault(protocolFactory != null ? protocolFactory.getProtocol() : null, requestInfo).getNome());
        return nomeSoggettoInterno;
    }

    private static boolean isTokenPolicyVersoPDND(PolicyNegoziazioneToken policyNegoziazioneToken, OpenSPCoop2Properties op2Properties, IProtocolFactory<?> protocolFactory) throws TokenException {
        boolean pdnd = policyNegoziazioneToken.isPDND();
        if (!pdnd) {
            try {
                pdnd = policyNegoziazioneToken.getEndpoint() != null && RegularExpressionEngine.isMatch((String)policyNegoziazioneToken.getEndpoint(), (String)op2Properties.getGestioneRetrieveTokenPdndUrlPatternMatch(protocolFactory != null ? protocolFactory.getProtocol() : null));
            }
            catch (RegExpNotFoundException notFound) {
                pdnd = false;
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        return pdnd;
    }

    private static String buildJwt(PolicyNegoziazioneToken policyNegoziazioneToken, Busta busta, TipoPdD tipoPdD, NegoziazioneTokenDynamicParameters dynamicParameters, IProtocolFactory<?> protocolFactory, RequestInfo requestInfo) throws TokenException, UtilsException {
        String claims;
        String digestAudit;
        Properties convertTextToProperties;
        String jwtAudience;
        String subject;
        String clientId;
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        JSONUtils jsonUtils = JSONUtils.getInstance((boolean)false);
        ObjectNode jwtPayload = jsonUtils.newObjectNode();
        boolean pdnd = GestoreTokenNegoziazioneUtilities.isTokenPolicyVersoPDND(policyNegoziazioneToken, op2Properties, protocolFactory);
        String nomeSoggettoInterno = GestoreTokenNegoziazioneUtilities.getNomeSoggettoInterno(busta, tipoPdD, protocolFactory, requestInfo, op2Properties);
        long nowMs = DateManager.getTimeMillis();
        long nowSeconds = nowMs / 1000L;
        String issuer = dynamicParameters.getSignedJwtIssuer();
        if (issuer == null) {
            issuer = nomeSoggettoInterno;
        }
        if (!"${undefined}".equals(issuer)) {
            jwtPayload.put("iss", issuer);
        }
        if ((clientId = dynamicParameters.getSignedJwtClientId()) == null) {
            throw new TokenException("ClientID undefined");
        }
        if (!("${undefined}".equals(clientId) || pdnd && !op2Properties.isGestioneRetrieveTokenPdndPayloadClientId(protocolFactory != null ? protocolFactory.getProtocol() : null, nomeSoggettoInterno))) {
            jwtPayload.put("client_id", clientId);
        }
        if (StringUtils.isNotEmpty((CharSequence)(subject = dynamicParameters.getSignedJwtSubject()))) {
            if (!"${undefined}".equals(subject)) {
                jwtPayload.put("sub", subject);
            }
        } else if (!"${undefined}".equals(clientId)) {
            jwtPayload.put("sub", clientId);
        }
        if ((jwtAudience = dynamicParameters.getSignedJwtAudience()) == null) {
            throw new TokenException("JWT-Audience undefined");
        }
        if (!"${undefined}".equals(jwtAudience)) {
            jwtPayload.put("aud", jwtAudience);
        }
        jwtPayload.put("iat", nowSeconds);
        if (!pdnd || op2Properties.isGestioneRetrieveTokenPdndPayloadNbf(protocolFactory != null ? protocolFactory.getProtocol() : null, nomeSoggettoInterno)) {
            jwtPayload.put("nbf", nowSeconds);
        }
        int ttl = -1;
        try {
            ttl = policyNegoziazioneToken.getJwtTtlSeconds();
        }
        catch (Exception e) {
            throw new TokenException("Invalid JWT-TimeToLive value: " + e.getMessage(), e);
        }
        long expired = nowSeconds + (long)ttl;
        jwtPayload.put("exp", expired);
        String jti = dynamicParameters.getSignedJwtJti();
        if (StringUtils.isNotEmpty((CharSequence)jti)) {
            if (!"${undefined}".equals(jti)) {
                jwtPayload.put("jti", jti);
            }
        } else {
            String uuid = null;
            try {
                uuid = UniqueIdentifierManager.newUniqueIdentifier().toString();
            }
            catch (Exception e) {
                throw new TokenException("Invalid JWT-TimeToLive value: " + e.getMessage(), e);
            }
            jwtPayload.put("jti", uuid);
        }
        if (policyNegoziazioneToken.isPDND()) {
            String sessionInfo;
            String jwtPurposeId = dynamicParameters.getSignedJwtPurposeId();
            if (jwtPurposeId == null) {
                throw new TokenException("JWT-PurposeId undefined");
            }
            if (!"${undefined}".equals(jwtPurposeId)) {
                jwtPayload.put("purposeId", jwtPurposeId);
            }
            if ((sessionInfo = dynamicParameters.getSignedJwtSessionInfo()) != null && !"".equals(sessionInfo)) {
                convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)sessionInfo);
                ObjectNode sessionInfoPayload = null;
                if (convertTextToProperties != null && !convertTextToProperties.isEmpty()) {
                    Enumeration<Object> keys = convertTextToProperties.keys();
                    while (keys.hasMoreElements()) {
                        String valore;
                        String nome = (String)keys.nextElement();
                        if (nome == null || "".equals(nome) || (valore = convertTextToProperties.getProperty(nome)) == null) continue;
                        if (sessionInfoPayload == null) {
                            sessionInfoPayload = jsonUtils.newObjectNode();
                        }
                        jsonUtils.putValue(sessionInfoPayload, nome, valore);
                    }
                }
                if (sessionInfoPayload != null) {
                    jwtPayload.set("sessionInfo", sessionInfoPayload);
                }
            }
        }
        if ((digestAudit = dynamicParameters.getSignedJwtAuditDigest()) != null && StringUtils.isNotEmpty((CharSequence)digestAudit)) {
            String algorithm = dynamicParameters.getSignedJwtAuditDigestAlgo();
            if (algorithm == null || StringUtils.isEmpty((CharSequence)algorithm)) {
                algorithm = "SHA256";
            }
            ObjectNode digest = jsonUtils.newObjectNode();
            digest.put("alg", algorithm);
            digest.put("value", digestAudit);
            jwtPayload.set("digest", (JsonNode)digest);
        }
        if ((claims = dynamicParameters.getSignedJwtClaims()) != null && !"".equals(claims) && (convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)claims)) != null && !convertTextToProperties.isEmpty()) {
            Enumeration<Object> keys = convertTextToProperties.keys();
            while (keys.hasMoreElements()) {
                String valore;
                String nome = (String)keys.nextElement();
                if (nome == null || "".equals(nome) || (valore = convertTextToProperties.getProperty(nome)) == null) continue;
                jsonUtils.putValue(jwtPayload, nome, valore);
            }
        }
        return jsonUtils.toString((JsonNode)jwtPayload);
    }

    public static KeystoreParams readKeystoreParams(PolicyNegoziazioneToken policyNegoziazioneToken) throws TokenException {
        KeystoreParams kp = new KeystoreParams();
        String keystoreType = policyNegoziazioneToken.getJwtSignKeystoreType();
        if (keystoreType == null) {
            throw new TokenException("JWT Signature keystore type undefined");
        }
        kp.setType(keystoreType);
        GestoreTokenNegoziazioneUtilities.fillKeystoreParams(policyNegoziazioneToken, keystoreType, kp);
        String keyAlias = policyNegoziazioneToken.getJwtSignKeyAlias();
        if (keyAlias == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
            throw new TokenException("JWT Signature key alias undefined");
        }
        kp.setKeyAlias(keyAlias);
        String keyPassword = policyNegoziazioneToken.getJwtSignKeyPassword();
        if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature key password undefined");
            }
        }
        kp.setKeyPassword(keyPassword);
        return kp;
    }

    private static void fillKeystoreParams(PolicyNegoziazioneToken policyNegoziazioneToken, String keystoreType, KeystoreParams kp) throws TokenException {
        String keystoreFile = null;
        String keystoreFilePublicKey = null;
        String keyPairAlgorithm = null;
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            keystoreFile = policyNegoziazioneToken.getJwtSignKeystoreFile();
            if (keystoreFile == null) {
                throw new TokenException("JWT Signature private key file undefined");
            }
            kp.setPath(keystoreFile);
            keystoreFilePublicKey = policyNegoziazioneToken.getJwtSignKeystoreFilePublicKey();
            if (keystoreFilePublicKey == null) {
                throw new TokenException("JWT Signature public key file undefined");
            }
            kp.setKeyPairPublicKeyPath(keystoreFilePublicKey);
            keyPairAlgorithm = policyNegoziazioneToken.getJwtSignKeyPairAlgorithm();
            if (keyPairAlgorithm == null) {
                throw new TokenException("JWT Signature key pair algorithm undefined");
            }
            kp.setKeyPairAlgorithm(keyPairAlgorithm);
        } else {
            keystoreFile = policyNegoziazioneToken.getJwtSignKeystoreFile();
            if (keystoreFile == null) {
                throw new TokenException("JWT Signature keystore file undefined");
            }
            kp.setPath(keystoreFile);
        }
        GestoreTokenNegoziazioneUtilities.fillKeystoreParamsPassword(policyNegoziazioneToken, keystoreType, kp);
        String keystoreByokPolicy = policyNegoziazioneToken.getJwtSignKeystoreByokPolicy();
        kp.setByokPolicy(keystoreByokPolicy);
    }

    private static void fillKeystoreParamsPassword(PolicyNegoziazioneToken policyNegoziazioneToken, String keystoreType, KeystoreParams kp) throws TokenException {
        String keystorePassword = policyNegoziazioneToken.getJwtSignKeystorePassword();
        if (!(keystorePassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12PasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature keystore password undefined");
            }
        }
        kp.setPassword(keystorePassword);
    }

    private static String signJwt(PolicyNegoziazioneToken policyNegoziazioneToken, String payload, String contentType, NegoziazioneTokenDynamicParameters dynamicParameters, Busta busta, RequestInfo requestInfo, Logger log) throws TokenException, SecurityException, UtilsException {
        Certificate cert;
        String type;
        String url;
        String signAlgo = policyNegoziazioneToken.getJwtSignAlgorithm();
        if (signAlgo == null) {
            throw new TokenException("SignAlgorithm undefined");
        }
        KeyStore ks = null;
        KeyPairStore keyPairStore = null;
        JWKSetStore jwtStore = null;
        String keyAlias = null;
        String keyPassword = null;
        if (policyNegoziazioneToken.isRfc7523x509Grant()) {
            if (policyNegoziazioneToken.isJwtSignKeystoreApplicativoModI()) {
                dynamicMap = null;
                if (dynamicParameters.isByokPolicyDefinedApplicativoModI()) {
                    dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, dynamicParameters.getPddContext(), log);
                }
                if ((keystoreType = dynamicParameters.getTipoKeystoreApplicativoModI()) == null) {
                    throw new TokenException("JWT Signature keystore type undefined");
                }
                if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
                    keyPairStore = dynamicParameters.getKeyPairStoreApplicativoModI(dynamicMap);
                    if (keyPairStore == null) {
                        throw new TokenException("JWT Signature keyPair undefined");
                    }
                } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) ? (jwtStore = dynamicParameters.getJWKSetStoreApplicativoModI(dynamicMap)) == null : (ks = dynamicParameters.getKeystoreApplicativoModI(dynamicMap)) == null) {
                    throw new TokenException("JWT Signature keystore undefined");
                }
                if ((keyAlias = dynamicParameters.getKeyAliasApplicativoModI()) == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
                    throw new TokenException("JWT Signature key alias undefined");
                }
                keyPassword = dynamicParameters.getKeyPasswordApplicativoModI();
                if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
                    throw new TokenException("JWT Signature key password undefined");
                }
            } else if (policyNegoziazioneToken.isJwtSignKeystoreFruizioneModI()) {
                dynamicMap = null;
                if (dynamicParameters.isByokPolicyDefinedFruizioneModI()) {
                    dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, dynamicParameters.getPddContext(), log);
                }
                if ((keystoreType = dynamicParameters.getTipoKeystoreFruizioneModI()) == null) {
                    throw new TokenException("JWT Signature keystore type undefined");
                }
                if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
                    keyPairStore = dynamicParameters.getKeyPairStoreFruizioneModI(dynamicMap);
                    if (keyPairStore == null) {
                        throw new TokenException("JWT Signature keyPair undefined");
                    }
                } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) ? (jwtStore = dynamicParameters.getJWKSetStoreFruizioneModI(dynamicMap)) == null : (ks = dynamicParameters.getKeystoreFruizioneModI(dynamicMap)) == null) {
                    throw new TokenException("JWT Signature keystore undefined");
                }
                if ((keyAlias = dynamicParameters.getKeyAliasFruizioneModI()) == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
                    throw new TokenException("JWT Signature key alias undefined");
                }
                keyPassword = dynamicParameters.getKeyPasswordFruizioneModI();
                if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
                    throw new TokenException("JWT Signature key password undefined");
                }
            } else {
                KeystoreParams kp = GestoreTokenNegoziazioneUtilities.readKeystoreParams(policyNegoziazioneToken);
                keystoreType = kp.getType();
                String keystoreFile = kp.getPath();
                String keystoreFilePublicKey = kp.getKeyPairPublicKeyPath();
                String keyPairAlgorithm = kp.getKeyPairAlgorithm();
                String keystorePassword = kp.getPassword();
                keyAlias = kp.getKeyAlias();
                keyPassword = kp.getKeyPassword();
                String keystoreByokPolicy = kp.getByokPolicy();
                BYOKRequestParams byokParams = null;
                if (BYOKProvider.isPolicyDefined((String)keystoreByokPolicy)) {
                    Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, dynamicParameters.getPddContext(), log);
                    byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)keystoreByokPolicy, dynamicMap);
                }
                if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
                    keyPairStore = GestoreKeystoreCache.getKeyPairStore((RequestInfo)requestInfo, (String)keystoreFile, (String)keystoreFilePublicKey, (String)keyPassword, (String)keyPairAlgorithm, (BYOKRequestParams)byokParams);
                } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType)) {
                    jwtStore = GestoreKeystoreCache.getJwkSetStore((RequestInfo)requestInfo, (String)keystoreFile, (BYOKRequestParams)byokParams);
                } else {
                    MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)keystoreFile, (String)keystoreType, (String)keystorePassword, (BYOKRequestParams)byokParams);
                    if (merlinKs == null) {
                        throw new TokenException("Accesso al keystore '" + keystoreFile + "' non riuscito");
                    }
                    ks = merlinKs.getKeyStore();
                }
            }
        }
        JWSOptions options = new JWSOptions(JOSESerialization.COMPACT);
        JwtHeaders jwtHeaders = new JwtHeaders();
        if (policyNegoziazioneToken.isJwtSignIncludeKeyIdWithKeyAlias()) {
            jwtHeaders.setKid(keyAlias);
        } else if (policyNegoziazioneToken.isJwtSignIncludeKeyIdWithClientId()) {
            clientId = dynamicParameters.getSignedJwtClientId();
            jwtHeaders.setKid(clientId);
        } else if (policyNegoziazioneToken.isJwtSignIncludeKeyIdCustom()) {
            String customId = dynamicParameters.getSignedJwtCustomId();
            jwtHeaders.setKid(customId);
        } else if (policyNegoziazioneToken.isJwtSignIncludeKeyIdApplicativoModI()) {
            clientId = dynamicParameters.getKidApplicativoModI();
            jwtHeaders.setKid(clientId);
        } else if (policyNegoziazioneToken.isJwtSignIncludeKeyIdFruizioneModI()) {
            clientId = dynamicParameters.getKidFruizioneModI();
            jwtHeaders.setKid(clientId);
        }
        if (policyNegoziazioneToken.isJwtSignIncludeX509Cert()) {
            jwtHeaders.setAddX5C(true);
        }
        if ((url = dynamicParameters.getSignedJwtX509Url()) != null && !"".equals(url)) {
            try {
                jwtHeaders.setX509Url(new URI(url));
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        }
        if (policyNegoziazioneToken.isJwtSignIncludeX509CertSha1()) {
            jwtHeaders.setX509IncludeCertSha1(true);
        }
        if (policyNegoziazioneToken.isJwtSignIncludeX509CertSha256()) {
            jwtHeaders.setX509IncludeCertSha256(true);
        }
        if (policyNegoziazioneToken.isJwtSignJoseContentType() && contentType != null && !"".equals(contentType)) {
            jwtHeaders.setContentType(contentType);
        }
        if ((type = policyNegoziazioneToken.getJwtSignJoseType()) != null && !"".equals(type) && !"${undefined}".equals(type)) {
            jwtHeaders.setType(type);
        }
        if (ks != null && (cert = ks.getCertificate(keyAlias)) instanceof X509Certificate) {
            jwtHeaders.addX509cert((X509Certificate)cert);
        }
        if (policyNegoziazioneToken.isRfc7523ClientSecretGrant()) {
            String clientSecret = policyNegoziazioneToken.getJwtClientSecret();
            if (clientSecret == null) {
                throw new TokenException("ClientSecret undefined");
            }
            JsonSignature jsonSignature = new JsonSignature(clientSecret, signAlgo, jwtHeaders, options);
            return jsonSignature.sign(payload);
        }
        if (policyNegoziazioneToken.isRfc7523x509Grant()) {
            JsonSignature jsonSignature = null;
            if (keyPairStore != null || jwtStore != null) {
                JsonWebKeys jwk = null;
                if (keyPairStore != null) {
                    jwk = keyPairStore.getJwkSet().getJsonWebKeys();
                    keyAlias = keyPairStore.getJwkSetKid();
                } else {
                    jwk = jwtStore.getJwkSet().getJsonWebKeys();
                }
                jsonSignature = new JsonSignature(jwk, false, keyAlias, signAlgo, jwtHeaders, options);
            } else {
                jsonSignature = new JsonSignature(ks, false, keyAlias, keyPassword, signAlgo, jwtHeaders, options);
            }
            return jsonSignature.sign(payload);
        }
        throw new TokenException("JWT Signed mode unknown");
    }

    private static String buildDPoPPayload(String httpMethod, String httpUri, String accessToken) throws TokenException, UtilsException {
        JSONUtils jsonUtils = JSONUtils.getInstance((boolean)false);
        ObjectNode dpopPayload = jsonUtils.newObjectNode();
        String jti = null;
        try {
            jti = UniqueIdentifierManager.newUniqueIdentifier().toString();
        }
        catch (Exception e) {
            throw new TokenException("Unable to generate jti: " + e.getMessage(), e);
        }
        dpopPayload.put("jti", jti);
        dpopPayload.put(DPOP_HTTP_METHOD, httpMethod);
        String htu = TokenUtilities.normalizeHtu(httpUri);
        dpopPayload.put(DPOP_HTTP_URI, htu);
        long nowSeconds = DateManager.getTimeMillis() / 1000L;
        dpopPayload.put("iat", nowSeconds);
        if (accessToken != null && !accessToken.isEmpty()) {
            String ath = GestoreTokenNegoziazioneUtilities.computeAccessTokenHash(accessToken);
            dpopPayload.put(DPOP_ACCESS_TOKEN_HASH, ath);
        }
        return jsonUtils.toString((JsonNode)dpopPayload);
    }

    public static String computeAccessTokenHash(String accessToken) throws TokenException {
        try {
            byte[] hash = DigestUtils.getDigestValue((byte[])accessToken.getBytes(StandardCharsets.US_ASCII), (String)DigestType.SHA256.getAlgorithmName());
            return Base64Utilities.encodeBase64URLSafeString((byte[])hash);
        }
        catch (Exception e) {
            throw new TokenException("Unable to compute access token hash: " + e.getMessage(), e);
        }
    }

    public static String buildDPoPBackendCacheKey(String policyName, String httpMethod, String httpUri, String ath) throws TokenException {
        String htu = TokenUtilities.normalizeHtu(httpUri);
        return DPOP_BACKEND_CACHE_PREFIX + policyName + "_" + httpMethod + "_" + htu + "_" + ath;
    }

    public static boolean isDPoPBackendCacheEntryValid(DPoPBackendCacheEntry entry, int ttlSeconds, OpenSPCoop2Properties op2Properties) {
        if (entry == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        long ageMs = now - entry.getCreationTime();
        long ttlMs = (long)ttlSeconds * 1000L;
        Integer refreshBeforeExpirePercent = op2Properties.getGestioneRetrieveTokenDpopBackendRefreshBeforeExpirePercent();
        Integer refreshBeforeExpireSeconds = op2Properties.getGestioneRetrieveTokenDpopBackendRefreshBeforeExpireSeconds();
        long effectiveTtlMs = ttlMs;
        if (refreshBeforeExpirePercent != null && refreshBeforeExpirePercent > 0) {
            effectiveTtlMs = ttlMs - ttlMs * (long)refreshBeforeExpirePercent.intValue() / 100L;
        } else if (refreshBeforeExpireSeconds != null && refreshBeforeExpireSeconds > 0) {
            effectiveTtlMs = ttlMs - (long)refreshBeforeExpireSeconds.intValue() * 1000L;
        }
        return ageMs < effectiveTtlMs;
    }

    public static KeystoreParams readDPoPKeystoreParams(PolicyNegoziazioneToken policyNegoziazioneToken) throws TokenException {
        KeystoreParams kp = new KeystoreParams();
        String keystoreType = policyNegoziazioneToken.getDpopSignKeystoreType();
        if (keystoreType == null) {
            throw new TokenException("JWT Signature keystore type undefined");
        }
        kp.setType(keystoreType);
        GestoreTokenNegoziazioneUtilities.fillDPoPKeystoreParams(policyNegoziazioneToken, keystoreType, kp);
        String keyAlias = policyNegoziazioneToken.getDpopSignKeyAlias();
        if (keyAlias == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
            throw new TokenException("JWT Signature key alias undefined");
        }
        kp.setKeyAlias(keyAlias);
        String keyPassword = policyNegoziazioneToken.getDpopSignKeyPassword();
        if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature key password undefined");
            }
        }
        kp.setKeyPassword(keyPassword);
        return kp;
    }

    private static void fillDPoPKeystoreParams(PolicyNegoziazioneToken policyNegoziazioneToken, String keystoreType, KeystoreParams kp) throws TokenException {
        String keystoreFile = null;
        String keystoreFilePublicKey = null;
        String keyPairAlgorithm = null;
        if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
            keystoreFile = policyNegoziazioneToken.getDpopSignKeystoreFile();
            if (keystoreFile == null) {
                throw new TokenException("JWT Signature private key file undefined");
            }
            kp.setPath(keystoreFile);
            keystoreFilePublicKey = policyNegoziazioneToken.getDpopSignKeystoreFilePublicKey();
            if (keystoreFilePublicKey == null) {
                throw new TokenException("JWT Signature public key file undefined");
            }
            kp.setKeyPairPublicKeyPath(keystoreFilePublicKey);
            keyPairAlgorithm = policyNegoziazioneToken.getDpopSignKeyPairAlgorithm();
            if (keyPairAlgorithm == null) {
                throw new TokenException("JWT Signature key pair algorithm undefined");
            }
            kp.setKeyPairAlgorithm(keyPairAlgorithm);
        } else {
            keystoreFile = policyNegoziazioneToken.getDpopSignKeystoreFile();
            if (keystoreFile == null) {
                throw new TokenException("JWT Signature keystore file undefined");
            }
            kp.setPath(keystoreFile);
        }
        GestoreTokenNegoziazioneUtilities.fillDPoPKeystoreParamsPassword(policyNegoziazioneToken, keystoreType, kp);
        String keystoreByokPolicy = policyNegoziazioneToken.getDpopSignKeystoreByokPolicy();
        kp.setByokPolicy(keystoreByokPolicy);
    }

    private static void fillDPoPKeystoreParamsPassword(PolicyNegoziazioneToken policyNegoziazioneToken, String keystoreType, KeystoreParams kp) throws TokenException {
        String keystorePassword = policyNegoziazioneToken.getDpopSignKeystorePassword();
        if (!(keystorePassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
            boolean required = true;
            if (KeystoreType.JKS.isType(keystoreType)) {
                required = DBUtils.isKeystoreJksPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(keystoreType)) {
                required = DBUtils.isKeystorePkcs12PasswordRequired();
            }
            if (required) {
                throw new TokenException("JWT Signature keystore password undefined");
            }
        }
        kp.setPassword(keystorePassword);
    }

    public static String signDPoP(DPoPParams params) throws TokenException, SecurityException, UtilsException {
        return GestoreTokenNegoziazioneUtilities.signDPoP(params, params.getDynamicParameters());
    }

    static String signDPoP(DPoPParams params, NegoziazioneTokenDynamicParameters dynamicParameters) throws TokenException, SecurityException, UtilsException {
        PolicyNegoziazioneToken policyNegoziazioneToken = params.getPolicyNegoziazioneToken();
        Busta busta = params.getBusta();
        RequestInfo requestInfo = params.getRequestInfo();
        Logger log = params.getLog();
        String signAlgo = policyNegoziazioneToken.getDpopSignAlgorithm();
        if (signAlgo == null) {
            throw new TokenException("DPoP SignAlgorithm undefined");
        }
        String payload = GestoreTokenNegoziazioneUtilities.buildDPoPPayload(params.getHttpMethod(), params.getHttpUri(), params.getAccessToken());
        KeyStore ks = null;
        KeyPairStore keyPairStore = null;
        JWKSetStore jwtStore = null;
        String keyAlias = null;
        String keyPassword = null;
        if (policyNegoziazioneToken.isDpopSignKeystoreApplicativoModI()) {
            boolean useDPoPKeystore = dynamicParameters.hasKeystoreDPoPApplicativoModI();
            dynamicMap = null;
            if (useDPoPKeystore ? dynamicParameters.isByokPolicyDefinedDPoPApplicativoModI() : dynamicParameters.isByokPolicyDefinedApplicativoModI()) {
                dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, dynamicParameters.getPddContext(), log);
            }
            String string = keystoreType = useDPoPKeystore ? dynamicParameters.getTipoKeystoreDPoPApplicativoModI() : dynamicParameters.getTipoKeystoreApplicativoModI();
            if (keystoreType == null) {
                throw new TokenException("JWT Signature keystore type undefined");
            }
            if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
                KeyPairStore keyPairStore2 = keyPairStore = useDPoPKeystore ? dynamicParameters.getKeyPairStoreDPoPApplicativoModI(dynamicMap) : dynamicParameters.getKeyPairStoreApplicativoModI(dynamicMap);
                if (keyPairStore == null) {
                    throw new TokenException("JWT Signature keyPair undefined");
                }
            } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType)) {
                JWKSetStore jWKSetStore = jwtStore = useDPoPKeystore ? dynamicParameters.getJWKSetStoreDPoPApplicativoModI(dynamicMap) : dynamicParameters.getJWKSetStoreApplicativoModI(dynamicMap);
                if (jwtStore == null) {
                    throw new TokenException("JWT Signature keystore undefined");
                }
            } else {
                KeyStore keyStore = ks = useDPoPKeystore ? dynamicParameters.getKeystoreDPoPApplicativoModI(dynamicMap) : dynamicParameters.getKeystoreApplicativoModI(dynamicMap);
                if (ks == null) {
                    throw new TokenException("JWT Signature keystore undefined");
                }
            }
            String string2 = keyAlias = useDPoPKeystore ? dynamicParameters.getKeyAliasDPoPApplicativoModI() : dynamicParameters.getKeyAliasApplicativoModI();
            if (keyAlias == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
                throw new TokenException("JWT Signature key alias undefined");
            }
            String string3 = keyPassword = useDPoPKeystore ? dynamicParameters.getKeyPasswordDPoPApplicativoModI() : dynamicParameters.getKeyPasswordApplicativoModI();
            if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
                throw new TokenException("JWT Signature key password undefined");
            }
        } else if (policyNegoziazioneToken.isDpopSignKeystoreFruizioneModI()) {
            boolean useDPoPKeystore = dynamicParameters.hasKeystoreDPoPFruizioneModI();
            dynamicMap = null;
            if (useDPoPKeystore ? dynamicParameters.isByokPolicyDefinedDPoPFruizioneModI() : dynamicParameters.isByokPolicyDefinedFruizioneModI()) {
                dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, dynamicParameters.getPddContext(), log);
            }
            String string = keystoreType = useDPoPKeystore ? dynamicParameters.getTipoKeystoreDPoPFruizioneModI() : dynamicParameters.getTipoKeystoreFruizioneModI();
            if (keystoreType == null) {
                throw new TokenException("JWT Signature keystore type undefined");
            }
            if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
                KeyPairStore keyPairStore3 = keyPairStore = useDPoPKeystore ? dynamicParameters.getKeyPairStoreDPoPFruizioneModI(dynamicMap) : dynamicParameters.getKeyPairStoreFruizioneModI(dynamicMap);
                if (keyPairStore == null) {
                    throw new TokenException("JWT Signature keyPair undefined");
                }
            } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType)) {
                JWKSetStore jWKSetStore = jwtStore = useDPoPKeystore ? dynamicParameters.getJWKSetStoreDPoPFruizioneModI(dynamicMap) : dynamicParameters.getJWKSetStoreFruizioneModI(dynamicMap);
                if (jwtStore == null) {
                    throw new TokenException("JWT Signature keystore undefined");
                }
            } else {
                KeyStore keyStore = ks = useDPoPKeystore ? dynamicParameters.getKeystoreDPoPFruizioneModI(dynamicMap) : dynamicParameters.getKeystoreFruizioneModI(dynamicMap);
                if (ks == null) {
                    throw new TokenException("JWT Signature keystore undefined");
                }
            }
            String string4 = keyAlias = useDPoPKeystore ? dynamicParameters.getKeyAliasDPoPFruizioneModI() : dynamicParameters.getKeyAliasFruizioneModI();
            if (keyAlias == null && !SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) && !SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType)) {
                throw new TokenException("JWT Signature key alias undefined");
            }
            String string5 = keyPassword = useDPoPKeystore ? dynamicParameters.getKeyPasswordDPoPFruizioneModI() : dynamicParameters.getKeyPasswordFruizioneModI();
            if (!(keyPassword != null || SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(keystoreType))) {
                throw new TokenException("JWT Signature key password undefined");
            }
        } else {
            KeystoreParams kp = GestoreTokenNegoziazioneUtilities.readDPoPKeystoreParams(policyNegoziazioneToken);
            String keystoreType = kp.getType();
            String keystoreFile = kp.getPath();
            String keystoreFilePublicKey = kp.getKeyPairPublicKeyPath();
            String keyPairAlgorithm = kp.getKeyPairAlgorithm();
            String keystorePassword = kp.getPassword();
            keyAlias = kp.getKeyAlias();
            keyPassword = kp.getKeyPassword();
            String keystoreByokPolicy = kp.getByokPolicy();
            BYOKRequestParams byokParams = null;
            if (BYOKProvider.isPolicyDefined((String)keystoreByokPolicy)) {
                PdDContext ctx = dynamicParameters != null ? dynamicParameters.getPddContext() : params.getPddContext();
                Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(busta, requestInfo, ctx, log);
                byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)keystoreByokPolicy, dynamicMap);
            }
            if (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(keystoreType)) {
                keyPairStore = GestoreKeystoreCache.getKeyPairStore((RequestInfo)requestInfo, (String)keystoreFile, (String)keystoreFilePublicKey, (String)keyPassword, (String)keyPairAlgorithm, byokParams);
            } else if (SecurityConstants.KEYSTORE_TYPE_JWK_VALUE.equalsIgnoreCase(keystoreType)) {
                jwtStore = GestoreKeystoreCache.getJwkSetStore((RequestInfo)requestInfo, (String)keystoreFile, byokParams);
            } else {
                MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)keystoreFile, (String)keystoreType, (String)keystorePassword, byokParams);
                if (merlinKs == null) {
                    throw new TokenException("Accesso al keystore '" + keystoreFile + "' non riuscito");
                }
                ks = merlinKs.getKeyStore();
            }
        }
        JWSOptions options = new JWSOptions(JOSESerialization.COMPACT);
        JwtHeaders jwtHeaders = new JwtHeaders();
        jwtHeaders.setType(DPOP_TYPE);
        JsonWebKey publicJwk = GestoreTokenNegoziazioneUtilities.extractPublicJwk(ks, keyPairStore, jwtStore, keyAlias);
        JwkReaderWriter jwkWriter = new JwkReaderWriter();
        String jwkJson = jwkWriter.jwkToJson(publicJwk);
        JSONUtils jsonUtils = JSONUtils.getInstance();
        JsonNode jwkNode = jsonUtils.getAsNode(jwkJson);
        if (jwkNode instanceof ObjectNode) {
            ObjectNode jwkObj = (ObjectNode)jwkNode;
            jwkObj.remove("kid");
            jwkObj.remove("alg");
            jwkObj.remove("use");
            jwkObj.remove("key_ops");
            jwkObj.remove("x5c");
            jwkObj.remove("x5t");
            jwkObj.remove("x5t#S256");
            jwkObj.remove("x5u");
            jwkJson = jsonUtils.toString((JsonNode)jwkObj);
        }
        Map jwkMap = (Map)jsonUtils.getAsObject(jwkJson, Map.class);
        jwtHeaders.setJwKeyRaw(jwkMap);
        JsonSignature jsonSignature = null;
        if (keyPairStore != null || jwtStore != null) {
            JsonWebKeys jwk = null;
            if (keyPairStore != null) {
                jwk = keyPairStore.getJwkSet().getJsonWebKeys();
                keyAlias = keyPairStore.getJwkSetKid();
            } else {
                jwk = jwtStore.getJwkSet().getJsonWebKeys();
            }
            jsonSignature = new JsonSignature(jwk, false, keyAlias, signAlgo, jwtHeaders, options);
        } else {
            jsonSignature = new JsonSignature(ks, false, keyAlias, keyPassword, signAlgo, jwtHeaders, options);
        }
        return jsonSignature.sign(payload);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JsonWebKey extractPublicJwk(KeyStore ks, KeyPairStore keyPairStore, JWKSetStore jwtStore, String keyAlias) throws TokenException, UtilsException, SecurityException {
        JsonWebKey fullKey = null;
        if (keyPairStore != null) {
            JsonWebKeys jwks = keyPairStore.getJwkSet().getJsonWebKeys();
            if (jwks.getKeys() == null || jwks.getKeys().isEmpty()) throw new TokenException("No keys found in KeyPairStore");
            fullKey = (JsonWebKey)jwks.getKeys().get(0);
            return GestoreTokenNegoziazioneUtilities.extractPublicJwk(fullKey);
        } else {
            if (jwtStore != null) {
                JsonWebKeys jwks = jwtStore.getJwkSet().getJsonWebKeys();
                if (keyAlias != null) {
                    fullKey = jwks.getKey(keyAlias);
                }
                if (fullKey == null && jwks.getKeys() != null && !jwks.getKeys().isEmpty()) {
                    fullKey = (JsonWebKey)jwks.getKeys().get(0);
                }
                if (fullKey != null) return GestoreTokenNegoziazioneUtilities.extractPublicJwk(fullKey);
                throw new TokenException("No keys found in JWKSetStore");
            }
            if (ks == null) throw new TokenException("No keystore available to extract public JWK");
            JWK jwk = new JWK(ks, keyAlias);
            fullKey = jwk.getJsonWebKey();
        }
        return GestoreTokenNegoziazioneUtilities.extractPublicJwk(fullKey);
    }

    private static JsonWebKey extractPublicJwk(JsonWebKey fullKey) throws TokenException {
        String keyType;
        String string = keyType = fullKey.getKeyType() != null ? fullKey.getKeyType().name() : null;
        if (KeyType.RSA.name().equals(keyType)) {
            RSAPublicKey publicKey = JwkUtils.toRSAPublicKey((JsonWebKey)fullKey);
            return JwkUtils.fromRSAPublicKey((RSAPublicKey)publicKey, (String)fullKey.getAlgorithm());
        }
        if (KeyType.EC.name().equals(keyType)) {
            ECPublicKey publicKey = JwkUtils.toECPublicKey((JsonWebKey)fullKey);
            String ecCurve = (String)fullKey.getProperty("crv");
            return JwkUtils.fromECPublicKey((ECPublicKey)publicKey, (String)ecCurve);
        }
        throw new TokenException("Unsupported key type for DPoP: " + keyType + " (only RSA and EC are supported)");
    }

    public static Date updateNowForExpire(String debugMetodoChiamante, Date nowParam, Date iat, Date exp, Integer refreshTokenBeforeExpirePercent, Integer refreshTokenBeforeExpireSeconds) {
        Date now = nowParam;
        int secondsPreExpire = -1;
        if (iat != null && refreshTokenBeforeExpirePercent != null && refreshTokenBeforeExpirePercent > 0) {
            float perc1;
            float perc2;
            int s;
            long secondsIat;
            int percent = refreshTokenBeforeExpirePercent;
            long secondsExpire = exp.getTime() / 1000L;
            long secondsDiff = secondsExpire - (secondsIat = iat.getTime() / 1000L);
            if (secondsDiff > 0L && (s = Math.round(perc2 = (perc1 = Float.parseFloat("" + secondsDiff) / 100.0f) * Float.parseFloat("" + percent))) > 0) {
                secondsPreExpire = s;
            }
        } else if (refreshTokenBeforeExpireSeconds != null && refreshTokenBeforeExpireSeconds > 0) {
            secondsPreExpire = refreshTokenBeforeExpireSeconds;
        }
        if (secondsPreExpire > 0) {
            now = new Date(now.getTime() + (long)(secondsPreExpire * 1000));
            if (debugMetodoChiamante != null) {
                // empty if block
            }
        }
        return now;
    }
}

