/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.pdd.core.token.DynamicDiscovery;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniTokenUserInfo;
import org.openspcoop2.pdd.core.token.SorgenteInformazioniToken;
import org.openspcoop2.pdd.core.token.TipoInformazioni;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.core.token.dpop.DPoP;
import org.openspcoop2.pdd.core.token.parser.ITokenParser;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.json.JSONUtils;

public class InformazioniToken
extends BaseBean
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private TipoInformazioni type = TipoInformazioni.validated_token;
    private boolean valid;
    private String iss;
    private String sub;
    private String username;
    private List<String> aud;
    private Date exp;
    private Date iat;
    private Date nbf;
    private String clientId;
    private String jti;
    private List<String> roles;
    private List<String> scopes;
    private InformazioniTokenUserInfo userInfo;
    private Map<String, Serializable> claims = new HashMap<String, Serializable>();
    private String rawResponse;
    private String token;
    private String httpResponseCode;
    private String errorDetails;
    private SorgenteInformazioniToken sourceType;
    private List<SorgenteInformazioniToken> sourceTypes = null;
    private Map<SorgenteInformazioniToken, String> sourcesTokenInfo = null;
    private DPoP dpop;
    private DynamicDiscovery dynamicDiscovery;
    private InformazioniAttributi aa;
    private InformazioniNegoziazioneToken retrievedToken;
    private Map<String, Serializable> pdnd = null;

    public InformazioniToken() {
    }

    public InformazioniToken(SorgenteInformazioniToken sourceType, String rawResponse, ITokenParser tokenParser) throws UtilsException {
        this(null, sourceType, rawResponse, tokenParser);
    }

    public InformazioniToken(Integer httpResponseCode, SorgenteInformazioniToken sourceType, String rawResponse, ITokenParser tokenParser) throws UtilsException {
        List<String> s;
        JsonNode root;
        Map readClaims;
        this.rawResponse = rawResponse;
        this.sourceType = sourceType;
        JSONUtils jsonUtils = JSONUtils.getInstance();
        if (jsonUtils.isJson(this.rawResponse) && (readClaims = jsonUtils.convertToSimpleMap(root = jsonUtils.getAsNode(this.rawResponse))) != null && readClaims.size() > 0) {
            this.claims.putAll(readClaims);
        }
        tokenParser.init(this.rawResponse, this.claims);
        if (httpResponseCode != null) {
            tokenParser.checkHttpTransaction(httpResponseCode);
        }
        this.valid = tokenParser.isValid();
        this.iss = tokenParser.getIssuer();
        this.sub = tokenParser.getSubject();
        this.username = tokenParser.getUsername();
        List<String> a = tokenParser.getAudience();
        if (a != null && !a.isEmpty()) {
            this.aud = new ArrayList<String>();
            this.aud.addAll(a);
        }
        this.exp = tokenParser.getExpired();
        this.iat = tokenParser.getIssuedAt();
        this.nbf = tokenParser.getNotToBeUsedBefore();
        this.clientId = tokenParser.getClientId();
        this.jti = tokenParser.getJWTIdentifier();
        List<String> r = tokenParser.getRoles();
        if (r != null && !r.isEmpty()) {
            this.roles = new ArrayList<String>();
            this.roles.addAll(r);
        }
        if ((s = tokenParser.getScopes()) != null && !s.isEmpty()) {
            this.scopes = new ArrayList<String>();
            this.scopes.addAll(s);
        }
        if (tokenParser.getUserInfoParser() != null) {
            this.userInfo = new InformazioniTokenUserInfo(this, tokenParser.getUserInfoParser());
        }
    }

    public InformazioniToken(String errorDetails, SorgenteInformazioniToken sourceType, String token) {
        this(errorDetails, null, null, sourceType, token);
    }

    public InformazioniToken(String errorDetails, Integer httpResponseCode, byte[] rawResponse, SorgenteInformazioniToken sourceType, String token) {
        this.valid = false;
        this.token = token;
        this.claims = null;
        this.sourceType = sourceType;
        if (httpResponseCode != null) {
            this.httpResponseCode = "" + httpResponseCode;
        }
        if (rawResponse != null) {
            this.rawResponse = new String(rawResponse);
        }
        this.errorDetails = errorDetails;
    }

    public InformazioniToken(boolean saveSourceTokenInfo, InformazioniToken ... informazioniTokens) throws UtilsException {
        if (informazioniTokens != null && informazioniTokens.length > 0) {
            List l;
            Object scopesV;
            List l2;
            Object rolesV;
            Object jtiV;
            Object clientIdV;
            Object nbfV;
            Object iatV;
            Object expV;
            List l3;
            Object audV;
            Object usernameV;
            Object subV;
            int i;
            if (saveSourceTokenInfo) {
                this.sourcesTokenInfo = new HashMap<SorgenteInformazioniToken, String>();
                for (i = 0; i < informazioniTokens.length; ++i) {
                    this.sourcesTokenInfo.put(informazioniTokens[i].getSourceType(), informazioniTokens[i].getRawResponse());
                }
            } else {
                this.sourceTypes = new ArrayList<SorgenteInformazioniToken>();
                for (i = 0; i < informazioniTokens.length; ++i) {
                    this.sourceTypes.add(informazioniTokens[i].getSourceType());
                }
            }
            for (i = 0; i < informazioniTokens.length; ++i) {
                if (informazioniTokens[i].getClaims().size() <= 0) continue;
                this.claims.putAll(informazioniTokens[i].getClaims());
            }
            Object issV = InformazioniToken.getValue("iss", informazioniTokens);
            if (issV instanceof String) {
                this.iss = (String)issV;
            }
            if ((subV = InformazioniToken.getValue("sub", informazioniTokens)) instanceof String) {
                this.sub = (String)subV;
            }
            if ((usernameV = InformazioniToken.getValue("username", informazioniTokens)) instanceof String) {
                this.username = (String)usernameV;
            }
            if ((audV = InformazioniToken.getValue("aud", informazioniTokens)) instanceof List && !(l3 = (List)audV).isEmpty()) {
                if (this.aud == null) {
                    this.aud = new ArrayList<String>();
                }
                this.aud.addAll(l3);
            }
            if ((expV = InformazioniToken.getValue("exp", informazioniTokens)) instanceof Date) {
                this.exp = (Date)expV;
            }
            if ((iatV = InformazioniToken.getValue("iat", informazioniTokens)) instanceof Date) {
                this.iat = (Date)iatV;
            }
            if ((nbfV = InformazioniToken.getValue("nbf", informazioniTokens)) instanceof Date) {
                this.nbf = (Date)nbfV;
            }
            if ((clientIdV = InformazioniToken.getValue("clientId", informazioniTokens)) instanceof String) {
                this.clientId = (String)clientIdV;
            }
            if ((jtiV = InformazioniToken.getValue("jti", informazioniTokens)) instanceof String) {
                this.jti = (String)jtiV;
            }
            if ((rolesV = InformazioniToken.getValue("roles", informazioniTokens)) instanceof List && !(l2 = (List)rolesV).isEmpty()) {
                if (this.roles == null) {
                    this.roles = new ArrayList<String>();
                }
                this.roles.addAll(l2);
            }
            if ((scopesV = InformazioniToken.getValue("scopes", informazioniTokens)) instanceof List && !(l = (List)scopesV).isEmpty()) {
                if (this.scopes == null) {
                    this.scopes = new ArrayList<String>();
                }
                this.scopes.addAll(l);
            }
            ArrayList<InformazioniTokenUserInfo> listUserInfo = new ArrayList<InformazioniTokenUserInfo>();
            for (int i2 = 0; i2 < informazioniTokens.length; ++i2) {
                InformazioniTokenUserInfo userInfoV = informazioniTokens[i2].getUserInfo();
                if (userInfoV == null) continue;
                listUserInfo.add(userInfoV);
            }
            this.userInfo = listUserInfo.size() == 1 ? (InformazioniTokenUserInfo)listUserInfo.get(0) : new InformazioniTokenUserInfo(listUserInfo.toArray(new InformazioniTokenUserInfo[1]));
        }
    }

    private static Object getValue(String field, InformazioniToken ... informazioniTokens) throws UtilsException {
        Object tmp = null;
        ArrayList<Object> listTmp = new ArrayList<Object>();
        String getMethodName = "get" + ("" + field.charAt(0)).toUpperCase() + field.substring(1);
        Method getMethod = null;
        try {
            getMethod = InformazioniToken.class.getMethod(getMethodName, new Class[0]);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        tmp = InformazioniToken.getValue(getMethod, listTmp, informazioniTokens);
        if (!listTmp.isEmpty()) {
            return listTmp;
        }
        return tmp;
    }

    private static Object getValue(Method getMethod, List<Object> listTmp, InformazioniToken ... informazioniTokens) throws UtilsException {
        Object tmp = null;
        for (int i = 0; i < informazioniTokens.length; ++i) {
            InformazioniToken infoToken = informazioniTokens[i];
            Object o = null;
            try {
                o = getMethod.invoke((Object)infoToken, new Object[0]);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
            if (o == null) continue;
            tmp = InformazioniToken.getValue(o, listTmp);
        }
        return tmp;
    }

    private static Object getValue(Object o, List<Object> listTmp) {
        Object tmp = null;
        if (o instanceof List) {
            List list = (List)o;
            if (!list.isEmpty()) {
                for (Object object : list) {
                    if (listTmp.contains(object)) continue;
                    listTmp.add(object);
                }
            }
        } else {
            tmp = o;
        }
        return tmp;
    }

    public TipoInformazioni getType() {
        return this.type;
    }

    public void setType(TipoInformazioni type) {
        this.type = type;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean getValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getIss() {
        return this.iss;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<String> getAud() {
        return this.aud;
    }

    public void setAud(List<String> aud) {
        this.aud = aud;
    }

    public Date getExp() {
        return this.exp;
    }

    public void setExp(Date exp) {
        this.exp = exp;
    }

    public Date getIat() {
        return this.iat;
    }

    public void setIat(Date iat) {
        this.iat = iat;
    }

    public Date getNbf() {
        return this.nbf;
    }

    public void setNbf(Date nbf) {
        this.nbf = nbf;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getJti() {
        return this.jti;
    }

    public void setJti(String jti) {
        this.jti = jti;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public InformazioniTokenUserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(InformazioniTokenUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public Map<String, Serializable> getClaims() {
        return this.claims;
    }

    public void setClaims(Map<String, Serializable> claims) {
        this.claims = claims;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public void setHttpResponseCode(String httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public SorgenteInformazioniToken getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SorgenteInformazioniToken sourceType) {
        this.sourceType = sourceType;
    }

    public Map<SorgenteInformazioniToken, String> getSourcesTokenInfo() {
        return this.sourcesTokenInfo;
    }

    public void setSourcesTokenInfo(Map<SorgenteInformazioniToken, String> sourcesTokenInfo) {
        this.sourcesTokenInfo = sourcesTokenInfo;
    }

    public List<SorgenteInformazioniToken> getSourceTypes() {
        return this.sourceTypes;
    }

    public void setSourceTypes(List<SorgenteInformazioniToken> sourceTypes) {
        this.sourceTypes = sourceTypes;
    }

    public DPoP getDpop() {
        return this.dpop;
    }

    public void setDpop(DPoP dpop) {
        this.dpop = dpop;
    }

    public DynamicDiscovery getDynamicDiscovery() {
        return this.dynamicDiscovery;
    }

    public void setDynamicDiscovery(DynamicDiscovery dynamicDiscovery) {
        this.dynamicDiscovery = dynamicDiscovery;
    }

    public InformazioniAttributi getAa() {
        return this.aa;
    }

    public void setAa(InformazioniAttributi aa) {
        this.aa = aa;
    }

    public InformazioniNegoziazioneToken getRetrievedToken() {
        return this.retrievedToken;
    }

    public void setRetrievedToken(InformazioniNegoziazioneToken retrievedToken) {
        this.retrievedToken = retrievedToken;
    }

    public Map<String, Serializable> getPdnd() {
        return this.pdnd;
    }

    public void setPdnd(Map<String, Serializable> pdnd) {
        this.pdnd = pdnd;
    }
}

