/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.IProvider;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderInfo;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.INegoziazioneTokenParser;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.utils.AbstractSecurityProvider;
import org.openspcoop2.security.utils.SignatureAlgorithmUtilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPProvider;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.SSLUtilities;

public class NegoziazioneTokenProvider
implements IProvider {
    private OCSPProvider ocspProvider = new OCSPProvider();
    private BYOKProvider byokProvider;
    private static boolean secret = false;

    public NegoziazioneTokenProvider() {
        try {
            this.byokProvider = BYOKProvider.getUnwrapInstance();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        boolean dpop;
        boolean proxy;
        boolean bearer;
        Properties pDefault = TokenUtilities.getDefaultProperties(mapProperties);
        boolean endpointSSL = TokenUtilities.isEnabled(pDefault, "policy.endpoint.https.stato");
        boolean ssl = TokenUtilities.isEnabled(pDefault, "policy.retrieveToken.endpoint.https.stato");
        if (endpointSSL || ssl) {
            this.validateEndpointSsl(mapProperties);
        }
        this.validateUrl(pDefault);
        String retMode = this.validateRetrieveMode(pDefault);
        boolean pdnd = TokenUtilities.isEnabled(pDefault, "policy.retrieveToken.jwt.pdnd");
        boolean basic = TokenUtilities.isEnabled(pDefault, "policy.retrieveToken.endpoint.basic.stato");
        if (basic) {
            this.validateBasicCredentials(pDefault);
        }
        if (bearer = TokenUtilities.isEnabled(pDefault, "policy.retrieveToken.endpoint.bearer.stato")) {
            String token = pDefault.getProperty("policy.retrieveToken.endpoint.bearer.token");
            InputValidationUtils.validateTextAreaInput((String)token, (String)"Token Endpoint - Autenticazione Client - Token");
        }
        if (ssl) {
            this.validateSslCredentials(mapProperties);
        }
        if (proxy = TokenUtilities.isEnabled(pDefault, "policy.endpoint.proxy.stato")) {
            this.validateProxy(mapProperties);
        }
        if ("rfc7523_x509".equals(retMode) || "rfc7523_clientSecret".equals(retMode)) {
            this.validateJWTSigned(pDefault, retMode, pdnd);
        }
        if (dpop = TokenUtilities.isEnabled(pDefault, "policy.retrieveToken.dpop")) {
            this.validateDPoP(pDefault);
        }
        this.validateFormParameters(pDefault, pdnd);
        this.validateCustomFormParameters(pDefault, pdnd);
        this.validateHeaders(pDefault);
        if ("custom".equals(retMode)) {
            this.validateTokenParser(pDefault);
        }
        this.validateForward(pDefault);
    }

    private void validateEndpointSsl(Map<String, Properties> mapProperties) throws ProviderValidationException {
        Properties p = mapProperties.get("sslConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia stato indicato un endpoint 'https', non \u00e8 stata fornita una configurazione dei parametri ssl da utilizzare");
        }
        String trustAllCerts = p.getProperty("trustAllCerts");
        boolean trustAll = false;
        if (trustAllCerts != null && StringUtils.isNotEmpty((CharSequence)trustAllCerts)) {
            trustAll = Boolean.valueOf(trustAllCerts);
        }
        if (!trustAll) {
            String location = p.getProperty("trustStoreLocation");
            InputValidationUtils.validateTextAreaInput((String)location, (String)"Https - Autenticazione Server - Path (TrustStore per l'autenticazione server)");
            String algo = p.getProperty("trustManagementAlgorithm");
            if (algo == null || "".equals(algo)) {
                throw new ProviderValidationException("Indicare un algoritmo per l'autenticazione server");
            }
            if (algo.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nell'algoritmo per l'autenticazione server");
            }
            String locationCRL = p.getProperty("trustStoreCRLs");
            if (locationCRL != null && !"".equals(locationCRL)) {
                InputValidationUtils.validateTextAreaInput((String)locationCRL, (String)"Https - Autenticazione Server - CRL File(s)");
            }
        }
    }

    private void validateUrl(Properties pDefault) throws ProviderValidationException {
        String url = pDefault.getProperty("policy.retrieveToken.endpoint.url");
        InputValidationUtils.validateTextAreaInput((String)url, (String)"Token Endpoint - URL");
        try {
            RegExpUtilities.validateUrl((String)url, (boolean)true);
        }
        catch (Exception e) {
            throw new ProviderValidationException("La URL fornita non \u00e8 valida: " + e.getMessage());
        }
    }

    private String validateRetrieveMode(Properties pDefault) throws ProviderValidationException {
        String retMode = pDefault.getProperty("policy.retrieveToken.mode");
        if ("usernamePassword".equals(retMode)) {
            String username = pDefault.getProperty("policy.retrieveToken.username");
            if (username == null || "".equals(username)) {
                throw new ProviderValidationException("Non \u00e8 stato fornito l'username");
            }
            if (username.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel'username");
            }
            String password = pDefault.getProperty("policy.retrieveToken.password");
            if (password == null || "".equals(password)) {
                throw new ProviderValidationException("Non \u00e8 stato fornita una password");
            }
            if (password.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nella password");
            }
        }
        return retMode;
    }

    private void validateBasicCredentials(Properties pDefault) throws ProviderValidationException {
        String username = pDefault.getProperty("policy.retrieveToken.endpoint.basic.username");
        if (username == null || "".equals(username)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornito un 'Client ID' da utilizzare durante la connessione verso il servizio");
        }
        if (username.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel 'Client ID'");
        }
        String password = pDefault.getProperty("policy.retrieveToken.endpoint.basic.password");
        if (password == null || "".equals(password)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornita un 'Client Secret' da utilizzare durante la connessione verso il servizio");
        }
        if (password.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel 'Client Secret'");
        }
    }

    private void validateSslCredentials(Map<String, Properties> mapProperties) throws ProviderValidationException {
        String algo;
        Properties p = mapProperties.get("sslClientConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'Https', non sono stati forniti i parametri di connessione ssl client da utilizzare verso il servizio");
        }
        String location = p.getProperty("keyStoreLocation");
        if (location != null && !"".equals(location)) {
            InputValidationUtils.validateTextAreaInput((String)location, (String)"Https - Autenticazione Client - Path (KeyStore per l'autenticazione client)");
        }
        if ((algo = p.getProperty("keyManagementAlgorithm")) == null || "".equals(algo)) {
            throw new ProviderValidationException("Indicare un algoritmo per l'autenticazione client");
        }
        if (algo.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'algoritmo per l'autenticazione client");
        }
    }

    private void validateProxy(Map<String, Properties> mapProperties) throws ProviderValidationException {
        Properties p = mapProperties.get("endpointConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia richiesta un proxy, non sono stati forniti i parametri di connessione");
        }
        String hostname = p.getProperty("proxyHostname");
        if (hostname == null || "".equals(hostname)) {
            throw new ProviderValidationException("Indicare un hostname per il Proxy");
        }
        if (hostname.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'hostname del Proxy");
        }
        String username = p.getProperty("proxyUsername");
        if (username != null && !"".equals(username) && username.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'username del Proxy");
        }
        String password = p.getProperty("proxyPassword");
        if (password != null && !"".equals(password) && password.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nella password del Proxy");
        }
    }

    private void validateJWTSigned(Properties pDefault, String retMode, boolean pdnd) throws ProviderValidationException {
        if ("rfc7523_x509".equals(retMode)) {
            this.validateJWTSignedx509(pDefault);
        }
        this.validateJWTSignedHeader(pDefault);
        this.validateJWTSignedPayload(pDefault, pdnd);
    }

    private void validateJWTSignedx509(Properties pDefault) throws ProviderValidationException {
        this.validateJWTSignedx509Keystore(pDefault);
        this.validateJWTSignedx509Key(pDefault);
    }

    private void validateJWTSignedx509Keystore(Properties pDefault) throws ProviderValidationException {
        String p;
        String file = pDefault.getProperty("policy.retrieveToken.jwt.signature.keystoreFile");
        InputValidationUtils.validateTextAreaInput((String)file, (String)"Token Endpoint - JWT KeyStore - Path");
        String fileChiavePubblica = pDefault.getProperty("policy.retrieveToken.jwt.signature.keystoreFilePublicKey");
        if (fileChiavePubblica != null && StringUtils.isNotEmpty((CharSequence)fileChiavePubblica)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Token Endpoint - JWT KeyStore - Chiave Pubblica");
        }
        if ((p = pDefault.getProperty("policy.retrieveToken.jwt.signature.keystorePassword")) != null) {
            if (p.startsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT KeyStore - Password', non deve iniziare con uno spazio");
            }
            if (p.endsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT KeyStore - Password', non deve terminare con uno spazio");
            }
        }
    }

    private void validateJWTSignedx509Key(Properties pDefault) throws ProviderValidationException {
        String p = pDefault.getProperty("policy.retrieveToken.jwt.signature.keyAlias");
        if (p != null) {
            if (p.startsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT KeyStore - Alias Chiave Privata', non deve iniziare con uno spazio");
            }
            if (p.endsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT KeyStore - Alias Chiave Privata', non deve terminare con uno spazio");
            }
        }
        if ((p = pDefault.getProperty("policy.retrieveToken.jwt.signature.keyPassword")) != null) {
            if (p.startsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT KeyStore - Password Chiave Privata', non deve iniziare con uno spazio");
            }
            if (p.endsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT KeyStore - Password Chiave Privata', non deve terminare con uno spazio");
            }
        }
    }

    private void validateDPoP(Properties pDefault) throws ProviderValidationException {
        this.validateDPoPKeystore(pDefault);
        this.validateDPoPKey(pDefault);
    }

    private void validateDPoPKeystore(Properties pDefault) throws ProviderValidationException {
        String p;
        String file = pDefault.getProperty("policy.retrieveToken.dpop.signature.keystoreFile");
        InputValidationUtils.validateTextAreaInput((String)file, (String)"DPoP KeyStore - Path");
        String fileChiavePubblica = pDefault.getProperty("policy.retrieveToken.dpop.signature.keystoreFilePublicKey");
        if (fileChiavePubblica != null && StringUtils.isNotEmpty((CharSequence)fileChiavePubblica)) {
            InputValidationUtils.validateTextAreaInput((String)fileChiavePubblica, (String)"DPoP KeyStore - Chiave Pubblica");
        }
        if ((p = pDefault.getProperty("policy.retrieveToken.dpop.signature.keystorePassword")) != null) {
            if (p.startsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'DPoP KeyStore - Password', non deve iniziare con uno spazio");
            }
            if (p.endsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'DPoP KeyStore - Password', non deve terminare con uno spazio");
            }
        }
    }

    private void validateDPoPKey(Properties pDefault) throws ProviderValidationException {
        String p = pDefault.getProperty("policy.retrieveToken.dpop.signature.keyAlias");
        if (p != null) {
            if (p.startsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'DPoP KeyStore - Alias Chiave Privata', non deve iniziare con uno spazio");
            }
            if (p.endsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'DPoP KeyStore - Alias Chiave Privata', non deve terminare con uno spazio");
            }
        }
        if ((p = pDefault.getProperty("policy.retrieveToken.dpop.signature.keyPassword")) != null) {
            if (p.startsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'DPoP KeyStore - Password Chiave Privata', non deve iniziare con uno spazio");
            }
            if (p.endsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'DPoP KeyStore - Password Chiave Privata', non deve terminare con uno spazio");
            }
        }
    }

    private void validateJWTSignedHeader(Properties pDefault) throws ProviderValidationException {
        String type;
        String kidValue;
        String kidMode = pDefault.getProperty("policy.retrieveToken.jwt.signature.include.key.id");
        if ("custom".equals(kidMode) && (kidValue = pDefault.getProperty("policy.retrieveToken.jwt.signature.include.key.id.value")) != null) {
            if (kidValue.startsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT Header - Key Id (kid)', non deve iniziare con uno spazio");
            }
            if (kidValue.endsWith(" ")) {
                throw new ProviderValidationException("Il valore indicato nel campo 'JWT Header - Key Id (kid)', non deve terminare con uno spazio");
            }
        }
        if ((type = pDefault.getProperty("policy.retrieveToken.jwt.signature.joseType")) != null && type.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel campo 'JWT Header - Type (typ)'");
        }
        String x5u = pDefault.getProperty("policy.retrieveToken.jwt.signature.include.x509url");
        if (x5u != null && !"".equals(x5u)) {
            InputValidationUtils.validateTextAreaInput((String)x5u, (String)"Token Endpoint - JWT Header - URL");
        }
    }

    private void validateJWTSignedPayload(Properties pDefault, boolean pdnd) throws ProviderValidationException {
        String clientId = pDefault.getProperty("policy.retrieveToken.jwt.clientId");
        if (clientId != null && clientId.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel campo 'JWT Payload - Client ID'");
        }
        String audience = pDefault.getProperty("policy.retrieveToken.jwt.audience");
        if (audience != null && audience.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel campo 'JWT Payload - Audience'");
        }
        String issuer = pDefault.getProperty("policy.retrieveToken.jwt.issuer");
        if (issuer != null && issuer.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel campo 'JWT Payload - Issuer'");
        }
        String subject = pDefault.getProperty("policy.retrieveToken.jwt.subject");
        if (subject != null && subject.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel campo 'JWT Payload - Subject'");
        }
        String jti = pDefault.getProperty("policy.retrieveToken.jwt.jti");
        if (jti != null && jti.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel campo 'JWT Payload - Identifier'");
        }
        if (pdnd) {
            this.validateJWTSignedPayloadPDND(pDefault);
        }
        this.validateJWTSignedClaims(pDefault, pdnd);
    }

    private void validateJWTSignedPayloadPDND(Properties pDefault) throws ProviderValidationException {
        String purposeId = pDefault.getProperty("policy.retrieveToken.jwt.purposeId");
        if (purposeId != null && purposeId.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel campo 'JWT Payload - Purpose ID'");
        }
        String session = pDefault.getProperty("policy.retrieveToken.jwt.sessionInfo");
        if (session != null && !"".equals(session)) {
            Properties convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)session);
            ArrayList<String> deny = new ArrayList<String>();
            TokenUtilities.checkClaims("claim", convertTextToProperties, "Informazioni Sessione", deny, false);
        }
    }

    private void validateJWTSignedClaims(Properties pDefault, boolean pdnd) throws ProviderValidationException {
        String claims = pDefault.getProperty("policy.retrieveToken.jwt.claims");
        if (claims != null && !"".equals(claims)) {
            Properties convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)claims);
            ArrayList<String> deny = new ArrayList<String>();
            deny.add("iss");
            deny.add("sub");
            deny.add("client_id");
            deny.add("aud");
            deny.add("iat");
            deny.add("nbf");
            deny.add("exp");
            deny.add("jti");
            if (pdnd) {
                deny.add("purposeId");
                deny.add("sessionInfo");
            }
            TokenUtilities.checkClaims("claim", convertTextToProperties, "Claims", deny, false);
        }
    }

    private void validateFormParameters(Properties pDefault, boolean pdnd) throws ProviderValidationException {
        String scopes = pDefault.getProperty("policy.retrieveToken.scope");
        if (scopes != null && !"".equals(scopes) && scopes.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi tra gli scope forniti");
        }
        String audience = pDefault.getProperty("policy.retrieveToken.audience");
        if (audience != null && !"".equals(audience) && audience.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel valore dell'audience");
        }
        if (pdnd) {
            String clientId = pDefault.getProperty("policy.retrieveToken.formClientId");
            if (clientId != null && clientId.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel campo 'Client ID'");
            }
            String resource = pDefault.getProperty("policy.retrieveToken.formResource");
            if (resource != null && resource.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel campo 'Resource'");
            }
        }
    }

    private void validateCustomFormParameters(Properties pDefault, boolean pdnd) throws ProviderValidationException {
        String parameters = pDefault.getProperty("policy.retrieveToken.formParameters");
        if (parameters != null && !"".equals(parameters)) {
            Properties convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)parameters);
            ArrayList<String> deny = new ArrayList<String>();
            deny.add("grant_type");
            deny.add("client_assertion_type");
            deny.add("client_assertion");
            deny.add("scope");
            deny.add("audience");
            if (pdnd) {
                deny.add("client_id");
            }
            TokenUtilities.checkClaims("parametro", convertTextToProperties, "Parametri", deny, false);
        }
    }

    private void validateHeaders(Properties pDefault) throws ProviderValidationException {
        String headers = pDefault.getProperty("policy.retrieveToken.httpHeaders");
        if (headers != null && !"".equals(headers)) {
            Properties convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)headers);
            ArrayList<String> deny = new ArrayList<String>();
            deny.add("Authorization");
            deny.add("Content-Type");
            TokenUtilities.checkClaims("header http", convertTextToProperties, "Header HTTP", deny, false);
        }
    }

    private void validateTokenParser(Properties pDefault) throws ProviderValidationException {
        String parser = pDefault.getProperty("policy.retrieveToken.claimsParser.custom");
        if (parser != null && "CUSTOM".equals(parser)) {
            String pluginType = pDefault.getProperty("policy.retrieveToken.claimsParser.pluginType");
            this.validateTokenParser(pDefault, pluginType);
        }
    }

    private void validateTokenParser(Properties pDefault, String pluginType) throws ProviderValidationException {
        if (pluginType != null && StringUtils.isNotEmpty((CharSequence)pluginType) && "-".equals(pluginType)) {
            String className = pDefault.getProperty("policy.retrieveToken.claimsParser.className");
            if ("-".equals(className)) {
                throw new ProviderValidationException("Deve essere selezionato un plugin per il 'Formato Risposta'");
            }
            if (className == null || "".equals(className)) {
                throw new ProviderValidationException("Non \u00e8 stata fornita la classe del parser dei claims della risposta");
            }
            if (className.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nella classe del parser dei claims della risposta");
            }
        }
    }

    private void validateForward(Properties pDefault) throws ProviderValidationException {
        String mode = pDefault.getProperty("policy.tokenForward.mode");
        if (mode == null) {
            throw new ProviderValidationException("Nessuna modalit\u00e0 di forward indicata");
        }
        if (!("RFC6750_header".equals(mode) || "RFC6750_url".equals(mode) || "CUSTOM_header".equals(mode) || "CUSTOM_url".equals(mode))) {
            throw new ProviderValidationException("La modalit\u00e0 di forward indicata '" + mode + "' non \u00e8 supportata");
        }
        if ("CUSTOM_header".equals(mode)) {
            String hdr = pDefault.getProperty("policy.tokenForward.mode.header");
            if (hdr == null || "".equals(hdr)) {
                throw new ProviderValidationException("La modalit\u00e0 di forward indicata prevede l'indicazione del nome di un header http");
            }
            if (hdr.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome dell'header HTTP indicato per la modalit\u00e0 di forward");
            }
        } else if ("CUSTOM_url".equals(mode)) {
            String urlP = pDefault.getProperty("policy.tokenForward.mode.queryParameter");
            if (urlP == null || "".equals(urlP)) {
                throw new ProviderValidationException("La modalit\u00e0 di forward indicata prevede l'indicazione del nome di una propriet\u00e0 della url");
            }
            if (urlP.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nel nome della propriet\u00e0 della url indicata per la modalit\u00e0 di forward");
            }
        }
    }

    public List<String> getValues(String id) throws ProviderException {
        return this.getValues(id, null);
    }

    public List<String> getValues(String id, ExternalResources externalResources) throws ProviderException {
        List<String> values = null;
        if ("retrieveTokenMethod".equals(id)) {
            ArrayList<String> methodsList = new ArrayList<String>();
            methodsList.add("clientCredentials");
            methodsList.add("usernamePassword");
            methodsList.add("rfc7523_x509");
            methodsList.add("rfc7523_clientSecret");
            methodsList.add("custom");
            return methodsList;
        }
        if ("endpointHttpsTipologia".equals(id)) {
            List tipologie = null;
            try {
                tipologie = SSLUtilities.getSSLSupportedProtocols();
            }
            catch (Exception e) {
                tipologie = SSLUtilities.getAllSslProtocol();
            }
            return tipologie;
        }
        if ("jwtSymmetricSignatureAlgorithm".equals(id) || "jwtAsymmetricSignatureAlgorithm".equals(id) || "dpopAsymmetricSignatureAlgorithm".equals(id)) {
            boolean symmetric = "jwtSymmetricSignatureAlgorithm".equals(id);
            return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm((boolean)symmetric);
        }
        if ("jwtKeystoreType".equals(id) || "dpopKeystoreType".equals(id) || "dpopKeystoreTypeNoModi".equals(id) || "endpointHttpsTruststoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id)) {
            return this.getStoreType(id, true);
        }
        if ("httpMethod".equals(id)) {
            ArrayList<String> methodsList = new ArrayList<String>();
            HttpRequestMethod[] methods = HttpRequestMethod.values();
            for (int i = 0; i < methods.length; ++i) {
                methodsList.add(methods[i].name());
            }
            return methodsList;
        }
        if ("customTokenParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginValues(externalResources, TipoPlugin.TOKEN_NEGOZIAZIONE);
        }
        if ("endpointHttpsTrustStoreOcspPolicy".equals(id)) {
            return this.ocspProvider.getValues();
        }
        if ("jwtByokPolicy".equals(id) || "dpopByokPolicy".equals(id) || "endpointHttpsByokPolicy".equals(id)) {
            return this.byokProvider.getValues();
        }
        return values;
    }

    public List<String> getLabels(String id) throws ProviderException {
        return this.getLabels(id, null);
    }

    public List<String> getLabels(String id, ExternalResources externalResources) throws ProviderException {
        if ("retrieveTokenMethod".equals(id)) {
            ArrayList<String> methodsList = new ArrayList<String>();
            methodsList.add("Client Credentials");
            methodsList.add("Resource Owner Password Credentials");
            methodsList.add("Signed JWT");
            methodsList.add("Signed JWT with Client Secret");
            methodsList.add("Personalizzato");
            return methodsList;
        }
        if ("jwtSymmetricSignatureAlgorithm".equals(id) || "jwtAsymmetricSignatureAlgorithm".equals(id) || "dpopAsymmetricSignatureAlgorithm".equals(id)) {
            boolean symmetric = "jwtSymmetricSignatureAlgorithm".equals(id);
            return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm((boolean)symmetric);
        }
        if ("jwtKeystoreType".equals(id) || "dpopKeystoreType".equals(id) || "dpopKeystoreTypeNoModi".equals(id) || "endpointHttpsTruststoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id)) {
            return this.getStoreType(id, false);
        }
        if ("customTokenParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginLabels(externalResources, TipoPlugin.TOKEN_NEGOZIAZIONE);
        }
        if ("endpointHttpsTrustStoreOcspPolicy".equals(id)) {
            return this.ocspProvider.getLabels();
        }
        if ("jwtByokPolicy".equals(id) || "dpopByokPolicy".equals(id) || "endpointHttpsByokPolicy".equals(id)) {
            return this.byokProvider.getLabels();
        }
        return this.getValues(id);
    }

    public static boolean isSecret() {
        return secret;
    }

    public static void setSecret(boolean secret) {
        NegoziazioneTokenProvider.secret = secret;
    }

    private List<String> getStoreType(String id, boolean value) {
        boolean trustStore = true;
        ArrayList<String> l = new ArrayList<String>();
        l.add(value ? SecurityConstants.KEYSTORE_TYPE_JKS_VALUE : SecurityConstants.KEYSTORE_TYPE_JKS_LABEL);
        l.add(value ? SecurityConstants.KEYSTORE_TYPE_PKCS12_VALUE : SecurityConstants.KEYSTORE_TYPE_PKCS12_LABEL);
        if ("jwtKeystoreType".equals(id) || "dpopKeystoreType".equals(id) || "dpopKeystoreTypeNoModi".equals(id)) {
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_JWK_VALUE : SecurityConstants.KEYSTORE_TYPE_JWK_LABEL);
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE : SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_LABEL);
        }
        if ("jwtKeystoreType".equals(id) || "dpopKeystoreType".equals(id)) {
            l.add(value ? "applicativoModi" : "Definito nell'applicativo ModI");
            l.add(value ? "fruizioneModi" : "Definito nella fruizione ModI");
        }
        if ("jwtKeystoreType".equals(id) || "dpopKeystoreType".equals(id) || "dpopKeystoreTypeNoModi".equals(id) || "endpointHttpsClientKeystoreType".equals(id)) {
            trustStore = false;
        }
        HSMUtils.fillTipologieKeystore((boolean)trustStore, (boolean)false, l);
        if (secret) {
            this.addStoreTypeSecret(l);
        }
        return l;
    }

    private void addStoreTypeSecret(List<String> l) {
        ArrayList lSecret = new ArrayList();
        HSMUtils.fillTipologieKeystore((boolean)false, (boolean)true, lSecret);
        if (!lSecret.isEmpty()) {
            for (String type : lSecret) {
                if (l.contains(type)) continue;
                l.add(type);
            }
        }
    }

    public String getDefault(String id) throws ProviderException {
        return this.getDefault(id, null);
    }

    public String getDefault(String id, ExternalResources externalResources) throws ProviderException {
        if ("retrieveTokenMethod".equals(id)) {
            return "clientCredentials";
        }
        if ("endpointHttpsTipologia".equals(id)) {
            return SSLUtilities.getSafeDefaultProtocol();
        }
        if ("jwtExpTtl".equals(id)) {
            return "300";
        }
        if ("jwtSymmetricSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithm.HS256.name();
        }
        if ("jwtAsymmetricSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithm.RS256.name();
        }
        if ("httpMethod".equals(id)) {
            return HttpRequestMethod.GET.name();
        }
        if ("jwtPurposeID".equals(id)) {
            return "${dynamicConfig:apiSearchByClientApplication(purposeId)}";
        }
        return null;
    }

    private boolean isProviderInfoStandard(String id) {
        return "endpointURL".equals(id) || "autenticazioneUsername".equals(id) || "autenticazionePassword".equals(id) || "autenticazioneEndpointBasicUsername".equals(id) || "autenticazioneEndpointBasicUsernameCustom".equals(id) || "autenticazioneEndpointBasicPassword".equals(id) || "autenticazioneEndpointBasicPasswordCustom".equals(id) || "autenticazioneEndpointBearerToken".equals(id) || "jwtSignatureIncludeCertModeX5U".equals(id) || "jwtSignatureKidValue".equals(id) || "scope".equals(id) || "audience".equals(id) || "formParameters".equals(id) || "httpContentType".equals(id) || "httpHeaders".equals(id) || "httpTemplatePayload".equals(id);
    }

    public ProviderInfo getProviderInfo(String id) throws ProviderException {
        if (this.isProviderInfoStandard(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI);
            return pInfo;
        }
        if ("jwtIssuer".equals(id) || "jwtIssuerApplicativoModiChoiceInput".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_ISSUER);
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI_CON_OPZIONE_VALORE_NON_DEFINITO);
            return pInfo;
        }
        if ("jwtSubject".equals(id) || "jwtSubjectApplicativoModiChoiceInput".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_SUBJECT);
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI_CON_OPZIONE_VALORE_NON_DEFINITO);
            return pInfo;
        }
        if ("jwtIdentifier".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_IDENTIFIER);
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI_CON_OPZIONE_VALORE_NON_DEFINITO);
            return pInfo;
        }
        if ("jwtClientId".equals(id) || "jwtClientIdApplicativoModiChoiceInput".equals(id) || "jwtAudience".equals(id) || "formResource".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI_CON_OPZIONE_VALORE_NON_DEFINITO);
            return pInfo;
        }
        if ("jwtPurposeID".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_PURPOSE_ID);
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI_CON_OPZIONE_VALORE_NON_DEFINITO);
            return pInfo;
        }
        if ("formClientId".equals(id) || "formClientIdApplicativoModiChoiceInput".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_FORM_PARAMETRO_CLIENT_ID);
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI_CON_OPZIONE_VALORE_NON_DEFINITO);
            return pInfo;
        }
        if ("jwtPayloadClaims".equals(id) || "jwtSessionInfo".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_CLAIMS);
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_VALORI);
            return pInfo;
        }
        if ("httpFreemarkerPayload".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il file fornito deve rispettare la sintassi del template engine 'Freemarker'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_OBJECT_VALORI);
            return pInfo;
        }
        if ("httpVelocityPayload".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il file fornito deve rispettare la sintassi del template engine 'Velocity'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_NEGOZIAZIONE_TOKEN_INFO_OBJECT_VALORI);
            return pInfo;
        }
        if ("customTokenParserCustomPlugin".equals(id)) {
            return this.getProviderInfoCustomParserPluginClassname();
        }
        return null;
    }

    private ProviderInfo getProviderInfoCustomParserPluginClassname() {
        ProviderInfo pInfo = new ProviderInfo();
        pInfo.setHeaderBody("Il plugin deve implementare l'interfaccia: ");
        pInfo.setListBody(new ArrayList());
        pInfo.getListBody().add(INegoziazioneTokenParser.class.getName());
        return pInfo;
    }

    public String dynamicUpdate(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        return this.dynamicUpdate(items, mapNameValue, item, actualValue, null);
    }

    public String dynamicUpdate(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, ExternalResources externalResources) {
        if ("jwtKeystoreFile".equals(item.getName()) || "jwtKeystorePrivateKey".equals(item.getName()) || "jwtKeystorePublicKey".equals(item.getName()) || "dpopKeystoreFile".equals(item.getName()) || "dpopKeystorePrivateKey".equals(item.getName()) || "dpopKeystorePublicKey".equals(item.getName()) || "endpointHttpsTruststoreFile".equals(item.getName()) || "endpointHttpsClientKeystoreFile".equals(item.getName())) {
            return this.dynamicUpdateStoreFile(items, mapNameValue, item, actualValue);
        }
        if ("jwtKeystorePassword".equals(item.getName()) || "dpopKeystorePassword".equals(item.getName()) || "endpointHttpsTruststorePassword".equals(item.getName()) || "endpointHttpsClientKeystorePassword".equals(item.getName())) {
            return this.dynamicUpdateStorePassword(items, mapNameValue, item, actualValue);
        }
        if ("jwtPasswordChiavePrivata".equals(item.getName()) || "jwtPasswordChiavePrivataOpzionale".equals(item.getName()) || "dpopPasswordChiavePrivata".equals(item.getName()) || "dpopPasswordChiavePrivataOpzionale".equals(item.getName()) || "endpointHttpsClientPasswordChiavePrivata".equals(item.getName())) {
            return this.dynamicUpdateStoreKeyPassword(items, mapNameValue, item, actualValue);
        }
        if ("jwtAliasChiavePrivata".equals(item.getName()) || "dpopAliasChiavePrivata".equals(item.getName())) {
            return this.dynamicUpdateStoreKeyAlias(items, mapNameValue, item, actualValue);
        }
        if ("customTokenParserCustomPluginChoice".equals(item.getName())) {
            return TokenUtilities.dynamicUpdateTokenPluginChoice(externalResources, TipoPlugin.TOKEN_NEGOZIAZIONE, item, actualValue);
        }
        if ("customTokenParserCustomPlugin".equals(item.getName())) {
            return TokenUtilities.dynamicUpdateTokenPluginClassName(externalResources, TipoPlugin.TOKEN_NEGOZIAZIONE, items, mapNameValue, item, "customTokenParserCustomPluginChoice", actualValue);
        }
        if ("endpointHttpsTrustStoreOcspPolicy".equals(item.getName())) {
            if (!this.ocspProvider.isOcspEnabled()) {
                item.setValue("");
                item.setType(ItemType.HIDDEN);
            }
        } else {
            if ("jwtByokPolicy".equals(item.getName()) || "dpopByokPolicy".equals(item.getName()) || "endpointHttpsByokPolicy".equals(item.getName())) {
                return this.dynamicUpdateByok(items, mapNameValue, item, actualValue);
            }
            if ("expectedTokenType".equals(item.getName())) {
                return this.dynamicUpdateExpectedTokenType(items, mapNameValue, item, actualValue);
            }
            if ("jwtKeystoreKeyPairAlgorithm".equals(item.getName()) || "dpopKeystoreKeyPairAlgorithm".equals(item.getName())) {
                return this.dynamicUpdateKeyPairAlgorithm(items, mapNameValue, item, actualValue);
            }
        }
        return actualValue;
    }

    private String dynamicUpdateStoreFile(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String typeValue;
        String type = "jwtKeystoreType";
        if ("dpopKeystoreFile".equals(item.getName()) || "dpopKeystorePrivateKey".equals(item.getName()) || "dpopKeystorePublicKey".equals(item.getName())) {
            type = this.getDpopKeystoreType(items, mapNameValue);
        } else if ("endpointHttpsTruststoreFile".equals(item.getName())) {
            type = "endpointHttpsTruststoreType";
        } else if ("endpointHttpsClientKeystoreFile".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        if (("jwtKeystoreType".equals(type) || "dpopKeystoreType".equals(type)) && ("applicativoModi".equals(typeValue = AbstractSecurityProvider.readValue((String)type, items, mapNameValue)) || "fruizioneModi".equals(typeValue))) {
            item.setValue(typeValue);
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        return AbstractSecurityProvider.processStoreFile((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String getDpopKeystoreType(List<?> items, Map<String, String> mapNameValue) {
        String typeValue = AbstractSecurityProvider.readValue((String)"dpopKeystoreType", items, mapNameValue);
        if (typeValue != null && !typeValue.isEmpty()) {
            return "dpopKeystoreType";
        }
        return "dpopKeystoreTypeNoModi";
    }

    private String dynamicUpdateStorePassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String typeValue;
        String type = "jwtKeystoreType";
        boolean keystore = true;
        if ("dpopKeystorePassword".equals(item.getName())) {
            type = this.getDpopKeystoreType(items, mapNameValue);
        } else if ("endpointHttpsTruststorePassword".equals(item.getName())) {
            type = "endpointHttpsTruststoreType";
            keystore = false;
        } else if ("endpointHttpsClientKeystorePassword".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        if (("jwtKeystoreType".equals(type) || "dpopKeystoreType".equals(type)) && ("applicativoModi".equals(typeValue = AbstractSecurityProvider.readValue((String)type, items, mapNameValue)) || "fruizioneModi".equals(typeValue))) {
            item.setValue("-");
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        return AbstractSecurityProvider.processStorePassword((boolean)keystore, (String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateStoreKeyPassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String typeValue;
        String type = "jwtKeystoreType";
        if ("dpopPasswordChiavePrivata".equals(item.getName()) || "dpopPasswordChiavePrivataOpzionale".equals(item.getName())) {
            type = this.getDpopKeystoreType(items, mapNameValue);
        } else if ("endpointHttpsClientPasswordChiavePrivata".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        if (("jwtKeystoreType".equals(type) || "dpopKeystoreType".equals(type)) && ("applicativoModi".equals(typeValue = AbstractSecurityProvider.readValue((String)type, items, mapNameValue)) || "fruizioneModi".equals(typeValue))) {
            item.setValue("-");
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        return AbstractSecurityProvider.processStoreKeyPassword((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateStoreKeyAlias(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String typeValue;
        String type = "jwtKeystoreType";
        if ("dpopAliasChiavePrivata".equals(item.getName())) {
            type = this.getDpopKeystoreType(items, mapNameValue);
        }
        if ("applicativoModi".equals(typeValue = AbstractSecurityProvider.readValue((String)type, items, mapNameValue)) || "fruizioneModi".equals(typeValue)) {
            item.setValue("-");
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        item.setType(ItemType.TEXT);
        return actualValue;
    }

    private String dynamicUpdateByok(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (!this.byokProvider.isByokEnabled()) {
            item.setValue("");
            item.setType(ItemType.HIDDEN);
            return actualValue;
        }
        return this.dynamicUpdateByokPolicy(items, mapNameValue, item, actualValue);
    }

    private String dynamicUpdateByokPolicy(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String typeValue;
        String type = null;
        if ("jwtByokPolicy".equals(item.getName())) {
            type = "jwtKeystoreType";
        } else if ("dpopByokPolicy".equals(item.getName())) {
            type = this.getDpopKeystoreType(items, mapNameValue);
        } else if ("endpointHttpsByokPolicy".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        if (("jwtKeystoreType".equals(type) || "dpopKeystoreType".equals(type)) && ("applicativoModi".equals(typeValue = AbstractSecurityProvider.readValue((String)type, items, mapNameValue)) || "fruizioneModi".equals(typeValue))) {
            item.setValue(typeValue);
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        return AbstractSecurityProvider.processStoreByokPolicy((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateExpectedTokenType(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String dpopValue;
        boolean dpopEnabled;
        if (item != null) {
            // empty if block
        }
        boolean bl = dpopEnabled = "true".equalsIgnoreCase(dpopValue = AbstractSecurityProvider.readValue((String)"dpop", items, mapNameValue)) || "selected".equalsIgnoreCase(dpopValue) || "yes".equalsIgnoreCase(dpopValue);
        if (actualValue == null || actualValue.trim().isEmpty()) {
            return actualValue;
        }
        if ("Bearer".equals(actualValue) || "DPoP".equals(actualValue)) {
            return dpopEnabled ? "DPoP" : "Bearer";
        }
        return actualValue;
    }

    private String dynamicUpdateKeyPairAlgorithm(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String signatureAlgorithmFieldName;
        String signatureAlgorithm;
        if (actualValue != null) {
            // empty if block
        }
        if ((signatureAlgorithm = AbstractSecurityProvider.readValue((String)(signatureAlgorithmFieldName = "jwtKeystoreKeyPairAlgorithm".equals(item.getName()) ? "jwtAsymmetricSignatureAlgorithm" : "dpopAsymmetricSignatureAlgorithm"), items, mapNameValue)) != null && signatureAlgorithm.startsWith("ES")) {
            item.setValue("EC");
            return "EC";
        }
        item.setValue("RSA");
        return "RSA";
    }
}

