/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.token.AbstractPolicyToken;
import org.openspcoop2.pdd.core.token.NegoziazioneTokenDynamicParameters;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.BasicNegoziazioneTokenParser;
import org.openspcoop2.pdd.core.token.parser.INegoziazioneTokenParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaimsNegoziazione;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class PolicyNegoziazioneToken
extends AbstractPolicyToken
implements Serializable {
    private static final long serialVersionUID = 1L;

    public INegoziazioneTokenParser getNegoziazioneTokenParser() throws TokenException {
        String customParser;
        BasicNegoziazioneTokenParser parser = null;
        TipologiaClaimsNegoziazione tipologiaClaims = TipologiaClaimsNegoziazione.valueOf(this.defaultProperties.getProperty("policy.retrieveToken.claimsParser"));
        if (this.isCustomGrant() && (customParser = this.defaultProperties.getProperty("policy.retrieveToken.claimsParser.custom")) != null && StringUtils.isNotEmpty((CharSequence)customParser)) {
            tipologiaClaims = TipologiaClaimsNegoziazione.valueOf(customParser);
        }
        if (TipologiaClaimsNegoziazione.CUSTOM.equals((Object)tipologiaClaims)) {
            return this.getNegoziazioneTokenCustomParser();
        }
        parser = new BasicNegoziazioneTokenParser(tipologiaClaims, TokenUtilities.getRetrieveResponseClaimsMappingProperties(this.properties));
        return parser;
    }

    private INegoziazioneTokenParser getNegoziazioneTokenCustomParser() throws TokenException {
        INegoziazioneTokenParser parser = null;
        String className = this.defaultProperties.getProperty("policy.retrieveToken.claimsParser.className");
        if (className != null && StringUtils.isNotEmpty((CharSequence)className) && !"-".equals(className)) {
            try {
                parser = (INegoziazioneTokenParser)ClassLoaderUtilities.newInstance((String)className);
            }
            catch (Exception e) {
                throw new TokenException(e.getMessage(), e);
            }
        } else {
            String tipo = this.defaultProperties.getProperty("policy.retrieveToken.claimsParser.pluginType");
            if (tipo != null && StringUtils.isNotEmpty((CharSequence)tipo) && !"-".equals(tipo)) {
                try {
                    PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
                    parser = pluginLoader.newTokenNegoziazione(tipo);
                }
                catch (Exception e) {
                    throw new TokenException(e.getMessage(), e);
                }
            } else {
                throw new TokenException("Deve essere selezionato un plugin per il 'Formato Risposta'");
            }
        }
        return parser;
    }

    public String getEndpoint() {
        return this.defaultProperties.getProperty("policy.retrieveToken.endpoint.url");
    }

    public boolean isEndpointHttps() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.endpoint.https.stato") || this.isHttpsAuthentication();
    }

    public boolean isHttpsAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.retrieveToken.endpoint.https.stato");
    }

    public boolean isBasicAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.retrieveToken.endpoint.basic.stato");
    }

    public String getBasicAuthenticationUsername() {
        return this.defaultProperties.getProperty("policy.retrieveToken.endpoint.basic.username");
    }

    public String getBasicAuthenticationPassword() {
        return this.defaultProperties.getProperty("policy.retrieveToken.endpoint.basic.password");
    }

    public boolean isBasicAuthenticationAsAuthorizationHeader() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.retrieveToken.endpoint.basic.asAuthorizationHeader");
    }

    public boolean isBearerAuthentication() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.retrieveToken.endpoint.bearer.stato");
    }

    public String getBeareAuthenticationToken() {
        return this.defaultProperties.getProperty("policy.retrieveToken.endpoint.bearer.token");
    }

    public boolean isClientCredentialsGrant() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.mode");
        return "clientCredentials".equals(mode);
    }

    public boolean isRfc7523x509Grant() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.mode");
        return "rfc7523_x509".equals(mode);
    }

    public boolean isRfc7523ClientSecretGrant() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.mode");
        return "rfc7523_clientSecret".equals(mode);
    }

    public boolean isUsernamePasswordGrant() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.mode");
        return "usernamePassword".equals(mode);
    }

    public boolean isCustomGrant() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.mode");
        return "custom".equals(mode);
    }

    public String getLabelGrant() {
        if (this.isClientCredentialsGrant()) {
            return "Client Credentials";
        }
        if (this.isUsernamePasswordGrant()) {
            return "Resource Owner Password Credentials";
        }
        if (this.isRfc7523x509Grant()) {
            return "Signed JWT";
        }
        if (this.isRfc7523ClientSecretGrant()) {
            return "Signed JWT with Client Secret";
        }
        if (this.isCustomGrant()) {
            return "Personalizzato";
        }
        return "Non definita";
    }

    public boolean isPDND() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.jwt.pdnd");
        return "true".equalsIgnoreCase(mode);
    }

    public String getUsernamePasswordGrantUsername() {
        return this.defaultProperties.getProperty("policy.retrieveToken.username");
    }

    public String getUsernamePasswordGrantPassword() {
        return this.defaultProperties.getProperty("policy.retrieveToken.password");
    }

    public String getScopeString() {
        return this.defaultProperties.getProperty("policy.retrieveToken.scope");
    }

    public List<String> getScopes(NegoziazioneTokenDynamicParameters dynamicParameters) {
        ArrayList<String> l = new ArrayList<String>();
        String scopes = dynamicParameters.getScope();
        if (scopes != null) {
            if (scopes.contains(",")) {
                String[] tmp;
                for (String s : tmp = scopes.split(",")) {
                    l.add(s.trim());
                }
            } else {
                l.add(scopes.trim());
            }
        }
        return l;
    }

    public String getAudience() {
        return this.defaultProperties.getProperty("policy.retrieveToken.audience");
    }

    public boolean isFormClientIdApplicativoModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.formClientId.mode");
        return mode != null && "applicativoModi".equals(mode);
    }

    public boolean isFormClientIdFruizioneModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.formClientId.mode");
        return mode != null && "fruizioneModi".equals(mode);
    }

    public String getFormClientId() {
        return this.defaultProperties.getProperty("policy.retrieveToken.formClientId");
    }

    public String getFormResource() {
        return this.defaultProperties.getProperty("policy.retrieveToken.formResource");
    }

    public String getFormParameters() {
        return this.defaultProperties.getProperty("policy.retrieveToken.formParameters");
    }

    public String getHttpMethod() {
        if (this.isCustomGrant()) {
            String httpMethod = this.defaultProperties.getProperty("policy.retrieveToken.httpMethod");
            if (httpMethod != null && StringUtils.isNotEmpty((CharSequence)httpMethod)) {
                return httpMethod;
            }
            return HttpRequestMethod.GET.name();
        }
        return HttpRequestMethod.POST.name();
    }

    public String getHttpContentType() {
        return this.defaultProperties.getProperty("policy.retrieveToken.httpContentType");
    }

    public String getHttpHeaders() {
        return this.defaultProperties.getProperty("policy.retrieveToken.httpHeaders");
    }

    public String getDynamicPayloadType() {
        return this.defaultProperties.getProperty("policy.retrieveToken.httpPayloadTemplateType");
    }

    public boolean isDynamicPayloadTemplate() {
        return "template".equals(this.getDynamicPayloadType());
    }

    public boolean isDynamicPayloadFreemarkerTemplate() {
        return "freemarker-template".equals(this.getDynamicPayloadType());
    }

    public boolean isDynamicPayloadVelocityTemplate() {
        return "velocity-template".equals(this.getDynamicPayloadType());
    }

    public String getDynamicPayload() {
        return this.defaultProperties.getProperty("policy.retrieveToken.httpPayload");
    }

    public boolean isSaveErrorInCache() {
        return TokenUtilities.isEnabled(this.defaultProperties, "policy.retrieveToken.saveErrorInCache");
    }

    public String getForwardTokenMode() {
        return this.defaultProperties.getProperty("policy.tokenForward.mode");
    }

    public String getForwardTokenModeCustomHeader() {
        return this.defaultProperties.getProperty("policy.tokenForward.mode.header");
    }

    public String getForwardTokenModeCustomUrl() {
        return this.defaultProperties.getProperty("policy.tokenForward.mode.queryParameter");
    }

    public boolean isJwtClientIdApplicativoModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.jwt.clientId.mode");
        return mode != null && "applicativoModi".equals(mode);
    }

    public boolean isJwtClientIdFruizioneModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.jwt.clientId.mode");
        return mode != null && "fruizioneModi".equals(mode);
    }

    public String getJwtClientId() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.clientId");
    }

    public String getJwtClientSecret() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.clientSecret");
    }

    public boolean isJwtIssuerApplicativoModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.jwt.issuer.mode");
        return mode != null && "applicativoModi".equals(mode);
    }

    public boolean isJwtIssuerFruizioneModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.jwt.issuer.mode");
        return mode != null && "fruizioneModi".equals(mode);
    }

    public String getJwtIssuer() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.issuer");
    }

    public boolean isJwtSubjectApplicativoModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.jwt.subject.mode");
        return mode != null && "applicativoModi".equals(mode);
    }

    public boolean isJwtSubjectFruizioneModI() {
        String mode = this.defaultProperties.getProperty("policy.retrieveToken.jwt.subject.mode");
        return mode != null && "fruizioneModi".equals(mode);
    }

    public String getJwtSubject() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.subject");
    }

    public String getJwtIdentifier() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.jti");
    }

    public String getJwtAudience() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.audience");
    }

    public Integer getJwtTtlSeconds() {
        String ttl = this.defaultProperties.getProperty("policy.retrieveToken.jwt.expired");
        if (ttl == null || StringUtils.isEmpty((CharSequence)ttl)) {
            ttl = "300";
        }
        return Integer.valueOf(ttl);
    }

    public String getJwtPurposeId() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.purposeId");
    }

    public String getJwtSessionInfo() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.sessionInfo");
    }

    public String getJwtClaims() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.claims");
    }

    public String getJwtSignAlgorithm() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.algorithm");
    }

    public boolean isJwtSignIncludeKeyIdWithKeyAlias() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.key.id");
        return tmp != null && "true".equals(tmp);
    }

    public boolean isJwtSignIncludeKeyIdWithClientId() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.key.id");
        return tmp != null && "client_id".equals(tmp);
    }

    public boolean isJwtSignIncludeKeyIdApplicativoModI() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.key.id");
        return tmp != null && "applicativoModi".equals(tmp);
    }

    public boolean isJwtSignIncludeKeyIdFruizioneModI() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.key.id");
        return tmp != null && "fruizioneModi".equals(tmp);
    }

    public boolean isJwtSignIncludeKeyIdCustom() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.key.id");
        return tmp != null && "custom".equals(tmp);
    }

    public String getJwtSignIncludeKeyIdCustom() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.key.id.value");
    }

    public boolean isJwtSignIncludeX509Cert() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.cert");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public String getJwtSignIncludeX509URL() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.x509url");
    }

    public boolean isJwtSignIncludeX509CertSha1() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.cert.sha1");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public boolean isJwtSignIncludeX509CertSha256() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.include.cert.sha256");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public boolean isJwtSignJoseContentType() {
        String tmp = this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.joseContentType");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public String getJwtSignJoseType() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.joseType");
    }

    public boolean isJwtSignKeystoreApplicativoModI() {
        return "applicativoModi".equals(this.getJwtSignKeystoreType());
    }

    public boolean isJwtSignKeystoreFruizioneModI() {
        return "fruizioneModi".equals(this.getJwtSignKeystoreType());
    }

    public String getJwtSignKeystoreType() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.keystoreType");
    }

    public String getJwtSignKeystoreFile() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.keystoreFile");
    }

    public String getJwtSignKeystoreFilePublicKey() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.keystoreFilePublicKey");
    }

    public String getJwtSignKeyPairAlgorithm() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.keyPairAlgorithm");
    }

    public String getJwtSignKeystorePassword() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.keystorePassword");
    }

    public String getJwtSignKeyAlias() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.keyAlias");
    }

    public String getJwtSignKeyPassword() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.keyPassword");
    }

    public String getJwtSignKeystoreByokPolicy() {
        return this.defaultProperties.getProperty("policy.retrieveToken.jwt.signature.byok");
    }

    public boolean isDpop() {
        return "true".equalsIgnoreCase(this.defaultProperties.getProperty("policy.retrieveToken.dpop"));
    }

    public String getDpopSignAlgorithm() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.algorithm");
    }

    public String getDpopSignKeystoreType() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.keystoreType");
    }

    public String getDpopSignKeystoreFile() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.keystoreFile");
    }

    public String getDpopSignKeystoreFilePublicKey() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.keystoreFilePublicKey");
    }

    public String getDpopSignKeyPairAlgorithm() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.keyPairAlgorithm");
    }

    public String getDpopSignKeystorePassword() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.keystorePassword");
    }

    public String getDpopSignKeyAlias() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.keyAlias");
    }

    public String getDpopSignKeyPassword() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.keyPassword");
    }

    public String getDpopSignKeystoreByokPolicy() {
        return this.defaultProperties.getProperty("policy.retrieveToken.dpop.signature.byok");
    }

    public boolean isDpopSignKeystoreApplicativoModI() {
        return "applicativoModi".equals(this.getDpopSignKeystoreType());
    }

    public boolean isDpopSignKeystoreFruizioneModI() {
        return "fruizioneModi".equals(this.getDpopSignKeystoreType());
    }

    public boolean isDpopCacheEnabled() {
        return "true".equalsIgnoreCase(this.defaultProperties.getProperty("policy.retrieveToken.dpop.cache.enabled"));
    }

    public int getDpopCacheTtl() {
        String ttl = this.defaultProperties.getProperty("policy.retrieveToken.dpop.cache.ttl");
        if (ttl != null && !ttl.isEmpty()) {
            try {
                return Integer.parseInt(ttl);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 300;
    }

    public String getForwardDpopMode() {
        return this.defaultProperties.getProperty("policy.tokenForward.dpop.mode");
    }

    public String getForwardDpopModeCustomHeader() {
        return this.defaultProperties.getProperty("policy.tokenForward.dpop.mode.header");
    }

    public String getForwardDpopModeCustomUrl() {
        return this.defaultProperties.getProperty("policy.tokenForward.dpop.mode.queryParameter");
    }

    public String getExpectedTokenType() {
        return this.defaultProperties.getProperty("policy.expectedTokenType");
    }
}

