/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.attribute_authority;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.IProvider;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderInfo;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.IRetrieveAttributeAuthorityResponseParser;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.utils.AbstractSecurityProvider;
import org.openspcoop2.security.utils.SignatureAlgorithmUtilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPProvider;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.http.SSLUtilities;

public class AttributeAuthorityProvider
implements IProvider {
    private OCSPProvider ocspProvider = new OCSPProvider();
    private BYOKProvider byokProvider;
    private static boolean secret = false;

    public AttributeAuthorityProvider() {
        try {
            this.byokProvider = BYOKProvider.getUnwrapInstance();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void validateId(String name) throws ProviderException, ProviderValidationException {
        if (name == null || StringUtils.isEmpty((CharSequence)name)) {
            throw new ProviderValidationException("Deve essere indicato un nome che identifica la policy per verso l'Attribute Authority");
        }
        if (name.contains(" ")) {
            throw new ProviderValidationException("Il nome associato alla policy non deve contenere spazi");
        }
        boolean match = false;
        try {
            match = RegularExpressionEngine.isMatch((String)name, (String)"^[_A-Za-z][\\-_A-Za-z0-9]*$");
        }
        catch (Exception e) {
            throw new ProviderException(e.getMessage(), (Throwable)e);
        }
        if (!match) {
            throw new ProviderValidationException("Il nome associato alla policy pu\u00f2 iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , e '-'");
        }
    }

    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        String mode;
        String requestX5U;
        String jwtKeystorePublicKey;
        boolean proxy;
        boolean bearer;
        Properties pDefault = TokenUtilities.getDefaultProperties(mapProperties);
        boolean endpointSSL = TokenUtilities.isEnabled(pDefault, "policy.endpoint.https.stato");
        boolean ssl = TokenUtilities.isEnabled(pDefault, "policy.endpoint.https.client.stato");
        if (endpointSSL || ssl) {
            this.validateEndpointSsl(mapProperties);
        }
        String url = pDefault.getProperty("policy.endpoint.url");
        InputValidationUtils.validateTextAreaInput((String)url, (String)"Endpoint - URL");
        try {
            RegExpUtilities.validateUrl((String)url, (boolean)true);
        }
        catch (Exception e) {
            throw new ProviderValidationException("La URL fornita non \u00e8 valida: " + e.getMessage());
        }
        boolean basic = TokenUtilities.isEnabled(pDefault, "policy.endpoint.basic.stato");
        if (basic) {
            this.validateBasicCredentials(pDefault);
        }
        if (bearer = TokenUtilities.isEnabled(pDefault, "policy.endpoint.bearer.stato")) {
            String token = pDefault.getProperty("policy.endpoint.bearer.token");
            InputValidationUtils.validateTextAreaInput((String)token, (String)"Endpoint - Autenticazione Client - Token");
        }
        if (ssl) {
            this.validateSslCredentials(mapProperties);
        }
        if (proxy = TokenUtilities.isEnabled(pDefault, "policy.endpoint.proxy.stato")) {
            this.validateProxy(mapProperties);
        }
        this.validateClaims(pDefault);
        String jwtKeystore = pDefault.getProperty("policy.attributeAuthority.request.jws.keystore.file");
        if (jwtKeystore != null && StringUtils.isNotEmpty((CharSequence)jwtKeystore)) {
            InputValidationUtils.validateTextAreaInput((String)jwtKeystore, (String)"Richiesta - JWS KeyStore - Path");
        }
        if ((jwtKeystorePublicKey = pDefault.getProperty("policy.attributeAuthority.request.jws.keystore.file.public")) != null && StringUtils.isNotEmpty((CharSequence)jwtKeystorePublicKey)) {
            InputValidationUtils.validateTextAreaInput((String)jwtKeystorePublicKey, (String)"Richiesta - JWS KeyStore - Chiave Pubblica");
        }
        if ((requestX5U = pDefault.getProperty("policy.attributeAuthority.request.jws.signature.include.x509url")) != null && StringUtils.isNotEmpty((CharSequence)requestX5U)) {
            InputValidationUtils.validateTextAreaInput((String)requestX5U, (String)"Richiesta - JWS Header - URL");
        }
        if ("jws".equals(mode = pDefault.getProperty("policy.attributeAuthority.response.type"))) {
            this.validateResponseTypeJWS(mapProperties, pDefault);
        }
        if ("custom".equals(mode)) {
            this.validateResponseTypeCustom(pDefault);
        }
    }

    private void validateEndpointSsl(Map<String, Properties> mapProperties) throws ProviderValidationException {
        Properties p = mapProperties.get("sslConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia stato indicato un endpoint 'https', non \u00e8 stata fornita una configurazione dei parametri ssl da utilizzare");
        }
        String trustAllCerts = p.getProperty("trustAllCerts");
        boolean trustAll = false;
        if (trustAllCerts != null && StringUtils.isNotEmpty((CharSequence)trustAllCerts)) {
            trustAll = Boolean.valueOf(trustAllCerts);
        }
        if (!trustAll) {
            String location = p.getProperty("trustStoreLocation");
            InputValidationUtils.validateTextAreaInput((String)location, (String)"Https - Autenticazione Server - Path (TrustStore per l'autenticazione server)");
            String algo = p.getProperty("trustManagementAlgorithm");
            if (algo == null || "".equals(algo)) {
                throw new ProviderValidationException("Indicare un algoritmo per l'autenticazione server");
            }
            if (algo.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nell'algoritmo per l'autenticazione server");
            }
            String locationCRL = p.getProperty("trustStoreCRLs");
            if (locationCRL != null && !"".equals(locationCRL)) {
                InputValidationUtils.validateTextAreaInput((String)locationCRL, (String)"Https - Autenticazione Server - CRL File(s)");
            }
        }
    }

    private void validateBasicCredentials(Properties pDefault) throws ProviderValidationException {
        String username = pDefault.getProperty("policy.endpoint.basic.username");
        if (username == null || "".equals(username)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornito un 'Username' da utilizzare durante la connessione verso il servizio");
        }
        if (username.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nel 'Username'");
        }
        String password = pDefault.getProperty("policy.endpoint.basic.password");
        if (password == null || "".equals(password)) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'HttpBasic', non \u00e8 stato fornita una 'Password' da utilizzare durante la connessione verso il servizio");
        }
        if (password.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nella 'Password'");
        }
    }

    private void validateSslCredentials(Map<String, Properties> mapProperties) throws ProviderValidationException {
        String algo;
        Properties p = mapProperties.get("sslClientConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia richiesta una autenticazione 'Https', non sono stati forniti i parametri di connessione ssl client da utilizzare verso il servizio");
        }
        String location = p.getProperty("keyStoreLocation");
        if (location != null && !"".equals(location)) {
            InputValidationUtils.validateTextAreaInput((String)location, (String)"Https - Autenticazione Client - Path (KeyStore per l'autenticazione client)");
        }
        if ((algo = p.getProperty("keyManagementAlgorithm")) == null || "".equals(algo)) {
            throw new ProviderValidationException("Indicare un algoritmo per l'autenticazione client");
        }
        if (algo.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'algoritmo per l'autenticazione client");
        }
    }

    private void validateProxy(Map<String, Properties> mapProperties) throws ProviderValidationException {
        Properties p = mapProperties.get("endpointConfig");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("Nonostante sia richiesta un proxy, non sono stati forniti i parametri di connessione");
        }
        String hostname = p.getProperty("proxyHostname");
        if (hostname == null || "".equals(hostname)) {
            throw new ProviderValidationException("Indicare un hostname per il Proxy");
        }
        if (hostname.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'hostname del Proxy");
        }
        String username = p.getProperty("proxyUsername");
        if (username != null && !"".equals(username) && username.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nell'username del Proxy");
        }
        String password = p.getProperty("proxyPassword");
        if (password != null && !"".equals(password) && password.contains(" ")) {
            throw new ProviderValidationException("Non indicare spazi nella password del Proxy");
        }
    }

    private void validateClaims(Properties pDefault) throws ProviderValidationException {
        String claims = pDefault.getProperty("policy.attributeAuthority.request.jwt.claims");
        if (claims != null && !"".equals(claims)) {
            Properties convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)claims);
            ArrayList<String> deny = new ArrayList<String>();
            deny.add("iss");
            deny.add("sub");
            deny.add("aud");
            deny.add("iat");
            deny.add("nbf");
            deny.add("exp");
            deny.add("jti");
            TokenUtilities.checkClaims("claim", convertTextToProperties, "Claims", deny, false);
        }
    }

    private void validateResponseTypeJWS(Map<String, Properties> mapProperties, Properties pDefault) throws ProviderValidationException {
        String crl;
        Properties p = mapProperties.get("signatureVerifyPropRefId");
        if (p == null || p.size() <= 0) {
            throw new ProviderValidationException("La validazione di una risposta JWS richiede una configurazione del TrustStore; configurazione non riscontrata");
        }
        if (!p.containsKey("rs.security.keystore") && !p.containsKey("rs.security.keystore.jwkset")) {
            String file = p.getProperty("rs.security.keystore.file");
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Risposta - TrustStore - Path");
        }
        if ((crl = pDefault.getProperty("signatureCRL")) != null && StringUtils.isNotEmpty((CharSequence)crl)) {
            InputValidationUtils.validateTextAreaInput((String)crl, (String)"Risposta - TrustStore - CRL File(s)");
        }
    }

    private void validateResponseTypeCustom(Properties pDefault) throws ProviderValidationException {
        String pluginType = pDefault.getProperty("policy.attributeAuthority.claimsParser.pluginType");
        if (pluginType != null && StringUtils.isNotEmpty((CharSequence)pluginType) && "-".equals(pluginType)) {
            String className = pDefault.getProperty("policy.attributeAuthority.claimsParser.className");
            if ("-".equals(className)) {
                throw new ProviderValidationException("Deve essere selezionato un plugin per la risposta");
            }
            if (className == null || "".equals(className)) {
                throw new ProviderValidationException("Non \u00e8 stata fornita la classe del parser dei claims della risposta");
            }
            if (className.contains(" ")) {
                throw new ProviderValidationException("Non indicare spazi nella classe del parser dei claims della risposta");
            }
        }
    }

    public List<String> getValues(String id) throws ProviderException {
        return this.getValues(id, null);
    }

    public List<String> getValues(String id, ExternalResources externalResources) throws ProviderException {
        List<String> values = null;
        if ("aaSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm((boolean)false, (boolean)false);
        }
        if ("endpointHttpsTipologia".equals(id)) {
            List tipologie = null;
            try {
                tipologie = SSLUtilities.getSSLSupportedProtocols();
            }
            catch (Exception e) {
                tipologie = SSLUtilities.getAllSslProtocol();
            }
            return tipologie;
        }
        if ("aaJWSTruststoreType".equals(id) || "aaJWSKeystoreType".equals(id) || "endpointHttpsTruststoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id)) {
            return this.getStoreType(id, true);
        }
        if ("aaJWSTruststoreTypeSelectCertificate".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectCertificateValues();
        }
        if ("aaJWSTruststoreTypeSelectJWKPublicKey".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectJwkPublicKeyValues();
        }
        if ("aaJWSTruststoreOcspPolicy".equals(id) || "endpointHttpsTrustStoreOcspPolicy".equals(id)) {
            return this.ocspProvider.getValues();
        }
        if ("aaJWSKeystoreByokPolicy".equals(id) || "endpointHttpsByokPolicy".equals(id)) {
            return this.byokProvider.getValues();
        }
        if ("aaResponseParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginValues(externalResources, TipoPlugin.ATTRIBUTE_AUTHORITY);
        }
        if ("aaResponseAsymmetricSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm((boolean)false, (boolean)true);
        }
        return values;
    }

    public List<String> getLabels(String id) throws ProviderException {
        return this.getLabels(id, null);
    }

    public List<String> getLabels(String id, ExternalResources externalResources) throws ProviderException {
        if ("aaSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm((boolean)false, (boolean)false);
        }
        if ("aaJWSTruststoreType".equals(id) || "aaJWSKeystoreType".equals(id) || "endpointHttpsTruststoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id)) {
            return this.getStoreType(id, false);
        }
        if ("aaJWSTruststoreTypeSelectCertificate".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectCertificateLabels();
        }
        if ("aaJWSTruststoreTypeSelectJWKPublicKey".equals(id)) {
            return Costanti.getIdValidazioneJwtTruststoreTypeSelectJwkPublicKeyLabels();
        }
        if ("aaJWSTruststoreOcspPolicy".equals(id) || "endpointHttpsTrustStoreOcspPolicy".equals(id)) {
            return this.ocspProvider.getLabels();
        }
        if ("aaJWSKeystoreByokPolicy".equals(id) || "endpointHttpsByokPolicy".equals(id)) {
            return this.byokProvider.getLabels();
        }
        if ("aaResponseParserCustomPluginChoice".equals(id)) {
            return TokenUtilities.getTokenPluginLabels(externalResources, TipoPlugin.ATTRIBUTE_AUTHORITY);
        }
        if ("aaResponseAsymmetricSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm((boolean)false, (boolean)true);
        }
        return this.getValues(id);
    }

    public static boolean isSecret() {
        return secret;
    }

    public static void setSecret(boolean secret) {
        AttributeAuthorityProvider.secret = secret;
    }

    private List<String> getStoreType(String id, boolean value) {
        boolean trustStore = true;
        ArrayList<String> l = new ArrayList<String>();
        l.add(value ? SecurityConstants.KEYSTORE_TYPE_JKS_VALUE : SecurityConstants.KEYSTORE_TYPE_JKS_LABEL);
        l.add(value ? SecurityConstants.KEYSTORE_TYPE_PKCS12_VALUE : SecurityConstants.KEYSTORE_TYPE_PKCS12_LABEL);
        if ("aaJWSTruststoreType".equals(id) || "aaJWSKeystoreType".equals(id)) {
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_JWK_VALUE : SecurityConstants.KEYSTORE_TYPE_JWK_LABEL);
        }
        if ("aaJWSKeystoreType".equals(id)) {
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE : SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_LABEL);
        }
        if ("aaJWSTruststoreType".equals(id)) {
            l.add(value ? SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE : SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_LABEL);
        }
        if ("aaJWSKeystoreType".equals(id) || "endpointHttpsClientKeystoreType".equals(id)) {
            trustStore = false;
        }
        HSMUtils.fillTipologieKeystore((boolean)trustStore, (boolean)false, l);
        if (secret) {
            this.addStoreTypeSecret(l);
        }
        return l;
    }

    private void addStoreTypeSecret(List<String> l) {
        ArrayList lSecret = new ArrayList();
        HSMUtils.fillTipologieKeystore((boolean)false, (boolean)true, lSecret);
        if (!lSecret.isEmpty()) {
            for (String type : lSecret) {
                if (l.contains(type)) continue;
                l.add(type);
            }
        }
    }

    public String getNote(String id, String actualValue) throws ProviderException {
        if ("aaJWSTruststoreTypeSelectCertificate".equals(id)) {
            if ("alias".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato nel truststore corrispondente all'alias indicato";
            }
            if ("x5c".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato presente nel token, dopo averlo validato rispetto al truststore";
            }
            if ("x5t#256".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato nel truststore corrispondente al thumbprint presente nel token";
            }
            if ("x5c_x5t#256".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato presente nel token o recuperato dal truststore rispetto al thumbprint";
            }
            if ("kid".equals(actualValue)) {
                return "Per la validazione viene utilizzato il certificato nel truststore con alias corrispondente al 'kid' presente nel token";
            }
            if ("x5u".equals(actualValue)) {
                return "Per la validazione viene recuperato il certificato riferito dalla URL presente nel token e validato rispetto al truststore";
            }
        } else if ("aaJWSTruststoreTypeSelectJWKPublicKey".equals(id)) {
            if ("alias".equals(actualValue)) {
                return "Per la validazione viene utilizzata la chiave pubblica nel truststore JWKs corrispondente al kid indicato";
            }
            if ("kid".equals(actualValue)) {
                return "Per la validazione viene utilizzata la chiave pubblica nel truststore JWKs corrispondente al 'kid' presente nel token";
            }
        }
        return null;
    }

    public String getDefault(String id) throws ProviderException {
        return this.getDefault(id, null);
    }

    public String getDefault(String id, ExternalResources externalResources) throws ProviderException {
        if ("aaSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithm.RS256.name();
        }
        if ("aaRichiestaPayloadExpTtl".equals(id)) {
            return "300";
        }
        if ("endpointHttpsTipologia".equals(id)) {
            return SSLUtilities.getSafeDefaultProtocol();
        }
        return null;
    }

    public ProviderInfo getProviderInfo(String id) throws ProviderException {
        if ("endpointURL".equals(id) || "autenticazioneEndpointBasicUsername".equals(id) || "autenticazioneEndpointBasicPassword".equals(id) || "autenticazioneEndpointBearerToken".equals(id) || "aaRichiestaPayloadIssuer".equals(id) || "aaRichiestaPayloadSubject".equals(id) || "aaRichiestaPayloadAudience".equals(id) || "aaResponseAudience".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_ATTRIBUTE_AUTHORITY_INFO_VALORI);
            return pInfo;
        }
        if ("aaRichiestaJwsPayloadTemplate".equals(id) || "aaRichiestaPayloadTemplate".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_ATTRIBUTE_AUTHORITY_INFO_VALORI_CON_REQUIRED_ATTRIBUTES);
            return pInfo;
        }
        if ("aaRichiestaJwsPayloadClaims".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_CLAIMS);
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_ATTRIBUTE_AUTHORITY_INFO_VALORI_CON_REQUIRED_ATTRIBUTES);
            return pInfo;
        }
        if ("aaRichiestaJwsPayloadTemplateFreemarker".equals(id) || "aaRichiestaPayloadTemplateFreemarker".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il file fornito deve rispettare la sintassi del template engine 'Freemarker'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_ATTRIBUTE_AUTHORITY_INFO_OBJECT_VALORI);
            return pInfo;
        }
        if ("aaRichiestaJwsPayloadTemplateVelocity".equals(id) || "aaRichiestaPayloadTemplateVelocity".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il file fornito deve rispettare la sintassi del template engine 'Velocity'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
            pInfo.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_ATTRIBUTE_AUTHORITY_INFO_OBJECT_VALORI);
            return pInfo;
        }
        if ("aaResponseParserCustom".equals(id)) {
            ProviderInfo pInfo = new ProviderInfo();
            pInfo.setHeaderBody("Il plugin deve implementare l'interfaccia: ");
            pInfo.setListBody(new ArrayList());
            pInfo.getListBody().add(IRetrieveAttributeAuthorityResponseParser.class.getName());
            return pInfo;
        }
        return null;
    }

    public String dynamicUpdate(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        return this.dynamicUpdate(items, mapNameValue, item, actualValue, null);
    }

    public String dynamicUpdate(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, ExternalResources externalResources) {
        if ("aaJWSTruststoreFile".equals(item.getName()) || "aaJWSKeystoreFile".equals(item.getName()) || "endpointHttpsTruststoreFile".equals(item.getName()) || "endpointHttpsClientKeystoreFile".equals(item.getName())) {
            return this.dynamicUpdateStoreFile(items, mapNameValue, item, actualValue);
        }
        if ("aaJWSTruststorePassword".equals(item.getName()) || "aaJWSKeystorePassword".equals(item.getName()) || "endpointHttpsTruststorePassword".equals(item.getName()) || "endpointHttpsClientKeystorePassword".equals(item.getName())) {
            return this.dynamicUpdateStorePassword(items, mapNameValue, item, actualValue);
        }
        if ("aaJWSKeystorePrivateKeyPassword".equals(item.getName()) || "endpointHttpsClientPasswordChiavePrivata".equals(item.getName())) {
            return this.dynamicUpdateStoreKeyPassword(items, mapNameValue, item, actualValue);
        }
        if ("aaJWSTruststoreOcspPolicy".equals(item.getName()) || "endpointHttpsTrustStoreOcspPolicy".equals(item.getName())) {
            if (!this.ocspProvider.isOcspEnabled()) {
                item.setValue("");
                item.setType(ItemType.HIDDEN);
            }
        } else {
            if ("aaJWSKeystoreByokPolicy".equals(item.getName()) || "endpointHttpsByokPolicy".equals(item.getName())) {
                return this.dynamicUpdateByok(items, mapNameValue, item, actualValue);
            }
            if ("aaJWSKeystoreKeyPairAlgorithm".equals(item.getName())) {
                return this.dynamicUpdateKeyAlgorithm(items, mapNameValue, item, actualValue, "aaJWSKeystoreType", SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE, "aaSignatureAlgorithm");
            }
            if ("aaJWSTruststorePublicKeyAlgorithm".equals(item.getName())) {
                return this.dynamicUpdateKeyAlgorithm(items, mapNameValue, item, actualValue, "aaJWSTruststoreType", SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE, "aaResponseAsymmetricSignatureAlgorithm");
            }
            if ("aaResponseParserCustomPluginChoice".equals(item.getName())) {
                return TokenUtilities.dynamicUpdateTokenPluginChoice(externalResources, TipoPlugin.ATTRIBUTE_AUTHORITY, item, actualValue);
            }
            if ("aaResponseParserCustom".equals(item.getName())) {
                return TokenUtilities.dynamicUpdateTokenPluginClassName(externalResources, TipoPlugin.ATTRIBUTE_AUTHORITY, items, mapNameValue, item, "aaResponseParserCustomPluginChoice", actualValue);
            }
        }
        return actualValue;
    }

    public String dynamicUpdateStoreFile(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "aaJWSTruststoreType";
        if ("aaJWSKeystoreFile".equals(item.getName())) {
            type = "aaJWSKeystoreType";
        } else if ("endpointHttpsTruststoreFile".equals(item.getName())) {
            type = "endpointHttpsTruststoreType";
        } else if ("endpointHttpsClientKeystoreFile".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        return AbstractSecurityProvider.processStoreFile((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    public String dynamicUpdateStorePassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "aaJWSTruststoreType";
        boolean keystore = true;
        if ("aaJWSKeystorePassword".equals(item.getName())) {
            type = "aaJWSKeystoreType";
        } else if ("endpointHttpsTruststorePassword".equals(item.getName())) {
            type = "endpointHttpsTruststoreType";
            keystore = false;
        } else if ("endpointHttpsClientKeystorePassword".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        return AbstractSecurityProvider.processStorePassword((boolean)keystore, (String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateStoreKeyPassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "aaJWSKeystoreType";
        if ("endpointHttpsClientPasswordChiavePrivata".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        return AbstractSecurityProvider.processStoreKeyPassword((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateByok(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (!this.byokProvider.isByokEnabled()) {
            item.setValue("");
            item.setType(ItemType.HIDDEN);
            return actualValue;
        }
        return this.dynamicUpdateByokPolicy(items, mapNameValue, item, actualValue);
    }

    private String dynamicUpdateByokPolicy(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = null;
        if ("aaJWSKeystoreByokPolicy".equals(item.getName())) {
            type = "aaJWSKeystoreType";
        } else if ("endpointHttpsByokPolicy".equals(item.getName())) {
            type = "endpointHttpsClientKeystoreType";
        }
        return AbstractSecurityProvider.processStoreByokPolicy((String)type, items, mapNameValue, (Item)item, (String)actualValue);
    }

    private String dynamicUpdateKeyAlgorithm(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue, String storeTypeId, String expectedStoreType, String signatureAlgorithmId) {
        String storeType = AbstractSecurityProvider.readValue((String)storeTypeId, items, mapNameValue);
        if (storeType == null || !expectedStoreType.equalsIgnoreCase(storeType)) {
            return actualValue;
        }
        String signatureAlgorithm = AbstractSecurityProvider.readValue((String)signatureAlgorithmId, items, mapNameValue);
        if ("alg".equals(signatureAlgorithm)) {
            return actualValue;
        }
        String keyPairAlgorithm = SignatureAlgorithmUtilities.covertToKeyPairAlgorithm((String)signatureAlgorithm);
        if (keyPairAlgorithm == null) {
            keyPairAlgorithm = "RSA";
        }
        item.setValue(keyPairAlgorithm);
        return keyPairAlgorithm;
    }
}

