/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.dpop.jti.impl;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Date;
import org.openspcoop2.pdd.core.token.TokenException;
import org.openspcoop2.pdd.core.token.dpop.jti.IJtiValidator;
import org.openspcoop2.pdd.core.token.dpop.jti.JtiEntry;
import org.openspcoop2.pdd.core.token.dpop.jti.LocalJtiCacheManager;
import org.openspcoop2.pdd.core.token.parser.IDPoPParser;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class LocalJtiValidator
implements IJtiValidator {
    private static final Logger logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private final long maxSize;
    private final boolean failOnFull;

    public LocalJtiValidator(long maxSize, boolean failOnFull) {
        this.maxSize = maxSize;
        this.failOnFull = failOnFull;
        String policy = failOnFull ? "Reject Policy" : "LRU Policy";
        logger.debug("LocalJtiValidator initialized with maxSize={}, policy={}", (Object)maxSize, (Object)policy);
    }

    @Override
    public void validateAndStore(String policyName, String jti, IDPoPParser dpopParser, long toleranceMillis) throws TokenException, UtilsException {
        long currentSize;
        Cache<String, JtiEntry> cache = LocalJtiCacheManager.getOrCreateCache(policyName, this.maxSize);
        JtiEntry alreadyUsed = (JtiEntry)cache.getIfPresent((Object)jti);
        if (alreadyUsed != null) {
            logger.warn("DPoP replay attack detected for policy [{}]: JTI [{}] already used", (Object)policyName, (Object)jti);
            throw new TokenException("DPoP JTI [" + jti + "] has already been used (replay attack detected)");
        }
        if (this.failOnFull && (currentSize = cache.estimatedSize()) >= this.maxSize) {
            logger.error("JTI cache full for policy [{}]: size={}/{} - rejecting JTI [{}]", new Object[]{policyName, currentSize, this.maxSize, jti});
            throw new UtilsException("DPoP JTI validation failed: local cache capacity exceeded (" + currentSize + "/" + this.maxSize + " entries). Consider increasing cache size or switching to distributed validation");
        }
        Date iat = dpopParser.getIssuedAt();
        if (iat != null) {
            long expirationMillis;
            long iatMillis = iat.getTime();
            long currentMillis = DateManager.getTimeMillis();
            if (currentMillis > (expirationMillis = iatMillis + toleranceMillis)) {
                logger.debug("DPoP with JTI [{}] already expired (iat={}, expiration={}, now={}) - not stored", new Object[]{jti, iatMillis, expirationMillis, currentMillis});
                throw new TokenException("DPoP token expired: iat [" + String.valueOf(iat) + "] + tolerance [" + toleranceMillis + "ms] exceeded");
            }
        }
        JtiEntry entry = new JtiEntry(iat, toleranceMillis);
        cache.put((Object)jti, (Object)entry);
        logger.debug("DPoP JTI [{}] stored successfully for policy [{}] (expires at {}ms)", new Object[]{jti, policyName, entry.getExpirationMillis()});
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

