/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.BasicTokenUserInfoParser;
import org.openspcoop2.pdd.core.token.parser.ITokenParser;
import org.openspcoop2.pdd.core.token.parser.ITokenUserInfoParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaims;
import org.openspcoop2.pdd.core.token.parser.TokenUtils;
import org.openspcoop2.utils.UtilsException;

public class BasicTokenParser
implements ITokenParser {
    protected Integer httpResponseCode;
    protected String raw;
    protected Map<String, Serializable> claims;
    protected TipologiaClaims parser;
    protected Properties parserConfig;
    protected ITokenUserInfoParser userInfoParser;

    public BasicTokenParser(TipologiaClaims parser) {
        this(parser, null);
    }

    public BasicTokenParser(TipologiaClaims parser, Properties parserConfig) {
        this.parser = parser;
        this.parserConfig = parserConfig;
        this.userInfoParser = new BasicTokenUserInfoParser(parser, this.parserConfig);
    }

    @Override
    public void init(String raw, Map<String, Serializable> claims) {
        this.raw = raw;
        this.claims = claims;
        this.userInfoParser.init(raw, claims);
    }

    @Override
    public void checkHttpTransaction(Integer httpResponseCode) throws UtilsException {
        this.httpResponseCode = httpResponseCode;
        switch (this.parser) {
            case INTROSPECTION_RESPONSE_RFC_7662: 
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case OIDC_ID_TOKEN: 
            case MAPPING: 
            case CUSTOM: {
                if (this.httpResponseCode == null || this.httpResponseCode >= 200 && this.httpResponseCode <= 299) break;
                String msgError = "Connessione terminata con errore (codice trasporto: " + this.httpResponseCode + ")";
                throw new UtilsException(msgError + ": " + this.raw);
            }
            case GOOGLE: {
                if (this.httpResponseCode != null && (this.httpResponseCode == 400 || this.httpResponseCode == 401) && this.claims != null && this.claims.size() > 0) {
                    String tmp = TokenUtilities.getClaimAsString(this.claims, "error");
                    if (tmp == null) {
                        tmp = TokenUtilities.getClaimAsString(this.claims, "error_description");
                    }
                    if (tmp != null) {
                        return;
                    }
                }
                if (this.httpResponseCode == null || this.httpResponseCode >= 200 && this.httpResponseCode <= 299) break;
                String msgError = "Connessione terminata con errore (codice trasporto: " + this.httpResponseCode + ")";
                throw new UtilsException(msgError + ": " + this.raw);
            }
        }
    }

    @Override
    public boolean isValid() {
        if (this.claims == null || this.claims.size() <= 0) {
            return false;
        }
        switch (this.parser) {
            case INTROSPECTION_RESPONSE_RFC_7662: {
                String claim = TokenUtilities.getClaimAsString(this.claims, "active");
                return Boolean.valueOf(claim);
            }
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case OIDC_ID_TOKEN: 
            case MAPPING: 
            case CUSTOM: {
                return true;
            }
            case GOOGLE: {
                if (this.httpResponseCode == null) {
                    return true;
                }
                if (this.httpResponseCode != 400 && this.httpResponseCode != 401) break;
                String tmp = TokenUtilities.getClaimAsString(this.claims, "error");
                if (tmp == null) {
                    tmp = TokenUtilities.getClaimAsString(this.claims, "error_description");
                }
                if (tmp == null) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getIssuer() {
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                return TokenUtilities.getClaimAsString(this.claims, "iss");
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                return TokenUtilities.getClaimAsString(this.claims, "iss");
            }
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "iss");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "iss");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.issuer");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getSubject() {
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                return TokenUtilities.getClaimAsString(this.claims, "sub");
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                return TokenUtilities.getClaimAsString(this.claims, "sub");
            }
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "sub");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "sub");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.subject");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getUsername() {
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                return null;
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                return TokenUtilities.getClaimAsString(this.claims, "username");
            }
            case OIDC_ID_TOKEN: {
                String tmp = TokenUtilities.getClaimAsString(this.claims, "preferred_username");
                if (tmp == null && this.getUserInfoParser() != null) {
                    return this.getUserInfoParser().getFullName();
                }
                return tmp;
            }
            case GOOGLE: {
                if (this.getUserInfoParser() != null) {
                    return this.getUserInfoParser().getFullName();
                }
                return null;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.username");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public List<String> getAudience() {
        List<String> lNull = null;
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                return TokenUtilities.getClaimAsList(this.claims, "aud");
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                return TokenUtilities.getClaimAsList(this.claims, "aud");
            }
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsList(this.claims, "aud");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsList(this.claims, "aud");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.audience");
                return TokenUtilities.getFirstClaimAsList(this.claims, claimNames);
            }
            case CUSTOM: {
                return lNull;
            }
        }
        return lNull;
    }

    @Override
    public Date getExpired() {
        String tmp = null;
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "exp");
                break;
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "exp");
                break;
            }
            case OIDC_ID_TOKEN: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "exp");
                break;
            }
            case GOOGLE: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "exp");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.expire");
                tmp = TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
                break;
            }
            case CUSTOM: {
                return null;
            }
        }
        if (tmp != null) {
            return TokenUtils.parseTimeInSecond(tmp);
        }
        return null;
    }

    @Override
    public Date getIssuedAt() {
        String tmp = null;
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "iat");
                break;
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "iat");
                break;
            }
            case OIDC_ID_TOKEN: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "iat");
                break;
            }
            case GOOGLE: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "iat");
                break;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.issuedAt");
                tmp = TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
                break;
            }
            case CUSTOM: {
                return null;
            }
        }
        if (tmp != null) {
            return TokenUtils.parseTimeInSecond(tmp);
        }
        return null;
    }

    @Override
    public Date getNotToBeUsedBefore() {
        String tmp = null;
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "nbf");
                break;
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                tmp = TokenUtilities.getClaimAsString(this.claims, "nbf");
                break;
            }
            case OIDC_ID_TOKEN: 
            case GOOGLE: {
                return null;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.notToBeUsedBefore");
                tmp = TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
                break;
            }
            case CUSTOM: {
                return null;
            }
        }
        if (tmp != null) {
            return TokenUtils.parseTimeInSecond(tmp);
        }
        return null;
    }

    @Override
    public String getJWTIdentifier() {
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                return TokenUtilities.getClaimAsString(this.claims, "jti");
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                return TokenUtilities.getClaimAsString(this.claims, "jti");
            }
            case OIDC_ID_TOKEN: 
            case GOOGLE: {
                return null;
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.jwtIdentifier");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getClientId() {
        switch (this.parser) {
            case JSON_WEB_TOKEN_RFC_7519: {
                return null;
            }
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: {
                return TokenUtilities.getClaimAsString(this.claims, "client_id");
            }
            case INTROSPECTION_RESPONSE_RFC_7662: {
                return TokenUtilities.getClaimAsString(this.claims, "client_id");
            }
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "azp");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "azp");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.clientId");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public List<String> getRoles() {
        List<String> lNull = null;
        switch (this.parser) {
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.role");
                return TokenUtilities.getFirstClaimAsList(this.claims, claimNames);
            }
            case INTROSPECTION_RESPONSE_RFC_7662: 
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case OIDC_ID_TOKEN: 
            case CUSTOM: 
            case GOOGLE: {
                return lNull;
            }
        }
        return lNull;
    }

    @Override
    public List<String> getScopes() {
        String tmpScopes = null;
        if (TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662.equals((Object)this.parser) || TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068.equals((Object)this.parser) || TipologiaClaims.OIDC_ID_TOKEN.equals((Object)this.parser) || TipologiaClaims.JSON_WEB_TOKEN_RFC_7519.equals((Object)this.parser)) {
            tmpScopes = TokenUtilities.getClaimAsString(this.claims, "scope");
        } else if (TipologiaClaims.GOOGLE.equals((Object)this.parser)) {
            tmpScopes = TokenUtilities.getClaimAsString(this.claims, "scope");
        } else if (TipologiaClaims.MAPPING.equals((Object)this.parser)) {
            List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.scope");
            List<String> tmpScopesList = TokenUtilities.getFirstClaimAsList(this.claims, claimNames);
            List<String> lNull = null;
            if (tmpScopesList != null && !tmpScopesList.isEmpty()) {
                ArrayList<String> scopes = new ArrayList<String>();
                for (String s : tmpScopesList) {
                    List<String> tmp = this.readScope(s);
                    if (tmp == null || tmp.isEmpty()) continue;
                    for (String sTmp : tmp) {
                        if (scopes.contains(sTmp)) continue;
                        scopes.add(sTmp);
                    }
                }
                return scopes;
            }
            return lNull;
        }
        return this.readScope(tmpScopes);
    }

    private List<String> readScope(String tmpScopes) {
        String[] tmpArray;
        List<String> lNull = null;
        if (tmpScopes != null && (tmpArray = tmpScopes.split(" ")) != null && tmpArray.length > 0) {
            ArrayList<String> scopes = new ArrayList<String>();
            for (int i = 0; i < tmpArray.length; ++i) {
                scopes.add(tmpArray[i].trim());
            }
            return scopes;
        }
        return lNull;
    }

    @Override
    public ITokenUserInfoParser getUserInfoParser() {
        return this.userInfoParser;
    }
}

