/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.transazioni;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.jdbc.converter.TransazioneFieldConverter;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.transazioni.DateUtility;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransazioniFiltroDuplicatiProcessTimes;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class FiltroDuplicati
implements IFiltroDuplicati {
    private OpenSPCoop2Properties openspcoop2Properties;
    private String idTransazione = null;
    private RequestInfo requestInfo = null;
    private org.openspcoop2.protocol.engine.driver.FiltroDuplicati filtroDuplicatiProtocol;
    private OpenSPCoopState openspcoop2State = null;
    private Boolean initDsResource = null;
    private Connection connection = null;
    private boolean isDirectConnection = false;
    private String modeGetConnection = null;
    private boolean releaseRuntimeResourceBeforeCheck = false;
    private String tipoDatabaseRuntime = null;
    private Logger log = null;
    private Logger logSql = null;
    private boolean debug = false;
    private TransazioneFieldConverter transazioneFieldConverter = null;
    private String nomeTabellaTransazioni = null;
    private String colonna_pdd_ruolo = null;
    private String colonna_duplicati_richiesta = null;
    private String colonna_data_id_msg_richiesta = null;
    private String colonna_id_messaggio_richiesta = null;
    private String colonna_duplicati_risposta = null;
    private String colonna_data_id_msg_risposta = null;
    private String colonna_id_messaggio_risposta = null;
    private volatile boolean useTransactionIdForTest = false;
    private static final String ID_MODULO = "FiltroDuplicati";

    public boolean isUseTransactionIdForTest() {
        return this.useTransactionIdForTest;
    }

    public void setUseTransactionIdForTest(boolean useTransactionIdForTest) {
        this.useTransactionIdForTest = useTransactionIdForTest;
    }

    public void init(Object context) throws ProtocolException {
        this.openspcoop2Properties = OpenSPCoop2Properties.getInstance();
        if (!this.openspcoop2Properties.isTransazioniFiltroDuplicatiTramiteTransazioniEnabled()) {
            this.filtroDuplicatiProtocol = new org.openspcoop2.protocol.engine.driver.FiltroDuplicati();
            this.filtroDuplicatiProtocol.init(context);
        } else {
            PdDContext pddContext = (PdDContext)context;
            if (pddContext == null) {
                throw new ProtocolException("PdDContext non fornito");
            }
            this.idTransazione = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
            if (this.idTransazione == null) {
                throw new ProtocolException("Id di transazione non fornito");
            }
            if (pddContext != null && pddContext.containsKey(Costanti.REQUEST_INFO)) {
                this.requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
            }
            if (this.initDsResource == null && this.connection == null) {
                this.init((PdDContext)context);
            }
        }
    }

    public boolean releaseRuntimeResourceBeforeCheck() {
        return this.releaseRuntimeResourceBeforeCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicata(IProtocolFactory<?> protocolFactory, String idBustaParam) throws ProtocolException {
        String idBusta = this.useTransactionIdForTest ? this.idTransazione : idBustaParam;
        long timeStart = -1L;
        TransazioniFiltroDuplicatiProcessTimes times = null;
        try {
            if (this.openspcoop2Properties.isTransazioniRegistrazioneSlowLog()) {
                timeStart = DateManager.getTimeMillis();
                times = new TransazioniFiltroDuplicatiProcessTimes();
            }
            if (this.filtroDuplicatiProtocol != null) {
                boolean bl = this.filtroDuplicatiProtocol.isDuplicata(protocolFactory, idBusta);
                return bl;
            }
            if (TransactionContext.containsIdentificativoProtocollo(idBusta)) {
                try {
                    TransactionContext.getTransaction(this.idTransazione).addIdProtocolloDuplicato(idBusta);
                }
                catch (Exception e) {
                    throw new ProtocolException((Throwable)e);
                }
                boolean e = true;
                return e;
            }
            if (this.esisteTransazione(protocolFactory, idBusta, idBusta, times)) {
                try {
                    TransactionContext.getTransaction(this.idTransazione).addIdProtocolloDuplicato(idBusta);
                }
                catch (Exception e) {
                    throw new ProtocolException((Throwable)e);
                }
                boolean e = true;
                return e;
            }
            try {
                TransactionContext.registraIdentificativoProtocollo(idBusta, this.idTransazione);
            }
            catch (Exception e) {
                if (e.getMessage() != null && "DUPLICATA".equals(e.getMessage())) {
                    long timeEnd;
                    long timeProcess;
                    try {
                        TransactionContext.getTransaction(this.idTransazione).addIdProtocolloDuplicato(idBusta);
                    }
                    catch (Exception eSetDuplicata) {
                        throw new ProtocolException((Throwable)eSetDuplicata);
                    }
                    boolean eSetDuplicata = true;
                    if (this.openspcoop2Properties.isTransazioniRegistrazioneSlowLog() && (timeProcess = (timeEnd = DateManager.getTimeMillis()) - timeStart) >= (long)this.openspcoop2Properties.getTransazioniRegistrazioneSlowLogThresholdMs()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(timeProcess);
                        if (this.idTransazione != null) {
                            sb.append(" <").append(this.idTransazione).append(">");
                        }
                        sb.append(" [isDuplicata]");
                        sb.append(" ").append(idBusta);
                        if (times != null) {
                            sb.append(" ").append(times.toString());
                        }
                        OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSlowLog().info(sb.toString());
                    }
                    return eSetDuplicata;
                }
                throw new ProtocolException((Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            long timeEnd;
            long timeProcess;
            if (this.openspcoop2Properties.isTransazioniRegistrazioneSlowLog() && (timeProcess = (timeEnd = DateManager.getTimeMillis()) - timeStart) >= (long)this.openspcoop2Properties.getTransazioniRegistrazioneSlowLogThresholdMs()) {
                StringBuilder sb = new StringBuilder();
                sb.append(timeProcess);
                if (this.idTransazione != null) {
                    sb.append(" <").append(this.idTransazione).append(">");
                }
                sb.append(" [isDuplicata]");
                sb.append(" ").append(idBusta);
                if (times != null) {
                    sb.append(" ").append(times.toString());
                }
                OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSlowLog().info(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementaNumeroDuplicati(IProtocolFactory<?> protocolFactory, String idBusta) throws ProtocolException {
        long timeStart = -1L;
        TransazioniFiltroDuplicatiProcessTimes times = null;
        try {
            if (this.openspcoop2Properties.isTransazioniRegistrazioneSlowLog()) {
                timeStart = DateManager.getTimeMillis();
                times = new TransazioniFiltroDuplicatiProcessTimes();
            }
            if (this.filtroDuplicatiProtocol != null) {
                this.filtroDuplicatiProtocol.incrementaNumeroDuplicati(protocolFactory, idBusta);
                return;
            }
            this.incrementDuplicatiTransazione(protocolFactory, idBusta, times);
        }
        finally {
            long timeEnd;
            long timeProcess;
            if (this.openspcoop2Properties.isTransazioniRegistrazioneSlowLog() && (timeProcess = (timeEnd = DateManager.getTimeMillis()) - timeStart) >= (long)this.openspcoop2Properties.getTransazioniRegistrazioneSlowLogThresholdMs()) {
                StringBuilder sb = new StringBuilder();
                sb.append(timeProcess);
                if (this.idTransazione != null) {
                    sb.append(" <").append(this.idTransazione).append(">");
                }
                sb.append(" [incrementaNumeroDuplicati]");
                sb.append(" ").append(idBusta);
                if (times != null) {
                    sb.append(" ").append(times.toString());
                }
                OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSlowLog().info(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registraBusta(IProtocolFactory<?> protocolFactory, Busta busta) throws ProtocolException {
        long timeStart = -1L;
        try {
            if (this.openspcoop2Properties.isTransazioniRegistrazioneSlowLog()) {
                timeStart = DateManager.getTimeMillis();
            }
            if (this.filtroDuplicatiProtocol != null) {
                this.filtroDuplicatiProtocol.registraBusta(protocolFactory, busta);
                return;
            }
        }
        finally {
            long timeEnd;
            long timeProcess;
            if (this.openspcoop2Properties.isTransazioniRegistrazioneSlowLog() && (timeProcess = (timeEnd = DateManager.getTimeMillis()) - timeStart) >= (long)this.openspcoop2Properties.getTransazioniRegistrazioneSlowLogThresholdMs()) {
                StringBuilder sb = new StringBuilder();
                sb.append(timeProcess);
                if (this.idTransazione != null) {
                    sb.append(" <").append(this.idTransazione).append(">");
                }
                sb.append(" [registraBusta]");
                if (busta != null) {
                    sb.append(" ").append(busta.getID());
                }
                OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSlowLog().info(sb.toString());
            }
        }
    }

    private synchronized void init(PdDContext pddContext) throws ProtocolException {
        if (this.initDsResource == null && this.connection == null) {
            try {
                this.debug = this.openspcoop2Properties.isTransazioniDebug();
                this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioni(this.debug);
                this.logSql = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSql(this.debug);
            }
            catch (Exception e) {
                throw new ProtocolException("Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
            }
            try {
                this.tipoDatabaseRuntime = this.openspcoop2Properties.getDatabaseType();
                if (this.tipoDatabaseRuntime == null) {
                    throw new Exception("Tipo Database non definito");
                }
                Object openspcoopstate = pddContext.getObject(Costanti.OPENSPCOOP_STATE);
                if (openspcoopstate != null) {
                    this.openspcoop2State = (OpenSPCoopState)openspcoopstate;
                }
                if (this.openspcoop2State != null && this.openspcoop2Properties.isTransazioniFiltroDuplicatiTramiteTransazioniUsePdDConnection() && DBTransazioniManager.getInstance().useRuntimePdD() && !this.openspcoop2State.resourceReleased()) {
                    this.connection = this.openspcoop2State.getConnectionDB();
                    this.modeGetConnection = "DirectConnection";
                    this.isDirectConnection = true;
                } else {
                    this.initDsResource = true;
                    this.modeGetConnection = "DatasourceRuntime";
                    this.releaseRuntimeResourceBeforeCheck = true;
                }
                this.transazioneFieldConverter = new TransazioneFieldConverter(this.tipoDatabaseRuntime);
                this.nomeTabellaTransazioni = this.transazioneFieldConverter.toTable((IModel)Transazione.model());
                this.colonna_pdd_ruolo = this.transazioneFieldConverter.toColumn(Transazione.model().PDD_RUOLO, false);
                this.colonna_duplicati_richiesta = this.transazioneFieldConverter.toColumn(Transazione.model().DUPLICATI_RICHIESTA, false);
                this.colonna_data_id_msg_richiesta = this.transazioneFieldConverter.toColumn(Transazione.model().DATA_ID_MSG_RICHIESTA, false);
                this.colonna_id_messaggio_richiesta = this.transazioneFieldConverter.toColumn(Transazione.model().ID_MESSAGGIO_RICHIESTA, false);
                this.colonna_duplicati_risposta = this.transazioneFieldConverter.toColumn(Transazione.model().DUPLICATI_RISPOSTA, false);
                this.colonna_data_id_msg_risposta = this.transazioneFieldConverter.toColumn(Transazione.model().DATA_ID_MSG_RISPOSTA, false);
                this.colonna_id_messaggio_risposta = this.transazioneFieldConverter.toColumn(Transazione.model().ID_MESSAGGIO_RISPOSTA, false);
            }
            catch (Exception e) {
                throw new ProtocolException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean esisteTransazione(IProtocolFactory<?> protocolFactory, String idBustaRichiesta, String idBustaRisposta, TransazioniFiltroDuplicatiProcessTimes times) throws ProtocolException {
        boolean bl;
        Connection con = null;
        DBTransazioniManager dbManager = null;
        Resource r = null;
        String idModulo = "FiltroDuplicati.esisteTransazione";
        try {
            IBustaBuilder protocolBustaBuilder = null;
            protocolBustaBuilder = this.openspcoop2State != null ? (idBustaRichiesta != null ? protocolFactory.createBustaBuilder(this.openspcoop2State.getStatoRichiesta()) : protocolFactory.createBustaBuilder(this.openspcoop2State.getStatoRisposta())) : protocolFactory.createBustaBuilder(null);
            if (idBustaRichiesta == null && idBustaRisposta == null) {
                throw new ProtocolException("ID busta non forniti");
            }
            long timeStart = -1L;
            try {
                if (times != null) {
                    timeStart = DateManager.getTimeMillis();
                }
                if (this.connection != null) {
                    con = this.connection;
                } else {
                    dbManager = DBTransazioniManager.getInstance();
                    r = dbManager.getResource(this.openspcoop2Properties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), idModulo, this.idTransazione);
                    if (r == null) {
                        throw new Exception("Risorsa al database non disponibile");
                    }
                    con = (Connection)r.getResource();
                }
                if (con == null) {
                    throw new Exception("Connection is null");
                }
            }
            finally {
                if (times != null) {
                    long timeProcess;
                    long timeEnd = DateManager.getTimeMillis();
                    times.getConnection = timeProcess = timeEnd - timeStart;
                }
            }
            bl = this.esisteTransazione_query(protocolFactory, idBustaRichiesta, idBustaRisposta, con, protocolBustaBuilder, times);
            if (this.isDirectConnection) return bl;
        }
        catch (Exception e) {
            try {
                throw new ProtocolException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (this.isDirectConnection) throw throwable;
                try {
                    if (r == null) throw throwable;
                    dbManager.releaseResource(this.openspcoop2Properties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), idModulo, r);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (r == null) return bl;
            dbManager.releaseResource(this.openspcoop2Properties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), idModulo, r);
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void incrementDuplicatiTransazione(IProtocolFactory<?> protocolFactory, String idBusta, TransazioniFiltroDuplicatiProcessTimes times) throws ProtocolException {
        Connection con = null;
        DBTransazioniManager dbManager = null;
        Resource r = null;
        String idModulo = "FiltroDuplicati.incrementDuplicatiTransazione";
        try {
            IBustaBuilder protocolBustaBuilder2332 = null;
            protocolBustaBuilder2332 = this.openspcoop2State != null ? (this.openspcoop2State.getStatoRichiesta() != null ? protocolFactory.createBustaBuilder(this.openspcoop2State.getStatoRichiesta()) : protocolFactory.createBustaBuilder(this.openspcoop2State.getStatoRisposta())) : protocolFactory.createBustaBuilder(null);
            if (idBusta == null) {
                throw new ProtocolException("ID busta non fornito");
            }
            long timeStart = -1L;
            try {
                if (times != null) {
                    timeStart = DateManager.getTimeMillis();
                }
                if (this.connection != null) {
                    con = this.connection;
                } else {
                    dbManager = DBTransazioniManager.getInstance();
                    r = dbManager.getResource(this.openspcoop2Properties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), idModulo, this.idTransazione);
                    if (r == null) {
                        throw new Exception("Risorsa al database non disponibile");
                    }
                    con = (Connection)r.getResource();
                }
                if (con == null) {
                    throw new Exception("Connection is null");
                }
            }
            finally {
                if (times != null) {
                    long timeProcess;
                    long timeEnd = DateManager.getTimeMillis();
                    times.getConnection = timeProcess = timeEnd - timeStart;
                }
            }
            long timeRequest = -1L;
            long timeResponse = -1L;
            long timeSleep = -1L;
            boolean esisteRichiesta = false;
            boolean esisteRisposta = false;
            try {
                TransazioniFiltroDuplicatiProcessTimes checkRequest = null;
                TransazioniFiltroDuplicatiProcessTimes checkResponse = null;
                if (times != null) {
                    checkRequest = new TransazioniFiltroDuplicatiProcessTimes();
                }
                esisteRichiesta = this.esisteTransazione_query(protocolFactory, idBusta, null, con, protocolBustaBuilder2332, checkRequest);
                if (times != null) {
                    timeRequest = checkRequest.read;
                }
                if (!esisteRichiesta) {
                    if (times != null) {
                        checkResponse = new TransazioniFiltroDuplicatiProcessTimes();
                    }
                    esisteRisposta = this.esisteTransazione_query(protocolFactory, null, idBusta, con, protocolBustaBuilder2332, checkResponse);
                    if (times != null) {
                        timeResponse = checkResponse.read;
                    }
                }
                int i = 0;
                while (!esisteRichiesta && !esisteRisposta && i < 60) {
                    Utilities.sleep((long)1000L);
                    timeSleep = timeSleep == -1L ? 1000L : (timeSleep += 1000L);
                    ++i;
                    if (times != null) {
                        checkRequest = new TransazioniFiltroDuplicatiProcessTimes();
                    }
                    esisteRichiesta = this.esisteTransazione_query(protocolFactory, idBusta, null, con, protocolBustaBuilder2332, checkRequest);
                    if (times != null) {
                        timeRequest += checkRequest.read;
                    }
                    if (esisteRichiesta) continue;
                    if (times != null) {
                        checkResponse = new TransazioniFiltroDuplicatiProcessTimes();
                    }
                    esisteRisposta = this.esisteTransazione_query(protocolFactory, null, idBusta, con, protocolBustaBuilder2332, checkResponse);
                    if (times == null) continue;
                    timeResponse += checkResponse.read;
                }
            }
            finally {
                if (times != null) {
                    times.checkExistsRequest = timeRequest;
                    times.checkExistsResponse = timeResponse;
                    times.checkSleep = timeSleep;
                }
            }
            if (esisteRichiesta) {
                this.incrementDuplicatiTransazione(protocolFactory, true, idBusta, con, protocolBustaBuilder2332, times);
            } else {
                if (!esisteRisposta) throw new ProtocolException("Precedente transazione con solito idBusta risulta in gestione da oltre 60 secondi");
                this.incrementDuplicatiTransazione(protocolFactory, false, idBusta, con, protocolBustaBuilder2332, times);
            }
            if (this.isDirectConnection) return;
        }
        catch (Exception e) {
            try {
                throw new ProtocolException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (this.isDirectConnection) throw throwable;
                try {
                    if (r == null) throw throwable;
                    dbManager.releaseResource(this.openspcoop2Properties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), idModulo, r);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (r == null) return;
            dbManager.releaseResource(this.openspcoop2Properties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), idModulo, r);
            return;
        }
        catch (Exception protocolBustaBuilder2332) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean esisteTransazione_query(IProtocolFactory<?> protocolFactory, String idBustaRichiesta, String idBustaRisposta, Connection con, IBustaBuilder<?> protocolBustaBuilder, TransazioniFiltroDuplicatiProcessTimes times) throws ProtocolException {
        boolean bl;
        long timeStart;
        ResultSet rs;
        Statement pstmt;
        block51: {
            long timeProcess;
            block49: {
                boolean bl2;
                block50: {
                    long timeProcess2;
                    pstmt = null;
                    rs = null;
                    timeStart = -1L;
                    if (times != null) {
                        timeStart = DateManager.getTimeMillis();
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabaseRuntime);
                    if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiTramiteTransazioniForceIndex()) {
                        if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                            sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_REQ_2");
                            sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_RES_2");
                        } else {
                            sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_REQ");
                            sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_RES");
                        }
                    }
                    sqlQueryObject.addFromTable(this.nomeTabellaTransazioni);
                    if (idBustaRichiesta != null) {
                        if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                            sqlQueryObject.addWhereCondition(true, new String[]{this.colonna_data_id_msg_richiesta + "=?", this.colonna_id_messaggio_richiesta + "=?", this.colonna_pdd_ruolo + "=?"});
                        } else {
                            sqlQueryObject.addWhereCondition(true, new String[]{this.colonna_id_messaggio_richiesta + "=?", this.colonna_pdd_ruolo + "=?"});
                        }
                    }
                    if (idBustaRisposta != null) {
                        if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                            sqlQueryObject.addWhereCondition(true, new String[]{this.colonna_data_id_msg_risposta + "=?", this.colonna_id_messaggio_risposta + "=?", this.colonna_pdd_ruolo + "=?"});
                        } else {
                            sqlQueryObject.addWhereCondition(true, new String[]{this.colonna_id_messaggio_risposta + "=?", this.colonna_pdd_ruolo + "=?"});
                        }
                    }
                    sqlQueryObject.setANDLogicOperator(false);
                    String sql = sqlQueryObject.createSQLQuery();
                    pstmt = con.prepareStatement(sql);
                    int index = 1;
                    Timestamp t = null;
                    if (idBustaRichiesta != null) {
                        if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                            t = DateUtility.getTimestampIntoIdProtocollo(this.log, protocolBustaBuilder, idBustaRichiesta);
                            if (t == null && !this.useTransactionIdForTest) {
                                throw new Exception("Estrazione data dall'id busta [" + idBustaRichiesta + "] non riuscita");
                            }
                            pstmt.setTimestamp(index++, t);
                        }
                        pstmt.setString(index++, idBustaRichiesta);
                        pstmt.setString(index++, TipoPdD.APPLICATIVA.getTipo());
                    }
                    if (idBustaRisposta != null) {
                        if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                            t = DateUtility.getTimestampIntoIdProtocollo(this.log, protocolBustaBuilder, idBustaRisposta);
                            if (t == null && !this.useTransactionIdForTest) {
                                throw new Exception("Estrazione data dall'id busta [" + idBustaRisposta + "] non riuscita");
                            }
                            pstmt.setTimestamp(index++, t);
                        }
                        pstmt.setString(index++, idBustaRisposta);
                        pstmt.setString(index++, TipoPdD.DELEGATA.getTipo());
                    }
                    if (this.debug) {
                        DateTimeFormatterWrapper dateformat = null;
                        if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory) && t != null) {
                            dateformat = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm");
                        }
                        if (idBustaRichiesta != null) {
                            if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory) && dateformat != null) {
                                sql = sql.replaceFirst("\\?", "'" + dateformat.format(t) + "'");
                            }
                            sql = sql.replaceFirst("\\?", "'" + idBustaRichiesta + "'");
                            sql = sql.replaceFirst("\\?", "'" + TipoPdD.APPLICATIVA.getTipo() + "'");
                        }
                        if (idBustaRisposta != null) {
                            if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory) && dateformat != null) {
                                sql = sql.replaceFirst("\\?", "'" + dateformat.format(t) + "'");
                            }
                            sql = sql.replaceFirst("\\?", "'" + idBustaRisposta + "'");
                            sql = sql.replaceFirst("\\?", "'" + TipoPdD.DELEGATA.getTipo() + "'");
                        }
                        this.logSql.debug("Eseguo query: " + sql);
                    }
                    if (!(rs = pstmt.executeQuery()).next()) break block49;
                    if (this.debug) {
                        this.logSql.debug("Risultato query: true");
                    }
                    bl2 = true;
                    if (times == null) break block50;
                    long timeEnd3 = DateManager.getTimeMillis();
                    times.read = timeProcess2 = timeEnd3 - timeStart;
                }
                return bl2;
            }
            if (this.debug) {
                this.logSql.debug("Risultato query: false");
            }
            bl = false;
            if (times == null) break block51;
            long timeEnd = DateManager.getTimeMillis();
            times.read = timeProcess = timeEnd - timeStart;
        }
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    if (times != null) {
                        long timeProcess2;
                        long timeEnd2 = DateManager.getTimeMillis();
                        times.read = timeProcess2 = timeEnd2 - timeStart;
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProtocolException((Throwable)e);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception timeEnd3) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception timeEnd3) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementDuplicatiTransazione(IProtocolFactory<?> protocolFactory, boolean richiesta, String idBusta, Connection con, IBustaBuilder<?> protocolBustaBuilder, TransazioniFiltroDuplicatiProcessTimes times) throws ProtocolException {
        Statement pstmt = null;
        try {
            if (idBusta == null) {
                throw new ProtocolException("ID busta non fornito");
            }
            long timeStart = -1L;
            try {
                if (times != null) {
                    timeStart = DateManager.getTimeMillis();
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabaseRuntime);
                if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiTramiteTransazioniForceIndex()) {
                    if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                        sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_REQ_2");
                        sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_RES_2");
                    } else {
                        sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_REQ");
                        sqlQueryObject.addSelectForceIndex(this.nomeTabellaTransazioni, "INDEX_TR_FILTROD_RES");
                    }
                }
                sqlQueryObject.addUpdateTable(this.nomeTabellaTransazioni);
                if (richiesta) {
                    sqlQueryObject.addUpdateField(this.colonna_duplicati_richiesta, this.colonna_duplicati_richiesta + "+1");
                    if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                        sqlQueryObject.addWhereCondition(this.colonna_data_id_msg_richiesta + "=?");
                    }
                    sqlQueryObject.addWhereCondition(this.colonna_id_messaggio_richiesta + "=?");
                    sqlQueryObject.addWhereCondition(this.colonna_duplicati_richiesta + ">=?");
                    sqlQueryObject.addWhereCondition(this.colonna_pdd_ruolo + "=?");
                } else {
                    sqlQueryObject.addUpdateField(this.colonna_duplicati_risposta, this.colonna_duplicati_risposta + "+1");
                    if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                        sqlQueryObject.addWhereCondition(this.colonna_data_id_msg_risposta + "=?");
                    }
                    sqlQueryObject.addWhereCondition(this.colonna_id_messaggio_risposta + "=?");
                    sqlQueryObject.addWhereCondition(this.colonna_duplicati_risposta + ">=?");
                    sqlQueryObject.addWhereCondition(this.colonna_pdd_ruolo + "=?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                Timestamp timestampId = DateUtility.getTimestampIntoIdProtocollo(this.log, protocolBustaBuilder, idBusta);
                if (timestampId == null && this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory) && !this.useTransactionIdForTest) {
                    throw new Exception("Estrazione data dall'id busta [" + idBusta + "] non riuscita");
                }
                String sql = sqlQueryObject.createSQLUpdate();
                pstmt = con.prepareStatement(sql);
                int index = 1;
                if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                    pstmt.setTimestamp(index++, timestampId);
                }
                pstmt.setString(index++, idBusta);
                pstmt.setInt(index++, 0);
                if (richiesta) {
                    pstmt.setString(index++, TipoPdD.APPLICATIVA.getTipo());
                } else {
                    pstmt.setString(index++, TipoPdD.DELEGATA.getTipo());
                }
                if (this.debug) {
                    if (this.openspcoop2Properties.isTransazioniFiltroDuplicatiSaveDateEnabled(protocolFactory)) {
                        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm");
                        sql = sql.replaceFirst("\\?", "'" + dateformat.format(timestampId) + "'");
                    }
                    if (idBusta != null) {
                        sql = sql.replaceFirst("\\?", "'" + idBusta + "'");
                    }
                    sql = sql.replaceFirst("\\?", "0");
                    sql = richiesta ? sql.replaceFirst("\\?", "'" + TipoPdD.APPLICATIVA.getTipo() + "'") : sql.replaceFirst("\\?", "'" + TipoPdD.DELEGATA.getTipo() + "'");
                    this.logSql.debug("Eseguo query: " + sql);
                }
                int righeModificate = pstmt.executeUpdate();
                if (this.debug) {
                    this.logSql.debug("ID[" + idBusta + "] richiesta[" + richiesta + "] modificate righe: " + righeModificate);
                }
            }
            finally {
                if (times != null) {
                    long timeProcess;
                    long timeEnd = DateManager.getTimeMillis();
                    times.update = timeProcess = timeEnd - timeStart;
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

