/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.PropertiesEnvUtils;
import org.openspcoop2.core.config.Dump;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.IPdDContextSerializer;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.DateBuilder;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.utils.Costanti;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class OpenSPCoop2Logger {
    protected static Logger loggerTracciamento = null;
    public static boolean loggerTracciamentoAbilitato = false;
    protected static org.apache.logging.log4j.Logger loggerMsgDiagnostico = null;
    public static boolean loggerMsgDiagnosticoAbilitato = false;
    protected static org.apache.logging.log4j.Logger loggerOpenSPCoop2 = null;
    public static boolean loggerMsgDiagnosticoReadableAbilitato = false;
    protected static org.apache.logging.log4j.Logger loggerIntegrationManager = null;
    public static boolean loggerIntegrationManagerAbilitato = false;
    protected static Logger loggerDump = null;
    public static boolean loggerDumpAbilitato = false;
    protected static Logger loggerOpenSPCoopConsole = LoggerWrapperFactory.getLogger((String)"govway.startup");
    protected static boolean loggerOpenSPCoopConsoleStartupAgganciatoLog = false;
    protected static Logger loggerOpenSPCoopCore = null;
    protected static Logger loggerOpenSPCoopTimers = null;
    protected static Logger loggerOpenSPCoopResources = null;
    protected static org.apache.logging.log4j.Logger loggerOpenSPCoopResourcesAsLoggerImpl = null;
    protected static Logger loggerOpenSPCoopConfigurazioneSistema = null;
    protected static Logger loggerOpenSPCoopProxy = null;
    protected static Logger loggerOpenSPCoopConnettori = null;
    protected static Logger loggerOpenSPCoopDumpBinarioPD = null;
    protected static Logger loggerOpenSPCoopDumpBinarioPA = null;
    protected static Logger loggerOpenSPCoopEventi = null;
    protected static Logger loggerOpenSPCoopEventiError = null;
    protected static Logger loggerOpenSPCoopTransazioni = null;
    protected static Logger loggerOpenSPCoopTransazioniError = null;
    protected static Logger loggerOpenSPCoopTransazioniDevNull = null;
    protected static Logger loggerOpenSPCoopTransazioniSql = null;
    protected static Logger loggerOpenSPCoopTransazioniSqlError = null;
    protected static Logger loggerOpenSPCoopTransazioniStateful = null;
    protected static Logger loggerOpenSPCoopTransazioniStatefulError = null;
    protected static Logger loggerOpenSPCoopTransazioniStatefulSql = null;
    protected static Logger loggerOpenSPCoopTransazioniStatefulSqlError = null;
    protected static Logger loggerOpenSPCoopTransazioniSlowLog = null;
    protected static Logger loggerOpenSPCoopFileSystemRecovery = null;
    protected static Logger loggerOpenSPCoopFileSystemRecoveryError = null;
    protected static Logger loggerOpenSPCoopFileSystemRecoverySql = null;
    protected static Logger loggerOpenSPCoopFileSystemRecoverySqlError = null;
    protected static Logger loggerOpenSPCoopControlloTraffico = null;
    protected static Logger loggerOpenSPCoopControlloTrafficoError = null;
    protected static Logger loggerOpenSPCoopControlloTrafficoSql = null;
    protected static Logger loggerOpenSPCoopControlloTrafficoSqlError = null;
    protected static Logger loggerOpenSPCoopAllarmi = null;
    protected static Logger loggerOpenSPCoopAllarmiError = null;
    protected static Logger loggerOpenSPCoopAllarmiSql = null;
    protected static Logger loggerOpenSPCoopAllarmiSqlError = null;
    protected static Logger loggerOpenSPCoopStatisticheOrarie = null;
    protected static Logger loggerOpenSPCoopStatisticheOrarieError = null;
    protected static Logger loggerOpenSPCoopStatisticheGiornaliere = null;
    protected static Logger loggerOpenSPCoopStatisticheGiornaliereError = null;
    protected static Logger loggerOpenSPCoopStatisticheSettimanali = null;
    protected static Logger loggerOpenSPCoopStatisticheSettimanaliError = null;
    protected static Logger loggerOpenSPCoopStatisticheMensili = null;
    protected static Logger loggerOpenSPCoopStatisticheMensiliError = null;
    protected static Logger loggerOpenSPCoopStatistichePdndGenerazione = null;
    protected static Logger loggerOpenSPCoopStatistichePdndGenerazioneError = null;
    protected static Logger loggerOpenSPCoopStatistichePdndPubblicazione = null;
    protected static Logger loggerOpenSPCoopStatistichePdndPubblicazioneError = null;
    protected static Logger loggerOpenSPCoopStatisticheOrarieSql = null;
    protected static Logger loggerOpenSPCoopStatisticheOrarieSqlError = null;
    protected static Logger loggerOpenSPCoopStatisticheGiornaliereSql = null;
    protected static Logger loggerOpenSPCoopStatisticheGiornaliereSqlError = null;
    protected static Logger loggerOpenSPCoopStatisticheSettimanaliSql = null;
    protected static Logger loggerOpenSPCoopStatisticheSettimanaliSqlError = null;
    protected static Logger loggerOpenSPCoopStatisticheMensiliSql = null;
    protected static Logger loggerOpenSPCoopStatisticheMensiliSqlError = null;
    protected static Logger loggerOpenSPCoopStatistichePdndGenerazioneSql = null;
    protected static Logger loggerOpenSPCoopStatistichePdndGenerazioneSqlError = null;
    protected static Logger loggerOpenSPCoopStatistichePdndPubblicazioneSql = null;
    protected static Logger loggerOpenSPCoopStatistichePdndPubblicazioneSqlError = null;
    protected static Logger loggerOpenSPCoopConsegnaContenuti = null;
    protected static Logger loggerOpenSPCoopConsegnaContenutiError = null;
    protected static Logger loggerOpenSPCoopConsegnaContenutiSql = null;
    protected static Logger loggerOpenSPCoopConsegnaContenutiSqlError = null;
    protected static Logger loggerOpenSPCoopPlugins = null;
    protected static Logger loggerOpenSPCoopPluginsError = null;
    protected static Logger loggerOpenSPCoopPluginsSql = null;
    protected static Logger loggerOpenSPCoopPluginsSqlError = null;
    protected static Logger loggerOpenSPCoopGestoreChiaviPDND = null;
    protected static Logger loggerOpenSPCoopGestoreChiaviPDNDError = null;
    protected static Logger loggerOpenSPCoopGestoreOperazioniRemote = null;
    protected static Logger loggerOpenSPCoopGestoreOperazioniRemoteError = null;
    public static List<IDiagnosticProducer> loggerMsgDiagnosticoOpenSPCoopAppender = new ArrayList<IDiagnosticProducer>();
    public static List<String> tipoMsgDiagnosticoOpenSPCoopAppender = new ArrayList<String>();
    public static List<ITracciaProducer> loggerTracciamentoOpenSPCoopAppender = new ArrayList<ITracciaProducer>();
    public static List<String> tipoTracciamentoOpenSPCoopAppender = new ArrayList<String>();
    public static List<IDumpProducer> loggerDumpOpenSPCoopAppender = new ArrayList<IDumpProducer>();
    public static List<String> tipoDumpOpenSPCoopAppender = new ArrayList<String>();
    private static IPdDContextSerializer pddContextSerializer = null;
    private static List<File> logDirs;
    private static final String APP_NAME = "govway";
    private static List<String> filesCheck;

    public static List<File> getLogDirs() {
        return logDirs;
    }

    public static boolean isLoggerOpenSPCoopConsoleStartupAgganciatoLog() {
        return loggerOpenSPCoopConsoleStartupAgganciatoLog;
    }

    private static void initializeLogDirs(Properties p, boolean append) {
        if (!append) {
            logDirs = new ArrayList<File>();
            filesCheck = new ArrayList<String>();
        }
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            File fTmp;
            String key = (String)en.nextElement();
            key = key.trim();
            String value = p.getProperty(key);
            value = value.trim();
            if (!key.endsWith(".fileName") && !key.endsWith(".filePattern") || (fTmp = new File(value)).getParentFile() == null || filesCheck.contains(fTmp.getParentFile().getAbsolutePath())) continue;
            logDirs.add(fTmp.getParentFile());
            filesCheck.add(fTmp.getParentFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initializeLogConsole(Logger logConsole) {
        InputStream isOp2 = null;
        InputStream isLogger = null;
        try {
            CollectionProperties loggerPropertiesRidefinito;
            isOp2 = OpenSPCoop2Logger.class.getResourceAsStream("/govway.properties");
            String confDir = null;
            if (isOp2 != null) {
                Properties op2Properties = new Properties();
                op2Properties.load(isOp2);
                confDir = op2Properties.getProperty("org.openspcoop2.pdd.confDirectory");
                confDir = PropertiesEnvUtils.resolveGovWayEnvVariables((String)confDir);
            }
            Properties loggerProperties = new Properties();
            isLogger = OpenSPCoop2Logger.class.getResourceAsStream("/govway.log4j2.properties");
            if (isLogger != null) {
                loggerProperties.load(isLogger);
            }
            if ((loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)LoggerWrapperFactory.getLogger(OpenSPCoop2Logger.class), (String)"OPENSPCOOP2_LOGGER_PROPERTIES", (String)"govway_local.log4j2.properties", (String)confDir)) != null && loggerPropertiesRidefinito.size() > 0) {
                Enumeration ridefinito = loggerPropertiesRidefinito.keys();
                while (ridefinito.hasMoreElements()) {
                    String key = (String)ridefinito.nextElement();
                    String value = loggerPropertiesRidefinito.get(key);
                    if (loggerProperties.containsKey(key)) {
                        loggerProperties.remove(key);
                    }
                    loggerProperties.put(key, value);
                }
            }
            PropertiesEnvUtils.resolveGovWayEnvVariables((Properties)loggerProperties);
            LoggerWrapperFactory.patchLoggers((Properties)loggerProperties, (Map)Costanti.ENV_LOG_GOVWAY, Map.of("appName", APP_NAME));
            LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties);
            OpenSPCoop2Logger.initializeLogDirs(loggerProperties, false);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop: " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (isOp2 != null) {
                    isOp2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (isLogger != null) {
                    isLogger.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean initialize(Logger logConsole, String rootDirectory, Properties objectProperties, boolean allarmiEnabled) {
        return OpenSPCoop2Logger.initialize(logConsole, rootDirectory, objectProperties, true, allarmiEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(Logger logConsole, String rootDirectory, Properties objectProperties, boolean loadExternalConfiguration, boolean allarmiEnabled) {
        try {
            Properties loggerProperties = new Properties();
            File loggerFile = new File(rootDirectory + "govway.log4j2.properties");
            if (!loggerFile.exists()) {
                loggerProperties.load(OpenSPCoop2Logger.class.getResourceAsStream("/govway.log4j2.properties"));
            } else {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(loggerFile);
                    loggerProperties.load(fin);
                }
                finally {
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (loadExternalConfiguration) {
                OpenSPCoop2Logger.loadExternal(logConsole, "OPENSPCOOP2_LOGGER_PROPERTIES", "govway_local.log4j2.properties", rootDirectory, loggerProperties, objectProperties);
            }
            PropertiesEnvUtils.resolveGovWayEnvVariables((Properties)loggerProperties);
            LoggerWrapperFactory.patchLoggers((Properties)loggerProperties, (Map)Costanti.ENV_LOG_GOVWAY, Map.of("appName", APP_NAME));
            LoggerWrapperFactory.setLogConfiguration((Properties)loggerProperties);
            OpenSPCoop2Logger.initializeLogDirs(loggerProperties, false);
            String tmp = loggerProperties.getProperty("logger.govway_startup.level");
            if (tmp != null && !tmp.equalsIgnoreCase("OFF")) {
                loggerOpenSPCoopConsoleStartupAgganciatoLog = true;
            }
            if ((loggerTracciamento = LoggerWrapperFactory.getLogger((String)"govway.tracciamento")) == null) {
                throw new CoreException("Logger govway.tracciamento non trovato");
            }
            tmp = loggerProperties.getProperty("logger.govway_tracciamento.level");
            if (tmp != null) {
                if ((tmp = tmp.trim()).equalsIgnoreCase("OFF")) {
                    loggerOpenSPCoopConsole.info("Sistema di logging delle tracce disabilitato da log4j (OFF).");
                    loggerTracciamentoAbilitato = false;
                } else {
                    loggerTracciamentoAbilitato = true;
                }
            }
            if ((loggerMsgDiagnostico = LoggerWrapperFactory.getLoggerImpl((String)"govway.msgDiagnostico")) == null) {
                throw new CoreException("Logger govway.msgDiagnostico non trovato");
            }
            tmp = loggerProperties.getProperty("logger.govway_diagnostici.level");
            if (tmp != null) {
                if ((tmp = tmp.trim()).equalsIgnoreCase("OFF")) {
                    loggerOpenSPCoopConsole.info("Sistema di logging dei messaggi diagnostici disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoAbilitato = false;
                } else {
                    loggerMsgDiagnosticoAbilitato = true;
                }
            }
            if ((loggerOpenSPCoop2 = LoggerWrapperFactory.getLoggerImpl((String)"govway.portaDiDominio")) == null) {
                throw new CoreException("Logger govway.portaDiDominio non trovato");
            }
            tmp = loggerProperties.getProperty("logger.govway_portaDiDominio.level");
            if (tmp != null) {
                if ((tmp = tmp.trim()).equalsIgnoreCase("OFF")) {
                    loggerOpenSPCoopConsole.info("Sistema di logging dei messaggi diagnostici 'readable' disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoReadableAbilitato = false;
                } else {
                    loggerMsgDiagnosticoReadableAbilitato = true;
                }
            }
            if ((loggerIntegrationManager = LoggerWrapperFactory.getLoggerImpl((String)"govway.integrationManager")) == null) {
                throw new CoreException("Logger govway.integrationManager non trovato");
            }
            tmp = loggerProperties.getProperty("logger.govway_integrationManager.level");
            if (tmp != null) {
                if ((tmp = tmp.trim()).equalsIgnoreCase("OFF")) {
                    loggerOpenSPCoopConsole.info("Sistema di logging dei messaggi diagnostici 'readable' per il servizio di IntegrationManager disabilitato da log4j (OFF).");
                    loggerIntegrationManagerAbilitato = false;
                } else {
                    loggerIntegrationManagerAbilitato = true;
                }
            }
            if ((loggerDump = LoggerWrapperFactory.getLogger((String)"govway.dump")) == null) {
                throw new CoreException("Logger govway.dump non trovato");
            }
            tmp = loggerProperties.getProperty("logger.govway_dump.level");
            if (tmp != null) {
                if ((tmp = tmp.trim()).equalsIgnoreCase("OFF")) {
                    loggerOpenSPCoopConsole.info("Sistema di logging dei contenuti applicativi (dump) disabilitato da log4j (OFF).");
                    loggerDumpAbilitato = false;
                } else {
                    loggerDumpAbilitato = true;
                }
            }
            if ((loggerOpenSPCoopCore = LoggerWrapperFactory.getLogger((String)"govway.core")) == null) {
                throw new CoreException("Logger govway.core non trovato");
            }
            loggerOpenSPCoopTimers = LoggerWrapperFactory.getLogger((String)"govway.timers");
            if (loggerOpenSPCoopTimers == null) {
                throw new CoreException("Logger govway.timers non trovato");
            }
            loggerOpenSPCoopResources = LoggerWrapperFactory.getLogger((String)"govway.resources");
            if (loggerOpenSPCoopResources == null) {
                throw new CoreException("Logger govway.resources non trovato");
            }
            loggerOpenSPCoopResourcesAsLoggerImpl = LoggerWrapperFactory.getLoggerImpl((String)"govway.resources");
            if (loggerOpenSPCoopResourcesAsLoggerImpl == null) {
                throw new CoreException("Logger(Impl) govway.resources non trovato");
            }
            loggerOpenSPCoopConfigurazioneSistema = LoggerWrapperFactory.getLogger((String)"govway.configurazioneSistema");
            if (loggerOpenSPCoopConfigurazioneSistema == null) {
                throw new CoreException("Logger govway.configurazioneSistema non trovato");
            }
            loggerOpenSPCoopProxy = LoggerWrapperFactory.getLogger((String)"govway.proxy");
            if (loggerOpenSPCoopProxy == null) {
                throw new CoreException("Logger govway.proxy non trovato");
            }
            loggerOpenSPCoopConnettori = LoggerWrapperFactory.getLogger((String)"govway.connettori");
            if (loggerOpenSPCoopConnettori == null) {
                throw new CoreException("Logger govway.connettori non trovato");
            }
            loggerOpenSPCoopDumpBinarioPD = LoggerWrapperFactory.getLogger((String)"govway.dumpBinarioPD");
            if (loggerOpenSPCoopDumpBinarioPD == null) {
                throw new CoreException("Logger govway.dumpBinarioPD non trovato");
            }
            loggerOpenSPCoopDumpBinarioPA = LoggerWrapperFactory.getLogger((String)"govway.dumpBinarioPA");
            if (loggerOpenSPCoopDumpBinarioPA == null) {
                throw new CoreException("Logger govway.dumpBinarioPA non trovato");
            }
            loggerOpenSPCoopEventi = LoggerWrapperFactory.getLogger((String)"govway.eventi");
            if (loggerOpenSPCoopEventi == null) {
                throw new CoreException("Logger govway.eventi non trovato");
            }
            loggerOpenSPCoopTransazioni = LoggerWrapperFactory.getLogger((String)"govway.transazioni");
            if (loggerOpenSPCoopTransazioni == null) {
                throw new CoreException("Logger govway.transazioni non trovato");
            }
            loggerOpenSPCoopTransazioniError = LoggerWrapperFactory.getLogger((String)"govway.transazioni.error");
            if (loggerOpenSPCoopTransazioniError == null) {
                throw new CoreException("Logger govway.transazioni.error non trovato");
            }
            loggerOpenSPCoopTransazioniDevNull = LoggerWrapperFactory.getLogger((String)"govway.transazioni.devnull");
            if (loggerOpenSPCoopTransazioniDevNull == null) {
                throw new CoreException("Logger govway.transazioni.devnull non trovato");
            }
            loggerOpenSPCoopTransazioniSql = LoggerWrapperFactory.getLogger((String)"govway.transazioni.sql");
            if (loggerOpenSPCoopTransazioniSql == null) {
                throw new CoreException("Logger govway.transazioni.sql non trovato");
            }
            loggerOpenSPCoopTransazioniSqlError = LoggerWrapperFactory.getLogger((String)"govway.transazioni.sql.error");
            if (loggerOpenSPCoopTransazioniSqlError == null) {
                throw new CoreException("Logger govway.transazioni.sql.error non trovato");
            }
            loggerOpenSPCoopTransazioniStateful = LoggerWrapperFactory.getLogger((String)"govway.transazioni.stateful");
            if (loggerOpenSPCoopTransazioniStateful == null) {
                throw new CoreException("Logger govway.transazioni.stateful non trovato");
            }
            loggerOpenSPCoopTransazioniStatefulError = LoggerWrapperFactory.getLogger((String)"govway.transazioni.stateful.error");
            if (loggerOpenSPCoopTransazioniStatefulError == null) {
                throw new CoreException("Logger govway.transazioni.stateful.error non trovato");
            }
            loggerOpenSPCoopTransazioniStatefulSql = LoggerWrapperFactory.getLogger((String)"govway.transazioni.stateful.sql");
            if (loggerOpenSPCoopTransazioniStatefulSql == null) {
                throw new CoreException("Logger govway.transazioni.stateful.sql non trovato");
            }
            loggerOpenSPCoopTransazioniStatefulSqlError = LoggerWrapperFactory.getLogger((String)"govway.transazioni.stateful.sql.error");
            if (loggerOpenSPCoopTransazioniStatefulSqlError == null) {
                throw new CoreException("Logger govway.transazioni.stateful.sql.error non trovato");
            }
            loggerOpenSPCoopTransazioniSlowLog = LoggerWrapperFactory.getLogger((String)"govway.transazioni.slowLog");
            if (loggerOpenSPCoopTransazioniSlowLog == null) {
                throw new CoreException("Logger govway.transazioni.slowLog non trovato");
            }
            loggerOpenSPCoopEventiError = LoggerWrapperFactory.getLogger((String)"govway.eventi.error");
            if (loggerOpenSPCoopEventiError == null) {
                throw new CoreException("Logger govway.eventi.error non trovato");
            }
            loggerOpenSPCoopFileSystemRecovery = LoggerWrapperFactory.getLogger((String)"govway.recoveryFileSystem");
            if (loggerOpenSPCoopFileSystemRecovery == null) {
                throw new CoreException("Logger govway.recoveryFileSystem non trovato");
            }
            loggerOpenSPCoopFileSystemRecoveryError = LoggerWrapperFactory.getLogger((String)"govway.recoveryFileSystem.error");
            if (loggerOpenSPCoopFileSystemRecoveryError == null) {
                throw new CoreException("Logger govway.recoveryFileSystem.error non trovato");
            }
            loggerOpenSPCoopFileSystemRecoverySql = LoggerWrapperFactory.getLogger((String)"govway.recoveryFileSystem.sql");
            if (loggerOpenSPCoopFileSystemRecoverySql == null) {
                throw new CoreException("Logger govway.recoveryFileSystem.sql non trovato");
            }
            loggerOpenSPCoopFileSystemRecoverySqlError = LoggerWrapperFactory.getLogger((String)"govway.recoveryFileSystem.sql.error");
            if (loggerOpenSPCoopFileSystemRecoverySqlError == null) {
                throw new CoreException("Logger govway.recoveryFileSystem.sql.error non trovato");
            }
            loggerOpenSPCoopControlloTraffico = LoggerWrapperFactory.getLogger((String)"govway.controlloTraffico");
            if (loggerOpenSPCoopControlloTraffico == null) {
                throw new CoreException("Logger govway.controlloTraffico non trovato");
            }
            loggerOpenSPCoopControlloTrafficoError = LoggerWrapperFactory.getLogger((String)"govway.controlloTraffico.error");
            if (loggerOpenSPCoopControlloTrafficoError == null) {
                throw new CoreException("Logger govway.controlloTraffico.error non trovato");
            }
            loggerOpenSPCoopControlloTrafficoSql = LoggerWrapperFactory.getLogger((String)"govway.controlloTraffico.sql");
            if (loggerOpenSPCoopControlloTrafficoSql == null) {
                throw new CoreException("Logger govway.controlloTraffico.sql non trovato");
            }
            loggerOpenSPCoopControlloTrafficoSqlError = LoggerWrapperFactory.getLogger((String)"govway.controlloTraffico.sql.error");
            if (loggerOpenSPCoopControlloTrafficoSqlError == null) {
                throw new CoreException("Logger govway.controlloTraffico.sql.error non trovato");
            }
            if (allarmiEnabled) {
                loggerOpenSPCoopAllarmi = LoggerWrapperFactory.getLogger((String)"govway.controlloAllarmi");
                if (loggerOpenSPCoopAllarmi == null) {
                    throw new CoreException("Logger govway.controlloAllarmi non trovato");
                }
                loggerOpenSPCoopAllarmiError = LoggerWrapperFactory.getLogger((String)"govway.controlloAllarmi.error");
                if (loggerOpenSPCoopAllarmiError == null) {
                    throw new CoreException("Logger govway.controlloAllarmi.error non trovato");
                }
                loggerOpenSPCoopAllarmiSql = LoggerWrapperFactory.getLogger((String)"govway.controlloAllarmi.sql");
                if (loggerOpenSPCoopAllarmiSql == null) {
                    throw new CoreException("Logger govway.controlloAllarmi.sql non trovato");
                }
                loggerOpenSPCoopAllarmiSqlError = LoggerWrapperFactory.getLogger((String)"govway.controlloAllarmi.sql.error");
                if (loggerOpenSPCoopAllarmiSqlError == null) {
                    throw new CoreException("Logger govway.controlloAllarmi.sql.error non trovato");
                }
            }
            if ((loggerOpenSPCoopStatisticheOrarie = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione")) == null) {
                throw new CoreException("Logger govway.statistiche.generazione non trovato");
            }
            loggerOpenSPCoopStatisticheOrarieError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione.error");
            if (loggerOpenSPCoopStatisticheOrarieError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.error non trovato");
            }
            loggerOpenSPCoopStatisticheOrarieSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione.sql");
            if (loggerOpenSPCoopStatisticheOrarieSql == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql non trovato");
            }
            loggerOpenSPCoopStatisticheOrarieSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_orarie.generazione.sql.error");
            if (loggerOpenSPCoopStatisticheOrarieSqlError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql.error non trovato");
            }
            loggerOpenSPCoopStatisticheGiornaliere = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione");
            if (loggerOpenSPCoopStatisticheGiornaliere == null) {
                throw new CoreException("Logger govway.statistiche.generazione non trovato");
            }
            loggerOpenSPCoopStatisticheGiornaliereError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione.error");
            if (loggerOpenSPCoopStatisticheGiornaliereError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.error non trovato");
            }
            loggerOpenSPCoopStatisticheGiornaliereSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione.sql");
            if (loggerOpenSPCoopStatisticheGiornaliereSql == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql non trovato");
            }
            loggerOpenSPCoopStatisticheGiornaliereSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_giornaliere.generazione.sql.error");
            if (loggerOpenSPCoopStatisticheGiornaliereSqlError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql.error non trovato");
            }
            loggerOpenSPCoopStatisticheSettimanali = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione");
            if (loggerOpenSPCoopStatisticheSettimanali == null) {
                throw new CoreException("Logger govway.statistiche.generazione non trovato");
            }
            loggerOpenSPCoopStatisticheSettimanaliError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione.error");
            if (loggerOpenSPCoopStatisticheSettimanaliError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.error non trovato");
            }
            loggerOpenSPCoopStatisticheSettimanaliSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione.sql");
            if (loggerOpenSPCoopStatisticheSettimanaliSql == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql non trovato");
            }
            loggerOpenSPCoopStatisticheSettimanaliSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_settimanali.generazione.sql.error");
            if (loggerOpenSPCoopStatisticheSettimanaliSqlError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql.error non trovato");
            }
            loggerOpenSPCoopStatisticheMensili = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione");
            if (loggerOpenSPCoopStatisticheMensili == null) {
                throw new CoreException("Logger govway.statistiche.generazione non trovato");
            }
            loggerOpenSPCoopStatisticheMensiliError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione.error");
            if (loggerOpenSPCoopStatisticheMensiliError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.error non trovato");
            }
            loggerOpenSPCoopStatisticheMensiliSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione.sql");
            if (loggerOpenSPCoopStatisticheMensiliSql == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql non trovato");
            }
            loggerOpenSPCoopStatisticheMensiliSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_mensili.generazione.sql.error");
            if (loggerOpenSPCoopStatisticheMensiliSqlError == null) {
                throw new CoreException("Logger govway.statistiche.generazione.sql.error non trovato");
            }
            loggerOpenSPCoopStatistichePdndGenerazione = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione");
            if (loggerOpenSPCoopStatistichePdndGenerazione == null) {
                throw new CoreException("Logger govway.statistiche_pdnd_tracciamento.generazione non trovato");
            }
            loggerOpenSPCoopStatistichePdndGenerazioneError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione.error");
            if (loggerOpenSPCoopStatistichePdndGenerazioneError == null) {
                throw new CoreException("Logger govway.statistiche_pdnd_tracciamento.generazione.error non trovato");
            }
            loggerOpenSPCoopStatistichePdndGenerazioneSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione.sql");
            if (loggerOpenSPCoopStatistichePdndGenerazioneSql == null) {
                throw new CoreException("Loggergovway.statistiche_pdnd_tracciamento.generazione.sql non trovato");
            }
            loggerOpenSPCoopStatistichePdndGenerazioneSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.generazione.sql.error");
            if (loggerOpenSPCoopStatistichePdndGenerazioneSqlError == null) {
                throw new CoreException("Logger govway.statistiche_pdnd_tracciamento.generazione.sql.error non trovato");
            }
            loggerOpenSPCoopStatistichePdndPubblicazione = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione");
            if (loggerOpenSPCoopStatistichePdndPubblicazione == null) {
                throw new CoreException("Logger govway.statistiche_pdnd_tracciamento.pubblicazione non trovato");
            }
            loggerOpenSPCoopStatistichePdndPubblicazioneError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione.error");
            if (loggerOpenSPCoopStatistichePdndPubblicazioneError == null) {
                throw new CoreException("Logger govway.statistiche_pdnd_tracciamento.pubblicazione.error non trovato");
            }
            loggerOpenSPCoopStatistichePdndPubblicazioneSql = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione.sql");
            if (loggerOpenSPCoopStatistichePdndPubblicazioneSql == null) {
                throw new CoreException("Logger govway.statistiche_pdnd_tracciamento.pubblicazione.sql non trovato");
            }
            loggerOpenSPCoopStatistichePdndPubblicazioneSqlError = LoggerWrapperFactory.getLogger((String)"govway.statistiche_pdnd_tracciamento.pubblicazione.sql.error");
            if (loggerOpenSPCoopStatistichePdndPubblicazioneSqlError == null) {
                throw new CoreException("Logger govway.statistiche_pdnd_tracciamento.pubblicazione.sql.error non trovato");
            }
            loggerOpenSPCoopConsegnaContenuti = LoggerWrapperFactory.getLogger((String)"govway.consegna_messaggi");
            if (loggerOpenSPCoopConsegnaContenuti == null) {
                throw new CoreException("Logger govway.consegna_messaggi non trovato");
            }
            loggerOpenSPCoopConsegnaContenutiError = LoggerWrapperFactory.getLogger((String)"govway.consegna_messaggi.error");
            if (loggerOpenSPCoopConsegnaContenutiError == null) {
                throw new CoreException("Logger govway.consegna_messaggi.error non trovato");
            }
            loggerOpenSPCoopConsegnaContenutiSql = LoggerWrapperFactory.getLogger((String)"govway.consegna_messaggi.sql");
            if (loggerOpenSPCoopConsegnaContenutiSql == null) {
                throw new CoreException("Logger govway.consegna_messaggi.sql non trovato");
            }
            loggerOpenSPCoopConsegnaContenutiSqlError = LoggerWrapperFactory.getLogger((String)"govway.consegna_messaggi.sql.error");
            if (loggerOpenSPCoopConsegnaContenutiSqlError == null) {
                throw new CoreException("Logger govway.consegna_messaggi.sql.error non trovato");
            }
            loggerOpenSPCoopPlugins = LoggerWrapperFactory.getLogger((String)"govway.plugins");
            if (loggerOpenSPCoopPlugins == null) {
                throw new CoreException("Logger govway.plugins non trovato");
            }
            loggerOpenSPCoopPluginsError = LoggerWrapperFactory.getLogger((String)"govway.plugins.error");
            if (loggerOpenSPCoopPluginsError == null) {
                throw new CoreException("Logger govway.plugins.error non trovato");
            }
            loggerOpenSPCoopPluginsSql = LoggerWrapperFactory.getLogger((String)"govway.plugins.sql");
            if (loggerOpenSPCoopPluginsSql == null) {
                throw new CoreException("Logger govway.plugins.sql non trovato");
            }
            loggerOpenSPCoopPluginsSqlError = LoggerWrapperFactory.getLogger((String)"govway.plugins.sql.error");
            if (loggerOpenSPCoopPluginsSqlError == null) {
                throw new CoreException("Logger govway.plugins.sql.error non trovato");
            }
            loggerOpenSPCoopGestoreChiaviPDND = LoggerWrapperFactory.getLogger((String)"govway.gestoreChiaviPDND");
            if (loggerOpenSPCoopGestoreChiaviPDND == null) {
                throw new CoreException("Logger govway.gestoreChiaviPDND non trovato");
            }
            loggerOpenSPCoopGestoreChiaviPDNDError = LoggerWrapperFactory.getLogger((String)"govway.gestoreChiaviPDND.error");
            if (loggerOpenSPCoopGestoreChiaviPDNDError == null) {
                throw new CoreException("Logger govway.gestoreChiaviPDND.error non trovato");
            }
            loggerOpenSPCoopGestoreOperazioniRemote = LoggerWrapperFactory.getLogger((String)"govway.gestoreOperazioniRemote");
            if (loggerOpenSPCoopGestoreOperazioniRemote == null) {
                throw new CoreException("Logger govway.gestoreOperazioniRemote non trovato");
            }
            loggerOpenSPCoopGestoreOperazioniRemoteError = LoggerWrapperFactory.getLogger((String)"govway.gestoreOperazioniRemote.error");
            if (loggerOpenSPCoopGestoreOperazioniRemoteError == null) {
                throw new CoreException("Logger govway.gestoreOperazioniRemote.error non trovato");
            }
            loggerOpenSPCoopConsole.info("Sistema di logging correttamente inizializzato.");
            OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
            String pddContextSerializerClass = propertiesReader.getPddContextSerializer();
            if (pddContextSerializerClass != null && !"none".equals(pddContextSerializerClass)) {
                try {
                    pddContextSerializer = (IPdDContextSerializer)Loader.getInstance().newInstance(pddContextSerializerClass);
                }
                catch (Exception e) {
                    throw new CoreException("Inizializzione IPdDContextSerializer non riuscita [" + pddContextSerializerClass + "]:" + e.getMessage(), (Throwable)e);
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void loadExternal(Logger logConsole, String loggerProperty, String loggerPath, String rootDirectory, Properties loggerProperties, Properties objectProperties) {
        String value;
        String key;
        Enumeration<Object> ridefinito;
        CollectionProperties loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)logConsole, (String)loggerProperty, (String)loggerPath, (String)rootDirectory);
        if (loggerPropertiesRidefinito != null && loggerPropertiesRidefinito.size() > 0) {
            ridefinito = loggerPropertiesRidefinito.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = loggerPropertiesRidefinito.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
        if (objectProperties != null && objectProperties.size() > 0) {
            ridefinito = objectProperties.keys();
            while (ridefinito.hasMoreElements()) {
                key = (String)ridefinito.nextElement();
                value = (String)objectProperties.get(key);
                if (loggerProperties.containsKey(key)) {
                    loggerProperties.remove(key);
                }
                loggerProperties.put(key, value);
            }
        }
    }

    public static boolean initializeProtocolLogger(Logger logConsole, boolean loadExternalConfiguration, String rootDirectory, Properties objectProperties) {
        try {
            ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
            Enumeration protocolNames = protocolFactoryManager.getProtocolNames();
            while (protocolNames.hasMoreElements()) {
                String content;
                String protocol = (String)protocolNames.nextElement();
                if (!protocolFactoryManager.isSupportedProtocolLogger(protocol)) continue;
                Properties loggerPropertiesProtocolAdjunct = null;
                InputStream isLoggerProtocol = OpenSPCoop2Logger.class.getResourceAsStream("/govway.protocolAdjunct.log4j2.properties");
                if (isLoggerProtocol != null && (content = Utilities.getAsString((InputStream)isLoggerProtocol, (String)Charset.UTF_8.getValue())) != null) {
                    content = content.replaceAll("IDPROTOCOLLO", protocol);
                    loggerPropertiesProtocolAdjunct = new Properties();
                    StringReader sr = new StringReader(content);
                    loggerPropertiesProtocolAdjunct.load(sr);
                    sr.close();
                }
                if (loadExternalConfiguration) {
                    OpenSPCoop2Logger.loadExternal(logConsole, CostantiPdD.getOpenspcoop2LoggerProtocolProperties(protocol), CostantiPdD.getOpenspcoop2LoggerProtocolLocalPath(protocol), rootDirectory, loggerPropertiesProtocolAdjunct, objectProperties);
                }
                logConsole.info("Protocol '" + protocol + "': Log4j config append");
                if (loggerPropertiesProtocolAdjunct != null) {
                    PropertiesEnvUtils.resolveGovWayEnvVariables(loggerPropertiesProtocolAdjunct);
                    LoggerWrapperFactory.patchLoggers((Properties)loggerPropertiesProtocolAdjunct, (Map)Costanti.ENV_LOG_GOVWAY, Map.of("appName", APP_NAME));
                    LoggerWrapperFactory.setLogConfiguration((Properties)loggerPropertiesProtocolAdjunct, (boolean)true);
                    OpenSPCoop2Logger.initializeLogDirs(loggerPropertiesProtocolAdjunct, true);
                }
                Logger log = LoggerWrapperFactory.getLogger((String)CostantiPdD.getOpenspcoop2LoggerFactoryName(protocol));
                protocolFactoryManager.getProtocolFactoryByName(protocol).initProtocolLogger(log);
                log.info("Inizializzazione completata");
            }
            return true;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop per i protocolli: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean initializeMsgDiagnosticiOpenSPCoopAppender(MessaggiDiagnostici msgDiagConfig) {
        try {
            if (msgDiagConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < msgDiagConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String msgDiagAppenderClass = prop.getMsgDiagnosticoOpenSPCoopAppender(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    if (msgDiagAppenderClass == null) {
                        throw new CoreException("Riscontrato errore durante il caricamento del msg diagnostico appender [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    IDiagnosticProducer appender = null;
                    try {
                        appender = (IDiagnosticProducer)Loader.getInstance().newInstance(msgDiagAppenderClass);
                        appender.initializeAppender(msgDiagConfig.getOpenspcoopAppender(i));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CoreException("Riscontrato errore durante il caricamento del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new CoreException("Riscontrato errore durante l'inizializzazione del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    loggerMsgDiagnosticoOpenSPCoopAppender.add(appender);
                    tipoMsgDiagnosticoOpenSPCoopAppender.add(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    loggerOpenSPCoopConsole.info("Sistema di logging: MsgDiagnosticoOpenSPCoopAppender di tipo [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato.");
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerMsgDiagnosticoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error("Riscontrato errore durante l'inizializzazione degli appender personalizzati per msg diagnostici: " + e.getMessage());
            return false;
        }
    }

    public static boolean initializeTracciamentoOpenSPCoopAppender(Tracciamento tracciamentoConfig) {
        try {
            if (tracciamentoConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < tracciamentoConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String tracciamentoAppenderClass = prop.getTracciamentoOpenSPCoopAppender(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    if (tracciamentoAppenderClass == null) {
                        throw new CoreException("Riscontrato errore durante il caricamento del tracciamento appender [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    ITracciaProducer appender = null;
                    try {
                        appender = (ITracciaProducer)Loader.getInstance().newInstance(tracciamentoAppenderClass);
                        appender.initializeAppender(tracciamentoConfig.getOpenspcoopAppender(i));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CoreException("Riscontrato errore durante il caricamento del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new CoreException("Riscontrato errore durante l'inizializzazione del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    loggerTracciamentoOpenSPCoopAppender.add(appender);
                    tipoTracciamentoOpenSPCoopAppender.add(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    loggerOpenSPCoopConsole.info("Sistema di logging: TracciamentoOpenSPCoopAppender di tipo [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato.");
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerTracciamentoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error("Riscontrato errore durante l'inizializzazione degli appender personalizzati per il tracciamento: " + e.getMessage());
            return false;
        }
    }

    public static boolean initializeDumpOpenSPCoopAppender(Dump dumpConfig) {
        try {
            if (dumpConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < dumpConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String dumpAppenderClass = prop.getDumpOpenSPCoopAppender(dumpConfig.getOpenspcoopAppender(i).getTipo());
                    if (dumpAppenderClass == null) {
                        throw new CoreException("Riscontrato errore durante il caricamento del dump appender [" + dumpConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    IDumpProducer appender = null;
                    try {
                        appender = (IDumpProducer)Loader.getInstance().newInstance(dumpAppenderClass);
                        appender.initializeAppender(dumpConfig.getOpenspcoopAppender(i));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CoreException("Riscontrato errore durante il caricamento del dump appender specificato [" + dumpConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new CoreException("Riscontrato errore durante l'inizializzazione del dump appender specificato [" + dumpConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    loggerDumpOpenSPCoopAppender.add(appender);
                    tipoDumpOpenSPCoopAppender.add(dumpConfig.getOpenspcoopAppender(i).getTipo());
                    loggerOpenSPCoopConsole.info("Sistema di logging: DumpOpenSPCoopAppender di tipo [" + dumpConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato.");
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerDumpOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error("Riscontrato errore durante l'inizializzazione degli appender personalizzati per il dump applicativo: " + e.getMessage());
            return false;
        }
    }

    public static String humanReadable(MsgDiagnostico msgDiag, IProtocolFactory<?> protocolFactory) {
        return OpenSPCoop2Logger.humanReadable(msgDiag, null, null, null, false, null, null, null, protocolFactory);
    }

    public static String humanReadable(MsgDiagnostico msgDiag, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String porta, boolean delegata, IDSoggetto fruitore, IDServizio servizio, String servizioApplicativo, IProtocolFactory<?> protocolFactory) {
        Map<String, String> contextSerializerParameters;
        String protocol = null;
        if (protocolFactory != null) {
            protocol = protocolFactory.getProtocol();
        }
        boolean formatValues = false;
        if (protocol != null) {
            formatValues = OpenSPCoop2Properties.getInstance().isRegistrazioneDiagnosticaFile_intestazione_formatValues();
        }
        Date gdo = msgDiag.getGdo();
        Object idPorta = msgDiag.getIdSoggetto().getCodicePorta() + "." + msgDiag.getIdSoggetto().toString();
        if (formatValues) {
            try {
                idPorta = NamingUtils.getLabelSoggetto((String)protocol, (IDSoggetto)msgDiag.getIdSoggetto());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String idFunzione = msgDiag.getIdFunzione();
        int valueLivello = msgDiag.getSeverita();
        String text = msgDiag.getMessaggio();
        String idBusta = msgDiag.getIdBusta();
        String codiceDiagnostico = msgDiag.getCodice();
        StringBuilder showMsg = new StringBuilder();
        if (protocol != null) {
            String labelP = protocol;
            if (formatValues) {
                try {
                    labelP = NamingUtils.getLabelProtocollo((String)protocol);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            showMsg.append("<").append(labelP).append(">");
        }
        if (msgDiag.getIdTransazione() != null) {
            if (showMsg.length() > 0) {
                showMsg.append(" ");
            }
            showMsg.append(msgDiag.getIdTransazione());
        }
        if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getLoggerKeywords()) != null && contextSerializerParameters.size() > 0) {
            for (String keyword : contextSerializerParameters.keySet()) {
                if (msgDiag.getPropertiesNames() == null) continue;
                String[] propertyNames = msgDiag.getPropertiesNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (!keyword.equals(propertyNames[i])) continue;
                    if (showMsg.length() > 0) {
                        showMsg.append(" ");
                    }
                    showMsg.append(propertyNames[i] + ":");
                    showMsg.append(msgDiag.getProperty(propertyNames[i]));
                }
            }
        }
        if (codiceDiagnostico != null) {
            if (showMsg.length() > 0) {
                showMsg.append(" ");
            }
            showMsg.append(codiceDiagnostico);
            showMsg.append(" ");
        }
        showMsg.append((String)idPorta);
        showMsg.append(" ");
        showMsg.append(idFunzione);
        showMsg.append(" <");
        showMsg.append(DateBuilder.getDate_Format((Date)gdo));
        showMsg.append("> ");
        showMsg.append("(");
        showMsg.append(LogLevels.toLog4J(valueLivello).toString());
        showMsg.append(")");
        if (idBusta != null) {
            showMsg.append(" ID:");
            showMsg.append(idBusta);
        }
        if (idCorrelazioneApplicativa != null) {
            showMsg.append(" IDApplicativo:");
            showMsg.append(idCorrelazioneApplicativa);
        }
        if (idCorrelazioneApplicativaRisposta != null) {
            showMsg.append(" IDApplicativoRisposta:");
            showMsg.append(idCorrelazioneApplicativaRisposta);
        }
        if (porta != null && !"".equals(porta)) {
            String labelPorta = porta;
            if (delegata) {
                showMsg.append(" OUT:" + labelPorta);
            } else {
                showMsg.append(" IN:" + labelPorta);
            }
        }
        if (servizioApplicativo != null) {
            if (formatValues) {
                if (delegata && !"Anonimo".equals(servizioApplicativo)) {
                    showMsg.append(" Applicativo:" + servizioApplicativo);
                }
            } else {
                showMsg.append(" SA:" + servizioApplicativo);
            }
        }
        if (fruitore != null && fruitore.getNome() != null) {
            showMsg.append(" FR:");
            String fruitoreLabel = fruitore.toString();
            if (formatValues) {
                try {
                    fruitoreLabel = NamingUtils.getLabelSoggetto((String)protocol, (IDSoggetto)fruitore);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            showMsg.append(fruitoreLabel);
        }
        if (fruitore != null && servizio != null) {
            showMsg.append(" -> ");
        }
        if (servizio != null) {
            if (servizio.getNome() != null) {
                showMsg.append(" S:");
                String servizioLabel = null;
                try {
                    servizioLabel = IDServizioFactory.getInstance().getUriFromIDServizio(servizio);
                }
                catch (Exception e) {
                    servizioLabel = servizio.toString(false);
                }
                if (formatValues) {
                    try {
                        servizioLabel = NamingUtils.getLabelAccordoServizioParteSpecifica((String)protocol, (IDServizio)servizio);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                showMsg.append(servizioLabel);
            } else if (servizio.getSoggettoErogatore() != null) {
                showMsg.append(" ER:");
                String erogatoreLabel = servizio.getSoggettoErogatore().toString();
                if (formatValues) {
                    try {
                        erogatoreLabel = NamingUtils.getLabelSoggetto((String)protocol, (IDSoggetto)servizio.getSoggettoErogatore());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                showMsg.append(erogatoreLabel);
            }
            if (servizio.getAzione() != null) {
                showMsg.append(" A:");
                showMsg.append(servizio.getAzione());
            }
        }
        showMsg.append("\n");
        showMsg.append(text);
        showMsg.append("\n");
        return showMsg.toString();
    }

    public static Logger getLoggerOpenSPCoopConsole() {
        return loggerOpenSPCoopConsole;
    }

    public static Logger getLoggerOpenSPCoopCore() {
        return loggerOpenSPCoopCore;
    }

    public static Logger getLoggerOpenSPCoopTimers() {
        return loggerOpenSPCoopTimers;
    }

    public static Logger getLoggerOpenSPCoopResources() {
        return loggerOpenSPCoopResources;
    }

    public static Logger getLoggerOpenSPCoopConfigurazioneSistema() {
        return loggerOpenSPCoopConfigurazioneSistema;
    }

    public static Logger getLoggerOpenSPCoopProxy() {
        return loggerOpenSPCoopProxy;
    }

    public static Logger getLoggerOpenSPCoopConnettori() {
        return loggerOpenSPCoopConnettori;
    }

    public static Logger getLoggerOpenSPCoopDumpBinarioPD() {
        return loggerOpenSPCoopDumpBinarioPD;
    }

    public static Logger getLoggerOpenSPCoopDumpBinarioPA() {
        return loggerOpenSPCoopDumpBinarioPA;
    }

    public static Logger getLoggerOpenSPCoopTransazioni(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopTransazioni;
        }
        return loggerOpenSPCoopTransazioniError;
    }

    public static Logger getLoggerOpenSPCoopTransazioniDevNull() {
        return loggerOpenSPCoopTransazioniDevNull;
    }

    public static Logger getLoggerOpenSPCoopTransazioniSql(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopTransazioniSql;
        }
        return loggerOpenSPCoopTransazioniSqlError;
    }

    public static Logger getLoggerOpenSPCoopTransazioniStateful(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopTransazioniStateful;
        }
        return loggerOpenSPCoopTransazioniStatefulError;
    }

    public static Logger getLoggerOpenSPCoopTransazioniStatefulSql(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopTransazioniStatefulSql;
        }
        return loggerOpenSPCoopTransazioniStatefulSqlError;
    }

    public static Logger getLoggerOpenSPCoopTransazioniSlowLog() {
        return loggerOpenSPCoopTransazioniSlowLog;
    }

    public static Logger getLoggerOpenSPCoopEventi(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopEventi;
        }
        return loggerOpenSPCoopEventiError;
    }

    public static Logger getLoggerOpenSPCoopFileSystemRecovery(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopFileSystemRecovery;
        }
        return loggerOpenSPCoopFileSystemRecoveryError;
    }

    public static Logger getLoggerOpenSPCoopFileSystemRecoverySql(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopFileSystemRecoverySql;
        }
        return loggerOpenSPCoopFileSystemRecoverySqlError;
    }

    public static Logger getLoggerOpenSPCoopControlloTraffico(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopControlloTraffico;
        }
        return loggerOpenSPCoopControlloTrafficoError;
    }

    public static Logger getLoggerOpenSPCoopControlloTrafficoSql(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopControlloTrafficoSql;
        }
        return loggerOpenSPCoopControlloTrafficoSqlError;
    }

    public static Logger getLoggerOpenSPCoopAllarmi(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopAllarmi;
        }
        return loggerOpenSPCoopAllarmiError;
    }

    public static Logger getLoggerOpenSPCoopAllarmiSql(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopAllarmiSql;
        }
        return loggerOpenSPCoopAllarmiSqlError;
    }

    public static Logger getLoggerOpenSPCoopStatistiche(TipoIntervalloStatistico tipoStatistica, boolean debug) {
        if (debug) {
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    return loggerOpenSPCoopStatisticheOrarie;
                }
                case STATISTICHE_GIORNALIERE: {
                    return loggerOpenSPCoopStatisticheGiornaliere;
                }
                case STATISTICHE_SETTIMANALI: {
                    return loggerOpenSPCoopStatisticheSettimanali;
                }
                case STATISTICHE_MENSILI: {
                    return loggerOpenSPCoopStatisticheMensili;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndGenerazione;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndPubblicazione;
                }
            }
        } else {
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    return loggerOpenSPCoopStatisticheOrarieError;
                }
                case STATISTICHE_GIORNALIERE: {
                    return loggerOpenSPCoopStatisticheGiornaliereError;
                }
                case STATISTICHE_SETTIMANALI: {
                    return loggerOpenSPCoopStatisticheSettimanaliError;
                }
                case STATISTICHE_MENSILI: {
                    return loggerOpenSPCoopStatisticheMensiliError;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndGenerazioneError;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndPubblicazioneError;
                }
            }
        }
        return null;
    }

    public static Logger getLoggerOpenSPCoopStatisticheSql(TipoIntervalloStatistico tipoStatistica, boolean debug) {
        if (debug) {
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    return loggerOpenSPCoopStatisticheOrarieSql;
                }
                case STATISTICHE_GIORNALIERE: {
                    return loggerOpenSPCoopStatisticheGiornaliereSql;
                }
                case STATISTICHE_SETTIMANALI: {
                    return loggerOpenSPCoopStatisticheSettimanaliSql;
                }
                case STATISTICHE_MENSILI: {
                    return loggerOpenSPCoopStatisticheMensiliSql;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndGenerazioneSql;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndPubblicazioneSql;
                }
            }
        } else {
            switch (tipoStatistica) {
                case STATISTICHE_ORARIE: {
                    return loggerOpenSPCoopStatisticheOrarieSqlError;
                }
                case STATISTICHE_GIORNALIERE: {
                    return loggerOpenSPCoopStatisticheGiornaliereSqlError;
                }
                case STATISTICHE_SETTIMANALI: {
                    return loggerOpenSPCoopStatisticheSettimanaliSqlError;
                }
                case STATISTICHE_MENSILI: {
                    return loggerOpenSPCoopStatisticheMensiliSqlError;
                }
                case PDND_GENERAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndGenerazioneSqlError;
                }
                case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                    return loggerOpenSPCoopStatistichePdndPubblicazioneSqlError;
                }
            }
        }
        return null;
    }

    public static Logger getLoggerOpenSPCoopConsegnaContenuti(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopConsegnaContenuti;
        }
        return loggerOpenSPCoopConsegnaContenutiError;
    }

    public static Logger getLoggerOpenSPCoopConsegnaContenutiSql(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopConsegnaContenutiSql;
        }
        return loggerOpenSPCoopConsegnaContenutiSqlError;
    }

    public static Logger getLoggerOpenSPCoopPlugins(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopPlugins;
        }
        return loggerOpenSPCoopPluginsError;
    }

    public static Logger getLoggerOpenSPCoopPluginsSql(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopPluginsSql;
        }
        return loggerOpenSPCoopPluginsSqlError;
    }

    public static Logger getLoggerOpenSPCoopGestoreChiaviPDND(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopGestoreChiaviPDND;
        }
        return loggerOpenSPCoopGestoreChiaviPDNDError;
    }

    public static Logger getLoggerOpenSPCoopGestoreOperazioniRemote(boolean debug) {
        if (debug) {
            return loggerOpenSPCoopGestoreOperazioniRemote;
        }
        return loggerOpenSPCoopGestoreOperazioniRemoteError;
    }

    public static List<IDiagnosticProducer> getLoggerMsgDiagnosticoOpenSPCoopAppender() {
        return loggerMsgDiagnosticoOpenSPCoopAppender;
    }

    public static List<String> getTipoMsgDiagnosticoOpenSPCoopAppender() {
        return tipoMsgDiagnosticoOpenSPCoopAppender;
    }

    public static List<ITracciaProducer> getLoggerTracciamentoOpenSPCoopAppender() {
        return loggerTracciamentoOpenSPCoopAppender;
    }

    public static List<String> getTipoTracciamentoOpenSPCoopAppender() {
        return tipoTracciamentoOpenSPCoopAppender;
    }
}

