/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.filetrace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.filetrace.FileTraceEncryptConfig;
import org.openspcoop2.pdd.logger.filetrace.LogSeverity;
import org.openspcoop2.pdd.logger.filetrace.Topic;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class FileTraceConfig {
    private static HashMap<String, FileTraceConfig> staticInstanceMap = new HashMap();
    private static final Semaphore semaphore = new Semaphore("FileTraceConfig");
    private boolean globale = true;
    private LogSeverity logSeverity = LogSeverity.info;
    private Map<String, String> escape = new HashMap<String, String>();
    private String headersSeparator = ",";
    private String headerSeparator = "=";
    private String headerPrefix = "";
    private String headerSuffix = "";
    private List<String> headerBlackList;
    private List<String> headerWhiteList;
    private String headerMultiValueSeparator = ",";
    private List<String> propertiesSortKeys = new ArrayList<String>();
    private Map<String, String> propertiesNames = new HashMap<String, String>();
    private Map<String, String> propertiesValues = new HashMap<String, String>();
    private Map<String, String> propertiesEncryptionMode = new HashMap<String, String>();
    private Map<String, FileTraceEncryptConfig> encryptionMode = new HashMap<String, FileTraceEncryptConfig>();
    private List<String> topicErogazioni = new ArrayList<String>();
    private Map<String, Topic> topicErogazioniMap = new HashMap<String, Topic>();
    private List<String> topicFruizioni = new ArrayList<String>();
    private Map<String, Topic> topicFruizioneMap = new HashMap<String, Topic>();
    private static boolean escapeInFile = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(InputStream is, String fileNamePath, boolean globale) throws CoreException {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("init_InputStream");
        try {
            if (!staticInstanceMap.containsKey(fileNamePath)) {
                FileTraceConfig instance = new FileTraceConfig(is, globale);
                staticInstanceMap.put(fileNamePath, instance);
            }
        }
        finally {
            semaphore.release(lock, "init_InputStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File file, boolean globale) throws CoreException {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("init_File");
        try {
            if (!staticInstanceMap.containsKey(file.getAbsolutePath())) {
                FileTraceConfig instance = new FileTraceConfig(file, globale);
                staticInstanceMap.put(file.getAbsolutePath(), instance);
            }
        }
        finally {
            semaphore.release(lock, "init_File");
        }
    }

    public static void update(File file, boolean globale) throws CoreException {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("update");
        try {
            FileTraceConfig.updateWithoutSynchronizedEngine(file, globale);
        }
        finally {
            semaphore.release(lock, "update_File");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetFileTraceAssociatePorte() {
        SemaphoreLock lock = semaphore.acquireThrowRuntime("resetFileTraceAssociatePorte");
        try {
            if (!staticInstanceMap.isEmpty()) {
                ArrayList<String> removeEntries = new ArrayList<String>();
                for (Map.Entry<String, FileTraceConfig> entry : staticInstanceMap.entrySet()) {
                    String path = entry.getKey();
                    FileTraceConfig config = staticInstanceMap.get(path);
                    if (config.isGlobale()) continue;
                    removeEntries.add(path);
                }
                while (!removeEntries.isEmpty()) {
                    String path = (String)removeEntries.remove(0);
                    staticInstanceMap.remove(path);
                }
            }
        }
        finally {
            semaphore.release(lock, "resetFileTraceAssociatePorte");
        }
    }

    private static void updateWithoutSynchronizedEngine(File file, boolean globale) throws CoreException {
        FileTraceConfig newConfig;
        FileTraceConfig instance = newConfig = new FileTraceConfig(file, globale);
        staticInstanceMap.remove(file.getAbsolutePath());
        staticInstanceMap.put(file.getAbsolutePath(), instance);
    }

    public static FileTraceConfig getConfig(File file, boolean globale) throws CoreException {
        if (!staticInstanceMap.containsKey(file.getAbsolutePath())) {
            FileTraceConfig.init(file, globale);
        }
        return staticInstanceMap.get(file.getAbsolutePath());
    }

    public FileTraceConfig(File file, boolean globale) throws CoreException {
        try (FileInputStream fin = new FileInputStream(file);){
            this.initEngine(fin, globale);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public FileTraceConfig(InputStream is, boolean globale) throws CoreException {
        this.initEngine(is, globale);
    }

    public static boolean isEscapeInFile() {
        return escapeInFile;
    }

    public static void setEscapeInFile(boolean escapeInFile) {
        FileTraceConfig.escapeInFile = escapeInFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEngine(InputStream is, boolean globale) throws CoreException {
        try {
            this.globale = globale;
            Properties p = new Properties();
            if (escapeInFile) {
                p.load(is);
            } else {
                this.fillProperties(p, is);
                File fTmp = FileSystemUtilities.createTempFile((String)"test", (String)".properties");
                try {
                    try (FileOutputStream fout = new FileOutputStream(fTmp);){
                        p.store(fout, "test");
                    }
                    try (FileInputStream finNewP = new FileInputStream(fTmp);){
                        p = new Properties();
                        p.load(finNewP);
                    }
                }
                finally {
                    FileSystemUtilities.deleteFile((File)fTmp);
                }
            }
            PropertiesReader reader = new PropertiesReader(p, true);
            String tmp = this.getProperty(reader, "log.severity", false);
            if (tmp != null) {
                this.logSeverity = LogSeverity.valueOf(tmp);
            }
            InputStream isLog = this.getInputStreamLogFile(reader);
            Properties pLog = new Properties();
            pLog.load(isLog);
            LoggerWrapperFactory.setLogConfiguration((Properties)pLog, (boolean)true);
            boolean erogazioni = true;
            this.registerTopic(reader, erogazioni);
            this.registerTopic(reader, !erogazioni);
            this.encryptionMode = FileTraceEncryptConfig.parse(reader);
            this.readFormatProperties(reader);
        }
        catch (Exception t) {
            throw new CoreException(t.getMessage(), (Throwable)t);
        }
    }

    private void fillProperties(Properties p, InputStream is) {
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.startsWith("#") || StringUtils.isEmpty((CharSequence)line) || line.endsWith("=") && line.length() == 1 || line.indexOf("=") <= 0) continue;
            String key = null;
            String value = "";
            if (line.endsWith("=")) {
                key = line.substring(0, line.length() - 1);
            } else {
                int indexOf = line.indexOf("=");
                key = line.substring(0, indexOf);
                value = line.substring(indexOf + 1, line.length());
            }
            p.put(key, value);
        }
        scanner.close();
    }

    private InputStream getInputStreamLogFile(PropertiesReader reader) throws UtilsException, FileNotFoundException {
        String tmp = this.getProperty(reader, "log.config.file", true);
        File fTmp = new File(tmp);
        if (fTmp.exists()) {
            return new FileInputStream(fTmp);
        }
        InputStream isTmp = FileTraceConfig.class.getResourceAsStream(tmp);
        if (isTmp != null) {
            return isTmp;
        }
        if (!tmp.startsWith("/") && (isTmp = FileTraceConfig.class.getResourceAsStream("/" + tmp)) != null) {
            return isTmp;
        }
        fTmp = new File(OpenSPCoop2Properties.getInstance().getRootDirectory(), tmp);
        if (fTmp.exists()) {
            return new FileInputStream(fTmp);
        }
        throw new UtilsException("File '" + tmp + "' not found");
    }

    private void registerTopic(PropertiesReader reader, boolean erogazioni) throws UtilsException {
        String tipo = erogazioni ? "erogazioni" : "fruizioni";
        String propertyName = "topic." + tipo;
        String tmp = this.getProperty(reader, propertyName, false);
        if (tmp != null && !StringUtils.isEmpty((CharSequence)tmp)) {
            List<String> list = erogazioni ? this.topicErogazioni : this.topicFruizioni;
            Map<String, Topic> map = erogazioni ? this.topicErogazioniMap : this.topicFruizioneMap;
            String[] split = tmp.split(",");
            if (split != null && split.length > 0) {
                for (int i = 0; i < split.length; ++i) {
                    String propertyNameTrackingPhases;
                    List<String> trackingPhases;
                    String propertyNameOutResponseContentDefined;
                    String tmpOutResponseContentDefined;
                    String propertyNameInResponseContentDefined;
                    String tmpInResponseContentDefined;
                    String propertyNameOutRequestContentDefined;
                    String tmpOutRequestContentDefined;
                    String nome = split[i].trim();
                    if (list.contains(nome)) {
                        throw new UtilsException("Found duplicate topic '" + nome + "' (" + tipo + ")");
                    }
                    list.add(nome);
                    Topic topic = new Topic();
                    topic.setErogazioni(erogazioni);
                    topic.setNome(nome);
                    String propertyNameOnlyRequestSent = propertyName + "." + nome + ".requestSent";
                    String tmpOnlyRequestSent = this.getProperty(reader, propertyNameOnlyRequestSent, false);
                    if (tmpOnlyRequestSent != null) {
                        topic.setOnlyRequestSent(Boolean.valueOf(tmpOnlyRequestSent));
                    } else {
                        propertyNameOnlyRequestSent = propertyName + "." + nome + ".requestSended";
                        tmpOnlyRequestSent = this.getProperty(reader, propertyNameOnlyRequestSent, false);
                        if (tmpOnlyRequestSent != null) {
                            topic.setOnlyRequestSent(Boolean.valueOf(tmpOnlyRequestSent));
                        }
                    }
                    String propertyNameInRequestContentDefined = propertyName + "." + nome + ".inRequestContentDefined";
                    String tmpInRequestContentDefined = this.getProperty(reader, propertyNameInRequestContentDefined, false);
                    if (tmpInRequestContentDefined != null) {
                        topic.setOnlyInRequestContentDefined(Boolean.valueOf(tmpInRequestContentDefined));
                    }
                    if ((tmpOutRequestContentDefined = this.getProperty(reader, propertyNameOutRequestContentDefined = propertyName + "." + nome + ".outRequestContentDefined", false)) != null) {
                        topic.setOnlyOutRequestContentDefined(Boolean.valueOf(tmpOutRequestContentDefined));
                    }
                    if ((tmpInResponseContentDefined = this.getProperty(reader, propertyNameInResponseContentDefined = propertyName + "." + nome + ".inResponseContentDefined", false)) != null) {
                        topic.setOnlyInResponseContentDefined(Boolean.valueOf(tmpInResponseContentDefined));
                    }
                    if ((tmpOutResponseContentDefined = this.getProperty(reader, propertyNameOutResponseContentDefined = propertyName + "." + nome + ".outResponseContentDefined", false)) != null) {
                        topic.setOnlyOutResponseContentDefined(Boolean.valueOf(tmpOutResponseContentDefined));
                    }
                    if ((trackingPhases = this.getList(reader, propertyNameTrackingPhases = propertyName + "." + nome + ".trackingPhases")) != null && !trackingPhases.isEmpty()) {
                        for (String phase : trackingPhases) {
                            if ("inRequest".equalsIgnoreCase(phase) || "in-request".equalsIgnoreCase(phase) || "requestIn".equalsIgnoreCase(phase) || "request-in".equalsIgnoreCase(phase)) {
                                topic.addFaseTracciamento(FaseTracciamento.IN_REQUEST);
                                continue;
                            }
                            if ("outRequest".equalsIgnoreCase(phase) || "out-request".equalsIgnoreCase(phase) || "requestOut".equalsIgnoreCase(phase) || "request-out".equalsIgnoreCase(phase)) {
                                topic.addFaseTracciamento(FaseTracciamento.OUT_REQUEST);
                                continue;
                            }
                            if ("outResponse".equalsIgnoreCase(phase) || "out-response".equalsIgnoreCase(phase) || "responseOut".equalsIgnoreCase(phase) || "response-out".equalsIgnoreCase(phase)) {
                                topic.addFaseTracciamento(FaseTracciamento.OUT_RESPONSE);
                                continue;
                            }
                            if ("postOutResponse".equalsIgnoreCase(phase) || "post-out-response".equalsIgnoreCase(phase) || "postResponseOut".equalsIgnoreCase(phase) || "post-response-out".equalsIgnoreCase(phase)) {
                                topic.addFaseTracciamento(FaseTracciamento.POST_OUT_RESPONSE);
                                topic.addFaseTracciamento(FaseTracciamento.POST_OUT_RESPONSE);
                                continue;
                            }
                            throw new UtilsException("Found unknown tracking phase '" + phase + "' in property '" + propertyNameTrackingPhases + "'");
                        }
                    }
                    String propertyNameCategory = "category.topic." + tipo + "." + nome;
                    String category = this.getProperty(reader, propertyNameCategory, true);
                    topic.setCategoryName(category);
                    topic.setLog(LoggerWrapperFactory.getLogger((String)category));
                    String propertyNameFormat = "format.topic." + tipo + "." + nome;
                    String format = this.getProperty(reader, propertyNameFormat, true);
                    topic.setFormat(format);
                    map.put(nome, topic);
                }
            }
        }
    }

    private List<String> getList(PropertiesReader reader, String propertyName) throws UtilsException {
        String[] split;
        ArrayList<String> list = new ArrayList<String>();
        String tmp = this.getProperty(reader, propertyName, false);
        if (tmp != null && !StringUtils.isEmpty((CharSequence)tmp) && (split = tmp.split(",")) != null && split.length > 0) {
            for (int i = 0; i < split.length; ++i) {
                String nome = split[i].trim();
                if (list.contains(nome)) {
                    throw new UtilsException("Found duplicate topic '" + nome + "' in property '" + propertyName + "'");
                }
                list.add(nome);
            }
        }
        return list;
    }

    private void readFormatProperties(PropertiesReader reader) throws UtilsException {
        String[] split;
        Properties escapeMap = reader.readProperties("format.escape.");
        if (escapeMap != null && !escapeMap.isEmpty()) {
            for (Object s : escapeMap.keySet()) {
                String key = (String)s;
                this.escape.put(key, escapeMap.getProperty(key));
            }
        }
        ArrayList<String> listPosition = new ArrayList<String>();
        ArrayList<String> listPnames = new ArrayList<String>();
        String prefixProperty = "format.property.";
        Properties propertiesMap = reader.readProperties(prefixProperty);
        this.parseProperties(propertiesMap, prefixProperty, listPosition, listPnames, false, reader);
        String prefixEncryptedProperty = "format.encryptedProperty.";
        propertiesMap = reader.readProperties(prefixEncryptedProperty);
        this.parseProperties(propertiesMap, prefixEncryptedProperty, listPosition, listPnames, true, reader);
        Collections.sort(listPosition);
        this.propertiesSortKeys = listPosition;
        String tmp = this.getProperty(reader, "format.headers.separator", false);
        if (tmp != null) {
            this.headersSeparator = tmp;
        }
        if ((tmp = this.getProperty(reader, "format.headers.header.separator", false)) != null) {
            this.headerSeparator = tmp;
        }
        if ((tmp = this.getProperty(reader, "format.headers.header.prefix", false)) != null) {
            this.headerPrefix = tmp;
        }
        if ((tmp = this.getProperty(reader, "format.headers.header.suffix", false)) != null) {
            this.headerSuffix = tmp;
        }
        if ((tmp = this.getProperty(reader, "format.header.multiValueSeparator", false)) != null) {
            this.headerMultiValueSeparator = tmp;
        }
        if ((tmp = this.getProperty(reader, "format.header.whiteList", false)) != null && !"".equals(tmp.trim())) {
            tmp = tmp.trim();
            this.headerWhiteList = new ArrayList<String>();
            if (tmp.contains(",")) {
                split = tmp.split(",");
                if (split != null && split.length > 0) {
                    for (String s : split) {
                        if (s == null || "".equals(s = s.trim())) continue;
                        this.headerWhiteList.add(s);
                    }
                }
            } else {
                this.headerWhiteList.add(tmp);
            }
        }
        if ((tmp = this.getProperty(reader, "format.header.blackList", false)) != null && !"".equals(tmp.trim())) {
            tmp = tmp.trim();
            this.headerBlackList = new ArrayList<String>();
            if (tmp.contains(",")) {
                split = tmp.split(",");
                if (split != null && split.length > 0) {
                    for (String s : split) {
                        if (s == null || "".equals(s = s.trim())) continue;
                        this.headerBlackList.add(s);
                    }
                }
            } else {
                this.headerBlackList.add(tmp);
            }
        }
    }

    private void parseProperties(Properties propertiesMap, String prefix, List<String> listPosition, List<String> listPnames, boolean encrypted, PropertiesReader reader) throws UtilsException {
        if (propertiesMap != null && !propertiesMap.isEmpty()) {
            for (Object s : propertiesMap.keySet()) {
                String key = (String)s;
                this.parseProperty(key, propertiesMap, prefix, listPosition, listPnames, encrypted, reader);
            }
        }
    }

    private void parseProperty(String key, Properties propertiesMap, String prefix, List<String> listPosition, List<String> listPnames, boolean encrypted, PropertiesReader reader) throws UtilsException {
        if (!key.contains(".") || key.length() < 3 || key.startsWith(".") || key.endsWith(".")) {
            throw new UtilsException("Format property '" + prefix + key + "' wrong (expected: " + prefix + "<intPosition>.<nomeProperty>)");
        }
        String prefixBad = "Bad property '" + prefix + key + "'";
        int indexOf = key.indexOf(".");
        String pos = key.substring(0, indexOf);
        String nomeP = key.substring(indexOf + 1, key.length());
        String posPadded = StringUtils.leftPad((String)pos, (int)10, (String)"0");
        if (listPosition.contains(posPadded)) {
            throw new UtilsException(prefixBad + ": contains duplicate position '" + pos + "'");
        }
        if (listPnames.contains(nomeP)) {
            throw new UtilsException(prefixBad + ". contains duplicate name '" + nomeP + "'");
        }
        listPosition.add(posPadded);
        this.propertiesNames.put(posPadded, nomeP);
        this.propertiesValues.put(posPadded, propertiesMap.getProperty(key));
        if (encrypted) {
            this.parseEncryptedProperty(reader, key, prefixBad, posPadded);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseEncryptedProperty(PropertiesReader reader, String key, String prefixBad, String posPadded) throws UtilsException {
        String modeP = "format.encrypt." + key;
        String mode = reader.getValue_convertEnvProperties(modeP);
        if (this.encryptionMode == null || this.encryptionMode.isEmpty()) {
            throw new UtilsException(prefixBad + ": no encryption mode defined");
        }
        if (mode == null || StringUtils.isEmpty((CharSequence)mode.trim())) {
            if (this.encryptionMode.size() != 1) throw new UtilsException(prefixBad + ": undefined property '" + modeP + "'");
            this.propertiesEncryptionMode.put(posPadded, this.encryptionMode.keySet().iterator().next());
            return;
        } else {
            if (!this.encryptionMode.containsKey(mode = mode.trim())) {
                throw new UtilsException(prefixBad + ": unknown encryption mode '" + mode + "'");
            }
            this.propertiesEncryptionMode.put(posPadded, mode);
        }
    }

    private String getProperty(PropertiesReader reader, String key, boolean required) throws UtilsException {
        String tmp = reader.getValue(key);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property '" + key + "' not found");
            }
            return null;
        }
        tmp = tmp.trim();
        return tmp;
    }

    public LogSeverity getLogSeverity() {
        return this.logSeverity;
    }

    public Map<String, String> getEscape() {
        return this.escape;
    }

    public String getHeadersSeparator() {
        return this.headersSeparator;
    }

    public String getHeaderSeparator() {
        return this.headerSeparator;
    }

    public String getHeaderPrefix() {
        return this.headerPrefix;
    }

    public String getHeaderSuffix() {
        return this.headerSuffix;
    }

    public List<String> getHeaderBlackList() {
        return this.headerBlackList;
    }

    public List<String> getHeaderWhiteList() {
        return this.headerWhiteList;
    }

    public String getHeaderMultiValueSeparator() {
        return this.headerMultiValueSeparator;
    }

    public List<String> getPropertiesSortKeys() {
        return this.propertiesSortKeys;
    }

    public Map<String, String> getPropertiesNames() {
        return this.propertiesNames;
    }

    public Map<String, String> getPropertiesValues() {
        return this.propertiesValues;
    }

    public Map<String, String> getPropertiesEncryptionMode() {
        return this.propertiesEncryptionMode;
    }

    public Map<String, FileTraceEncryptConfig> getEncryptionMode() {
        return this.encryptionMode;
    }

    public List<String> getTopicErogazioni() {
        return this.topicErogazioni;
    }

    public Map<String, Topic> getTopicErogazioniMap() {
        return this.topicErogazioniMap;
    }

    public List<String> getTopicFruizioni() {
        return this.topicFruizioni;
    }

    public Map<String, Topic> getTopicFruizioneMap() {
        return this.topicFruizioneMap;
    }

    public boolean isGlobale() {
        return this.globale;
    }
}

