/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.filetrace;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.token.InformazioniNegoziazioneToken;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.pdd.logger.filetrace.FileTraceConfig;
import org.openspcoop2.pdd.logger.filetrace.HeaderFormat;
import org.openspcoop2.pdd.logger.filetrace.InfoConfigurazione;
import org.openspcoop2.pdd.logger.filetrace.ResultClass;
import org.openspcoop2.pdd.logger.info.DatiEsitoTransazione;
import org.openspcoop2.pdd.logger.info.DatiMittente;
import org.openspcoop2.pdd.logger.info.InfoEsitoTransazioneFormatUtils;
import org.openspcoop2.pdd.logger.info.InfoMittenteFormatUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.protocol.sdk.PDNDTokenInfoDetails;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.date.DateEngineType;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.xml.XMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class Info {
    private IProtocolFactory<?> protocolFactory;
    private Transazione transazione;
    private EsitiProperties esitiProperties;
    private CredenzialiMittente credenzialiMittente;
    private InformazioniToken informazioniToken;
    private InformazioniAttributi informazioniAttributi;
    private InformazioniNegoziazioneToken informazioniNegoziazioneToken;
    private SecurityToken securityToken;
    private FaseTracciamento trackingPhase;
    private Traccia tracciaRichiesta;
    private Traccia tracciaRisposta;
    private List<MsgDiagnostico> msgDiagnostici;
    private Messaggio richiestaIngresso;
    private List<String> headerRichiestaIngressoConsumati = new ArrayList<String>();
    private Messaggio richiestaUscita;
    private Map<String, List<String>> headerRichiestaUscita;
    private List<String> headerRichiestaUscitaConsumati = new ArrayList<String>();
    private Messaggio rispostaIngresso;
    private List<String> headerRispostaIngressoConsumati = new ArrayList<String>();
    private Messaggio rispostaUscita;
    private Map<String, List<String>> headerRispostaUscita;
    private List<String> headerRispostaUscitaConsumati = new ArrayList<String>();
    private InfoConfigurazione infoConfigurazione;
    private Map<String, String> escape;
    private String headersSeparator;
    private String headerSeparator;
    private String headerPrefix;
    private String headerSuffix;
    private List<String> headerBlackList;
    private List<String> headerWhiteList;
    private String headerMultiValueSeparator;
    private String defaultValue = "";
    private int defaultIntegerValue = 0;
    private long defaultLongValue = 0L;
    private Logger log;
    private volatile boolean base64;
    private Map<String, String> properties = new HashMap<String, String>();
    private static final String CONVERSIONE_ESITO_FALLITA = "Conversione esito fallita: ";
    private IDServizioApplicativo tokenClientApplication;
    private Boolean tokenClientApplicationRead;
    private PDNDTokenInfo pdndTokenOrganizationInfo = null;
    private PDNDTokenInfo pdndTokenClientInfo = null;

    public Info(Logger log, IProtocolFactory<?> protocolFactory, Transazione transazione, CredenzialiMittente credenzialiMittente, InformazioniToken informazioniToken, InformazioniAttributi informazioniAttributi, InformazioniNegoziazioneToken informazioniNegoziazioneToken, SecurityToken securityToken, Traccia tracciaRichiesta, Traccia tracciaRisposta, List<MsgDiagnostico> msgDiagnostici, Messaggio richiestaIngresso, Messaggio richiestaUscita, Map<String, List<String>> headerRichiestaUscita, Messaggio rispostaIngresso, Messaggio rispostaUscita, Map<String, List<String>> headerRispostaUscita, InfoConfigurazione infoConfigurazione, FileTraceConfig config, FaseTracciamento trackingPhase, boolean base64) throws ProtocolException {
        this.log = log;
        this.protocolFactory = protocolFactory;
        this.transazione = transazione;
        this.esitiProperties = EsitiProperties.getInstance((Logger)log, this.protocolFactory);
        this.credenzialiMittente = credenzialiMittente;
        this.informazioniToken = informazioniToken;
        this.informazioniAttributi = informazioniAttributi;
        this.informazioniNegoziazioneToken = informazioniNegoziazioneToken;
        this.securityToken = securityToken;
        this.tracciaRichiesta = tracciaRichiesta;
        this.tracciaRisposta = tracciaRisposta;
        this.msgDiagnostici = msgDiagnostici;
        this.richiestaIngresso = richiestaIngresso;
        this.richiestaUscita = richiestaUscita;
        this.headerRichiestaUscita = headerRichiestaUscita;
        this.rispostaIngresso = rispostaIngresso;
        this.rispostaUscita = rispostaUscita;
        this.headerRispostaUscita = headerRispostaUscita;
        this.infoConfigurazione = infoConfigurazione;
        this.escape = config.getEscape();
        this.headersSeparator = config.getHeadersSeparator();
        this.headerSeparator = config.getHeaderSeparator();
        this.headerPrefix = config.getHeaderPrefix();
        this.headerSuffix = config.getHeaderSuffix();
        this.headerMultiValueSeparator = config.getHeaderMultiValueSeparator();
        this.headerWhiteList = config.getHeaderWhiteList();
        this.headerBlackList = config.getHeaderBlackList();
        this.trackingPhase = trackingPhase;
        this.base64 = base64;
    }

    private String getErrorSuffix(Exception t) {
        return " failed: " + t.getMessage();
    }

    public String getTransactionId() {
        return this.getTransactionId(null);
    }

    public String getTransactionId(String defaultValue) {
        return this.correctValue(this.transazione.getIdTransazione(), defaultValue);
    }

    public String getRequestId() {
        return this.getRequestId(null);
    }

    public String getRequestId(String defaultValue) {
        return this.correctValue(this.transazione.getIdMessaggioRichiesta(), defaultValue);
    }

    public String getResponseId() {
        return this.getResponseId(null);
    }

    public String getResponseId(String defaultValue) {
        return this.correctValue(this.transazione.getIdMessaggioRisposta(), defaultValue);
    }

    public String getCorrelationId() {
        return this.getCorrelationId(null);
    }

    public String getCorrelationId(String defaultValue) {
        return this.correctValue(this.transazione.getIdCollaborazione(), defaultValue);
    }

    public String getAsyncId() {
        return this.getAsyncId(null);
    }

    public String getAsyncId(String defaultValue) {
        return this.correctValue(this.transazione.getIdAsincrono(), defaultValue);
    }

    public String getRequestApplicationId() {
        return this.getRequestApplicationId(null);
    }

    public String getRequestApplicationId(String defaultValue) {
        return this.correctValue(this.transazione.getIdCorrelazioneApplicativa(), defaultValue);
    }

    public String getResponseApplicationId() {
        return this.getResponseApplicationId(null);
    }

    public String getResponseApplicationId(String defaultValue) {
        return this.correctValue(this.transazione.getIdCorrelazioneApplicativaRisposta(), defaultValue);
    }

    public String getApplicationId() {
        return this.getApplicationId(null);
    }

    public String getApplicationId(String defaultValue) {
        Object s = null;
        if (this.transazione.getIdCorrelazioneApplicativa() != null) {
            s = this.transazione.getIdCorrelazioneApplicativa();
        }
        if (this.transazione.getIdCorrelazioneApplicativaRisposta() != null) {
            s = s == null ? this.transazione.getIdCorrelazioneApplicativaRisposta() : (String)s + this.transazione.getIdCorrelazioneApplicativaRisposta();
        }
        return this.correctValue((String)s, defaultValue);
    }

    public String getClusterId() {
        return this.getClusterId(null);
    }

    public String getClusterId(String defaultValue) {
        return this.correctValue(this.transazione.getClusterId(), defaultValue);
    }

    public String getResultClass() {
        return this.getResultClass(null);
    }

    public String getResultClass(String defaultValue) {
        try {
            if (InfoEsitoTransazioneFormatUtils.isEsitoOk(this.log, (Integer)this.transazione.getEsito(), this.esitiProperties)) {
                return this.correctValue(ResultClass.OK.name(), defaultValue);
            }
            if (InfoEsitoTransazioneFormatUtils.isEsitoFaultApplicativo(this.log, (Integer)this.transazione.getEsito(), this.esitiProperties)) {
                return this.correctValue(ResultClass.FAULT.name(), defaultValue);
            }
            if (InfoEsitoTransazioneFormatUtils.isEsitoKo(this.log, (Integer)this.transazione.getEsito(), this.esitiProperties)) {
                return this.correctValue(ResultClass.KO.name(), defaultValue);
            }
            return this.correctValue(ResultClass.KO.name(), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public boolean isResultClassOk() {
        try {
            return InfoEsitoTransazioneFormatUtils.isEsitoOk(this.log, (Integer)this.transazione.getEsito(), this.esitiProperties);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isResultClassFault() {
        try {
            return InfoEsitoTransazioneFormatUtils.isEsitoFaultApplicativo(this.log, (Integer)this.transazione.getEsito(), this.esitiProperties);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isResultClassKo() {
        try {
            return InfoEsitoTransazioneFormatUtils.isEsitoKo(this.log, (Integer)this.transazione.getEsito(), this.esitiProperties);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public int getResultAsInt() {
        return this.transazione.getEsito();
    }

    public int getResultCode() {
        return this.getResultAsInt();
    }

    public String getResult() {
        return this.getResult(null);
    }

    public String getResult(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoName(Integer.valueOf(this.transazione.getEsito())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getResultDescription() {
        return this.getResultDescription(null);
    }

    public String getResultDescription(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoDescription(Integer.valueOf(this.transazione.getEsito())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getResultLabel() {
        return this.getResultLabel(null);
    }

    public String getResultLabel(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoLabel(Integer.valueOf(this.transazione.getEsito())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getResultLabelSyntetic() {
        return this.getResultLabelSyntetic(null);
    }

    public String getResultLabelSyntetic(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoLabelSyntetic(Integer.valueOf(this.transazione.getEsito())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public int getSyncResultAsInt() {
        return this.transazione.getEsitoSincrono();
    }

    public String getSyncResult() {
        return this.getSyncResult(null);
    }

    public String getSyncResult(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoName(Integer.valueOf(this.transazione.getEsitoSincrono())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getSyncResultDescription() {
        return this.getSyncResultDescription(null);
    }

    public String getSyncResultDescription(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoDescription(Integer.valueOf(this.transazione.getEsitoSincrono())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getSyncResultLabel() {
        return this.getSyncResultLabel(null);
    }

    public String getSyncResultLabel(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoLabel(Integer.valueOf(this.transazione.getEsitoSincrono())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getSyncResultLabelSyntetic() {
        return this.getSyncResultLabelSyntetic(null);
    }

    public String getSyncResultLabelSyntetic(String defaultValue) {
        try {
            return this.correctValue(this.esitiProperties.getEsitoLabelSyntetic(Integer.valueOf(this.transazione.getEsitoSincrono())), defaultValue);
        }
        catch (Exception e) {
            this.log.error(CONVERSIONE_ESITO_FALLITA + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getTransactionType() {
        return this.getTransactionType(null);
    }

    public String getTransactionType(String defaultValue) {
        return this.correctValue(this.transazione.getEsitoContesto(), defaultValue);
    }

    public String getInHttpStatus() {
        return this.getInHttpStatus(null);
    }

    public String getInHttpStatus(String defaultValue) {
        return this.correctValue(this.transazione.getCodiceRispostaIngresso(), defaultValue);
    }

    public String getInHttpReason() {
        return this.getInHttpReason(null);
    }

    public String getInHttpReason(String defaultValue) {
        String reason = null;
        try {
            String codiceRisposta = this.transazione.getCodiceRispostaIngresso();
            if (codiceRisposta != null && !"".equals(codiceRisposta)) {
                int status = Integer.parseInt(codiceRisposta);
                reason = HttpUtilities.getHttpReason((int)status);
            }
        }
        catch (Exception e) {
            this.log.error("Conversione http reason: " + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
        return this.correctValue(reason, defaultValue);
    }

    public String getOutHttpStatus() {
        return this.getOutHttpStatus(null);
    }

    public String getOutHttpStatus(String defaultValue) {
        return this.correctValue(this.transazione.getCodiceRispostaUscita(), defaultValue);
    }

    public String getOutHttpReason() {
        return this.getOutHttpReason(null);
    }

    public String getOutHttpReason(String defaultValue) {
        String reason = null;
        try {
            String codiceRisposta = this.transazione.getCodiceRispostaUscita();
            if (codiceRisposta != null && !"".equals(codiceRisposta)) {
                int status = Integer.parseInt(codiceRisposta);
                reason = HttpUtilities.getHttpReason((int)status);
            }
        }
        catch (Exception e) {
            this.log.error("Conversione http reason: " + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
        return this.correctValue(reason, defaultValue);
    }

    private DatiEsitoTransazione convertToDatiEsitoTransazioneEngine() {
        boolean oldValueBase64 = this.base64;
        DatiEsitoTransazione datiEsitoTransazione = null;
        try {
            this.base64 = false;
            datiEsitoTransazione = new DatiEsitoTransazione();
            datiEsitoTransazione.setEsito(this.getResultAsInt());
            datiEsitoTransazione.setProtocollo(this.protocolFactory);
            datiEsitoTransazione.setFaultIntegrazione(this.getFaultIntegrazioneEngine(null));
            datiEsitoTransazione.setFormatoFaultIntegrazione(this.getFormatoFaultIntegrazioneEngine(null));
            datiEsitoTransazione.setFaultCooperazione(this.getFaultCooperazioneEngine(null));
            datiEsitoTransazione.setFormatoFaultCooperazione(this.getFormatoFaultCooperazioneEngine(null));
            datiEsitoTransazione.setPddRuolo(this.transazione.getPddRuolo());
        }
        finally {
            this.base64 = oldValueBase64;
        }
        return datiEsitoTransazione;
    }

    public String getErrorDetail() {
        return this.getErrorDetail(null);
    }

    public String getErrorDetail(String defaultValue) {
        DatiEsitoTransazione datiEsitoTransazione = this.convertToDatiEsitoTransazioneEngine();
        String dettaglioErroreResult = InfoEsitoTransazioneFormatUtils.getDettaglioErrore(this.log, datiEsitoTransazione, this.msgDiagnostici);
        return this.correctValue(dettaglioErroreResult, defaultValue);
    }

    public String getDiagnostics() {
        return this.getDiagnosticsEngine(false, "\n", "yyyy-MM-dd_HH:mm:ss.SSSX", null);
    }

    public String getDiagnostics(String separator) {
        return this.getDiagnosticsEngine(false, separator, "yyyy-MM-dd_HH:mm:ss.SSSX", null);
    }

    public String getDiagnostics(String separator, String format) {
        return this.getDiagnosticsEngine(false, separator, format, null);
    }

    public String getDiagnostics(String separator, String format, String timeZone) {
        return this.getDiagnosticsEngine(false, separator, format, timeZone);
    }

    public String getErrorDiagnostics() {
        return this.getDiagnosticsEngine(true, "\n", "yyyy-MM-dd_HH:mm:ss.SSSX", null);
    }

    public String getErrorDiagnostics(String separator) {
        return this.getDiagnosticsEngine(true, separator, "yyyy-MM-dd_HH:mm:ss.SSSX", null);
    }

    public String getErrorDiagnostics(String separator, String format) {
        return this.getDiagnosticsEngine(true, separator, format, null);
    }

    public String getErrorDiagnostics(String separator, String format, String timeZone) {
        return this.getDiagnosticsEngine(true, separator, format, timeZone);
    }

    private String getDiagnosticsEngine(boolean onlyErrors, String separator, String format, String timeZone) {
        StringBuilder sb = new StringBuilder();
        if (this.msgDiagnostici != null && !this.msgDiagnostici.isEmpty()) {
            for (MsgDiagnostico msgDiagnostico : this.msgDiagnostici) {
                if (onlyErrors && msgDiagnostico.getSeverita() > 2) continue;
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                String severitaAsString = LogLevels.toOpenSPCoop2(msgDiagnostico.getSeverita());
                sb.append(severitaAsString);
                sb.append(" ");
                sb.append(this.correctDateWithoutCorrectValue(msgDiagnostico.getGdo(), format, timeZone, null, null));
                sb.append(" ");
                sb.append(msgDiagnostico.getCodice());
                sb.append(" ");
                sb.append(msgDiagnostico.getMessaggio());
            }
        }
        return this.correctValue(sb.toString(), null);
    }

    public String getAcceptedRequestDate() {
        return this.getAcceptedRequestDate("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getAcceptedRequestDate(String format) {
        return this.getAcceptedRequestDate(format, null, null, null);
    }

    public String getAcceptedRequestDate(String format, String defaultValue) {
        return this.getAcceptedRequestDate(format, defaultValue, null, null);
    }

    public String getAcceptedRequestDate(String format, String replace, String with) {
        return this.getAcceptedRequestDate(format, null, replace, with);
    }

    public String getAcceptedRequestDate(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataAccettazioneRichiesta(), format, null, defaultValue, replace, with);
    }

    public String getAcceptedRequestDateZ(String format, String timeZone) {
        return this.getAcceptedRequestDateZ(format, timeZone, null, null, null);
    }

    public String getAcceptedRequestDateZ(String format, String timeZone, String defaultValue) {
        return this.getAcceptedRequestDateZ(format, timeZone, defaultValue, null, null);
    }

    public String getAcceptedRequestDateZ(String format, String timeZone, String replace, String with) {
        return this.getAcceptedRequestDateZ(format, timeZone, null, replace, with);
    }

    public String getAcceptedRequestDateZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataAccettazioneRichiesta(), format, timeZone, defaultValue, replace, with);
    }

    public String getInRequestDate() {
        return this.getInRequestDate("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getInRequestDate(String format) {
        return this.getInRequestDate(format, null, null, null);
    }

    public String getInRequestDate(String format, String defaultValue) {
        return this.getInRequestDate(format, defaultValue, null, null);
    }

    public String getInRequestDate(String format, String replace, String with) {
        return this.getInRequestDate(format, null, replace, with);
    }

    public String getInRequestDate(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRichiesta(), format, null, defaultValue, replace, with);
    }

    public String getInRequestDateZ(String format, String timeZone) {
        return this.getInRequestDateZ(format, timeZone, null, null, null);
    }

    public String getInRequestDateZ(String format, String timeZone, String defaultValue) {
        return this.getInRequestDateZ(format, timeZone, defaultValue, null, null);
    }

    public String getInRequestDateZ(String format, String timeZone, String replace, String with) {
        return this.getInRequestDateZ(format, timeZone, null, replace, with);
    }

    public String getInRequestDateZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRichiesta(), format, timeZone, defaultValue, replace, with);
    }

    public String getInRequestStartTime() {
        return this.getInRequestStartTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getInRequestStartTime(String format) {
        return this.getInRequestStartTime(format, null, null, null);
    }

    public String getInRequestStartTime(String format, String defaultValue) {
        return this.getInRequestStartTime(format, defaultValue, null, null);
    }

    public String getInRequestStartTime(String format, String replace, String with) {
        return this.getInRequestStartTime(format, null, replace, with);
    }

    public String getInRequestStartTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRichiesta(), format, null, defaultValue, replace, with);
    }

    public String getInRequestStartTimeZ(String format, String timeZone) {
        return this.getInRequestStartTimeZ(format, timeZone, null, null, null);
    }

    public String getInRequestStartTimeZ(String format, String timeZone, String defaultValue) {
        return this.getInRequestStartTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getInRequestStartTimeZ(String format, String timeZone, String replace, String with) {
        return this.getInRequestStartTimeZ(format, timeZone, null, replace, with);
    }

    public String getInRequestStartTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRichiesta(), format, timeZone, defaultValue, replace, with);
    }

    public String getInRequestEndTime() {
        return this.getInRequestEndTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getInRequestEndTime(String format) {
        return this.getInRequestEndTime(format, null, null, null);
    }

    public String getInRequestEndTime(String format, String defaultValue) {
        return this.getInRequestEndTime(format, defaultValue, null, null);
    }

    public String getInRequestEndTime(String format, String replace, String with) {
        return this.getInRequestEndTime(format, null, replace, with);
    }

    public String getInRequestEndTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRichiestaStream(), format, null, defaultValue, replace, with);
    }

    public String getInRequestEndTimeZ(String format, String timeZone) {
        return this.getInRequestEndTimeZ(format, timeZone, null, null, null);
    }

    public String getInRequestEndTimeZ(String format, String timeZone, String defaultValue) {
        return this.getInRequestEndTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getInRequestEndTimeZ(String format, String timeZone, String replace, String with) {
        return this.getInRequestEndTimeZ(format, timeZone, null, replace, with);
    }

    public String getInRequestEndTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRichiestaStream(), format, timeZone, defaultValue, replace, with);
    }

    public String getOutRequestDate() {
        return this.getOutRequestDate("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getOutRequestDate(String format) {
        return this.getOutRequestDate(format, null, null, null);
    }

    public String getOutRequestDate(String format, String defaultValue) {
        return this.getOutRequestDate(format, defaultValue, null, null);
    }

    public String getOutRequestDate(String format, String replace, String with) {
        return this.getOutRequestDate(format, null, replace, with);
    }

    public String getOutRequestDate(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRichiesta(), format, null, defaultValue, replace, with);
    }

    public String getOutRequestDateZ(String format, String timeZone) {
        return this.getOutRequestDateZ(format, timeZone, null, null, null);
    }

    public String getOutRequestDateZ(String format, String timeZone, String defaultValue) {
        return this.getOutRequestDateZ(format, timeZone, defaultValue, null, null);
    }

    public String getOutRequestDateZ(String format, String timeZone, String replace, String with) {
        return this.getOutRequestDateZ(format, timeZone, null, replace, with);
    }

    public String getOutRequestDateZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRichiesta(), format, timeZone, defaultValue, replace, with);
    }

    public String getOutRequestStartTime() {
        return this.getOutRequestStartTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getOutRequestStartTime(String format) {
        return this.getOutRequestStartTime(format, null, null, null);
    }

    public String getOutRequestStartTime(String format, String defaultValue) {
        return this.getOutRequestStartTime(format, defaultValue, null, null);
    }

    public String getOutRequestStartTime(String format, String replace, String with) {
        return this.getOutRequestStartTime(format, null, replace, with);
    }

    public String getOutRequestStartTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRichiesta(), format, null, defaultValue, replace, with);
    }

    public String getOutRequestStartTimeZ(String format, String timeZone) {
        return this.getOutRequestStartTimeZ(format, timeZone, null, null, null);
    }

    public String getOutRequestStartTimeZ(String format, String timeZone, String defaultValue) {
        return this.getOutRequestStartTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getOutRequestStartTimeZ(String format, String timeZone, String replace, String with) {
        return this.getOutRequestStartTimeZ(format, timeZone, null, replace, with);
    }

    public String getOutRequestStartTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRichiesta(), format, timeZone, defaultValue, replace, with);
    }

    public String getOutRequestEndTime() {
        return this.getOutRequestEndTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getOutRequestEndTime(String format) {
        return this.getOutRequestEndTime(format, null, null, null);
    }

    public String getOutRequestEndTime(String format, String defaultValue) {
        return this.getOutRequestEndTime(format, defaultValue, null, null);
    }

    public String getOutRequestEndTime(String format, String replace, String with) {
        return this.getOutRequestEndTime(format, null, replace, with);
    }

    public String getOutRequestEndTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRichiestaStream(), format, null, defaultValue, replace, with);
    }

    public String getOutRequestEndTimeZ(String format, String timeZone) {
        return this.getOutRequestEndTimeZ(format, timeZone, null, null, null);
    }

    public String getOutRequestEndTimeZ(String format, String timeZone, String defaultValue) {
        return this.getOutRequestEndTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getOutRequestEndTimeZ(String format, String timeZone, String replace, String with) {
        return this.getOutRequestEndTimeZ(format, timeZone, null, replace, with);
    }

    public String getOutRequestEndTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRichiestaStream(), format, timeZone, defaultValue, replace, with);
    }

    public String getAcceptedResponseDate() {
        return this.getAcceptedResponseDate("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getAcceptedResponseDate(String format) {
        return this.getAcceptedResponseDate(format, null, null, null);
    }

    public String getAcceptedResponseDate(String format, String defaultValue) {
        return this.getAcceptedResponseDate(format, defaultValue, null, null);
    }

    public String getAcceptedResponseDate(String format, String replace, String with) {
        return this.getAcceptedResponseDate(format, null, replace, with);
    }

    public String getAcceptedResponseDate(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataAccettazioneRisposta(), format, null, defaultValue, replace, with);
    }

    public String getAcceptedResponseDateZ(String format, String timeZone) {
        return this.getAcceptedResponseDateZ(format, timeZone, null, null, null);
    }

    public String getAcceptedResponseDateZ(String format, String timeZone, String defaultValue) {
        return this.getAcceptedResponseDateZ(format, timeZone, defaultValue, null, null);
    }

    public String getAcceptedResponseDateZ(String format, String timeZone, String replace, String with) {
        return this.getAcceptedResponseDateZ(format, timeZone, null, replace, with);
    }

    public String getAcceptedResponseDateZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataAccettazioneRisposta(), format, timeZone, defaultValue, replace, with);
    }

    public String getInResponseDate() {
        return this.getInResponseDate("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getInResponseDate(String format) {
        return this.getInResponseDate(format, null, null, null);
    }

    public String getInResponseDate(String format, String defaultValue) {
        return this.getInResponseDate(format, defaultValue, null, null);
    }

    public String getInResponseDate(String format, String replace, String with) {
        return this.getInResponseDate(format, null, replace, with);
    }

    public String getInResponseDate(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRisposta(), format, null, defaultValue, replace, with);
    }

    public String getInResponseDateZ(String format, String timeZone) {
        return this.getInResponseDateZ(format, timeZone, null, null, null);
    }

    public String getInResponseDateZ(String format, String timeZone, String defaultValue) {
        return this.getInResponseDateZ(format, timeZone, defaultValue, null, null);
    }

    public String getInResponseDateZ(String format, String timeZone, String replace, String with) {
        return this.getInResponseDateZ(format, timeZone, null, replace, with);
    }

    public String getInResponseDateZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRisposta(), format, timeZone, defaultValue, replace, with);
    }

    public String getInResponseStartTime() {
        return this.getInResponseStartTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getInResponseStartTime(String format) {
        return this.getInResponseStartTime(format, null, null, null);
    }

    public String getInResponseStartTime(String format, String defaultValue) {
        return this.getInResponseStartTime(format, defaultValue, null, null);
    }

    public String getInResponseStartTime(String format, String replace, String with) {
        return this.getInResponseStartTime(format, null, replace, with);
    }

    public String getInResponseStartTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRisposta(), format, null, defaultValue, replace, with);
    }

    public String getInResponseStartTimeZ(String format, String timeZone) {
        return this.getInResponseStartTimeZ(format, timeZone, null, null, null);
    }

    public String getInResponseStartTimeZ(String format, String timeZone, String defaultValue) {
        return this.getInResponseStartTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getInResponseStartTimeZ(String format, String timeZone, String replace, String with) {
        return this.getInResponseStartTimeZ(format, timeZone, null, replace, with);
    }

    public String getInResponseStartTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRisposta(), format, timeZone, defaultValue, replace, with);
    }

    public String getInResponseEndTime() {
        return this.getInResponseEndTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getInResponseEndTime(String format) {
        return this.getInResponseEndTime(format, null, null, null);
    }

    public String getInResponseEndTime(String format, String defaultValue) {
        return this.getInResponseEndTime(format, defaultValue, null, null);
    }

    public String getInResponseEndTime(String format, String replace, String with) {
        return this.getInResponseEndTime(format, null, replace, with);
    }

    public String getInResponseEndTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRispostaStream(), format, null, defaultValue, replace, with);
    }

    public String getInResponseEndTimeZ(String format, String timeZone) {
        return this.getInResponseEndTimeZ(format, timeZone, null, null, null);
    }

    public String getInResponseEndTimeZ(String format, String timeZone, String defaultValue) {
        return this.getInResponseEndTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getInResponseEndTimeZ(String format, String timeZone, String replace, String with) {
        return this.getInResponseEndTimeZ(format, timeZone, null, replace, with);
    }

    public String getInResponseEndTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataIngressoRispostaStream(), format, timeZone, defaultValue, replace, with);
    }

    public String getOutResponseDate() {
        return this.getOutResponseDate("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getOutResponseDate(String format) {
        return this.getOutResponseDate(format, null, null, null);
    }

    public String getOutResponseDate(String format, String defaultValue) {
        return this.getOutResponseDate(format, defaultValue, null, null);
    }

    public String getOutResponseDate(String format, String replace, String with) {
        return this.getOutResponseDate(format, null, replace, with);
    }

    public String getOutResponseDate(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRisposta(), format, null, defaultValue, replace, with);
    }

    public String getOutResponseDateZ(String format, String timeZone) {
        return this.getOutResponseDateZ(format, timeZone, null, null, null);
    }

    public String getOutResponseDateZ(String format, String timeZone, String defaultValue) {
        return this.getOutResponseDateZ(format, timeZone, defaultValue, null, null);
    }

    public String getOutResponseDateZ(String format, String timeZone, String replace, String with) {
        return this.getOutResponseDateZ(format, timeZone, null, replace, with);
    }

    public String getOutResponseDateZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRisposta(), format, timeZone, defaultValue, replace, with);
    }

    public String getOutResponseStartTime() {
        return this.getOutResponseStartTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getOutResponseStartTime(String format) {
        return this.getOutResponseStartTime(format, null, null, null);
    }

    public String getOutResponseStartTime(String format, String defaultValue) {
        return this.getOutResponseStartTime(format, defaultValue, null, null);
    }

    public String getOutResponseStartTime(String format, String replace, String with) {
        return this.getOutResponseStartTime(format, null, replace, with);
    }

    public String getOutResponseStartTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRispostaStream(), format, null, defaultValue, replace, with);
    }

    public String getOutResponseStartTimeZ(String format, String timeZone) {
        return this.getOutResponseStartTimeZ(format, timeZone, null, null, null);
    }

    public String getOutResponseStartTimeZ(String format, String timeZone, String defaultValue) {
        return this.getOutResponseStartTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getOutResponseStartTimeZ(String format, String timeZone, String replace, String with) {
        return this.getOutResponseStartTimeZ(format, timeZone, null, replace, with);
    }

    public String getOutResponseStartTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRispostaStream(), format, timeZone, defaultValue, replace, with);
    }

    public String getOutResponseEndTime() {
        return this.getOutResponseEndTime("yyyy-MM-dd_HH:mm:ss.SSSX");
    }

    public String getOutResponseEndTime(String format) {
        return this.getOutResponseEndTime(format, null, null, null);
    }

    public String getOutResponseEndTime(String format, String defaultValue) {
        return this.getOutResponseEndTime(format, defaultValue, null, null);
    }

    public String getOutResponseEndTime(String format, String replace, String with) {
        return this.getOutResponseEndTime(format, null, replace, with);
    }

    public String getOutResponseEndTime(String format, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRisposta(), format, null, defaultValue, replace, with);
    }

    public String getOutResponseEndTimeZ(String format, String timeZone) {
        return this.getOutResponseEndTimeZ(format, timeZone, null, null, null);
    }

    public String getOutResponseEndTimeZ(String format, String timeZone, String defaultValue) {
        return this.getOutResponseEndTimeZ(format, timeZone, defaultValue, null, null);
    }

    public String getOutResponseEndTimeZ(String format, String timeZone, String replace, String with) {
        return this.getOutResponseEndTimeZ(format, timeZone, null, replace, with);
    }

    public String getOutResponseEndTimeZ(String format, String timeZone, String defaultValue, String replace, String with) {
        return this.correctDate(this.transazione.getDataUscitaRisposta(), format, timeZone, defaultValue, replace, with);
    }

    public long getElapsedTime() {
        return this.getElapsedTime(null);
    }

    public long getElapsedTime(String defaultValue) {
        return this.correctLong(this.getLatenzaTotaleEngine(), defaultValue);
    }

    public long getElapsedTimeS() {
        return this.getElapsedTimeS(null);
    }

    public long getElapsedTimeS(String defaultValue) {
        return this.getElapsedTime(defaultValue) / 1000L;
    }

    public long getElapsedTimeMs() {
        return this.getElapsedTimeMs(null);
    }

    public long getElapsedTimeMs(String defaultValue) {
        return this.getElapsedTime(defaultValue);
    }

    public long getElapsedTimeUs() {
        return this.getElapsedTimeUs(null);
    }

    public long getElapsedTimeUs(String defaultValue) {
        return this.getElapsedTime(defaultValue) * 1000L;
    }

    public long getElapsedTimeNs() {
        return this.getElapsedTimeNs(null);
    }

    public long getElapsedTimeNs(String defaultValue) {
        return this.getElapsedTime(defaultValue) * 1000L * 1000L;
    }

    private Long getLatenzaTotaleEngine() {
        Long l = null;
        if (this.transazione.getDataUscitaRisposta() != null && this.transazione.getDataIngressoRichiesta() != null) {
            l = this.transazione.getDataUscitaRisposta().getTime() - this.transazione.getDataIngressoRichiesta().getTime();
        }
        return l;
    }

    public long getApiElapsedTime() {
        return this.getApiElapsedTime(null);
    }

    public long getApiElapsedTime(String defaultValue) {
        return this.correctLong(this.getLatenzaServizioEngine(), defaultValue);
    }

    public long getApiElapsedTimeS() {
        return this.getApiElapsedTimeS(null);
    }

    public long getApiElapsedTimeS(String defaultValue) {
        return this.getApiElapsedTime(defaultValue) / 1000L;
    }

    public long getApiElapsedTimeMs() {
        return this.getApiElapsedTimeMs(null);
    }

    public long getApiElapsedTimeMs(String defaultValue) {
        return this.getApiElapsedTime(defaultValue);
    }

    public long getApiElapsedTimeUs() {
        return this.getApiElapsedTimeUs(null);
    }

    public long getApiElapsedTimeUs(String defaultValue) {
        return this.getApiElapsedTime(defaultValue) * 1000L;
    }

    public long getApiElapsedTimeNs() {
        return this.getApiElapsedTimeNs(null);
    }

    public long getApiElapsedTimeNs(String defaultValue) {
        return this.getApiElapsedTime(defaultValue) * 1000L * 1000L;
    }

    private Long getLatenzaServizioEngine() {
        Long l = null;
        if (this.transazione.getDataUscitaRichiesta() != null && this.transazione.getDataIngressoRisposta() != null) {
            l = this.transazione.getDataIngressoRisposta().getTime() - this.transazione.getDataUscitaRichiesta().getTime();
        }
        return l;
    }

    public long getGatewayLatency() {
        return this.getGatewayLatency(null);
    }

    public long getGatewayLatency(String defaultValue) {
        return this.correctLong(this.getLatenzaPortaEngine(), defaultValue);
    }

    public long getGatewayLatencyS() {
        return this.getGatewayLatencyS(null);
    }

    public long getGatewayLatencyS(String defaultValue) {
        return this.getGatewayLatency(defaultValue) / 1000L;
    }

    public long getGatewayLatencyMs() {
        return this.getGatewayLatencyMs(null);
    }

    public long getGatewayLatencyMs(String defaultValue) {
        return this.getGatewayLatency(defaultValue);
    }

    public long getGatewayLatencyUs() {
        return this.getGatewayLatencyUs(null);
    }

    public long getGatewayLatencyUs(String defaultValue) {
        return this.getGatewayLatency(defaultValue) * 1000L;
    }

    public long getGatewayLatencyNs() {
        return this.getGatewayLatencyNs(null);
    }

    public long getGatewayLatencyNs(String defaultValue) {
        return this.getGatewayLatency(defaultValue) * 1000L * 1000L;
    }

    private Long getLatenzaPortaEngine() {
        Long l = null;
        Long latTotale = this.getLatenzaTotaleEngine();
        if (latTotale != null && latTotale >= 0L) {
            Long latServizio = this.getLatenzaServizioEngine();
            l = latServizio != null && latServizio >= 0L ? Long.valueOf(latTotale - latServizio) : latTotale;
        }
        return l;
    }

    public String getDomain() {
        return this.getDomain(null);
    }

    public String getDomain(String defaultValue) {
        return this.correctValue(this.transazione.getPddCodice(), defaultValue);
    }

    public String getOrganizationType() {
        return this.getOrganizationType(null);
    }

    public String getOrganizationType(String defaultValue) {
        return this.correctValue(this.transazione.getPddTipoSoggetto(), defaultValue);
    }

    public String getOrganization() {
        return this.getOrganization(null);
    }

    public String getOrganization(String defaultValue) {
        return this.correctValue(this.transazione.getPddNomeSoggetto(), defaultValue);
    }

    public String getOrganizationId() {
        return this.getOrganizationId(null);
    }

    public String getOrganizationId(String defaultValue) {
        String nome = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getOrganization())) {
            try {
                nome = NamingUtils.getLabelSoggetto((String)this.getProfile(), (String)this.getOrganizationType(), (String)this.getOrganization());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.correctValue(nome, defaultValue);
    }

    public String getRole() {
        return this.getRole(null);
    }

    public String getRole(String defaultValue) {
        String s = null;
        if (this.transazione.getPddRuolo() != null) {
            s = PddRuolo.DELEGATA.equals((Object)this.transazione.getPddRuolo()) ? "fruizione" : "erogazione";
        }
        return this.correctValue(s, defaultValue);
    }

    public String getSenderType() {
        return this.getSenderType(null);
    }

    public String getSenderType(String defaultValue) {
        return this.correctValue(this.transazione.getTipoSoggettoFruitore(), defaultValue);
    }

    public String getSender() {
        return this.getSender(null);
    }

    public String getSender(String defaultValue) {
        return this.correctValue(this.transazione.getNomeSoggettoFruitore(), defaultValue);
    }

    public String getSenderId() {
        return this.getSenderId(null);
    }

    public String getSenderId(String defaultValue) {
        String nome = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getSender())) {
            try {
                nome = NamingUtils.getLabelSoggetto((String)this.getProfile(), (String)this.getSenderType(), (String)this.getSender());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.correctValue(nome, defaultValue);
    }

    public String getSenderDomain() {
        return this.getSenderDomain(null);
    }

    public String getSenderDomain(String defaultValue) {
        return this.correctValue(this.transazione.getIdportaSoggettoFruitore(), defaultValue);
    }

    public String getSenderURI() {
        return this.getSenderURI(null);
    }

    public String getSenderURI(String defaultValue) {
        return this.correctValue(this.transazione.getIndirizzoSoggettoFruitore(), defaultValue);
    }

    public String getSenderProperty(String name) {
        return this.getSenderProperty(name, null);
    }

    public String getSenderProperty(String name, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getSenderProperty(name), defaultValue);
    }

    public String getSenderPropertiesKeys() {
        return this.getSenderPropertiesKeys(null);
    }

    public String getSenderPropertiesKeys(String defaultValue) {
        return this.getSenderPropertiesKeys(",", defaultValue);
    }

    public String getSenderPropertiesKeys(String separator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getSenderPropertiesKeysAsString(separator), defaultValue);
    }

    public String getSenderProperties() {
        return this.getSenderProperties(null);
    }

    public String getSenderProperties(String defaultValue) {
        return this.getSenderProperties(" ", "=", defaultValue);
    }

    public String getSenderProperties(String propertySeparator, String valueSeparator) {
        return this.getSenderProperties(propertySeparator, valueSeparator, null);
    }

    public String getSenderProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getSenderPropertiesAsString(propertySeparator, valueSeparator), defaultValue);
    }

    public String getProviderType() {
        return this.getProviderType(null);
    }

    public String getProviderType(String defaultValue) {
        return this.correctValue(this.transazione.getTipoSoggettoErogatore(), defaultValue);
    }

    public String getProvider() {
        return this.getProvider(null);
    }

    public String getProvider(String defaultValue) {
        return this.correctValue(this.transazione.getNomeSoggettoErogatore(), defaultValue);
    }

    public String getProviderId() {
        return this.getProviderId(null);
    }

    public String getProviderId(String defaultValue) {
        String nome = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getProvider())) {
            try {
                nome = NamingUtils.getLabelSoggetto((String)this.getProfile(), (String)this.getProviderType(), (String)this.getProvider());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.correctValue(nome, defaultValue);
    }

    public String getProviderDomain() {
        return this.getProviderDomain(null);
    }

    public String getProviderDomain(String defaultValue) {
        return this.correctValue(this.transazione.getIdportaSoggettoErogatore(), defaultValue);
    }

    public String getProviderURI() {
        return this.getProviderURI(null);
    }

    public String getProviderURI(String defaultValue) {
        return this.correctValue(this.transazione.getIndirizzoSoggettoErogatore(), defaultValue);
    }

    public String getProviderProperty(String name) {
        return this.getProviderProperty(name, null);
    }

    public String getProviderProperty(String name, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getProviderProperty(name), defaultValue);
    }

    public String getProviderPropertiesKeys() {
        return this.getProviderPropertiesKeys(null);
    }

    public String getProviderPropertiesKeys(String defaultValue) {
        return this.getProviderPropertiesKeys(",", defaultValue);
    }

    public String getProviderPropertiesKeys(String separator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getProviderPropertiesKeysAsString(separator), defaultValue);
    }

    public String getProviderProperties() {
        return this.getProviderProperties(null);
    }

    public String getProviderProperties(String defaultValue) {
        return this.getProviderProperties(" ", "=", defaultValue);
    }

    public String getProviderProperties(String propertySeparator, String valueSeparator) {
        return this.getProviderProperties(propertySeparator, valueSeparator, null);
    }

    public String getProviderProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getProviderPropertiesAsString(propertySeparator, valueSeparator), defaultValue);
    }

    public String getCollaborationProfileCode() {
        return this.getCollaborationProfileCode(null);
    }

    public String getCollaborationProfileCode(String defaultValue) {
        return this.correctValue(this.transazione.getProfiloCollaborazioneOp2(), defaultValue);
    }

    public String getCollaborationProfile() {
        return this.getCollaborationProfile(null);
    }

    public String getCollaborationProfile(String defaultValue) {
        return this.correctValue(this.transazione.getProfiloCollaborazioneProt(), defaultValue);
    }

    public String getApiProtocol() {
        return this.getApiProtocol(null);
    }

    public String getApiProtocol(String defaultValue) {
        if (TipoAPI.REST.getValoreAsInt() == this.transazione.getTipoApi()) {
            return "rest";
        }
        if (TipoAPI.SOAP.getValoreAsInt() == this.transazione.getTipoApi()) {
            return "soap";
        }
        return this.correctValue(null, defaultValue);
    }

    public String getApiInterface() {
        return this.getApiInterface(null);
    }

    public String getApiInterface(String defaultValue) {
        return this.correctValue(this.transazione.getUriAccordoServizio(), defaultValue);
    }

    public String getApiInterfaceId() {
        return this.getApiInterfaceId(null);
    }

    public String getApiInterfaceId(String defaultValue) {
        String p = null;
        try {
            String parteComune = this.transazione.getUriAccordoServizio();
            if (parteComune != null && !"".equals(parteComune)) {
                p = this.getApiInterfaceIdEngine(parteComune);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(p, defaultValue);
    }

    private String getApiInterfaceIdEngine(String parteComune) {
        try {
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(parteComune);
            return NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordo);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getApiType() {
        return this.getApiType(null);
    }

    public String getApiType(String defaultValue) {
        return this.correctValue(this.transazione.getTipoServizio(), defaultValue);
    }

    public String getApi() {
        return this.getApi(null);
    }

    public String getApi(String defaultValue) {
        return this.correctValue(this.transazione.getNomeServizio(), defaultValue);
    }

    public int getApiVersion() {
        return this.getApiVersion(null);
    }

    public int getApiVersion(String defaultValue) {
        return this.correctInteger(this.transazione.getVersioneServizio(), defaultValue);
    }

    public String getApiId() {
        return this.getApiId(null);
    }

    public String getApiId(String defaultValue) {
        String nome = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getApi())) {
            try {
                nome = NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)this.getProfile(), (String)this.getApiType(), (String)this.getApi(), (Integer)this.getApiVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.correctValue(nome, defaultValue);
    }

    public String getApiProperty(String name) {
        return this.getApiProperty(name, null);
    }

    public String getApiProperty(String name, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getApiImplProperty(name), defaultValue);
    }

    public String getApiPropertiesKeys() {
        return this.getApiPropertiesKeys(null);
    }

    public String getApiPropertiesKeys(String defaultValue) {
        return this.getApiPropertiesKeys(",", defaultValue);
    }

    public String getApiPropertiesKeys(String separator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getApiImplPropertiesKeysAsString(separator), defaultValue);
    }

    public String getApiProperties() {
        return this.getApiProperties(null);
    }

    public String getApiProperties(String defaultValue) {
        return this.getApiProperties(" ", "=", defaultValue);
    }

    public String getApiProperties(String propertySeparator, String valueSeparator) {
        return this.getApiProperties(propertySeparator, valueSeparator, null);
    }

    public String getApiProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getApiImplPropertiesAsString(propertySeparator, valueSeparator), defaultValue);
    }

    public String getInterface() {
        return this.getInterface(null);
    }

    public String getInterface(String defaultValue) {
        return this.correctValue(this.transazione.getNomePorta(), defaultValue);
    }

    public String getAction() {
        return this.getAction(null);
    }

    public String getAction(String defaultValue) {
        return this.correctValue(this.transazione.getAzione(), defaultValue);
    }

    public String getHttpMethod() {
        return this.getHttpMethod(null);
    }

    public String getHttpMethod(String defaultValue) {
        return this.correctValue(this.transazione.getTipoRichiesta(), defaultValue);
    }

    public String getOutURL() {
        return this.getOutURL(null);
    }

    public String getOutURL(String defaultValue) {
        String url = this.transazione.getLocationConnettore();
        if (url != null && url.startsWith("[") && url.contains("] ")) {
            url = url.substring(url.indexOf("] ") + 2);
        }
        return this.correctValue(url, defaultValue);
    }

    public String getOutConnectorName() {
        return this.getOutConnectorName(null);
    }

    public String getOutConnectorName(String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getOutConnectorName(), defaultValue);
    }

    public String getInURL() {
        return this.getInURL(null);
    }

    public String getInURL(String defaultValue) {
        String url = this.transazione.getUrlInvocazione();
        if (url != null && url.startsWith("[") && url.contains("] ")) {
            url = url.substring(url.indexOf("] ") + 2);
        }
        return this.correctValue(url, defaultValue);
    }

    public String getInFunction() {
        return this.getInFunction(null);
    }

    public String getInFunction(String defaultValue) {
        String url = this.transazione.getUrlInvocazione();
        String function = null;
        if (url.startsWith("[") && url.contains("] ")) {
            function = url.substring(1, url.indexOf("] "));
        }
        return this.correctValue(function, defaultValue);
    }

    public String getApplication() {
        return this.getApplication(null);
    }

    public String getApplication(String defaultValue) {
        return this.correctValue(this.transazione.getServizioApplicativoFruitore(), defaultValue);
    }

    public String getApplicationProperty(String name) {
        return this.getApplicationProperty(name, null);
    }

    public String getApplicationProperty(String name, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getApplicationProperty(name), defaultValue);
    }

    public String getApplicationPropertiesKeys() {
        return this.getApplicationPropertiesKeys(null);
    }

    public String getApplicationPropertiesKeys(String defaultValue) {
        return this.getApplicationPropertiesKeys(",", defaultValue);
    }

    public String getApplicationPropertiesKeys(String separator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getApplicationPropertiesKeysAsString(separator), defaultValue);
    }

    public String getApplicationProperties() {
        return this.getApplicationProperties(null);
    }

    public String getApplicationProperties(String defaultValue) {
        return this.getApplicationProperties(" ", "=", defaultValue);
    }

    public String getApplicationProperties(String propertySeparator, String valueSeparator) {
        return this.getApplicationProperties(propertySeparator, valueSeparator, null);
    }

    public String getApplicationProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getApplicationPropertiesAsString(propertySeparator, valueSeparator), defaultValue);
    }

    public String getCredentials() {
        return this.getCredentials(null);
    }

    public String getCredentials(String defaultValue) {
        return this.correctValue(this.transazione.getCredenziali(), defaultValue);
    }

    public String getPrincipalAuthType() {
        return this.getPrincipalAuthType(null);
    }

    public String getPrincipalAuthType(String defaultValue) {
        String tipo;
        String string = tipo = this.credenzialiMittente != null && this.credenzialiMittente.getTrasporto() != null ? this.credenzialiMittente.getTrasporto().getTipo() : null;
        if (tipo != null && tipo.contains("_")) {
            try {
                String soloTipoAuth = tipo.substring(tipo.indexOf("_") + 1, tipo.length());
                if (soloTipoAuth != null) {
                    tipo = soloTipoAuth;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.correctValue(tipo, defaultValue);
    }

    public String getPrincipal() {
        return this.getPrincipal(null);
    }

    public String getPrincipal(String defaultValue) {
        return this.correctValue(this.credenzialiMittente != null && this.credenzialiMittente.getTrasporto() != null ? this.credenzialiMittente.getTrasporto().getCredenziale() : null, defaultValue);
    }

    public String getClientCertificateSubjectDN() {
        return this.getClientCertificateSubjectDN(null);
    }

    public String getClientCertificateSubjectDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getChannel() != null && this.securityToken.getChannel().getCertificate() != null && this.securityToken.getChannel().getCertificate().getSubject() != null) {
            v = this.securityToken.getChannel().getCertificate().getSubject().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getClientCertificateSubjectCN() {
        return this.getClientCertificateSubjectCN(null);
    }

    public String getClientCertificateSubjectCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getChannel() != null && this.securityToken.getChannel().getCertificate() != null && this.securityToken.getChannel().getCertificate().getSubject() != null) {
            v = this.securityToken.getChannel().getCertificate().getSubject().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getClientCertificateSubjectDNInfo(String oid) {
        return this.getClientCertificateSubjectDNInfo(oid, null);
    }

    public String getClientCertificateSubjectDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getChannel() != null && this.securityToken.getChannel().getCertificate() != null && this.securityToken.getChannel().getCertificate().getSubject() != null) {
            v = this.securityToken.getChannel().getCertificate().getSubject().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getClientCertificateIssuerDN() {
        return this.getClientCertificateIssuerDN(null);
    }

    public String getClientCertificateIssuerDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getChannel() != null && this.securityToken.getChannel().getCertificate() != null && this.securityToken.getChannel().getCertificate().getIssuer() != null) {
            v = this.securityToken.getChannel().getCertificate().getIssuer().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getClientCertificateIssuerCN() {
        return this.getClientCertificateIssuerCN(null);
    }

    public String getClientCertificateIssuerCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getChannel() != null && this.securityToken.getChannel().getCertificate() != null && this.securityToken.getChannel().getCertificate().getIssuer() != null) {
            v = this.securityToken.getChannel().getCertificate().getIssuer().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getClientCertificateIssuerDNInfo(String oid) {
        return this.getClientCertificateIssuerDNInfo(oid, null);
    }

    public String getClientCertificateIssuerDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getChannel() != null && this.securityToken.getChannel().getCertificate() != null && this.securityToken.getChannel().getCertificate().getIssuer() != null) {
            v = this.securityToken.getChannel().getCertificate().getIssuer().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getToken() {
        return this.getToken(null);
    }

    public String getToken(String defaultValue) {
        return this.correctValue(this.transazione.getTokenInfo(), defaultValue);
    }

    public String getTokenIssuer() {
        return this.getTokenIssuer(null);
    }

    public String getTokenIssuer(String defaultValue) {
        return this.correctValue(this.credenzialiMittente != null && this.credenzialiMittente.getTokenIssuer() != null ? this.credenzialiMittente.getTokenIssuer().getCredenziale() : null, defaultValue);
    }

    public String getTokenSubject() {
        return this.getTokenSubject(null);
    }

    public String getTokenSubject(String defaultValue) {
        return this.correctValue(this.credenzialiMittente != null && this.credenzialiMittente.getTokenSubject() != null ? this.credenzialiMittente.getTokenSubject().getCredenziale() : null, defaultValue);
    }

    public String getTokenClientId() {
        return this.getTokenClientId(null);
    }

    public String getTokenClientId(String defaultValue) {
        return this.correctValue(this.credenzialiMittente != null && this.credenzialiMittente.getTokenClientId() != null ? CredenzialeTokenClient.convertClientIdDBValueToOriginal((String)this.credenzialiMittente.getTokenClientId().getCredenziale()) : null, defaultValue);
    }

    private void initTokenClientApplicationEngine() {
        try {
            this.tokenClientApplication = this.credenzialiMittente != null && this.credenzialiMittente.getTokenClientId() != null ? CredenzialeTokenClient.convertApplicationDBValueToOriginal((String)this.credenzialiMittente.getTokenClientId().getCredenziale()) : null;
        }
        catch (Exception t) {
            this.log.error("_initTokenClientApplication()" + this.getErrorSuffix(t), (Throwable)t);
        }
        this.tokenClientApplicationRead = true;
    }

    private IDServizioApplicativo getTokenClientApplicationEngine() {
        if (this.tokenClientApplicationRead == null) {
            this.initTokenClientApplicationEngine();
        }
        return this.tokenClientApplication;
    }

    public String getTokenClientApplication() {
        return this.getTokenClientApplication(null);
    }

    public String getTokenClientApplication(String defaultValue) {
        IDServizioApplicativo idSA = this.getTokenClientApplicationEngine();
        return this.correctValue(idSA != null ? idSA.getNome() : null, defaultValue);
    }

    public String getTokenClientApplicationProperty(String name) {
        return this.getTokenClientApplicationProperty(name, null);
    }

    public String getTokenClientApplicationProperty(String name, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getTokenClientApplicationProperty(name), defaultValue);
    }

    public String getTokenClientApplicationPropertiesKeys() {
        return this.getTokenClientApplicationPropertiesKeys(null);
    }

    public String getTokenClientApplicationPropertiesKeys(String defaultValue) {
        return this.getTokenClientApplicationPropertiesKeys(",", defaultValue);
    }

    public String getTokenClientApplicationPropertiesKeys(String separator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getTokenClientApplicationPropertiesKeysAsString(separator), defaultValue);
    }

    public String getTokenClientApplicationProperties() {
        return this.getTokenClientApplicationProperties(null);
    }

    public String getTokenClientApplicationProperties(String defaultValue) {
        return this.getTokenClientApplicationProperties(" ", "=", defaultValue);
    }

    public String getTokenClientApplicationProperties(String propertySeparator, String valueSeparator) {
        return this.getTokenClientApplicationProperties(propertySeparator, valueSeparator, null);
    }

    public String getTokenClientApplicationProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getTokenClientApplicationPropertiesAsString(propertySeparator, valueSeparator), defaultValue);
    }

    public String getTokenClientOrganizationType() {
        return this.getTokenClientOrganizationType(null);
    }

    public String getTokenClientOrganizationType(String defaultValue) {
        IDServizioApplicativo idSA = this.getTokenClientApplicationEngine();
        return this.correctValue(idSA != null ? idSA.getIdSoggettoProprietario().getTipo() : null, defaultValue);
    }

    public String getTokenClientOrganization() {
        return this.getTokenClientOrganization(null);
    }

    public String getTokenClientOrganization(String defaultValue) {
        IDServizioApplicativo idSA = this.getTokenClientApplicationEngine();
        return this.correctValue(idSA != null ? idSA.getIdSoggettoProprietario().getNome() : null, defaultValue);
    }

    public String getTokenClientOrganizationId() {
        return this.getTokenClientOrganizationId(null);
    }

    public String getTokenClientOrganizationId(String defaultValue) {
        String nome = null;
        if (StringUtils.isNotEmpty((CharSequence)this.getTokenClientOrganization())) {
            try {
                nome = NamingUtils.getLabelSoggetto((String)this.getProfile(), (String)this.getTokenClientOrganizationType(), (String)this.getTokenClientOrganization());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.correctValue(nome, defaultValue);
    }

    public String getTokenClientOrganizationProperty(String name) {
        return this.getTokenClientOrganizationProperty(name, null);
    }

    public String getTokenClientOrganizationProperty(String name, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getTokenClientOrganizationProperty(name), defaultValue);
    }

    public String getTokenClientOrganizationPropertiesKeys() {
        return this.getTokenClientOrganizationPropertiesKeys(null);
    }

    public String getTokenClientOrganizationPropertiesKeys(String defaultValue) {
        return this.getTokenClientOrganizationPropertiesKeys(",", defaultValue);
    }

    public String getTokenClientOrganizationPropertiesKeys(String separator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getTokenClientOrganizationPropertiesKeysAsString(separator), defaultValue);
    }

    public String getTokenClientOrganizationProperties() {
        return this.getTokenClientOrganizationProperties(null);
    }

    public String getTokenClientOrganizationProperties(String defaultValue) {
        return this.getTokenClientOrganizationProperties(" ", "=", defaultValue);
    }

    public String getTokenClientOrganizationProperties(String propertySeparator, String valueSeparator) {
        return this.getTokenClientOrganizationProperties(propertySeparator, valueSeparator, null);
    }

    public String getTokenClientOrganizationProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getTokenClientOrganizationPropertiesAsString(propertySeparator, valueSeparator), defaultValue);
    }

    public String getTokenUsername() {
        return this.getTokenUsername(null);
    }

    public String getTokenUsername(String defaultValue) {
        return this.correctValue(this.credenzialiMittente != null && this.credenzialiMittente.getTokenUsername() != null ? this.credenzialiMittente.getTokenUsername().getCredenziale() : null, defaultValue);
    }

    public String getTokenMail() {
        return this.getTokenMail(null);
    }

    public String getTokenMail(String defaultValue) {
        return this.correctValue(this.credenzialiMittente != null && this.credenzialiMittente.getTokenEMail() != null ? this.credenzialiMittente.getTokenEMail().getCredenziale() : null, defaultValue);
    }

    public String getTokenClaim(String tokenClaim) {
        return this.getTokenClaim(tokenClaim, null);
    }

    public String getTokenClaim(String tokenClaim, String defaultValue) {
        Serializable valueInfoTokenObject;
        String v = null;
        if (tokenClaim != null && this.informazioniToken != null && this.informazioniToken.getClaims() != null && this.informazioniToken.getClaims().containsKey(tokenClaim) && (valueInfoTokenObject = this.informazioniToken.getClaims().get(tokenClaim)) != null) {
            List<String> lClaimValues = TokenUtilities.getClaimValues(valueInfoTokenObject);
            v = TokenUtilities.getClaimValuesAsString(lClaimValues);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenRaw() {
        return this.getTokenRaw(null);
    }

    public String getTokenRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            v = (String)((Object)this.securityToken.getAccessToken().getToken());
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenHeaderRaw() {
        return this.getTokenHeaderRaw(null);
    }

    public String getTokenHeaderRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            v = this.securityToken.getAccessToken().getHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDecodedHeader() {
        return this.getTokenDecodedHeader(null);
    }

    public String getTokenDecodedHeader(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            v = this.securityToken.getAccessToken().getDecodedHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenHeaderClaim(String tokenClaim) {
        return this.getTokenHeaderClaim(tokenClaim, null);
    }

    public String getTokenHeaderClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            try {
                v = this.securityToken.getAccessToken().getHeaderClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenHeaderClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenHeaderClaims() {
        return this.getTokenHeaderClaims(",", "=", null);
    }

    public String getTokenHeaderClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            try {
                Map map = this.securityToken.getAccessToken().getHeaderClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenHeaderClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenPayloadRaw() {
        return this.getTokenPayloadRaw(null);
    }

    public String getTokenPayloadRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            v = this.securityToken.getAccessToken().getPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDecodedPayload() {
        return this.getTokenDecodedPayload(null);
    }

    public String getTokenDecodedPayload(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            v = this.securityToken.getAccessToken().getDecodedPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenPayloadClaim(String tokenClaim) {
        return this.getTokenPayloadClaim(tokenClaim, null);
    }

    public String getTokenPayloadClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            try {
                v = this.securityToken.getAccessToken().getPayloadClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenPayloadClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenPayloadClaims() {
        return this.getTokenPayloadClaims(",", "=", null);
    }

    public String getTokenPayloadClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null) {
            try {
                Map map = this.securityToken.getAccessToken().getPayloadClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenPayloadClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenCertificateSubjectDN() {
        return this.getTokenCertificateSubjectDN(null);
    }

    public String getTokenCertificateSubjectDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null && this.securityToken.getAccessToken().getCertificate() != null && this.securityToken.getAccessToken().getCertificate().getSubject() != null) {
            v = this.securityToken.getAccessToken().getCertificate().getSubject().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenCertificateSubjectCN() {
        return this.getTokenCertificateSubjectCN(null);
    }

    public String getTokenCertificateSubjectCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null && this.securityToken.getAccessToken().getCertificate() != null && this.securityToken.getAccessToken().getCertificate().getSubject() != null) {
            v = this.securityToken.getAccessToken().getCertificate().getSubject().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenCertificateSubjectDNInfo(String oid) {
        return this.getTokenCertificateSubjectDNInfo(oid, null);
    }

    public String getTokenCertificateSubjectDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null && this.securityToken.getAccessToken().getCertificate() != null && this.securityToken.getAccessToken().getCertificate().getSubject() != null) {
            v = this.securityToken.getAccessToken().getCertificate().getSubject().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenCertificateIssuerDN() {
        return this.getTokenCertificateIssuerDN(null);
    }

    public String getTokenCertificateIssuerDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null && this.securityToken.getAccessToken().getCertificate() != null && this.securityToken.getAccessToken().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAccessToken().getCertificate().getIssuer().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenCertificateIssuerCN() {
        return this.getTokenCertificateIssuerCN(null);
    }

    public String getTokenCertificateIssuerCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null && this.securityToken.getAccessToken().getCertificate() != null && this.securityToken.getAccessToken().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAccessToken().getCertificate().getIssuer().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenCertificateIssuerDNInfo(String oid) {
        return this.getTokenCertificateIssuerDNInfo(oid, null);
    }

    public String getTokenCertificateIssuerDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAccessToken() != null && this.securityToken.getAccessToken().getCertificate() != null && this.securityToken.getAccessToken().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAccessToken().getCertificate().getIssuer().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPRaw() {
        return this.getTokenDPoPRaw(null);
    }

    public String getTokenDPoPRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            v = (String)((Object)this.securityToken.getDpopToken().getToken());
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPHeaderRaw() {
        return this.getTokenDPoPHeaderRaw(null);
    }

    public String getTokenDPoPHeaderRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            v = this.securityToken.getDpopToken().getHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPDecodedHeader() {
        return this.getTokenDPoPDecodedHeader(null);
    }

    public String getTokenDPoPDecodedHeader(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            v = this.securityToken.getDpopToken().getDecodedHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPHeaderClaim(String tokenClaim) {
        return this.getTokenDPoPHeaderClaim(tokenClaim, null);
    }

    public String getTokenDPoPHeaderClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            try {
                v = this.securityToken.getDpopToken().getHeaderClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenDPoPHeaderClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPHeaderClaims() {
        return this.getTokenDPoPHeaderClaims(",", "=", null);
    }

    public String getTokenDPoPHeaderClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            try {
                Map map = this.securityToken.getDpopToken().getHeaderClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenDPoPHeaderClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPPayloadRaw() {
        return this.getTokenDPoPPayloadRaw(null);
    }

    public String getTokenDPoPPayloadRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            v = this.securityToken.getDpopToken().getPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPDecodedPayload() {
        return this.getTokenDPoPDecodedPayload(null);
    }

    public String getTokenDPoPDecodedPayload(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            v = this.securityToken.getDpopToken().getDecodedPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPPayloadClaim(String tokenClaim) {
        return this.getTokenDPoPPayloadClaim(tokenClaim, null);
    }

    public String getTokenDPoPPayloadClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            try {
                v = this.securityToken.getDpopToken().getPayloadClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenDPoPPayloadClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenDPoPPayloadClaims() {
        return this.getTokenDPoPPayloadClaims(",", "=", null);
    }

    public String getTokenDPoPPayloadClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            try {
                Map map = this.securityToken.getDpopToken().getPayloadClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenDPoPPayloadClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndClientJson() {
        return this.getPdndClientJson(null);
    }

    public String getPdndClientJson(String defaultValue) {
        return this.correctValue(this.getPdndClientJsonEngine(), defaultValue);
    }

    private String getPdndClientJsonEngine() {
        if (this.credenzialiMittente != null && this.credenzialiMittente.getTokenPdndClientJson() != null && this.credenzialiMittente.getTokenPdndClientJson().getCredenziale() != null) {
            return this.credenzialiMittente.getTokenPdndClientJson().getCredenziale();
        }
        if (this.securityToken != null && this.securityToken.getPdnd() != null && this.securityToken.getPdnd().getClientJson() != null) {
            return this.securityToken.getPdnd().getClientJson();
        }
        return null;
    }

    public String getPdndOrganizationJson() {
        return this.getPdndOrganizationJson(null);
    }

    public String getPdndOrganizationJson(String defaultValue) {
        return this.correctValue(this.getPdndOrganizationJsonEngine(), defaultValue);
    }

    private String getPdndOrganizationJsonEngine() {
        if (this.credenzialiMittente != null && this.credenzialiMittente.getTokenPdndOrganizationJson() != null && this.credenzialiMittente.getTokenPdndOrganizationJson().getCredenziale() != null) {
            return this.credenzialiMittente.getTokenPdndOrganizationJson().getCredenziale();
        }
        if (this.securityToken != null && this.securityToken.getPdnd() != null && this.securityToken.getPdnd().getOrganizationJson() != null) {
            return this.securityToken.getPdnd().getOrganizationJson();
        }
        return null;
    }

    public String getPdndOrganizationName() {
        return this.getPdndOrganizationName(null);
    }

    public String getPdndOrganizationName(String defaultValue) {
        String v;
        String string = v = this.credenzialiMittente != null && this.credenzialiMittente.getTokenPdndOrganizationName() != null ? this.credenzialiMittente.getTokenPdndOrganizationName().getCredenziale() : null;
        if (v == null) {
            try {
                v = this.securityToken != null && this.securityToken.getPdnd() != null ? this.securityToken.getPdnd().getOrganizationName() : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v == null) {
            PDNDTokenInfo info = this.getPDNDTokenOrganizationInfo();
            try {
                if (info != null) {
                    v = info.getOrganizationName(this.log);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndOrganizationId() {
        return this.getPdndOrganizationId(null);
    }

    public String getPdndOrganizationId(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenOrganizationInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getOrganizationId(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndOrganizationCategory() {
        return this.getPdndOrganizationCategory(null);
    }

    public String getPdndOrganizationCategory(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenOrganizationInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getOrganizationCategory(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndOrganizationSubUnit() {
        return this.getPdndOrganizationSubUnit(null);
    }

    public String getPdndOrganizationSubUnit(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenOrganizationInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getOrganizationSubUnit(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndOrganizationExternalOrigin() {
        return this.getPdndOrganizationExternalOrigin(null);
    }

    public String getPdndOrganizationExternalOrigin(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenOrganizationInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getOrganizationExternalOrigin(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndOrganizationExternalId() {
        return this.getPdndOrganizationExternalId(null);
    }

    public String getPdndOrganizationExternalId(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenOrganizationInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getOrganizationExternalId(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    private PDNDTokenInfo getPDNDTokenOrganizationInfo() {
        if (this.pdndTokenOrganizationInfo == null) {
            this.initPDNDTokenOrganizationInfo();
        }
        return this.pdndTokenOrganizationInfo;
    }

    private synchronized void initPDNDTokenOrganizationInfo() {
        if (this.pdndTokenOrganizationInfo == null) {
            this.pdndTokenOrganizationInfo = new PDNDTokenInfo();
            String organizationJson = this.getPdndOrganizationJsonEngine();
            if (organizationJson != null) {
                PDNDTokenInfoDetails id = new PDNDTokenInfoDetails();
                id.setDetails(organizationJson);
                this.pdndTokenOrganizationInfo.setOrganization(id);
            }
        }
    }

    public String getPdndClientId() {
        return this.getPdndClientId(null);
    }

    public String getPdndClientId(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenClientInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getClientId(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndClientConsumerId() {
        return this.getPdndClientConsumerId(null);
    }

    public String getPdndClientConsumerId(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenClientInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getClientConsumerId(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndClientName() {
        return this.getPdndClientName(null);
    }

    public String getPdndClientName(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenClientInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getClientName(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    public String getPdndClientDescription() {
        return this.getPdndClientDescription(null);
    }

    public String getPdndClientDescription(String defaultValue) {
        PDNDTokenInfo info = this.getPDNDTokenClientInfo();
        String v = null;
        try {
            if (info != null) {
                v = info.getClientDescription(this.log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(v, defaultValue);
    }

    private PDNDTokenInfo getPDNDTokenClientInfo() {
        if (this.pdndTokenClientInfo == null) {
            this.initPDNDTokenClientInfo();
        }
        return this.pdndTokenClientInfo;
    }

    private synchronized void initPDNDTokenClientInfo() {
        if (this.pdndTokenClientInfo == null) {
            this.pdndTokenClientInfo = new PDNDTokenInfo();
            String clientJson = this.getPdndClientJsonEngine();
            if (clientJson != null) {
                PDNDTokenInfoDetails id = new PDNDTokenInfoDetails();
                id.setDetails(clientJson);
                this.pdndTokenClientInfo.setClient(id);
            }
        }
    }

    public String getAttribute(String attributeName) {
        return this.getAttribute(attributeName, null);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        Serializable valueAttributeObject;
        String v = null;
        if (attributeName != null && this.informazioniAttributi != null && (this.informazioniAttributi.isMultipleAttributeAuthorities() == null || this.informazioniAttributi.isMultipleAttributeAuthorities().getValue() == null || !this.informazioniAttributi.isMultipleAttributeAuthorities().getValue().booleanValue()) && this.informazioniAttributi.getAttributes() != null && this.informazioniAttributi.getAttributes().containsKey(attributeName) && (valueAttributeObject = this.informazioniAttributi.getAttributes().get(attributeName)) != null) {
            List<String> lClaimValues = TokenUtilities.getClaimValues(valueAttributeObject);
            v = TokenUtilities.getClaimValuesAsString(lClaimValues);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getAttributeByAA(String attributeAuthorityName, String attributeName) {
        return this.getAttributeByAA(attributeAuthorityName, attributeName, null);
    }

    public String getAttributeByAA(String attributeAuthorityName, String attributeName, String defaultValue) {
        String v = null;
        if (attributeAuthorityName != null && attributeName != null) {
            v = this.getAttributeByAAEngine(attributeAuthorityName, attributeName);
        }
        return this.correctValue(v, defaultValue);
    }

    private String getAttributeByAAEngine(String attributeAuthorityName, String attributeName) {
        Object valueAttributeObject;
        Map map;
        Serializable o;
        if (this.informazioniAttributi != null && this.informazioniAttributi.isMultipleAttributeAuthorities() != null && this.informazioniAttributi.isMultipleAttributeAuthorities().getValue() != null && this.informazioniAttributi.isMultipleAttributeAuthorities().getValue().booleanValue() && this.informazioniAttributi.getAttributes() != null && this.informazioniAttributi.getAttributes().containsKey(attributeAuthorityName) && (o = this.informazioniAttributi.getAttributes().get(attributeAuthorityName)) instanceof Map && (map = (Map)((Object)o)).containsKey(attributeName) && (valueAttributeObject = map.get(attributeName)) != null) {
            List<String> lClaimValues = TokenUtilities.getClaimValues(valueAttributeObject);
            return TokenUtilities.getClaimValuesAsString(lClaimValues);
        }
        return null;
    }

    public String getRetrievedAccessToken() {
        return this.getRetrievedAccessToken(null);
    }

    public String getRetrievedAccessToken(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null) {
            v = this.informazioniNegoziazioneToken.getAccessToken();
        } else if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            v = (String)((Object)this.securityToken.getAuthorization().getToken());
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenClaim(String tokenClaim) {
        return this.getRetrievedTokenClaim(tokenClaim, null);
    }

    public String getRetrievedTokenClaim(String tokenClaim, String defaultValue) {
        Serializable valueInfoTokenObject;
        String v = null;
        if (tokenClaim != null && this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getClaims() != null && this.informazioniNegoziazioneToken.getClaims().containsKey(tokenClaim) && (valueInfoTokenObject = this.informazioniNegoziazioneToken.getClaims().get(tokenClaim)) != null) {
            List<String> lClaimValues = TokenUtilities.getClaimValues(valueInfoTokenObject);
            v = TokenUtilities.getClaimValuesAsString(lClaimValues);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestTransactionId() {
        return this.getRetrievedTokenRequestTransactionId(null);
    }

    public String getRetrievedTokenRequestTransactionId(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getTransactionId();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestGrantType() {
        return this.getRetrievedTokenRequestGrantType(null);
    }

    public String getRetrievedTokenRequestGrantType(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getGrantType();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestJwtClientAssertion() {
        return this.getRetrievedTokenRequestJwtClientAssertion(null);
    }

    public String getRetrievedTokenRequestJwtClientAssertion(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null && this.informazioniNegoziazioneToken.getRequest().getJwtClientAssertion() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getJwtClientAssertion().getToken();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestDPoP() {
        return this.getRetrievedTokenRequestDPoP(null);
    }

    public String getRetrievedTokenRequestDPoP(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null && this.informazioniNegoziazioneToken.getRequest().getDpop() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getDpop().getToken();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestClientId() {
        return this.getRetrievedTokenRequestClientId(null);
    }

    public String getRetrievedTokenRequestClientId(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getClientId();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestClientToken() {
        return this.getRetrievedTokenRequestClientToken(null);
    }

    public String getRetrievedTokenRequestClientToken(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getClientToken();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestUsername() {
        return this.getRetrievedTokenRequestUsername(null);
    }

    public String getRetrievedTokenRequestUsername(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getUsername();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenRequestUrl() {
        return this.getRetrievedTokenRequestUrl(null);
    }

    public String getRetrievedTokenRequestUrl(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getRequest() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getEndpoint();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRetrievedTokenDPoPBackend() {
        return this.getRetrievedTokenDPoPBackend(null);
    }

    public String getRetrievedTokenDPoPBackend(String defaultValue) {
        String v = null;
        if (this.informazioniNegoziazioneToken != null && this.informazioniNegoziazioneToken.getDpopBackend() != null) {
            v = this.informazioniNegoziazioneToken.getRequest().getDpop().getToken();
        } else if (this.securityToken != null && this.securityToken.getDpopToken() != null) {
            v = (String)((Object)this.securityToken.getDpopToken().getToken());
        }
        return this.correctValue(v, defaultValue);
    }

    public String getClientIP() {
        return this.getClientIP(null);
    }

    public String getClientIP(String defaultValue) {
        return this.correctValue(this.transazione.getSocketClientAddress(), defaultValue);
    }

    public String getForwardedIP() {
        return this.getForwardedIP(null);
    }

    public String getForwardedIP(String defaultValue) {
        return this.correctValue(this.transazione.getTransportClientAddress(), defaultValue);
    }

    public String getRequesterIP() {
        return this.getRequesterIP(null);
    }

    public String getRequesterIP(String defaultValue) {
        String forwardedIP = this.getForwardedIP();
        if (forwardedIP != null && StringUtils.isNotEmpty((CharSequence)forwardedIP)) {
            return forwardedIP;
        }
        return this.getClientIP(defaultValue);
    }

    private DatiMittente convertToDatiMittenteEngine() {
        DatiMittente datiMittente = new DatiMittente();
        datiMittente.setTokenUsername(this.getTokenUsername());
        datiMittente.setTokenSubject(this.getTokenSubject());
        datiMittente.setTokenIssuer(this.getTokenIssuer());
        datiMittente.setTokenClientId(this.getTokenClientId());
        datiMittente.setTokenClient(this.getTokenClientApplication());
        datiMittente.setTokenClientTipoSoggettoFruitore(this.getTokenClientOrganizationType());
        datiMittente.setTokenClientNomeSoggettoFruitore(this.getTokenClientOrganization());
        datiMittente.setTokenClientSoggettoFruitore(this.getTokenClientOrganizationId());
        datiMittente.setPdndOrganizationName(this.getPdndOrganizationName());
        datiMittente.setTipoTrasportoMittente(this.getPrincipalAuthType());
        datiMittente.setTrasportoMittente(this.getPrincipal());
        datiMittente.setServizioApplicativoFruitore(this.getApplication());
        datiMittente.setSoggettoFruitore(this.getSenderId());
        datiMittente.setTipoSoggettoFruitore(this.getSenderType());
        datiMittente.setNomeSoggettoFruitore(this.getSender());
        datiMittente.setPddRuolo(this.transazione.getPddRuolo());
        datiMittente.setSoggettoOperativo(null);
        datiMittente.setTransportClientAddress(this.getForwardedIP());
        datiMittente.setSocketClientAddress(this.getClientIP());
        return datiMittente;
    }

    public String getRequester() {
        return this.getRequester(null);
    }

    public String getRequester(String defaultValue) {
        DatiMittente datiMittente = this.convertToDatiMittenteEngine();
        boolean notUseBase64option = false;
        return this.correctValue(InfoMittenteFormatUtils.getRichiedente(datiMittente), defaultValue, true, notUseBase64option);
    }

    public String getIpRequester() {
        return this.getIpRequester(null);
    }

    public String getIpRequester(String defaultValue) {
        DatiMittente datiMittente = this.convertToDatiMittenteEngine();
        return this.correctValue(InfoMittenteFormatUtils.getIpRichiedente(datiMittente, OpenSPCoop2Properties.getInstance().isTransazioniTracciamentoDBTransportClientAddressSanitizePort()), defaultValue);
    }

    public String getState() {
        return this.getState(null);
    }

    public String getState(String defaultValue) {
        return this.correctValue(this.transazione.getStato(), defaultValue);
    }

    public String getProfile() {
        return this.getProfile(null);
    }

    public String getProfile(String defaultValue) {
        return this.correctValue(this.transazione.getProtocollo(), defaultValue);
    }

    public String getProfileLabel() {
        return this.getProfileLabel(null);
    }

    public String getProfileLabel(String defaultValue) {
        String p = null;
        try {
            p = NamingUtils.getLabelProtocollo((String)this.getProfile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.correctValue(p, defaultValue);
    }

    public String getCorrelationType() {
        return this.getCorrelationType(null);
    }

    public String getCorrelationType(String defaultValue) {
        return this.correctValue(this.transazione.getTipoServizioCorrelato(), defaultValue);
    }

    public String getCorrelationApi() {
        return this.getCorrelationApi(null);
    }

    public String getCorrelationApi(String defaultValue) {
        return this.correctValue(this.transazione.getNomeServizioCorrelato(), defaultValue);
    }

    public int getDuplicateRequest() {
        return this.getDuplicateRequest(null);
    }

    public int getDuplicateRequest(String defaultValue) {
        return this.correctInteger(this.transazione.getDuplicatiRichiesta(), defaultValue);
    }

    public int getDuplicateResponse() {
        return this.getDuplicateResponse(null);
    }

    public int getDuplicateResponse(String defaultValue) {
        return this.correctInteger(this.transazione.getDuplicatiRisposta(), defaultValue);
    }

    public String getInFault() {
        return this.getInFault(null);
    }

    public String getInFault(String defaultValue) {
        if (this.transazione.getPddRuolo() != null) {
            switch (this.transazione.getPddRuolo()) {
                case DELEGATA: {
                    return this.getFaultCooperazioneEngine(defaultValue);
                }
                case APPLICATIVA: {
                    return this.getFaultIntegrazioneEngine(defaultValue);
                }
            }
        }
        return this.correctValue(null, defaultValue);
    }

    public String getOutFault() {
        return this.getOutFault(null);
    }

    public String getOutFault(String defaultValue) {
        if (this.transazione.getPddRuolo() != null) {
            switch (this.transazione.getPddRuolo()) {
                case DELEGATA: {
                    return this.getFaultIntegrazioneEngine(defaultValue);
                }
                case APPLICATIVA: {
                    return this.getFaultCooperazioneEngine(defaultValue);
                }
            }
        }
        return this.correctValue(null, defaultValue);
    }

    private String getFaultIntegrazioneEngine(String defaultValue) {
        return this.correctValue(this.transazione.getFaultIntegrazione(), defaultValue);
    }

    private String getFormatoFaultIntegrazioneEngine(String defaultValue) {
        return this.correctValue(this.transazione.getFormatoFaultIntegrazione(), defaultValue);
    }

    private String getFaultCooperazioneEngine(String defaultValue) {
        return this.correctValue(this.transazione.getFaultCooperazione(), defaultValue);
    }

    private String getFormatoFaultCooperazioneEngine(String defaultValue) {
        return this.correctValue(this.transazione.getFormatoFaultCooperazione(), defaultValue);
    }

    public String getInRequestContentType() {
        return this.getInRequestContentType(null);
    }

    public String getInRequestContentType(String defaultValue) {
        String s = null;
        if (this.richiestaIngresso != null) {
            s = this.richiestaIngresso.getContentType();
        }
        return this.correctValue(s, defaultValue);
    }

    public String getInRequestContent() {
        return this.getInRequestContent(null);
    }

    public String getInRequestContent(String defaultValue) {
        byte[] c = null;
        if (this.richiestaIngresso != null && this.richiestaIngresso.getBody() != null && this.richiestaIngresso.getBody().size() > 0) {
            c = this.richiestaIngresso.getBody().toByteArray();
        }
        return this.correctByteArray(c, defaultValue);
    }

    public int getInRequestSize() {
        return this.getInRequestSize(null);
    }

    public int getInRequestSize(String defaultValue) {
        byte[] c = null;
        if (this.richiestaIngresso != null && this.richiestaIngresso.getBody() != null && this.richiestaIngresso.getBody().size() > 0) {
            c = this.richiestaIngresso.getBody().toByteArray();
        }
        int size = 0;
        if (c != null) {
            size = c.length;
        } else if (this.transazione.getRichiestaIngressoBytes() != null) {
            size = this.transazione.getRichiestaIngressoBytes().intValue();
        }
        return this.correctInteger(size, defaultValue);
    }

    public String getInRequestHeader(String name) {
        return this.getInRequestHeader(name, this.headerMultiValueSeparator, false);
    }

    public String getInRequestHeader(String name, String multiValueSeparator) {
        return this.getInRequestHeader(name, multiValueSeparator, false);
    }

    public String removeInRequestHeader(String name) {
        return this.getInRequestHeader(name, this.headerMultiValueSeparator, true);
    }

    public String removeInRequestHeader(String name, String multiValueSeparator) {
        return this.getInRequestHeader(name, multiValueSeparator, true);
    }

    private String getInRequestHeader(String name, String multiValueSeparator, boolean consume) {
        String s = null;
        if (this.richiestaIngresso != null && this.richiestaIngresso.getHeaders() != null) {
            List values = (List)TransportUtils.getRawObject((Map)this.richiestaIngresso.getHeaders(), (String)name);
            s = this.format(values, multiValueSeparator);
        }
        if (consume) {
            this.headerRichiestaIngressoConsumati.add(name);
        }
        return this.correctValue(s, null);
    }

    public String getInRequestHeaders() {
        return this.getInRequestHeaders(null, null, null, null, null);
    }

    public String getInRequestHeaders(String defaultValue) {
        return this.getInRequestHeaders(defaultValue, null, null, null, null);
    }

    public String getInRequestHeaders(String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        return this.getInRequestHeaders(null, hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix);
    }

    public String getInRequestHeaders(String defaultValue, String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        if (this.richiestaIngresso != null) {
            return this.formatHeaders(this.filterHeaders(this.richiestaIngresso.getHeaders(), this.headerRichiestaIngressoConsumati), defaultValue, new HeaderFormat(hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix));
        }
        String s = null;
        return this.correctValue(s, defaultValue);
    }

    public String getOutRequestContentType() {
        return this.getOutRequestContentType(null);
    }

    public String getOutRequestContentType(String defaultValue) {
        String s = null;
        if (this.richiestaUscita != null) {
            s = this.richiestaUscita.getContentType();
        } else if (this.headerRichiestaUscita != null && !this.headerRichiestaUscita.isEmpty()) {
            s = TransportUtils.getFirstValue(this.headerRichiestaUscita, (String)"Content-Type");
        }
        return this.correctValue(s, defaultValue);
    }

    public String getOutRequestContent() {
        return this.getOutRequestContent(null);
    }

    public String getOutRequestContent(String defaultValue) {
        byte[] c = null;
        if (this.richiestaUscita != null && this.richiestaUscita.getBody() != null && this.richiestaUscita.getBody().size() > 0) {
            c = this.richiestaUscita.getBody().toByteArray();
        }
        return this.correctByteArray(c, defaultValue);
    }

    public int getOutRequestSize() {
        return this.getOutRequestSize(null);
    }

    public int getOutRequestSize(String defaultValue) {
        byte[] c = null;
        if (this.richiestaUscita != null && this.richiestaUscita.getBody() != null && this.richiestaUscita.getBody().size() > 0) {
            c = this.richiestaUscita.getBody().toByteArray();
        }
        int size = 0;
        if (c != null) {
            size = c.length;
        } else if (this.transazione.getRichiestaUscitaBytes() != null) {
            size = this.transazione.getRichiestaUscitaBytes().intValue();
        }
        return this.correctInteger(size, defaultValue);
    }

    public String getOutRequestHeader(String name) {
        return this.getOutRequestHeader(name, this.headerMultiValueSeparator, false);
    }

    public String getOutRequestHeader(String name, String multiValueSeparator) {
        return this.getOutRequestHeader(name, multiValueSeparator, false);
    }

    public String removeOutRequestHeader(String name) {
        return this.getOutRequestHeader(name, this.headerMultiValueSeparator, true);
    }

    public String removeOutRequestHeader(String name, String multiValueSeparator) {
        return this.getOutRequestHeader(name, multiValueSeparator, true);
    }

    private String getOutRequestHeader(String name, String multiValueSeparator, boolean consume) {
        String s = null;
        if (this.richiestaUscita != null && this.richiestaUscita.getHeaders() != null) {
            List values = (List)TransportUtils.getRawObject((Map)this.richiestaUscita.getHeaders(), (String)name);
            s = this.format(values, multiValueSeparator);
        } else if (this.headerRichiestaUscita != null && !this.headerRichiestaUscita.isEmpty()) {
            List values = (List)TransportUtils.getRawObject(this.headerRichiestaUscita, (String)name);
            s = this.format(values, multiValueSeparator);
        }
        if (consume) {
            this.headerRichiestaUscitaConsumati.add(name);
        }
        return this.correctValue(s, null);
    }

    public String getOutRequestHeaders() {
        return this.getOutRequestHeaders(null, null, null, null, null);
    }

    public String getOutRequestHeaders(String defaultValue) {
        return this.getOutRequestHeaders(defaultValue, null, null, null, null);
    }

    public String getOutRequestHeaders(String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        return this.getOutRequestHeaders(null, hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix);
    }

    public String getOutRequestHeaders(String defaultValue, String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        if (this.richiestaUscita != null) {
            return this.formatHeaders(this.filterHeaders(this.richiestaUscita.getHeaders(), this.headerRichiestaUscitaConsumati), defaultValue, new HeaderFormat(hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix));
        }
        if (this.headerRichiestaUscita != null && !this.headerRichiestaUscita.isEmpty()) {
            return this.formatHeaders(this.filterHeaders(this.headerRichiestaUscita, this.headerRichiestaUscitaConsumati), defaultValue, new HeaderFormat(hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix));
        }
        String s = null;
        return this.correctValue(s, defaultValue);
    }

    public String getInResponseContentType() {
        return this.getInResponseContentType(null);
    }

    public String getInResponseContentType(String defaultValue) {
        String s = null;
        if (this.rispostaIngresso != null) {
            s = this.rispostaIngresso.getContentType();
        }
        return this.correctValue(s, defaultValue);
    }

    public String getInResponseContent() {
        return this.getInResponseContent(null);
    }

    public String getInResponseContent(String defaultValue) {
        byte[] c = null;
        if (this.rispostaIngresso != null && this.rispostaIngresso.getBody() != null && this.rispostaIngresso.getBody().size() > 0) {
            c = this.rispostaIngresso.getBody().toByteArray();
        }
        return this.correctByteArray(c, defaultValue);
    }

    public int getInResponseSize() {
        return this.getInResponseSize(null);
    }

    public int getInResponseSize(String defaultValue) {
        byte[] c = null;
        if (this.rispostaIngresso != null && this.rispostaIngresso.getBody() != null && this.rispostaIngresso.getBody().size() > 0) {
            c = this.rispostaIngresso.getBody().toByteArray();
        }
        int size = 0;
        if (c != null) {
            size = c.length;
        } else if (this.transazione.getRispostaIngressoBytes() != null) {
            size = this.transazione.getRispostaIngressoBytes().intValue();
        }
        return this.correctInteger(size, defaultValue);
    }

    public String getInResponseHeader(String name) {
        return this.getInResponseHeader(name, this.headerMultiValueSeparator, false);
    }

    public String getInResponseHeader(String name, String multiValueSeparator) {
        return this.getInResponseHeader(name, multiValueSeparator, false);
    }

    public String removeInResponseHeader(String name) {
        return this.getInResponseHeader(name, this.headerMultiValueSeparator, true);
    }

    public String removeInResponseHeader(String name, String multiValueSeparator) {
        return this.getInResponseHeader(name, multiValueSeparator, true);
    }

    private String getInResponseHeader(String name, String multiValueSeparator, boolean consume) {
        String s = null;
        if (this.rispostaIngresso != null && this.rispostaIngresso.getHeaders() != null) {
            List values = (List)TransportUtils.getRawObject((Map)this.rispostaIngresso.getHeaders(), (String)name);
            s = this.format(values, multiValueSeparator);
        }
        if (consume) {
            this.headerRispostaIngressoConsumati.add(name);
        }
        return this.correctValue(s, null);
    }

    public String getInResponseHeaders() {
        return this.getInResponseHeaders(null, null, null, null, null);
    }

    public String getInResponseHeaders(String defaultValue) {
        return this.getInResponseHeaders(defaultValue, null, null, null, null);
    }

    public String getInResponseHeaders(String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        return this.getInResponseHeaders(null, hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix);
    }

    public String getInResponseHeaders(String defaultValue, String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        if (this.rispostaIngresso != null) {
            return this.formatHeaders(this.filterHeaders(this.rispostaIngresso.getHeaders(), this.headerRispostaIngressoConsumati), defaultValue, new HeaderFormat(hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix));
        }
        String s = null;
        return this.correctValue(s, defaultValue);
    }

    public String getOutResponseContentType() {
        return this.getOutResponseContentType(null);
    }

    public String getOutResponseContentType(String defaultValue) {
        String s = null;
        if (this.rispostaUscita != null) {
            s = this.rispostaUscita.getContentType();
        } else if (this.headerRispostaUscita != null && !this.headerRispostaUscita.isEmpty()) {
            s = TransportUtils.getFirstValue(this.headerRispostaUscita, (String)"Content-Type");
        }
        return this.correctValue(s, defaultValue);
    }

    public String getOutResponseContent() {
        return this.getOutResponseContent(null);
    }

    public String getOutResponseContent(String defaultValue) {
        byte[] c = null;
        if (this.rispostaUscita != null && this.rispostaUscita.getBody() != null && this.rispostaUscita.getBody().size() > 0) {
            c = this.rispostaUscita.getBody().toByteArray();
        }
        return this.correctByteArray(c, defaultValue);
    }

    public int getOutResponseSize() {
        return this.getOutResponseSize(null);
    }

    public int getOutResponseSize(String defaultValue) {
        byte[] c = null;
        if (this.rispostaUscita != null && this.rispostaUscita.getBody() != null && this.rispostaUscita.getBody().size() > 0) {
            c = this.rispostaUscita.getBody().toByteArray();
        }
        int size = 0;
        if (c != null) {
            size = c.length;
        } else if (this.transazione.getRispostaUscitaBytes() != null) {
            size = this.transazione.getRispostaUscitaBytes().intValue();
        }
        return this.correctInteger(size, defaultValue);
    }

    public String getOutResponseHeader(String name) {
        return this.getOutResponseHeader(name, this.headerMultiValueSeparator, false);
    }

    public String getOutResponseHeader(String name, String multiValueSeparator) {
        return this.getOutResponseHeader(name, multiValueSeparator, false);
    }

    public String removeOutResponseHeader(String name) {
        return this.getOutResponseHeader(name, this.headerMultiValueSeparator, true);
    }

    public String removeOutResponseHeader(String name, String multiValueSeparator) {
        return this.getOutResponseHeader(name, multiValueSeparator, true);
    }

    private String getOutResponseHeader(String name, String multiValueSeparator, boolean consume) {
        String s = null;
        if (this.rispostaUscita != null && this.rispostaUscita.getHeaders() != null) {
            List values = (List)TransportUtils.getRawObject((Map)this.rispostaUscita.getHeaders(), (String)name);
            s = this.format(values, multiValueSeparator);
        } else if (this.headerRispostaUscita != null && !this.headerRispostaUscita.isEmpty()) {
            List values = (List)TransportUtils.getRawObject(this.headerRispostaUscita, (String)name);
            s = this.format(values, multiValueSeparator);
        }
        if (consume) {
            this.headerRispostaUscitaConsumati.add(name);
        }
        return this.correctValue(s, null);
    }

    public String getOutResponseHeaders() {
        return this.getOutResponseHeaders(null, null, null, null, null);
    }

    public String getOutResponseHeaders(String defaultValue) {
        return this.getOutResponseHeaders(defaultValue, null, null, null, null);
    }

    public String getOutResponseHeaders(String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        return this.getOutResponseHeaders(null, hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix);
    }

    public String getOutResponseHeaders(String defaultValue, String hdrsSeparator, String hdrSeparator, String hdrPrefix, String hdrSuffix) {
        if (this.rispostaUscita != null) {
            return this.formatHeaders(this.filterHeaders(this.rispostaUscita.getHeaders(), this.headerRispostaUscitaConsumati), defaultValue, new HeaderFormat(hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix));
        }
        if (this.headerRispostaUscita != null && !this.headerRispostaUscita.isEmpty()) {
            return this.formatHeaders(this.filterHeaders(this.headerRispostaUscita, this.headerRispostaUscitaConsumati), defaultValue, new HeaderFormat(hdrsSeparator, hdrSeparator, hdrPrefix, hdrSuffix));
        }
        String s = null;
        return this.correctValue(s, defaultValue);
    }

    private String getPropertiesKeysEngine(String[] p, String separator, String defaultValue) {
        String v = null;
        if (p != null && p.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String key : p) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(key);
            }
            v = sb.toString();
        }
        return this.correctValue(v, defaultValue);
    }

    private String getPropertiesEngine(String[] pNames, String[] pValues, String propertySeparator, String valueSeparator, String defaultValue) {
        String v = null;
        if (pNames != null && pNames.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < pNames.length; ++i) {
                String key = pNames[i];
                if (sb.length() > 0) {
                    sb.append(propertySeparator);
                }
                sb.append(key);
                sb.append(valueSeparator);
                sb.append(pValues[i]);
            }
            return sb.toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getRequestProperty(String name) {
        return this.getRequestProperty(name, null);
    }

    public String getRequestProperty(String name, String defaultValue) {
        String s = null;
        if (this.tracciaRichiesta != null && this.tracciaRichiesta.getBusta() != null) {
            s = this.tracciaRichiesta.getBusta().getProperty(name);
        }
        return this.correctValue(s, defaultValue);
    }

    public String getRequestPropertiesKeys() {
        return this.getRequestPropertiesKeys(null);
    }

    public String getRequestPropertiesKeys(String defaultValue) {
        return this.getRequestPropertiesKeys(",", defaultValue);
    }

    public String getRequestPropertiesKeys(String separator, String defaultValue) {
        String[] p = this.tracciaRichiesta.getPropertiesNames();
        return this.getPropertiesKeysEngine(p, separator, defaultValue);
    }

    public String getRequestProperties() {
        return this.getRequestProperties(null);
    }

    public String getRequestProperties(String defaultValue) {
        return this.getRequestProperties(" ", "=", defaultValue);
    }

    public String getRequestProperties(String propertySeparator, String valueSeparator) {
        return this.getRequestProperties(propertySeparator, valueSeparator, null);
    }

    public String getRequestProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        String[] pNames = this.tracciaRichiesta.getPropertiesNames();
        String[] pValues = this.tracciaRichiesta.getPropertiesValues();
        return this.getPropertiesEngine(pNames, pValues, propertySeparator, valueSeparator, defaultValue);
    }

    public String getResponseProperty(String name) {
        return this.getResponseProperty(name, null);
    }

    public String getResponseProperty(String name, String defaultValue) {
        String s = null;
        if (this.tracciaRisposta != null && this.tracciaRisposta.getBusta() != null) {
            s = this.tracciaRisposta.getBusta().getProperty(name);
        }
        return this.correctValue(s, defaultValue);
    }

    public String getResponsePropertiesKeys() {
        return this.getResponsePropertiesKeys(null);
    }

    public String getResponsePropertiesKeys(String defaultValue) {
        return this.getResponsePropertiesKeys(",", defaultValue);
    }

    public String getResponsePropertiesKeys(String separator, String defaultValue) {
        String[] p = this.tracciaRisposta.getPropertiesNames();
        return this.getPropertiesKeysEngine(p, separator, defaultValue);
    }

    public String getResponseProperties() {
        return this.getResponseProperties(null);
    }

    public String getResponseProperties(String defaultValue) {
        return this.getResponseProperties(" ", "=", defaultValue);
    }

    public String getResponseProperties(String propertySeparator, String valueSeparator) {
        return this.getResponseProperties(propertySeparator, valueSeparator, null);
    }

    public String getResponseProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        String[] pNames = this.tracciaRisposta.getPropertiesNames();
        String[] pValues = this.tracciaRisposta.getPropertiesValues();
        return this.getPropertiesEngine(pNames, pValues, propertySeparator, valueSeparator, defaultValue);
    }

    public String getTokenModIAuthorizationRaw() {
        return this.getTokenModIAuthorizationRaw(null);
    }

    public String getTokenModIAuthorizationRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            v = (String)((Object)this.securityToken.getAuthorization().getToken());
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationHeaderRaw() {
        return this.getTokenModIAuthorizationHeaderRaw(null);
    }

    public String getTokenModIAuthorizationHeaderRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            v = this.securityToken.getAuthorization().getHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationDecodedHeader() {
        return this.getTokenModIAuthorizationDecodedHeader(null);
    }

    public String getTokenModIAuthorizationDecodedHeader(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            v = this.securityToken.getAuthorization().getDecodedHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationHeaderClaim(String tokenClaim) {
        return this.getTokenModIAuthorizationHeaderClaim(tokenClaim, null);
    }

    public String getTokenModIAuthorizationHeaderClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            try {
                v = this.securityToken.getAuthorization().getHeaderClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuthorizationHeaderClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationHeaderClaims() {
        return this.getTokenModIAuthorizationHeaderClaims(",", "=", null);
    }

    public String getTokenModIAuthorizationHeaderClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            try {
                Map map = this.securityToken.getAuthorization().getHeaderClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuthorizationHeaderClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationPayloadRaw() {
        return this.getTokenModIAuthorizationPayloadRaw(null);
    }

    public String getTokenModIAuthorizationPayloadRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            v = this.securityToken.getAuthorization().getPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationDecodedPayload() {
        return this.getTokenModIAuthorizationDecodedPayload(null);
    }

    public String getTokenModIAuthorizationDecodedPayload(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            v = this.securityToken.getAuthorization().getDecodedPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationPayloadClaim(String tokenClaim) {
        return this.getTokenModIAuthorizationPayloadClaim(tokenClaim, null);
    }

    public String getTokenModIAuthorizationPayloadClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            try {
                v = this.securityToken.getAuthorization().getPayloadClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuthorizationPayloadClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationPayloadClaims() {
        return this.getTokenModIAuthorizationPayloadClaims(",", "=", null);
    }

    public String getTokenModIAuthorizationPayloadClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null) {
            try {
                Map map = this.securityToken.getAuthorization().getPayloadClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuthorizationPayloadClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationCertificateSubjectDN() {
        return this.getTokenModIAuthorizationCertificateSubjectDN(null);
    }

    public String getTokenModIAuthorizationCertificateSubjectDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null && this.securityToken.getAuthorization().getCertificate() != null && this.securityToken.getAuthorization().getCertificate().getSubject() != null) {
            v = this.securityToken.getAuthorization().getCertificate().getSubject().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationCertificateSubjectCN() {
        return this.getTokenModIAuthorizationCertificateSubjectCN(null);
    }

    public String getTokenModIAuthorizationCertificateSubjectCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null && this.securityToken.getAuthorization().getCertificate() != null && this.securityToken.getAuthorization().getCertificate().getSubject() != null) {
            v = this.securityToken.getAuthorization().getCertificate().getSubject().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationCertificateSubjectDNInfo(String oid) {
        return this.getTokenModIAuthorizationCertificateSubjectDNInfo(oid, null);
    }

    public String getTokenModIAuthorizationCertificateSubjectDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null && this.securityToken.getAuthorization().getCertificate() != null && this.securityToken.getAuthorization().getCertificate().getSubject() != null) {
            v = this.securityToken.getAuthorization().getCertificate().getSubject().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationCertificateIssuerDN() {
        return this.getTokenModIAuthorizationCertificateIssuerDN(null);
    }

    public String getTokenModIAuthorizationCertificateIssuerDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null && this.securityToken.getAuthorization().getCertificate() != null && this.securityToken.getAuthorization().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAuthorization().getCertificate().getIssuer().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationCertificateIssuerCN() {
        return this.getTokenModIAuthorizationCertificateIssuerCN(null);
    }

    public String getTokenModIAuthorizationCertificateIssuerCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null && this.securityToken.getAuthorization().getCertificate() != null && this.securityToken.getAuthorization().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAuthorization().getCertificate().getIssuer().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuthorizationCertificateIssuerDNInfo(String oid) {
        return this.getTokenModIAuthorizationCertificateIssuerDNInfo(oid, null);
    }

    public String getTokenModIAuthorizationCertificateIssuerDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAuthorization() != null && this.securityToken.getAuthorization().getCertificate() != null && this.securityToken.getAuthorization().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAuthorization().getCertificate().getIssuer().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityRaw() {
        return this.getTokenModIIntegrityRaw(null);
    }

    public String getTokenModIIntegrityRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            v = (String)((Object)this.securityToken.getIntegrity().getToken());
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityHeaderRaw() {
        return this.getTokenModIIntegrityHeaderRaw(null);
    }

    public String getTokenModIIntegrityHeaderRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            v = this.securityToken.getIntegrity().getHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityDecodedHeader() {
        return this.getTokenModIIntegrityDecodedHeader(null);
    }

    public String getTokenModIIntegrityDecodedHeader(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            v = this.securityToken.getIntegrity().getDecodedHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityHeaderClaim(String tokenClaim) {
        return this.getTokenModIIntegrityHeaderClaim(tokenClaim, null);
    }

    public String getTokenModIIntegrityHeaderClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            try {
                v = this.securityToken.getIntegrity().getHeaderClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenModIIntegrityHeaderClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityHeaderClaims() {
        return this.getTokenModIIntegrityHeaderClaims(",", "=", null);
    }

    public String getTokenModIIntegrityHeaderClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            try {
                Map map = this.securityToken.getIntegrity().getHeaderClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenModIIntegrityHeaderClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityPayloadRaw() {
        return this.getTokenModIIntegrityPayloadRaw(null);
    }

    public String getTokenModIIntegrityPayloadRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            v = this.securityToken.getIntegrity().getPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityDecodedPayload() {
        return this.getTokenModIIntegrityDecodedPayload(null);
    }

    public String getTokenModIIntegrityDecodedPayload(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            v = this.securityToken.getIntegrity().getDecodedPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityPayloadClaim(String tokenClaim) {
        return this.getTokenModIIntegrityPayloadClaim(tokenClaim, null);
    }

    public String getTokenModIIntegrityPayloadClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            try {
                v = this.securityToken.getIntegrity().getPayloadClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenModIIntegrityPayloadClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityPayloadClaims() {
        return this.getTokenModIIntegrityPayloadClaims(",", "=", null);
    }

    public String getTokenModIIntegrityPayloadClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null) {
            try {
                Map map = this.securityToken.getIntegrity().getPayloadClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenModIIntegrityPayloadClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityCertificateSubjectDN() {
        return this.getTokenModIIntegrityCertificateSubjectDN(null);
    }

    public String getTokenModIIntegrityCertificateSubjectDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null && this.securityToken.getIntegrity().getCertificate() != null && this.securityToken.getIntegrity().getCertificate().getSubject() != null) {
            v = this.securityToken.getIntegrity().getCertificate().getSubject().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityCertificateSubjectCN() {
        return this.getTokenModIIntegrityCertificateSubjectCN(null);
    }

    public String getTokenModIIntegrityCertificateSubjectCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null && this.securityToken.getIntegrity().getCertificate() != null && this.securityToken.getIntegrity().getCertificate().getSubject() != null) {
            v = this.securityToken.getIntegrity().getCertificate().getSubject().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityCertificateSubjectDNInfo(String oid) {
        return this.getTokenModIIntegrityCertificateSubjectDNInfo(oid, null);
    }

    public String getTokenModIIntegrityCertificateSubjectDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null && this.securityToken.getIntegrity().getCertificate() != null && this.securityToken.getIntegrity().getCertificate().getSubject() != null) {
            v = this.securityToken.getIntegrity().getCertificate().getSubject().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityCertificateIssuerDN() {
        return this.getTokenModIIntegrityCertificateIssuerDN(null);
    }

    public String getTokenModIIntegrityCertificateIssuerDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null && this.securityToken.getIntegrity().getCertificate() != null && this.securityToken.getIntegrity().getCertificate().getIssuer() != null) {
            v = this.securityToken.getIntegrity().getCertificate().getIssuer().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityCertificateIssuerCN() {
        return this.getTokenModIIntegrityCertificateIssuerCN(null);
    }

    public String getTokenModIIntegrityCertificateIssuerCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null && this.securityToken.getIntegrity().getCertificate() != null && this.securityToken.getIntegrity().getCertificate().getIssuer() != null) {
            v = this.securityToken.getIntegrity().getCertificate().getIssuer().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIIntegrityCertificateIssuerDNInfo(String oid) {
        return this.getTokenModIIntegrityCertificateIssuerDNInfo(oid, null);
    }

    public String getTokenModIIntegrityCertificateIssuerDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getIntegrity() != null && this.securityToken.getIntegrity().getCertificate() != null && this.securityToken.getIntegrity().getCertificate().getIssuer() != null) {
            v = this.securityToken.getIntegrity().getCertificate().getIssuer().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditRaw() {
        return this.getTokenModIAuditRaw(null);
    }

    public String getTokenModIAuditRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            v = (String)((Object)this.securityToken.getAudit().getToken());
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditHeaderRaw() {
        return this.getTokenModIAuditHeaderRaw(null);
    }

    public String getTokenModIAuditHeaderRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            v = this.securityToken.getAudit().getHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditDecodedHeader() {
        return this.getTokenModIAuditDecodedHeader(null);
    }

    public String getTokenModIAuditDecodedHeader(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            v = this.securityToken.getAudit().getDecodedHeader();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditHeaderClaim(String tokenClaim) {
        return this.getTokenModIAuditHeaderClaim(tokenClaim, null);
    }

    public String getTokenModIAuditHeaderClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            try {
                v = this.securityToken.getAudit().getHeaderClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuditHeaderClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditHeaderClaims() {
        return this.getTokenModIAuditHeaderClaims(",", "=", null);
    }

    public String getTokenModIAuditHeaderClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            try {
                Map map = this.securityToken.getAudit().getHeaderClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuditHeaderClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditPayloadRaw() {
        return this.getTokenModIAuditPayloadRaw(null);
    }

    public String getTokenModIAuditPayloadRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            v = this.securityToken.getAudit().getPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditDecodedPayload() {
        return this.getTokenModIAuditDecodedPayload(null);
    }

    public String getTokenModIAuditDecodedPayload(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            v = this.securityToken.getAudit().getDecodedPayload();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditPayloadClaim(String tokenClaim) {
        return this.getTokenModIAuditPayloadClaim(tokenClaim, null);
    }

    public String getTokenModIAuditPayloadClaim(String tokenClaim, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            try {
                v = this.securityToken.getAudit().getPayloadClaim(tokenClaim);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuditPayloadClaim(" + tokenClaim + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditPayloadClaims() {
        return this.getTokenModIAuditPayloadClaims(",", "=", null);
    }

    public String getTokenModIAuditPayloadClaims(String claimSeparator, String nameValueSeparator, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null) {
            try {
                Map map = this.securityToken.getAudit().getPayloadClaims();
                v = this.formatTokenClaims(map, claimSeparator, nameValueSeparator);
            }
            catch (Exception t) {
                this.log.error("getTokenModIAuditPayloadClaims(" + claimSeparator + "," + nameValueSeparator + ")" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditCertificateSubjectDN() {
        return this.getTokenModIAuditCertificateSubjectDN(null);
    }

    public String getTokenModIAuditCertificateSubjectDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null && this.securityToken.getAudit().getCertificate() != null && this.securityToken.getAudit().getCertificate().getSubject() != null) {
            v = this.securityToken.getAudit().getCertificate().getSubject().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditCertificateSubjectCN() {
        return this.getTokenModIAuditCertificateSubjectCN(null);
    }

    public String getTokenModIAuditCertificateSubjectCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null && this.securityToken.getAudit().getCertificate() != null && this.securityToken.getAudit().getCertificate().getSubject() != null) {
            v = this.securityToken.getAudit().getCertificate().getSubject().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditCertificateSubjectDNInfo(String oid) {
        return this.getTokenModIAuditCertificateSubjectDNInfo(oid, null);
    }

    public String getTokenModIAuditCertificateSubjectDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null && this.securityToken.getAudit().getCertificate() != null && this.securityToken.getAudit().getCertificate().getSubject() != null) {
            v = this.securityToken.getAudit().getCertificate().getSubject().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditCertificateIssuerDN() {
        return this.getTokenModIAuditCertificateIssuerDN(null);
    }

    public String getTokenModIAuditCertificateIssuerDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null && this.securityToken.getAudit().getCertificate() != null && this.securityToken.getAudit().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAudit().getCertificate().getIssuer().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditCertificateIssuerCN() {
        return this.getTokenModIAuditCertificateIssuerCN(null);
    }

    public String getTokenModIAuditCertificateIssuerCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null && this.securityToken.getAudit().getCertificate() != null && this.securityToken.getAudit().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAudit().getCertificate().getIssuer().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModIAuditCertificateIssuerDNInfo(String oid) {
        return this.getTokenModIAuditCertificateIssuerDNInfo(oid, null);
    }

    public String getTokenModIAuditCertificateIssuerDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getAudit() != null && this.securityToken.getAudit().getCertificate() != null && this.securityToken.getAudit().getCertificate().getIssuer() != null) {
            v = this.securityToken.getAudit().getCertificate().getIssuer().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModISoapRaw() {
        return this.getTokenModISoapRaw(null);
    }

    public String getTokenModISoapRaw(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getEnvelope() != null) {
            try {
                XMLUtils xmlUtils = XMLUtils.getInstance();
                v = xmlUtils.toString((Element)this.securityToken.getEnvelope().getToken(), true);
            }
            catch (Exception t) {
                this.log.error("getTokenModISoapRaw" + this.getErrorSuffix(t), (Throwable)t);
            }
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModISoapCertificateSubjectDN() {
        return this.getTokenModISoapCertificateSubjectDN(null);
    }

    public String getTokenModISoapCertificateSubjectDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getEnvelope() != null && this.securityToken.getEnvelope().getCertificate() != null && this.securityToken.getEnvelope().getCertificate().getSubject() != null) {
            v = this.securityToken.getEnvelope().getCertificate().getSubject().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModISoapCertificateSubjectCN() {
        return this.getTokenModISoapCertificateSubjectCN(null);
    }

    public String getTokenModISoapCertificateSubjectCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getEnvelope() != null && this.securityToken.getEnvelope().getCertificate() != null && this.securityToken.getEnvelope().getCertificate().getSubject() != null) {
            v = this.securityToken.getEnvelope().getCertificate().getSubject().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModISoapCertificateSubjectDNInfo(String oid) {
        return this.getTokenModISoapCertificateSubjectDNInfo(oid, null);
    }

    public String getTokenModISoapCertificateSubjectDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getEnvelope() != null && this.securityToken.getEnvelope().getCertificate() != null && this.securityToken.getEnvelope().getCertificate().getSubject() != null) {
            v = this.securityToken.getEnvelope().getCertificate().getSubject().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModISoapCertificateIssuerDN() {
        return this.getTokenModISoapCertificateIssuerDN(null);
    }

    public String getTokenModISoapCertificateIssuerDN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getEnvelope() != null && this.securityToken.getEnvelope().getCertificate() != null && this.securityToken.getEnvelope().getCertificate().getIssuer() != null) {
            v = this.securityToken.getEnvelope().getCertificate().getIssuer().toString();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModISoapCertificateIssuerCN() {
        return this.getTokenModISoapCertificateIssuerCN(null);
    }

    public String getTokenModISoapCertificateIssuerCN(String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getEnvelope() != null && this.securityToken.getEnvelope().getCertificate() != null && this.securityToken.getEnvelope().getCertificate().getIssuer() != null) {
            v = this.securityToken.getEnvelope().getCertificate().getIssuer().getCN();
        }
        return this.correctValue(v, defaultValue);
    }

    public String getTokenModISoapCertificateIssuerDNInfo(String oid) {
        return this.getTokenModISoapCertificateIssuerDNInfo(oid, null);
    }

    public String getTokenModISoapCertificateIssuerDNInfo(String oid, String defaultValue) {
        String v = null;
        if (this.securityToken != null && this.securityToken.getEnvelope() != null && this.securityToken.getEnvelope().getCertificate() != null && this.securityToken.getEnvelope().getCertificate().getIssuer() != null) {
            v = this.securityToken.getEnvelope().getCertificate().getIssuer().getInfo(oid);
        }
        return this.correctValue(v, defaultValue);
    }

    public String getHostAddress() {
        return this.getHostAddress(null);
    }

    public String getHostAddress(String defaultValue) {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            this.log.error("local ip: " + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getHostName() {
        return this.getHostName(null);
    }

    public String getHostName(String defaultValue) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.log.error("local hostname: " + e.getMessage(), (Throwable)e);
            return this.correctValue(null, defaultValue);
        }
    }

    public String getSystemProperty(String name) {
        return this.getSystemProperty(name, null);
    }

    public String getSystemProperty(String name, String defaultValue) {
        String s = System.getenv(name);
        return this.correctValue(s, defaultValue);
    }

    public String getJavaProperty(String name) {
        return this.getJavaProperty(name, null);
    }

    public String getJavaProperty(String name, String defaultValue) {
        String s = System.getProperty(name);
        return this.correctValue(s, defaultValue);
    }

    public String getProperty(String name) throws CoreException {
        return this.getPropertyEngine(name, null, true);
    }

    public String getProperty(String name, String defaultValue) throws CoreException {
        return this.getPropertyEngine(name, defaultValue, false);
    }

    private String getPropertyEngine(String name, String defaultValue, boolean required) throws CoreException {
        String s;
        String string = s = this.properties != null ? this.properties.get(name) : null;
        if (s == null && required) {
            throw new CoreException("Property '" + name + "' not found");
        }
        boolean escapeV = true;
        return this.correctValue(s, defaultValue, !escapeV);
    }

    protected void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getPropertyUnion(String left, String right, String separator) throws CoreException {
        return this.getPropertyUnion(left, right, separator, null);
    }

    public String getPropertyUnion(String left, String right, String separator, String defaultValue) throws CoreException {
        String pRight;
        StringBuilder sb = new StringBuilder();
        String pLeft = this.getProperty(left, left);
        if (pLeft != null && pLeft.length() > 0) {
            sb.append(pLeft);
        }
        if ((pRight = this.getProperty(right, right)) != null && pRight.length() > 0) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(pRight);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return this.correctValue(null, defaultValue);
    }

    public String getContextProperty(String name) {
        return this.getContextProperty(name, null);
    }

    public String getContextProperty(String name, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getContextProperty(name), defaultValue);
    }

    public String getContextPropertiesKeys() {
        return this.getContextPropertiesKeys(null);
    }

    public String getContextPropertiesKeys(String defaultValue) {
        return this.getContextPropertiesKeys(",", defaultValue);
    }

    public String getContextPropertiesKeys(String separator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getContextPropertiesKeysAsString(separator), defaultValue);
    }

    public String getContextProperties() {
        return this.getContextProperties(null);
    }

    public String getContextProperties(String defaultValue) {
        return this.getContextProperties(" ", "=", defaultValue);
    }

    public String getContextProperties(String propertySeparator, String valueSeparator) {
        return this.getContextProperties(propertySeparator, valueSeparator, null);
    }

    public String getContextProperties(String propertySeparator, String valueSeparator, String defaultValue) {
        return this.correctValue(this.infoConfigurazione.getContextPropertiesAsString(propertySeparator, valueSeparator), defaultValue);
    }

    public String getTrackingPhase() {
        return this.trackingPhase != null ? this.trackingPhase.name() : "-";
    }

    private String escape(String v) {
        if (this.escape != null && !this.escape.isEmpty()) {
            Set<String> specialCharacters = this.escape.keySet();
            boolean found = false;
            for (String specialChar : specialCharacters) {
                if (!v.contains(specialChar)) continue;
                found = true;
                break;
            }
            if (!found) {
                return v;
            }
            return this.escapeEngine(v, specialCharacters);
        }
        return v;
    }

    private String escapeEngine(String v, Set<String> specialCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length(); ++i) {
            String charAtI = "" + v.charAt(i);
            boolean foundSpecialChar = false;
            for (String specialChar : specialCharacters) {
                if (!charAtI.equals(specialChar)) continue;
                String escapeChar = this.escape.get(specialChar);
                sb.append(escapeChar);
                foundSpecialChar = true;
                break;
            }
            if (foundSpecialChar) continue;
            sb.append(charAtI);
        }
        return sb.toString();
    }

    private String correctValue(String v, String defaultValueParam) {
        return this.correctValue(v, defaultValueParam, true);
    }

    private String correctValue(String v, String defaultValueParam, boolean escape) {
        return this.correctValue(v, defaultValueParam, escape, true);
    }

    private String correctValue(String v, String defaultValueParam, boolean escape, boolean useBase64option) {
        String defaultValueTmp = this.defaultValue;
        if (defaultValueParam != null) {
            defaultValueTmp = defaultValueParam;
        }
        String res = null;
        if (escape && !this.base64) {
            res = v != null ? this.escape(v) : defaultValueTmp;
        } else {
            String string = res = v != null ? v : defaultValueTmp;
        }
        if (useBase64option && this.base64 && res != null && res.length() > 0) {
            return Base64Utilities.encodeAsString((byte[])res.getBytes());
        }
        return res;
    }

    private String correctDate(Date d, String format, String timeZone, String defaultValueParam, String replace, String with) {
        if (d == null) {
            return this.correctValue(null, defaultValueParam);
        }
        String v = this.correctDateWithoutCorrectValue(d, format, timeZone, replace, with);
        return this.correctValue(v, defaultValueParam);
    }

    private String correctDateWithoutCorrectValue(Date d, String format, String timeZone, String replace, String with) {
        DateTimeFormatterWrapper formatter = null;
        if (timeZone == null) {
            formatter = DateUtils.getDateFormatter_ISO_8601_TZ((DateEngineType)DateEngineType.JAVA_UTIL, (String)format);
        } else {
            formatter = DateUtils.getDateFormatter((DateEngineType)DateEngineType.JAVA_UTIL, (String)format);
            formatter.setTimeZone(TimeZone.getTimeZone(timeZone));
        }
        String v = formatter.format(d);
        if (replace != null && with != null) {
            v = v.replaceAll(replace, with);
        }
        return v;
    }

    private long correctLong(Long v, String defaultValueParam) {
        long defaultValueTmp = this.defaultLongValue;
        if (defaultValueParam != null) {
            defaultValueTmp = Long.valueOf(defaultValueParam);
        }
        return v != null && v >= 0L ? v : defaultValueTmp;
    }

    private int correctInteger(Integer v, String defaultValueParam) {
        int defaultValueTmp = this.defaultIntegerValue;
        if (defaultValueParam != null) {
            defaultValueTmp = Integer.valueOf(defaultValueParam);
        }
        return v != null && v >= 0 ? v : defaultValueTmp;
    }

    private String correctByteArray(byte[] v, String defaultValueParam) {
        String s = null;
        if (v != null && v.length > 0) {
            s = this.base64 ? Base64Utilities.encodeAsString((byte[])v) : new String(v);
        }
        String defaultValueTmp = this.defaultValue;
        if (defaultValueParam != null) {
            defaultValueTmp = defaultValueParam;
        }
        return s != null ? this.escape(s) : defaultValueTmp;
    }

    private String formatHeaders(Map<String, List<String>> mapParam, String defaultValueParam, HeaderFormat headerFormat) {
        Map<String, List<String>> map = null;
        if (mapParam != null && !mapParam.isEmpty()) {
            map = this.headerWhiteList != null && !this.headerWhiteList.isEmpty() ? this.filterHeaders(true, this.headerWhiteList, mapParam) : (this.headerBlackList != null && !this.headerBlackList.isEmpty() ? this.filterHeaders(false, this.headerBlackList, mapParam) : mapParam);
        }
        return this.formatHeadersEngine(map, defaultValueParam, headerFormat);
    }

    private Map<String, List<String>> filterHeaders(boolean white, List<String> filterList, Map<String, List<String>> sourceHeaders) {
        HashMap<String, List<String>> map = null;
        if (filterList != null && !filterList.isEmpty()) {
            map = new HashMap<String, List<String>>();
            this.filterHeaders(map, white, filterList, sourceHeaders);
        }
        return map;
    }

    private void filterHeaders(Map<String, List<String>> map, boolean white, List<String> filterList, Map<String, List<String>> sourceHeaders) {
        for (Map.Entry<String, List<String>> entry : sourceHeaders.entrySet()) {
            String hdr = entry.getKey();
            boolean find = false;
            for (String filterHdr : filterList) {
                if (!filterHdr.equalsIgnoreCase(hdr)) continue;
                find = true;
                break;
            }
            if (white) {
                if (!find) continue;
                map.put(hdr, sourceHeaders.get(hdr));
                continue;
            }
            if (find) continue;
            map.put(hdr, sourceHeaders.get(hdr));
        }
    }

    private String formatHeadersEngine(Map<String, List<String>> map, String defaultValueParam, HeaderFormat headerFormat) {
        if (map != null && !map.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String hdr = entry.getKey();
                if ("ReturnCode".equals(hdr)) continue;
                this.formatHeadersEngine(sb, map, hdr, defaultValueParam, headerFormat);
            }
            String res = sb.toString();
            if (this.base64 && res != null && res.length() > 0) {
                return Base64Utilities.encodeAsString((byte[])res.getBytes());
            }
            return res;
        }
        return this.correctValue(null, defaultValueParam);
    }

    private void formatHeadersEngine(StringBuilder sb, Map<String, List<String>> map, String hdr, String defaultValueParam, HeaderFormat headerFormat) {
        List<String> hdrValues = map.get(hdr);
        if (hdrValues != null && !hdrValues.isEmpty()) {
            for (String hdrValue : hdrValues) {
                this.formatHeadersEngine(sb, hdr, defaultValueParam, headerFormat, hdrValue);
            }
        }
    }

    private void formatHeadersEngine(StringBuilder sb, String hdr, String defaultValueParam, HeaderFormat headerFormat, String hdrValue) {
        if (sb.length() > 0) {
            sb.append(headerFormat.hdrsSeparator == null ? this.headersSeparator : headerFormat.hdrsSeparator);
        }
        sb.append(headerFormat.hdrPrefix == null ? this.headerPrefix : headerFormat.hdrPrefix);
        sb.append(this.correctValue(hdr, defaultValueParam, true, false));
        sb.append(headerFormat.hdrSeparator == null ? this.headerSeparator : headerFormat.hdrSeparator);
        sb.append(this.correctValue(hdrValue, defaultValueParam, true, false));
        sb.append(headerFormat.hdrSuffix == null ? this.headerSuffix : headerFormat.hdrSuffix);
    }

    private String format(List<String> values, String separator) {
        String s = null;
        if (values != null && !values.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String value : values) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(value);
            }
            s = sb.toString();
        }
        return s;
    }

    private String formatTokenClaims(Map<String, String> map, String claimSeparator, String nameValueSeparator) {
        String s = null;
        if (map != null && !map.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = map.get(key);
                if (sb.length() > 0) {
                    sb.append(claimSeparator);
                }
                sb.append(key);
                sb.append(nameValueSeparator);
                sb.append(value != null ? value : "");
            }
            s = sb.toString();
        }
        return s;
    }

    private Map<String, List<String>> filterHeaders(Map<String, List<String>> header, List<String> headerConsumati) {
        if (headerConsumati == null || headerConsumati.isEmpty()) {
            return header;
        }
        HashMap<String, List<String>> newMap = null;
        if (header != null) {
            newMap = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : header.entrySet()) {
                boolean exists = false;
                for (String h : headerConsumati) {
                    if (!h.equalsIgnoreCase(entry.getKey())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
        }
        return newMap;
    }
}

