/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.record;

import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.logger.record.AbstractDatoRicostruzione;
import org.openspcoop2.pdd.logger.record.InfoDato;

public class StringDatoRicostruzione
extends AbstractDatoRicostruzione<String> {
    public StringDatoRicostruzione(InfoDato info, String dato, boolean checkSeparator) throws CoreException {
        super(info, dato);
        if (checkSeparator && dato != null && dato.contains(" ")) {
            throw new CoreException("Il dato [" + dato + "] contiene il carattere separatore [ ]");
        }
    }

    public StringDatoRicostruzione(String dato, InfoDato info) throws CoreException {
        super(dato, info);
    }

    @Override
    public String convertToString() {
        if (this.dato == null) {
            return "-";
        }
        return (String)this.dato;
    }

    @Override
    protected String convertToObject(String dato) throws CoreException {
        if (dato == null) {
            throw new CoreException("Dato non fornito");
        }
        if ("-".equals(dato)) {
            return null;
        }
        return dato;
    }
}

