/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.transazioni;

import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.IdDumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.core.transazioni.dao.IDumpMessaggioService;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.config.TransactionResource;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.transaction.TransactionContentUtils;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class ContenutiUtilities {
    private Logger logger;

    public ContenutiUtilities(Logger log) {
        this.logger = log;
    }

    public void insertContenuti(Transazione transactionDTO, Traccia tracciaRichiesta, Traccia tracciaRisposta, List<MsgDiagnostico> msgDiagnostici, IDumpMessaggioService dumpMessageService, List<TransactionResource> risorse, TransactionServiceLibrary transactionServiceLibrary, DAOFactory daoFactory) throws HandlerException {
        try {
            boolean updateRichiestaIngresso = false;
            boolean updateRichiestaUscita = false;
            boolean updateRispostaIngresso = false;
            boolean updateRispostaUscita = false;
            DumpMessaggio dumpMessaggioRichiestaIngresso = null;
            DumpMessaggio dumpMessaggioRichiestaUscita = null;
            DumpMessaggio dumpMessaggioRispostaIngresso = null;
            DumpMessaggio dumpMessaggioRispostaUscita = null;
            IdDumpMessaggio idDumpMessaggioRichiestaIngresso = new IdDumpMessaggio();
            idDumpMessaggioRichiestaIngresso.setIdTransazione(transactionDTO.getIdTransazione());
            idDumpMessaggioRichiestaIngresso.setTipoMessaggio(TipoMessaggio.RICHIESTA_INGRESSO);
            IdDumpMessaggio idDumpMessaggioRichiestaUscita = new IdDumpMessaggio();
            idDumpMessaggioRichiestaUscita.setIdTransazione(transactionDTO.getIdTransazione());
            idDumpMessaggioRichiestaUscita.setTipoMessaggio(TipoMessaggio.RICHIESTA_USCITA);
            IdDumpMessaggio idDumpMessaggioRispostaIngresso = new IdDumpMessaggio();
            idDumpMessaggioRispostaIngresso.setIdTransazione(transactionDTO.getIdTransazione());
            idDumpMessaggioRispostaIngresso.setTipoMessaggio(TipoMessaggio.RISPOSTA_INGRESSO);
            IdDumpMessaggio idDumpMessaggioRispostaUscita = new IdDumpMessaggio();
            idDumpMessaggioRispostaUscita.setIdTransazione(transactionDTO.getIdTransazione());
            idDumpMessaggioRispostaUscita.setTipoMessaggio(TipoMessaggio.RISPOSTA_USCITA);
            if (risorse != null && !risorse.isEmpty()) {
                for (TransactionResource risorsaCalcolata : risorse) {
                    DumpContenuto contenuto;
                    if (TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)risorsaCalcolata.getTipoMessaggio())) {
                        if (dumpMessaggioRichiestaIngresso == null) {
                            dumpMessaggioRichiestaIngresso = this.getSafe(dumpMessageService, idDumpMessaggioRichiestaIngresso);
                        }
                        if (dumpMessaggioRichiestaIngresso == null) {
                            dumpMessaggioRichiestaIngresso = new DumpMessaggio();
                            dumpMessaggioRichiestaIngresso.setIdTransazione(transactionDTO.getIdTransazione());
                            dumpMessaggioRichiestaIngresso.setTipoMessaggio(TipoMessaggio.RICHIESTA_INGRESSO);
                            dumpMessaggioRichiestaIngresso.setDumpTimestamp(DateManager.getDate());
                        }
                        contenuto = TransactionContentUtils.createDumpContenuto((String)risorsaCalcolata.getNome(), (String)risorsaCalcolata.getValore(), (Date)DateManager.getDate());
                        dumpMessaggioRichiestaIngresso.addContenuto(contenuto);
                        updateRichiestaIngresso = true;
                        continue;
                    }
                    if (TipoMessaggio.RICHIESTA_USCITA.equals((Object)risorsaCalcolata.getTipoMessaggio())) {
                        if (dumpMessaggioRichiestaUscita == null) {
                            dumpMessaggioRichiestaUscita = this.getSafe(dumpMessageService, idDumpMessaggioRichiestaUscita);
                        }
                        if (dumpMessaggioRichiestaUscita == null) {
                            dumpMessaggioRichiestaUscita = new DumpMessaggio();
                            dumpMessaggioRichiestaUscita.setIdTransazione(transactionDTO.getIdTransazione());
                            dumpMessaggioRichiestaUscita.setTipoMessaggio(TipoMessaggio.RICHIESTA_USCITA);
                            dumpMessaggioRichiestaUscita.setDumpTimestamp(DateManager.getDate());
                        }
                        contenuto = TransactionContentUtils.createDumpContenuto((String)risorsaCalcolata.getNome(), (String)risorsaCalcolata.getValore(), (Date)DateManager.getDate());
                        dumpMessaggioRichiestaUscita.addContenuto(contenuto);
                        updateRichiestaUscita = true;
                        continue;
                    }
                    if (TipoMessaggio.RISPOSTA_INGRESSO.equals((Object)risorsaCalcolata.getTipoMessaggio())) {
                        if (dumpMessaggioRispostaIngresso == null) {
                            dumpMessaggioRispostaIngresso = this.getSafe(dumpMessageService, idDumpMessaggioRispostaIngresso);
                        }
                        if (dumpMessaggioRispostaIngresso == null) {
                            dumpMessaggioRispostaIngresso = new DumpMessaggio();
                            dumpMessaggioRispostaIngresso.setIdTransazione(transactionDTO.getIdTransazione());
                            dumpMessaggioRispostaIngresso.setTipoMessaggio(TipoMessaggio.RISPOSTA_INGRESSO);
                            dumpMessaggioRispostaIngresso.setDumpTimestamp(DateManager.getDate());
                        }
                        contenuto = TransactionContentUtils.createDumpContenuto((String)risorsaCalcolata.getNome(), (String)risorsaCalcolata.getValore(), (Date)DateManager.getDate());
                        dumpMessaggioRispostaIngresso.addContenuto(contenuto);
                        updateRispostaIngresso = true;
                        continue;
                    }
                    if (!TipoMessaggio.RISPOSTA_USCITA.equals((Object)risorsaCalcolata.getTipoMessaggio())) continue;
                    if (dumpMessaggioRispostaUscita == null) {
                        dumpMessaggioRispostaUscita = this.getSafe(dumpMessageService, idDumpMessaggioRispostaUscita);
                    }
                    if (dumpMessaggioRispostaUscita == null) {
                        dumpMessaggioRispostaUscita = new DumpMessaggio();
                        dumpMessaggioRispostaUscita.setIdTransazione(transactionDTO.getIdTransazione());
                        dumpMessaggioRispostaUscita.setTipoMessaggio(TipoMessaggio.RISPOSTA_USCITA);
                        dumpMessaggioRispostaUscita.setDumpTimestamp(DateManager.getDate());
                    }
                    contenuto = TransactionContentUtils.createDumpContenuto((String)risorsaCalcolata.getNome(), (String)risorsaCalcolata.getValore(), (Date)DateManager.getDate());
                    dumpMessaggioRispostaUscita.addContenuto(contenuto);
                    updateRispostaUscita = true;
                }
            }
            if (dumpMessaggioRichiestaIngresso == null && transactionServiceLibrary != null) {
                dumpMessaggioRichiestaIngresso = new DumpMessaggio();
                dumpMessaggioRichiestaIngresso.setIdTransazione(transactionDTO.getIdTransazione());
                dumpMessaggioRichiestaIngresso.setTipoMessaggio(TipoMessaggio.RICHIESTA_INGRESSO);
                dumpMessaggioRichiestaIngresso.setDumpTimestamp(DateManager.getDate());
            }
            if (dumpMessaggioRichiestaUscita == null && transactionServiceLibrary != null) {
                dumpMessaggioRichiestaUscita = new DumpMessaggio();
                dumpMessaggioRichiestaUscita.setIdTransazione(transactionDTO.getIdTransazione());
                dumpMessaggioRichiestaUscita.setTipoMessaggio(TipoMessaggio.RICHIESTA_USCITA);
                dumpMessaggioRichiestaUscita.setDumpTimestamp(DateManager.getDate());
            }
            if (dumpMessaggioRispostaIngresso == null && transactionServiceLibrary != null) {
                dumpMessaggioRispostaIngresso = new DumpMessaggio();
                dumpMessaggioRispostaIngresso.setIdTransazione(transactionDTO.getIdTransazione());
                dumpMessaggioRispostaIngresso.setTipoMessaggio(TipoMessaggio.RISPOSTA_INGRESSO);
                dumpMessaggioRispostaIngresso.setDumpTimestamp(DateManager.getDate());
            }
            if (dumpMessaggioRispostaUscita == null && transactionServiceLibrary != null) {
                dumpMessaggioRispostaUscita = new DumpMessaggio();
                dumpMessaggioRispostaUscita.setIdTransazione(transactionDTO.getIdTransazione());
                dumpMessaggioRispostaUscita.setTipoMessaggio(TipoMessaggio.RISPOSTA_USCITA);
                dumpMessaggioRispostaUscita.setDumpTimestamp(DateManager.getDate());
            }
            boolean messaggioModificatoSDK = false;
            if (transactionServiceLibrary != null) {
                messaggioModificatoSDK = transactionServiceLibrary.processResourcesBeforeSaveOnDatabase(transactionDTO, tracciaRichiesta, tracciaRisposta, msgDiagnostici, dumpMessaggioRichiestaIngresso, dumpMessaggioRichiestaUscita, dumpMessaggioRispostaIngresso, dumpMessaggioRispostaUscita, transactionDTO.getStato(), this.logger, daoFactory);
            }
            if (updateRichiestaIngresso || messaggioModificatoSDK) {
                dumpMessageService.updateOrCreate((Object)idDumpMessaggioRichiestaIngresso, (Object)dumpMessaggioRichiestaIngresso);
            }
            if (updateRichiestaUscita || messaggioModificatoSDK) {
                dumpMessageService.updateOrCreate((Object)idDumpMessaggioRichiestaUscita, (Object)dumpMessaggioRichiestaUscita);
            }
            if (updateRispostaIngresso || messaggioModificatoSDK) {
                dumpMessageService.updateOrCreate((Object)idDumpMessaggioRispostaIngresso, (Object)dumpMessaggioRispostaIngresso);
            }
            if (updateRispostaUscita || messaggioModificatoSDK) {
                dumpMessageService.updateOrCreate((Object)idDumpMessaggioRispostaUscita, (Object)dumpMessaggioRispostaUscita);
            }
        }
        catch (Exception e) {
            throw new HandlerException("Errore durante la scrittura della transazione sul database: " + e.getLocalizedMessage(), e);
        }
    }

    private DumpMessaggio getSafe(IDumpMessaggioService dumpMessageService, IdDumpMessaggio id) throws ServiceException, MultipleResultException, NotImplementedException {
        try {
            return (DumpMessaggio)dumpMessageService.get((Object)id);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }
}

