/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.Imbustamento;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class ImbustamentoMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private transient MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (log == null) {
                LoggerWrapperFactory.getLogger(ImbustamentoMDB.class).error("[Imbustamento] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
                log.error("[Imbustamento] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                log.error("[Imbustamento] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage(), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                log.error("[Imbustamento] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.isSistemaDumpDisponibile()) {
                log.error("[Imbustamento] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage(), Dump.getMotivoMalfunzionamentoDump());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Imbustamento lib = null;
            try {
                lib = new Imbustamento(log);
            }
            catch (Exception e) {
                log.error("Imbustamento.instanziazione: " + e.getMessage(), (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.inizializzazioneUltimata) {
                log = LoggerWrapperFactory.getLogger(ImbustamentoMDB.class);
                log.error("[Imbustamento] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(TipoPdD.DELEGATA, "Imbustamento");
            msgDiag.mediumDebug("Ricezione richiesta (ImbustamentoMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ImbustamentoMessage imbustamentoMsg = null;
            try {
                imbustamentoMsg = (ImbustamentoMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getObject(ImbustamentoMessage)");
                return;
            }
            if (imbustamentoMsg.getRichiestaDelegata() != null && imbustamentoMsg.getRichiestaDelegata().getIdPortaDelegata() != null) {
                RequestInfo requestInfo = null;
                if (imbustamentoMsg.getPddContext() != null && imbustamentoMsg.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)imbustamentoMsg.getPddContext().getObject(Costanti.REQUEST_INFO);
                }
                msgDiag.updatePorta(imbustamentoMsg.getRichiestaDelegata().getIdPortaDelegata().getNome(), requestInfo);
            }
            String idMessageRequest = null;
            try {
                idMessageRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopStateful stato = null;
            try {
                stato = new OpenSPCoopStateful();
                stato.setIDMessaggioSessione(idMessageRequest);
                stato.setMessageLib(imbustamentoMsg);
            }
            catch (Exception e) {
                log.error("[Imbustamento] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = imbustamentoMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME)));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "Imbustamento", idMessageRequest, "OUTBOX", received.getJMSMessageID(), pddContext)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessageRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "Imbustamento");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                log.error("[Imbustamento] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                log.info("[Imbustamento] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
            } else {
                log.debug("[Imbustamento] Invocazione della libreria terminata correttamente");
            }
        }
    }
}

