/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import org.apache.commons.io.output.NullOutputStream;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoGestioneCORS;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapperUtilities;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerBase;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.CachedConfigIntegrationReader;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.CORSFilter;
import org.openspcoop2.pdd.core.CORSWrappedHttpServletResponse;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.CostantiControlloTraffico;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.core.integrazione.peer.HeaderMap;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.ConnectorHttpServletResponse;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.registry.ServiceIdentificationReader;
import org.openspcoop2.protocol.registry.CachedRegistryReader;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.InformazioniErroriInfrastrutturali;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.protocol.utils.IDSerialGenerator;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.NameValue;
import org.openspcoop2.utils.TimeoutIOException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.datasource.DataSource;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.CORSRequestType;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ServicesUtils {
    private static Random internalRnd = null;

    private ServicesUtils() {
    }

    private static synchronized void initRandom() {
        if (internalRnd == null) {
            internalRnd = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (internalRnd == null) {
            ServicesUtils.initRandom();
        }
        return internalRnd;
    }

    public static ServiceIdentificationReader getServiceIdentificationReader(Logger logCore, RequestInfo requestInfo, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager) throws Exception {
        if (requestInfo == null) {
            throw new Exception("Param requestInfo is null");
        }
        CachedRegistryReader registryReader = new CachedRegistryReader(logCore, requestInfo.getProtocolFactory(), registroServiziManager, requestInfo);
        CachedConfigIntegrationReader configIntegrationReader = new CachedConfigIntegrationReader(logCore, requestInfo.getProtocolFactory(), configurazionePdDManager, requestInfo);
        return new ServiceIdentificationReader((IRegistryReader)registryReader, (IConfigIntegrationReader)configIntegrationReader, requestInfo.getProtocolFactory(), logCore);
    }

    public static boolean isConnessioneClientNonDisponibile(Throwable t) {
        Throwable tInner;
        if (t instanceof SocketException) {
            return true;
        }
        if (Utilities.existsInnerException((Throwable)t, SocketException.class)) {
            return true;
        }
        return Utilities.existsInnerException((Throwable)t, IOException.class) && (tInner = Utilities.getInnerException((Throwable)t, IOException.class)) != null && tInner.getMessage() != null && (tInner.getMessage().contains("Broken pipe") || tInner.getMessage().contains("Connection reset by peer"));
    }

    public static boolean isConnessioneServerReadTimeout(Throwable t) {
        try {
            SocketTimeoutException e = null;
            if (t instanceof SocketTimeoutException) {
                e = (SocketTimeoutException)t;
            } else if (Utilities.existsInnerException((Throwable)t, SocketTimeoutException.class)) {
                e = (SocketTimeoutException)Utilities.getInnerInstanceException((Throwable)t, SocketTimeoutException.class, (boolean)true);
            }
            if (e != null && e.getMessage() != null && OpenSPCoop2Properties.getInstance().isServiceUnavailableReadTimedOut(e.getMessage())) {
                return true;
            }
            if (TimeoutIOException.isTimeoutIOException((Throwable)t) && t.getMessage() != null && t.getMessage().startsWith("Response ")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isResponsePayloadTooLarge(Throwable t) {
        try {
            if (LimitExceededIOException.isLimitExceededIOException((Throwable)t) && t.getMessage() != null && t.getMessage().startsWith("Response ")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static InformazioniErroriInfrastrutturali readInformazioniErroriInfrastrutturali(PdDContext pddContext) {
        Object o;
        Object o2;
        Object o3;
        Object o4;
        InformazioniErroriInfrastrutturali informazioniErrori = new InformazioniErroriInfrastrutturali();
        boolean erroreUtilizzoConnettore = false;
        if (pddContext != null && (o4 = pddContext.getObject(Costanti.ERRORE_UTILIZZO_CONNETTORE)) instanceof Boolean) {
            erroreUtilizzoConnettore = (Boolean)o4;
        }
        informazioniErrori.setErroreUtilizzoConnettore(erroreUtilizzoConnettore);
        boolean erroreSOAPFaultServerPortaDelegata = false;
        if (pddContext != null && (o3 = pddContext.getObject(Costanti.ERRORE_SOAP_FAULT_SERVER)) instanceof Boolean) {
            erroreSOAPFaultServerPortaDelegata = (Boolean)o3;
        }
        informazioniErrori.setRicevutoSoapFaultServerPortaDelegata(erroreSOAPFaultServerPortaDelegata);
        boolean erroreContenutoRichiestaNonRiconosciuto = false;
        if (pddContext != null && (o2 = pddContext.getObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO)) instanceof Boolean) {
            erroreContenutoRichiestaNonRiconosciuto = (Boolean)o2;
        }
        informazioniErrori.setContenutoRichiestaNonRiconosciuto(erroreContenutoRichiestaNonRiconosciuto);
        boolean erroreContenutoRispostaNonRiconosciuto = false;
        if (pddContext != null && (o = pddContext.getObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO)) instanceof Boolean) {
            erroreContenutoRispostaNonRiconosciuto = (Boolean)o;
        }
        informazioniErrori.setContenutoRispostaNonRiconosciuto(erroreContenutoRispostaNonRiconosciuto);
        return informazioniErrori;
    }

    public static String checkMustUnderstand(OpenSPCoop2SoapMessage message, IProtocolFactory<?> protocolFactory) throws MessageException {
        SOAPEnvelope envelope = null;
        SOAPHeader header = null;
        try {
            OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
            if (openspcoopProperties != null) {
                if (openspcoopProperties.isBypassFilterMustUnderstandEnabledForAllHeaders()) {
                    String string = null;
                    return string;
                }
                envelope = message.getSOAPPart().getEnvelope();
                header = envelope.getHeader();
                if (header == null) {
                    String string = null;
                    return string;
                }
                List<NameValue> filtri = openspcoopProperties.getBypassFilterMustUnderstandProperties(protocolFactory.getProtocol());
                if (filtri != null && !filtri.isEmpty()) {
                    String string = ServicesUtils.checkMustUnderstandHeaderElement(message.getMessageType(), header, filtri);
                    return string;
                }
            }
        }
        catch (Exception ex) {
            Throwable t = ParseExceptionUtils.getParseException((Throwable)ex);
            if (t != null) {
                throw new MessageException((Throwable)ex);
            }
            if (Utilities.existsInnerException((Throwable)ex, (String)"com.ctc.wstx.exc.WstxUnexpectedCharException") || Utilities.existsInnerException((Throwable)ex, (String)"com.ctc.wstx.exc.WstxParsingException")) {
                throw new MessageException((Throwable)ex);
            }
            throw new MessageException("BypassMustUnderstand, errore durante il set processed degli header con mustUnderstand='1' e actor non presente: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            header = null;
            envelope = null;
        }
        return null;
    }

    private static String checkMustUnderstandHeaderElement(MessageType messageType, SOAPHeader header, List<NameValue> filtri) throws UtilsException {
        try {
            StringBuilder bfError = new StringBuilder();
            if (!SoapUtils.checkMustUnderstandHeaderElement((MessageType)messageType, (SOAPHeader)header, filtri, (StringBuilder)bfError)) {
                return bfError.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public static String checkSOAPEnvelopeNamespace(OpenSPCoop2SoapMessage message, MessageType messageType) throws MessageException {
        try {
            if (!SoapUtils.checkSOAPEnvelopeNamespace((OpenSPCoop2SoapMessage)message, (MessageType)messageType)) {
                OpenSPCoop2MessageSoapStreamReader reader = message.getSoapReader();
                String envelopeNamespace = null;
                if (reader != null) {
                    envelopeNamespace = reader.getNamespace();
                }
                if (envelopeNamespace == null) {
                    return message.getSOAPPart().getEnvelope().getNamespaceURI();
                }
                return envelopeNamespace;
            }
            return null;
        }
        catch (Exception ex) {
            throw new MessageException("CheckSoapEnvelopeNamespace, errore durante il controllo del namespace del soap envelope: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static void checkCharset(String contentType, List<String> ctDefault, MsgDiagnostico msgDiag, boolean request, TipoPdD tipoPdD) throws MessageException {
        try {
            if (contentType != null && contentType.contains("charset")) {
                String charset = null;
                if (ContentTypeUtilities.isMultipartContentType((String)contentType)) {
                    String ct = ContentTypeUtilities.getInternalMultipartContentType(charset);
                    if (ct != null) {
                        charset = ContentTypeUtilities.readCharsetFromContentType((String)ct);
                    }
                } else {
                    charset = ContentTypeUtilities.readCharsetFromContentType((String)contentType);
                }
                if (charset != null) {
                    if (charset.startsWith("\"") && charset.length() > 1) {
                        charset = charset.substring(1);
                    }
                    if (charset.endsWith("\"") && charset.length() > 1) {
                        charset = charset.substring(0, charset.length() - 1);
                    }
                }
                boolean find = false;
                for (String string : ctDefault) {
                    if (!string.equalsIgnoreCase(charset)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    msgDiag.addKeyword("@CONTENT_TYPE@", contentType);
                    StringBuilder sb = new StringBuilder();
                    for (String def : ctDefault) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(def);
                    }
                    msgDiag.addKeyword("@CHARSET_DEFAULT@", sb.toString());
                    String string = TipoPdD.DELEGATA.equals((Object)tipoPdD) ? "ricezioneContenutiApplicativi." : "ricezioneBuste.";
                    String idDiagnostico = request ? "richiesta.warningCharsetDifferenteDefault" : "risposta.warningCharsetDifferenteDefault";
                    msgDiag.logPersonalizzato(string, idDiagnostico);
                }
            }
        }
        catch (Exception ex) {
            throw new MessageException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static boolean verificaRispostaRelazioneCodiceTrasporto202(IProtocolFactory<?> protocolFactory, OpenSPCoop2Properties openSPCoopProperties, OpenSPCoop2Message responseMessage, boolean gestioneLatoPortaDelegata) throws ProtocolException, MessageException, MessageNotSupportedException {
        if (responseMessage == null) {
            return false;
        }
        IProtocolManager protocolManager = protocolFactory.createProtocolManager();
        boolean rispostaPresente = true;
        if (protocolManager.isHttpEmptyResponseOneWay()) {
            if (ServiceBinding.SOAP.equals((Object)responseMessage.getServiceBinding())) {
                OpenSPCoop2SoapMessage soap = responseMessage.castAsSoap();
                if (soap.hasAttachments()) {
                    rispostaPresente = true;
                } else if (!soap.isSOAPBodyEmpty()) {
                    rispostaPresente = true;
                } else {
                    SOAPHeader h = null;
                    SOAPHeader header = null;
                    h = soap.getSOAPHeader();
                    if (h != null) {
                        header = h;
                    }
                    if (h == null || header == null || SoapUtils.getFirstNotEmptyChildNode((OpenSPCoop2MessageFactory)responseMessage.getFactory(), (Node)header, (boolean)false) == null) {
                        rispostaPresente = false;
                    } else if (gestioneLatoPortaDelegata && !protocolManager.isHttpOneWay_PD_HTTPEmptyResponse()) {
                        rispostaPresente = false;
                    }
                    header = null;
                    h = null;
                }
            } else {
                rispostaPresente = true;
            }
        }
        return rispostaPresente;
    }

    private static long calculateContentLength(OpenSPCoop2Message message) throws MessageException {
        message.writeTo((OutputStream)NullOutputStream.INSTANCE, false);
        return message.getOutgoingMessageContentLength();
    }

    private static Long getBackendContentLength(OpenSPCoop2Message message) {
        if (message.getTransportResponseContext() != null && message.getTransportResponseContext().getContentLength() > 0L) {
            return message.getTransportResponseContext().getContentLength();
        }
        return null;
    }

    private static long resolveContentLength(OpenSPCoop2Message message, boolean forceRecalculate) throws MessageException {
        Long backendCL;
        if (!forceRecalculate && !message.isContentBuilded() && (backendCL = ServicesUtils.getBackendContentLength(message)) != null) {
            return backendCL;
        }
        return ServicesUtils.calculateContentLength(message);
    }

    public static void setTransferLength(TransferLengthModes transferLengthMode, ConnectorInMessage connectorInMessage, ConnectorOutMessage connectorOutMessage, OpenSPCoop2Message message, PdDContext pddContext, boolean govwayGeneratedErrorMessage) throws ConnectorException, MessageException {
        Long backendCL;
        Object bulkFlag;
        if (ServicesUtils.setTransferLengthByPorta(connectorOutMessage, message, pddContext, govwayGeneratedErrorMessage)) {
            return;
        }
        if (!govwayGeneratedErrorMessage && pddContext != null && message != null && (bulkFlag = pddContext.getObject(Costanti.MODIPA_BULK_RESOURCE_REST)) != null && "true".equals(bulkFlag.toString()) && (backendCL = ServicesUtils.getBackendContentLength(message)) != null) {
            connectorOutMessage.setContentLength((int)ServicesUtils.resolveContentLength(message, false));
            return;
        }
        if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals((Object)transferLengthMode)) {
            String requestProtocoll = connectorInMessage.getProtocol();
            if (requestProtocoll != null && requestProtocoll.endsWith("1.1")) {
                connectorOutMessage.setHeader("Transfer-Encoding", "chunked");
            }
        } else if (TransferLengthModes.CONTENT_LENGTH.equals((Object)transferLengthMode) && message != null) {
            connectorOutMessage.setContentLength((int)ServicesUtils.calculateContentLength(message));
        }
    }

    private static boolean setTransferLengthByPorta(ConnectorOutMessage connectorOutMessage, OpenSPCoop2Message message, PdDContext pddContext, boolean govwayGeneratedErrorMessage) throws ConnectorException, MessageException {
        if (message != null && pddContext != null) {
            Map map;
            Object o = pddContext.getObject(Costanti.PROPRIETA_CONFIGURAZIONE);
            ArrayList<Proprieta> proprieta = null;
            if (o instanceof Map && !(map = (Map)o).isEmpty()) {
                proprieta = new ArrayList<Proprieta>();
                for (Map.Entry entry : map.entrySet()) {
                    Proprieta p = new Proprieta();
                    p.setNome((String)entry.getKey());
                    p.setValore((String)entry.getValue());
                    proprieta.add(p);
                }
            }
            if (proprieta != null && !proprieta.isEmpty() && ServicesUtils.setTransferLengthByPorta(proprieta, connectorOutMessage, message, govwayGeneratedErrorMessage)) {
                return true;
            }
        }
        return false;
    }

    private static boolean setTransferLengthByPorta(List<Proprieta> proprieta, ConnectorOutMessage connectorOutMessage, OpenSPCoop2Message message, boolean govwayGeneratedErrorMessage) throws ConnectorException, MessageException {
        Long backendCL;
        if (CostantiProprieta.isConnettoriHttpContentLengthForceRecalculate(proprieta, false)) {
            connectorOutMessage.setContentLength((int)ServicesUtils.resolveContentLength(message, true));
            return true;
        }
        if (CostantiProprieta.isConnettoriHttpContentLengthForce(proprieta, false)) {
            connectorOutMessage.setContentLength((int)ServicesUtils.resolveContentLength(message, false));
            return true;
        }
        if (!govwayGeneratedErrorMessage && (backendCL = ServicesUtils.getBackendContentLength(message)) != null) {
            if (CostantiProprieta.isConnettoriHttpContentLengthPreserveRecalculate(proprieta, false)) {
                connectorOutMessage.setContentLength((int)ServicesUtils.resolveContentLength(message, true));
                return true;
            }
            if (CostantiProprieta.isConnettoriHttpContentLengthPreserve(proprieta, false)) {
                connectorOutMessage.setContentLength((int)ServicesUtils.resolveContentLength(message, false));
                return true;
            }
        }
        return false;
    }

    public static void setTransferLength(TransferLengthModes transferLengthMode, ConnectorInMessage connectorInMessage, ConnectorOutMessage connectorOutMessage, Long length) throws ConnectorException {
        if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals((Object)transferLengthMode)) {
            String requestProtocoll = connectorInMessage.getProtocol();
            if (requestProtocoll != null && requestProtocoll.endsWith("1.1")) {
                connectorOutMessage.setHeader("Transfer-Encoding", "chunked");
            }
        } else if (TransferLengthModes.CONTENT_LENGTH.equals((Object)transferLengthMode) && length != null) {
            connectorOutMessage.setContentLength(length.intValue());
        }
    }

    public static void setContentType(OpenSPCoop2Message message, ConnectorOutMessage connectorOutMessage) throws ConnectorException {
        try {
            String contentTypeRisposta;
            if (CostantiPdD.isEnabledAddSWAStartParameterIfNotPresent(message)) {
                SoapUtils.addSWAStartParameterIfNotPresent((OpenSPCoop2Message)message);
            }
            if ((contentTypeRisposta = message.getContentType()) != null) {
                connectorOutMessage.setContentType(contentTypeRisposta);
            } else {
                if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                    throw new MessageException("Risposta errore senza Content-type");
                }
                if (message.castAsRest().hasContent()) {
                    throw new MessageException("Risposta errore senza Content-type");
                }
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static void setGovWayHeaderResponse(ServiceBinding serviceBindingRequest, OpenSPCoop2Message msg, OpenSPCoop2Properties openspcoopProperties, Map<String, List<String>> propertiesTrasporto, Logger logCore, boolean portaDelegata, PdDContext pddContext, RequestInfo requestInfo) {
        Properties pHeaderRateLimiting;
        UtilitiesIntegrazione utilitiesIntegrazione = null;
        try {
            utilitiesIntegrazione = portaDelegata ? UtilitiesIntegrazione.getInstancePDResponse(logCore) : UtilitiesIntegrazione.getInstancePAResponse(logCore);
            List idTransazioneValues = (List)TransportUtils.getRawObject(propertiesTrasporto, (String)((String)((Object)Costanti.ID_TRANSAZIONE.getValue())));
            if (idTransazioneValues == null || idTransazioneValues.isEmpty()) {
                String idTransazione = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
                HeaderIntegrazione hdr = new HeaderIntegrazione(idTransazione);
                utilitiesIntegrazione.setTransportProperties(hdr, propertiesTrasporto, null);
            } else {
                utilitiesIntegrazione.setInfoProductTransportProperties(propertiesTrasporto);
            }
        }
        catch (Exception e) {
            logCore.error("Set header di integrazione fallito: " + e.getMessage(), (Throwable)e);
        }
        if (pddContext.containsKey(CostantiControlloTraffico.PDD_CONTEXT_HEADER_RATE_LIMITING) && (pHeaderRateLimiting = (Properties)pddContext.getObject(CostantiControlloTraffico.PDD_CONTEXT_HEADER_RATE_LIMITING)).size() > 0) {
            Enumeration<Object> en = pHeaderRateLimiting.keys();
            while (en.hasMoreElements()) {
                String key2 = (String)en.nextElement();
                TransportUtils.setHeader(propertiesTrasporto, (String)key2, (String)pHeaderRateLimiting.getProperty(key2));
            }
        }
        ServicesUtils.setCORSAllowOrigin(propertiesTrasporto, logCore, portaDelegata, pddContext, requestInfo);
        HeaderMap extraHeaders = Objects.requireNonNullElse((HeaderMap)pddContext.getObject(CostantiPdD.EXTRA_HEADERS_RESPONSE), new HeaderMap());
        extraHeaders.forEach((key, value) -> TransportUtils.setHeader((Map)propertiesTrasporto, (String)key, (String)value));
        try {
            OpenSPCoop2MessageProperties forwardHeader = null;
            if (msg != null && openspcoopProperties != null) {
                forwardHeader = ServiceBinding.REST.equals((Object)msg.getServiceBinding()) ? msg.getForwardTransportHeader(openspcoopProperties.getRESTServicesHeadersForwardConfig(false)) : msg.getForwardTransportHeader(openspcoopProperties.getSOAPServicesHeadersForwardConfig(false));
            }
            try {
                if (utilitiesIntegrazione != null) {
                    ServiceBinding sb = msg != null ? msg.getServiceBinding() : serviceBindingRequest;
                    utilitiesIntegrazione.setSecurityHeaders(sb, requestInfo, propertiesTrasporto, forwardHeader);
                }
            }
            catch (Exception e) {
                logCore.error("Set security headers fallito: " + e.getMessage(), (Throwable)e);
            }
            if (propertiesTrasporto != null && !propertiesTrasporto.isEmpty() && forwardHeader != null && forwardHeader.size() > 0) {
                for (String key3 : propertiesTrasporto.keySet()) {
                    forwardHeader.removePropertyValues(key3);
                }
            }
        }
        catch (Exception e) {
            logCore.error("Pulizia forward header, rispetto a quelli generati da GovWay, fallito: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void setCORSAllowOrigin(Map<String, List<String>> propertiesTrasporto, Logger logCore, boolean portaDelegata, PdDContext pddContext, RequestInfo requestInfo) {
        try {
            boolean preflightRequest;
            Object nomePortaObject = pddContext.getObject(CostantiPdD.NOME_PORTA_INVOCATA);
            String nomePorta = null;
            if (nomePortaObject instanceof String) {
                nomePorta = (String)nomePortaObject;
            }
            CorsConfigurazione cors = null;
            HttpServletRequest httpServletRequest = null;
            URLProtocolContext protocolContext = null;
            if (requestInfo != null) {
                protocolContext = requestInfo.getProtocolContext();
            }
            if (protocolContext != null) {
                httpServletRequest = protocolContext.getHttpServletRequest();
                if (nomePorta == null) {
                    nomePorta = protocolContext.getInterfaceName();
                }
            }
            if (httpServletRequest != null) {
                ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance();
                if (nomePorta != null) {
                    if (portaDelegata) {
                        IDPortaDelegata idPD = new IDPortaDelegata();
                        idPD.setNome(nomePorta);
                        PortaDelegata pdDefault = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
                        cors = configurazionePdDManager.getConfigurazioneCORS(pdDefault);
                    } else {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(nomePorta);
                        PortaApplicativa paDefault = configurazionePdDManager.getPortaApplicativaSafeMethod(idPA, requestInfo);
                        cors = configurazionePdDManager.getConfigurazioneCORS(paDefault);
                    }
                }
                if (cors == null) {
                    cors = configurazionePdDManager.getConfigurazioneCORS();
                }
            } else {
                cors = new CorsConfigurazione();
                cors.setStato(StatoFunzionalita.DISABILITATO);
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)cors.getStato()) && TipoGestioneCORS.GATEWAY.equals((Object)cors.getTipo()) && !(preflightRequest = pddContext.containsKey(Costanti.CORS_PREFLIGHT_REQUEST_VIA_GATEWAY))) {
                CORSFilter corsFilter = new CORSFilter(logCore, cors);
                CORSWrappedHttpServletResponse res = new CORSWrappedHttpServletResponse(false);
                corsFilter.doCORS(httpServletRequest, (HttpServletResponse)res, CORSRequestType.ACTUAL, true);
                propertiesTrasporto.putAll(res.getHeadersValues());
            }
        }
        catch (Exception e) {
            logCore.error("Set cors origin: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isRequestWsdl(ConnectorInMessage reqParam, Logger logCore) {
        try {
            if (reqParam == null || reqParam.getURLProtocolContext() == null || reqParam.getURLProtocolContext().getHttpServletRequest() == null) {
                return false;
            }
            HttpServletRequest req = reqParam.getURLProtocolContext().getHttpServletRequest();
            if (HttpRequestMethod.GET.equals(req.getMethod())) {
                Enumeration parameters = req.getParameterNames();
                while (parameters.hasMoreElements()) {
                    String key = (String)parameters.nextElement();
                    String value = req.getParameter(key);
                    if (!"wsdl".equalsIgnoreCase(key) || value != null && !"".equals(value)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            logCore.error("IsRequestWsdl fallita: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static void writeWsdl(ConnectorOutMessage response, RequestInfo requestInfo, IDService idService, ServiceIdentificationReader serviceIdentificationReader, Logger logCore) throws ConnectorException {
        try {
            boolean generazioneWsdlEnabled = false;
            generazioneWsdlEnabled = IDService.PORTA_APPLICATIVA.equals((Object)idService) ? OpenSPCoop2Properties.getInstance().isGenerazioneWsdlPortaApplicativaEnabled() : OpenSPCoop2Properties.getInstance().isGenerazioneWsdlPortaDelegataEnabled();
            if (!generazioneWsdlEnabled) {
                response.setStatus(404);
                response.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeWsdlUnsupported(idService)).getBytes()));
                return;
            }
            byte[] wsdl = null;
            if (requestInfo != null && requestInfo.getIdServizio() != null) {
                AccordoServizioParteSpecifica asps = null;
                AccordoServizioParteComune aspc = null;
                byte[] wsdlLogico = null;
                try {
                    asps = serviceIdentificationReader.getRegistryReader().getAccordoServizioParteSpecifica(requestInfo.getIdServizio(), false);
                }
                catch (RegistryNotFound registryNotFound) {
                    // empty catch block
                }
                if (asps != null) {
                    try {
                        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                        aspc = serviceIdentificationReader.getRegistryReader().getAccordoServizioParteComune(idAccordo, true, true);
                    }
                    catch (RegistryNotFound idAccordo) {
                        // empty catch block
                    }
                }
                if (aspc != null) {
                    wsdlLogico = TipologiaServizio.CORRELATO.equals((Object)asps.getTipologiaServizio()) ? aspc.getByteWsdlLogicoFruitore() : aspc.getByteWsdlLogicoErogatore();
                }
                if (wsdlLogico != null) {
                    MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
                    WSDLUtilities wsdlUtilities = new WSDLUtilities((AbstractXMLUtils)xmlUtils);
                    AccordoServizioWrapperUtilities wsdlWrapperUtilities = new AccordoServizioWrapperUtilities(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), logCore);
                    wsdlWrapperUtilities.setAccordoServizio(new AccordoServizioWrapper());
                    wsdlWrapperUtilities.getAccordoServizioWrapper().setAccordoServizio(aspc);
                    Definition wsdlDefinition = null;
                    if (TipologiaServizio.CORRELATO.equals((Object)asps.getTipologiaServizio())) {
                        wsdlWrapperUtilities.getAccordoServizioWrapper().setBytesWsdlImplementativoFruitore(asps.getByteWsdlImplementativoFruitore());
                        wsdlDefinition = wsdlWrapperUtilities.buildWsdlFruitoreFromBytes();
                    } else {
                        wsdlWrapperUtilities.getAccordoServizioWrapper().setBytesWsdlImplementativoErogatore(asps.getByteWsdlImplementativoErogatore());
                        wsdlDefinition = wsdlWrapperUtilities.buildWsdlErogatoreFromBytes();
                    }
                    if (asps.getPortType() != null && requestInfo.getProtocolContext() != null) {
                        Port portWSDL;
                        Binding bindingWSDL;
                        UrlInvocazioneAPI urlInvocazioneApi = ConfigurazionePdDManager.getInstance().getConfigurazioneUrlInvocazione(requestInfo.getProtocolFactory(), IDService.PORTA_APPLICATIVA.equals((Object)idService) ? RuoloContesto.PORTA_APPLICATIVA : RuoloContesto.PORTA_DELEGATA, requestInfo.getIntegrationServiceBinding(), requestInfo.getProtocolContext().getInterfaceName(), requestInfo.getIdentitaPdD(), aspc, requestInfo);
                        String prefixGatewayUrl = urlInvocazioneApi.getBaseUrl();
                        String contesto = urlInvocazioneApi.getContext();
                        prefixGatewayUrl = Utilities.buildUrl((String)prefixGatewayUrl, (String)contesto);
                        DefinitionWrapper wrapper = new DefinitionWrapper(wsdlDefinition, (AbstractXMLUtils)xmlUtils);
                        PortType ptWSDL = wrapper.getPortType(asps.getPortType());
                        if (ptWSDL != null && ptWSDL.getQName() != null && ptWSDL.getQName().getLocalPart() != null && (bindingWSDL = wrapper.getBindingByPortType(ptWSDL.getQName().getLocalPart())) != null && bindingWSDL.getQName() != null && bindingWSDL.getQName().getLocalPart() != null && (portWSDL = wrapper.getServicePortByBindingName(bindingWSDL.getQName().getLocalPart())) != null) {
                            wrapper.updateLocation(portWSDL, prefixGatewayUrl);
                        }
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    wsdlUtilities.writeWsdlTo(wsdlDefinition, (OutputStream)bout);
                    bout.flush();
                    bout.close();
                    wsdl = bout.toByteArray();
                }
            }
            if (wsdl != null) {
                HttpUtilities.setOutputFile((HttpServletResponse)new ConnectorHttpServletResponse(response), (boolean)true, (String)"interface.wsdl");
                response.setStatus(200);
                response.sendResponse(DumpByteArrayOutputStream.newInstance(wsdl));
            } else {
                response.setStatus(404);
                response.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeWsdlNotDefined(idService)).getBytes()));
            }
        }
        catch (Exception e) {
            logCore.error("Lettura wsdl fallita: " + e.getMessage(), (Throwable)e);
            throw new ConnectorException("Lettura wsdl fallita: " + e.getMessage(), e);
        }
    }

    public static void processTrackingException(Exception e, Logger log, FaseTracciamento fase, Context context) throws HandlerException {
        HandlerException he = null;
        if (e instanceof HandlerException) {
            he = (HandlerException)e;
            if (he.getIntegrationFunctionError() == null) {
                he.setIntegrationFunctionError(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE);
                String msg = "Tracciamento '" + fase.name() + "' fallito: " + e.getMessage();
                log.error(msg, (Throwable)e);
            }
        } else {
            he = new HandlerException();
            he.setIntegrationFunctionError(IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE);
            String msg = "Tracciamento '" + fase.name() + "' fallito: " + e.getMessage();
            log.error(msg, (Throwable)e);
        }
        context.addObject(Costanti.ERRORE_TRACCIAMENTO, (Object)"true");
        throw he;
    }

    public static EsitoTransazione updateEsitoConAnomalie(EsitoTransazione esito, Logger log, IProtocolFactory<?> protocolFactory) {
        try {
            if (EsitoTransazioneName.OK.equals((Object)esito.getName())) {
                EsitiProperties esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
                esito = esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.OK_PRESENZA_ANOMALIE, esito.getContextType());
            }
        }
        catch (Exception e) {
            String msg = "Update esito con anomalie fallito: " + e.getMessage();
            log.error(msg, (Throwable)e);
        }
        return esito;
    }

    public static void initCheckConnectionDB(Logger logR, boolean checkIsClosed, boolean checkAutoCommit) {
        DriverConfigurazioneDB.setCheckLogger((Logger)logR);
        DriverConfigurazioneDB.setCheckIsClosed((boolean)checkIsClosed);
        DriverConfigurazioneDB.setCheckAutocommit((boolean)checkAutoCommit);
        DriverRegistroServiziDB.setCheckLogger((Logger)logR);
        DriverRegistroServiziDB.setCheckIsClosed((boolean)checkIsClosed);
        DriverRegistroServiziDB.setCheckAutocommit((boolean)checkAutoCommit);
        JDBCServiceManagerBase.setCheckLogger((Logger)logR);
        JDBCServiceManagerBase.setCheckIsClosed((boolean)checkIsClosed);
        JDBCServiceManagerBase.setCheckAutocommit((boolean)checkAutoCommit);
        BasicComponentFactory.setCheckLogger((Logger)logR);
        BasicComponentFactory.setCheckIsClosed((boolean)checkIsClosed);
        BasicComponentFactory.setCheckAutocommit((boolean)checkAutoCommit);
        IDSerialGenerator.setCheckLogger((Logger)logR);
        IDSerialGenerator.setCheckIsClosed((boolean)checkIsClosed);
        IDSerialGenerator.setCheckAutocommit((boolean)checkAutoCommit);
        DataSource.setCheckLogger((Logger)logR);
        DataSource.setCheckIsClosed((boolean)checkIsClosed);
        DataSource.setCheckAutocommit((boolean)checkAutoCommit);
    }
}

