/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.ConnectorApplicativeThreadPool;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherErrorInfo;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherInfo;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorAsyncInMessage;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorAsyncOutMessage;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorInMessage;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.service.IRicezioneService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.TimeoutIOException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.unblocked.IPipedUnblockedStream;
import org.openspcoop2.utils.io.notifier.unblocked.PipedUnblockedStreamFactory;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public abstract class AbstractRicezioneConnectorAsync {
    protected abstract IDService getIdService();

    protected abstract String getIdModulo();

    protected abstract AbstractErrorGenerator getErrorGenerator(Logger var1, RequestInfo var2) throws ConnectorException;

    protected abstract void doError(RequestInfo var1, AbstractErrorGenerator var2, ErroreIntegrazione var3, IntegrationFunctionError var4, Throwable var5, HttpServletResponse var6, Logger var7);

    protected abstract ConnectorDispatcherErrorInfo doError(RequestInfo var1, AbstractErrorGenerator var2, ErroreIntegrazione var3, IntegrationFunctionError var4, Throwable var5, ParseException var6, ConnectorOutMessage var7, Logger var8, boolean var9) throws ConnectorException;

    protected abstract void emitTransaction(Logger var1, ConnectorInMessage var2, PdDContext var3, Date var4, ConnectorDispatcherInfo var5);

    protected abstract long getTimeout();

    protected abstract IRicezioneService newRicezioneService(AbstractErrorGenerator var1);

    public void doEngine(final RequestInfo requestInfo, HttpServletRequest req, HttpServletResponse res, HttpRequestMethod method) throws ServletException, IOException {
        final Date dataAccettazioneRichiesta = DateManager.getDate();
        final Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (method != null) {
            // empty if block
        }
        AbstractErrorGenerator generatoreErrore = null;
        try {
            generatoreErrore = this.getErrorGenerator(logCore, requestInfo);
        }
        catch (Exception e) {
            String msg = "Inizializzazione Generatore Errore fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            logCore.error(msg, (Throwable)e);
            this.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, e, res, logCore);
            return;
        }
        final AsyncContext ac = req.startAsync();
        HttpServletConnectorAsyncInMessage httpIn = null;
        try {
            httpIn = new HttpServletConnectorAsyncInMessage(requestInfo, req, this.getIdService(), this.getIdModulo());
        }
        catch (Exception e) {
            this.doError("HttpServletConnectorInMessage init error", e);
        }
        IProtocolFactory<?> protocolFactory = null;
        try {
            protocolFactory = httpIn.getProtocolFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpServletConnectorAsyncOutMessage httpOut = null;
        try {
            httpOut = new HttpServletConnectorAsyncOutMessage(requestInfo, protocolFactory, ac, this.getIdService(), this.getIdModulo());
        }
        catch (Exception e) {
            this.doError("HttpServletConnectorOutMessage init error", e);
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        boolean stream = op2Properties.isNIOConfigAsyncRequestStreamEnabled();
        int dimensioneBuffer = op2Properties.getNIOConfigAsyncRequestPipedUnblockedStreamBuffer();
        final long timeout = this.getTimeout();
        req.getInputStream().setReadListener(new ReadListener(){
            private ServletInputStream is = null;
            private Logger log;
            private AbstractErrorGenerator generatoreErrore;
            private HttpServletConnectorAsyncInMessage httpIn;
            private HttpServletConnectorAsyncOutMessage httpOut;
            private boolean stream;
            private ByteArrayOutputStream os = null;
            private IPipedUnblockedStream pipe;

            public ReadListener init(Logger log, ServletInputStream is, boolean stream, int sizeBuffer, AbstractErrorGenerator generatoreErrore, HttpServletConnectorAsyncInMessage httpIn, HttpServletConnectorAsyncOutMessage httpOut) throws ServletException {
                this.is = is;
                this.log = log;
                this.generatoreErrore = generatoreErrore;
                this.httpIn = httpIn;
                this.httpOut = httpOut;
                this.stream = stream;
                if (stream) {
                    try {
                        this.pipe = PipedUnblockedStreamFactory.newPipedUnblockedStream((Logger)logCore, (long)sizeBuffer, (int)(IDService.PORTA_APPLICATIVA.equals((Object)AbstractRicezioneConnectorAsync.this.getIdService()) || IDService.PORTA_APPLICATIVA_NIO.equals((Object)AbstractRicezioneConnectorAsync.this.getIdService()) ? 120000 : 180000), (String)"Request");
                    }
                    catch (Throwable t) {
                        this.log.error("Istanziazione PipedStream fallita: " + t.getMessage(), t);
                        throw new ServletException(t.getMessage(), t);
                    }
                    this.httpIn.updateInputStream((InputStream)this.pipe);
                } else {
                    this.os = new ByteArrayOutputStream();
                }
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable t) {
                String msg = "Avvenuto errore durante la lettura della richiesta: " + Utilities.readFirstErrorValidMessageFromException((Throwable)t);
                this.log.error(msg, t);
                try {
                    ConnectorDispatcherErrorInfo cInfo = AbstractRicezioneConnectorAsync.this.doError(requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_509_READ_REQUEST_MSG), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, t, null, this.httpOut, this.log, false);
                    AbstractRicezioneConnectorAsync.this.emitTransaction(this.log, this.httpIn, null, dataAccettazioneRichiesta, cInfo);
                }
                catch (Exception e) {
                    this.log.error("Gestione errore fallita: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    ac.complete();
                }
            }

            public void onDataAvailable() throws IOException {
                int len = -1;
                byte[] b = new byte[65536];
                while (this.is.isReady() && (len = this.is.read(b)) != -1) {
                    if (this.stream) {
                        this.pipe.write(b, 0, len);
                        continue;
                    }
                    this.os.write(b, 0, len);
                }
            }

            public void onAllDataRead() throws IOException {
                if (this.stream) {
                    this.pipe.close();
                } else {
                    this.os.flush();
                    this.os.close();
                    this.is.close();
                    IRicezioneService ricezioneService = AbstractRicezioneConnectorAsync.this.newRicezioneService(this.generatoreErrore);
                    this.httpIn.updateInputStream(new ByteArrayInputStream(this.os.toByteArray()));
                    try {
                        ricezioneService.process(this.httpIn, this.httpOut, dataAccettazioneRichiesta, true);
                    }
                    catch (Throwable e) {
                        ConnectorUtils.getErrorLog().error(AbstractRicezioneConnectorAsync.this.getIdService().getValue() + ".process error: " + e.getMessage(), e);
                        throw new IOException(AbstractRicezioneConnectorAsync.this.getIdService().getValue() + ".process error: " + e.getMessage(), e);
                    }
                }
            }
        }.init(logCore, req.getInputStream(), stream, dimensioneBuffer, generatoreErrore, httpIn, httpOut));
        ac.addListener(new AsyncListener(){
            private HttpServletConnectorAsyncOutMessage httpOut;

            public AsyncListener init(HttpServletConnectorAsyncOutMessage httpOut) {
                this.httpOut = httpOut;
                return this;
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                if (event.getThrowable() != null) {
                    this.httpOut.setNioException((Throwable)new TimeoutIOException("Timeout '" + timeout + "' exceeded: " + event.getThrowable().getMessage(), event.getThrowable()));
                } else {
                    this.httpOut.setNioException((Throwable)new TimeoutIOException("Timeout '" + timeout + "' exceeded"));
                }
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
                if (event.getThrowable() != null) {
                    this.httpOut.setNioException(new ConnectorException("Async IO error: " + event.getThrowable().getMessage(), event.getThrowable()));
                } else {
                    this.httpOut.setNioException(new ConnectorException("Async IO error"));
                }
            }

            public void onComplete(AsyncEvent event) throws IOException {
            }
        }.init(httpOut));
        ac.setTimeout(timeout);
        if (stream) {
            boolean delegata;
            IRicezioneService ricezioneService = this.newRicezioneService(generatoreErrore);
            Runnable runnable = new Runnable(){
                private IRicezioneService ricezioneService;
                private HttpServletConnectorInMessage httpIn;
                private HttpServletConnectorAsyncOutMessage httpOut;

                public Runnable init(IRicezioneService ricezioneService, HttpServletConnectorInMessage httpIn, HttpServletConnectorAsyncOutMessage httpOut) {
                    this.ricezioneService = ricezioneService;
                    this.httpIn = httpIn;
                    this.httpOut = httpOut;
                    return this;
                }

                @Override
                public void run() {
                    try {
                        this.ricezioneService.process(this.httpIn, this.httpOut, dataAccettazioneRichiesta, true);
                    }
                    catch (Throwable e) {
                        ConnectorUtils.getErrorLog().error("NIO RicezioneBuste.process error: " + e.getMessage(), e);
                    }
                }
            }.init(ricezioneService, httpIn, httpOut);
            boolean bl = delegata = this.getIdService() != null && this.getIdService().isPortaDelegata();
            if (delegata) {
                ConnectorApplicativeThreadPool.executeByAsyncOutRequestPool(runnable);
            } else {
                ConnectorApplicativeThreadPool.executeByAsyncInRequestPool(runnable);
            }
        }
    }

    private void doError(String msg, Exception e) throws ServletException {
        String msgError = msg + ": " + e.getMessage();
        ConnectorUtils.getErrorLog().error(msgError, (Throwable)e);
        throw new ServletException(e.getMessage(), (Throwable)e);
    }
}

