/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.DynamicClusterManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.CheckStatoPdD;
import org.openspcoop2.pdd.services.connector.ResultAggregate;
import org.openspcoop2.pdd.services.connector.proxy.IProxyOperationService;
import org.openspcoop2.pdd.services.connector.proxy.ProxyOperation;
import org.openspcoop2.pdd.services.connector.proxy.ProxyOperationServiceFactory;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpServletCredential;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class Proxy
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String SERVIZIO_NON_ABILITATO = "Servizio non abilitato";
    private static final String SERVIZIO_NON_DISPONIBILE = "Servizio non disponibile";
    private static boolean saveContextOnlyOperation = true;

    private static void logError(Logger log, String msg, Throwable e) {
        log.error(msg, e);
    }

    private static void logError(Logger log, String msg) {
        log.error(msg);
    }

    private static void logDebug(Logger log, String msg) {
        log.debug(msg);
    }

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code) {
        Proxy.sendError(res, log, msg, code, msg, null);
    }

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code, Throwable e) {
        Proxy.sendError(res, log, msg, code, msg, e);
    }

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code, String logMsg) {
        Proxy.sendError(res, log, msg, code, logMsg, null);
    }

    private static void sendError(HttpServletResponse res, Logger log, String msg, int code, String logMsg, Throwable e) {
        String prefix = "[Proxy] ";
        if (e != null) {
            Proxy.logError(log, prefix + logMsg, e);
        } else {
            Proxy.logError(log, prefix + logMsg);
        }
        res.setStatus(code);
        res.setContentType("text/plain");
        try {
            res.getOutputStream().write(msg.getBytes());
        }
        catch (Exception t) {
            Proxy.logError(log, "[Proxy] SendError failed: " + t.getMessage(), t);
        }
    }

    public static boolean isSaveContextOnlyOperation() {
        return saveContextOnlyOperation;
    }

    public static void setSaveContextOnlyOperation(boolean saveContextOnlyOperation) {
        Proxy.saveContextOnlyOperation = saveContextOnlyOperation;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String tmp;
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopProxy();
        if (log == null) {
            log = LoggerWrapperFactory.getLogger(Proxy.class);
        }
        if (!OpenSPCoop2Startup.initialize) {
            CheckStatoPdD.serializeNotInitializedResponse(res, log);
            return;
        }
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        boolean proxyEnabled = false;
        if (properties != null && properties.isProxyReadJMXResourcesEnabled()) {
            proxyEnabled = true;
        }
        if (!proxyEnabled) {
            String msg = SERVIZIO_NON_ABILITATO;
            Proxy.sendError(res, log, msg, 500);
            return;
        }
        List<String> list = null;
        try {
            list = DynamicClusterManager.getInstance().getHostnames(log);
        }
        catch (Exception e) {
            String msg = SERVIZIO_NON_DISPONIBILE;
            String logMsg = msg + ": " + e.getMessage();
            Proxy.sendError(res, log, msg, 500, logMsg, e);
            return;
        }
        boolean asyncMode = properties.isProxyReadJMXResourcesAsyncProcessByTimer();
        IProxyOperationService proxyOperationService = null;
        if (asyncMode) {
            String className = properties.getProxyReadJMXResourcesAsyncProcessByTimerServiceImplClass();
            try {
                proxyOperationService = ProxyOperationServiceFactory.newInstance(className, log);
            }
            catch (Exception e) {
                String msg = SERVIZIO_NON_DISPONIBILE;
                String logMsg = msg + ": " + e.getMessage();
                Proxy.sendError(res, log, msg, 500, logMsg, e);
                return;
            }
        }
        String protocolSchema = properties.getProxyReadJMXResourcesSchema();
        if (asyncMode && (tmp = properties.getProxyReadJMXResourcesAsyncProcessByTimerSchema()) != null && StringUtils.isNotEmpty((CharSequence)tmp)) {
            protocolSchema = tmp;
        }
        if (protocolSchema == null || StringUtils.isEmpty((CharSequence)protocolSchema)) {
            protocolSchema = req.getScheme();
        }
        String protocol = protocolSchema != null && protocolSchema.trim().toLowerCase().startsWith("https") ? "https://" : "http://";
        String hostnameAsync = null;
        if (asyncMode) {
            hostnameAsync = properties.getProxyReadJMXResourcesAsyncProcessByTimerHostname();
        }
        int port = req.getLocalPort();
        if (asyncMode && properties.getProxyReadJMXResourcesAsyncProcessByTimerPort() != null && properties.getProxyReadJMXResourcesAsyncProcessByTimerPort() > 0) {
            port = properties.getProxyReadJMXResourcesAsyncProcessByTimerPort();
        } else if (properties.getProxyReadJMXResourcesPort() != null && properties.getProxyReadJMXResourcesPort() > 0) {
            port = properties.getProxyReadJMXResourcesPort();
        }
        Object context = req.getContextPath();
        if (!((String)context).endsWith("/")) {
            context = (String)context + "/";
        }
        context = (String)context + "check";
        Map<String, List<String>> parameters = this.buildParameters(req);
        boolean https = properties.isProxyReadJMXResourcesHttpsEnabled();
        boolean verificaHostname = false;
        boolean autenticazioneServer = false;
        String autenticazioneServerPath = null;
        String autenticazioneServerType = null;
        String autenticazioneServerPassword = null;
        if (https) {
            verificaHostname = properties.isProxyReadJMXResourcesHttpsEnabledVerificaHostName();
            autenticazioneServer = properties.isProxyReadJMXResourcesHttpsEnabledAutenticazioneServer();
            if (autenticazioneServer) {
                autenticazioneServerPath = properties.getProxyReadJMXResourcesHttpsEnabledAutenticazioneServerTruststorePath();
                autenticazioneServerType = properties.getProxyReadJMXResourcesHttpsEnabledAutenticazioneServerTruststoreType();
                autenticazioneServerPassword = properties.getProxyReadJMXResourcesHttpsEnabledAutenticazioneServerTruststorePassword();
            }
        }
        int readTimeout = properties.getProxyReadJMXResourcesReadTimeout();
        int connectTimeout = properties.getProxyReadJMXResourcesConnectionTimeout();
        String usernameCheck = properties.getCheckReadJMXResourcesUsername();
        String passwordCheck = properties.getCheckReadJMXResourcesPassword();
        String resourceName = req.getParameter("resourceName");
        if (resourceName != null && !"".equals(resourceName)) {
            String username = properties.getProxyReadJMXResourcesUsername();
            String password = properties.getProxyReadJMXResourcesPassword();
            if (username != null && password != null) {
                HttpServletCredential identity = new HttpServletCredential(req, log);
                if (!username.equals(identity.getUsername())) {
                    String msg = "Servizio non autorizzato";
                    String logMsg = msg + ". Richiesta effettuata da username [" + identity.getUsername() + "] sconosciuto";
                    Proxy.sendError(res, log, msg, 500, logMsg);
                    return;
                }
                if (!password.equals(identity.getPassword())) {
                    String msg = "Servizio non autorizzato";
                    String logMsg = msg + ". Richiesta effettuata da username [" + identity.getUsername() + "] (password errata)";
                    Proxy.sendError(res, log, msg, 500, logMsg);
                    return;
                }
            }
            String attributeName = req.getParameter("attributeName");
            String attributeValue = req.getParameter("attributeValue");
            String attributeBooleanValue = req.getParameter("attributeBooleanValue");
            String methodName = req.getParameter("methodName");
            String parameterValues = Proxy.formatParameters(req);
            Proxy.logDebug(log, "==============");
            if (attributeName != null) {
                Proxy.logDebug(log, "resourceName[" + resourceName + "] attributeName[" + attributeName + "] attributeValue[" + attributeValue + "] attributeBooleanValue[" + attributeBooleanValue + "] ...");
            } else {
                Proxy.logDebug(log, "resourceName[" + resourceName + "] methodName[" + methodName + "]" + parameterValues + " ...");
            }
            boolean invokeAllNodes = false;
            boolean aggregate = false;
            String resourcePrefix = "[resource: " + resourceName + "] ";
            String tipoOperazioneAsync = null;
            int asyncCheckInterval = properties.getProxyReadJMXResourcesAsyncProcessByTimerCheckInterval();
            if (asyncMode) {
                tipoOperazioneAsync = attributeName != null && (attributeValue != null || attributeBooleanValue != null) ? resourcePrefix + "setAttribute '" + attributeName + "'" : resourcePrefix + methodName;
            }
            if (attributeName != null && (attributeValue != null || attributeBooleanValue != null)) {
                invokeAllNodes = true;
            } else if (methodName != null) {
                if ("resetCache".equals(methodName) || "removeObjectCache".equals(methodName)) {
                    invokeAllNodes = true;
                } else if ("DatiRichieste".equals(resourceName) && ("removeRateLimitingGlobalConfigCache".equals(methodName) || "removeRateLimitingAPIConfigCache".equals(methodName))) {
                    invokeAllNodes = true;
                } else if ("ConfigurazionePdD".equals(resourceName) && (methodName.startsWith("ripulisciRiferimentiCache") || "enablePortaDelegata".equals(methodName) || "disablePortaDelegata".equals(methodName) || "enablePortaApplicativa".equals(methodName) || "disablePortaApplicativa".equals(methodName) || "enableConnettoreMultiplo".equals(methodName) || "disableConnettoreMultiplo".equals(methodName) || "enableSchedulingConnettoreMultiplo".equals(methodName) || "disableSchedulingConnettoreMultiplo".equals(methodName) || "enableSchedulingConnettoreMultiploRuntimeRepository".equals(methodName) || "disableSchedulingConnettoreMultiploRuntimeRepository".equals(methodName))) {
                    invokeAllNodes = true;
                } else if ("StatoServiziPdD".equals(resourceName) && ("abilitaServizioPortaDelegata".equals(methodName) || "disabilitaServizioPortaDelegata".equals(methodName) || "abilitaServizioPortaApplicativa".equals(methodName) || "disabilitaServizioPortaApplicativa".equals(methodName) || "abilitaServizioIntegrationManager".equals(methodName) || "disabilitaServizioIntegrationManager".equals(methodName))) {
                    invokeAllNodes = true;
                } else if ("LoadBalancer".equals(resourceName) && ("updateConnettoriPrioritari".equals(methodName) || "resetConnettoriPrioritari".equals(methodName))) {
                    invokeAllNodes = true;
                } else if ("MonitoraggioRisorse".equals(resourceName) && ("getUsedDBConnections".equals(methodName) || "getUsedQueueConnections".equals(methodName) || "getActiveTransactions".equals(methodName) || "getActiveProtocolIds".equals(methodName) || "getActivePDConnections".equals(methodName) || "getActivePAConnections".equals(methodName)) || "DatasourceGW".equals(resourceName) && "getUsedConnections".equals(methodName) || "LoadBalancer".equals(resourceName) && "getThreadPoolStatus".equals(methodName)) {
                    invokeAllNodes = true;
                    aggregate = true;
                    if (asyncMode) {
                        String msg = SERVIZIO_NON_DISPONIBILE;
                        String logMsg = msg + ". L'operazione richiesta (" + resourcePrefix + methodName + ") richiede un'aggregazione non attuabile in modalit\u00e0 asincrona";
                        Proxy.sendError(res, log, msg, 500, logMsg);
                        return;
                    }
                }
            }
            if (invokeAllNodes) {
                HttpResponse httpResponseFailed = null;
                HttpResponse httpResponseOk = null;
                String urlT = null;
                Throwable t = null;
                ResultAggregate resultAggregate = null;
                Proxy.logDebug(log, "Invoke all node ...");
                List<String> lUsed = list;
                if (asyncMode) {
                    lUsed = new ArrayList<String>();
                    lUsed.add("localhost");
                }
                for (String hostname : lUsed) {
                    String url = null;
                    try {
                        boolean error;
                        String hostnameUsed = hostname;
                        if (asyncMode && hostnameAsync != null && StringUtils.isNotEmpty((CharSequence)hostnameAsync)) {
                            hostnameUsed = hostnameAsync;
                        }
                        int portUsed = port;
                        Integer portHostname = properties.getProxyReadJMXResourcesPort(hostname);
                        if (portHostname != null && portHostname > 0) {
                            portUsed = portHostname;
                        }
                        boolean addContext = !asyncMode || !saveContextOnlyOperation;
                        url = this.buildUrl(log, addContext, protocol, hostnameUsed, portUsed, (String)context, parameters);
                        if (aggregate && asyncMode) {
                            throw new CoreException("L'operazione richiesta (" + url + ") richiede un'aggregazione non attuabile in modalit\u00e0 asincrona");
                        }
                        HttpResponse httpResponse = null;
                        httpResponse = asyncMode ? this.saveOperation(proxyOperationService, url, tipoOperazioneAsync, log, asyncCheckInterval) : Proxy.invokeHttp(url, readTimeout, connectTimeout, usernameCheck, passwordCheck, https, verificaHostname, autenticazioneServer, autenticazioneServerPath, autenticazioneServerType, autenticazioneServerPassword);
                        String sResponse = null;
                        if (httpResponse.getContent() != null) {
                            sResponse = new String(httpResponse.getContent());
                        }
                        boolean bl = error = sResponse != null && sResponse.startsWith("Operazione non riuscita: ");
                        if (httpResponse.getResultHTTPOperation() == 200 && !error) {
                            if (httpResponseOk == null) {
                                httpResponseOk = httpResponse;
                            }
                            if (aggregate) {
                                if (resultAggregate == null) {
                                    resultAggregate = new ResultAggregate(resourceName, methodName);
                                }
                                resultAggregate.addResponse(sResponse, hostname);
                            }
                        } else if (httpResponseFailed == null) {
                            httpResponseFailed = httpResponse;
                        }
                        Proxy.logDebug(log, "Invoked '" + hostname + "' (" + httpResponse.getResultHTTPOperation() + ")");
                    }
                    catch (Exception e) {
                        String msg = "(" + hostname + ") Servizio non disponibile";
                        t = new Exception(msg, e);
                        urlT = url;
                    }
                }
                if (t != null) {
                    msg = t.getMessage();
                    logMsg = "error occurs: " + t.getMessage();
                    Proxy.sendError(res, log, msg, 500, logMsg, t);
                } else if (httpResponseFailed != null) {
                    Proxy.logDebug(log, "Invoke all node complete 'ERROR'");
                    this.writeResponse(httpResponseFailed, res, log);
                } else if (resultAggregate != null) {
                    Proxy.logDebug(log, "Invoke all node complete 'Aggregate OK'");
                    this.writeResponse(resultAggregate.getHttpResponse(), res, log);
                } else if (httpResponseOk != null) {
                    Proxy.logDebug(log, "Invoke all node complete 'OK'");
                    this.writeResponse(httpResponseOk, res, log);
                } else {
                    msg = SERVIZIO_NON_DISPONIBILE;
                    logMsg = "'CasoNonPrevisto' (url: " + urlT + ") " + msg;
                    Proxy.sendError(res, log, msg, 500, logMsg);
                }
            } else {
                Proxy.logDebug(log, "Invoke single node '" + list.get(0) + "' ...");
                String url = null;
                try {
                    String hostname;
                    String hostnameUsed = hostname = list.get(0);
                    if (asyncMode && hostnameAsync != null && StringUtils.isNotEmpty((CharSequence)hostnameAsync)) {
                        hostnameUsed = hostnameAsync;
                    }
                    int portUsed = port;
                    Integer portHostname = properties.getProxyReadJMXResourcesPort(hostname);
                    if (portHostname != null && portHostname > 0) {
                        portUsed = portHostname;
                    }
                    url = this.buildUrl(log, true, protocol, hostnameUsed, portUsed, (String)context, parameters);
                    HttpResponse httpResponse = Proxy.invokeHttp(url, readTimeout, connectTimeout, usernameCheck, passwordCheck, https, verificaHostname, autenticazioneServer, autenticazioneServerPath, autenticazioneServerType, autenticazioneServerPassword);
                    this.writeResponse(httpResponse, res, log);
                }
                catch (Exception e) {
                    String msg = SERVIZIO_NON_DISPONIBILE;
                    String logMsg = msg + " (url: " + url + "): " + e.getMessage();
                    Proxy.sendError(res, log, msg, 500, logMsg, e);
                }
            }
        } else {
            Proxy.logDebug(log, "Invoke single node CHECK '" + list.get(0) + "' ...");
            String url = null;
            try {
                String hostname;
                String hostnameUsed = hostname = list.get(0);
                if (asyncMode && hostnameAsync != null && StringUtils.isNotEmpty((CharSequence)hostnameAsync)) {
                    hostnameUsed = hostnameAsync;
                }
                int portUsed = port;
                Integer portHostname = properties.getProxyReadJMXResourcesPort(hostname);
                if (portHostname != null && portHostname > 0) {
                    portUsed = portHostname;
                }
                url = this.buildUrl(log, true, protocol, hostnameUsed, portUsed, (String)context, parameters);
                HttpResponse httpResponse = Proxy.invokeHttp(url, readTimeout, connectTimeout, usernameCheck, passwordCheck, https, verificaHostname, autenticazioneServer, autenticazioneServerPath, autenticazioneServerType, autenticazioneServerPassword);
                this.writeResponse(httpResponse, res, log);
            }
            catch (Exception e) {
                String msg = SERVIZIO_NON_DISPONIBILE;
                String logMsg = msg + " (url: " + url + "): " + e.getMessage();
                Proxy.sendError(res, log, msg, 500, logMsg, e);
            }
        }
    }

    public static HttpResponse invokeHttp(String url, int readTimeout, int connectTimeout, String usernameCheck, String passwordCheck, boolean https, boolean verificaHostname, boolean autenticazioneServer, String autenticazioneServerPath, String autenticazioneServerType, String autenticazioneServerPassword) throws UtilsException {
        HttpResponse response = null;
        if (https) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.setUrl(url);
            httpRequest.setConnectTimeout(connectTimeout);
            httpRequest.setReadTimeout(readTimeout);
            httpRequest.setUsername(usernameCheck);
            httpRequest.setPassword(passwordCheck);
            httpRequest.setMethod(HttpRequestMethod.GET);
            httpRequest.setHostnameVerifier(verificaHostname);
            if (autenticazioneServer) {
                httpRequest.setTrustStorePath(autenticazioneServerPath);
                httpRequest.setTrustStoreType(autenticazioneServerType);
                httpRequest.setTrustStorePassword(autenticazioneServerPassword);
            } else {
                httpRequest.setTrustAllCerts(true);
            }
            response = HttpUtilities.httpInvoke((HttpRequest)httpRequest);
        } else {
            response = HttpUtilities.getHTTPResponse((String)url, (int)readTimeout, (int)connectTimeout, (String)usernameCheck, (String)passwordCheck);
        }
        return response;
    }

    private HttpResponse saveOperation(IProxyOperationService proxyOperationService, String url, String description, Logger log, int asyncCheckInterval) {
        HttpResponse response = new HttpResponse();
        try {
            ProxyOperation proxyOperation = new ProxyOperation();
            proxyOperation.setCommand(url);
            proxyOperation.setDescription(description);
            proxyOperation.setRegistrationTime(DateManager.getDate());
            proxyOperationService.save(proxyOperation);
            response.setResultHTTPOperation(200);
            response.setContentType("text/plain");
            response.setContent(("Operazione effettuata con successo; " + "la richiesta \u00e8 stata registrata e verr\u00e0 evasa entro SECONDI secondi".replace("SECONDI", "" + asyncCheckInterval)).getBytes());
        }
        catch (Exception t) {
            response.setResultHTTPOperation(500);
            response.setContentType("text/plain");
            Proxy.logError(log, "[Proxy] saveOperation failed: " + t.getMessage(), t);
            response.setContent(("Operazione non riuscita: " + t.getMessage()).getBytes());
        }
        return response;
    }

    private void writeResponse(HttpResponse httpResponse, HttpServletResponse res, Logger log) {
        try {
            res.setStatus(httpResponse.getResultHTTPOperation());
            if (httpResponse.getContentType() != null) {
                res.setContentType(httpResponse.getContentType());
            }
            if (httpResponse.getContent() != null) {
                res.getOutputStream().write(httpResponse.getContent());
            }
        }
        catch (Exception t) {
            Proxy.logError(log, "[Proxy] WriteResponse failed: " + t.getMessage(), t);
        }
    }

    private String buildUrl(Logger log, boolean addContext, String protocol, String hostname, int port, String context, Map<String, List<String>> parameters) {
        StringBuilder sb = new StringBuilder();
        if (addContext) {
            sb.append(protocol);
            sb.append(hostname);
            sb.append(":");
            sb.append(port);
        }
        sb.append(context);
        return TransportUtils.buildUrlWithParameters(parameters, (String)sb.toString(), (Logger)log);
    }

    private Map<String, List<String>> buildParameters(HttpServletRequest req) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String nomeProperty = (String)en.nextElement();
            String[] s = req.getParameterValues(nomeProperty);
            ArrayList<String> values = new ArrayList<String>();
            if (s != null && s.length > 0) {
                for (int i = 0; i < s.length; ++i) {
                    String value = s[i];
                    values.add(value);
                }
            } else {
                values.add(req.getParameter(nomeProperty));
            }
            parameters.put(nomeProperty, values);
        }
        return parameters;
    }

    private static String formatParameters(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder("");
        String paramValue = req.getParameter("paramValue");
        if (paramValue != null) {
            sb.append(" ").append("paramValue[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramIntegerValue")) != null) {
            sb.append(" ").append("paramIntValue[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramLongValue")) != null) {
            sb.append(" ").append("paramLongValue[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramBooleanValue")) != null) {
            sb.append(" ").append("paramBooleanValue[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramValue2")) != null) {
            sb.append(" ").append("paramValue2[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramIntegerValue2")) != null) {
            sb.append(" ").append("paramIntValue2[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramLongValue2")) != null) {
            sb.append(" ").append("paramLongValue2[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramBooleanValue2")) != null) {
            sb.append(" ").append("paramBooleanValue2[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramValue3")) != null) {
            sb.append(" ").append("paramValue3[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramIntegerValue3")) != null) {
            sb.append(" ").append("paramIntValue3[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramLongValue3")) != null) {
            sb.append(" ").append("paramLongValue3[").append(paramValue).append("]");
        }
        if ((paramValue = req.getParameter("paramBooleanValue3")) != null) {
            sb.append(" ").append("paramBooleanValue3[").append(paramValue).append("]");
        }
        return sb.toString();
    }
}

