/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.service;

import jakarta.xml.soap.SOAPFault;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreRichieste;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.core.controllo_traffico.SoglieDimensioneMessaggi;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInAcceptRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.transazioni.ConfigurazioneTracciamento;
import org.openspcoop2.pdd.logger.transazioni.InformazioniTransazione;
import org.openspcoop2.pdd.logger.transazioni.TracciamentoManager;
import org.openspcoop2.pdd.services.DirectVMProtocolInfo;
import org.openspcoop2.pdd.services.DumpRaw;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.connector.AsyncResponseCallbackClientEvent;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherErrorInfo;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherInfo;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.IAsyncResponseCallback;
import org.openspcoop2.pdd.services.connector.RicezioneBusteConnector;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.ConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.messages.DumpRawConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.DumpRawConnectorOutMessage;
import org.openspcoop2.pdd.services.core.RicezioneBuste;
import org.openspcoop2.pdd.services.core.RicezioneBusteContext;
import org.openspcoop2.pdd.services.error.RicezioneBusteExternalErrorGenerator;
import org.openspcoop2.pdd.services.service.IRicezioneService;
import org.openspcoop2.pdd.services.service.RicezioneBusteServiceUtils;
import org.openspcoop2.pdd.services.service.RicezionePropertiesConfig;
import org.openspcoop2.protocol.basic.builder.EsitoBuilder;
import org.openspcoop2.protocol.basic.registry.ServiceIdentificationReader;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.InformazioniErroriInfrastrutturali;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.LimitedInputStream;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.TimeoutIOException;
import org.openspcoop2.utils.TimeoutInputStream;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class RicezioneBusteService
implements IRicezioneService,
IAsyncResponseCallback {
    private RicezioneBusteExternalErrorGenerator generatoreErrore;
    private RicezioneBusteContext context = null;
    private IProtocolFactory<?> protocolFactory = null;
    private OpenSPCoop2Properties openSPCoopProperties = null;
    private ProprietaErroreApplicativo proprietaErroreAppl = null;
    private ConnectorInMessage req = null;
    private ConnectorOutMessage res = null;
    private Date dataAccettazioneRichiesta = null;
    private Date dataIngressoRichiesta = null;
    private RequestInfo requestInfo = null;
    private PdDContext pddContext = null;
    private OpenSPCoop2Message requestMessage = null;
    private OpenSPCoop2Message responseMessage = null;
    private Logger logCore = null;
    private MsgDiagnostico msgDiag = null;
    private DumpRaw dumpRaw = null;
    private String idModulo = null;
    private PostOutResponseContext postOutResponseContext = null;
    private String idTransazione = null;

    public RicezioneBusteService(RicezioneBusteExternalErrorGenerator generatoreErrore) {
        this.generatoreErrore = generatoreErrore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ConnectorInMessage reqParam, ConnectorOutMessage resParam, Date dataAccettazioneRichiestaParam, boolean async) throws ConnectorException {
        block169: {
            this.req = reqParam;
            this.res = resParam;
            this.dataAccettazioneRichiesta = dataAccettazioneRichiestaParam;
            this.idModulo = this.req.getIdModulo();
            IDService idModuloAsService = this.req.getIdModuloAsIDService();
            this.requestInfo = this.req.getRequestInfo();
            this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (this.logCore == null) {
                this.logCore = LoggerWrapperFactory.getLogger((String)this.idModulo);
            }
            this.openSPCoopProperties = OpenSPCoop2Properties.getInstance();
            PreInAcceptRequestContext preInAcceptRequestContext = null;
            SogliaReadTimeout sogliaReadTimeout = null;
            if (this.openSPCoopProperties != null && OpenSPCoop2Startup.initialize) {
                preInAcceptRequestContext = new PreInAcceptRequestContext();
                preInAcceptRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
                preInAcceptRequestContext.setIdModulo(this.idModulo);
                preInAcceptRequestContext.setRequestInfo(this.requestInfo);
                preInAcceptRequestContext.setLogCore(this.logCore);
                try {
                    if (this.openSPCoopProperties.isConnettoriUseLimitedInputStream()) {
                        SogliaDimensioneMessaggio soglia = new SogliaDimensioneMessaggio();
                        soglia.setSogliaKb(this.openSPCoopProperties.getLimitedInputStreamThresholdKb());
                        soglia.setUseContentLengthHeader(this.openSPCoopProperties.isLimitedInputStreamUseContentLength());
                        soglia.setUseContentLengthHeaderAcceptZeroValue(this.openSPCoopProperties.isLimitedInputStreamUseContentLengthAcceptZeroValue());
                        soglia.setPolicyGlobale(true);
                        soglia.setNomePolicy("GovWayCore");
                        soglia.setIdPolicyConGruppo("GovWayCore");
                        this.req.setRequestLimitedStream(soglia);
                    }
                    if (this.openSPCoopProperties.isConnettoriUseTimeoutInputStream()) {
                        sogliaReadTimeout = new SogliaReadTimeout();
                        sogliaReadTimeout.setSogliaMs(this.openSPCoopProperties.getReadConnectionTimeoutRicezioneBuste());
                        sogliaReadTimeout.setConfigurazioneGlobale(true);
                        sogliaReadTimeout.setIdConfigurazione("GovWayCore");
                        this.req.setRequestReadTimeout(sogliaReadTimeout);
                    }
                    this.req.setThresholdContext(null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository());
                }
                catch (Throwable t) {
                    this.logCore.error(t.getMessage(), t);
                }
                preInAcceptRequestContext.setReq(this.req);
                GestoreHandlers.preInRequest(preInAcceptRequestContext, this.logCore, this.logCore);
            }
            try {
                if (this.generatoreErrore == null) {
                    this.generatoreErrore = new RicezioneBusteExternalErrorGenerator(this.logCore, RicezioneBusteConnector.ID_MODULO, this.requestInfo, null);
                }
            }
            catch (Exception e) {
                String msg = "Inizializzazione Generatore Errore fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
                this.logCore.error(msg, (Throwable)e);
                ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, (Throwable)e, null, this.res, this.logCore, false);
                this.res.close(false);
                RicezioneBusteServiceUtils.emitTransaction(this.logCore, this.req, null, this.dataAccettazioneRichiesta, cInfo);
                return;
            }
            if (!OpenSPCoop2Startup.initialize || this.openSPCoopProperties == null) {
                String msg = "Inizializzazione di GovWay non correttamente effettuata: OpenSPCoopProperties";
                if (!OpenSPCoop2Startup.initialize) {
                    msg = "Inizializzazione di GovWay non correttamente effettuata";
                }
                this.logCore.error(msg);
                ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, null, null, this.res, this.logCore, false);
                this.res.close(false);
                RicezioneBusteServiceUtils.emitTransaction(this.logCore, this.req, null, this.dataAccettazioneRichiesta, cInfo);
                return;
            }
            ConfigurazionePdDManager configPdDManager = null;
            try {
                configPdDManager = ConfigurazionePdDManager.getInstance();
                if (configPdDManager == null || !configPdDManager.isInitializedConfigurazionePdDReader()) {
                    throw new CoreException("ConfigurazionePdDManager not initialized");
                }
            }
            catch (Exception e) {
                String msg = "Inizializzazione di GovWay non correttamente effettuata: ConfigurazionePdDManager";
                this.logCore.error(msg);
                ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, (Throwable)e, null, this.res, this.logCore, false);
                this.res.close(false);
                RicezioneBusteServiceUtils.emitTransaction(this.logCore, this.req, null, this.dataAccettazioneRichiesta, cInfo);
                return;
            }
            Object oPddContextFromServlet = this.req.getAttribute((String)((Object)CostantiPdD.OPENSPCOOP2_PDD_CONTEXT_HEADER_HTTP.getValue()));
            PdDContext pddContextFromServlet = null;
            if (oPddContextFromServlet != null) {
                pddContextFromServlet = (PdDContext)oPddContextFromServlet;
            }
            if (this.requestInfo == null) {
                this.res.close(false);
                String msg = "RequestInfo undefined";
                this.logCore.error(msg);
                return;
            }
            ServiceIdentificationReader serviceIdentificationReader = null;
            try {
                serviceIdentificationReader = ServicesUtils.getServiceIdentificationReader(this.logCore, this.requestInfo, configPdDManager.getRegistroServiziManager(), configPdDManager);
            }
            catch (Exception e) {
                String msg = "Inizializzazione RegistryReader fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
                this.logCore.error(msg, (Throwable)e);
                ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, (Throwable)e, null, this.res, this.logCore, false);
                this.res.close(false);
                RicezioneBusteServiceUtils.emitTransaction(this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
                return;
            }
            try {
                this.context = new RicezioneBusteContext(idModuloAsService, this.dataAccettazioneRichiesta, this.requestInfo);
                this.protocolFactory = this.req.getProtocolFactory();
                this.idTransazione = (String)this.context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
            }
            catch (Throwable e) {
                this.context = null;
                this.protocolFactory = null;
            }
            try {
                GestoreRichieste.readRequestConfig(this.requestInfo);
            }
            catch (Exception e) {
                String msg = "GestoreRichieste readRequestConfig fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
                this.logCore.error(msg, (Throwable)e);
                ConnectorDispatcherErrorInfo cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_500_ERRORE_INTERNO), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, (Throwable)e, null, this.res, this.logCore, false);
                this.res.close(false);
                RicezioneBusteServiceUtils.emitTransaction(this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
                return;
            }
            if (this.idTransazione != null) {
                try {
                    if (this.openSPCoopProperties.isTransazioniEnabled()) {
                        TransactionContext.createTransaction(this.idTransazione, "RicezioneBuste.1");
                    }
                    this.requestInfo.setIdTransazione(this.idTransazione);
                    this.generatoreErrore.getImbustamentoErrore().setIdTransazione(this.idTransazione);
                    this.req.setThresholdContext(this.context != null ? this.context.getPddContext() : null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository());
                }
                catch (Throwable e) {
                    this.context = null;
                    this.protocolFactory = null;
                }
            }
            String nomePorta = this.requestInfo.getProtocolContext().getInterfaceName();
            this.msgDiag = MsgDiagnostico.newInstance(TipoPdD.APPLICATIVA, this.idModulo, nomePorta, this.requestInfo);
            this.msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
            if (this.context != null && this.protocolFactory != null) {
                this.msgDiag.setPddContext(this.context.getPddContext(), this.protocolFactory);
            }
            try {
                this.msgDiag.logPersonalizzato("ricezioneRichiesta.firstLog");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico di ingresso", (Throwable)e);
            }
            try {
                this.req.setDiagnosticProducer(this.context != null ? this.context.getPddContext() : null, this.msgDiag);
            }
            catch (Throwable e) {
                this.logCore.error("Errore registrazione diagnostico sulla richiesta", e);
            }
            GestoreHandlers.emitDiagnostic(this.msgDiag, preInAcceptRequestContext, this.context != null ? this.context.getPddContext() : null, this.logCore, this.logCore);
            try {
                this.msgDiag.mediumDebug("Accesso configurazione della richiesta in corso...");
            }
            catch (Exception e) {
                this.logCore.error("Errore generazione diagnostico", (Throwable)e);
            }
            ConnectorDispatcherInfo cInfo = RicezioneBusteServiceUtils.updatePortaApplicativaRequestInfo(this.requestInfo, this.logCore, this.req, this.res, this.generatoreErrore, serviceIdentificationReader, this.msgDiag, this.context != null ? this.context.getPddContext() : null);
            if (cInfo != null) {
                this.res.close(false);
                RicezioneBusteServiceUtils.emitTransaction(this.context, this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
                return;
            }
            this.req.updateRequestInfo(this.requestInfo);
            try {
                try {
                    this.msgDiag.mediumDebug("Lettura configurazione dump binario ...");
                }
                catch (Exception e) {
                    this.logCore.error("Errore generazione diagnostico", (Throwable)e);
                }
                boolean dumpBinario = configPdDManager.dumpBinarioPA();
                PortaApplicativa pa = null;
                if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null && this.requestInfo.getProtocolContext().getInterfaceName() != null) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(this.requestInfo.getProtocolContext().getInterfaceName());
                    pa = configPdDManager.getPortaApplicativaSafeMethod(idPA, this.requestInfo);
                }
                try {
                    this.msgDiag.mediumDebug("Lettura configurazione dimensione massima della richiesta ...");
                }
                catch (Exception e) {
                    this.logCore.error("Errore generazione diagnostico", (Throwable)e);
                }
                String azione = this.requestInfo != null && this.requestInfo.getIdServizio() != null ? this.requestInfo.getIdServizio().getAzione() : null;
                SoglieDimensioneMessaggi limitedInputStream = configPdDManager.getSoglieLimitedInputStream(pa, azione, this.idModulo, this.context != null && this.context.getPddContext() != null ? this.context.getPddContext() : null, this.requestInfo, this.protocolFactory, this.logCore);
                if (limitedInputStream != null) {
                    this.req.setRequestLimitedStream(limitedInputStream.getRichiesta());
                    if (this.context != null && this.context.getPddContext() != null) {
                        this.context.getPddContext().addObject(Costanti.LIMITED_STREAM, limitedInputStream.getRisposta());
                    }
                } else if (!this.openSPCoopProperties.isLimitedInputStreamThresholdDefined()) {
                    this.req.disableLimitedStream();
                }
                try {
                    this.msgDiag.mediumDebug("Lettura configurazione timeout per la lettura della richiesta ...");
                }
                catch (Exception e) {
                    this.logCore.error("Errore generazione diagnostico", (Throwable)e);
                }
                boolean useTimeoutInputStream = configPdDManager.isConnettoriUseTimeoutInputStream(pa);
                if (useTimeoutInputStream) {
                    sogliaReadTimeout = configPdDManager.getRequestReadTimeout(pa, this.requestInfo, this.protocolFactory, (Context)(this.context != null ? this.context.getPddContext() : null), null);
                    if (sogliaReadTimeout != null && sogliaReadTimeout.getSogliaMs() > 0) {
                        this.req.setRequestReadTimeout(sogliaReadTimeout);
                    } else {
                        this.req.disableReadTimeout();
                    }
                } else {
                    this.req.disableReadTimeout();
                }
                try {
                    this.msgDiag.mediumDebug("Lettura configurazione dump ...");
                }
                catch (Exception e) {
                    this.logCore.error("Errore generazione diagnostico", (Throwable)e);
                }
                DumpConfigurazione dumpConfigurazione = configPdDManager.getDumpConfigurazione(pa);
                ConfigurazioneTracciamento configurazioneTracciamento = new ConfigurazioneTracciamento(this.logCore, configPdDManager, pa);
                boolean fileTraceHeaders = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioHeaderEnabled();
                boolean fileTracePayload = configurazioneTracciamento.isTransazioniFileTraceDumpBinarioPayloadEnabled();
                this.dumpRaw = new DumpRaw(this.logCore, this.requestInfo.getIdentitaPdD(), this.idModulo, TipoPdD.APPLICATIVA, dumpBinario, dumpConfigurazione, fileTraceHeaders, fileTracePayload);
                if (this.dumpRaw.isActiveDumpRichiesta()) {
                    this.req = new DumpRawConnectorInMessage(this.logCore, this.req, this.context != null ? this.context.getPddContext() : null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository());
                }
                if (this.dumpRaw.isActiveDumpRisposta()) {
                    this.res = new DumpRawConnectorOutMessage(this.logCore, this.res, this.context != null ? this.context.getPddContext() : null, this.openSPCoopProperties.getDumpBinarioInMemoryThreshold(), this.openSPCoopProperties.getDumpBinarioRepository(), this.dumpRaw);
                }
            }
            catch (Throwable e) {
                String msg = "Inizializzazione di GovWay non correttamente effettuata: DumpRaw";
                this.logCore.error(msg, e);
                cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, e, null, this.res, this.logCore, false);
                this.res.close(false);
                RicezioneBusteServiceUtils.emitTransaction(this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfo);
                return;
            }
            if (this.context != null && this.context.getPddContext() != null && sogliaReadTimeout != null && sogliaReadTimeout.getSogliaMs() > 0) {
                this.context.getPddContext().put(CostantiPdD.REQUEST_READ_TIMEOUT, sogliaReadTimeout.getSogliaMs());
            }
            if (ServiceBinding.SOAP.equals((Object)this.requestInfo.getProtocolServiceBinding())) {
                HttpRequestMethod method = null;
                if (this.req != null && this.req.getURLProtocolContext() != null && this.req.getURLProtocolContext().getRequestType() != null) {
                    try {
                        method = HttpRequestMethod.valueOf((String)this.req.getURLProtocolContext().getRequestType());
                    }
                    catch (Exception msg) {
                        // empty catch block
                    }
                }
                if (method != null && !HttpRequestMethod.POST.equals(method)) {
                    if (ServicesUtils.isRequestWsdl(this.req, this.logCore)) {
                        try {
                            ServicesUtils.writeWsdl(this.res, this.requestInfo, RicezioneBusteConnector.ID_SERVICE, serviceIdentificationReader, this.logCore);
                        }
                        catch (Exception e) {
                            String msg = "Lettura wsdl fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
                            this.logCore.error(msg, (Throwable)e);
                            cInfo = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_500_ERRORE_INTERNO), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, (Throwable)e, null, this.res, this.logCore, false);
                        }
                        finally {
                            if (this.openSPCoopProperties.isTransazioniEnabled()) {
                                this.idTransazione = (String)this.context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                                TransactionContext.removeTransaction(this.idTransazione);
                            }
                        }
                        this.res.close(false);
                        return;
                    }
                    String msg = "Metodo http '" + String.valueOf(method) + "' non supportato dall'API SOAP invocata";
                    this.logCore.error(msg);
                    ConnectorDispatcherErrorInfo cInfoError = ConnectorDispatcherUtils.doError(this.requestInfo, this.generatoreErrore, ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(msg, this.protocolFactory), IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL, null, null, this.res, this.logCore, false);
                    this.res.close(false);
                    RicezioneBusteServiceUtils.emitTransaction(this.context, this.logCore, this.req, pddContextFromServlet, this.dataAccettazioneRichiesta, cInfoError);
                    return;
                }
            }
            String protocol = null;
            MessageType messageTypeReq = null;
            ServiceBinding protocolServiceBinding = null;
            boolean completeProcess = false;
            try {
                try {
                    this.msgDiag.mediumDebug("Creazione contesto ...");
                }
                catch (Exception e) {
                    this.logCore.error("Errore generazione diagnostico", (Throwable)e);
                }
                if (this.protocolFactory == null) {
                    this.protocolFactory = this.req.getProtocolFactory();
                }
                protocol = this.protocolFactory.getProtocol();
                protocolServiceBinding = this.requestInfo.getProtocolServiceBinding();
                this.proprietaErroreAppl = this.openSPCoopProperties.getProprietaGestioneErrorePD(this.protocolFactory.createProtocolManager());
                this.proprietaErroreAppl.setDominio(this.openSPCoopProperties.getIdentificativoPortaDefault(this.protocolFactory.getProtocol(), this.requestInfo));
                this.proprietaErroreAppl.setIdModulo(this.idModulo);
                if (this.context == null) {
                    this.context = new RicezioneBusteContext(idModuloAsService, this.dataAccettazioneRichiesta, this.requestInfo);
                }
                if (preInAcceptRequestContext != null && preInAcceptRequestContext.getPreContext() != null && !preInAcceptRequestContext.getPreContext().isEmpty()) {
                    this.context.getPddContext().addAll((Map)preInAcceptRequestContext.getPreContext(), false);
                }
                this.context.getPddContext().addObject(Costanti.PROTOCOL_NAME, this.protocolFactory.getProtocol());
                this.context.getPddContext().addObject(Costanti.REQUEST_INFO, this.req.getRequestInfo());
                RicezionePropertiesConfig rConfig = RicezioneBusteServiceUtils.readPropertiesConfig(this.req.getRequestInfo(), this.logCore, null);
                if (rConfig != null) {
                    if (rConfig.getApiImplementation() != null && !rConfig.getApiImplementation().isEmpty()) {
                        this.context.getPddContext().addObject(Costanti.PROPRIETA_CONFIGURAZIONE, rConfig.getApiImplementation());
                    }
                    if (rConfig.getSoggettoErogatore() != null && !rConfig.getSoggettoErogatore().isEmpty()) {
                        this.context.getPddContext().addObject(Costanti.PROPRIETA_SOGGETTO_EROGATORE, rConfig.getSoggettoErogatore());
                    }
                }
                this.context.setTipoPorta(TipoPdD.APPLICATIVA);
                this.context.setIdModulo(this.idModulo);
                this.msgDiag.setPddContext(this.context.getPddContext(), this.protocolFactory);
                this.pddContext = this.context.getPddContext();
                DynamicMapBuilderUtils.injectDynamicMap(null, this.requestInfo, (Map<Object>)this.pddContext, this.logCore);
                try {
                    if (this.openSPCoopProperties.isTransazioniEnabled()) {
                        TransactionContext.createTransaction((String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE), "RicezioneBuste.2");
                    }
                }
                catch (Exception e) {
                    this.logCore.error("Errore durante la creazione della transazione", (Throwable)e);
                }
                try {
                    this.msgDiag.logPersonalizzato("ricezioneRichiesta.firstAccessRequestStream");
                }
                catch (Exception e) {
                    this.logCore.error("Errore generazione diagnostico di ingresso (stream access)", (Throwable)e);
                }
                if (this.dumpRaw != null && this.dumpRaw.isActiveDump()) {
                    this.dumpRaw.setPddContext(this.msgDiag.getPorta(), this.context.getPddContext());
                    this.dumpRaw.serializeContext(this.context, protocol);
                }
                DirectVMConnectorInMessage vm = null;
                ConnectorInMessage connectorInMessage = this.req;
                if (connectorInMessage instanceof DirectVMConnectorInMessage) {
                    DirectVMConnectorInMessage directvmconnectorinmessage;
                    vm = directvmconnectorinmessage = (DirectVMConnectorInMessage)connectorInMessage;
                } else {
                    DumpRawConnectorInMessage dumprawconnectorinmessage;
                    connectorInMessage = this.req;
                    if (connectorInMessage instanceof DumpRawConnectorInMessage && (connectorInMessage = (dumprawconnectorinmessage = (DumpRawConnectorInMessage)connectorInMessage).getWrappedConnectorInMessage()) instanceof DirectVMConnectorInMessage) {
                        DirectVMConnectorInMessage directvmconnectorInmessage;
                        vm = directvmconnectorInmessage = (DirectVMConnectorInMessage)connectorInMessage;
                    }
                }
                if (vm != null && vm.getDirectVMProtocolInfo() != null) {
                    vm.getDirectVMProtocolInfo().setInfo(this.pddContext);
                }
                this.postOutResponseContext = new PostOutResponseContext(this.logCore, this.protocolFactory);
                this.postOutResponseContext.setTipoPorta(TipoPdD.APPLICATIVA);
                this.postOutResponseContext.setPddContext(this.pddContext);
                this.postOutResponseContext.setIdModulo(this.idModulo);
                PreInRequestContext preInRequestContext = new PreInRequestContext(this.pddContext);
                if (pddContextFromServlet != null) {
                    preInRequestContext.getPddContext().addAll((Map)pddContextFromServlet, true);
                }
                preInRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
                preInRequestContext.setIdModulo(this.idModulo);
                preInRequestContext.setProtocolFactory(this.protocolFactory);
                preInRequestContext.setRequestInfo(this.requestInfo);
                HashMap<String, Object> transportContext = new HashMap<String, Object>();
                transportContext.put("SERVLET_REQUEST", this.req);
                transportContext.put("SERVLET_RESPONSE", this.res);
                preInRequestContext.setTransportContext(transportContext);
                preInRequestContext.setLogCore(this.logCore);
                GestoreHandlers.preInRequest(preInRequestContext, this.msgDiag, this.logCore);
                this.pddContext.addAll((Map)preInRequestContext.getPddContext(), false);
                NotifierInputStreamParams notifierInputStreamParams = preInRequestContext.getNotifierInputStreamParams();
                this.context.setNotifierInputStreamParams(notifierInputStreamParams);
                this.req.checkContentLengthLimit();
                if (this.dumpRaw != null && this.dumpRaw.isActiveDumpRichiesta()) {
                    this.dumpRaw.serializeRequest((DumpRawConnectorInMessage)this.req, true, notifierInputStreamParams);
                    this.dataIngressoRichiesta = this.req.getDataIngressoRichiesta();
                    this.context.setDataIngressoRichiesta(this.dataIngressoRichiesta);
                }
                this.msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.tipologiaMessaggio");
                messageTypeReq = this.requestInfo.getProtocolRequestMessageType();
                if (ServiceBinding.SOAP.equals((Object)protocolServiceBinding) && messageTypeReq != null) {
                    this.msgDiag.addKeyword("@SOAP_VERSION@", messageTypeReq.getMessageVersionAsString());
                    this.msgDiag.addKeyword("@SOAP_NAMESPACE_ATTESO@", SoapUtils.getSoapEnvelopeNS((MessageType)messageTypeReq));
                }
                String contentTypeReq = this.req.getContentType();
                boolean contentTypeSupportato = messageTypeReq != null;
                this.msgDiag.addKeyword("@CONTENT_TYPES_ATTESI@", this.requestInfo.getBindingConfig().getContentTypesSupportedAsString(protocolServiceBinding, MessageRole.REQUEST, (TransportRequestContext)this.requestInfo.getProtocolContext()));
                List supportedContentTypes = this.requestInfo.getBindingConfig().getContentTypesSupported(protocolServiceBinding, MessageRole.REQUEST, (TransportRequestContext)this.requestInfo.getProtocolContext());
                this.msgDiag.addKeyword("@HEADER_HTTP@", contentTypeReq);
                if (ServiceBinding.SOAP.equals((Object)protocolServiceBinding) && !this.openSPCoopProperties.isControlloContentTypeAbilitatoRicezioneBuste() && !contentTypeSupportato) {
                    if ("Undefined".equals(contentTypeReq)) {
                        this.msgDiag.logPersonalizzato("contentType.notDefined");
                    } else {
                        this.msgDiag.logPersonalizzato("contentType.unsupported");
                    }
                    messageTypeReq = MessageType.SOAP_11;
                    contentTypeReq = SoapUtils.getSoapContentTypeForMessageWithoutAttachments((MessageType)messageTypeReq);
                    String msgWarn = "Content-Type non supportato, viene utilizzato forzatamente il tipo: " + contentTypeReq;
                    this.logCore.warn(msgWarn);
                    contentTypeSupportato = true;
                }
                if (!contentTypeSupportato) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    if ("Undefined".equals(contentTypeReq)) {
                        this.msgDiag.logPersonalizzato("contentType.notDefined");
                        this.responseMessage = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, IntegrationFunctionError.CONTENT_TYPE_NOT_PROVIDED, ErroriIntegrazione.ERRORE_433_CONTENT_TYPE_NON_PRESENTE.getErrore433_ContentTypeNonPresente(supportedContentTypes));
                    } else {
                        this.msgDiag.logPersonalizzato("contentType.unsupported");
                        this.responseMessage = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, IntegrationFunctionError.CONTENT_TYPE_NOT_SUPPORTED, ErroriIntegrazione.ERRORE_429_CONTENT_TYPE_NON_SUPPORTATO.getErrore429_ContentTypeNonSupportato(contentTypeReq, supportedContentTypes));
                    }
                    break block169;
                }
                try {
                    boolean checkEnabled = false;
                    List<String> ctDefault = null;
                    if (ServiceBinding.SOAP.equals((Object)protocolServiceBinding)) {
                        if (this.openSPCoopProperties.isControlloCharsetContentTypeAbilitatoRicezioneBusteSoap()) {
                            checkEnabled = true;
                            ctDefault = this.openSPCoopProperties.getControlloCharsetContentTypeAbilitatoRicezioneBusteSoap();
                        }
                    } else if (this.openSPCoopProperties.isControlloCharsetContentTypeAbilitatoRicezioneBusteRest()) {
                        checkEnabled = true;
                        ctDefault = this.openSPCoopProperties.getControlloCharsetContentTypeAbilitatoRicezioneBusteRest();
                    }
                    if (checkEnabled) {
                        ServicesUtils.checkCharset(contentTypeReq, ctDefault, this.msgDiag, true, TipoPdD.APPLICATIVA);
                    }
                }
                catch (Throwable t) {
                    this.logCore.error("Avvenuto errore durante il controllo del charset della richiesta: " + t.getMessage(), t);
                }
                String soapAction = null;
                try {
                    if (ServiceBinding.SOAP.equals((Object)protocolServiceBinding)) {
                        soapAction = this.req.getSOAPAction();
                    }
                }
                catch (Exception e) {
                    if (this.dataIngressoRichiesta == null) {
                        this.dataIngressoRichiesta = DateManager.getDate();
                    }
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    throw e;
                }
                this.msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.inCorso");
                Utilities.printFreeMemory((String)"RicezioneBuste - Pre costruzione richiesta");
                OpenSPCoop2MessageParseResult pr = this.req.getRequest(notifierInputStreamParams);
                if (pr.getParseException() != null) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
                }
                this.dataIngressoRichiesta = this.req.getDataIngressoRichiesta();
                this.context.setDataIngressoRichiesta(this.dataIngressoRichiesta);
                this.requestMessage = pr.getMessage_throwParseException();
                Utilities.printFreeMemory((String)"RicezioneBuste - Post costruzione richiesta");
                this.requestMessage.setProtocolName(this.protocolFactory.getProtocol());
                this.requestMessage.setTransactionId(PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.pddContext));
                this.requestMessage.addContextProperty(Costanti.REQUEST_INFO, (Object)this.requestInfo);
                this.requestMessage.addContextProperty(Costanti.ID_TRANSAZIONE, this.pddContext.getObject(Costanti.ID_TRANSAZIONE));
                Object nomePortaInvocataObject = this.context.getPddContext().getObject(CostantiPdD.NOME_PORTA_INVOCATA);
                if (nomePortaInvocataObject instanceof String) {
                    this.requestMessage.addContextProperty(CostantiPdD.NOME_PORTA_INVOCATA, nomePortaInvocataObject);
                }
                String soapEnvelopeNamespaceVersionMismatch = null;
                try {
                    if (ServiceBinding.SOAP.equals((Object)protocolServiceBinding)) {
                        soapEnvelopeNamespaceVersionMismatch = ServicesUtils.checkSOAPEnvelopeNamespace(this.requestMessage.castAsSoap(), messageTypeReq);
                    }
                }
                catch (Exception e) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    throw e;
                }
                String mustUnderstandError = null;
                if (soapEnvelopeNamespaceVersionMismatch == null) {
                    try {
                        if (ServiceBinding.SOAP.equals((Object)protocolServiceBinding)) {
                            mustUnderstandError = ServicesUtils.checkMustUnderstand(this.requestMessage.castAsSoap(), this.protocolFactory);
                        }
                    }
                    catch (Exception e) {
                        this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                        throw e;
                    }
                }
                if (soapAction != null && this.openSPCoopProperties.checkSoapActionQuotedString_ricezioneBuste()) {
                    try {
                        SoapUtils.checkSoapActionQuotedString((String)soapAction, (MessageType)messageTypeReq);
                    }
                    catch (Exception e) {
                        this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                        throw e;
                    }
                }
                try {
                    if (this.requestInfo != null && this.requestInfo.getProtocolContext() != null && this.requestInfo.getProtocolContext().getCredential() != null && this.requestInfo.getProtocolContext().getCredential().getCertificate() != null && this.requestInfo.getProtocolContext().getCredential().getCertificate().getCertificate() != null) {
                        SecurityTokenUtilities.newSecurityToken((Context)this.pddContext);
                    }
                }
                catch (Exception e) {
                    this.logCore.error("Costruzione SecurityToken non riuscito: " + e.getMessage(), (Throwable)e);
                }
                if (mustUnderstandError == null && soapEnvelopeNamespaceVersionMismatch == null) {
                    this.context.setCredenziali(new Credenziali(this.req.getCredential()));
                    this.context.setGestioneRisposta(true);
                    this.context.setMessageRequest(this.requestMessage);
                    this.context.setTracciamentoAbilitato(true);
                    this.context.setUrlProtocolContext(this.requestInfo.getProtocolContext());
                    this.context.setMsgDiagnostico(this.msgDiag);
                    this.msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.completata");
                    this.registraTracciaInRequest();
                    RicezioneBuste gestoreRichiesta = new RicezioneBuste(this.context, this.generatoreErrore, async ? this : null);
                    gestoreRichiesta.process(this.req);
                    completeProcess = true;
                } else if (mustUnderstandError != null) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", mustUnderstandError);
                    this.msgDiag.logPersonalizzato("mustUnderstand.unknown");
                    this.responseMessage = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, IntegrationFunctionError.SOAP_MUST_UNDERSTAND_UNKNOWN, ErroriIntegrazione.ERRORE_427_MUSTUNDERSTAND_ERROR.getErrore427_MustUnderstandHeaders(mustUnderstandError));
                } else {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    this.msgDiag.addKeyword("@SOAP_NAMESPACE@", soapEnvelopeNamespaceVersionMismatch);
                    this.msgDiag.logPersonalizzato("soapEnvelopeNamespace.versionMismatch");
                    this.responseMessage = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, IntegrationFunctionError.SOAP_VERSION_MISMATCH, ErroriIntegrazione.ERRORE_430_SOAP_ENVELOPE_NAMESPACE_ERROR.getErrore430_SoapNamespaceNonSupportato(messageTypeReq, soapEnvelopeNamespaceVersionMismatch));
                }
            }
            catch (Throwable e) {
                String msgErrore;
                if (this.context == null) {
                    this.context = RicezioneBusteContext.newRicezioneBusteContext(idModuloAsService, this.dataAccettazioneRichiesta, this.requestInfo);
                    this.context.setDataIngressoRichiesta(this.dataIngressoRichiesta);
                    this.context.setTipoPorta(TipoPdD.APPLICATIVA);
                    this.context.setIdModulo(this.idModulo);
                    this.context.getPddContext().addObject(Costanti.PROTOCOL_NAME, this.protocolFactory.getProtocol());
                    this.pddContext = this.context.getPddContext();
                    this.msgDiag.setPddContext(this.pddContext, this.protocolFactory);
                    if (this.postOutResponseContext != null) {
                        this.postOutResponseContext.setPddContext(this.pddContext);
                    }
                }
                Throwable tParsing = null;
                ParseException parseException = null;
                if (this.pddContext.containsKey(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION) && (parseException = (ParseException)this.pddContext.removeObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) != null) {
                    tParsing = parseException.getParseException();
                }
                if (tParsing == null && (this.requestMessage == null || this.requestMessage.getParseException() == null)) {
                    tParsing = ParseExceptionUtils.getParseException((Throwable)e);
                }
                if ((msgErrore = e.getMessage()) == null) {
                    msgErrore = e.toString();
                }
                if (ServiceBinding.SOAP.equals((Object)protocolServiceBinding) && messageTypeReq != null && (msgErrore.equals("Transport level information does not match with SOAP Message namespace URI") || msgErrore.equals("I dati ricevuti non rappresentano un messaggio SOAP 1.1 valido: ") || msgErrore.equals("InputStream does not represent a valid SOAP 1.1 Message") || msgErrore.equals("InputStream does not represent a valid SOAP 1.2 Message"))) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    this.msgDiag.addKeyword("@SOAP_NAMESPACE@", "Impossibile recuperare il valore del namespace");
                    this.msgDiag.logPersonalizzato("soapEnvelopeNamespace.versionMismatch");
                    this.responseMessage = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, IntegrationFunctionError.SOAP_VERSION_MISMATCH, ErroriIntegrazione.ERRORE_430_SOAP_ENVELOPE_NAMESPACE_ERROR.getErrore430_SoapNamespaceNonSupportato(messageTypeReq, "Impossibile recuperare il valore del namespace"));
                } else if (tParsing != null) {
                    this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                    msgErrore = tParsing.getMessage();
                    if (msgErrore == null) {
                        msgErrore = tParsing.toString();
                    }
                    this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                    this.logCore.error("parsingExceptionRichiesta", e);
                    this.msgDiag.logPersonalizzato("parsingExceptionRichiesta");
                    IntegrationFunctionError integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_REQUEST_CONTENT;
                    if (parseException != null && parseException.getSourceException() != null && TimeoutIOException.isTimeoutIOException((Throwable)parseException.getSourceException())) {
                        integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
                    } else if (parseException != null && parseException.getSourceException() != null && LimitExceededIOException.isLimitExceededIOException((Throwable)parseException.getSourceException())) {
                        integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
                    }
                    this.responseMessage = this.generatoreErrore.buildErroreIntestazione(this.pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_432_PARSING_EXCEPTION_RICHIESTA.getErrore432_MessaggioRichiestaMalformato(tParsing));
                } else if (e instanceof HandlerException) {
                    IntegrationFunctionError integrationError;
                    ErroreIntegrazione errore;
                    HandlerException he = (HandlerException)e;
                    this.logCore.error("ErroreGenerale (HandlerException)", e);
                    if (he.isEmettiDiagnostico()) {
                        this.msgDiag.logErroreGenerico(e, "Generale(richiesta-handler)");
                    }
                    if ((errore = he.convertToErroreIntegrazione()) == null) {
                        errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("Generale(richiesta)");
                    }
                    if ((integrationError = he.getIntegrationFunctionError()) == null) {
                        integrationError = IntegrationFunctionError.BAD_REQUEST;
                    }
                    this.responseMessage = this.generatoreErrore.buildErroreProcessamento(this.pddContext, integrationError, errore, e);
                    he.customized(this.responseMessage);
                } else {
                    this.logCore.error("ErroreGenerale", e);
                    this.msgDiag.logErroreGenerico(e, "Generale(richiesta)");
                    this.responseMessage = this.generatoreErrore.buildErroreProcessamento(this.pddContext, IntegrationFunctionError.BAD_REQUEST, ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(true, e), e);
                }
            }
            finally {
                try {
                    if (!completeProcess || !async) {
                        this.completeEngine(AsyncResponseCallbackClientEvent.NONE, completeProcess);
                    }
                }
                finally {
                    try {
                        GestoreRichieste.saveRequestConfig(this.requestInfo);
                    }
                    catch (Throwable e) {
                        this.logCore.error("Errore durante il salvataggio dei dati della richiesta: " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public void asyncComplete(AsyncResponseCallbackClientEvent clientEvent, Object ... args) throws ConnectorException {
        this.completeEngine(clientEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeEngine(AsyncResponseCallbackClientEvent clientEvent, boolean completeProcess) throws ConnectorException {
        if (completeProcess) {
            this.responseMessage = this.context.getMessageResponse();
        }
        requestReadTimeout = null;
        responseReadTimeout = null;
        if (this.pddContext != null && this.pddContext.containsKey(TimeoutInputStream.ERROR_MSG_KEY)) {
            timeoutMessage = PdDContext.getValue((MapKey<String>)TimeoutInputStream.ERROR_MSG_KEY, this.pddContext);
            if (timeoutMessage != null && timeoutMessage.startsWith("Request ")) {
                requestReadTimeout = timeoutMessage;
            } else if (timeoutMessage != null && timeoutMessage.startsWith("Response ")) {
                responseReadTimeout = timeoutMessage;
            }
        }
        requestLimitExceeded = null;
        responseLimitExceeded = null;
        if (this.pddContext != null && this.pddContext.containsKey(LimitedInputStream.ERROR_MSG_KEY)) {
            limitedExceededMessage = PdDContext.getValue((MapKey<String>)LimitedInputStream.ERROR_MSG_KEY, this.pddContext);
            if (limitedExceededMessage != null && limitedExceededMessage.startsWith("Request ")) {
                requestLimitExceeded = limitedExceededMessage;
            } else if (limitedExceededMessage != null && limitedExceededMessage.startsWith("Response ")) {
                responseLimitExceeded = limitedExceededMessage;
            }
        }
        if (this.requestMessage != null && this.requestMessage.getParseException() != null || this.pddContext.containsKey(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION) || requestReadTimeout != null || requestLimitExceeded != null) {
            if (this.pddContext != null) {
                this.pddContext.addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
            }
            parseException = null;
            tParsing = null;
            sParsing /* !! */  = null;
            msgErrore = null;
            if (requestReadTimeout != null) {
                tParsing = (TimeoutIOException)this.pddContext.getObject(TimeoutInputStream.EXCEPTION_KEY);
                sParsing /* !! */  = tParsing;
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            } else if (requestLimitExceeded != null) {
                tParsing = (LimitExceededIOException)this.pddContext.getObject(LimitedInputStream.EXCEPTION_KEY);
                sParsing /* !! */  = tParsing;
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            } else if (this.requestMessage != null && this.requestMessage.getParseException() != null) {
                parseException = this.requestMessage.getParseException();
                tParsing = parseException.getParseException();
                sParsing /* !! */  = parseException.getSourceException();
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            } else {
                parseException = (ParseException)this.pddContext.getObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                tParsing = parseException.getParseException();
                sParsing /* !! */  = parseException.getSourceException();
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            }
            if (msgErrore == null && tParsing != null) {
                msgErrore = tParsing.toString();
            }
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
            this.logCore.error("parsingExceptionRichiesta", (Throwable)sParsing /* !! */ );
            this.msgDiag.logPersonalizzato("parsingExceptionRichiesta");
            integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_REQUEST_CONTENT;
            if (requestReadTimeout != null) {
                integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
            } else if (requestLimitExceeded != null) {
                integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
            } else if (parseException != null && sParsing /* !! */  != null && TimeoutIOException.isTimeoutIOException((Throwable)sParsing /* !! */ )) {
                integrationFunctionError = IntegrationFunctionError.REQUEST_TIMED_OUT;
            } else if (parseException != null && sParsing /* !! */  != null && LimitExceededIOException.isLimitExceededIOException((Throwable)sParsing /* !! */ )) {
                integrationFunctionError = IntegrationFunctionError.REQUEST_SIZE_EXCEEDED;
            }
            this.responseMessage = this.generatoreErrore.buildErroreIntestazione(this.pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_432_PARSING_EXCEPTION_RICHIESTA.getErrore432_MessaggioRichiestaMalformato((Throwable)tParsing));
        } else if (this.responseMessage != null && this.responseMessage.getParseException() != null || this.pddContext.containsKey(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION) || responseReadTimeout != null || responseLimitExceeded != null) {
            this.pddContext.addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
            parseException = null;
            tParsing = null;
            sParsing /* !! */  = null;
            msgErrore = null;
            if (responseReadTimeout != null) {
                tParsing = (TimeoutIOException)this.pddContext.getObject(TimeoutInputStream.EXCEPTION_KEY);
                sParsing /* !! */  = tParsing;
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            } else if (responseLimitExceeded != null) {
                tParsing = (LimitExceededIOException)this.pddContext.getObject(LimitedInputStream.EXCEPTION_KEY);
                sParsing /* !! */  = tParsing;
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            } else if (this.responseMessage != null && this.responseMessage.getParseException() != null) {
                parseException = this.responseMessage.getParseException();
                tParsing = parseException.getParseException();
                sParsing /* !! */  = parseException.getSourceException();
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            } else {
                parseException = (ParseException)this.pddContext.getObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                tParsing = parseException.getParseException();
                sParsing /* !! */  = parseException.getSourceException();
                if (tParsing != null) {
                    msgErrore = tParsing.getMessage();
                }
            }
            if (msgErrore == null && tParsing != null) {
                msgErrore = tParsing.toString();
            }
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
            this.logCore.error("parsingExceptionRisposta", (Throwable)sParsing /* !! */ );
            integrationFunctionError = IntegrationFunctionError.UNPROCESSABLE_RESPONSE_CONTENT;
            if (responseReadTimeout != null) {
                integrationFunctionError = IntegrationFunctionError.ENDPOINT_REQUEST_TIMED_OUT;
            } else if (responseLimitExceeded != null) {
                integrationFunctionError = IntegrationFunctionError.RESPONSE_SIZE_EXCEEDED;
            } else if (sParsing /* !! */  != null && TimeoutIOException.isTimeoutIOException((Throwable)sParsing /* !! */ )) {
                integrationFunctionError = IntegrationFunctionError.ENDPOINT_REQUEST_TIMED_OUT;
            } else if (sParsing /* !! */  != null && LimitExceededIOException.isLimitExceededIOException((Throwable)sParsing /* !! */ )) {
                integrationFunctionError = IntegrationFunctionError.RESPONSE_SIZE_EXCEEDED;
            }
            this.msgDiag.logPersonalizzato("parsingExceptionRisposta");
            this.responseMessage = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_440_PARSING_EXCEPTION_RISPOSTA.getErrore440_MessaggioRispostaMalformato((Throwable)tParsing));
        }
        try {
            v0 = urlProtocolContext = this.context != null ? this.context.getUrlProtocolContext() : null;
            if (urlProtocolContext == null) {
                urlProtocolContext = this.req.getURLProtocolContext();
            }
            if (urlProtocolContext != null && this.pddContext != null) {
                urlInvocazione = urlProtocolContext.getUrlInvocazione_formBased();
                if (urlProtocolContext.getFunction() != null) {
                    urlInvocazione = "[" + urlProtocolContext.getFunction() + "] " + (String)urlInvocazione;
                }
                this.pddContext.addObject(Costanti.URL_INVOCAZIONE, urlInvocazione);
            }
        }
        catch (Throwable urlProtocolContext) {
            // empty catch block
        }
        try {
            v1 = credenziali = this.context != null ? this.context.getCredenziali() : null;
            if (credenziali == null) {
                credenziali = new Credenziali(this.req.getCredential());
            }
            if (credenziali != null && this.pddContext != null) {
                this.pddContext.addObject(Costanti.CREDENZIALI_INVOCAZIONE, credenziali.toString());
            }
        }
        catch (Throwable credenziali) {
            // empty catch block
        }
        try {
            this.req.close();
        }
        catch (Exception e) {
            this.logCore.error("Request.close() error: " + e.getMessage(), (Throwable)e);
        }
        dataPrimaSpedizioneRisposta = DateManager.getDate();
        dataRispostaSpedita = null;
        transazioneDaAggiornare = null;
        if (this.context != null) {
            if (this.context.getMsgDiagnostico() != null) {
                this.msgDiag = this.context.getMsgDiagnostico();
            }
            if (this.context.getResponseHeaders() == null) {
                this.context.setResponseHeaders(new HashMap<String, List<String>>());
            }
            ServicesUtils.setGovWayHeaderResponse(this.requestMessage != null ? this.requestMessage.getServiceBinding() : this.requestInfo.getProtocolServiceBinding(), this.responseMessage, this.openSPCoopProperties, this.context.getResponseHeaders(), this.logCore, false, this.context.getPddContext(), this.requestInfo);
        }
        if (this.context == null || this.context.getResponseHeaders() == null) ** GOTO lbl166
        keys = this.context.getResponseHeaders().keySet().iterator();
        while (true) {
            block213: {
                block212: {
                    if (!keys.hasNext()) break block212;
                    key = keys.next();
                    values = this.context.getResponseHeaders().get(key);
                    if (values == null || values.isEmpty()) continue;
                    break block213;
                }
                if (this.context != null && this.context.getProtocol() != null) {
                    this.generatoreErrore.updateDominio(this.context.getIdentitaPdD());
                    idServizio = null;
                    try {
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(this.context.getProtocol().getTipoServizio(), this.context.getProtocol().getServizio(), this.context.getProtocol().getErogatore(), this.context.getProtocol().getVersioneServizio().intValue());
                    }
                    catch (Exception key) {
                        // empty catch block
                    }
                    if (idServizio != null) {
                        idServizio.setAzione(this.context.getProtocol().getAzione());
                        this.generatoreErrore.updateInformazioniCooperazione(this.context.getProtocol().getFruitore(), idServizio);
                    }
                    servizioApplicativo = null;
                    if (this.context.getIntegrazione() != null) {
                        servizioApplicativo = this.context.getIntegrazione().getServizioApplicativoFruitore();
                    }
                    this.generatoreErrore.updateInformazioniCooperazione(servizioApplicativo);
                }
                vm = null;
                value = this.res;
                if (value instanceof DirectVMConnectorOutMessage) {
                    vm = directvmconnectoroutmessage = (DirectVMConnectorOutMessage)value;
                } else {
                    value = this.req;
                    if (value instanceof DumpRawConnectorOutMessage && (value = (dumprawconnectoroutmessage = (DumpRawConnectorOutMessage)value).getWrappedConnectorOutMessage()) instanceof DirectVMConnectorOutMessage) {
                        vm = directvmconnectorOutmessage = (DirectVMConnectorOutMessage)value;
                    }
                }
                if (vm != null && this.context != null && this.context.getPddContext() != null) {
                    pInfo = new DirectVMProtocolInfo();
                    oIdTransazione = this.context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                    if (oIdTransazione != null) {
                        pInfo.setIdTransazione((String)oIdTransazione);
                    }
                    if (this.context.getProtocol() != null) {
                        if (this.context.getProtocol().getIdRichiesta() != null) {
                            pInfo.setIdMessaggioRichiesta(this.context.getProtocol().getIdRichiesta());
                        }
                        if (this.context.getProtocol().getIdRisposta() != null) {
                            pInfo.setIdMessaggioRisposta(this.context.getProtocol().getIdRisposta());
                        }
                    }
                    vm.setDirectVMProtocolInfo(pInfo);
                }
                informazioniErrori = ServicesUtils.readInformazioniErroriInfrastrutturali(this.pddContext);
                responseMessageError = null;
                esito = null;
                descrizioneSoapFault = "";
                statoServletResponse = 200;
                erroreConsegnaRisposta = null;
                httpEmptyResponse = false;
                erroreConnessioneClient = false;
                erroreResponseTimeout = false;
                erroreResponsePayloadTooLarge = false;
                sendInvoked = false;
                registraTracciaOutResponse = false;
                try {
                    block217: {
                        block214: {
                            block216: {
                                block215: {
                                    if (this.responseMessage == null || this.responseMessage.isForcedEmptyResponse() || this.responseMessage.getForcedResponse() != null) break block214;
                                    if (this.responseMessage.getForcedResponseCode() != null) {
                                        try {
                                            statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponseCode());
                                        }
                                        catch (Exception var23_32) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.responseMessage.getParseException() != null) {
                                        throw this.responseMessage.getParseException().getSourceException();
                                    }
                                    ServicesUtils.setTransferLength(this.openSPCoopProperties.getTransferLengthModes_ricezioneBuste(), this.req, this.res, this.responseMessage, this.pddContext, false);
                                    this.responseMessage.updateContentType();
                                    ServicesUtils.setContentType(this.responseMessage, this.res);
                                    consume = true;
                                    if (!ServiceBinding.SOAP.equals((Object)this.responseMessage.getServiceBinding())) break block215;
                                    soapMessage = this.responseMessage.castAsSoap();
                                    if (soapMessage.hasSOAPFault()) {
                                        consume = false;
                                        statoServletResponse = 500;
                                        descrizioneSoapFault = " (" + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)this.responseMessage.getFactory(), (SOAPFault)soapMessage.getSOAPBody().getFault(), (boolean)false, (Logger)this.logCore) + ")";
                                        break block216;
                                    } else if (statoServletResponse == 500) {
                                        statoServletResponse = !soapMessage.isSOAPBodyEmpty() ? 200 : this.protocolFactory.createProtocolManager().getHttpReturnCodeEmptyResponseOneWay();
                                    }
                                    break block216;
                                }
                                if (this.responseMessage.castAsRest().isProblemDetailsForHttpApis_RFC7807() || MessageRole.FAULT.equals((Object)this.responseMessage.getMessageRole()) && (MessageType.XML.equals((Object)this.responseMessage.getMessageType()) || MessageType.JSON.equals((Object)this.responseMessage.getMessageType()))) {
                                    consume = false;
                                    contentAsString = null;
                                    try {
                                        contentAsString = this.responseMessage.castAsRest().getContentAsString();
                                    }
                                    catch (Throwable t) {
                                        this.logCore.error("Parsing errore non riuscito: " + t.getMessage(), t);
                                    }
                                    if (contentAsString != null && StringUtils.isNotEmpty((CharSequence)contentAsString)) {
                                        descrizioneSoapFault = " (" + contentAsString + ")";
                                    }
                                }
                            }
                            this.res.setStatus(statoServletResponse);
                            esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getProtocolServiceBinding(), this.responseMessage, this.proprietaErroreAppl, informazioniErrori, (Map)this.pddContext);
                            registraTracciaOutResponse = true;
                            transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, responseMessageError);
                            sendInvoked = true;
                            if (TransferLengthModes.CONTENT_LENGTH.equals((Object)this.openSPCoopProperties.getTransferLengthModes_ricezioneBuste())) {
                                this.res.sendResponse(this.responseMessage, false);
                            } else {
                                this.res.sendResponse(this.responseMessage, consume);
                            }
                            ** GOTO lbl463
                        }
                        if (this.responseMessage == null || this.responseMessage.getForcedResponse() == null) break block217;
                        response = this.responseMessage.getForcedResponse().getContent();
                        if (response != null && response.length < 1024) {
                            try {
                                descrizioneSoapFault = "(" + new String(response) + ")";
                            }
                            catch (Throwable t) {
                                descrizioneSoapFault = "";
                            }
                        }
                        if (this.responseMessage.getForcedResponse().getHeadersValues() != null && this.responseMessage.getForcedResponse().getHeadersValues().size() > 0) {
                            keys = this.responseMessage.getForcedResponse().getHeadersValues().keySet().iterator();
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                    if (this.responseMessage != null && this.responseMessage.getForcedResponseCode() != null) {
                        try {
                            statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponseCode());
                        }
                        catch (Exception response) {}
                    } else {
                        statoServletResponse = this.protocolFactory.createProtocolManager().getHttpReturnCodeEmptyResponseOneWay();
                    }
                    this.res.setStatus(statoServletResponse);
                    httpEmptyResponse = true;
                    esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getProtocolServiceBinding(), this.responseMessage, this.proprietaErroreAppl, informazioniErrori, (Map)this.pddContext);
                    registraTracciaOutResponse = true;
                    transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, responseMessageError);
                    ** GOTO lbl463
                }
                catch (Throwable e) {
                    this.logCore.error("ErroreGenerale", e);
                    erroreConsegnaRisposta = e;
                    erroreConnessioneClient = ServicesUtils.isConnessioneClientNonDisponibile(e);
                    if (!erroreConnessioneClient && ServicesUtils.isConnessioneServerReadTimeout(e)) {
                        erroreResponseTimeout = true;
                        erroreConsegnaRisposta = new CoreException("Connessione con il backend dell'API non pi\u00f9 disponibile: " + e.getMessage(), e);
                    }
                    if (!erroreConnessioneClient && !erroreResponseTimeout && ServicesUtils.isResponsePayloadTooLarge(e)) {
                        erroreResponsePayloadTooLarge = true;
                        erroreConsegnaRisposta = new CoreException("Risposta ricevuta dal backend dell'API non gestibile: " + e.getMessage(), e);
                    }
                    try {
                        if (!sendInvoked) {
                            informazioniErroriInfrastrutturaliError = new InformazioniErroriInfrastrutturali();
                            if (this.responseMessage != null && this.responseMessage.getParseException() != null || this.pddContext.containsKey(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) {
                                informazioniErroriInfrastrutturaliError.setContenutoRispostaNonRiconosciuto(true);
                                parseException = null;
                                parseException = this.responseMessage != null && this.responseMessage.getParseException() != null ? this.responseMessage.getParseException() : (ParseException)this.pddContext.getObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION);
                                msgErrore = parseException.getParseException().getMessage();
                                if (msgErrore == null) {
                                    msgErrore = parseException.getParseException().toString();
                                }
                                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", msgErrore);
                                this.logCore.error("parsingExceptionRisposta", parseException.getSourceException());
                                this.msgDiag.logPersonalizzato("parsingExceptionRisposta");
                                responseMessageError = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, IntegrationFunctionError.UNPROCESSABLE_RESPONSE_CONTENT, ErroriIntegrazione.ERRORE_440_PARSING_EXCEPTION_RISPOSTA.getErrore440_MessaggioRispostaMalformato(parseException.getParseException()));
                            } else {
                                ife = IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
                                if (e instanceof HandlerException && (he = (HandlerException)e).getIntegrationFunctionError() != null) {
                                    ife = he.getIntegrationFunctionError();
                                }
                                responseMessageError = this.generatoreErrore.buildErroreProcessamento((Context)this.pddContext, ife, ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(false, e));
                            }
                            ServicesUtils.setTransferLength(this.openSPCoopProperties.getTransferLengthModes_ricezioneBuste(), this.req, this.res, responseMessageError, this.pddContext, true);
                            ServicesUtils.setContentType(responseMessageError, this.res);
                            if (responseMessageError != null && responseMessageError.getForcedResponseCode() != null) {
                                try {
                                    statoServletResponse = Integer.parseInt(responseMessageError.getForcedResponseCode());
                                    this.res.setStatus(statoServletResponse);
                                }
                                catch (Exception ife) {
                                    // empty catch block
                                }
                            }
                            if (responseMessageError != null && ServiceBinding.SOAP.equals((Object)responseMessageError.getServiceBinding()) && (body = responseMessageError.castAsSoap().getSOAPBody()) != null && body.hasFault()) {
                                statoServletResponse = 500;
                                this.res.setStatus(statoServletResponse);
                                descrizioneSoapFault = " (" + SoapUtils.safe_toString((OpenSPCoop2MessageFactory)responseMessageError.getFactory(), (SOAPFault)body.getFault(), (boolean)false, (Logger)this.logCore) + ")";
                            }
                            esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getProtocolServiceBinding(), responseMessageError, this.proprietaErroreAppl, informazioniErroriInfrastrutturaliError, (Map)this.pddContext);
                            if (!registraTracciaOutResponse) {
                                transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, responseMessageError);
                            }
                            this.res.sendResponse(responseMessageError, false);
                        }
                        ** GOTO lbl463
                    }
                    catch (Throwable error) {
                        if (!erroreConnessioneClient) {
                            erroreConnessioneClient = ServicesUtils.isConnessioneClientNonDisponibile(error);
                        }
                        this.logCore.error("Generazione di un risposta errore non riuscita", error);
                        statoServletResponse = 500;
                        try {
                            ife = null;
                            if (error instanceof HandlerException && (he = (HandlerException)error).getIntegrationFunctionError() != null) {
                                ife = he.getIntegrationFunctionError();
                            }
                            if ((responseMessageError = ife != null ? this.generatoreErrore.buildFault(error, (Context)this.pddContext, ife) : this.generatoreErrore.buildFault(error, (Context)this.pddContext)) != null && responseMessageError.getForcedResponseCode() != null) {
                                try {
                                    statoServletResponse = Integer.parseInt(responseMessageError.getForcedResponseCode());
                                }
                                catch (Exception he) {
                                    // empty catch block
                                }
                            }
                            try {
                                this.res.setStatus(statoServletResponse);
                            }
                            catch (Exception eStatus) {
                                this.logCore.error("Response.setStatus(" + statoServletResponse + ") error: " + eStatus.getMessage(), (Throwable)eStatus);
                            }
                            this.res.sendResponse(responseMessageError, false);
                        }
                        catch (Throwable eError) {
                            if (!erroreConnessioneClient) {
                                erroreConnessioneClient = ServicesUtils.isConnessioneClientNonDisponibile(eError);
                            }
                            try {
                                this.res.setStatus(statoServletResponse);
                            }
                            catch (Throwable eStatus) {
                                // empty catch block
                            }
                            try {
                                this.res.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])error.toString().getBytes()));
                            }
                            catch (Exception erroreStreamChiuso) {
                                erroreConnessioneClient = true;
                            }
                        }
                        try {
                            esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                            ** GOTO lbl463
                        }
                        catch (Exception eBuildError) {
                            esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                        }
                    }
                    ** GOTO lbl463
                }
                finally {
                    block209: {
                        if (!sendInvoked) {
                            statoServletResponse = this.res.getResponseStatus();
                        }
                        this.msgDiag.addKeyword("@CODICE_CONSEGNA@", "" + statoServletResponse);
                        this.msgDiag.addKeyword("@SOAP_FAULT@", (String)descrizioneSoapFault);
                        try {
                            this.res.flush(true);
                            this.res.close(clientEvent, true);
                            dataRispostaSpedita = DateManager.getDate();
                            if (erroreConsegnaRisposta != null) {
                                this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", erroreConsegnaRisposta.toString());
                                this.msgDiag.logPersonalizzato("consegnaMessaggioFallita");
                                break block209;
                            }
                            if (httpEmptyResponse) {
                                this.msgDiag.logPersonalizzato("consegnaMessaggioNonPresente");
                                break block209;
                            }
                            if (statoServletResponse >= 300) {
                                this.msgDiag.logPersonalizzato("consegnaMessaggioKoEffettuata");
                            } else {
                                this.msgDiag.logPersonalizzato("consegnaMessaggioOkEffettuata");
                            }
                        }
                        catch (Exception e) {
                            erroreConnessioneClient = true;
                            this.logCore.error("Chiusura stream non riuscita", (Throwable)e);
                            this.msgDiag.addKeyword("@ERRORE_CONSEGNA@", e.toString());
                            this.msgDiag.logPersonalizzato("consegnaMessaggioFallita");
                            erroreConsegnaRisposta = e;
                            if (esito != null && EsitoTransazioneName.OK.equals((Object)esito.getName())) {
                                try {
                                    esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                                }
                                catch (Exception eBuildError) {
                                    esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                                }
                            }
                        }
                        finally {
                            if (dataRispostaSpedita == null) {
                                dataRispostaSpedita = DateManager.getDate();
                            }
                        }
                    }
                    if (this.dumpRaw != null && this.dumpRaw.isActiveDumpRisposta()) {
                        this.dumpRaw.serializeResponse((DumpRawConnectorOutMessage)this.res);
                    }
                }
            }
            i = 0;
            while (true) {
                if (i >= values.size()) ** break;
                value = values.get(i);
                verbo = "";
                try {
                    if (i == 0) {
                        verbo = "set";
                        this.res.setHeader(key, (String)value);
                    } else {
                        verbo = "add";
                        this.res.addHeader(key, (String)value);
                    }
                }
                catch (Exception e) {
                    this.logCore.error("Response." + verbo + "Header(" + key + "," + (String)value + ") set failed: " + e.getMessage(), (Throwable)e);
                }
                ++i;
            }
            break;
        }
        while (true) {
            if (keys.hasNext()) {
                key = (String)keys.next();
                values = (List)this.responseMessage.getForcedResponse().getHeadersValues().get(key);
                if (values == null || values.isEmpty()) continue;
            } else lbl-1000:
            // 2 sources

            {
                if (this.responseMessage.getForcedResponse().getContentType() != null) {
                    this.res.setContentType(this.responseMessage.getForcedResponse().getContentType());
                }
                if (this.responseMessage.getForcedResponse().getResponseCode() != null) {
                    try {
                        statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponse().getResponseCode());
                    }
                    catch (Exception keys) {}
                } else if (this.responseMessage != null && this.responseMessage.getForcedResponseCode() != null) {
                    try {
                        statoServletResponse = Integer.parseInt(this.responseMessage.getForcedResponseCode());
                    }
                    catch (Exception keys) {
                        // empty catch block
                    }
                }
                this.res.setStatus(statoServletResponse);
                esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), statoServletResponse, this.requestInfo.getProtocolServiceBinding(), this.responseMessage, this.proprietaErroreAppl, informazioniErrori, (Map)this.pddContext);
                registraTracciaOutResponse = true;
                transazioneDaAggiornare = this.registraTracciaOutResponse(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, responseMessageError);
                if (response != null) {
                    sendInvoked = true;
                    this.res.sendResponse(DumpByteArrayOutputStream.newInstance((byte[])response));
                }
lbl463:
                // 10 sources

                if (erroreConnessioneClient) {
                    try {
                        esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_CONNESSIONE_CLIENT_NON_DISPONIBILE);
                    }
                    catch (Exception eBuildError) {
                        esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                    }
                } else if (erroreResponseTimeout) {
                    try {
                        esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_RESPONSE_TIMEOUT);
                    }
                    catch (Exception eBuildError) {
                        esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                    }
                } else if (erroreResponsePayloadTooLarge) {
                    try {
                        esito = this.protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)this.req.getURLProtocolContext(), EsitoTransazioneName.CONTROLLO_TRAFFICO_POLICY_VIOLATA);
                    }
                    catch (Exception eBuildError) {
                        esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                    }
                } else if (EsitoTransazioneName.OK.equals((Object)esito.getName()) && this.context != null && this.context.getPddContext() != null && this.context.getPddContext().containsKey(Costanti.EMESSI_DIAGNOSTICI_ERRORE)) {
                    esito = ServicesUtils.updateEsitoConAnomalie(esito, this.logCore, this.protocolFactory);
                }
                location = "...";
                try {
                    c = null;
                    if (this.context != null && this.context.getPddContext() != null && this.context.getPddContext().containsKey(Costanti.ID_TRANSAZIONE)) {
                        this.idTransazione = (String)this.context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                    }
                    if (this.idTransazione != null) {
                        c = RepositoryConnettori.removeConnettorePA(this.idTransazione);
                    }
                    if (c != null) {
                        location = c.getLocation();
                        c.disconnect();
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logDisconnectError(e, location);
                }
                if (this.postOutResponseContext != null) {
                    try {
                        this.updateContext(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, responseMessageError);
                        this.postOutResponseContext.setTransazioneDaAggiornare(transazioneDaAggiornare);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
                    }
                    GestoreHandlers.postOutResponse(this.postOutResponseContext, this.msgDiag, this.logCore);
                }
                try {
                    if (this.requestMessage != null && this.requestMessage.getNotifierInputStream() != null) {
                        this.requestMessage.getNotifierInputStream().close();
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream richiesta");
                }
                try {
                    if (this.responseMessage != null && this.responseMessage.getNotifierInputStream() != null) {
                        this.responseMessage.getNotifierInputStream().close();
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream risposta");
                }
                this.requestMessage = null;
                this.responseMessage = null;
                return;
            }
            i = 0;
            while (true) {
                if (i >= values.size()) ** break;
                value = (String)values.get(i);
                verbo = "";
                try {
                    if (i == 0) {
                        verbo = "set";
                        this.res.setHeader(key, value);
                    } else {
                        verbo = "add";
                        this.res.addHeader(key, value);
                    }
                }
                catch (Exception e) {
                    this.logCore.error("Response(Forced)." + verbo + "Header(" + key + "," + value + ") error: " + e.getMessage(), (Throwable)e);
                }
                ++i;
            }
            break;
        }
    }

    private void updateContext(Date dataPrimaSpedizioneRisposta, Date dataRispostaSpedita, EsitoTransazione esito, int statoServletResponse, Throwable erroreConsegnaRisposta, OpenSPCoop2Message responseMessageError) throws ConnectorException {
        if (this.postOutResponseContext != null) {
            this.postOutResponseContext.getPddContext().addObject(CostantiPdD.DATA_ACCETTAZIONE_RICHIESTA, this.dataAccettazioneRichiesta);
            if (this.dataIngressoRichiesta != null) {
                this.postOutResponseContext.getPddContext().addObject(CostantiPdD.DATA_INGRESSO_RICHIESTA, this.dataIngressoRichiesta);
            }
            this.postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            this.postOutResponseContext.setDataPrimaSpedizioneRisposta(dataPrimaSpedizioneRisposta);
            this.postOutResponseContext.setDataRispostaSpedita(dataRispostaSpedita);
            this.postOutResponseContext.setEsito(esito);
            this.postOutResponseContext.setReturnCode(statoServletResponse);
            this.postOutResponseContext.setResponseHeaders(this.context.getResponseHeaders());
            this.postOutResponseContext.setProtocollo(this.context.getProtocol());
            this.postOutResponseContext.setIntegrazione(this.context.getIntegrazione());
            if (this.context.getTipoPorta() != null) {
                this.postOutResponseContext.setTipoPorta(this.context.getTipoPorta());
            }
            this.postOutResponseContext.setIdModulo(this.idModulo);
            if (this.requestMessage != null) {
                long incomingRequestMessageContentLength = this.requestMessage.getIncomingMessageContentLength();
                long outgoingRequestMessageContentLenght = this.requestMessage.getOutgoingMessageContentLength();
                if (incomingRequestMessageContentLength < 0L) {
                    int cl = this.req.getContentLength();
                    if (cl > 0) {
                        incomingRequestMessageContentLength = (long)cl + 0L;
                    } else {
                        try {
                            this.requestMessage.writeTo((OutputStream)NullOutputStream.INSTANCE, true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        incomingRequestMessageContentLength = this.requestMessage.getIncomingMessageContentLength();
                    }
                }
                this.postOutResponseContext.setInputRequestMessageSize(incomingRequestMessageContentLength);
                this.postOutResponseContext.setOutputRequestMessageSize(outgoingRequestMessageContentLenght);
            } else {
                this.postOutResponseContext.setInputRequestMessageSize((long)this.req.getContentLength() + 0L);
            }
            if (erroreConsegnaRisposta != null) {
                if (responseMessageError != null) {
                    this.postOutResponseContext.setInputResponseMessageSize(responseMessageError.getIncomingMessageContentLength());
                    this.postOutResponseContext.setOutputResponseMessageSize(responseMessageError.getOutgoingMessageContentLength());
                    this.postOutResponseContext.setMessaggio(responseMessageError);
                } else if (this.responseMessage != null && !this.responseMessage.isForcedEmptyResponse() && this.responseMessage.getForcedResponse() == null) {
                    this.postOutResponseContext.setInputResponseMessageSize(this.responseMessage.getIncomingMessageContentLength());
                    this.postOutResponseContext.setOutputResponseMessageSize(this.responseMessage.getOutgoingMessageContentLength());
                    this.postOutResponseContext.setMessaggio(this.responseMessage);
                }
                this.postOutResponseContext.setErroreConsegna(erroreConsegnaRisposta.toString());
            } else if (this.responseMessage != null && !this.responseMessage.isForcedEmptyResponse() && this.responseMessage.getForcedResponse() == null) {
                this.postOutResponseContext.setInputResponseMessageSize(this.responseMessage.getIncomingMessageContentLength());
                this.postOutResponseContext.setOutputResponseMessageSize(this.responseMessage.getOutgoingMessageContentLength());
                this.postOutResponseContext.setMessaggio(this.responseMessage);
            } else if (this.responseMessage != null && this.responseMessage.getForcedResponse() != null && this.responseMessage.getForcedResponse().getContent() != null) {
                this.postOutResponseContext.setInputResponseMessageSize(this.responseMessage.getIncomingMessageContentLength());
                this.postOutResponseContext.setOutputResponseMessageSize(Long.valueOf(this.responseMessage.getForcedResponse().getContent().length));
            }
        }
    }

    private Transazione registraTracciaOutResponse(Date dataPrimaSpedizioneRisposta, Date dataRispostaSpedita, EsitoTransazione esito, int statoServletResponse, Throwable erroreConsegnaRisposta, OpenSPCoop2Message responseMessageError) throws HandlerException {
        try {
            if (this.postOutResponseContext != null) {
                this.updateContext(dataPrimaSpedizioneRisposta, dataRispostaSpedita, esito, statoServletResponse, erroreConsegnaRisposta, responseMessageError);
                TracciamentoManager tracciamentoManager = new TracciamentoManager(FaseTracciamento.OUT_RESPONSE);
                if (!tracciamentoManager.isTransazioniEnabled()) {
                    return null;
                }
                InformazioniTransazione info = new InformazioniTransazione(this.postOutResponseContext);
                tracciamentoManager.invoke(info, this.postOutResponseContext.getEsito(), this.context.getResponseHeaders(), this.msgDiag);
                return info.getTransazioneDaAggiornare();
            }
        }
        catch (Exception e) {
            ServicesUtils.processTrackingException(e, this.postOutResponseContext.getLogCore(), FaseTracciamento.OUT_RESPONSE, this.context.getPddContext());
        }
        return null;
    }

    private void registraTracciaInRequest() throws HandlerException {
        try {
            TracciamentoManager tracciamentoManager = new TracciamentoManager(FaseTracciamento.IN_REQUEST);
            if (!tracciamentoManager.isTransazioniEnabled()) {
                return;
            }
            InformazioniTransazione info = new InformazioniTransazione();
            info.setContext(this.context.getPddContext());
            info.setTipoPorta(this.context.getTipoPorta());
            info.setProtocolFactory(this.protocolFactory);
            info.setProtocollo(this.context.getProtocol());
            info.setIntegrazione(this.context.getIntegrazione());
            info.setIdModulo(this.context.getIdModulo());
            TransportRequestContext transportRequestContext = null;
            if (this.context.getMessageRequest() != null) {
                transportRequestContext = this.context.getMessageRequest().getTransportRequestContext();
            }
            String esitoContext = EsitoBuilder.getTipoContext((TransportRequestContext)transportRequestContext, (EsitiProperties)EsitiProperties.getInstance((Logger)this.logCore, this.protocolFactory), (Logger)this.logCore);
            tracciamentoManager.invoke(info, esitoContext, this.msgDiag);
        }
        catch (Exception e) {
            ServicesUtils.processTrackingException(e, this.logCore, FaseTracciamento.IN_REQUEST, this.context.getPddContext());
        }
    }
}

