/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.pdd.config.ConfigurazioneCoda;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ConfigurazionePriorita;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.MessaggioServizioApplicativo;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateDBManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerConsegnaContenutiApplicativiSender;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.openspcoop2.utils.threads.IGestoreCodaRunnableInstance;
import org.openspcoop2.utils.threads.IRunnableInstance;
import org.openspcoop2.utils.threads.Runnable;
import org.openspcoop2.utils.threads.RunnableLogger;

public class TimerConsegnaContenutiApplicativi
implements IGestoreCodaRunnableInstance {
    private static TimerState STATE = TimerState.OFF;
    private MsgDiagnostico msgDiag = null;
    private RunnableLogger log;
    private RunnableLogger logSql;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean debug;
    private String clusterId;
    private RegistroServiziManager registroServiziReader;
    private ConfigurazionePdDManager configurazionePdDReader;
    private ConfigurazioneCoda configurazioneCoda;
    private List<ConfigurazionePriorita> configurazioniPriorita;
    private TimerLock timerLock = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphore_statistics;
    private Date lastCheckMessaggiDaRispedire = null;
    private static final String DATA_START = "DATA_START";

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public TimerConsegnaContenutiApplicativi(ConfigurazioneCoda configurazioneCoda, MsgDiagnostico msgDiag, RunnableLogger log, RunnableLogger logSql, OpenSPCoop2Properties p, ConfigurazionePdDManager configurazionePdDReader, RegistroServiziManager registroServiziReader) throws TimerException {
        this.configurazioneCoda = configurazioneCoda;
        this.msgDiag = msgDiag;
        this.log = log;
        this.logSql = logSql;
        this.propertiesReader = p;
        this.debug = configurazioneCoda.isDebug();
        this.clusterId = p.getClusterId(false);
        this.configurazioniPriorita = new ArrayList<ConfigurazionePriorita>();
        List<String> prioritaList = this.propertiesReader.getTimerConsegnaContenutiApplicativiPriorita();
        for (int i = 0; i < prioritaList.size(); ++i) {
            String priorita = prioritaList.get(i);
            this.configurazioniPriorita.add(this.propertiesReader.getTimerConsegnaContenutiApplicativiConfigurazionePriorita(priorita));
        }
        this.configurazionePdDReader = configurazionePdDReader;
        this.registroServiziReader = registroServiziReader;
        this.timerLock = new TimerLock(TipoLock.CONSEGNA_NOTIFICHE, configurazioneCoda.getName());
        if (this.propertiesReader.isTimerLockByDatabase()) {
            this.semaphore_statistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.propertiesReader.getTimerConsegnaContenutiApplicativiLockMaxLife(), this.propertiesReader.getTimerConsegnaContenutiApplicativiLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.propertiesReader.getDatabaseType());
            try {
                this.semaphore = new Semaphore(this.semaphore_statistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.log.getLog());
            }
            catch (Exception e) {
                throw new TimerException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(RunnableLogger log) throws UtilsException {
        OpenSPCoopStateful openspcoopstateGestore = new OpenSPCoopStateful();
        try {
            this.logDebug("Rilascio eventuali messaggi con lock appesi da riconsegnare verso il modulo ConsegnaContenutiApplicativi ...");
            openspcoopstateGestore.initResource(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "TimerConsegnaContenutiApplicativi", "initialize", OpenSPCoopStateDBManager.smistatoreMessaggiPresiInCarico);
            Connection connectionDB = ((StateMessage)openspcoopstateGestore.getStatoRichiesta()).getConnectionDB();
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstateGestore, true, this.logSql.getLog(), this.msgDiag, null);
            String causaMessaggiINBOXDaRiconsegnare = "Rilascio eventuali messaggi con lock appesi da riconsegnare verso il modulo ConsegnaContenutiApplicativi";
            try {
                GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXDaRiconsegnare, this.propertiesReader.getTimerConsegnaContenutiApplicativi_getLockAttesaAttiva(), this.propertiesReader.getTimerConsegnaContenutiApplicativi_getLockCheckInterval());
                gestoreMsgSearch.releaseMessaggiPresaInCosegna(this.configurazioneCoda.getName(), this.clusterId, this.debug, this.logSql);
            }
            finally {
                try {
                    GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOXDaRiconsegnare);
                }
                catch (Exception exception) {}
            }
            this.logDebug("Rilascio effettuato di eventuali messaggi con lock appesi da riconsegnare verso il modulo ConsegnaContenutiApplicativi");
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiRilascioLockRiconsegnaConsegnaContenutiApplicativi");
            this.logError("Riscontrato errore durante la gestione del repository dei messaggi (Rilascio lock per riconsegna verso ConsegnaContenutiApplicativi): " + e.getMessage(), e);
        }
        finally {
            if (openspcoopstateGestore != null) {
                openspcoopstateGestore.releaseResource();
            }
        }
    }

    public void logCheckInProgress(Map<String, Object> context) {
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.log.info(this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloRepositoryMessaggi = DateManager.getTimeMillis();
        context.put(DATA_START, startControlloRepositoryMessaggi);
    }

    public void logRegisteredThreads(Map<String, Object> context, int nuoviThreadsAttivati) {
        if (nuoviThreadsAttivati > 0) {
            this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INOLTRATI@", "" + nuoviThreadsAttivati);
            this.msgDiag.logPersonalizzato("ricercaMessaggiDaInoltrare");
        }
    }

    public void logCheckFinished(Map<String, Object> context) {
        long endControlloRepositoryMessaggi = DateManager.getTimeMillis();
        long startControlloRepositoryMessaggi = (Long)context.get(DATA_START);
        long diff = endControlloRepositoryMessaggi - startControlloRepositoryMessaggi;
        this.log.info("Controllo Repository Messaggi (Riconsegna verso ConsegnaContenutiApplicativi) terminato in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Runnable> nextRunnable(int limit) throws UtilsException {
        List<Runnable> returnNull = null;
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logError("Rilevato sistema in shutdown");
            return returnNull;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logError(msgErrore);
            throw new UtilsException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logError("Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return returnNull;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logError("Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return returnNull;
        }
        if (!TimerState.ENABLED.equals((Object)STATE)) {
            this.msgDiag.logPersonalizzato("disabilitato");
            this.log.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
            return returnNull;
        }
        OpenSPCoopStateful openspcoopstateGestore = new OpenSPCoopStateful();
        try {
            int finestraAncoraDisponibileDopoApplicativiPrioritari;
            this.logDebug("Inizializzazione connessione al db per ricercare nuovi threads da attivare (limit: " + limit + ") ...");
            openspcoopstateGestore.initResource(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "TimerConsegnaContenutiApplicativi", "nextRunnable", OpenSPCoopStateDBManager.smistatoreMessaggiPresiInCarico);
            Connection connectionDB = ((StateMessage)openspcoopstateGestore.getStatoRichiesta()).getConnectionDB();
            boolean verificaPresenzaMessaggiDaRispedire = false;
            boolean calcolaDataMinimaMessaggiRispedire = false;
            Integer secondiAnzianitaPerIniziareSpedireNuovoMessaggio = this.configurazioneCoda.getScheduleMessageAfter();
            if (this.lastCheckMessaggiDaRispedire == null) {
                this.lastCheckMessaggiDaRispedire = DateManager.getDate();
                verificaPresenzaMessaggiDaRispedire = true;
            } else {
                Date expired = new Date(DateManager.getTimeMillis() - (long)(1000 * this.configurazioneCoda.getNextMessages_consegnaFallita_intervalloControllo()));
                this.logDebug("(" + this.configurazioneCoda.getName() + ") Verifica check messaggi da spedire previsto quando ultimo chek '" + DateUtils.getSimpleDateFormatMs().format(this.lastCheckMessaggiDaRispedire) + "' < '" + DateUtils.getSimpleDateFormatMs().format(expired) + "' ...");
                if (this.lastCheckMessaggiDaRispedire.before(expired)) {
                    verificaPresenzaMessaggiDaRispedire = true;
                    this.lastCheckMessaggiDaRispedire = DateManager.getDate();
                }
            }
            if (verificaPresenzaMessaggiDaRispedire) {
                calcolaDataMinimaMessaggiRispedire = this.configurazioneCoda.isNextMessages_consegnaFallita_calcolaDataMinimaRiconsegna();
            }
            this.logDebug("(" + this.configurazioneCoda.getName() + ") verificaPresenzaMessaggiDaRispedire:" + verificaPresenzaMessaggiDaRispedire + " calcolaDataMinimaMessaggiRispedire:" + calcolaDataMinimaMessaggiRispedire);
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstateGestore, true, this.logSql.getLog(), this.msgDiag, null);
            Date now = DateManager.getDate();
            ArrayList<MessaggioServizioApplicativo> msgDaRiconsegnareINBOX = new ArrayList<MessaggioServizioApplicativo>();
            List<String> serviziApplicativiPrioritari = this.configurazionePdDReader.getServiziApplicativiConsegnaNotifichePrioritarie(this.configurazioneCoda.getName());
            if (serviziApplicativiPrioritari != null && !serviziApplicativiPrioritari.isEmpty()) {
                String prefix = "[Applicativi Prioritari] ";
                String causale = prefix + "Messaggi da riconsegnare verso il modulo ConsegnaContenutiApplicativi";
                try {
                    this.logDebug(prefix + "Acquisizione lock per ricercare nuovi threads da attivare (limit: " + limit + ") ...");
                    this.lock(connectionDB, causale);
                    this.logDebug(prefix + "Lock acquisito, ricerca nuovi threads da attivare (limit: " + limit + ") ...");
                    List<MessaggioServizioApplicativo> msgDaRiconsegnareINBOX_priorita = gestoreMsgSearch.readMessaggiDaRiconsegnareIntoBoxByServiziApplicativPrioritari(limit, verificaPresenzaMessaggiDaRispedire, calcolaDataMinimaMessaggiRispedire, secondiAnzianitaPerIniziareSpedireNuovoMessaggio, now, this.propertiesReader.getTimerConsegnaContenutiApplicativiPresaInConsegnaMaxLife(), this.debug, this.logSql, this.configurazioneCoda.getName(), serviziApplicativiPrioritari.toArray(new String[1]));
                    if (msgDaRiconsegnareINBOX_priorita != null && !msgDaRiconsegnareINBOX_priorita.isEmpty()) {
                        this.logDebug(prefix + "Ricerca nuovi threads da attivare terminata (limit: " + limit + "); prendo in carico " + msgDaRiconsegnareINBOX_priorita.size() + " messaggi ...");
                        for (MessaggioServizioApplicativo messaggioServizioApplicativo : msgDaRiconsegnareINBOX_priorita) {
                            GestoreMessaggi messaggioDaInviare = new GestoreMessaggi(openspcoopstateGestore, true, messaggioServizioApplicativo.getIdMessaggio(), "INBOX", this.log.getLog(), this.msgDiag, null);
                            messaggioDaInviare.updateMessaggioPresaInCosegna(messaggioServizioApplicativo.getServizioApplicativo(), this.clusterId, this.debug, this.logSql);
                            msgDaRiconsegnareINBOX.add(messaggioServizioApplicativo);
                        }
                        this.logDebug(prefix + "Presa in carico " + msgDaRiconsegnareINBOX_priorita.size() + " messaggi terminata, rilascio lock...");
                    } else {
                        this.logDebug(prefix + "Ricerca nuovi threads da attivare terminata (limit: " + limit + "); non sono presenti messaggi, rilascio lock...");
                    }
                }
                finally {
                    this.releaseLock(connectionDB, causale);
                }
                this.logDebug(prefix + "Lock rilasciato");
            }
            if ((finestraAncoraDisponibileDopoApplicativiPrioritari = limit - msgDaRiconsegnareINBOX.size()) > 0) {
                for (ConfigurazionePriorita configurazionePriorita : this.configurazioniPriorita) {
                    String prefix = "[P-" + configurazionePriorita.getLabel() + "] ";
                    int limitPriorita = 0;
                    if (configurazionePriorita.isNessunaPriorita()) {
                        limitPriorita = limit - msgDaRiconsegnareINBOX.size();
                        this.logDebug(prefix + "Calcolo limit; cerco entries rimaste senza guardare la priorit\u00e0 (" + limitPriorita + ") ...");
                    } else {
                        limitPriorita = finestraAncoraDisponibileDopoApplicativiPrioritari * configurazionePriorita.getPercentuale() / 100;
                        this.logDebug(prefix + "Calcolo limit; " + configurazionePriorita.getPercentuale() + "% di " + finestraAncoraDisponibileDopoApplicativiPrioritari + ": " + limitPriorita + " ...");
                    }
                    if (limitPriorita <= 0) {
                        this.logDebug(prefix + "Per la priorit\u00e0 non \u00e8 necessario cercare alcun messaggio");
                        continue;
                    }
                    String causale = prefix + "Messaggi da riconsegnare verso il modulo ConsegnaContenutiApplicativi";
                    try {
                        this.logDebug(prefix + "Acquisizione lock per ricercare nuovi threads da attivare (limit: " + limitPriorita + ") ...");
                        this.lock(connectionDB, causale);
                        this.logDebug(prefix + "Lock acquisito, ricerca nuovi threads da attivare (limit: " + limitPriorita + ") ...");
                        List<MessaggioServizioApplicativo> msgDaRiconsegnareINBOXpriorita = gestoreMsgSearch.readMessaggiDaRiconsegnareIntoBoxByPriorita(limitPriorita, verificaPresenzaMessaggiDaRispedire, calcolaDataMinimaMessaggiRispedire, secondiAnzianitaPerIniziareSpedireNuovoMessaggio, now, this.propertiesReader.getTimerConsegnaContenutiApplicativiPresaInConsegnaMaxLife(), this.debug, this.logSql, this.configurazioneCoda.getName(), configurazionePriorita.isNessunaPriorita() ? null : configurazionePriorita.getName());
                        if (msgDaRiconsegnareINBOXpriorita != null && !msgDaRiconsegnareINBOXpriorita.isEmpty()) {
                            this.logDebug(prefix + "Ricerca nuovi threads da attivare terminata (limit: " + limitPriorita + "); prendo in carico " + msgDaRiconsegnareINBOXpriorita.size() + " messaggi ...");
                            for (MessaggioServizioApplicativo messaggioServizioApplicativo : msgDaRiconsegnareINBOXpriorita) {
                                GestoreMessaggi messaggioDaInviare = new GestoreMessaggi(openspcoopstateGestore, true, messaggioServizioApplicativo.getIdMessaggio(), "INBOX", this.log.getLog(), this.msgDiag, null);
                                messaggioDaInviare.updateMessaggioPresaInCosegna(messaggioServizioApplicativo.getServizioApplicativo(), this.clusterId, this.debug, this.logSql);
                                msgDaRiconsegnareINBOX.add(messaggioServizioApplicativo);
                            }
                            this.logDebug(prefix + "Presa in carico " + msgDaRiconsegnareINBOXpriorita.size() + " messaggi terminata, rilascio lock...");
                        } else {
                            this.logDebug(prefix + "Ricerca nuovi threads da attivare terminata (limit: " + limitPriorita + "); non sono presenti messaggi, rilascio lock...");
                        }
                    }
                    finally {
                        this.releaseLock(connectionDB, causale);
                    }
                    this.logDebug(prefix + "Lock rilasciato");
                }
            }
            this.logDebug("Creazione Runnable ...");
            ArrayList<Runnable> listRunnable = null;
            if (msgDaRiconsegnareINBOX != null && !msgDaRiconsegnareINBOX.isEmpty()) {
                listRunnable = new ArrayList<Runnable>();
                for (MessaggioServizioApplicativo messaggioServizioApplicativo : msgDaRiconsegnareINBOX) {
                    TimerConsegnaContenutiApplicativiSender sender = new TimerConsegnaContenutiApplicativiSender(messaggioServizioApplicativo, this.registroServiziReader, this.configurazionePdDReader, this.clusterId, this.configurazioneCoda);
                    listRunnable.add(new Runnable((IRunnableInstance)sender, -1));
                }
            }
            this.logDebug("Creazione Runnable terminata");
            ArrayList<Runnable> arrayList = listRunnable;
            return arrayList;
        }
        catch (TimerLockNotAvailableException t) {
            this.log.info(t.getMessage(), (Throwable)t);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiRiconsegnaConsegnaContenutiApplicativi");
            this.logError("Riscontrato errore durante la gestione del repository dei messaggi (Riconsegna verso ConsegnaContenutiApplicativi): " + e.getMessage(), e);
        }
        finally {
            if (openspcoopstateGestore != null) {
                openspcoopstateGestore.releaseResource();
            }
        }
        return returnNull;
    }

    private void lock(Connection connectionDB, String causale) throws UtilsException, TimerLockNotAvailableException {
        GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causale, this.propertiesReader.getTimerConsegnaContenutiApplicativi_getLockAttesaAttiva(), this.propertiesReader.getTimerConsegnaContenutiApplicativi_getLockCheckInterval());
    }

    private void releaseLock(Connection connectionDB, String causale) {
        try {
            GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causale);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logDebug(String msg) {
        this.logDebug(msg, null);
    }

    private void logDebug(String msg, Throwable e) {
        if (e != null) {
            this.log.debug(this.getPrefix() + msg, e);
        } else {
            this.log.debug(this.getPrefix() + msg);
        }
    }

    private void logError(String msg) {
        this.logError(msg, null);
    }

    private void logError(String msg, Throwable e) {
        if (e != null) {
            this.log.error(this.getPrefix() + msg, e);
        } else {
            this.log.error(this.getPrefix() + msg);
        }
    }

    private String getPrefix() {
        if (this.configurazioneCoda != null) {
            return "[" + this.configurazioneCoda.getName() + "] ";
        }
        return "";
    }
}

