/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsLibrary;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.DBStatisticheManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class TimerStatisticheLib {
    private static TimerState STATE_STATISTICHE_ORARIE = TimerState.OFF;
    private static TimerState STATE_STATISTICHE_GIORNALIERE = TimerState.OFF;
    private static TimerState STATE_STATISTICHE_SETTIMANALI = TimerState.OFF;
    private static TimerState STATE_STATISTICHE_MENSILI = TimerState.OFF;
    private static TimerState STATE_PDND_TRACCIAMENTO_PUBBLICAZIONE = TimerState.OFF;
    private static TimerState STATE_PDND_TRACCIAMENTO_GENERAZIONE = TimerState.OFF;
    private Logger logCore = null;
    private Logger logSql = null;
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private OpenSPCoop2Properties op2Properties = null;
    private boolean generazioneStatisticheCustom = false;
    private boolean analisiTransazioniCustom = false;
    private boolean debug = false;
    private boolean useUnionForLatency = false;
    private long waitMsBeforeNextInterval = -1L;
    private boolean waitStatiInConsegna = false;
    private TipoIntervalloStatistico tipoStatistica;
    private boolean statisticheOrarie = false;
    private boolean statisticheGiornaliere = false;
    private boolean statisticheSettimanali = false;
    private boolean statisticheMensili = false;
    private boolean tracciamentoPdndGenerazione = false;
    private boolean tracciamentoPdndPubblicazione = false;
    private boolean statisticheOrarie_gestioneUltimoIntervallo = false;
    private boolean statisticheGiornaliere_gestioneUltimoIntervallo = false;
    private boolean statisticheSettimanali_gestioneUltimoIntervallo = false;
    private boolean statisticheMensili_gestioneUltimoIntervallo = false;
    private String tipoDatabase = null;
    private DAOFactory daoFactory = null;
    private Logger daoFactoryLogger = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesStatistiche = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsStatistiche = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsBase = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesUtils = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPluginsTransazioni = null;
    private StatisticsConfig statisticsConfig;
    private TimerLock timerLock = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphore_statistics;

    public static TimerState getSTATE_STATISTICHE_ORARIE() {
        return STATE_STATISTICHE_ORARIE;
    }

    public static void setSTATE_STATISTICHE_ORARIE(TimerState sTATE_STATISTICHE_ORARIE) {
        STATE_STATISTICHE_ORARIE = sTATE_STATISTICHE_ORARIE;
    }

    public static TimerState getSTATE_STATISTICHE_GIORNALIERE() {
        return STATE_STATISTICHE_GIORNALIERE;
    }

    public static void setSTATE_STATISTICHE_GIORNALIERE(TimerState sTATE_STATISTICHE_GIORNALIERE) {
        STATE_STATISTICHE_GIORNALIERE = sTATE_STATISTICHE_GIORNALIERE;
    }

    public static TimerState getSTATE_STATISTICHE_SETTIMANALI() {
        return STATE_STATISTICHE_SETTIMANALI;
    }

    public static void setSTATE_STATISTICHE_SETTIMANALI(TimerState sTATE_STATISTICHE_SETTIMANALI) {
        STATE_STATISTICHE_SETTIMANALI = sTATE_STATISTICHE_SETTIMANALI;
    }

    public static TimerState getSTATE_STATISTICHE_MENSILI() {
        return STATE_STATISTICHE_MENSILI;
    }

    public static void setSTATE_STATISTICHE_MENSILI(TimerState sTATE_STATISTICHE_MENSILI) {
        STATE_STATISTICHE_MENSILI = sTATE_STATISTICHE_MENSILI;
    }

    public static TimerState getSTATE_PDND_TRACCIAMENTO_PUBBLICAZIONE() {
        return STATE_PDND_TRACCIAMENTO_PUBBLICAZIONE;
    }

    public static void setSTATE_PDND_TRACCIAMENTO_PUBBLICAZIONE(TimerState sTATE_PDND_TRACCIAMENTO_PUBBLICAZIONE) {
        STATE_PDND_TRACCIAMENTO_PUBBLICAZIONE = sTATE_PDND_TRACCIAMENTO_PUBBLICAZIONE;
    }

    public static TimerState getSTATE_PDND_TRACCIAMENTO_GENERAZIONE() {
        return STATE_PDND_TRACCIAMENTO_GENERAZIONE;
    }

    public static void setSTATE_PDND_TRACCIAMENTO_GENERAZIONE(TimerState sTATE_PDND_TRACCIAMENTO_GENERAZIONE) {
        STATE_PDND_TRACCIAMENTO_GENERAZIONE = sTATE_PDND_TRACCIAMENTO_GENERAZIONE;
    }

    public TimerStatisticheLib(TipoIntervalloStatistico tipoStatistica, MsgDiagnostico msgDiag, Logger logTimer, OpenSPCoop2Properties p) throws Exception {
        this.msgDiag = msgDiag;
        this.op2Properties = p;
        this.debug = this.op2Properties.isStatisticheGenerazioneDebug();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopStatistiche(tipoStatistica, this.debug);
        this.logSql = OpenSPCoop2Logger.getLoggerOpenSPCoopStatisticheSql(tipoStatistica, this.debug);
        this.logTimer = logTimer;
        this.useUnionForLatency = this.op2Properties.isStatisticheGenerazioneUseUnionForLatency();
        this.generazioneStatisticheCustom = this.op2Properties.isStatisticheGenerazioneCustomEnabled();
        this.analisiTransazioniCustom = this.op2Properties.isStatisticheGenerazioneCustomSdkEnabled();
        this.tipoStatistica = tipoStatistica;
        switch (this.tipoStatistica) {
            case STATISTICHE_ORARIE: {
                this.statisticheOrarie = this.op2Properties.isStatisticheGenerazioneBaseOrariaEnabled();
                this.statisticheOrarie_gestioneUltimoIntervallo = this.op2Properties.isStatisticheGenerazioneBaseOrariaEnabledUltimaOra();
                break;
            }
            case STATISTICHE_GIORNALIERE: {
                this.statisticheGiornaliere = this.op2Properties.isStatisticheGenerazioneBaseGiornalieraEnabled();
                this.statisticheGiornaliere_gestioneUltimoIntervallo = this.op2Properties.isStatisticheGenerazioneBaseGiornalieraEnabledUltimoGiorno();
                break;
            }
            case STATISTICHE_SETTIMANALI: {
                this.statisticheSettimanali = this.op2Properties.isStatisticheGenerazioneBaseSettimanaleEnabled();
                this.statisticheSettimanali_gestioneUltimoIntervallo = this.op2Properties.isStatisticheGenerazioneBaseSettimanaleEnabledUltimaSettimana();
                break;
            }
            case STATISTICHE_MENSILI: {
                this.statisticheMensili = this.op2Properties.isStatisticheGenerazioneBaseMensileEnabled();
                this.statisticheMensili_gestioneUltimoIntervallo = this.op2Properties.isStatisticheGenerazioneBaseMensileEnabledUltimoMese();
                break;
            }
            case PDND_GENERAZIONE_TRACCIAMENTO: {
                this.tracciamentoPdndGenerazione = this.op2Properties.isStatistichePdndTracciamentoGenerazioneEnabled();
                break;
            }
            case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                this.tracciamentoPdndPubblicazione = this.op2Properties.isStatistichePdndTracciamentoPubblicazioneEnabled();
            }
        }
        this.waitStatiInConsegna = this.op2Properties.isStatisticheGenerazioneAttendiCompletamentoTransazioniInFasiIntermedie();
        this.waitMsBeforeNextInterval = this.op2Properties.getStatisticheGenerazioneTradeOffMs();
        try {
            this.tipoDatabase = this.op2Properties.getDatabaseType();
            if (this.tipoDatabase == null) {
                throw new Exception("Tipo Database non definito");
            }
            String tipoDatabaseTransazioni = DBTransazioniManager.getInstance().getTipoDatabase();
            if (tipoDatabaseTransazioni == null) {
                throw new Exception("Tipo Database Transazioni non definito");
            }
            DAOFactoryProperties daoFactoryProperties = null;
            this.daoFactoryLogger = this.logSql;
            this.daoFactory = DAOFactory.getInstance((Logger)this.daoFactoryLogger);
            daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)this.daoFactoryLogger);
            this.daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance());
            this.daoFactoryServiceManagerPropertiesTransazioni.setShowSql(this.debug);
            this.daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(tipoDatabaseTransazioni);
            this.daoFactoryServiceManagerPropertiesStatistiche = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
            this.daoFactoryServiceManagerPropertiesStatistiche.setShowSql(this.debug);
            this.daoFactoryServiceManagerPropertiesStatistiche.setDatabaseType(tipoDatabaseTransazioni);
            if (this.generazioneStatisticheCustom) {
                this.daoFactoryServiceManagerPropertiesPluginsStatistiche = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo.getInstance());
                this.daoFactoryServiceManagerPropertiesPluginsStatistiche.setShowSql(this.debug);
                this.daoFactoryServiceManagerPropertiesPluginsStatistiche.setDatabaseType(this.tipoDatabase);
                this.daoFactoryServiceManagerPropertiesPluginsBase = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance());
                this.daoFactoryServiceManagerPropertiesPluginsBase.setShowSql(this.debug);
                this.daoFactoryServiceManagerPropertiesPluginsBase.setDatabaseType(this.tipoDatabase);
                this.daoFactoryServiceManagerPropertiesUtils = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance());
                this.daoFactoryServiceManagerPropertiesUtils.setShowSql(this.debug);
                this.daoFactoryServiceManagerPropertiesUtils.setDatabaseType(this.tipoDatabase);
                if (this.analisiTransazioniCustom) {
                    this.daoFactoryServiceManagerPropertiesPluginsTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance());
                    this.daoFactoryServiceManagerPropertiesPluginsTransazioni.setShowSql(this.debug);
                    this.daoFactoryServiceManagerPropertiesPluginsTransazioni.setDatabaseType(this.tipoDatabase);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Errore durante l'inizializzazione del datasource: " + e.getMessage(), e);
        }
        try {
            this.statisticsConfig = new StatisticsConfig(false);
            this.statisticsConfig.setLogCore(this.logCore);
            this.statisticsConfig.setLogSql(this.logSql);
            this.statisticsConfig.setGenerazioneStatisticheCustom(this.generazioneStatisticheCustom);
            this.statisticsConfig.setAnalisiTransazioniCustom(this.analisiTransazioniCustom);
            this.statisticsConfig.setDebug(this.debug);
            this.statisticsConfig.setUseUnionForLatency(this.useUnionForLatency);
            this.statisticsConfig.setStatisticheOrarie(this.statisticheOrarie);
            this.statisticsConfig.setStatisticheGiornaliere(this.statisticheGiornaliere);
            this.statisticsConfig.setStatisticheSettimanali(this.statisticheSettimanali);
            this.statisticsConfig.setStatisticheMensili(this.statisticheMensili);
            this.statisticsConfig.setStatisticheOrarieGestioneUltimoIntervallo(this.statisticheOrarie_gestioneUltimoIntervallo);
            this.statisticsConfig.setStatisticheGiornaliereGestioneUltimoIntervallo(this.statisticheGiornaliere_gestioneUltimoIntervallo);
            this.statisticsConfig.setStatisticheSettimanaliGestioneUltimoIntervallo(this.statisticheSettimanali_gestioneUltimoIntervallo);
            this.statisticsConfig.setStatisticheMensiliGestioneUltimoIntervallo(this.statisticheMensili_gestioneUltimoIntervallo);
            this.statisticsConfig.setWaitMsBeforeNextInterval(this.waitMsBeforeNextInterval);
            this.statisticsConfig.setWaitStatiInConsegna(this.waitStatiInConsegna);
            if (ProtocolFactoryManager.getInstance().existsProtocolFactory("modipa") && ModIUtils.isTracingPDNDEnabled()) {
                this.statisticsConfig.setPdndTracciamentoGenerazione(this.tracciamentoPdndGenerazione);
                this.statisticsConfig.setPdndTracciamentoPubblicazione(this.tracciamentoPdndPubblicazione);
            } else {
                this.statisticsConfig.setPdndTracciamentoGenerazione(false);
                this.statisticsConfig.setPdndTracciamentoPubblicazione(false);
            }
            this.statisticsConfig.setPdndTracciamentoGenerazioneDelayMinutes(this.op2Properties.getStatistichePdndTracciamentoGenerazioneDelayMinutes());
            this.statisticsConfig.setPdndTracciamentoErogazioniEnabled(this.op2Properties.isStatistichePdndTracciamentoErogazioniEnabled());
            this.statisticsConfig.setPdndTracciamentoFruizioniEnabled(this.op2Properties.isStatistichePdndTracciamentoFruizioniEnabled());
            this.statisticsConfig.setPdndTracciamentoRequestConfig(this.op2Properties.getStatistichePdndTracciamentoHttpRequestConfig());
            this.statisticsConfig.setPdndTracciamentoSoggettiEnabled(this.op2Properties.getStatistichePdndTracciamentoSoggettiEnabled());
            this.statisticsConfig.setPdndTracciamentoSoggettiDisabled(this.op2Properties.isStatistichePdndTracciamentoSoggettiDisabled());
            this.statisticsConfig.setPdndTracciamentoMaxAttempt(this.op2Properties.getStatistichePdndTracciamentoMaxAttempts());
            this.statisticsConfig.setPdndTracciamentoPendingCheck(this.op2Properties.getStatistichePdndTracciamentoPendingCheck());
            this.statisticsConfig.setPdndTracciamentoGenerazioneDbBatchSize(this.op2Properties.getPdndTracciamentoGenerazioneDbBatchSize());
            this.statisticsConfig.setPdndTracciamentoPubblicazioneDbBatchSize(this.op2Properties.getPdndTracciamentoPubblicazioneDbBatchSize());
        }
        catch (Exception e) {
            throw new Exception("Errore durante la generazione delle statistiche (InitConfigurazione): " + e.getMessage(), e);
        }
        switch (this.tipoStatistica) {
            case STATISTICHE_ORARIE: {
                this.timerLock = new TimerLock(TipoLock.GENERAZIONE_STATISTICHE_ORARIE);
                break;
            }
            case STATISTICHE_GIORNALIERE: {
                this.timerLock = new TimerLock(TipoLock.GENERAZIONE_STATISTICHE_GIORNALIERE);
                break;
            }
            case STATISTICHE_SETTIMANALI: {
                this.timerLock = new TimerLock(TipoLock.GENERAZIONE_STATISTICHE_SETTIMANALI);
                break;
            }
            case STATISTICHE_MENSILI: {
                this.timerLock = new TimerLock(TipoLock.GENERAZIONE_STATISTICHE_MENSILI);
                break;
            }
            case PDND_GENERAZIONE_TRACCIAMENTO: {
                this.timerLock = new TimerLock(TipoLock.GENERAZIONE_PDND_TRACCIAMENTO_GENERAZIONE);
                break;
            }
            case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                this.timerLock = new TimerLock(TipoLock.GENERAZIONE_PDND_TRACCIAMENTO_PUBBLICAZIONE);
            }
        }
        if (this.op2Properties.isTimerLockByDatabase()) {
            this.semaphore_statistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.op2Properties.getStatisticheGenerazioneTimerLockMaxLife(), this.op2Properties.getStatisticheGenerazioneTimerLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.tipoDatabase);
            try {
                this.semaphore = new Semaphore(this.semaphore_statistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.logTimer);
            }
            catch (Exception e) {
                throw new TimerException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check() throws TimerException {
        block146: {
            if (OpenSPCoop2Startup.contextDestroyed) {
                this.logTimer.error("[TimerStatistiche] Rilevato sistema in shutdown");
                return;
            }
            if (!OpenSPCoop2Startup.initialize) {
                this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
                msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
                this.logTimer.error(msgErrore);
                throw new TimerException(msgErrore);
            }
            if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
                this.logTimer.error("[TimerStatistiche] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                this.logTimer.error("[TimerStatistiche] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                return;
            }
            enabled = false;
            switch (1.$SwitchMap$org$openspcoop2$core$statistiche$constants$TipoIntervalloStatistico[this.tipoStatistica.ordinal()]) {
                case 1: {
                    enabled = TimerState.ENABLED.equals((Object)TimerStatisticheLib.STATE_STATISTICHE_ORARIE);
                    break;
                }
                case 2: {
                    enabled = TimerState.ENABLED.equals((Object)TimerStatisticheLib.STATE_STATISTICHE_GIORNALIERE);
                    break;
                }
                case 3: {
                    enabled = TimerState.ENABLED.equals((Object)TimerStatisticheLib.STATE_STATISTICHE_SETTIMANALI);
                    break;
                }
                case 4: {
                    enabled = TimerState.ENABLED.equals((Object)TimerStatisticheLib.STATE_STATISTICHE_MENSILI);
                    break;
                }
                case 5: {
                    enabled = TimerState.ENABLED.equals((Object)TimerStatisticheLib.STATE_PDND_TRACCIAMENTO_GENERAZIONE);
                    break;
                }
                case 6: {
                    enabled = TimerState.ENABLED.equals((Object)TimerStatisticheLib.STATE_PDND_TRACCIAMENTO_PUBBLICAZIONE);
                    break;
                }
            }
            if (!enabled) {
                this.msgDiag.logPersonalizzato("disabilitato");
                this.logCore.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
                this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
                return;
            }
            this.msgDiag.logPersonalizzato("generazioneStatistiche");
            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("generazioneStatistiche"));
            startControlloTimer = DateManager.getTimeMillis();
            dbTransazioniManager = null;
            dbStatisticheManager = null;
            rTransazioni = null;
            rStatistiche = null;
            conConfig = null;
            driverConfigurazioneDB = null;
            dbTransazioniManager = DBTransazioniManager.getInstance();
            rTransazioni = dbTransazioniManager.getResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", null);
            if (rTransazioni == null) {
                throw new Exception("Risorsa al database delle transazioni non disponibile");
            }
            conTransazioni = (Connection)rTransazioni.getResource();
            if (conTransazioni == null) {
                throw new Exception("Connessione al database delle transazioni non disponibile");
            }
            conStatistiche = null;
            if (this.op2Properties.isStatisticheUseTransazioniDatasource()) {
                conStatistiche = conTransazioni;
            } else if (this.op2Properties.isStatisticheUsePddRuntimeDatasource() && this.op2Properties.isTransazioniUsePddRuntimeDatasource()) {
                conStatistiche = conTransazioni;
            } else {
                dbStatisticheManager = DBStatisticheManager.getInstance();
                rStatistiche = dbStatisticheManager.getResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", null);
                if (rStatistiche == null) {
                    throw new Exception("Risorsa al database delle statistiche non disponibile");
                }
                conStatistiche = (Connection)rStatistiche.getResource();
                if (conStatistiche == null) {
                    throw new Exception("Connessione al database delle statistiche non disponibile");
                }
            }
            statisticheSM = (org.openspcoop2.core.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), conStatistiche, this.daoFactoryServiceManagerPropertiesStatistiche, this.daoFactoryLogger);
            transazioniSM = (org.openspcoop2.core.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.transazioni.utils.ProjectInfo.getInstance(), conTransazioni, this.daoFactoryServiceManagerPropertiesTransazioni, this.daoFactoryLogger);
            pluginsStatisticheSM = null;
            pluginsBaseSM = null;
            utilsSM = null;
            pluginsTransazioniSM = null;
            if (this.generazioneStatisticheCustom || this.tracciamentoPdndGenerazione || this.tracciamentoPdndPubblicazione) {
                driverConfigurazione = ConfigurazionePdDReader.getDriverConfigurazionePdD();
                if (driverConfigurazione instanceof DriverConfigurazioneDB == false) throw new Exception("La generazione delle statistiche custom richiede una configurazione di tipo 'db', trovato: " + driverConfigurazione.getClass().getName());
                driverConfigurazioneDB = (DriverConfigurazioneDB)driverConfigurazione;
                conConfig = driverConfigurazioneDB.getConnection("TimerStatistiche.customStats");
                pluginsStatisticheSM = (org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo.getInstance(), conConfig, this.daoFactoryServiceManagerPropertiesPluginsStatistiche, this.daoFactoryLogger);
                pluginsBaseSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), conConfig, this.daoFactoryServiceManagerPropertiesPluginsBase, this.daoFactoryLogger);
                utilsSM = (org.openspcoop2.core.commons.search.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), conConfig, this.daoFactoryServiceManagerPropertiesUtils, this.daoFactoryLogger);
                if (this.analisiTransazioniCustom) {
                    pluginsTransazioniSM = (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), conConfig, this.daoFactoryServiceManagerPropertiesPluginsTransazioni, this.daoFactoryLogger);
                }
            }
            this.statisticsConfig.setForceIndexConfig(this.op2Properties.getStatisticheGenerazioneExternalForceIndexRepository());
            this.statisticsConfig.setGroupByConfig(this.op2Properties.getStatisticheGenerazioneGroupByConfig());
            causa = "Generazione Statistiche";
            try {
                GestoreMessaggi.acquireLock(this.semaphore, conStatistiche, this.timerLock, this.msgDiag, causa, this.op2Properties.getStatisticheGenerazioneTimerLockAttesaAttiva(), this.op2Properties.getStatisticheGenerazioneTimerLockCheckInterval());
                sLibrary = new StatisticsLibrary(this.statisticsConfig, statisticheSM, transazioniSM, pluginsStatisticheSM, pluginsBaseSM, utilsSM, pluginsTransazioniSM);
                switch (1.$SwitchMap$org$openspcoop2$core$statistiche$constants$TipoIntervalloStatistico[this.tipoStatistica.ordinal()]) {
                    case 1: {
                        if (this.generaStatistica("orario", conStatistiche, sLibrary, TipoIntervalloStatistico.STATISTICHE_ORARIE)) ** break;
                        try {
                            if (rTransazioni != null) {
                                dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
                            }
                        }
                        catch (Throwable var20_34) {
                            // empty catch block
                        }
                        try {
                            if (rStatistiche != null) {
                                dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
                            }
                        }
                        catch (Throwable var20_35) {
                            // empty catch block
                        }
                        try {
                            if (conConfig == null) return;
                            driverConfigurazioneDB.releaseConnection(conConfig);
                            return;
                        }
                        catch (Throwable var20_36) {
                            // empty catch block
                        }
                        return;
                    }
                    case 2: {
                        if (this.generaStatistica("giornaliero", conStatistiche, sLibrary, TipoIntervalloStatistico.STATISTICHE_GIORNALIERE)) ** break;
                        try {
                            if (rTransazioni != null) {
                                dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
                            }
                        }
                        catch (Throwable var20_38) {
                            // empty catch block
                        }
                        try {
                            if (rStatistiche != null) {
                                dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
                            }
                        }
                        catch (Throwable var20_39) {
                            // empty catch block
                        }
                        try {
                            if (conConfig == null) return;
                            driverConfigurazioneDB.releaseConnection(conConfig);
                            return;
                        }
                        catch (Throwable var20_40) {
                            // empty catch block
                        }
                        return;
                    }
                    case 3: {
                        if (this.generaStatistica("settimanale", conStatistiche, sLibrary, TipoIntervalloStatistico.STATISTICHE_SETTIMANALI)) ** break;
                        try {
                            if (rTransazioni != null) {
                                dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
                            }
                        }
                        catch (Throwable var20_42) {
                            // empty catch block
                        }
                        try {
                            if (rStatistiche != null) {
                                dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
                            }
                        }
                        catch (Throwable var20_43) {
                            // empty catch block
                        }
                        try {
                            if (conConfig == null) return;
                            driverConfigurazioneDB.releaseConnection(conConfig);
                            return;
                        }
                        catch (Throwable var20_44) {
                            // empty catch block
                        }
                        return;
                    }
                    case 4: {
                        if (this.generaStatistica("mensile", conStatistiche, sLibrary, TipoIntervalloStatistico.STATISTICHE_MENSILI)) ** break;
                        try {
                            if (rTransazioni != null) {
                                dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
                            }
                        }
                        catch (Throwable var20_46) {
                            // empty catch block
                        }
                        try {
                            if (rStatistiche != null) {
                                dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
                            }
                        }
                        catch (Throwable var20_47) {
                            // empty catch block
                        }
                        try {
                            if (conConfig == null) return;
                            driverConfigurazioneDB.releaseConnection(conConfig);
                            return;
                        }
                        catch (Throwable var20_48) {
                            // empty catch block
                        }
                        return;
                    }
                    case 5: {
                        if (this.generaStatistica("pdnd tracciamento generazione", conStatistiche, sLibrary, TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO)) ** break;
                        try {
                            if (rTransazioni != null) {
                                dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
                            }
                        }
                        catch (Throwable var20_50) {
                            // empty catch block
                        }
                        try {
                            if (rStatistiche != null) {
                                dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
                            }
                        }
                        catch (Throwable var20_51) {
                            // empty catch block
                        }
                        try {
                            if (conConfig == null) return;
                            driverConfigurazioneDB.releaseConnection(conConfig);
                            return;
                        }
                        catch (Throwable var20_52) {
                            // empty catch block
                        }
                        return;
                    }
                    case 6: {
                        if (this.generaStatistica("pdnd pubblicazione generazione", conStatistiche, sLibrary, TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO)) ** break;
                        try {
                            if (rTransazioni != null) {
                                dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
                            }
                        }
                        catch (Throwable var20_54) {
                            // empty catch block
                        }
                        try {
                            if (rStatistiche != null) {
                                dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
                            }
                        }
                        catch (Throwable var20_55) {
                            // empty catch block
                        }
                        try {
                            if (conConfig == null) return;
                            driverConfigurazioneDB.releaseConnection(conConfig);
                            return;
                        }
                        catch (Throwable var20_56) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
            finally {
                try {
                    GestoreMessaggi.releaseLock(this.semaphore, conStatistiche, this.timerLock, this.msgDiag, causa);
                }
                catch (Exception var20_33) {}
            }
            endControlloTimer = DateManager.getTimeMillis();
            diff = endControlloTimer - startControlloTimer;
            this.logTimer.info("Generazione '" + this.tipoStatistica.getValue() + "' terminato in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
            if (rTransazioni != null) {
                dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
            }
            break block146;
            catch (Throwable conTransazioni) {
                // empty catch block
            }
        }
        try {
            if (rStatistiche != null) {
                dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
            }
        }
        catch (Throwable conTransazioni) {
            // empty catch block
        }
        try {
            if (conConfig == null) return;
            driverConfigurazioneDB.releaseConnection(conConfig);
            return;
        }
        catch (Throwable conTransazioni) {
            return;
        }
        catch (TimerLockNotAvailableException t) {
            this.logTimer.info(t.getMessage(), (Throwable)t);
            return;
            {
                catch (Throwable var23_60) {
                    throw var23_60;
                }
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GenerazioneStatistiche");
                this.logTimer.error("Riscontrato errore durante la generazione delle statistiche (" + this.tipoStatistica.getValue() + "): " + e.getMessage(), (Throwable)e);
                return;
            }
        }
        finally {
            try {
                if (rTransazioni != null) {
                    dbTransazioniManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rTransazioni);
                }
            }
            catch (Throwable t) {}
            try {
                if (rStatistiche != null) {
                    dbStatisticheManager.releaseResource(this.op2Properties.getIdentitaPortaDefaultWithoutProtocol(), "TimerStatistiche", rStatistiche);
                }
            }
            catch (Throwable t) {}
            try {
                if (conConfig != null) {
                    driverConfigurazioneDB.releaseConnection(conConfig);
                }
            }
            catch (Throwable t) {}
        }
    }

    private boolean generaStatistica(String intervallo, Connection conStatistiche, StatisticsLibrary sLibrary, TipoIntervalloStatistico tipoIntervalloStatistico) {
        long startGenerazione = DateManager.getTimeMillis();
        this.msgDiag.addKeyword("@TIPO_STATISTICA@", intervallo);
        this.msgDiag.logPersonalizzato("generazioneStatistiche.inCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("generazioneStatistiche.inCorso"));
        try {
            GestoreMessaggi.updateLock(this.semaphore, conStatistiche, this.timerLock, this.msgDiag, "Generazione statistiche intervallo '" + intervallo + "' ...");
        }
        catch (Throwable e) {
            this.msgDiag.logErroreGenerico(e, "TimerStatistiche-UpdateLock");
            this.logTimer.error("TimerStatistiche-UpdateLock: " + e.getMessage(), e);
            return false;
        }
        switch (tipoIntervalloStatistico) {
            case STATISTICHE_ORARIE: {
                sLibrary.generateStatisticaOraria();
                break;
            }
            case STATISTICHE_GIORNALIERE: {
                sLibrary.generateStatisticaGiornaliera();
                break;
            }
            case STATISTICHE_SETTIMANALI: {
                sLibrary.generateStatisticaSettimanale();
                break;
            }
            case STATISTICHE_MENSILI: {
                sLibrary.generateStatisticaMensile();
                break;
            }
            case PDND_GENERAZIONE_TRACCIAMENTO: {
                sLibrary.generatePdndGenerazioneTracciamento();
                break;
            }
            case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                sLibrary.generatePdndPubblicazioneTracciamento();
            }
        }
        long endGenerazione = DateManager.getTimeMillis();
        String tempoImpiegato = Utilities.convertSystemTimeIntoStringMillisecondi((long)(endGenerazione - startGenerazione), (boolean)true);
        this.msgDiag.addKeyword("@TEMPO_GENERAZIONE@", tempoImpiegato);
        this.msgDiag.logPersonalizzato("generazioneStatistiche.effettuata");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("generazioneStatistiche.effettuata"));
        return true;
    }
}

