/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.util.List;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.threshold.IThreshold;
import org.openspcoop2.pdd.core.threshold.ThresholdException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerThresholdThread
extends BaseThread {
    private static TimerState STATE = TimerState.OFF;
    public static boolean freeSpace = true;
    public static final String ID_MODULO = "GestoreThreshold";
    private OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
    private MsgDiagnostico msgDiag = MsgDiagnostico.newInstance("GestoreThreshold");
    private IThreshold[] gestore = null;
    private List<String> tipiThreshold = null;
    private Logger log;
    private boolean lastCheck = true;

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public TimerThresholdThread() throws ThresholdException {
        this.msgDiag.setPrefixMsgPersonalizzati("timerThreshold.");
        this.msgDiag.addKeyword("@ID_TIMER_THRESHOLD@", ID_MODULO);
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopResources();
        this.tipiThreshold = this.propertiesReader.getRepositoryThresholdTypes();
        this.gestore = new IThreshold[this.tipiThreshold.size()];
        Loader loader = Loader.getInstance();
        for (int i = 0; i < this.tipiThreshold.size(); ++i) {
            String tipoClass = ClassNameProperties.getInstance().getThreshold(this.tipiThreshold.get(i));
            if (tipoClass == null) {
                throw new ThresholdException("Riscontrato errore durante l'istanziazione del threshold di tipo [" + this.tipiThreshold.get(i) + "]: is null");
            }
            try {
                this.gestore[i] = (IThreshold)loader.newInstance(tipoClass);
                this.gestore[i].toString();
                continue;
            }
            catch (Exception e) {
                throw new ThresholdException("Riscontrato errore durante l'istanziazione del threshold di tipo [" + this.tipiThreshold.get(i) + "]: " + e.getMessage());
            }
        }
    }

    public void process() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String sec = "secondi";
            if (this.propertiesReader.getRepositoryThresholdCheckInterval() == 1L) {
                sec = "secondo";
            }
            this.msgDiag.addKeyword("@TIMEOUT@", this.propertiesReader.getRepositoryThresholdCheckInterval() + " " + sec);
            this.msgDiag.logPersonalizzato("avvioEffettuato");
            while (!this.isStop()) {
                if (OpenSPCoop2Startup.contextDestroyed) {
                    this.log.error("[GestoreThreshold] Rilevato sistema in shutdown");
                    return;
                }
                if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
                    this.log.error("[GestoreThreshold] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
                    this.sleepForNextCheck((int)this.propertiesReader.getRepositoryThresholdCheckInterval(), 1000);
                    continue;
                }
                if (TimerState.ENABLED.equals((Object)STATE)) {
                    boolean checkThreshold = true;
                    for (int i = 0; i < this.tipiThreshold.size(); ++i) {
                        this.log.debug("Verifica '" + this.tipiThreshold.get(i) + "' in corso ...");
                        this.msgDiag.addKeyword("@TIPO_THRESHOLD@", this.tipiThreshold.get(i));
                        this.msgDiag.logPersonalizzato("controlloInCorso");
                        try {
                            checkThreshold = this.gestore[i].check(this.propertiesReader.getRepositoryThresholdParameters(this.tipiThreshold.get(i)));
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "checkThreshold(" + this.tipiThreshold.get(i) + ")");
                            this.log.debug("Controllo threshould non riuscito (tipo:" + this.tipiThreshold.get(i) + ")", (Throwable)e);
                            checkThreshold = false;
                        }
                        this.log.debug("Verifica '" + this.tipiThreshold.get(i) + "' completato con esito " + (checkThreshold ? "ok" : "ko"));
                        if (!checkThreshold) break;
                    }
                    if (!checkThreshold && this.lastCheck) {
                        this.msgDiag.logPersonalizzato("risorsaNonDisponibile");
                    } else if (checkThreshold && !this.lastCheck) {
                        this.msgDiag.logPersonalizzato("risorsaRitornataDisponibile");
                    }
                    this.lastCheck = checkThreshold;
                    freeSpace = checkThreshold;
                } else {
                    this.log.info("Timer GestoreThreshold disabilitato");
                }
                this.sleepForNextCheck((int)this.propertiesReader.getRepositoryThresholdCheckInterval(), 1000);
            }
        }
        finally {
            this.finished();
        }
    }
}

