/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.pdnd;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProviderDriverUtils;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.keystore.cache.RemoteStoreCache;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class TimerGestoreCacheChiaviPDNDLib {
    private static TimerState state = TimerState.OFF;
    private OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
    private String tipoDatabase = this.op2Properties.getDatabaseType();
    private Logger logCore = null;
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private RemoteStoreConfig remoteStore;
    private RemoteKeyType remoteKeyType;

    public static TimerState getState() {
        return state;
    }

    public static void setState(TimerState stateParam) {
        state = stateParam;
    }

    private void logCoreInfo(String msg) {
        if (this.logCore != null) {
            this.logCore.info(msg);
        }
    }

    private void logTimerError(String msgErrore, Throwable e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, e);
        }
    }

    private void logTimerError(String msgErrore) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore);
        }
    }

    private void logTimerInfo(String msg) {
        if (this.logTimer != null) {
            this.logTimer.info(msg);
        }
    }

    private void logTimerDebug(String msg) {
        if (this.logTimer != null) {
            this.logTimer.debug(msg);
        }
    }

    public TimerGestoreCacheChiaviPDNDLib(Logger logTimer, MsgDiagnostico msgDiag, RemoteStoreConfig remoteStore, RemoteKeyType remoteKeyType) throws TimerException {
        if (this.tipoDatabase == null) {
            throw new TimerException("Tipo Database non definito");
        }
        boolean debug = this.op2Properties.isGestoreChiaviPDNDDebug();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopGestoreChiaviPDND(debug);
        this.logTimer = logTimer;
        this.msgDiag = msgDiag;
        this.remoteStore = remoteStore;
        this.remoteKeyType = remoteKeyType;
    }

    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimerError("[TimerGestoreCacheChiaviPDND] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimerError(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimerError("[TimerGestoreCacheChiaviPDND] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimerError("[TimerGestoreCacheChiaviPDND] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        boolean enabled = TimerState.ENABLED.equals((Object)state);
        if (!enabled) {
            this.msgDiag.addKeyword("@ID_REMOTE_STORE@", "-");
            this.emitDiagnosticLog("disabilitato");
            return;
        }
        this.emitDiagnosticLog("letturaCacheKeys");
        long startControlloTimer = DateManager.getTimeMillis();
        long idStore = -1L;
        DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection = null;
        try {
            IDriverConfigurazioneGet oConfig = ConfigurazionePdDReader.getDriverConfigurazionePdD();
            if (!(oConfig instanceof DriverConfigurazioneDB)) {
                throw new TimerException("Gestore utilizzabile solamente con una configurazione su database");
            }
            driverConfigurazioneDbGestoreConnection = (DriverConfigurazioneDB)oConfig;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreCacheChiaviPDND");
            this.logTimerError("Riscontrato errore durante la gestione della cache delle chavi della PDND: " + e.getMessage(), e);
            return;
        }
        idStore = this.getIdStore(driverConfigurazioneDbGestoreConnection);
        if (idStore <= 0L) {
            this.emitDiagnosticLog("letturaCacheKeys.nonNecessaria");
            return;
        }
        try {
            this.process(startControlloTimer, idStore, driverConfigurazioneDbGestoreConnection);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreCacheChiaviPDND");
            this.logTimerError("Riscontrato errore durante la gestione della cache delle chavi della PDND: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIdStore(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection) {
        Connection conConfigurazione = null;
        String method = "TimerGestoreCacheChiaviPDND.getIdStore";
        try {
            conConfigurazione = driverConfigurazioneDbGestoreConnection.getConnection(method);
            if (conConfigurazione == null) {
                throw new TimerException("Connessione al database della configurazione non disponibile");
            }
            long l = RemoteStoreProviderDriverUtils.getIdRemoteStore(conConfigurazione, this.tipoDatabase, this.remoteStore);
            return l;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreCacheChiaviPDND");
            this.logTimerError("Riscontrato errore durante la gestione della cache delle chavi della PDND (read idStore): " + e.getMessage(), e);
            long l = -1L;
            return l;
        }
        finally {
            try {
                if (conConfigurazione != null) {
                    driverConfigurazioneDbGestoreConnection.releaseConnection(method, conConfigurazione);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void process(long startControlloTimer, long idStore, DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection) throws SecurityException, CoreException, TimerException {
        List keys = GestoreKeystoreCache.keysRemoteStore();
        int sizeCacheKeys = keys != null ? keys.size() : 0;
        int size = 0;
        if (sizeCacheKeys > 0) {
            for (String key : keys) {
                String keyCachePrefix = "RemoteStore " + RemoteStoreCache.getPrefixKeyCache((RemoteStoreConfig)this.remoteStore, (RemoteKeyType)this.remoteKeyType);
                if (key == null || !key.startsWith(keyCachePrefix) || key.length() <= keyCachePrefix.length()) continue;
                ++size;
                String kid = key.substring(keyCachePrefix.length());
                if (this.existsRemoteStoreKey(driverConfigurazioneDbGestoreConnection, idStore, kid)) continue;
                this.removeFromCache(key, kid);
            }
        }
        long endGenerazione = DateManager.getTimeMillis();
        String tempoImpiegato = Utilities.convertSystemTimeIntoStringMillisecondi((long)(endGenerazione - startControlloTimer), (boolean)true);
        this.msgDiag.addKeyword("@TEMPO_GESTIONE@", tempoImpiegato);
        this.msgDiag.addKeyword("@NUMERO_EVENTI@", "" + size);
        this.emitDiagnosticLog("letturaCacheKeys.effettuata");
    }

    private boolean existsRemoteStoreKey(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, long idStore, String kid) throws TimerException {
        Connection conConfigurazione = null;
        String method = "TimerGestoreCacheChiaviPDND.existsRemoteStoreKey_" + idStore + "_" + kid;
        try {
            conConfigurazione = driverConfigurazioneDbGestoreConnection.getConnection(method);
            if (conConfigurazione == null) {
                throw new TimerException("Connessione al database della configurazione non disponibile");
            }
            boolean bl = RemoteStoreProviderDriverUtils.existsRemoteStoreKey(conConfigurazione, this.tipoDatabase, idStore, kid, true);
            return bl;
        }
        catch (Exception e) {
            throw new TimerException("existsRemoteStoreKey failed: " + e.getMessage());
        }
        finally {
            try {
                if (conConfigurazione != null) {
                    driverConfigurazioneDbGestoreConnection.releaseConnection(method, conConfigurazione);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void removeFromCache(String key, String kid) throws SecurityException, CoreException {
        this.logTimerDebug("Elimino chiave '" + key + "' dalla cache");
        GestoreKeystoreCache.removeRemoteStore(null, (String)kid, (RemoteKeyType)this.remoteKeyType, (RemoteStoreConfig)this.remoteStore);
        if (this.op2Properties.isGestoreChiaviPDNDclientInfoEnabled()) {
            GestoreKeystoreCache.removeRemoteStoreClientInfo(null, (String)kid, (RemoteStoreConfig)this.remoteStore);
        }
    }

    private void emitDiagnosticLog(String code) {
        this.msgDiag.logPersonalizzato(code);
        String msg = this.msgDiag.getMessaggio_replaceKeywords(code);
        this.logCoreInfo(msg);
        this.logTimerInfo(msg);
    }
}

