/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.pdnd;

import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.core.eventi.constants.TipoSeverita;
import org.openspcoop2.core.eventi.utils.SeveritaConverter;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.eventi.GestoreEventi;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.core.keystore.RemoteStore;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProviderDriverUtils;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.pdd.timers.pdnd.TimerGestoreChiaviPDNDEvent;
import org.openspcoop2.pdd.timers.pdnd.TimerGestoreChiaviPDNDEvents;
import org.openspcoop2.pdd.timers.pdnd.TimerGestoreChiaviPDNDUtilities;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class TimerGestoreChiaviPDNDLib {
    private static TimerState state = TimerState.OFF;
    private OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
    private String tipoDatabase = this.op2Properties.getDatabaseType();
    private Logger logCore = null;
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private RemoteStoreConfig remoteStore;
    private String urlCheckEventi;
    private String parameterLastEventId;
    private String parameterLastEventIdFirstValue;
    private String parameterLimit;
    private int limit;
    private int timeoutSeconds = -1;
    private TimerLock timerLock = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphoreStatistics;
    private String lastEventId = null;
    private RemoteStore remoteStoreDbImage = null;
    public static final String TIPO_EVENTO_ADD = "Add";
    private static final String TIPO_EVENTO_DELETED = "Delete";
    private static final String TIPO_EVENTO_UPDATED = "Update";

    public static TimerState getState() {
        return state;
    }

    public static void setState(TimerState stateParam) {
        state = stateParam;
    }

    private void logCoreInfo(String msg) {
        if (this.logCore != null) {
            this.logCore.info(msg);
        }
    }

    private void logCoreError(String msgErrore, Throwable e) {
        if (this.logCore != null) {
            this.logCore.error(msgErrore, e);
        }
    }

    private void logTimerError(String msgErrore, Throwable e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, e);
        }
    }

    private void logTimerError(String msgErrore) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore);
        }
    }

    private void logTimerInfo(String msg) {
        if (this.logTimer != null) {
            this.logTimer.info(msg);
        }
    }

    private void logTimerInfo(String msg, Exception e) {
        if (this.logTimer != null) {
            this.logTimer.info(msg, (Throwable)e);
        }
    }

    public TimerGestoreChiaviPDNDLib(Logger logTimer, MsgDiagnostico msgDiag, RemoteStoreConfig remoteStore, String urlCheckEventi, int timeoutSeconds) throws TimerException {
        if (this.tipoDatabase == null) {
            throw new TimerException("Tipo Database non definito");
        }
        boolean debug = this.op2Properties.isGestoreChiaviPDNDDebug();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopGestoreChiaviPDND(debug);
        this.logTimer = logTimer;
        this.msgDiag = msgDiag;
        this.remoteStore = remoteStore;
        this.urlCheckEventi = urlCheckEventi;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.parameterLastEventId = ModIUtils.extractInfoFromMetadati((Map)this.remoteStore.getMetadati(), (String)"api-pdnd-eventsKeys-parameterLastEventId", (String)"Events keys last eventid parameter");
            this.lastEventId = this.parameterLastEventIdFirstValue = ModIUtils.extractInfoFromMetadati((Map)this.remoteStore.getMetadati(), (String)"api-pdnd-eventsKeys-parameterLastEventIdFirstValue", (String)"Events keys last eventid initial parameter value", (boolean)true);
            this.parameterLimit = ModIUtils.extractInfoFromMetadati((Map)this.remoteStore.getMetadati(), (String)"api-pdnd-eventsKeys-parameterLimit", (String)"Events keys limit parameter");
            this.limit = this.op2Properties.getGestoreChiaviPDNDeventsKeysLimit();
        }
        catch (Exception e) {
            throw new TimerException(e.getMessage(), e);
        }
        this.timerLock = new TimerLock(TipoLock.GESTORE_CHIAVI_PDND);
        if (this.op2Properties.isTimerLockByDatabase()) {
            this.semaphoreStatistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.op2Properties.getGestoreChiaviPDNDTimerLockMaxLife(), this.op2Properties.getGestoreChiaviPDNDTimerLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.tipoDatabase);
            try {
                this.semaphore = new Semaphore(this.semaphoreStatistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.logTimer);
            }
            catch (Exception e) {
                throw new TimerException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimerError("[TimerGestoreChiaviPDND] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimerError(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimerError("[TimerGestoreChiaviPDND] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimerError("[TimerGestoreChiaviPDND] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        boolean enabled = TimerState.ENABLED.equals((Object)state);
        if (!enabled) {
            this.msgDiag.addKeyword("@ID_REMOTE_STORE@", "-");
            this.emitDiagnosticLog("disabilitato");
            return;
        }
        this.emitDiagnosticLog("letturaEventi");
        long startControlloTimer = DateManager.getTimeMillis();
        DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection = null;
        try {
            IDriverConfigurazioneGet oConfig = ConfigurazionePdDReader.getDriverConfigurazionePdD();
            if (!(oConfig instanceof DriverConfigurazioneDB)) {
                throw new TimerException("Gestore utilizzabile solamente con una configurazione su database");
            }
            driverConfigurazioneDbGestoreConnection = (DriverConfigurazioneDB)oConfig;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreChiaviPDND");
            this.logTimerError("Riscontrato errore durante la gestione eventi per le chiavi della PDND: " + e.getMessage(), e);
            return;
        }
        try {
            String causa = "Gestione chiavi PDND";
            try {
                this.acquireLock(driverConfigurazioneDbGestoreConnection, causa);
                this.process(driverConfigurazioneDbGestoreConnection);
            }
            finally {
                this.releaseSafeLock(driverConfigurazioneDbGestoreConnection, causa);
            }
            long endControlloTimer = DateManager.getTimeMillis();
            long diff = endControlloTimer - startControlloTimer;
            this.logTimerInfo("Gestione eventi per le chiavi della PDND terminata in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
        }
        catch (TimerLockNotAvailableException t) {
            this.logTimerInfo(t.getMessage(), t);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreChiaviPDND");
            this.logTimerError("Riscontrato errore durante la gestione eventi per le chiavi della PDND: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, String causa) throws DriverConfigurazioneException, TimerException, UtilsException, TimerLockNotAvailableException {
        Connection conConfigurazione = null;
        String method = "TimerGestoreChiaviPDND.acquireLock";
        try {
            conConfigurazione = driverConfigurazioneDbGestoreConnection.getConnection(method);
            if (conConfigurazione == null) {
                throw new TimerException("Connessione al database della configurazione non disponibile");
            }
            GestoreMessaggi.acquireLock(this.semaphore, conConfigurazione, this.timerLock, this.msgDiag, causa, this.op2Properties.getGestoreChiaviPDNDTimerLockAttesaAttiva(), this.op2Properties.getGestoreChiaviPDNDTimerLockCheckInterval());
        }
        finally {
            try {
                if (conConfigurazione != null) {
                    driverConfigurazioneDbGestoreConnection.releaseConnection(method, conConfigurazione);
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSafeLock(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, String causa) {
        Connection conConfigurazione = null;
        String method = "TimerGestoreChiaviPDND.releaseSafeLock";
        try {
            conConfigurazione = driverConfigurazioneDbGestoreConnection.getConnection(method);
            if (conConfigurazione == null) {
                throw new TimerException("Connessione al database della configurazione non disponibile");
            }
            GestoreMessaggi.releaseSafeLock(this.semaphore, conConfigurazione, this.timerLock, this.msgDiag, causa);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreChiaviPDND");
        }
        finally {
            try {
                if (conConfigurazione != null) {
                    driverConfigurazioneDbGestoreConnection.releaseConnection(method, conConfigurazione);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void process(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection) throws KeystoreException {
        boolean created = this.readRemoteStoreDbImage(driverConfigurazioneDbGestoreConnection);
        TimerGestoreChiaviPDNDUtilities pdndUtilities = new TimerGestoreChiaviPDNDUtilities(this.remoteStore, this.urlCheckEventi, this.parameterLastEventId, this.parameterLimit, this.limit);
        this.msgDiag.addKeyword("@LIMIT@", "" + this.limit);
        boolean updateLasteEventId = false;
        if (created || this.remoteStoreDbImage.getLastEvent() == null) {
            updateLasteEventId = this.initialize(driverConfigurazioneDbGestoreConnection, pdndUtilities);
        } else {
            String lastEventIdDbImage;
            int msTimeout;
            long now = DateManager.getTimeMillis();
            Date check = new Date(now - (long)(msTimeout = this.timeoutSeconds * 1000));
            if (check.before(this.remoteStoreDbImage.getDataAggiornamento())) {
                this.emitDiagnosticLog("letturaEventi.nonNecessaria");
                return;
            }
            this.lastEventId = lastEventIdDbImage = this.remoteStoreDbImage.getLastEvent();
            int letti = 1;
            String prec = null;
            while (letti > 0) {
                prec = this.lastEventId;
                letti = this.gestione(driverConfigurazioneDbGestoreConnection, pdndUtilities, true);
                if (this.lastEventId == null || !this.lastEventId.equals(prec)) continue;
            }
            if (!lastEventIdDbImage.equals(this.lastEventId)) {
                updateLasteEventId = true;
            }
        }
        if (updateLasteEventId) {
            this.updateRemoteStore(driverConfigurazioneDbGestoreConnection, this.remoteStoreDbImage.getId(), this.lastEventId);
        }
    }

    private boolean initialize(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, TimerGestoreChiaviPDNDUtilities pdndUtilities) {
        boolean updateLasteEventId;
        block5: {
            updateLasteEventId = false;
            this.emitDiagnosticLog("inizializzazione.inCorso");
            try {
                int letti = 1;
                String prec = null;
                while (letti > 0) {
                    prec = this.lastEventId;
                    letti = this.gestione(driverConfigurazioneDbGestoreConnection, pdndUtilities, false);
                    if (this.lastEventId == null || !this.lastEventId.equals(prec)) continue;
                }
                if (letti == -1) {
                    throw new TimerException("Recupero eventi dalla PDND non riuscito");
                }
                this.msgDiag.addKeyword("@OFFSET@", this.lastEventId);
                this.emitDiagnosticLog("inizializzazione.effettuata");
                updateLasteEventId = true;
            }
            catch (Exception e) {
                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                this.emitDiagnosticLog("inizializzazione.fallita");
                if (this.logCore != null) {
                    this.logCore.error("Inizializzazione timer chiavi PDND fallita: " + e.getMessage(), (Throwable)e);
                }
                if (this.logTimer == null) break block5;
                this.logTimer.error("Inizializzazione timer chiavi PDND fallita: " + e.getMessage(), (Throwable)e);
            }
        }
        return updateLasteEventId;
    }

    private boolean readRemoteStoreDbImage(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection) throws KeystoreException {
        Connection conConfigurazione = null;
        String method = "TimerGestoreChiaviPDND.readRemoteStoreDbImage";
        try {
            conConfigurazione = driverConfigurazioneDbGestoreConnection.getConnection(method);
            if (conConfigurazione == null) {
                throw new TimerException("Connessione al database della configurazione non disponibile");
            }
            boolean bl = this.readRemoteStoreDbImage(conConfigurazione);
            return bl;
        }
        catch (Exception e) {
            throw new KeystoreException("readRemoteStoreDbImage failed: " + e.getMessage());
        }
        finally {
            try {
                if (conConfigurazione != null) {
                    driverConfigurazioneDbGestoreConnection.releaseConnection(method, conConfigurazione);
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean readRemoteStoreDbImage(Connection conConfigurazione) throws KeystoreException {
        this.remoteStoreDbImage = RemoteStoreProviderDriverUtils.getRemoteStore(conConfigurazione, this.tipoDatabase, this.remoteStore, false);
        boolean created = false;
        if (this.remoteStoreDbImage == null) {
            block4: {
                try {
                    RemoteStoreProviderDriverUtils.createRemoteStore(conConfigurazione, this.tipoDatabase, this.remoteStore);
                    created = true;
                }
                catch (KeystoreException e) {
                    this.remoteStoreDbImage = RemoteStoreProviderDriverUtils.getRemoteStore(conConfigurazione, this.tipoDatabase, this.remoteStore, false);
                    if (this.remoteStoreDbImage != null) break block4;
                    throw e;
                }
            }
            if (this.remoteStoreDbImage == null) {
                this.remoteStoreDbImage = RemoteStoreProviderDriverUtils.getRemoteStore(conConfigurazione, this.tipoDatabase, this.remoteStore, true);
            }
        }
        return created;
    }

    private String getEventPrefix(TimerGestoreChiaviPDNDEvent event) {
        return "Evento '" + event.getEventId() + "' ";
    }

    private int gestione(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, TimerGestoreChiaviPDNDUtilities pdndUtilities, boolean gestioneEvento) {
        try {
            long startGenerazione = DateManager.getTimeMillis();
            int letti = 0;
            this.msgDiag.addKeyword("@OFFSET@", this.lastEventId);
            this.emitDiagnosticLog("gestioneEventi.inCorso");
            TimerGestoreChiaviPDNDEvents events = pdndUtilities.readNextEvents(this.lastEventId);
            letti = events == null || events.getEvents() == null || events.getEvents().isEmpty() ? 0 : events.getEvents().size();
            this.msgDiag.addKeyword("@NUMERO_EVENTI@", "" + letti);
            this.emitDiagnosticLog("gestioneEventi.analisi");
            if (letti > 0) {
                for (TimerGestoreChiaviPDNDEvent event : events.getEvents()) {
                    if (!event.getEventId().equals(this.lastEventId)) {
                        this.lastEventId = event.getEventId();
                        if (!gestioneEvento) continue;
                        this.gestioneEvento(driverConfigurazioneDbGestoreConnection, event);
                        continue;
                    }
                    this.emitLog(this.getEventPrefix(event) + "con un identificativo uguale all'ultimo evento gestito '" + this.lastEventId + "' (tipo di operazione: '" + event.getObjectType() + "'; tipo di evento: '" + event.getEventType() + "')");
                }
            }
            long endGenerazione = DateManager.getTimeMillis();
            String tempoImpiegato = Utilities.convertSystemTimeIntoStringMillisecondi((long)(endGenerazione - startGenerazione), (boolean)true);
            this.msgDiag.addKeyword("@TEMPO_GESTIONE@", tempoImpiegato);
            this.emitDiagnosticLog("gestioneEventi.effettuata");
            return letti;
        }
        catch (Exception e) {
            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
            this.emitDiagnosticLog("gestioneEventi.fallita");
            return -1;
        }
    }

    private void gestioneEvento(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, TimerGestoreChiaviPDNDEvent event) throws KeystoreException, TimerException {
        boolean updateDeleteKeyV1 = "KEY".equals(event.getObjectType()) && ("DELETED".equals(event.getEventType()) || "UPDATED".equals(event.getEventType()));
        boolean deleteKeyV2 = "CLIENT_KEY_DELETED".equals(event.getEventType());
        if (updateDeleteKeyV1 || deleteKeyV2) {
            this.gestioneEventoProcess(driverConfigurazioneDbGestoreConnection, event);
        } else if ("KEY".equals(event.getObjectType()) || event.getKid() != null) {
            this.emitLog(this.getEventPrefix(event) + "relativo ad una chiave; tipo di evento '" + event.getEventType() + "' ignorato");
        } else if (event.getObjectType() == null) {
            this.emitLog(this.getEventPrefix(event) + "relativo ad un tipo di evento '" + event.getEventType() + "' non gestito");
        } else {
            this.emitLog(this.getEventPrefix(event) + "relativo ad un tipo di operazione '" + event.getObjectType() + "' non gestita; (tipo di evento '" + event.getEventType() + "')");
        }
    }

    private void gestioneEventoProcess(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, TimerGestoreChiaviPDNDEvent event) throws KeystoreException, TimerException {
        this.msgDiag.addKeyword("@ID_EVENTO@", event.getEventId());
        this.msgDiag.addKeyword("@TIPO_EVENTO@", event.getEventType());
        String kid = null;
        if (event.getKid() != null) {
            kid = event.getKid();
            this.msgDiag.addKeyword("@DETTAGLI_EVENTO@", kid);
        } else if (event.getObjectId() != null) {
            String details = event.getObjectId().toString();
            this.msgDiag.addKeyword("@DETTAGLI_EVENTO@", details);
            kid = event.getObjectId().get("kid");
        } else {
            String details = "object id undefined";
            this.msgDiag.addKeyword("@DETTAGLI_EVENTO@", details);
        }
        if (kid != null) {
            this.gestioneEvento(driverConfigurazioneDbGestoreConnection, event, kid);
        }
        this.emitDiagnosticLog("gestioneEventi.evento");
    }

    private void gestioneEvento(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, TimerGestoreChiaviPDNDEvent event, String kid) throws KeystoreException, TimerException {
        Connection conConfigurazione = null;
        String method = "TimerGestoreChiaviPDND.gestioneEvento_" + kid;
        try {
            conConfigurazione = driverConfigurazioneDbGestoreConnection.getConnection(method);
            if (conConfigurazione == null) {
                throw new TimerException("Connessione al database della configurazione non disponibile");
            }
            this.gestioneEvento(conConfigurazione, event, kid);
        }
        catch (Exception e) {
            throw new KeystoreException("gestioneEvento failed: " + e.getMessage());
        }
        finally {
            try {
                if (conConfigurazione != null) {
                    driverConfigurazioneDbGestoreConnection.releaseConnection(method, conConfigurazione);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void gestioneEvento(Connection conConfigurazione, TimerGestoreChiaviPDNDEvent event, String kid) throws KeystoreException, TimerException {
        Evento evento = null;
        if ("DELETED".equals(event.getEventType()) || "CLIENT_KEY_DELETED".equals(event.getEventType())) {
            int deleted = RemoteStoreProviderDriverUtils.deleteRemoteStoreKey(conConfigurazione, this.tipoDatabase, this.remoteStoreDbImage.getId(), kid);
            if (deleted > 0 && this.op2Properties.isGestoreChiaviPDNDEventiDelete()) {
                evento = TimerGestoreChiaviPDNDLib.buildEvento(event.getEventType(), kid, "La chiave \u00e8 stata eliminata dal repository locale");
            }
        } else {
            int updated = RemoteStoreProviderDriverUtils.invalidRemoteStoreKey(conConfigurazione, this.tipoDatabase, this.remoteStoreDbImage.getId(), kid);
            if (updated > 0 && this.op2Properties.isGestoreChiaviPDNDEventiUpdate()) {
                evento = TimerGestoreChiaviPDNDLib.buildEvento(event.getEventType(), kid, "La chiave \u00e8 stata invalidata sul repository locale");
            }
        }
        if (evento != null) {
            try {
                GestoreEventi.getInstance().log(evento);
            }
            catch (Exception e) {
                String msgError = "Registrazione evento per kid '" + kid + "' (eventType:" + event.getEventType() + ") non riuscita: " + e.getMessage();
                this.logCoreError(msgError, e);
                this.logTimerError(msgError, e);
            }
        }
    }

    private void updateRemoteStore(DriverConfigurazioneDB driverConfigurazioneDbGestoreConnection, long idStore, String lastEventId) throws KeystoreException {
        Connection conConfigurazione = null;
        String method = "TimerGestoreChiaviPDND.updateRemoteStore_" + idStore + "_" + lastEventId;
        try {
            conConfigurazione = driverConfigurazioneDbGestoreConnection.getConnection(method);
            if (conConfigurazione == null) {
                throw new TimerException("Connessione al database della configurazione non disponibile");
            }
            RemoteStoreProviderDriverUtils.updateRemoteStore(conConfigurazione, this.tipoDatabase, this.remoteStoreDbImage.getId(), this.lastEventId);
        }
        catch (Exception e) {
            throw new KeystoreException("updateRemoteStore failed: " + e.getMessage());
        }
        finally {
            try {
                if (conConfigurazione != null) {
                    driverConfigurazioneDbGestoreConnection.releaseConnection(method, conConfigurazione);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void emitDiagnosticLog(String code) {
        this.msgDiag.logPersonalizzato(code);
        String msg = this.msgDiag.getMessaggio_replaceKeywords(code);
        this.emitLog(msg);
    }

    private void emitLog(String msg) {
        this.logCoreInfo(msg);
        this.logTimerInfo(msg);
    }

    public static Evento buildEvento(String eventType, String objectDetail, String descrizione) throws TimerException {
        Evento evento = new Evento();
        evento.setTipo("GestioneChiaviPDND");
        if ("ADDED".equals(eventType) || "CLIENT_KEY_ADDED".equals(eventType) || TIPO_EVENTO_ADD.equals(eventType)) {
            evento.setCodice(TIPO_EVENTO_ADD);
        } else if ("UPDATED".equals(eventType)) {
            evento.setCodice(TIPO_EVENTO_UPDATED);
        } else if ("DELETED".equals(eventType) || "CLIENT_KEY_DELETED".equals(eventType)) {
            evento.setCodice(TIPO_EVENTO_DELETED);
        } else {
            evento.setCodice(eventType);
        }
        if (objectDetail != null) {
            evento.setIdConfigurazione(objectDetail);
        }
        evento.setDescrizione(descrizione);
        evento.setOraRegistrazione(DateManager.getDate());
        try {
            evento.setSeverita(SeveritaConverter.toIntValue((TipoSeverita)TipoSeverita.INFO));
        }
        catch (Exception e) {
            throw new TimerException(e.getMessage(), e);
        }
        evento.setClusterId(OpenSPCoop2Properties.getInstance().getClusterId(false));
        return evento;
    }
}

