/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.pdnd;

import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.pdnd.TimerGestoreChiaviPDNDEvents;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceUtils;

public class TimerGestoreChiaviPDNDUtilities {
    private RemoteStoreConfig remoteStore;
    private String urlCheckEventi;
    private String parameterLastEventId;
    private String parameterLimit;
    private int limit;

    public TimerGestoreChiaviPDNDUtilities(RemoteStoreConfig remoteStore, String urlCheckEventi, String parameterLastEventId, String parameterLimit, int limit) {
        this.remoteStore = remoteStore;
        this.urlCheckEventi = urlCheckEventi;
        this.parameterLastEventId = parameterLastEventId;
        this.parameterLimit = parameterLimit;
        this.limit = limit;
    }

    public TimerGestoreChiaviPDNDEvents readNextEvents(String lastEventId) throws TimerException {
        String responseJson = null;
        try {
            StringBuilder sb = new StringBuilder(this.urlCheckEventi).append("?");
            if (lastEventId != null && StringUtils.isNotEmpty((CharSequence)lastEventId)) {
                sb.append(this.parameterLastEventId).append("=").append(lastEventId);
                sb.append("&");
            }
            sb.append(this.parameterLimit).append("=").append(this.limit);
            String url = sb.toString();
            byte[] response = ExternalResourceUtils.readResource((String)url, (ExternalResourceConfig)this.remoteStore);
            responseJson = new String(response);
        }
        catch (Exception e) {
            throw new TimerException(e.getMessage(), e);
        }
        try {
            return TimerGestoreChiaviPDNDEvents.toEvents(responseJson);
        }
        catch (Exception e) {
            throw new TimerException("Uncorrect json format (" + responseJson + "): " + e.getMessage(), e);
        }
    }
}

