/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.proxy;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.connector.proxy.IProxyOperationService;
import org.openspcoop2.pdd.services.connector.proxy.ProxyOperationServiceFactory;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.proxy.TimerGestoreOperazioniRemoteLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerGestoreOperazioniRemote
extends BaseThread {
    public static final String ID_MODULO = "TimerGestoreOperazioniRemote";
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private OpenSPCoop2Properties op2Properties = null;
    private Date dataUltimoAggiornamento = null;
    private String urlPrefix;
    private IProxyOperationService proxyOperationService = null;

    private void logError(String msgErrore, Exception e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, (Throwable)e);
        }
    }

    public TimerGestoreOperazioniRemote(long timeout) throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreOperazioniAsincrone.");
            this.msgDiag.addKeyword("@ID_TIMER@", ID_MODULO);
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.op2Properties = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        String className = this.op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerServiceImplClass();
        try {
            this.proxyOperationService = ProxyOperationServiceFactory.newInstance(className, this.logTimer);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer-ProxyOperationService");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del ProxyOperationService: " + e.getMessage();
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.urlPrefix = TimerGestoreOperazioniRemote.buildUlrPrefix(this.op2Properties);
        this.dataUltimoAggiornamento = DateManager.getDate();
        this.setTimeout((int)timeout);
        String sec = "secondi";
        if (this.getTimeout() == 1) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    private static String buildUlrPrefix(OpenSPCoop2Properties op2Properties) {
        Integer portHostname;
        String protocolSchema = op2Properties.getProxyReadJMXResourcesSchema();
        String tmp = op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerSchema();
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp)) {
            protocolSchema = tmp;
        }
        String protocol = protocolSchema != null && protocolSchema.trim().toLowerCase().startsWith("https") ? "https://" : "http://";
        String hostnameAsync = op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerHostname();
        if (hostnameAsync == null || StringUtils.isEmpty((CharSequence)hostnameAsync)) {
            hostnameAsync = "localhost";
        }
        int port = 8080;
        if (op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerPort() != null && op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerPort() > 0) {
            port = op2Properties.getProxyReadJMXResourcesAsyncProcessByTimerPort();
        } else if (op2Properties.getProxyReadJMXResourcesPort() != null && op2Properties.getProxyReadJMXResourcesPort() > 0) {
            port = op2Properties.getProxyReadJMXResourcesPort();
        }
        String hostnameLocale = op2Properties.getClusterHostname();
        if (hostnameLocale != null && (portHostname = op2Properties.getProxyReadJMXResourcesPort(hostnameLocale)) != null && portHostname > 0) {
            port = portHostname;
        }
        return protocol + hostnameAsync + ":" + port;
    }

    public void process() {
        try {
            this.msgDiag.addKeyword("@DATA_AGGIORNAMENTO@", DateUtils.getSimpleDateFormatMs().format(this.dataUltimoAggiornamento));
            Date now = DateManager.getDate();
            TimerGestoreOperazioniRemoteLib timer = new TimerGestoreOperazioniRemoteLib(this.logTimer, this.msgDiag, this.proxyOperationService, now, this.dataUltimoAggiornamento, this.urlPrefix);
            timer.check();
            this.dataUltimoAggiornamento = now;
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreOperazioniRemote.check()");
            this.logError("Errore generale: " + e.getMessage(), e);
        }
    }
}

