/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.ctrlstat.config.RegistroServiziRemotoInstanceProperties;
import org.slf4j.Logger;

public class RegistroServiziRemotoProperties {
    private Logger log = null;
    private RegistroServiziRemotoInstanceProperties reader;
    private static RegistroServiziRemotoProperties registroServiziRemotoProperties = null;

    private RegistroServiziRemotoProperties(String confDir, String confPropertyName, String confLocalPathPrefix, Logger log) throws Exception {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(RegistroServiziRemotoProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = RegistroServiziRemotoProperties.class.getResourceAsStream("/console.registroServiziRemoto.properties");
            if (properties == null) {
                throw new Exception("File '/console.registroServiziRemoto.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'console.registroServiziRemoto.properties': \n\n" + e.getMessage());
            throw new Exception("ConsoleProperties initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new RegistroServiziRemotoInstanceProperties(propertiesReader, this.log, confDir, confPropertyName, confLocalPathPrefix);
    }

    public static boolean initialize(String confDir, String confPropertyName, String confLocalPathPrefix, Logger log) {
        try {
            registroServiziRemotoProperties = new RegistroServiziRemotoProperties(confDir, confPropertyName, confLocalPathPrefix, log);
            return true;
        }
        catch (Exception e) {
            log.error("Inizializzazione fallita: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static RegistroServiziRemotoProperties getInstance() throws OpenSPCoop2ConfigurationException {
        if (registroServiziRemotoProperties == null) {
            Class<RegistroServiziRemotoProperties> clazz = RegistroServiziRemotoProperties.class;
            synchronized (RegistroServiziRemotoProperties.class) {
                throw new OpenSPCoop2ConfigurationException("DatasourceProperties non inizializzato");
            }
        }
        return registroServiziRemotoProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        RegistroServiziRemotoProperties.registroServiziRemotoProperties.reader.setLocalObjectImplementation(prop);
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    public String getTipoRegistroServiziRemoto() throws UtilsException {
        return this.readProperty(true, "registroServizi.tipo");
    }

    public String getRegistroServiziXML_Location() throws UtilsException {
        return this.readProperty(CostantiConfigurazione.REGISTRO_XML.equals(this.getTipoRegistroServiziRemoto()), "registroServizi.xml.location");
    }

    public String getRegistroServiziDB_DataSource() throws UtilsException {
        return this.readProperty(CostantiConfigurazione.REGISTRO_DB.equals(this.getTipoRegistroServiziRemoto()), "registroServizi.db.dataSource");
    }

    public Properties getRegistroServiziDB_DataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("registroServizi.db.context.");
    }

    public String getRegistroServiziDB_TipoDatabase() throws UtilsException {
        return this.readProperty(CostantiConfigurazione.REGISTRO_DB.equals(this.getTipoRegistroServiziRemoto()), "registroServizi.db.tipo");
    }
}

