/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.plugins.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedException;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedBean;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedFormServlet;
import org.openspcoop2.web.ctrlstat.plugins.WrapperExtendedBean;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public abstract class AbstractServletNewWindowChangeExtended
extends Action {
    protected abstract ConsoleHelper getConsoleHelper(HttpServletRequest var1, PageData var2, HttpSession var3) throws Exception;

    protected abstract ControlStationCore getConsoleCore() throws Exception;

    protected abstract IExtendedFormServlet getExtendedServlet(ControlStationCore var1, String var2) throws Exception;

    protected abstract List<Parameter> getTitle(Object var1, HttpServletRequest var2, HttpSession var3) throws Exception;

    protected abstract Object getObject(ControlStationCore var1, HttpServletRequest var2) throws Exception;

    protected abstract String getObjectName() throws Exception;

    protected abstract ForwardParams getForwardParams() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConsoleHelper consoleHelper = this.getConsoleHelper(request, pd, session);
            ControlStationCore consoleCore = this.getConsoleCore();
            IExtendedFormServlet extendedServlet = this.getExtendedServlet(consoleCore, consoleHelper.getParameter("extendedFormUniqueId"));
            consoleHelper.makeMenu();
            Object object = this.getObject(consoleCore, request);
            List<Parameter> lstParam = this.getTitle(object, request, session);
            lstParam.add(new Parameter(extendedServlet.getFormTitle(TipoOperazione.CHANGE, consoleHelper), null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            IExtendedBean extendedBean = null;
            DBManager dbManager = null;
            Connection con = null;
            try {
                dbManager = DBManager.getInstance();
                con = dbManager.getConnection();
                extendedBean = extendedServlet.getExtendedBean(con, extendedServlet.getId(request));
            }
            finally {
                if (dbManager != null) {
                    dbManager.releaseConnection(con);
                }
            }
            extendedBean = extendedServlet.readHttpParameters(object, TipoOperazione.CHANGE, extendedBean, request);
            if (!consoleHelper.isEditModeInProgress()) {
                boolean isOk = true;
                try {
                    extendedServlet.checkDati(TipoOperazione.CHANGE, consoleHelper, consoleCore, object, extendedBean);
                }
                catch (Exception e) {
                    isOk = false;
                    pd.setMessage(e.getMessage());
                }
                if (!isOk) {
                    ArrayList<DataElement> dati = new ArrayList<DataElement>();
                    dati.add(ServletUtils.getDataElementForEditModeFinished());
                    DataElement de = new DataElement();
                    de.setValue(extendedServlet.getUniqueID());
                    de.setType(DataElementType.HIDDEN);
                    de.setName("extendedFormUniqueId");
                    dati.add(de);
                    extendedServlet.addToDati(dati, TipoOperazione.CHANGE, consoleHelper, consoleCore, object, extendedBean);
                    pd.setDati(dati);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)this.getObjectName(), (ForwardParams)this.getForwardParams());
                }
                WrapperExtendedBean wrapperExtendedBean = new WrapperExtendedBean();
                wrapperExtendedBean.setExtendedBean(extendedBean);
                wrapperExtendedBean.setExtendedServlet(extendedServlet);
                wrapperExtendedBean.setOriginalBean(object);
                wrapperExtendedBean.setManageOriginalBean(false);
                consoleCore.performUpdateOperation(userLogin, consoleHelper.smista(), wrapperExtendedBean);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                String testModificaEffettuata = extendedServlet.getTestoModificaEffettuata(TipoOperazione.CHANGE, consoleHelper);
                DataElement de = new DataElement();
                de.setValue(extendedServlet.getUniqueID());
                de.setType(DataElementType.HIDDEN);
                de.setName("extendedFormUniqueId");
                dati.add(de);
                extendedServlet.addToDati(dati, TipoOperazione.CHANGE, consoleHelper, consoleCore, object, extendedBean);
                pd.setDati(dati);
                pd.setMessage(testModificaEffettuata, Costanti.MESSAGE_TYPE_INFO);
                pd.disableEditMode();
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)this.getObjectName(), (ForwardParams)this.getForwardParams());
            }
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            DataElement de = new DataElement();
            de.setValue(extendedServlet.getUniqueID());
            de.setType(DataElementType.HIDDEN);
            de.setName("extendedFormUniqueId");
            dati.add(de);
            extendedServlet.addToDati(dati, TipoOperazione.CHANGE, consoleHelper, consoleCore, object, extendedBean);
            pd.setDati(dati);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)this.getObjectName(), (ForwardParams)this.getForwardParams());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)this.getObjectName(), (ForwardParams)this.getForwardParams());
        }
    }

    public static void addToDatiNewWindow(IExtendedFormServlet extendedServlet, List<DataElement> dati, ConsoleHelper consoleHelper, ControlStationCore core, Object originalObject, IExtendedBean extendedBean, String servletName) throws ExtendedException {
        DataElement de = new DataElement();
        de.setValue(extendedServlet.getUniqueID());
        de.setType(DataElementType.HIDDEN);
        de.setName("extendedFormUniqueId");
        dati.add(de);
        Object servletNameWithId = servletName;
        servletNameWithId = ((String)servletNameWithId).contains("?") ? (String)servletNameWithId + "&" : (String)servletNameWithId + "?";
        servletNameWithId = (String)servletNameWithId + "extendedFormUniqueId=" + extendedServlet.getUniqueID();
        extendedServlet.addToDatiNewWindow(dati, consoleHelper, core, originalObject, extendedBean, (String)servletNameWithId);
    }
}

