/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.about;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.IVersionInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TargetType;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.User;

public class AboutHelper
extends ConsoleHelper {
    public AboutHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    private String getSoggettoSelezionatoFromSession() {
        try {
            User userFromSession = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
            if (userFromSession != null) {
                return userFromSession.getSoggettoSelezionatoPddConsole();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<DataElement> addAboutToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String userLogin, BinaryParameter infoBP) throws UtilsException {
        DataElement de;
        IVersionInfo versionInfo;
        block17: {
            versionInfo = null;
            try {
                versionInfo = this.core.getInfoVersion(this.request, this.session);
            }
            catch (Exception e) {
                ControlStationLogger.getPddConsoleCoreLogger().error("Errore durante la lettura delle informazioni sulla versione: " + e.getMessage(), (Throwable)e);
            }
            String soggettoSelezionato = this.getSoggettoSelezionatoFromSession();
            if (versionInfo != null) {
                if (!StringUtils.isEmpty((CharSequence)versionInfo.getErrorMessage(new Object[]{soggettoSelezionato}))) {
                    this.pd.setMessage(versionInfo.getErrorMessage(new Object[]{soggettoSelezionato}), MessageType.ERROR);
                } else if (!StringUtils.isEmpty((CharSequence)versionInfo.getWarningMessage(new Object[]{soggettoSelezionato}))) {
                    this.pd.setMessage(versionInfo.getWarningMessage(new Object[]{soggettoSelezionato}), MessageType.INFO);
                }
            }
            de = new DataElement();
            de.setLabel("Prodotto");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Versione");
            de.setType(DataElementType.TEXT);
            de.setValue(this.core.getProductVersion());
            de.setStyleClass("spanNoEdit16");
            dati.add(de);
            de = new DataElement();
            de.setLabelLink("Sito");
            de.setType(DataElementType.LINK);
            de.setTarget(TargetType.BLANK);
            if (versionInfo != null && !StringUtils.isEmpty((CharSequence)versionInfo.getWebSite(new Object[]{soggettoSelezionato}))) {
                de.setValue(versionInfo.getWebSite(new Object[]{soggettoSelezionato}));
                de.setUrl(versionInfo.getWebSite(new Object[]{soggettoSelezionato}));
            } else {
                de.setValue("https://govway.org");
                de.setUrl("https://govway.org");
            }
            de.setStyleClass("spanNoEdit16");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Copyright");
            de.setType(DataElementType.TEXT);
            if (versionInfo != null && !StringUtils.isEmpty((CharSequence)versionInfo.getCopyright(new Object[]{soggettoSelezionato}))) {
                de.setValue(versionInfo.getCopyright(new Object[]{soggettoSelezionato}));
            } else {
                de.setValue("2005-2026 Link.it srl");
            }
            de.setStyleClass("spanNoEdit16");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Licenza");
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setCols(70);
            if (versionInfo != null) {
                try {
                    String info = versionInfo.getInfo(new Object[]{soggettoSelezionato});
                    String[] split = info.split("\n");
                    de.setValue(info);
                    if (split == null || split.length > 11) {
                        de.setRows(11);
                        break block17;
                    }
                    de.setRows(split.length + 1);
                }
                catch (Exception e) {
                    ControlStationLogger.getPddConsoleCoreLogger().error("Errore durante la lettura delle informazioni della licenza: " + e.getMessage(), (Throwable)e);
                    de.setValue("Errore durante la lettura delle informazioni della licenza");
                    de.setRows(2);
                }
            } else {
                de.setValue("This program is free software: you can redistribute it and/or modify\nit under the terms of the GNU General Public License version 3, as published by\nthe Free Software Foundation.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.");
                de.setRows(11);
            }
        }
        dati.add(de);
        if (versionInfo != null) {
            de = new DataElement();
            de.setLabel("Licenza");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            DataElement deFile = infoBP.getFileDataElement("Licenza", "", this.getSize());
            deFile.setPostBack(false);
            dati.add(deFile);
            dati.addAll(infoBP.getFileNameDataElement());
            dati.add(infoBP.getFileIdDataElement());
            de = new DataElement();
            de.setName("infoFinish");
            de.setType(DataElementType.HIDDEN);
            de.setValue("yes");
            dati.add(de);
            this.pd.setLabelBottoneInvia("Aggiorna Licenza");
        } else {
            this.pd.setMode("view-noeditbutton");
        }
        return dati;
    }
}

