/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ac;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class AccordiCooperazioneHelper
extends ConsoleHelper {
    public AccordiCooperazioneHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public AccordiCooperazioneHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public boolean accordiCooperazioneCheckData(TipoOperazione tipoOp, String nome, String descr, String id, String referente, String versione, boolean visibilitaAccordoCooperazione, IDAccordoCooperazione idAccordoOLD) throws Exception {
        try {
            int idInt = 0;
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                idInt = Integer.parseInt(id);
            }
            if (referente == null) {
                referente = "";
            }
            if (nome == null || nome.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Nome");
                return false;
            }
            if (referente == null || referente.equals("") || referente.equals("-")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Soggetto Referente");
                return false;
            }
            if (versione == null || versione.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare una Versione dell'accordo");
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkNCName(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (descr != null && !"".equals(descr) && !this.checkLength255(descr, "Descrizione")) {
                return false;
            }
            if (!versione.equals("") && !this.checkNumber(versione, "Versione", false)) {
                return false;
            }
            Soggetto sRef = null;
            IDSoggetto idSoggettoReferente = null;
            if (referente != null && !referente.equals("") && !referente.equals("-")) {
                boolean trovatoProv = this.soggettiCore.existsSoggetto(Integer.parseInt(referente));
                if (!trovatoProv) {
                    this.pd.setMessage("Il Soggetto referente dev'essere scelto tra quelli definiti nel pannello Soggetti");
                    return false;
                }
                sRef = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(referente));
                boolean visibile = false;
                if (visibilitaAccordoCooperazione == visibile && sRef.getPrivato() != null && sRef.getPrivato().booleanValue()) {
                    this.pd.setMessage("Non e' possibile utilizzare un soggetto referente con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica.");
                    return false;
                }
                idSoggettoReferente = new IDSoggetto(sRef.getTipo(), sRef.getNome());
            }
            int idAcc = 0;
            Integer versioneInt = null;
            if (versione != null) {
                versioneInt = Integer.parseInt(versione);
            }
            IDAccordoCooperazione idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(nome, idSoggettoReferente, versioneInt.intValue());
            boolean esisteAC = this.acCore.existsAccordoCooperazione(idAccordo);
            AccordoCooperazione ac = null;
            if (esisteAC) {
                ac = this.acCore.getAccordoCooperazione(idAccordo);
                idAcc = ac.getId().intValue();
            }
            if (idAcc != 0 && (tipoOp.equals((Object)TipoOperazione.ADD) || tipoOp.equals((Object)TipoOperazione.CHANGE) && idInt != idAcc)) {
                this.pd.setMessage("Esiste gi&agrave; un accordo (versione " + versione + ") con nome " + nome);
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.CHANGE) && ((ac = this.acCore.getAccordoCooperazione(idAccordoOLD)).getPrivato() == null || !ac.getPrivato().booleanValue()) && ac.getElencoPartecipanti() != null) {
                AccordoCooperazionePartecipanti partecipanti = ac.getElencoPartecipanti();
                for (int i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                    Soggetto sPartecipante = this.soggettiCore.getSoggettoRegistro(partecipanti.getSoggettoPartecipante(i).getIdSoggetto().intValue());
                    if (sPartecipante.getPrivato() == null || !sPartecipante.getPrivato().booleanValue()) continue;
                    this.pd.setMessage("Non e' possibile impostare una visibilita' pubblica all'accordo di cooperazione, poiche' possiede un soggetto parcepante [" + sPartecipante.getTipo() + "/" + sPartecipante.getNome() + "] con visibilita' privata.");
                    return false;
                }
            }
            AccordoCooperazione accordoCooperazione = new AccordoCooperazione();
            accordoCooperazione.setDescrizione(descr);
            accordoCooperazione.setNome(nome);
            if (versione != null) {
                accordoCooperazione.setVersione(Integer.valueOf(Integer.parseInt(versione)));
            }
            if (sRef != null) {
                IdSoggetto soggettoReferente = new IdSoggetto();
                soggettoReferente.setTipo(sRef.getTipo());
                soggettoReferente.setNome(sRef.getNome());
                accordoCooperazione.setSoggettoReferente(soggettoReferente);
            }
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(accordoCooperazione.getSoggettoReferente().getTipo());
            ValidazioneResult v = this.acCore.validazione(accordoCooperazione, this.soggettiCore);
            if (!v.isEsito()) {
                this.pd.setMessage("[validazione-" + protocollo + "] " + v.getMessaggioErrore());
                if (v.getException() != null) {
                    this.log.error("[validazione-" + protocollo + "] " + v.getMessaggioErrore(), (Throwable)v.getException());
                } else {
                    this.log.error("[validazione-" + protocollo + "] " + v.getMessaggioErrore());
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiCooperazioneList(List<AccordoCooperazione> lista, ISearch ricerca) throws Exception {
        try {
            ExporterUtils exporterUtils;
            DataElement de;
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiCooperazione", (Parameter[])new Parameter[0]);
            int idLista = Liste.ACCORDI_COOPERAZIONE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.addFilterProtocol(ricerca, idLista);
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                String filterStatoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroStatoAccordo");
                this.addFilterStatoAccordo(filterStatoAccordo, false);
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
            } else {
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Accordi Cooperazione", (String)search);
            }
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            int totEl = 3;
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                ++totEl;
            }
            if (showProtocolli) {
                ++totEl;
            }
            String[] labels = new String[totEl];
            labels[0] = "Nome";
            int index = 1;
            if (showProtocolli) {
                labels[index] = "Profilo";
                ++index;
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                labels[index] = "Stato";
                ++index;
            }
            labels[index] = "Partecipanti";
            labels[++index] = "Allegati";
            ++index;
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                Iterator<AccordoCooperazione> it = lista.iterator();
                AccordoCooperazione accordoCooperazione = null;
                while (it.hasNext()) {
                    accordoCooperazione = it.next();
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(accordoCooperazione.getSoggettoReferente().getTipo());
                    de = new DataElement();
                    de.setUrl("accordiCooperazioneChange.do", new Parameter[]{new Parameter("id", "" + accordoCooperazione.getId()), new Parameter("nome", accordoCooperazione.getNome())});
                    de.setValue(this.getLabelIdAccordoCooperazione(accordoCooperazione));
                    de.setIdToRemove("" + accordoCooperazione.getId());
                    de.setToolTip(accordoCooperazione.getDescrizione());
                    e.add(de);
                    if (showProtocolli) {
                        de = new DataElement();
                        de.setValue(this.getLabelProtocollo(protocollo));
                        e.add(de);
                    }
                    if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                        de = new DataElement();
                        de.setValue(StatiAccordo.upper((String)accordoCooperazione.getStatoPackage()));
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setUrl("accordiCooperazionePartecipantiList.do", new Parameter[]{new Parameter("id", "" + accordoCooperazione.getId()), new Parameter("nome", accordoCooperazione.getNome())});
                    if (contaListe.booleanValue()) {
                        int numP = 0;
                        if (accordoCooperazione.getElencoPartecipanti() != null) {
                            numP = accordoCooperazione.getElencoPartecipanti().sizeSoggettoPartecipanteList();
                        }
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numP));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("accordiCooperazioneAllegatiList.do", new Parameter[]{new Parameter("id", "" + accordoCooperazione.getId()), new Parameter("nome", accordoCooperazione.getNome())});
                    if (contaListe.booleanValue()) {
                        ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                        this.acCore.accordiCoopAllegatiList(accordoCooperazione.getId().intValue(), (ISearch)searchForCount);
                        int num = searchForCount.getNumEntries(Liste.ACCORDI_COOP_ALLEGATI);
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(num));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.ACCORDO_COOPERAZIONE, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(AccordiCooperazioneCostanti.LABEL_ACCORDI_COOPERAZIONE_ESPORTA_SELEZIONATI_CLICK_EVENT);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiPartecipantiList(AccordoCooperazione ac) throws Exception {
        try {
            String id = this.getParameter("id");
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiCooperazionePartecipanti", (Parameter[])new Parameter[]{new Parameter("id", id)});
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            this.pd.setSearchDescription("");
            lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
            lstParam.add(new Parameter("Partecipanti di " + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac), null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Partecipante"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (ac.getElencoPartecipanti() != null) {
                AccordoCooperazionePartecipanti partecipanti = ac.getElencoPartecipanti();
                for (int i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                    IdSoggetto acep = partecipanti.getSoggettoPartecipante(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setValue(acep.getTipo() + "/" + acep.getNome());
                    de.setIdToRemove("" + acep.getId());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            this.pd.setSearch("off");
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiCooperazioneToDati(List<DataElement> dati, String nome, String descr, String id, TipoOperazione tipoOp, String referente, String versione, String[] providersList, String[] providersListLabel, boolean privato, String stato, String oldStato, String tipoProtocollo, List<String> listaTipiProtocollo, boolean used) throws Exception {
        boolean modificheAbilitate = false;
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            modificheAbilitate = true;
        } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
            modificheAbilitate = true;
        } else if (!StatiAccordo.finale.toString().equals(oldStato)) {
            modificheAbilitate = true;
        }
        DataElement de = new DataElement();
        if (TipoOperazione.CHANGE.equals((Object)tipoOp)) {
            de.setLabel("id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Profilo Interoperabilit\u00e0");
            if (listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
                if (!used && modificheAbilitate) {
                    de.setLabel("Profilo Interoperabilit\u00e0");
                    de.setValues(listaTipiProtocollo);
                    de.setSelected(tipoProtocollo);
                    de.setType(DataElementType.SELECT);
                    de.setName("tipoProtocollo");
                    de.setPostBack(true);
                } else {
                    de.setValue(tipoProtocollo);
                    de.setType(DataElementType.TEXT);
                    de.setName("tipoProtocollo");
                }
            } else {
                de.setValue(tipoProtocollo);
                de.setType(DataElementType.HIDDEN);
                de.setName("tipoProtocollo");
            }
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            de.setLabel("Profilo Interoperabilit\u00e0");
            if (listaTipiProtocollo != null && listaTipiProtocollo.size() > 1 && modificheAbilitate) {
                de.setLabel("Profilo Interoperabilit\u00e0");
                de.setValues(listaTipiProtocollo);
                de.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
                de.setSelected(tipoProtocollo);
                de.setType(DataElementType.SELECT);
                de.setName("tipoProtocollo");
                de.setPostBack(true);
            } else {
                DataElement deLABEL = new DataElement();
                deLABEL.setLabel("Profilo Interoperabilit\u00e0");
                deLABEL.setType(DataElementType.TEXT);
                deLABEL.setName("tipoProtocollo__label");
                deLABEL.setValue(this.getLabelProtocollo(tipoProtocollo));
                dati.add(deLABEL);
                de.setValue(tipoProtocollo);
                de.setType(DataElementType.HIDDEN);
                de.setName("tipoProtocollo");
            }
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (modificheAbilitate) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descr);
        de.setType(DataElementType.TEXT_EDIT);
        if (!modificheAbilitate && StringUtils.isBlank((CharSequence)descr)) {
            de.setValue("");
        }
        de.setName("descr");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Soggetto Referente");
        de.setName("referente");
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            de.setType(DataElementType.SELECT);
            de.setValues(providersList);
            de.setLabels(providersListLabel);
            if (referente != null && !"".equals(referente)) {
                de.setSelected(referente);
            } else {
                de.setSelected("-");
            }
            de.setRequired(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(referente);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Soggetto Referente");
            de.setName("referenteLabelAccordo1.2");
            de.setType(DataElementType.TEXT);
            if (referente != null && !"".equals(referente) && !"-".equals(referente)) {
                Soggetto sogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(referente));
                de.setValue(this.getLabelNomeSoggetto(tipoProtocollo, sogg.getTipo(), sogg.getNome()));
            } else {
                de.setValue("-");
            }
        }
        dati.add(de);
        if (modificheAbilitate) {
            de = this.getVersionDataElement("Versione", "versione", versione, false);
        } else {
            de = new DataElement();
            de.setValue(versione);
            de.setName("versione");
            de.setType(DataElementType.TEXT);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Privato");
        de.setValue(privato ? "yes" : "");
        de.setSelected(privato ? "yes" : "");
        if (this.core.isShowFlagPrivato() && modificheAbilitate && this.isModalitaAvanzata()) {
            de.setType(DataElementType.CHECKBOX);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("privato");
        de.setSize(this.getSize());
        dati.add(de);
        if (this.core.isShowFlagPrivato() && !modificheAbilitate && this.isModalitaAvanzata()) {
            de = new DataElement();
            de.setLabel("Visibilit&agrave; accordo");
            de.setName("privatoLabel");
            if (privato) {
                de.setValue("privata");
            } else {
                de.setValue("pubblica");
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        if (this.isShowGestioneWorkflowStatoDocumenti()) {
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                deLabel = new DataElement();
                deLabel.setType(DataElementType.TEXT);
                deLabel.setLabel("Stato");
                deLabel.setValue(StatiAccordo.upper((String)StatiAccordo.bozza.toString()));
                deLabel.setName("stato__label");
                dati.add(deLabel);
                de.setType(DataElementType.HIDDEN);
                de.setValue(StatiAccordo.bozza.toString());
            } else if (!StatiAccordo.finale.toString().equals(oldStato)) {
                de.setType(DataElementType.SELECT);
                de.setValues(StatiAccordo.toArray());
                de.setLabels(StatiAccordo.toLabel());
                de.setSelected(stato);
            } else {
                deLabel = new DataElement();
                deLabel.setType(DataElementType.TEXT);
                deLabel.setLabel("Stato");
                deLabel.setValue(StatiAccordo.upper((String)StatiAccordo.finale.toString()));
                deLabel.setName("stato__label");
                dati.add(deLabel);
                de.setType(DataElementType.HIDDEN);
                de.setValue(StatiAccordo.finale.toString());
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(StatiAccordo.finale.toString());
        }
        de.setName("stato");
        dati.add(de);
        if (!tipoOp.equals((Object)TipoOperazione.ADD)) {
            int num;
            ConsoleSearch searchForCount;
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("accordiCooperazionePartecipantiList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome)});
            if (contaListe.booleanValue()) {
                searchForCount = new ConsoleSearch(true, 1);
                this.acCore.accordiCoopPartecipantiList(Long.parseLong(id), (ISearch)searchForCount);
                num = searchForCount.getNumEntries(Liste.ACCORDI_COOP_PARTECIPANTI);
                de.setValue("Soggetti Partecipanti(" + num + ")");
            } else {
                de.setValue("Soggetti Partecipanti");
            }
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("accordiCooperazioneAllegatiList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome)});
            if (contaListe.booleanValue()) {
                searchForCount = new ConsoleSearch(true, 1);
                this.acCore.accordiCoopAllegatiList(Integer.parseInt(id), (ISearch)searchForCount);
                num = searchForCount.getNumEntries(Liste.ACCORDI_COOP_ALLEGATI);
                de.setValue("Allegati(" + num + ")");
            } else {
                de.setValue("Allegati");
            }
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addAccordiCooperazioneToDatiAsHidden(List<DataElement> dati, String nome, String descr, String id, TipoOperazione tipoOp, String referente, String versione, String[] providersList, String[] providersListLabel, boolean privato, String stato, String oldStato, String tipoProtocollo, List<String> listaTipiProtocollo, boolean used) throws Exception {
        DataElement de = new DataElement();
        de.setValue(tipoProtocollo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoProtocollo");
        de.setSize(this.getSize());
        dati.add(de);
        if (TipoOperazione.CHANGE.equals((Object)tipoOp)) {
            de = new DataElement();
            de.setLabel("id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.HIDDEN);
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descr);
        de.setType(DataElementType.HIDDEN);
        de.setValue(descr);
        de.setName("descr");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Soggetto Referente");
        de.setName("referente");
        if (referente != null && !"".equals(referente) && !"-".equals(referente)) {
            Soggetto sogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(referente));
            de.setValue("" + sogg.getId());
        } else {
            de.setValue("-");
        }
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Versione");
        de.setValue(versione);
        de.setType(DataElementType.HIDDEN);
        de.setName("versione");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Privato");
        de.setValue(privato ? "yes" : "no");
        de.setType(DataElementType.HIDDEN);
        de.setName("privato");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Visibilit&agrave; accordo");
        de.setName("privatoLabel");
        de.setType(DataElementType.HIDDEN);
        if (privato) {
            de.setValue("privata");
        } else {
            de.setValue("pubblica");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setType(DataElementType.HIDDEN);
        de.setValue(stato);
        de.setName("stato");
        dati.add(de);
        return dati;
    }

    public void prepareAccordiCoopPartecipantiList(AccordoCooperazione ac, List<IDSoggetto> lista, ISearch ricerca) throws Exception {
        try {
            String id = this.getParameter("id");
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiCooperazionePartecipanti", (Parameter[])new Parameter[]{new Parameter("id", id)});
            int idLista = Liste.ACCORDI_COOP_PARTECIPANTI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String titleAS = this.getLabelIdAccordoCooperazione(ac);
            this.pd.setSearchDescription("");
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("Partecipanti di " + titleAS, null));
            } else {
                lstParam.add(new Parameter("Partecipanti di " + titleAS, "accordiCooperazioneList.do"));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            this.pd.setSearchLabel("Partecipante");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Partecipanti", (String)search);
            }
            String[] labels = new String[]{"Partecipante"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            for (int i = 0; i < lista.size(); ++i) {
                IDSoggetto idSO = lista.get(i);
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue(this.getLabelNomeSoggetto(this.soggettiCore.getProtocolloAssociatoTipoSoggetto(idSO.getTipo()), idSO.getTipo(), idSO.getNome()));
                de.setIdToRemove(idSO.getTipo() + "/" + idSO.getNome());
                e.add(de);
                dati.add(e);
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(ac.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiCoopAllegatiList(AccordoCooperazione ac, ISearch ricerca, List<Documento> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiCooperazioneAllegati", (Parameter[])new Parameter[]{new Parameter("id", "" + ac.getId())});
            int idLista = Liste.ACCORDI_COOP_ALLEGATI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String titleAS = this.getLabelIdAccordoCooperazione(ac);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("Allegati di " + titleAS, null));
            } else {
                lstParam.add(new Parameter("Allegati di " + titleAS, "accordiCooperazioneAllegatiList.do", new Parameter[]{new Parameter("id", "" + ac.getId())}));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Allegati", (String)search);
            }
            String[] labels = new String[]{"Nome", "Ruolo", "Tipo", "Documento"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Documento doc : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiCooperazioneAllegatiChange.do", new Parameter[]{new Parameter("idAllegato", "" + doc.getId()), new Parameter("idAccordo", "" + ac.getId()), new Parameter("nomeDoc", doc.getFile())});
                    de.setValue(doc.getFile());
                    de.setIdToRemove("" + doc.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(doc.getRuolo());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(doc.getTipo());
                    e.add(de);
                    de = new DataElement();
                    if (this.core.isShowAllegati()) {
                        de.setUrl("accordiCooperazioneAllegatiView.do", new Parameter[]{new Parameter("idAllegato", "" + doc.getId()), new Parameter("idAccordo", "" + ac.getId()), new Parameter("nomeDoc", doc.getFile())});
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    } else {
                        Parameter pTipoDoc = new Parameter("tipoDocumento", "ac");
                        de.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAllegato", "" + doc.getId()), new Parameter("idAccordo", "" + ac.getId()), new Parameter("nomeDoc", doc.getFile()), pTipoDoc});
                        de.setValue("Download".toLowerCase());
                        de.setDisabilitaAjaxStatus();
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(ac.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAllegatiToDati(TipoOperazione tipoOp, String idAllegato, String idAccordo, Documento doc, StringBuilder contenutoAllegato, String errore, List<DataElement> dati, String statoPackage, boolean editMode) {
        DataElement de = new DataElement();
        de.setValue(idAllegato);
        de.setType(DataElementType.HIDDEN);
        de.setName("idAllegato");
        dati.add(de);
        de = new DataElement();
        de.setValue(idAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("idAccordo");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Allegato");
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getRuolo());
        de.setLabel("Ruolo");
        de.setType(DataElementType.TEXT);
        de.setName("ruolo");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getFile());
        de.setLabel("Nome");
        de.setType(DataElementType.TEXT);
        de.setName("nomeDoc");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(doc.getTipo());
        de.setLabel("Tipo");
        de.setType(DataElementType.TEXT);
        de.setName("tipoFile");
        de.setSize(this.getSize());
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.OTHER)) {
            if (this.core.isShowAllegati()) {
                if (errore != null) {
                    de = new DataElement();
                    de.setValue(errore);
                    de.setLabel("Documento");
                    de.setType(DataElementType.TEXT);
                    de.setName("documento");
                    de.setSize(this.getSize());
                    dati.add(de);
                } else {
                    de = new DataElement();
                    de.setLabel("");
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setValue(contenutoAllegato.toString());
                    de.setRows(30);
                    de.setCols(110);
                    dati.add(de);
                }
            }
            DataElement saveAs = new DataElement();
            saveAs.setValue("Download");
            saveAs.setType(DataElementType.LINK);
            Parameter pIdAccordo = new Parameter("idAccordo", idAccordo);
            Parameter pIdAllegato = new Parameter("idAllegato", idAllegato);
            Parameter pTipoDoc = new Parameter("tipoDocumento", "ac");
            saveAs.setUrl("downloadDocumento", new Parameter[]{pIdAccordo, pIdAllegato, pTipoDoc});
            saveAs.setDisabilitaAjaxStatus();
            dati.add(saveAs);
        }
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            if (editMode) {
                if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(statoPackage)) {
                    this.pd.setMode("view-noeditbutton");
                } else {
                    de = new DataElement();
                    de.setType(DataElementType.FILE);
                    de.setLabel("Documento");
                    de.setName("theFile");
                    de.setSize(this.getSize());
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setType(DataElementType.FILE);
                de.setLabel("Documento");
                de.setName("theFile");
                de.setSize(this.getSize());
                dati.add(de);
            }
        }
        return dati;
    }

    public List<DataElement> addAllegatoToDati(TipoOperazione tipoOp, String idAccordo, String ruolo, String[] ruoli, String[] tipiAmmessi, String[] tipiAmmessiLabel, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setValue(idAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Allegato");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Ruolo");
        de.setType(DataElementType.SELECT);
        de.setName("ruolo");
        de.setValues(ruoli);
        de.setPostBack(true);
        de.setSelected(ruolo != null ? ruolo : "");
        de.setSize(this.getSize());
        dati.add(de);
        if (tipiAmmessi != null) {
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.SELECT);
            de.setName("tipoFile");
            de.setValues(tipiAmmessi);
            de.setLabels(tipiAmmessiLabel);
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setValue(idAccordo);
        de.setLabel("Documento");
        de.setType(DataElementType.FILE);
        de.setName("theFile");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public List<DataElement> addPartecipanteToDati(TipoOperazione tipoOp, String id, String[] partecipantiNonInseriti, String[] partecipantiNonInseritiLabels, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Partecipante");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setValue(id);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Soggetto");
        de.setValues(partecipantiNonInseriti);
        de.setLabels(partecipantiNonInseritiLabels);
        de.setType(DataElementType.SELECT);
        de.setName("partecipante");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }
}

