/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneAzioniDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
        try {
            AccordiServizioParteComuneHelper apcHelper = new AccordiServizioParteComuneHelper(request, pd, session);
            apcHelper.makeMenu();
            String id = apcHelper.getParametroLong("id");
            long idAccordoLong = Long.valueOf(id);
            String objToRemove = apcHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            String tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(apcCore);
            PorteDelegateCore porteDelegateCore = new PorteDelegateCore(apcCore);
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apcCore);
            AccordoServizioParteComune as = apcCore.getAccordoServizioFull(idAccordoLong);
            int totAz = as.sizeAzioneList();
            String nomeaz = "";
            List<IDServizio> idServiziWithAccordo = null;
            try {
                idServiziWithAccordo = apsCore.getIdServiziWithAccordo(idAccordoFactory.getIDAccordoFromAccordo(as), true);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            StringBuilder errori = new StringBuilder();
            block4: for (int i = 0; i < idsToRemove.size(); ++i) {
                nomeaz = idsToRemove.get(i);
                if (apcCore.isAzioneCorrelata(as.getId(), nomeaz, nomeaz)) {
                    ArrayList<String> tmp = new ArrayList<String>();
                    for (int l = 0; l < as.sizeAzioneList(); ++l) {
                        Azione azc = as.getAzione(l);
                        if (!nomeaz.equals(azc.getCorrelata())) continue;
                        tmp.add(azc.getNome());
                    }
                    if (errori.length() > 0) {
                        errori.append("<BR>");
                    }
                    errori.append("Azione " + nomeaz + " non rimuovibile poich\u00e8 perche' correlata ad altre azioni:<BR>");
                    for (int p = 0; p < tmp.size(); ++p) {
                        errori.append("- " + (String)tmp.get(p) + "<BR>");
                    }
                    continue;
                }
                if (idServiziWithAccordo != null && idServiziWithAccordo.size() > 0) {
                    List<MappingErogazionePortaApplicativa> lPA = porteApplicativeCore.getMappingConGruppiPerAzione(nomeaz, idServiziWithAccordo);
                    if (lPA != null && !lPA.isEmpty()) {
                        if (errori.length() > 0) {
                            errori.append("<BR>");
                        }
                        errori.append("Azione " + nomeaz + " non rimuovibile poich\u00e8 riassegnata in un gruppo dell'erogazione del servizio: <BR>");
                        for (int j = 0; j < lPA.size(); ++j) {
                            errori.append("- " + String.valueOf(lPA.get(j).getIdServizio()) + " (gruppo: '" + lPA.get(j).getDescrizione() + "')<BR>");
                        }
                        continue;
                    }
                    List<MappingFruizionePortaDelegata> lPD = porteDelegateCore.getMappingConGruppiPerAzione(nomeaz, idServiziWithAccordo);
                    if (lPD != null && !lPD.isEmpty()) {
                        if (errori.length() > 0) {
                            errori.append("<BR>");
                        }
                        errori.append("Azione " + nomeaz + " non rimuovibile poich\u00e8 riassegnata in un gruppo della fruizione del servizio: <BR>");
                        for (int j = 0; j < lPD.size(); ++j) {
                            errori.append("- " + String.valueOf(lPD.get(j).getIdServizio()) + " (fruitore: " + String.valueOf(lPD.get(j).getIdFruitore()) + ") (gruppo: '" + lPD.get(j).getDescrizione() + "')<BR>");
                        }
                        continue;
                    }
                    if (apcCore.isUnicaAzioneInAccordi(nomeaz)) {
                        int j;
                        if (porteApplicativeCore.existsPortaApplicativaAzione(nomeaz)) {
                            List<IDPortaApplicativa> idPAs = porteApplicativeCore.getPortaApplicativaAzione(nomeaz);
                            if (errori.length() > 0) {
                                errori.append("<BR>");
                            }
                            errori.append("Azione " + nomeaz + " non rimuovibile poich\u00e8 in uso in porte applicative: <BR>");
                            for (j = 0; j < idPAs.size(); ++j) {
                                errori.append("- " + idPAs.get(j).toString() + "<BR>");
                            }
                            continue;
                        }
                        if (porteDelegateCore.existsPortaDelegataAzione(nomeaz)) {
                            List<IDPortaDelegata> idPDs = porteDelegateCore.getPortaDelegataAzione(nomeaz);
                            if (errori.length() > 0) {
                                errori.append("<BR>");
                            }
                            errori.append("Azione " + nomeaz + " non rimuovibile poich\u00e8 in uso in porte delegate: <BR>");
                            for (j = 0; j < idPDs.size(); ++j) {
                                errori.append("- " + idPDs.get(j).toString() + "<BR>");
                            }
                            continue;
                        }
                    } else {
                        if (errori.length() > 0) {
                            errori.append("<BR>");
                        }
                        errori.append("Azione " + nomeaz + " non rimuovibile poich\u00e8 la API viene implementata dai seguenti servizi: <br>");
                        for (int j = 0; j < idServiziWithAccordo.size(); ++j) {
                            errori.append("- " + idServiziWithAccordo.get(j).toString() + "<br>");
                        }
                        continue;
                    }
                }
                for (int j = 0; j < as.sizeAzioneList(); ++j) {
                    Azione az = as.getAzione(i);
                    if (!nomeaz.equals(az.getNome())) continue;
                    as.removeAzione(j);
                    --totAz;
                    continue block4;
                }
            }
            boolean modificaUtilizzoSenzaAzione = false;
            if (totAz == 0) {
                modificaUtilizzoSenzaAzione = true;
            }
            if (modificaUtilizzoSenzaAzione) {
                as.setUtilizzoSenzaAzione(true);
            }
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
            if (errori.length() > 0) {
                pd.setMessage(errori.toString());
            }
            List<AccordoServizioParteSpecifica> listaServizi = apsCore.serviziWithIdAccordoList(idAccordoLong);
            for (AccordoServizioParteSpecifica servizio : listaServizi) {
                apcCore.performUpdateOperation(userLogin, apcHelper.smista(), servizio);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.ACCORDI_AZIONI;
            ricerca = apcHelper.checkSearchParameters(idLista, ricerca);
            List<Azione> lista = apcCore.accordiAzioniList(idAccordoLong, (ISearch)ricerca);
            apcHelper.prepareAccordiAzioniList(as, lista, (ISearch)ricerca, id, tipoAccordo);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"accordiServizioParteComuneAzioni", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComuneAzioni", (ForwardParams)ForwardParams.DEL());
        }
    }
}

