/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Message;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceParameter;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneServizioCompostoServizioComponenteSintetico;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneServizioCompostoSintetico;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.OperationSintetica;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.beans.ResourceSintetica;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.constants.ParameterType;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.RepresentationType;
import org.openspcoop2.core.registry.constants.RepresentationXmlType;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.utils.rest.ValidatorException;
import org.openspcoop2.utils.rest.api.ApiParameterSchema;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.utils.rest.api.ApiUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriHelper;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.Dialog;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;

public class AccordiServizioParteComuneHelper
extends ConnettoriHelper {
    public AccordiServizioParteComuneHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public AccordiServizioParteComuneHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public boolean asWithAllegatiXsd(AccordoServizioParteComune as) {
        boolean asWithAllegati = false;
        if (as.getByteWsdlDefinitorio() != null) {
            asWithAllegati = true;
        }
        if (as.sizeAllegatoList() > 0) {
            for (Documento doc : as.getAllegatoList()) {
                if (!"xsd".equalsIgnoreCase(doc.getTipo()) && !"xml".equalsIgnoreCase(doc.getTipo())) continue;
                asWithAllegati = true;
                break;
            }
        }
        if (as.sizeSpecificaSemiformaleList() > 0) {
            for (Documento doc : as.getSpecificaSemiformaleList()) {
                if (!"xsd".equalsIgnoreCase(doc.getTipo()) && !"xml".equalsIgnoreCase(doc.getTipo())) continue;
                asWithAllegati = true;
                break;
            }
        }
        return asWithAllegati;
    }

    public static String convertProfiloCollaborazioneDB2View(String toConvert) {
        String profilo = "";
        if (toConvert == null || toConvert.equals("")) {
            profilo = "";
        } else if (toConvert.equals(CostantiRegistroServizi.ONEWAY.getValue())) {
            profilo = "oneway";
        } else if (toConvert.equals(CostantiRegistroServizi.SINCRONO.getValue())) {
            profilo = "sincrono";
        } else if (toConvert.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO.getValue())) {
            profilo = "asincronoSimmetrico";
        } else if (toConvert.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.getValue())) {
            profilo = "asincronoAsimmetrico";
        }
        return profilo;
    }

    public static String convertProfiloCollaborazioneDB2View(ProfiloCollaborazione toConvert) {
        String profilo = "";
        if (toConvert == null || toConvert.equals("")) {
            profilo = "";
        } else if (toConvert.equals((Object)CostantiRegistroServizi.ONEWAY)) {
            profilo = "oneway";
        } else if (toConvert.equals((Object)CostantiRegistroServizi.SINCRONO)) {
            profilo = "sincrono";
        } else if (toConvert.equals((Object)CostantiRegistroServizi.ASINCRONO_SIMMETRICO)) {
            profilo = "asincronoSimmetrico";
        } else if (toConvert.equals((Object)CostantiRegistroServizi.ASINCRONO_ASIMMETRICO)) {
            profilo = "asincronoAsimmetrico";
        }
        return profilo;
    }

    public static String convertProfiloCollaborazioneView2DB(String toConvert) {
        String profilo = "";
        if (toConvert == null || toConvert.equals("")) {
            profilo = "";
        } else if (toConvert.equals("oneway")) {
            profilo = CostantiRegistroServizi.ONEWAY.toString();
        } else if (toConvert.equals("sincrono")) {
            profilo = CostantiRegistroServizi.SINCRONO.toString();
        } else if (toConvert.equals("asincronoSimmetrico")) {
            profilo = CostantiRegistroServizi.ASINCRONO_SIMMETRICO.toString();
        } else if (toConvert.equals("asincronoAsimmetrico")) {
            profilo = CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.toString();
        }
        return profilo;
    }

    public static String convertAbilitatoDisabilitatoView2DB(String toConvert) {
        String value = null;
        value = toConvert == null || "".equals(toConvert) ? null : (toConvert.equals("yes") ? CostantiRegistroServizi.ABILITATO.toString() : CostantiRegistroServizi.DISABILITATO.toString());
        return value;
    }

    public static String convertAbilitatoDisabilitatoDB2View(String toConvert) {
        if (CostantiRegistroServizi.ABILITATO.equals(toConvert)) {
            return "yes";
        }
        return "no";
    }

    public static String convertAbilitatoDisabilitatoDB2View(StatoFunzionalita toConvert) {
        if (CostantiRegistroServizi.ABILITATO.equals((Object)toConvert)) {
            return "yes";
        }
        return "no";
    }

    public void prepareAccordiErogatoriList(AccordoServizioParteComune as, List<Soggetto> lista, ISearch ricerca, String tipoAccordo) throws Exception {
        try {
            String id = this.getParameter("id");
            String uri = null;
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneErogatori", (Parameter[])new Parameter[]{new Parameter("id", id), new Parameter("tipoAccordo", tipoAccordo), new Parameter("nome", uri)});
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            int idLista = Liste.ACCORDI_EROGATORI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo), "accordiServizioParteComuneList.do?" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getName() + "=" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getValue()), new Parameter("Erogazioni di " + labelASTitle, null)});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo), "accordiServizioParteComuneList.do?" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getName() + "=" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getValue()), new Parameter("Erogazioni di  di " + labelASTitle, "accordiServizioParteComuneErogatoriList.do?id=" + id + "&nome=" + uri + "&" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getName() + "=" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getValue()), new Parameter("Risultati ricerca", null)});
            }
            this.pd.setSearchLabel("Soggetto Erogatore");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Erogazioni", (String)search);
            }
            String[] labels = new String[]{"Soggetto Erogatore", "Servizio", "Fruitori"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Soggetto sog : lista) {
                    ArrayList<AccordoServizioParteSpecifica> listaServizi = new ArrayList<AccordoServizioParteSpecifica>();
                    for (int i = 0; i < sog.sizeAccordoServizioParteSpecificaList(); ++i) {
                        listaServizi.add(sog.getAccordoServizioParteSpecifica(i));
                    }
                    IDSoggetto tmpIdSoggetto = new IDSoggetto(sog.getTipo(), sog.getNome());
                    Soggetto tmpSog = null;
                    try {
                        tmpSog = this.soggettiCore.getSoggettoRegistro(tmpIdSoggetto);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    for (int i = 0; i < listaServizi.size(); ++i) {
                        AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)listaServizi.get(i);
                        String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(sog.getTipo());
                        ArrayList<DataElement> e = new ArrayList<DataElement>();
                        DataElement de = new DataElement();
                        de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + tmpSog.getId()), new Parameter("nomeprov", sog.getNome()), new Parameter("tipoprov", sog.getTipo())});
                        de.setValue(this.getLabelNomeSoggetto(protocollo, sog.getTipo(), sog.getNome()));
                        e.add(de);
                        boolean isServizioCorrelato = TipologiaServizio.CORRELATO.equals((Object)asps.getTipologiaServizio());
                        int idServ = asps.getId().intValue();
                        de = new DataElement();
                        de.setUrl("accordiServizioParteSpecificaChange.do", new Parameter[]{new Parameter("id", "" + idServ)});
                        String correlato = isServizioCorrelato ? " [Correlato]" : "";
                        de.setValue(this.getLabelNomeServizio(protocollo, asps.getTipo(), asps.getNome(), asps.getVersione()) + correlato);
                        e.add(de);
                        de = new DataElement();
                        Parameter pIdsoggErogatore = new Parameter("idSoggErogatore", "" + sog.getId());
                        de.setUrl("accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{new Parameter("id", "" + asps.getId()), pIdsoggErogatore});
                        if (contaListe.booleanValue()) {
                            int numEr = asps.sizeFruitoreList();
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numEr));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        e.add(de);
                        dati.add(e);
                    }
                }
            }
            this.pd.setDati(dati);
            this.pd.setSelect(false);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiAllegatiList(AccordoServizioParteComune as, ISearch ricerca, List<Documento> lista, String tipoAccordo) throws Exception {
        try {
            Object labelAllegati;
            String uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", "" + as.getId());
            Parameter pNomeAccordo = new Parameter("nome", uri);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneAllegati", (Parameter[])new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo});
            int idLista = Liste.ACCORDI_ALLEGATI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object object = labelAllegati = isModalitaVistaApiCustom != false ? "Allegati" : "Allegati di " + labelASTitle;
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter((String)labelAllegati, null));
            } else {
                listaParams.add(new Parameter((String)labelAllegati, "accordiServizioParteComuneAllegatiList.do", new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Allegati", (String)search);
            }
            String[] labels = new String[]{"Nome", "Ruolo", "Tipo", "Documento"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Documento doc : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiServizioParteComuneAllegatiChange.do", new Parameter[]{new Parameter("idAllegato", "" + doc.getId()), new Parameter("idAccordo", "" + as.getId()), new Parameter("nomeDoc", doc.getFile()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    de.setValue(doc.getFile());
                    de.setIdToRemove("" + doc.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(doc.getRuolo());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(doc.getTipo());
                    e.add(de);
                    de = new DataElement();
                    if (this.core.isShowAllegati()) {
                        de.setValue("visualizza");
                        de.setUrl("accordiServizioParteComuneAllegatiView.do", new Parameter[]{new Parameter("idAllegato", "" + doc.getId()), new Parameter("idAccordo", "" + as.getId()), new Parameter("nomeDoc", doc.getFile()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    } else {
                        de.setValue("Download".toLowerCase());
                        de.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAllegato", "" + doc.getId()), new Parameter("idAccordo", "" + as.getId()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), new Parameter("tipoDocumento", "aspc")});
                        de.setDisabilitaAjaxStatus();
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<Object> addAccordiAllegatiToDati(List<Object> dati, TipoOperazione tipoOperazione, String idAccordo, String ruolo, String[] ruoli, String[] tipiAmmessi, String[] tipiAmmessiLabel, String tipoAccordo, String tipoFile, String idAllegato, Documento doc, AccordoServizioParteComune as, String errore, StringBuilder contenutoAllegato, List<BinaryParameter> binaryParameterDocumenti) throws Exception {
        try {
            boolean stato;
            DataElement de;
            if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
                de = new DataElement();
                de.setValue(idAccordo);
                de.setType(DataElementType.HIDDEN);
                de.setName("id");
                dati.add(de);
            } else {
                de = new DataElement();
                de.setValue(idAllegato);
                de.setType(DataElementType.HIDDEN);
                de.setName("idAllegato");
                dati.add(de);
                de = new DataElement();
                de.setValue(idAccordo);
                de.setType(DataElementType.HIDDEN);
                de.setName("idAccordo");
                dati.add(de);
            }
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Allegato");
            dati.add(de);
            boolean bl = stato = this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage());
            if (!stato && TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                de = new DataElement();
                de.setLabel("Attuale");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
            }
            de = new DataElement();
            if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
                de.setValue(idAccordo);
                de.setType(DataElementType.SELECT);
                de.setSelected(ruolo != null ? ruolo : "");
                de.setValues(ruoli);
            } else {
                de.setValue(doc.getRuolo());
                de.setType(DataElementType.TEXT);
            }
            de.setLabel("Ruolo");
            de.setName("ruolo");
            de.setPostBack(true);
            de.setSize(this.getSize());
            dati.add(de);
            if (tipiAmmessi != null) {
                de = new DataElement();
                de.setLabel("Tipo");
                de.setType(DataElementType.SELECT);
                de.setName("tipoFile");
                de.setValues(tipiAmmessi);
                de.setLabels(tipiAmmessiLabel);
                de.setSize(this.getSize());
                de.setSelected(tipoFile);
                dati.add(de);
            }
            if (!TipoOperazione.ADD.equals((Object)tipoOperazione)) {
                de = new DataElement();
                de.setValue(doc.getFile());
                de.setLabel("Nome");
                de.setType(DataElementType.TEXT);
                de.setName("nomeDoc");
                de.setSize(this.getSize());
                dati.add(de);
            }
            if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
                BinaryParameter allegato0 = binaryParameterDocumenti.get(0);
                DataElement fileDataElement = allegato0.getFileDataElement("Documento", "", this.getSize());
                fileDataElement.setType(DataElementType.MULTI_FILE);
                fileDataElement.setRequired(true);
                dati.add(fileDataElement);
                dati.addAll(BinaryParameter.getFileNameDataElement(binaryParameterDocumenti));
                dati.add(BinaryParameter.getFileIdDataElement(binaryParameterDocumenti));
            }
            if (!TipoOperazione.ADD.equals((Object)tipoOperazione)) {
                de = new DataElement();
                de.setValue(doc.getTipo());
                de.setLabel("Tipo");
                de.setType(DataElementType.TEXT);
                de.setName("tipoFile");
                de.setSize(this.getSize());
                dati.add(de);
            }
            de = new DataElement();
            de.setValue(tipoAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoAccordo");
            dati.add(de);
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                    this.pd.disableEditMode();
                } else {
                    de = new DataElement();
                    de.setLabel("Nuovo");
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.FILE);
                    de.setLabel("Documento");
                    de.setName("theFile");
                    de.setSize(this.getSize());
                    dati.add(de);
                }
            }
            if (TipoOperazione.OTHER.equals((Object)tipoOperazione)) {
                if (this.core.isShowAllegati()) {
                    if (errore != null) {
                        de = new DataElement();
                        de.setValue(errore);
                        de.setLabel("Documento");
                        de.setType(DataElementType.TEXT);
                        de.setName("documento");
                        de.setSize(this.getSize());
                        dati.add(de);
                    } else {
                        de = new DataElement();
                        de.setLabel("");
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                        de.setValue(contenutoAllegato.toString());
                        de.setRows(30);
                        de.setCols(110);
                        dati.add(de);
                    }
                }
                DataElement saveAs = new DataElement();
                saveAs.setValue("Download");
                saveAs.setType(DataElementType.LINK);
                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", idAccordo), new Parameter("idAllegato", idAllegato), new Parameter("tipoDocumento", "aspc")});
                saveAs.setDisabilitaAjaxStatus();
                dati.add(saveAs);
                this.pd.disableEditMode();
            }
            return dati;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiPorttypeOperationsList(ISearch ricerca, List<Operation> lista, String idAs, AccordoServizioParteComune as, String tipoAccordo, String nomept) throws Exception {
        try {
            String uri = null;
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", idAs);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            Parameter pNomePortTypes = new Parameter("nomept", nomept);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComunePortTypeOperations", (Parameter[])new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo, pNomePortTypes});
            HashMap<String, String> campiHidden = new HashMap<String, String>();
            campiHidden.put("nomept", nomept);
            this.pd.setHidden(campiHidden);
            int idLista = Liste.ACCORDI_PORTTYPE_AZIONI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object labelPortTypes = isModalitaVistaApiCustom != false ? "Servizi" : "Servizi di " + labelASTitle;
            listaParams.add(new Parameter((String)labelPortTypes, "accordiServizioParteComunePortTypesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
            String labelOperations = "Azioni di " + nomept;
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter(labelOperations, null));
            } else {
                listaParams.add(new Parameter(labelOperations, "accordiServizioParteComunePortTypeOperationsList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomePortTypes}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Azioni", (String)search);
            }
            String[] labels = new String[]{"Nome", "Uso"};
            this.pd.setLabels(labels);
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            if (lista != null) {
                for (Operation op : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiServizioParteComunePortTypeOperationsChange.do", new Parameter[]{new Parameter("id", idAs), new Parameter("nomept", nomept), new Parameter("nomeop", op.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
                    de.setValue(op.getNome());
                    de.setIdToRemove(op.getNome());
                    e.add(de);
                    this.addInUsoButtonVisualizzazioneClassica(e, op.getNome(), op.getNome() + "@" + nomept + "@" + this.idAccordoFactory.getUriFromAccordo(as), InUsoType.OPERAZIONE);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiPorttypeOperationCheckData(TipoOperazione tipoOperazione, String id, String nomept, String nomeop, String profProtocollo, String filtrodupop, String confricop, String idcollop, String idRifRichiestaOp, String consordop, String scadenzaop, String servcorr, String azicorr, String profcollop, String styleOp, String soapActionOp, String useOpParam, String opTypeOp, String nsWSDLOp) throws Exception {
        try {
            boolean giaRegistrato;
            int i;
            if (filtrodupop != null && filtrodupop.equals("null")) {
                filtrodupop = null;
            }
            if (confricop != null && confricop.equals("null")) {
                confricop = null;
            }
            if (idcollop != null && idcollop.equals("null")) {
                idcollop = null;
            }
            if (idRifRichiestaOp != null && idRifRichiestaOp.equals("null")) {
                idRifRichiestaOp = null;
            }
            if (consordop != null && consordop.equals("null")) {
                consordop = null;
            }
            if (servcorr == null || servcorr.equals("")) {
                servcorr = "-";
            }
            if (azicorr == null || azicorr.equals("")) {
                azicorr = "-";
            }
            if (profcollop == null) {
                profcollop = "";
            }
            if (styleOp == null) {
                styleOp = "0";
            }
            if (soapActionOp == null) {
                soapActionOp = "";
            }
            String useOp = useOpParam;
            if (useOpParam == null) {
                useOp = AccordiServizioParteComuneCostanti.DEFAULT_VALUE_PARAMETRO_APC_PORT_TYPE_OPERATION_USE;
            }
            if (nsWSDLOp == null) {
                nsWSDLOp = "";
            }
            if (nomeop.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Nome");
                return false;
            }
            if (this.core.isShowCorrelazioneAsincronaInAccordi() && !servcorr.equals("-") && azicorr.equals("-")) {
                this.pd.setMessage("Indicare un'azione correlata");
                return false;
            }
            if (!this.checkLength255(nomeop, "Nome")) {
                return false;
            }
            if (soapActionOp != null && !"".equals(soapActionOp) && !this.checkLength255(soapActionOp, "SOAPAction")) {
                return false;
            }
            if (nsWSDLOp != null && !"".equals(nsWSDLOp) && !this.checkLength255(nsWSDLOp, "Namespace")) {
                return false;
            }
            if (!this.checkNCName(nomeop, "Nome")) {
                return false;
            }
            if (!profProtocollo.equals("default") && !profProtocollo.equals("ridefinito")) {
                this.pd.setMessage("Il profilo dev'essere \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_PORT_TYPE[0] + "\" o \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_PORT_TYPE[1] + "\"");
                return false;
            }
            if ("ridefinito".equals(profProtocollo)) {
                if (!(filtrodupop == null || filtrodupop.equals("yes") || filtrodupop.equals(CostantiRegistroServizi.ABILITATO.getValue()) || filtrodupop.equals("no") || filtrodupop.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Filtro duplicati dev'essere selezionato o deselezionato");
                    return false;
                }
                if (!(confricop == null || confricop.equals("yes") || confricop.equals(CostantiRegistroServizi.ABILITATO.getValue()) || confricop.equals("no") || confricop.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Conferma Ricezione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!(idcollop == null || idcollop.equals("yes") || idcollop.equals(CostantiRegistroServizi.ABILITATO.getValue()) || idcollop.equals("no") || idcollop.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("ID Conversazione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!(idRifRichiestaOp == null || idRifRichiestaOp.equals("yes") || idRifRichiestaOp.equals(CostantiRegistroServizi.ABILITATO.getValue()) || idRifRichiestaOp.equals("no") || idRifRichiestaOp.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Riferimento ID Richiesta dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!(consordop == null || consordop.equals("yes") || consordop.equals(CostantiRegistroServizi.ABILITATO.getValue()) || consordop.equals("no") || consordop.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Consegna in ordine dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!scadenzaop.equals("") && !this.checkNumber(scadenzaop, "Scadenza", false)) {
                    return false;
                }
            }
            AccordoServizioParteComuneSintetico as = this.apcCore.getAccordoServizioSintetico(Long.valueOf(id));
            PortTypeSintetico pt = null;
            for (i = 0; i < as.getPortType().size(); ++i) {
                PortTypeSintetico ptCheck = (PortTypeSintetico)as.getPortType().get(i);
                if (!nomept.equals(ptCheck.getNome())) continue;
                pt = ptCheck;
                break;
            }
            if (pt == null) {
                throw new Exception("Il port type '" + nomept + "' non esiste");
            }
            if (tipoOperazione.equals((Object)TipoOperazione.ADD) && (giaRegistrato = this.apcCore.existsAccordoServizioPorttypeOperation(nomeop, pt.getId()))) {
                this.pd.setMessage("L'azione " + nomeop + " &egrave; gi&agrave; stata associata al servizio");
                return false;
            }
            if (this.core.isShowCorrelazioneAsincronaInAccordi() && pt != null) {
                for (i = 0; i < pt.getAzione().size(); ++i) {
                    OperationSintetica op = (OperationSintetica)pt.getAzione().get(i);
                    if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && nomeop.equals(op.getNome())) continue;
                    if (!(servcorr == null || "".equals(servcorr) || "-".equals(servcorr) || azicorr == null || "".equals(azicorr) || "-".equals(azicorr))) {
                        if (op.getCorrelata() != null) continue;
                        this.pd.setMessage("L'azione " + nomeop + ", essendo correlata ad un'altra azione (" + azicorr + ") di un altro servizio (" + servcorr + "), non pu&ograve; essere aggiunta ad un servizio che possiede azioni che non risultano correlate verso altri servizi asincroni");
                        return false;
                    }
                    if (op.getCorrelataServizio() == null || pt.getNome().equals(op.getCorrelataServizio())) continue;
                    this.pd.setMessage("L'azione " + nomeop + " non pu&ograve; essere aggiunta poich&egrave; il servizio " + pt.getNome() + " possiede azioni che risultano correlate in profili asincroni (correlazione verso altri servizi)");
                    return false;
                }
            }
            if (profcollop.equals(CostantiRegistroServizi.ONEWAY.getValue()) && opTypeOp != null && !opTypeOp.equals("input")) {
                this.pd.setMessage("L'operationType di tipo " + opTypeOp + " non pu&ograve; essere utilizzata con l'azione " + nomeop + " poich&egrave; possiede un profilo " + profcollop);
                return false;
            }
            if (profcollop.equals(CostantiRegistroServizi.SINCRONO.getValue()) && opTypeOp != null && !opTypeOp.equals("inputOutput")) {
                this.pd.setMessage("L'operationType di tipo " + opTypeOp + " non pu&ograve; essere utilizzata con l'azione " + nomeop + " poich&egrave; possiede un profilo " + profcollop);
                return false;
            }
            if (nsWSDLOp != null && !nsWSDLOp.equals("")) {
                if (nsWSDLOp.indexOf(" ") != -1) {
                    this.pd.setMessage("Il campo Namespace non pu&ograve; contenere spazi");
                    return false;
                }
                try {
                    URI.create(nsWSDLOp);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il campo Namespace non contiene una URI valida");
                    return false;
                }
            }
            if (soapActionOp != null && !soapActionOp.equals("") && soapActionOp.indexOf(" ") != -1) {
                this.pd.setMessage("Il campo SOAPAction non pu&ograve; contenere spazi");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiPorttypeOperationToDati(List<DataElement> dati, String id, String nomept, String nomeop, String profProtocollo, String filtrodupop, String deffiltrodupop, String confricop, String defconfricop, String idcollop, String defidcollop, String idRifRichiestaOp, String defIdRifRichiestaOp, String consordop, String defconsordop, String scadenzaop, String defscadenzaop, TipoOperazione tipoOperazione, String defProfiloCollaborazioneOp, String profiloCollaborazioneOp, String opcorr, String[] opList, String stato, String tipoSICA, String[] servCorrList, String servcorr, String[] aziCorrList, String azicorr, String protocollo, String soapActionOp, String styleOp, String useOp, String nsWSDLOp, String operationTypeOp, int messageInputCnt, int messageOutputCnt, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws Exception {
        try {
            boolean modificheAbilitate = false;
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                modificheAbilitate = true;
            } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
                modificheAbilitate = true;
            } else if (!StatiAccordo.finale.toString().equals(stato)) {
                modificheAbilitate = true;
            }
            DataElement de = new DataElement();
            de.setValue(tipoSICA);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoAccordo");
            dati.add(de);
            de = new DataElement();
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setValue(nomept);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomept");
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Azione");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nomeop);
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.TEXT);
            }
            de.setName("nomeop");
            de.setSize(this.getSize());
            dati.add(de);
            ArrayList<DataElement> dataElements = new ArrayList<DataElement>();
            if (this.core.isShowCorrelazioneAsincronaInAccordi()) {
                de = new DataElement();
                de.setLabel("Correlata al servizio");
                de.setName("servcorr");
                if (servCorrList != null && (profProtocollo.equals("default") && (defProfiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO) || defProfiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO)) || profProtocollo.equals("ridefinito") && (profiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO) || profiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO)))) {
                    de.setType(DataElementType.SELECT);
                    de.setValues(servCorrList);
                    de.setSelected(servcorr);
                    de.setPostBack(true);
                    dataElements.add(de);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(servcorr);
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Correlata all'azione");
                de.setName("azicorr");
                if (aziCorrList != null && (profProtocollo.equals("default") && (defProfiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO) || defProfiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO)) || profProtocollo.equals("ridefinito") && (profiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO) || profiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO)))) {
                    de.setType(DataElementType.SELECT);
                    de.setValues(aziCorrList);
                    de.setSelected(azicorr);
                    if (servcorr != null && !"".equals(servcorr) && !"-".equals(servcorr) && modificheAbilitate) {
                        de.setRequired(true);
                    }
                    dataElements.add(de);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(azicorr);
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setLabel("Azione correlata");
                de.setName("opcorrelata");
                if (opList != null && (profProtocollo.equals("default") && defProfiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO) || profProtocollo.equals("ridefinito") && profiloCollaborazioneOp.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO))) {
                    de.setType(DataElementType.SELECT);
                    de.setValues(opList);
                    de.setSelected(opcorr);
                    dataElements.add(de);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(opcorr);
                    dati.add(de);
                }
            }
            boolean filtroDuplicatiSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.FILTRO_DUPLICATI);
            boolean confermaRicezioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONFERMA_RICEZIONE);
            boolean collaborazioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.COLLABORAZIONE);
            boolean idRiferimentoRichiestaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA);
            boolean consegnaInOrdineSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONSEGNA_IN_ORDINE);
            boolean scadenzaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.SCADENZA);
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Informazioni Protocollo");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Profilo");
            de.setType(DataElementType.SELECT);
            de.setName("profBusta");
            if (modificheAbilitate) {
                de.setValues(AccordiServizioParteComuneCostanti.INFORMAZIONI_PROTOCOLLO_MODALITA);
                de.setLabels(AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_PORT_TYPE);
                de.setSelected(profProtocollo);
                de.setPostBack(true);
            } else {
                de.setType(DataElementType.TEXT);
                if (profProtocollo.equals("default")) {
                    de.setValue("profilo servizio");
                } else {
                    de.setValue("ridefinito");
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Profilo di collaborazione");
            de.setName("profcollop");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defProfiloCollaborazioneOp);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(this.core.getProfiliDiCollaborazioneSupportatiDalProtocollo(protocollo, serviceBinding));
                de.setSelected(profiloCollaborazioneOp);
                de.setPostBack(true);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Filtro Duplicati");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(deffiltrodupop);
            } else if ("ridefinito".equals(profProtocollo) && !filtroDuplicatiSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)filtrodupop)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)filtrodupop)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("filtrodupop");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Conferma Ricezione");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defconfricop);
            } else if ("ridefinito".equals(profProtocollo) && !confermaRicezioneSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)confricop)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)confricop)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("confricop");
            dati.add(de);
            de = new DataElement();
            de.setLabel("ID Conversazione");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defidcollop);
            } else if ("ridefinito".equals(profProtocollo) && !collaborazioneSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idcollop)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idcollop)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("idcollop");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Riferimento ID Richiesta");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defIdRifRichiestaOp);
            } else if ("ridefinito".equals(profProtocollo) && !idRiferimentoRichiestaSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaOp)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaOp)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("idRifReqOp");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Consegna in Ordine");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defconsordop);
            } else if ("ridefinito".equals(profProtocollo) && !consegnaInOrdineSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)consordop)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)consordop)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("consordop");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Scadenza");
            de.setValue(scadenzaop);
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defscadenzaop);
            } else if ("ridefinito".equals(profProtocollo) && !scadenzaSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defscadenzaop);
            } else {
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(scadenzaop);
                if (!modificheAbilitate && (scadenzaop == null || "".equals(scadenzaop))) {
                    de.setValue(" ");
                }
            }
            de.setName("scadenzaop");
            de.setSize(this.getSize());
            dati.add(de);
            if (dataElements.size() > 0) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Correlazione asincrona");
                dati.add(de);
                while (dataElements.size() > 0) {
                    dati.add((DataElement)dataElements.remove(0));
                }
            }
            if (this.isModalitaAvanzata()) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Informazioni WSDL");
                dati.add(de);
                de = new DataElement();
                de.setLabel("SOAPAction");
                de.setValue(soapActionOp);
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("soapactionop");
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Style");
                de.setType(DataElementType.SELECT);
                de.setName("styleop");
                de.setValues(AccordiServizioParteComuneCostanti.PORT_TYPES_OPERATION_STYLE);
                de.setLabels(AccordiServizioParteComuneCostanti.LABEL_PORT_TYPES_OPERATION_STYLE);
                de.setSelected(styleOp);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Use");
                de.setType(DataElementType.SELECT);
                de.setName("useop");
                de.setValues(AccordiServizioParteComuneCostanti.PORT_TYPES_OPERATION_USE);
                de.setLabels(AccordiServizioParteComuneCostanti.LABEL_PORT_TYPES_OPERATION_USE);
                de.setSelected(useOp);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Namespace");
                de.setValue(nsWSDLOp);
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("nswsdlop");
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("OperationType");
                if (!profiloCollaborazioneOp.equalsIgnoreCase(CostantiRegistroServizi.ONEWAY.getValue()) && !profiloCollaborazioneOp.equalsIgnoreCase(CostantiRegistroServizi.SINCRONO.getValue())) {
                    de.setType(DataElementType.SELECT);
                    de.setName("typeop");
                    de.setValues(AccordiServizioParteComuneCostanti.PORT_TYPE_OPERATION_TYPE);
                    de.setLabels(AccordiServizioParteComuneCostanti.LABEL_PORT_TYPE_OPERATION_TYPE);
                    de.setSelected(operationTypeOp);
                    de.setPostBack(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setName("typeop");
                    de.setValue(operationTypeOp);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("OperationType");
                    de.setType(DataElementType.TEXT);
                    de.setValue(operationTypeOp);
                }
                dati.add(de);
                if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("accordiServizioParteComunePortTypeOperationsMessageList.do", new Parameter[]{new Parameter("id", id), new Parameter("tipoAccordo", tipoSICA), new Parameter("nomept", nomept), new Parameter("nomeop", nomeop), new Parameter("msgop", "i")});
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"MessageInput", (Long)Long.valueOf(messageInputCnt));
                    dati.add(de);
                    if (operationTypeOp.equals("inputOutput")) {
                        de = new DataElement();
                        de.setType(DataElementType.LINK);
                        de.setUrl("accordiServizioParteComunePortTypeOperationsMessageList.do", new Parameter[]{new Parameter("id", id), new Parameter("tipoAccordo", tipoSICA), new Parameter("nomept", nomept), new Parameter("nomeop", nomeop), new Parameter("msgop", "o")});
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"MessageOutput", (Long)Long.valueOf(messageOutputCnt));
                        dati.add(de);
                    }
                }
            }
            return dati;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiPorttypeList(String idApc, AccordoServizioParteComune as, List<PortType> lista, ISearch ricerca, String tipoAccordo) throws Exception {
        try {
            Object labelPortTypes;
            String uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", idApc);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComunePortTypes", (Parameter[])new Parameter[]{pIdAccordo, pTipoAccordo, pNomeAccordo});
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            int idLista = Liste.ACCORDI_PORTTYPE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object object = labelPortTypes = isModalitaVistaApiCustom != false ? "Servizi" : "Servizi di " + labelASTitle;
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter((String)labelPortTypes, null));
            } else {
                listaParams.add(new Parameter((String)labelPortTypes, "accordiServizioParteComunePortTypesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Servizi", (String)search);
            }
            String[] labels = new String[]{"Nome", "Descrizione", "Azioni", "Uso"};
            this.pd.setLabels(labels);
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            boolean existsBigDescription = false;
            if (lista != null) {
                for (PortType pt : lista) {
                    if (pt.getDescrizione() == null || pt.getDescrizione().length() <= 30) continue;
                    existsBigDescription = true;
                    break;
                }
                for (PortType pt : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiServizioParteComunePortTypesChange.do", new Parameter[]{new Parameter("id", idApc), new Parameter("nomept", pt.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    if (!existsBigDescription) {
                        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
                    }
                    de.setValue(pt.getNome());
                    de.setToolTip(pt.getNome());
                    de.setIdToRemove(pt.getNome());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(pt.getDescrizione());
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("accordiServizioParteComunePortTypeOperationsList.do", new Parameter[]{new Parameter("id", idApc), new Parameter("nomept", pt.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    if (contaListe.booleanValue()) {
                        int idPortType = 0;
                        for (int i = 0; i < as.sizePortTypeList(); ++i) {
                            PortType pt1 = as.getPortType(i);
                            if (!pt.getNome().equals(pt1.getNome())) continue;
                            idPortType = pt1.getId().intValue();
                            break;
                        }
                        ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                        this.apcCore.accordiPorttypeOperationList(idPortType, (ISearch)searchForCount);
                        int num = searchForCount.getNumEntries(Liste.ACCORDI_PORTTYPE_AZIONI);
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(num));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    this.addInUsoButtonVisualizzazioneClassica(e, pt.getNome(), pt.getNome() + "@" + this.idAccordoFactory.getUriFromAccordo(as), InUsoType.PORT_TYPE);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiPorttypeCheckData(TipoOperazione tipoOperazione, String id, String nomept, String descr, String profProtocollo, String filtroduppt, String confricpt, String idcollpt, String idRifRichiestaPt, String consordpt, String scadenzapt) throws Exception {
        try {
            boolean giaRegistrato;
            if (nomept.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Nome");
                return false;
            }
            if (!this.checkLength255(nomept, "Nome")) {
                return false;
            }
            if (descr != null && !"".equals(descr) && !this.checkLength255(descr, "Descrizione")) {
                return false;
            }
            if (!this.checkNCName(nomept, "Nome")) {
                return false;
            }
            if (!profProtocollo.equals("default") && !profProtocollo.equals("ridefinito")) {
                this.pd.setMessage("Il profilo dev'essere \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO[0] + "\" o \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO[1] + "\"");
                return false;
            }
            if ("ridefinito".equals(profProtocollo)) {
                if (!(filtroduppt == null || filtroduppt.equals("yes") || filtroduppt.equals(CostantiRegistroServizi.ABILITATO.getValue()) || filtroduppt.equals("no") || filtroduppt.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Filtro Duplicati dev'essere selezionato o deselezionato");
                    return false;
                }
                if (!(confricpt == null || confricpt.equals("yes") || confricpt.equals(CostantiRegistroServizi.ABILITATO.getValue()) || confricpt.equals("no") || confricpt.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Conferma Ricezione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!(idcollpt == null || idcollpt.equals("yes") || idcollpt.equals(CostantiRegistroServizi.ABILITATO.getValue()) || idcollpt.equals("no") || idcollpt.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("ID Conversazione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!(idRifRichiestaPt == null || idRifRichiestaPt.equals("yes") || idRifRichiestaPt.equals(CostantiRegistroServizi.ABILITATO.getValue()) || idRifRichiestaPt.equals("no") || idRifRichiestaPt.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Riferimento ID Richiesta dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!(consordpt == null || consordpt.equals("yes") || consordpt.equals(CostantiRegistroServizi.ABILITATO.getValue()) || consordpt.equals("no") || consordpt.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                    this.pd.setMessage("Consegna in Ordine dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!scadenzapt.equals("") && !this.checkNumber(scadenzapt, "Scadenza", false)) {
                    return false;
                }
            }
            if (tipoOperazione.equals((Object)TipoOperazione.ADD) && (giaRegistrato = this.apcCore.existsAccordoServizioPorttype(nomept, Integer.parseInt(id)))) {
                this.pd.setMessage("Il servizio " + nomept + " &egrave; gi&agrave; stato associato alla API");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiPorttypeToDati(List<DataElement> dati, String id, String nomept, String profProtocollo, String filtroduppt, String deffiltroduppt, String confricpt, String defconfricpt, String idcollpt, String defidcollpt, String idRifRichiestaPt, String defIdRifRichiestaPt, String consordpt, String defconsordpt, String scadenzapt, String defscadenzapt, TipoOperazione tipoOperazione, String defProfiloCollaborazionePT, String profiloCollaborazionePT, String descr, String stato, String tipoAccordo, String protocollo, String servizioStyle, org.openspcoop2.message.constants.ServiceBinding serviceBinding, IProtocolFactory<?> protocolFactory, MessageType messageType) throws Exception {
        try {
            boolean modificheAbilitate = false;
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                modificheAbilitate = true;
            } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
                modificheAbilitate = true;
            } else if (!StatiAccordo.finale.toString().equals(stato)) {
                modificheAbilitate = true;
            }
            DataElement de = new DataElement();
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setValue(tipoAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoAccordo");
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Servizio");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nomept);
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.TEXT);
            }
            de.setName("nomept");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Descrizione");
            de.setValue(descr);
            de.setType(DataElementType.TEXT_EDIT);
            if (!modificheAbilitate && (descr == null || "".equals(descr))) {
                de.setValue(" ");
            }
            de.setName("descr");
            de.setSize(this.getSize());
            dati.add(de);
            dati.add(this.getMessageTypeDataElement("messageTypePT", protocolFactory, serviceBinding, messageType));
            if (this.isModalitaStandard()) {
                profProtocollo = "ridefinito";
            }
            boolean filtroDuplicatiSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.FILTRO_DUPLICATI);
            boolean confermaRicezioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONFERMA_RICEZIONE);
            boolean collaborazioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.COLLABORAZIONE);
            boolean idRiferimentoRichiestaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA);
            boolean consegnaInOrdineSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONSEGNA_IN_ORDINE);
            boolean scadenzaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.SCADENZA);
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Informazioni Protocollo");
            dati.add(de);
            if (this.isModalitaStandard()) {
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("profBusta");
                de.setValue("ridefinito");
                dati.add(de);
                profProtocollo = "ridefinito";
            } else {
                de = new DataElement();
                de.setLabel("Profilo");
                de.setType(DataElementType.SELECT);
                de.setName("profBusta");
                if (modificheAbilitate) {
                    de.setValues(AccordiServizioParteComuneCostanti.INFORMAZIONI_PROTOCOLLO_MODALITA);
                    de.setLabels(AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO);
                    de.setSelected(profProtocollo);
                    de.setPostBack(true);
                } else {
                    de.setType(DataElementType.TEXT);
                    if (profProtocollo.equals("default")) {
                        de.setValue("profilo API");
                    } else {
                        de.setValue("ridefinito");
                    }
                }
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Profilo di collaborazione");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defProfiloCollaborazionePT);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(this.core.getProfiliDiCollaborazioneSupportatiDalProtocollo(protocollo, serviceBinding));
                de.setSelected(profiloCollaborazionePT);
            }
            de.setName("profcollpt");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Filtro Duplicati");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(deffiltroduppt);
            } else if (!filtroDuplicatiSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)filtroduppt) || CostantiRegistroServizi.ABILITATO.equals(filtroduppt)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)filtroduppt) || CostantiRegistroServizi.ABILITATO.equals(filtroduppt)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("filtroduppt");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Conferma Ricezione");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defconfricpt);
            } else if (!confermaRicezioneSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)confricpt) || CostantiRegistroServizi.ABILITATO.equals(confricpt)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)confricpt) || CostantiRegistroServizi.ABILITATO.equals(confricpt)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("confricpt");
            dati.add(de);
            de = new DataElement();
            de.setLabel("ID Conversazione");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defidcollpt);
            } else if (!collaborazioneSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idcollpt) || CostantiRegistroServizi.ABILITATO.equals(idcollpt)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idcollpt) || CostantiRegistroServizi.ABILITATO.equals(idcollpt)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("idcollpt");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Riferimento ID Richiesta");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defIdRifRichiestaPt);
            } else if (!idRiferimentoRichiestaSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaPt) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiestaPt)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaPt) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiestaPt)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("idRifReqPt");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Consegna in Ordine");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defconsordpt);
            } else if (!consegnaInOrdineSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)consordpt) || CostantiRegistroServizi.ABILITATO.equals(consordpt)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)consordpt) || CostantiRegistroServizi.ABILITATO.equals(consordpt)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("consordpt");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Scadenza");
            de.setValue(scadenzapt);
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defscadenzapt);
            } else if (!scadenzaSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defscadenzapt);
            } else {
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(scadenzapt);
                if (!modificheAbilitate && (scadenzapt == null || "".equals(scadenzapt))) {
                    de.setValue(" ");
                }
            }
            de.setName("scadenzapt");
            de.setSize(this.getSize());
            dati.add(de);
            if (!this.isModalitaStandard()) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Informazioni WSDL");
                dati.add(de);
                de = new DataElement();
                de.setLabel("Style");
                de.setType(DataElementType.SELECT);
                de.setName("stylept");
                de.setValues(AccordiServizioParteComuneCostanti.PORT_TYPES_STYLE);
                de.setLabels(AccordiServizioParteComuneCostanti.LABEL_PORT_TYPES_STYLE);
                de.setSelected(servizioStyle);
                dati.add(de);
            }
            return dati;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiAzioniList(AccordoServizioParteComune as, List<Azione> lista, ISearch ricerca, String idAs, String tipoAccordo) throws Exception {
        try {
            String uri = null;
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneAzioni", (Parameter[])new Parameter[]{new Parameter("id", idAs), new Parameter("tipoAccordo", tipoAccordo), new Parameter("nome", uri)});
            int idLista = Liste.ACCORDI_AZIONI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo), "accordiServizioParteComuneList.do?" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getName() + "=" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getValue()), new Parameter("Azioni di " + labelASTitle, null)});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo), "accordiServizioParteComuneList.do?" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getName() + "=" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getValue()), new Parameter("Azioni di " + labelASTitle, "accordiServizioParteComuneAzioniList.do?id=" + idAs + "&nome=" + uri + "&" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getName() + "=" + AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo).getValue()), new Parameter("Risultati ricerca", null)});
            }
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Azioni", (String)search);
            }
            String[] labels = new String[]{"Nome", "Profilo"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Azione az : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiServizioParteComuneAzioniChange.do", new Parameter[]{new Parameter("id", idAs), new Parameter("nomeaz", az.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    de.setValue(az.getNome());
                    de.setIdToRemove(az.getNome());
                    e.add(de);
                    de = new DataElement();
                    if (az.getProfAzione().equals("default")) {
                        de.setValue("profilo API");
                    } else {
                        de.setValue(az.getProfAzione());
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiAzioniCheckData(TipoOperazione tipoOperazione, String id, String nomeaz, String profProtocollo, String filtrodupaz, String confricaz, String idcollaz, String idRifRichiestaAz, String consordaz, String scadenzaaz) throws Exception {
        try {
            int idInt;
            boolean giaRegistrato;
            if (filtrodupaz != null && (filtrodupaz.equals("null") || filtrodupaz.equals("no"))) {
                filtrodupaz = null;
            }
            if (confricaz != null && (confricaz.equals("null") || confricaz.equals("no"))) {
                confricaz = null;
            }
            if (idcollaz != null && (idcollaz.equals("null") || idcollaz.equals("no"))) {
                idcollaz = null;
            }
            if (idRifRichiestaAz != null && (idRifRichiestaAz.equals("null") || idRifRichiestaAz.equals("no"))) {
                idRifRichiestaAz = null;
            }
            if (consordaz != null && (consordaz.equals("null") || consordaz.equals("no"))) {
                consordaz = null;
            }
            if (nomeaz.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Nome");
                return false;
            }
            if (nomeaz.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel nome dell'azione");
                return false;
            }
            if (!this.checkLength255(nomeaz, "Nome")) {
                return false;
            }
            if (!this.checkNCName(nomeaz, "Nome")) {
                return false;
            }
            if (!profProtocollo.equals("default") && !profProtocollo.equals("ridefinito")) {
                this.pd.setMessage("Il profilo  dev'essere \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO[0] + "\" o \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO[1] + "\"");
                return false;
            }
            if (profProtocollo.equals("ridefinito")) {
                if (filtrodupaz != null && !filtrodupaz.equals("yes")) {
                    this.pd.setMessage("Filtro Duplicati dev'essere selezionato o deselezionato");
                    return false;
                }
                if (confricaz != null && !confricaz.equals("yes")) {
                    this.pd.setMessage("Conferma Ricezione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (idcollaz != null && !idcollaz.equals("yes")) {
                    this.pd.setMessage("ID Conversazione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (idRifRichiestaAz != null && !idRifRichiestaAz.equals("yes")) {
                    this.pd.setMessage("Riferimento ID Richiesta dev'essere selezionata o deselezionata");
                    return false;
                }
                if (consordaz != null && !consordaz.equals("yes")) {
                    this.pd.setMessage("Consegna in Ordine dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!scadenzaaz.equals("") && !this.checkNumber(scadenzaaz, "Scadenza", false)) {
                    return false;
                }
            }
            if (tipoOperazione.equals((Object)TipoOperazione.ADD) && (giaRegistrato = this.apcCore.existsAccordoServizioAzione(nomeaz, idInt = Integer.parseInt(id)))) {
                this.pd.setMessage("L'azione " + nomeaz + " &egrave; gi&agrave; stata associata alla API " + id);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiAzioniToDati(List<DataElement> dati, String id, String nomeaz, String profProtocollo, String filtrodupaz, String deffiltrodupaz, String confricaz, String defconfricaz, String idcollaz, String defidcollaz, String idRifRichiestaAz, String defIdRifRichiestaAz, String consordaz, String defconsordaz, String scadenzaaz, String defscadenzaaz, String defprofcoll, String profcoll, TipoOperazione tipoOperazione, String azicorr, String[] azioniList, String stato, String tipoSICA, String protocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws Exception {
        DataElement de = new DataElement();
        de.setValue(id);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        boolean modificheAbilitate = false;
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            modificheAbilitate = true;
        } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
            modificheAbilitate = true;
        } else if (!StatiAccordo.finale.toString().equals(stato)) {
            modificheAbilitate = true;
        }
        de = new DataElement();
        de.setValue(tipoSICA);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoAccordo");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Azione");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nomeaz);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nomeaz");
        de.setSize(this.getSize());
        dati.add(de);
        boolean filtroDuplicatiSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.FILTRO_DUPLICATI);
        boolean confermaRicezioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONFERMA_RICEZIONE);
        boolean collaborazioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.COLLABORAZIONE);
        boolean idRiferimentoRichiestaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA);
        boolean consegnaInOrdineSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONSEGNA_IN_ORDINE);
        boolean scadenzaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.SCADENZA);
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Informazioni Protocollo");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Azione correlata");
        if (azioniList != null && (profProtocollo.equals("default") && defprofcoll.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.toString()) || profProtocollo.equals("ridefinito") && profcoll.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.toString()))) {
            de.setType(DataElementType.SELECT);
            de.setValues(azioniList);
            de.setSelected(azicorr);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(azicorr);
        }
        de.setName("azicorr");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Profilo");
        if (modificheAbilitate) {
            de.setType(DataElementType.SELECT);
            de.setName("profBusta");
            de.setValues(AccordiServizioParteComuneCostanti.INFORMAZIONI_PROTOCOLLO_MODALITA);
            de.setLabels(AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO);
            de.setSelected(profProtocollo);
            de.setPostBack(true);
        } else {
            de.setType(DataElementType.TEXT);
            if (profProtocollo.equals("default")) {
                de.setValue("profilo API");
            } else {
                de.setValue("ridefinito");
            }
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Profilo di collaborazione");
        de.setName("profcollaz");
        if (profProtocollo.equals("default")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(defprofcoll);
        } else {
            de.setType(DataElementType.SELECT);
            de.setValues(this.core.getProfiliDiCollaborazioneSupportatiDalProtocollo(protocollo, serviceBinding));
            de.setSelected(profcoll);
            if (modificheAbilitate) {
                de.setPostBack(true);
            }
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Filtro Duplicati");
        if (profProtocollo.equals("default")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(deffiltrodupaz);
        } else if (profProtocollo.equals("ridefinito") && !filtroDuplicatiSupportato) {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        } else if (modificheAbilitate) {
            de.setType(DataElementType.CHECKBOX);
            if (ServletUtils.isCheckBoxEnabled((String)filtrodupaz) || CostantiRegistroServizi.ABILITATO.equals(filtrodupaz)) {
                de.setSelected(true);
            }
        } else {
            de.setType(DataElementType.TEXT);
            if (ServletUtils.isCheckBoxEnabled((String)filtrodupaz) || CostantiRegistroServizi.ABILITATO.equals(filtrodupaz)) {
                de.setValue(CostantiRegistroServizi.ABILITATO.toString());
            } else {
                de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
            }
        }
        de.setName("filtrodupaz");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Conferma Ricezione");
        if (profProtocollo.equals("default")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(defconfricaz);
        } else if (profProtocollo.equals("ridefinito") && !confermaRicezioneSupportato) {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        } else if (modificheAbilitate) {
            de.setType(DataElementType.CHECKBOX);
            if (ServletUtils.isCheckBoxEnabled((String)confricaz) || CostantiRegistroServizi.ABILITATO.equals(confricaz)) {
                de.setSelected(true);
            }
        } else {
            de.setType(DataElementType.TEXT);
            if (ServletUtils.isCheckBoxEnabled((String)confricaz) || CostantiRegistroServizi.ABILITATO.equals(confricaz)) {
                de.setValue(CostantiRegistroServizi.ABILITATO.toString());
            } else {
                de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
            }
        }
        de.setName("confricaz");
        dati.add(de);
        de = new DataElement();
        de.setLabel("ID Conversazione");
        if (profProtocollo.equals("default")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(defidcollaz);
        } else if (profProtocollo.equals("ridefinito") && !collaborazioneSupportato) {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        } else if (modificheAbilitate) {
            de.setType(DataElementType.CHECKBOX);
            if (ServletUtils.isCheckBoxEnabled((String)idcollaz) || CostantiRegistroServizi.ABILITATO.equals(idcollaz)) {
                de.setSelected(true);
            }
        } else {
            de.setType(DataElementType.TEXT);
            if (ServletUtils.isCheckBoxEnabled((String)idcollaz) || CostantiRegistroServizi.ABILITATO.equals(idcollaz)) {
                de.setValue(CostantiRegistroServizi.ABILITATO.toString());
            } else {
                de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
            }
        }
        de.setName("idcollaz");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Riferimento ID Richiesta");
        if (profProtocollo.equals("default")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(defIdRifRichiestaAz);
        } else if (profProtocollo.equals("ridefinito") && !idRiferimentoRichiestaSupportato) {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        } else if (modificheAbilitate) {
            de.setType(DataElementType.CHECKBOX);
            if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaAz) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiestaAz)) {
                de.setSelected(true);
            }
        } else {
            de.setType(DataElementType.TEXT);
            if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaAz) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiestaAz)) {
                de.setValue(CostantiRegistroServizi.ABILITATO.toString());
            } else {
                de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
            }
        }
        de.setName("idRifReqAz");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Consegna in Ordine");
        if (profProtocollo.equals("default")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(defconsordaz);
        } else if (profProtocollo.equals("ridefinito") && !consegnaInOrdineSupportato) {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        } else if (modificheAbilitate) {
            de.setType(DataElementType.CHECKBOX);
            if (ServletUtils.isCheckBoxEnabled((String)consordaz) || CostantiRegistroServizi.ABILITATO.equals(consordaz)) {
                de.setSelected(true);
            }
        } else {
            de.setType(DataElementType.TEXT);
            if (ServletUtils.isCheckBoxEnabled((String)consordaz) || CostantiRegistroServizi.ABILITATO.equals(consordaz)) {
                de.setValue(CostantiRegistroServizi.ABILITATO.toString());
            } else {
                de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
            }
        }
        de.setName("consordaz");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Scadenza");
        de.setValue(scadenzaaz);
        if (profProtocollo.equals("default")) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(defscadenzaaz);
        } else if (profProtocollo.equals("ridefinito") && !scadenzaSupportato) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(defscadenzaaz);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(scadenzaaz);
            if (!modificheAbilitate && (scadenzaaz == null || "".equals(scadenzaaz))) {
                de.setValue(" ");
            }
        }
        de.setName("scadenzaaz");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public void addAccordiWSDLChangeToDati(List<DataElement> dati, String id, String tipoAccordo, String tipo, String label, String oldwsdl, String statoPackage, boolean validazioneDocumenti, String tipologiaDocumentoScaricare, org.openspcoop2.message.constants.ServiceBinding serviceBinding, boolean aggiornaEsistenti, boolean eliminaNonPresentiNuovaInterfaccia) throws Exception {
        String gestioneParziale = this.getParametroApiGestioneParziale("apiGestioneParziale");
        if (gestioneParziale == null) {
            gestioneParziale = "";
        }
        boolean nascondiSezioneDownload = gestioneParziale.equals("apiWsdlChange");
        DataElement de = new DataElement();
        Object labelWSDL = label;
        Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
        if (!isModalitaVistaApiCustom.booleanValue()) {
            labelWSDL = label.contains(" di ") ? label.split(" di")[0] : tipologiaDocumentoScaricare.toUpperCase().charAt(0) + tipologiaDocumentoScaricare.substring(1);
        }
        de = new DataElement();
        de.setLabel("id");
        de.setValue(id);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        de = new DataElement();
        de.setValue(tipoAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoAccordo");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("tipo");
        de.setValue(tipo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipo");
        dati.add(de);
        de = new DataElement();
        de.setLabel("apiGestioneParziale");
        de.setType(DataElementType.HIDDEN);
        de.setName("apiGestioneParziale");
        de.setValue(gestioneParziale);
        dati.add(de);
        if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(statoPackage)) {
            this.pd.disableEditMode();
            if (!nascondiSezioneDownload) {
                de = new DataElement();
                de.setLabel((String)labelWSDL);
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            if (this.core.isShowInterfacceAPI()) {
                de = new DataElement();
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                de.setValue(oldwsdl);
                de.setRows(30);
                de.setCols(110);
                de.setLabel("");
                dati.add(de);
            }
            if (oldwsdl != null && !oldwsdl.isEmpty()) {
                DataElement saveAs = new DataElement();
                saveAs.setValue("Download");
                saveAs.setType(DataElementType.LINK);
                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", id), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("tipoDocumento", "aspc")});
                saveAs.setDisabilitaAjaxStatus();
                dati.add(saveAs);
            } else {
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                dati.add(de);
            }
        } else {
            if (oldwsdl != null && !oldwsdl.isEmpty()) {
                if (!nascondiSezioneDownload) {
                    de = new DataElement();
                    de.setLabel((String)labelWSDL);
                    de.setType(DataElementType.TITLE);
                    dati.add(de);
                    if (this.core.isShowInterfacceAPI()) {
                        de = new DataElement();
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                        de.setValue(oldwsdl);
                        de.setRows(30);
                        de.setCols(110);
                        dati.add(de);
                    }
                    DataElement saveAs = new DataElement();
                    saveAs.setValue("Download");
                    saveAs.setType(DataElementType.LINK);
                    saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", id), new Parameter("tipoDocumentoDaScaricare", tipologiaDocumentoScaricare), new Parameter("tipoDocumento", "aspc")});
                    saveAs.setDisabilitaAjaxStatus();
                    dati.add(saveAs);
                }
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Aggiornamento " + (String)labelWSDL);
                de.setValue("");
                de.setSize(this.getSize());
                dati.add(de);
            } else {
                if (gestioneParziale != null && !"".equals(gestioneParziale)) {
                    de = new DataElement();
                    de.setType(DataElementType.TITLE);
                    de.setLabel("Interfaccia " + (String)labelWSDL);
                    de.setValue("");
                    de.setSize(this.getSize());
                    dati.add(de);
                } else if (!nascondiSezioneDownload) {
                    de = new DataElement();
                    de.setLabel((String)labelWSDL);
                    de.setType(DataElementType.TITLE);
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Attuale");
                de.setType(DataElementType.TEXT);
                de.setValue("non fornito");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Validazione Specifica");
            de.setValue("" + validazioneDocumenti);
            if (this.isModalitaAvanzata()) {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(validazioneDocumenti);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("validazioneDocumenti");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nuovo");
            de.setValue("");
            de.setType(DataElementType.FILE);
            de.setName("wsdl");
            de.setSize(this.getSize());
            dati.add(de);
            if (oldwsdl != null && !oldwsdl.isEmpty()) {
                de = new DataElement();
                de.setBold(true);
                de.setLabel("Attenzione");
                de.setValue("Se si desidera eliminare un documento precedentemente caricato cliccare su 'Salva' senza selezionare alcun file");
                de.setType(DataElementType.NOTE);
                de.setName("wsdlWarn");
                de.setSize(this.getSize());
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("");
            switch (serviceBinding) {
                case REST: {
                    de.setLabelRight("Le risorse esistenti vengono aggiornate");
                    break;
                }
                case SOAP: {
                    de.setLabelRight("Le azioni esistenti vengono aggiornate");
                }
            }
            de.setValue("" + aggiornaEsistenti);
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(aggiornaEsistenti);
            de.setName("wsdlAggiorna");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("");
            switch (serviceBinding) {
                case REST: {
                    de.setLabelRight("Elimina le risorse non presenti nella nuova interfaccia");
                    break;
                }
                case SOAP: {
                    de.setLabelRight("Elimina i servizi e le azioni non presenti nella nuova interfaccia");
                }
            }
            de.setValue("" + eliminaNonPresentiNuovaInterfaccia);
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(eliminaNonPresentiNuovaInterfaccia);
            de.setName("wsdlElimina");
            de.setSize(this.getSize());
            dati.add(de);
        }
    }

    public void addAccordiWSDLChangeToDatiAsHidden(List<DataElement> dati, String id, String tipoAccordo, String tipo, String label, String oldwsdl, String statoPackage, boolean validazioneDocumenti) {
        DataElement de = new DataElement();
        de.setLabel("id");
        de.setValue(id);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        de = new DataElement();
        de.setValue(tipoAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoAccordo");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("tipo");
        de.setValue(tipo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipo");
        dati.add(de);
        if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(statoPackage)) {
            this.pd.disableEditMode();
        } else {
            de = new DataElement();
            de.setLabel("Validazione Specifica");
            de.setValue("" + validazioneDocumenti);
            de.setType(DataElementType.HIDDEN);
            de.setName("validazioneDocumenti");
            dati.add(de);
        }
    }

    public boolean accordiWSDLCheckData(PageData pd, String tipo, String wsdl, AccordoServizioParteComune as, boolean validazioneDocumenti, String protocollo) throws Exception {
        if (validazioneDocumenti) {
            ValidazioneResult result;
            boolean validazioneParteComune = false;
            boolean validazioneSpecificaConversazione = false;
            FormatoSpecifica formato = null;
            if (as != null) {
                formato = as.getFormatoSpecifica();
            }
            if (tipo.equals("wsdldef")) {
                tmp = this.apcCore.getInterfaceAsByteArray(formato, wsdl);
                if (as != null) {
                    as.setByteWsdlDefinitorio(tmp);
                }
                validazioneParteComune = true;
            } else if (tipo.equals("wsdlconc")) {
                tmp = this.apcCore.getInterfaceAsByteArray(formato, wsdl);
                if (as != null) {
                    as.setByteWsdlConcettuale(tmp);
                }
                validazioneParteComune = true;
            } else if (tipo.equals("wsdlserv")) {
                tmp = this.apcCore.getInterfaceAsByteArray(formato, wsdl);
                if (as != null) {
                    as.setByteWsdlLogicoErogatore(tmp);
                }
                validazioneParteComune = true;
            } else if (tipo.equals("wsdlservcorr")) {
                tmp = this.apcCore.getInterfaceAsByteArray(formato, wsdl);
                if (as != null) {
                    as.setByteWsdlLogicoFruitore(tmp);
                }
                validazioneParteComune = true;
            } else if (tipo.equals("wsblconc")) {
                tmp = this.apcCore.getInterfaceAsByteArray(formato, wsdl);
                if (as != null) {
                    as.setByteSpecificaConversazioneConcettuale(tmp);
                }
                validazioneSpecificaConversazione = true;
            } else if (tipo.equals("wsblserv")) {
                tmp = this.apcCore.getInterfaceAsByteArray(formato, wsdl);
                if (as != null) {
                    as.setByteSpecificaConversazioneErogatore(tmp);
                }
                validazioneSpecificaConversazione = true;
            } else if (tipo.equals("wsblservcorr")) {
                tmp = this.apcCore.getInterfaceAsByteArray(formato, wsdl);
                if (as != null) {
                    as.setByteSpecificaConversazioneFruitore(tmp);
                }
                validazioneSpecificaConversazione = true;
            }
            if (validazioneParteComune) {
                result = this.apcCore.validaInterfacciaWsdlParteComune(as, protocollo);
                if (!result.isEsito()) {
                    String msgErroreHTML = result.getMessaggioErrore();
                    if (msgErroreHTML != null) {
                        msgErroreHTML = msgErroreHTML.replaceAll("\n", "<br/>");
                    }
                    pd.setMessage(msgErroreHTML);
                } else if (result.getMessaggioWarning() != null && StringUtils.isNotEmpty((CharSequence)result.getMessaggioWarning())) {
                    String msgWarningHTML = result.getMessaggioWarning();
                    if (msgWarningHTML != null) {
                        msgWarningHTML = msgWarningHTML.replaceAll("\n", "<br/>");
                    }
                    this.pd.setMessage(msgWarningHTML, org.openspcoop2.web.lib.mvc.MessageType.WARN);
                }
                return result.isEsito();
            }
            if (validazioneSpecificaConversazione) {
                result = this.apcCore.validaSpecificaConversazione(as, protocollo);
                if (!result.isEsito()) {
                    pd.setMessage(result.getMessaggioErrore());
                }
                return result.isEsito();
            }
        }
        return true;
    }

    public List<DataElement> addAccordiToDati(List<DataElement> dati, String nome, String descr, String profcoll, BinaryParameter wsdldef, BinaryParameter wsdlconc, BinaryParameter wsdlserv, BinaryParameter wsdlservcorr, BinaryParameter wsblconc, BinaryParameter wsblserv, BinaryParameter wsblservcorr, String filtrodup, String confric, String idcoll, String idRifRichiesta, String consord, String scadenza, String id, TipoOperazione tipoOperazione, boolean showUtilizzoSenzaAzione, boolean utilizzoSenzaAzione, String referente, String versione, String[] providersList, String[] providersListLabel, boolean privato, boolean isServizioComposto, String[] accordiCooperazioneEsistenti, String[] accordiCooperazioneEsistentiLabel, String accordoCooperazione, String stato, String oldStato, String tipoAccordo, boolean validazioneDocumenti, String tipoProtocollo, List<String> listaTipiProtocollo, boolean used, boolean asWithAllegatiXSD, IProtocolFactory<?> protocolFactory, org.openspcoop2.message.constants.ServiceBinding serviceBinding, MessageType messageType, InterfaceType interfaceType, String gruppi, List<String> elencoGruppi, boolean gestioneNuovaVersione, int gestioneNuovaVersioneMin, boolean gestioneNuovaVersioneRidefinisciInterfaccia, long gestioneNuovaVersioneOldIdApc, boolean confirm, String canaleStato, String canale, List<CanaleConfigurazione> canaleList, boolean gestioneCanaliEnabled) throws Exception {
        boolean almostOneSupported;
        int num;
        ConsoleSearch searchForCount;
        Boolean contaListeObject;
        boolean contaListe;
        Boolean showAccordiAzioniObject = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ShowAccordiAzioni");
        boolean showAccordiAzioni = showAccordiAzioniObject != null && showAccordiAzioniObject != false;
        Boolean showAccordiCooperazioneObject = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ShowAccordiCooperazione");
        boolean showAccordiCooperazione = showAccordiCooperazioneObject != null && showAccordiCooperazioneObject != false;
        boolean isInterfacciaAvanzata = this.isModalitaAvanzata();
        boolean ripristinoStatoOperativo = this.core.isGestioneWorkflowStatoDocumentiRipristinoStatoOperativoDaFinale();
        boolean modificheAbilitate = false;
        if (tipoOperazione.equals((Object)TipoOperazione.ADD) || !this.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(oldStato)) {
            modificheAbilitate = true;
        }
        boolean modificaAbilitataServizioComposto = true;
        if ("asc".equals(tipoAccordo)) {
            modificaAbilitataServizioComposto = tipoOperazione.equals((Object)TipoOperazione.ADD);
        }
        boolean showServizioCompostoCheck = AccordiServizioParteComuneUtilities.showFlagServizioComposto();
        Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
        String apiGestioneParziale = this.getParametroApiGestioneParziale("apiGestioneParziale");
        DataElement de = new DataElement();
        de.setName("apiGestioneParziale");
        de.setValue(apiGestioneParziale);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        Parameter pApiGestioneParziale = null;
        pApiGestioneParziale = isModalitaVistaApiCustom != null && isModalitaVistaApiCustom != false ? new Parameter("apiGestioneParziale", apiGestioneParziale) : new Parameter("apiGestioneParziale", "");
        boolean gestioneInformazioniGenerali = false;
        boolean gestioneInformazioniProfilo = false;
        boolean gestioneSoggettoReferente = false;
        boolean gestioneDescrizione = false;
        boolean gestioneSpecificaInterfacce = false;
        boolean gestioneInformazioniProtocollo = false;
        boolean gestioneGruppi = false;
        boolean gestioneCanale = false;
        if (TipoOperazione.ADD.equals((Object)tipoOperazione) || isModalitaVistaApiCustom == null || !isModalitaVistaApiCustom.booleanValue()) {
            gestioneInformazioniGenerali = true;
            gestioneInformazioniProfilo = true;
            gestioneSoggettoReferente = true;
            gestioneDescrizione = true;
            gestioneSpecificaInterfacce = true;
            gestioneInformazioniProtocollo = true;
            gestioneGruppi = true;
            gestioneCanale = true;
        } else if ("apiInfoGenerali".equals(apiGestioneParziale)) {
            gestioneInformazioniGenerali = true;
        } else if ("apiProfilo".equals(apiGestioneParziale)) {
            gestioneInformazioniProfilo = true;
        } else if ("apiSoggettoReferente".equals(apiGestioneParziale)) {
            gestioneSoggettoReferente = true;
        } else if ("apiDescrizione".equals(apiGestioneParziale)) {
            gestioneDescrizione = true;
        } else if ("apiGestioneSpecificaInterfacce".equals(apiGestioneParziale)) {
            gestioneSpecificaInterfacce = true;
        } else if ("apiOpzioniAvanzate".equals(apiGestioneParziale)) {
            gestioneInformazioniProtocollo = true;
        } else if ("apiGruppi".equals(apiGestioneParziale)) {
            gestioneGruppi = true;
        } else if ("apiCanale".equals(apiGestioneParziale)) {
            gestioneCanale = true;
        }
        if (gestioneInformazioniProfilo) {
            // empty if block
        }
        if (gestioneNuovaVersione) {
            de = new DataElement();
            de.setValue("" + gestioneNuovaVersione);
            de.setType(DataElementType.HIDDEN);
            de.setName("apiNewVersion");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setValue("" + gestioneNuovaVersioneMin);
            de.setType(DataElementType.HIDDEN);
            de.setName("apiNewVersionMin");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setValue("" + gestioneNuovaVersioneOldIdApc);
            de.setType(DataElementType.HIDDEN);
            de.setName("apiNewVersionOldIdApc");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setValue(tipoAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoAccordo");
        de.setSize(this.getSize());
        dati.add(de);
        if (gestioneInformazioniGenerali) {
            de = new DataElement();
            String labelAccordoServizio = AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo);
            de.setLabel(labelAccordoServizio);
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && isModalitaVistaApiCustom != null && isModalitaVistaApiCustom.booleanValue() && gestioneSoggettoReferente) {
            de = new DataElement();
            de.setLabel("Soggetto Referente");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && isModalitaVistaApiCustom != null && isModalitaVistaApiCustom.booleanValue() && gestioneDescrizione) {
            de = new DataElement();
            de.setLabel("Descrizione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && isModalitaVistaApiCustom != null && isModalitaVistaApiCustom.booleanValue() && gestioneGruppi) {
            de = new DataElement();
            de.setLabel("Tags");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            de = new DataElement();
            de.setLabel("id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Profilo Interoperabilit\u00e0");
            if (gestioneInformazioniGenerali && listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
                boolean usedCheckForProtocollo = true;
                if (usedCheckForProtocollo) {
                    DataElement deLABEL = new DataElement();
                    deLABEL.setLabel("Profilo Interoperabilit\u00e0");
                    deLABEL.setType(DataElementType.TEXT);
                    deLABEL.setName("protocollo__label");
                    deLABEL.setValue(this.getLabelProtocollo(tipoProtocollo));
                    dati.add(deLABEL);
                    de.setValue(tipoProtocollo);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("protocollo");
                } else {
                    de.setLabel("Profilo Interoperabilit\u00e0");
                    de.setValues(listaTipiProtocollo);
                    de.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
                    de.setSelected(tipoProtocollo);
                    de.setType(DataElementType.SELECT);
                    de.setName("protocollo");
                    de.setPostBack(true);
                }
            } else {
                de.setValue(tipoProtocollo);
                de.setType(DataElementType.HIDDEN);
                de.setName("protocollo");
            }
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            de = new DataElement();
            if (!gestioneNuovaVersione && listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
                de.setLabel("Profilo Interoperabilit\u00e0");
                de.setValues(listaTipiProtocollo);
                de.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
                de.setSelected(tipoProtocollo);
                de.setType(DataElementType.SELECT);
                de.setName("protocollo");
                de.setPostBack(true);
            } else {
                de.setValue(tipoProtocollo);
                de.setType(DataElementType.HIDDEN);
                de.setName("protocollo");
            }
            de.setSize(this.getSize());
            dati.add(de);
        }
        boolean forceHiddenServiceBinding = !gestioneInformazioniGenerali;
        boolean usedCheckForServiceBinding = used;
        if (gestioneInformazioniGenerali && TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            usedCheckForServiceBinding = true;
        }
        if (gestioneNuovaVersione) {
            forceHiddenServiceBinding = true;
        }
        de = this.getServiceBindingDataElement(protocolFactory, usedCheckForServiceBinding, serviceBinding, forceHiddenServiceBinding);
        dati.add(de);
        boolean nascondiMessageType = !isInterfacciaAvanzata || !gestioneInformazioniGenerali;
        de = this.getMessageTypeDataElement("messageType", protocolFactory, serviceBinding, messageType, nascondiMessageType);
        dati.add(de);
        boolean showReferente = false;
        if (gestioneSoggettoReferente) {
            showReferente = showAccordiCooperazione && isServizioComposto ? true : this.apcCore.isSupportatoSoggettoReferente(protocolFactory.getProtocol());
        }
        de = new DataElement();
        if (TipoOperazione.ADD.equals((Object)tipoOperazione) || isModalitaVistaApiCustom == null || !isModalitaVistaApiCustom.booleanValue()) {
            de.setLabel("Soggetto Referente");
        } else {
            de.setLabel("Nome");
        }
        de.setName("referente");
        if (showReferente) {
            de.setPostBack(true);
            Soggetto sogg = null;
            if (referente != null && !"".equals(referente) && !"-".equals(referente) && Integer.parseInt(referente) > 0) {
                sogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(referente));
            }
            if (modificheAbilitate && modificaAbilitataServizioComposto && !gestioneNuovaVersione && !confirm) {
                de.setType(DataElementType.SELECT);
                de.setValues(providersList);
                de.setLabels(providersListLabel);
                if (referente != null && !"".equals(referente) && !"-".equals(referente)) {
                    de.setSelected(referente);
                } else {
                    de.setSelected("-");
                }
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(referente);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Soggetto Referente");
                de.setName("referenteLabelAccordo1.2");
                de.setType(DataElementType.TEXT);
                if (referente != null && !"".equals(referente) && !"-".equals(referente)) {
                    de.setValue(this.getLabelNomeSoggetto(tipoProtocollo, sogg.getTipo(), sogg.getNome()));
                } else {
                    de.setValue("-");
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(referente);
        }
        dati.add(de);
        if (showAccordiCooperazione && isServizioComposto) {
            de = new DataElement();
            de.setLabel("Accordo Cooperazione");
            de.setName("accordoCooperazione");
            if (gestioneInformazioniGenerali && modificheAbilitate && modificaAbilitataServizioComposto && !gestioneNuovaVersione) {
                de.setType(DataElementType.SELECT);
                de.setValues(accordiCooperazioneEsistenti);
                de.setLabels(accordiCooperazioneEsistentiLabel);
                de.setSelected(accordoCooperazione != null ? accordoCooperazione : "-");
                de.setRequired(true);
                de.setPostBack(true);
            } else {
                de = new DataElement();
                de.setLabel("Accordo Cooperazione");
                de.setName("accordoCooperazione");
                de.setType(DataElementType.HIDDEN);
                de.setValue(accordoCooperazione);
                if (gestioneInformazioniGenerali) {
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Accordo Cooperazione");
                    de.setType(DataElementType.TEXT);
                    for (int i = 0; i < accordiCooperazioneEsistenti.length; ++i) {
                        if (!accordiCooperazioneEsistenti[i].equals(accordoCooperazione)) continue;
                        de.setValue(accordiCooperazioneEsistentiLabel[i]);
                        break;
                    }
                }
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD) || gestioneInformazioniGenerali && modificheAbilitate) {
            if (gestioneNuovaVersione) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            }
        } else if (gestioneInformazioniGenerali) {
            de.setType(DataElementType.TEXT);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descr);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD) || gestioneDescrizione && modificheAbilitate) {
            de.setType(DataElementType.TEXT_AREA);
            if (gestioneDescrizione && !tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.setRows(15);
                de.setLabel("");
            }
        } else {
            if (gestioneDescrizione) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            if (!modificheAbilitate && StringUtils.isBlank((CharSequence)descr)) {
                de.setValue("");
            }
        }
        de.setName("descr");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tags");
        de.setValue(gruppi);
        de.setLabels(elencoGruppi);
        de.setValues(elencoGruppi);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD) || gestioneGruppi && modificheAbilitate) {
            de.setType(DataElementType.TEXT_EDIT);
        } else {
            if (gestioneGruppi) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            if (!modificheAbilitate && StringUtils.isBlank((CharSequence)gruppi)) {
                de.setValue("");
            }
        }
        de.setName("gruppi");
        de.setSize(this.getSize());
        if (modificheAbilitate) {
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.enableTags();
            } else {
                de.enableTags(true);
                if (!StringUtils.isBlank((CharSequence)gruppi)) {
                    List<String> tagsDisponibili = this.gruppiCore.getAllGruppiOrdinatiPerDataRegistrazione();
                    List<String> nomiGruppi = Arrays.asList(gruppi.split(","));
                    for (String nomeGruppo : nomiGruppi) {
                        int indexOf = tagsDisponibili.indexOf(nomeGruppo);
                        if (indexOf == -1) {
                            indexOf = 0;
                        }
                        de.addStatus(nomeGruppo, "label-info-" + (indexOf %= CostantiControlStation.NUMERO_GRUPPI_CSS.intValue()), "");
                    }
                }
            }
        }
        dati.add(de);
        this.addCanaleToDati(dati, tipoOperazione, canaleStato, canale, canaleList, gestioneCanaliEnabled, modificheAbilitate, gestioneCanale);
        de = new DataElement();
        if (gestioneInformazioniGenerali && modificheAbilitate) {
            de = this.getVersionDataElement("Versione", "versione", versione, false);
            if (gestioneNuovaVersione) {
                de.setMinValue(Integer.valueOf(gestioneNuovaVersioneMin));
            }
        } else {
            de.setName("versione");
            de.setLabel("Versione");
            de.setValue(versione);
            if (gestioneInformazioniGenerali) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Privato");
        if (privato) {
            de.setValue("yes");
            de.setSelected("yes");
        }
        if (this.core.isShowFlagPrivato() && modificheAbilitate && isInterfacciaAvanzata && gestioneInformazioniGenerali) {
            de.setType(DataElementType.CHECKBOX);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("privato");
        dati.add(de);
        if (this.core.isShowFlagPrivato() && !modificheAbilitate && isInterfacciaAvanzata && gestioneInformazioniGenerali) {
            de = new DataElement();
            de.setLabel("Visibilit\u00e0 API");
            de.setName("privatoLabel");
            if (privato) {
                de.setValue("privata");
            } else {
                de.setValue("pubblica");
            }
            dati.add(de);
        }
        if (showAccordiCooperazione) {
            de = new DataElement();
            de.setLabel("Servizio Composto");
            de.setName("isServizioComposto");
            de.setValue(isServizioComposto ? "yes" : "no");
            if (modificheAbilitate && showServizioCompostoCheck && gestioneInformazioniGenerali) {
                de.setSelected(isServizioComposto ? "yes" : "no");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        if (this.isShowGestioneWorkflowStatoDocumenti()) {
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(StatiAccordo.bozza.toString());
                de.setName("stato");
            } else if (!StatiAccordo.finale.toString().equals(oldStato) && gestioneInformazioniGenerali) {
                de.setType(DataElementType.SELECT);
                de.setValues(StatiAccordo.toArray());
                de.setLabels(StatiAccordo.toLabel());
                de.setSelected(stato);
                de.setName("stato");
            } else {
                if (gestioneInformazioniGenerali) {
                    DataElement deLabel = new DataElement();
                    deLabel.setType(DataElementType.TEXT);
                    deLabel.setLabel("Stato");
                    deLabel.setValue(StatiAccordo.upper((String)StatiAccordo.finale.toString()));
                    deLabel.setName("stato__label");
                    dati.add(deLabel);
                }
                de.setType(DataElementType.HIDDEN);
                de.setValue(StatiAccordo.finale.toString());
                de.setName("stato");
                if (ripristinoStatoOperativo && gestioneInformazioniGenerali) {
                    dati.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("accordiServizioParteComuneChange.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), new Parameter("backToStato", StatiAccordo.operativo.toString()), new Parameter("edit-mode", "in_progress")});
                    de.setValue("Ripristina Stato Operativo");
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(StatiAccordo.finale.toString());
            de.setName("stato");
        }
        dati.add(de);
        boolean showConversazioni = false;
        boolean showWsdlDefinitorio = false;
        boolean showWsdlAsincroni = false;
        if (isInterfacciaAvanzata && serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP)) {
            showConversazioni = tipoProtocollo != null ? this.apcCore.showConversazioni(tipoProtocollo, serviceBinding, interfaceType) : false;
            showConversazioni = showConversazioni && isInterfacciaAvanzata;
            showWsdlDefinitorio = this.apcCore.showWsdlDefinitorio(tipoProtocollo, serviceBinding, interfaceType);
            showWsdlAsincroni = this.core.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(tipoProtocollo, serviceBinding);
        }
        DataElement deValidazione = new DataElement();
        deValidazione.setLabel("Validazione Specifica");
        deValidazione.setValue("" + validazioneDocumenti);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD) && this.isModalitaAvanzata()) {
            deValidazione.setType(DataElementType.CHECKBOX);
            deValidazione.setSelected(validazioneDocumenti);
            if (showConversazioni || showWsdlDefinitorio || showWsdlAsincroni) {
                deValidazione.setLabel("Validazione Specifiche");
            }
        } else {
            deValidazione.setType(DataElementType.HIDDEN);
        }
        deValidazione.setName("validazioneDocumenti");
        deValidazione.setSize(this.getSize());
        if (!tipoOperazione.equals((Object)TipoOperazione.ADD) || showConversazioni) {
            dati.add(deValidazione);
        }
        boolean bl = contaListe = (contaListeObject = ServletUtils.getContaListeFromSession((HttpSession)this.session)) != null && contaListeObject != false;
        if (!tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            if (this.isModalitaCompleta()) {
                switch (serviceBinding) {
                    case REST: {
                        de = new DataElement();
                        de.setType(DataElementType.LINK);
                        de.setUrl("accordiServizioParteComuneResourcesList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                        if (contaListe) {
                            searchForCount = new ConsoleSearch(true, 1);
                            this.apcCore.accordiResourceList(Integer.parseInt(id), (ISearch)searchForCount);
                            num = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES);
                            de.setValue("Risorse (" + num + ")");
                        } else {
                            de.setValue("Risorse");
                        }
                        dati.add(de);
                        break;
                    }
                    default: {
                        if (showAccordiAzioni) {
                            de = new DataElement();
                            de.setType(DataElementType.LINK);
                            de.setUrl("accordiServizioParteComuneAzioniList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                            if (contaListe) {
                                searchForCount = new ConsoleSearch(true, 1);
                                this.apcCore.accordiAzioniList(Integer.parseInt(id), (ISearch)searchForCount);
                                num = searchForCount.getNumEntries(Liste.ACCORDI_AZIONI);
                                de.setValue("Azioni (" + num + ")");
                            } else {
                                de.setValue("Azioni");
                            }
                            dati.add(de);
                        }
                        de = new DataElement();
                        de.setType(DataElementType.LINK);
                        de.setUrl("accordiServizioParteComunePortTypesList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                        if (contaListe) {
                            searchForCount = new ConsoleSearch(true, 1);
                            this.apcCore.accordiPorttypeList(Integer.parseInt(id), (ISearch)searchForCount);
                            num = searchForCount.getNumEntries(Liste.ACCORDI_PORTTYPE);
                            de.setValue("Servizi (" + num + ")");
                        } else {
                            de.setValue("Servizi");
                        }
                        dati.add(de);
                    }
                }
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("accordiServizioParteComuneAllegatiList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                if (contaListe) {
                    searchForCount = new ConsoleSearch(true, 1);
                    this.apcCore.accordiAllegatiList(Integer.parseInt(id), (ISearch)searchForCount);
                    num = searchForCount.getNumEntries(Liste.ACCORDI_ALLEGATI);
                    de.setValue("Allegati (" + num + ")");
                } else {
                    de.setValue("Allegati");
                }
                dati.add(de);
            }
            if (showAccordiCooperazione && isServizioComposto && gestioneInformazioniGenerali) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("accordiServizioParteComuneComponentiList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome)});
                if (contaListe) {
                    searchForCount = new ConsoleSearch(true, 1);
                    this.apcCore.accordiComponentiList(Integer.parseInt(id), (ISearch)searchForCount);
                    num = searchForCount.getNumEntries(Liste.ACCORDI_COMPONENTI);
                    de.setValue("Servizi Componenti (" + num + ")");
                } else {
                    de.setValue("Servizi Componenti");
                }
                dati.add(de);
            }
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && this.isModalitaCompleta()) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("accordiServizioParteComuneErogatoriList.do", new Parameter[]{new Parameter("id", id), new Parameter("nome", nome), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
            if (!tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                searchForCount = new ConsoleSearch(true, 1);
                this.apcCore.accordiErogatoriList(Integer.parseInt(id), (ISearch)searchForCount);
                num = searchForCount.getNumEntries(Liste.ACCORDI_EROGATORI);
                de.setValue("Erogazioni (" + num + ")");
            } else {
                de.setValue("Erogazioni");
            }
            dati.add(de);
        }
        if (gestioneNuovaVersione && !gestioneNuovaVersioneRidefinisciInterfaccia) {
            de = new DataElement();
            de.setLabel("Specifica delle interfacce");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Ridefinisci Interfaccia");
            de.setName("apiNewVersionRedefine");
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(gestioneNuovaVersioneRidefinisciInterfaccia);
            de.setPostBack(true);
            dati.add(de);
        } else {
            List<InterfaceType> interfaceTypeList = this.core.getInterfaceTypeList(protocolFactory, serviceBinding);
            DataElement deInterfaceType = this.getInterfaceTypeDataElement(tipoOperazione, protocolFactory, serviceBinding, interfaceType);
            if (interfaceTypeList == null || interfaceTypeList.isEmpty()) {
                dati.add(deInterfaceType);
            } else {
                if (tipoOperazione.equals((Object)TipoOperazione.ADD) || gestioneSpecificaInterfacce) {
                    de = new DataElement();
                    de.setLabel("Specifica delle interfacce");
                    de.setType(DataElementType.TITLE);
                    dati.add(de);
                }
                if (gestioneNuovaVersione) {
                    de = new DataElement();
                    de.setLabel("Ridefinisci Interfaccia");
                    de.setName("apiNewVersionRedefine");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(gestioneNuovaVersioneRidefinisciInterfaccia);
                    de.setPostBack(true);
                    dati.add(de);
                }
                dati.add(deInterfaceType);
                if (tipoOperazione.equals((Object)TipoOperazione.ADD) && !showConversazioni) {
                    dati.add(deValidazione);
                }
                if (isInterfacciaAvanzata) {
                    if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                        if (serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP)) {
                            if (showWsdlDefinitorio) {
                                dati.add(wsdldef.getFileDataElement("WSDL Definitorio", "", this.getSize()));
                                dati.addAll(wsdldef.getFileNameDataElement());
                                dati.add(wsdldef.getFileIdDataElement());
                            } else {
                                de = new DataElement();
                                de.setLabel("WSDL Definitorio");
                                wsdldefS = wsdldef.getValue() != null ? new String(wsdldef.getValue()) : "";
                                de.setValue(wsdldefS);
                                de.setType(DataElementType.HIDDEN);
                                de.setName("wsdldef");
                                dati.add(de);
                            }
                            if (showWsdlAsincroni) {
                                dati.add(wsdlconc.getFileDataElement("WSDL Concettuale", "", this.getSize()));
                                dati.addAll(wsdlconc.getFileNameDataElement());
                                dati.add(wsdlconc.getFileIdDataElement());
                                dati.add(wsdlserv.getFileDataElement("WSDL Logico Erogatore", "", this.getSize()));
                                dati.addAll(wsdlserv.getFileNameDataElement());
                                dati.add(wsdlserv.getFileIdDataElement());
                                dati.add(wsdlservcorr.getFileDataElement("WSDL Logico Fruitore", "", this.getSize()));
                                dati.addAll(wsdlservcorr.getFileNameDataElement());
                                dati.add(wsdlservcorr.getFileIdDataElement());
                            } else {
                                de = new DataElement();
                                de.setLabel("WSDL Concettuale");
                                String wsdlconcS = wsdlconc.getValue() != null ? new String(wsdlconc.getValue()) : "";
                                de.setValue(wsdlconcS);
                                de.setType(DataElementType.HIDDEN);
                                de.setName("wsdlconc");
                                dati.add(de);
                                dati.add(wsdlserv.getFileDataElement("WSDL Logico", "", this.getSize()));
                                dati.addAll(wsdlserv.getFileNameDataElement());
                                dati.add(wsdlserv.getFileIdDataElement());
                                de = new DataElement();
                                de.setLabel("WSDL Logico Fruitore");
                                String wsdlservcorrS = wsdlservcorr.getValue() != null ? new String(wsdlservcorr.getValue()) : "";
                                de.setValue(wsdlservcorrS);
                                de.setType(DataElementType.HIDDEN);
                                de.setName("wsdlservcorr");
                                dati.add(de);
                            }
                        } else {
                            labelWsdlCon = this.getLabelWSDLFromFormatoSpecifica(interfaceType);
                            dati.add(wsdlconc.getFileDataElement(labelWsdlCon, "", this.getSize()));
                            dati.addAll(wsdlconc.getFileNameDataElement());
                            dati.add(wsdlconc.getFileIdDataElement());
                            de = new DataElement();
                            de.setLabel("WSDL Logico Erogatore");
                            String wsdlservS = wsdlserv.getValue() != null ? new String(wsdlserv.getValue()) : "";
                            de.setValue(wsdlservS);
                            de.setType(DataElementType.HIDDEN);
                            de.setName("wsdlserv");
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("WSDL Logico Fruitore");
                            wsdlservcorrS = wsdlservcorr.getValue() != null ? new String(wsdlservcorr.getValue()) : "";
                            de.setValue(wsdlservcorrS);
                            de.setType(DataElementType.HIDDEN);
                            de.setName("wsdlservcorr");
                            dati.add(de);
                        }
                    } else if (gestioneSpecificaInterfacce) {
                        if (serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP)) {
                            if (showWsdlDefinitorio) {
                                de = new DataElement();
                                de.setType(DataElementType.LINK);
                                de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdldef"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                                de.setValue("WSDL Definitorio");
                                dati.add(de);
                            }
                            if (showWsdlAsincroni) {
                                de = new DataElement();
                                de.setType(DataElementType.LINK);
                                de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdlconc"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                                de.setValue("WSDL Concettuale");
                                dati.add(de);
                                de = new DataElement();
                                de.setType(DataElementType.LINK);
                                de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdlserv"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                                de.setValue("WSDL Logico Erogatore");
                                dati.add(de);
                                de = new DataElement();
                                de.setType(DataElementType.LINK);
                                de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdlservcorr"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                                de.setValue("WSDL Logico Fruitore");
                                dati.add(de);
                            } else {
                                de = new DataElement();
                                de.setType(DataElementType.LINK);
                                de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdlserv"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                                de.setValue("WSDL Logico");
                                dati.add(de);
                            }
                            if (asWithAllegatiXSD) {
                                DataElement saveAs = new DataElement();
                                saveAs.setValue("XSD Schema Collection");
                                saveAs.setType(DataElementType.LINK);
                                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", id), new Parameter("tipoDocumento", "aspc"), new Parameter("tipoDocumentoDaScaricare", "xsdSchemaCollection"), pApiGestioneParziale});
                                saveAs.setDisabilitaAjaxStatus();
                                dati.add(saveAs);
                            }
                        } else {
                            labelWsdlCon = this.getLabelWSDLFromFormatoSpecifica(interfaceType);
                            de = new DataElement();
                            de.setType(DataElementType.LINK);
                            de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdlconc"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                            de.setValue(labelWsdlCon);
                            dati.add(de);
                            if (asWithAllegatiXSD) {
                                DataElement saveAs = new DataElement();
                                saveAs.setValue("XSD Schema Collection");
                                saveAs.setType(DataElementType.LINK);
                                saveAs.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", id), new Parameter("tipoDocumento", "aspc"), new Parameter("tipoDocumentoDaScaricare", "xsdSchemaCollection"), pApiGestioneParziale});
                                saveAs.setDisabilitaAjaxStatus();
                                dati.add(saveAs);
                            }
                        }
                    }
                } else if (serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP)) {
                    if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                        de = new DataElement();
                        de.setLabel("WSDL Definitorio");
                        wsdldefS = wsdldef.getValue() != null ? new String(wsdldef.getValue()) : "";
                        de.setValue(wsdldefS);
                        de.setType(DataElementType.HIDDEN);
                        de.setName("wsdldef");
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("WSDL Concettuale");
                        String wsdlconcS = wsdlconc.getValue() != null ? new String(wsdlconc.getValue()) : "";
                        de.setValue(wsdlconcS);
                        de.setType(DataElementType.HIDDEN);
                        de.setName("wsdlconc");
                        dati.add(de);
                        dati.add(wsdlserv.getFileDataElement("WSDL", "", this.getSize()));
                        dati.addAll(wsdlserv.getFileNameDataElement());
                        dati.add(wsdlserv.getFileIdDataElement());
                        de = new DataElement();
                        de.setLabel("WSDL Logico Fruitore");
                        wsdlservcorrS = wsdlservcorr.getValue() != null ? new String(wsdlservcorr.getValue()) : "";
                        de.setValue(wsdlservcorrS);
                        de.setType(DataElementType.HIDDEN);
                        de.setName("wsdlservcorr");
                        dati.add(de);
                    } else if (gestioneSpecificaInterfacce) {
                        de = new DataElement();
                        de.setType(DataElementType.LINK);
                        de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdlserv"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                        de.setValue("WSDL");
                        dati.add(de);
                    }
                } else if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                    de = new DataElement();
                    de.setLabel("WSDL Definitorio");
                    wsdldefS = wsdldef.getValue() != null ? new String(wsdldef.getValue()) : "";
                    de.setValue(wsdldefS);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("wsdldef");
                    dati.add(de);
                    String labelWsdlCon = this.getLabelWSDLFromFormatoSpecifica(interfaceType);
                    dati.add(wsdlconc.getFileDataElement(labelWsdlCon, "", this.getSize()));
                    dati.addAll(wsdlconc.getFileNameDataElement());
                    dati.add(wsdlconc.getFileIdDataElement());
                    de = new DataElement();
                    de.setLabel("WSDL Logico Erogatore");
                    String wsdlservS = wsdlserv.getValue() != null ? new String(wsdlserv.getValue()) : "";
                    de.setValue(wsdlservS);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("wsdlserv");
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("WSDL Logico Fruitore");
                    String wsdlservcorrS = wsdlservcorr.getValue() != null ? new String(wsdlservcorr.getValue()) : "";
                    de.setValue(wsdlservcorrS);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("wsdlservcorr");
                    dati.add(de);
                } else if (gestioneSpecificaInterfacce) {
                    labelWsdlCon = this.getLabelWSDLFromFormatoSpecifica(interfaceType);
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsdlconc"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                    de.setValue(labelWsdlCon);
                    dati.add(de);
                }
            }
            if (showConversazioni) {
                if (tipoOperazione.equals((Object)TipoOperazione.ADD) || gestioneSpecificaInterfacce) {
                    de = new DataElement();
                    de.setLabel("Specifica delle conversazioni");
                    de.setType(DataElementType.TITLE);
                    dati.add(de);
                }
                if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                    dati.add(wsblconc.getFileDataElement("Specifica Concettuale", "", this.getSize()));
                    dati.addAll(wsblconc.getFileNameDataElement());
                    dati.add(wsblconc.getFileIdDataElement());
                    dati.add(wsblserv.getFileDataElement("Specifica Erogatore", "", this.getSize()));
                    dati.addAll(wsblserv.getFileNameDataElement());
                    dati.add(wsblserv.getFileIdDataElement());
                    dati.add(wsblservcorr.getFileDataElement("Specifica Fruitore", "", this.getSize()));
                    dati.addAll(wsblservcorr.getFileNameDataElement());
                    dati.add(wsblservcorr.getFileIdDataElement());
                } else if (gestioneSpecificaInterfacce) {
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsblconc"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                    de.setValue("Specifica Concettuale");
                    dati.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsblserv"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                    de.setValue("Specifica Erogatore");
                    dati.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("accordiServizioParteComuneWSDLChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipo", "wsblservcorr"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo), pApiGestioneParziale});
                    de.setValue("Specifica Fruitore");
                    dati.add(de);
                }
            }
        }
        Boolean gestioneInfoProtocollo = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"GestioneInfoProtocollo");
        boolean isSoap = serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP);
        boolean filtroDuplicatiSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(tipoProtocollo, serviceBinding, FunzionalitaProtocollo.FILTRO_DUPLICATI);
        boolean confermaRicezioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(tipoProtocollo, serviceBinding, FunzionalitaProtocollo.CONFERMA_RICEZIONE);
        boolean collaborazioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(tipoProtocollo, serviceBinding, FunzionalitaProtocollo.COLLABORAZIONE);
        boolean idRiferimentoRichiestaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(tipoProtocollo, serviceBinding, FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA);
        boolean consegnaInOrdineSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(tipoProtocollo, serviceBinding, FunzionalitaProtocollo.CONSEGNA_IN_ORDINE);
        boolean scadenzaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(tipoProtocollo, serviceBinding, FunzionalitaProtocollo.SCADENZA);
        boolean bl2 = almostOneSupported = filtroDuplicatiSupportato || confermaRicezioneSupportato || collaborazioneSupportato || idRiferimentoRichiestaSupportato || consegnaInOrdineSupportato || scadenzaSupportato;
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && !gestioneInformazioniProtocollo) {
            gestioneInfoProtocollo = false;
        }
        de = new DataElement();
        if (isModalitaVistaApiCustom != null && isModalitaVistaApiCustom.booleanValue()) {
            de.setLabel("Opzioni Avanzate");
        } else {
            de.setLabel("Informazioni Protocollo");
        }
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && (almostOneSupported || isSoap)) {
            de.setType(DataElementType.TITLE);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Profilo di collaborazione");
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && isSoap) {
            de.setType(DataElementType.SELECT);
            de.setValues(this.core.getProfiliDiCollaborazioneSupportatiDalProtocollo(tipoProtocollo, serviceBinding));
            de.setSelected(profcoll);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(profcoll);
        }
        de.setName("profcoll");
        dati.add(de);
        if (showUtilizzoSenzaAzione && gestioneInfoProtocollo.booleanValue()) {
            de = new DataElement();
            de.setLabel("Utilizzo Senza Azione");
            if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
            } else {
                de.setType(DataElementType.TEXT);
                if (utilizzoSenzaAzione) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("utilizzoSenzaAzione");
            if (utilizzoSenzaAzione) {
                de.setSelected(true);
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Filtro Duplicati");
        de.setName("filtrodup");
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && filtroDuplicatiSupportato) {
            if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)filtrodup) || CostantiRegistroServizi.ABILITATO.equals(filtrodup)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)filtrodup) || CostantiRegistroServizi.ABILITATO.equals(filtrodup)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            if (filtroDuplicatiSupportato) {
                de.setValue("yes");
            } else {
                de.setValue("no");
            }
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Conferma Ricezione");
        de.setName("confric");
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && confermaRicezioneSupportato) {
            if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)confric) || CostantiRegistroServizi.ABILITATO.equals(confric)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)confric) || CostantiRegistroServizi.ABILITATO.equals(confric)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("ID Conversazione");
        de.setName("idcoll");
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && collaborazioneSupportato) {
            if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idcoll) || CostantiRegistroServizi.ABILITATO.equals(idcoll)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idcoll) || CostantiRegistroServizi.ABILITATO.equals(idcoll)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Riferimento ID Richiesta");
        de.setName("idRifReq");
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && idRiferimentoRichiestaSupportato) {
            if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiesta) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiesta)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiesta) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiesta)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Consegna in Ordine");
        de.setName("consord");
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && consegnaInOrdineSupportato) {
            if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)consord) || CostantiRegistroServizi.ABILITATO.equals(consord)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)consord) || CostantiRegistroServizi.ABILITATO.equals(consord)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Scadenza");
        de.setValue(scadenza);
        if (gestioneInfoProtocollo != null && gestioneInfoProtocollo.booleanValue() && scadenzaSupportato) {
            de.setType(DataElementType.TEXT_EDIT);
            if (!modificheAbilitate && (scadenza == null || "".equals(scadenza))) {
                de.setValue(" ");
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("scadenza");
        de.setSize(this.getSize());
        dati.add(de);
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && isModalitaVistaApiCustom != null && isModalitaVistaApiCustom.booleanValue() && gestioneSpecificaInterfacce) {
            this.pd.disableEditMode();
        }
        return dati;
    }

    public void addCanaleToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String canaleStato, String canale, List<CanaleConfigurazione> canaleList, boolean gestioneCanaliEnabled, boolean modificheAbilitate, boolean gestioneCanale) throws DriverConfigurazioneNotFound {
        if (gestioneCanaliEnabled) {
            DataElement de = new DataElement();
            de.setLabel("Canale");
            de.setValue(canaleStato);
            de.setValues(AccordiServizioParteComuneCostanti.VALUES_PARAMETRO_APC_CANALE_STATO);
            ArrayList<String> labelsCanaleStato = new ArrayList<String>();
            CanaleConfigurazione canaleConfigurazioneDefault = this.getCanaleDefault(canaleList);
            labelsCanaleStato.add(MessageFormat.format("default ({0})", canaleConfigurazioneDefault.getNome()));
            labelsCanaleStato.add("ridefinito");
            de.setLabels(labelsCanaleStato);
            if (tipoOperazione.equals((Object)TipoOperazione.ADD) || gestioneCanale && modificheAbilitate) {
                de.setType(DataElementType.SELECT);
                de.setSelected(canaleStato);
            } else if (gestioneCanale) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("canaleStato");
            de.setSize(this.getSize());
            de.setPostBack(true);
            dati.add(de);
            if ("ridefinito".equals(canaleStato)) {
                de = new DataElement();
                de.setLabel("");
                de.setValue(canale);
                List canaliListValues = canaleList.stream().map(CanaleConfigurazione::getNome).collect(Collectors.toList());
                de.setValues(canaliListValues);
                de.setLabels(canaliListValues);
                if (tipoOperazione.equals((Object)TipoOperazione.ADD) || gestioneCanale && modificheAbilitate) {
                    de.setType(DataElementType.SELECT);
                    de.setSelected(canale);
                } else {
                    if (gestioneCanale) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    if (!modificheAbilitate && StringUtils.isBlank((CharSequence)canale)) {
                        de.setValue("");
                    }
                }
                de.setName("canale");
                de.setSize(this.getSize());
                dati.add(de);
            }
        }
    }

    public String getLabelWSDLFromFormatoSpecifica(InterfaceType formatoSpecifica) {
        switch (formatoSpecifica) {
            case SWAGGER_2: {
                return "Swagger 2";
            }
            case OPEN_API_3: {
                return "Open API 3";
            }
            case WSDL_11: {
                return "Wsdl 1.1";
            }
        }
        return "Open API 3";
    }

    public List<DataElement> addAccordiToDatiAsHidden(List<DataElement> dati, String nome, String descr, String profcoll, String wsdldef, String wsdlconc, String wsdlserv, String wsdlservcorr, String filtrodup, String confric, String idcoll, String idRifRichiesta, String consord, String scadenza, String id, TipoOperazione tipoOperazione, boolean showUtilizzoSenzaAzione, boolean utilizzoSenzaAzione, String referente, String versione, String[] providersList, String[] providersListLabel, boolean privato, boolean isServizioComposto, String[] accordiCooperazioneEsistenti, String[] accordiCooperazioneEsistentiLabel, String accordoCooperazione, String stato, String oldStato, String tipoAccordo, boolean validazioneDocumenti, String tipoProtocollo, List<String> listaTipiProtocollo, boolean used, org.openspcoop2.message.constants.ServiceBinding serviceBinding, MessageType messageType, InterfaceType formatoSpecifica, String gruppi, String canaleStato, String canale) throws Exception {
        Boolean showAccordiCooperazione = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ShowAccordiCooperazione");
        boolean modificheAbilitate = false;
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            modificheAbilitate = true;
        } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
            modificheAbilitate = true;
        } else if (!StatiAccordo.finale.toString().equals(oldStato)) {
            modificheAbilitate = true;
        }
        boolean modificaAbilitataServizioComposto = true;
        if ("asc".equals(tipoAccordo)) {
            modificaAbilitataServizioComposto = tipoOperazione.equals((Object)TipoOperazione.ADD);
        }
        DataElement de = new DataElement();
        de.setValue(tipoAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoAccordo");
        de.setSize(this.getSize());
        dati.add(de);
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            de = new DataElement();
            de.setLabel("id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Profilo Interoperabilit\u00e0");
        de.setValue(tipoProtocollo);
        de.setType(DataElementType.HIDDEN);
        de.setName("protocollo");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.HIDDEN);
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descr);
        de.setType(DataElementType.HIDDEN);
        de.setName("descr");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tags");
        de.setValue(gruppi);
        de.setType(DataElementType.HIDDEN);
        de.setName("gruppi");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Canale");
        de.setValue(canaleStato);
        de.setType(DataElementType.HIDDEN);
        de.setName("canaleStato");
        de.setSize(this.getSize());
        dati.add(de);
        if ("ridefinito".equals(canaleStato)) {
            de = new DataElement();
            de.setLabel("Canale");
            de.setValue(canale);
            de.setType(DataElementType.HIDDEN);
            de.setName("canale");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Soggetto Referente");
        de.setName("referente");
        Soggetto sogg = null;
        if (referente != null && !"".equals(referente) && !"-".equals(referente) && Integer.parseInt(referente) > 0) {
            sogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(referente));
        }
        if (modificheAbilitate && modificaAbilitataServizioComposto) {
            de.setType(DataElementType.HIDDEN);
            if (referente != null && !"".equals(referente) && !"-".equals(referente)) {
                de.setValue(referente);
            } else {
                de.setValue("-");
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(referente);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Soggetto Referente");
            de.setName("referenteLabelAccordo1.2");
            de.setType(DataElementType.HIDDEN);
            if (referente != null && !"".equals(referente) && !"-".equals(referente)) {
                de.setValue(sogg.getTipo() + "/" + sogg.getNome());
            } else {
                de.setValue("-");
            }
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Versione");
        de.setValue(versione);
        de.setType(DataElementType.HIDDEN);
        de.setName("versione");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Privato");
        if (privato) {
            de.setValue("yes");
        } else {
            de.setValue(null);
        }
        de.setType(DataElementType.HIDDEN);
        de.setName("privato");
        dati.add(de);
        if (showAccordiCooperazione.booleanValue()) {
            de = new DataElement();
            de.setLabel("Servizio Composto");
            de.setName("isServizioComposto");
            de.setValue(isServizioComposto ? "yes" : "no");
            de.setType(DataElementType.HIDDEN);
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setType(DataElementType.HIDDEN);
        de.setValue(stato);
        de.setName("stato");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Validazione Specifica");
        de.setValue("" + validazioneDocumenti);
        de.setType(DataElementType.HIDDEN);
        de.setName("validazioneDocumenti");
        de.setSize(this.getSize());
        dati.add(de);
        if (showAccordiCooperazione.booleanValue() && isServizioComposto) {
            de = new DataElement();
            de.setLabel("Accordo Cooperazione");
            de.setName("accordoCooperazione");
            de.setType(DataElementType.HIDDEN);
            de.setValue(accordoCooperazione);
            dati.add(de);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Profilo di collaborazione");
        de.setType(DataElementType.HIDDEN);
        de.setValue(profcoll);
        de.setName("profcoll");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Utilizzo Senza Azione");
        de.setType(DataElementType.HIDDEN);
        if (utilizzoSenzaAzione) {
            de.setValue(CostantiRegistroServizi.ABILITATO.toString());
        } else {
            de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
        }
        de.setName("utilizzoSenzaAzione");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Filtro Duplicati");
        de.setName("filtrodup");
        if (ServletUtils.isCheckBoxEnabled((String)filtrodup) || CostantiRegistroServizi.ABILITATO.equals(filtrodup)) {
            de.setValue("yes");
        } else {
            de.setValue("no");
        }
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Conferma Ricezione");
        de.setName("confric");
        if (ServletUtils.isCheckBoxEnabled((String)confric) || CostantiRegistroServizi.ABILITATO.equals(confric)) {
            de.setValue("yes");
        } else {
            de.setValue("no");
        }
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("ID Conversazione");
        de.setName("idcoll");
        if (ServletUtils.isCheckBoxEnabled((String)idcoll) || CostantiRegistroServizi.ABILITATO.equals(idcoll)) {
            de.setValue("yes");
        } else {
            de.setValue("no");
        }
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Riferimento ID Richiesta");
        de.setName("idRifReq");
        if (ServletUtils.isCheckBoxEnabled((String)idRifRichiesta) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiesta)) {
            de.setValue("yes");
        } else {
            de.setValue("no");
        }
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Consegna in Ordine");
        de.setName("consord");
        if (ServletUtils.isCheckBoxEnabled((String)consord) || CostantiRegistroServizi.ABILITATO.equals(consord)) {
            de.setValue("yes");
        } else {
            de.setValue("no");
        }
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Scadenza");
        de.setValue(scadenza);
        de.setType(DataElementType.HIDDEN);
        de.setName("scadenza");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setValue(serviceBinding != null ? serviceBinding.toString() : null);
        de.setType(DataElementType.HIDDEN);
        de.setName("serviceBinding");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo Messaggio");
        de.setValue(messageType != null ? messageType.toString() : null);
        de.setType(DataElementType.HIDDEN);
        de.setName("messageType");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Formato Specifica");
        de.setValue(formatoSpecifica != null ? formatoSpecifica.toString() : null);
        de.setType(DataElementType.HIDDEN);
        de.setName("interfaceType");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public boolean accordiCheckData(TipoOperazione tipoOperazione, String nome, String descr, String profcoll, BinaryParameter wsdldef, BinaryParameter wsdlconc, BinaryParameter wsdlserv, BinaryParameter wsdlservcorr, String filtrodup, String confric, String idcoll, String idRifRichiesta, String consord, String scadenza, String id, String referente, String versione, String accordoCooperazione, boolean visibilitaAccordoServizio, boolean visibilitaAccordoCooperazione, IDAccordo idAccordoOLD, BinaryParameter wsblconc, BinaryParameter wsblserv, BinaryParameter wsblservcorr, boolean validazioneDocumenti, String tipoProtocollo, String backToStato, org.openspcoop2.message.constants.ServiceBinding serviceBinding, MessageType messageType, InterfaceType formatoSpecifica, boolean checkReferente, String gruppi, String canaleStato, String canale, boolean gestioneCanaliEnabled) throws ControlStationCoreException {
        try {
            int idInt = 0;
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                idInt = Integer.parseInt(id);
            }
            if (referente == null) {
                referente = "";
            }
            if (backToStato != null && tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                return true;
            }
            if (nome == null || nome.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Nome");
                return false;
            }
            if (versione == null || versione.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare una Versione dell'accordo");
                return false;
            }
            if ((referente == null || referente.equals("") || referente.equals("-")) && (!TipoOperazione.ADD.equals((Object)tipoOperazione) || checkReferente)) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Soggetto Referente");
                return false;
            }
            if (serviceBinding == null) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Service Binding");
                return false;
            }
            if (formatoSpecifica == null) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Formato Specifica");
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo di testo 'nome'");
                return false;
            }
            if (scadenza.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo di testo 'scadenza'");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (descr != null && !"".equals(descr)) {
                boolean valid = true;
                if (this.apcCore.isApiDescriptionTruncate255()) {
                    valid = this.checkLength255(descr, "Descrizione");
                } else if (this.apcCore.isApiDescriptionTruncate4000()) {
                    valid = this.checkLength4000(descr, "Descrizione");
                }
                if (!valid) {
                    return false;
                }
            }
            if (!this.checkNCName(nome, "Nome")) {
                return false;
            }
            if (gruppi != null && !"".equals(gruppi)) {
                List<String> nomiGruppi = Arrays.asList(gruppi.split(","));
                for (String nomeGruppo : nomiGruppi) {
                    if (this.checkNCName(nomeGruppo, "Tags")) continue;
                    return false;
                }
            }
            if (!this.canaleCheckData(canaleStato, canale, gestioneCanaliEnabled)) {
                return false;
            }
            if (!versione.equals("") && !this.checkNumber(versione, "Versione", false)) {
                return false;
            }
            if (!(profcoll.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO) || profcoll.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO) || profcoll.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_SINCRONO) || profcoll.equals(AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ONEWAY))) {
                this.pd.setMessage("Il profilo di collaborazione dev'essere " + AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO + ", " + AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO + ", " + AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_SINCRONO + " o " + AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ONEWAY);
                return false;
            }
            if (!(filtrodup == null || filtrodup.equals("yes") || filtrodup.equals(CostantiRegistroServizi.ABILITATO.getValue()) || filtrodup.equals("no") || filtrodup.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                this.pd.setMessage("Filtro duplicati dev'essere selezionato o deselezionato");
                return false;
            }
            if (!(confric == null || confric.equals("yes") || confric.equals(CostantiRegistroServizi.ABILITATO.getValue()) || confric.equals("no") || confric.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                this.pd.setMessage("Conferma ricezione dev'essere selezionata o deselezionata");
                return false;
            }
            if (!(idcoll == null || idcoll.equals("yes") || idcoll.equals(CostantiRegistroServizi.ABILITATO.getValue()) || idcoll.equals("no") || idcoll.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                this.pd.setMessage("ID Conversazione dev'essere selezionata o deselezionata");
                return false;
            }
            if (!(idRifRichiesta == null || idRifRichiesta.equals("yes") || idRifRichiesta.equals(CostantiRegistroServizi.ABILITATO.getValue()) || idRifRichiesta.equals("no") || idRifRichiesta.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                this.pd.setMessage("Riferimento ID Richiesta dev'essere selezionata o deselezionata");
                return false;
            }
            if (!(consord == null || consord.equals("yes") || consord.equals(CostantiRegistroServizi.ABILITATO.getValue()) || consord.equals("no") || consord.equals(CostantiRegistroServizi.DISABILITATO.getValue()))) {
                this.pd.setMessage("Consegna in ordine dev'essere selezionata o deselezionata");
                return false;
            }
            if (!scadenza.equals("") && !this.checkNumber(scadenza, "Scadenza", false)) {
                return false;
            }
            if ("-".equals(accordoCooperazione)) {
                this.pd.setMessage("L'accordo di cooperazione e' richiesto.");
                return false;
            }
            if (!"-".equals(accordoCooperazione) && !"".equals(accordoCooperazione) && accordoCooperazione != null) {
                boolean nonVisibile = true;
                boolean visibile = false;
                if (visibilitaAccordoServizio == visibile && visibilitaAccordoCooperazione == nonVisibile) {
                    this.pd.setMessage("Non e' possibile utilizzare un accordo di cooperazione con visibilita' privata, in un accordo di servizio con visibilita' pubblica.");
                    return false;
                }
            }
            IDSoggetto soggettoReferente = null;
            Soggetto sRef = null;
            if (checkReferente) {
                if (referente != null && !referente.equals("") && !referente.equals("-")) {
                    boolean trovatoProv = this.soggettiCore.existsSoggetto(Integer.parseInt(referente));
                    if (!trovatoProv) {
                        this.pd.setMessage("Il Soggetto referente dev'essere scelto tra quelli definiti nel pannello Soggetti");
                        return false;
                    }
                    sRef = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(referente));
                    boolean visibile = false;
                    if (visibilitaAccordoServizio == visibile && sRef.getPrivato() != null && sRef.getPrivato().booleanValue()) {
                        this.pd.setMessage("Non e' possibile utilizzare un soggetto referente con visibilita' privata, in un accordo di servizio con visibilita' pubblica.");
                        return false;
                    }
                    soggettoReferente = new IDSoggetto(sRef.getTipo(), sRef.getNome());
                }
            } else {
                soggettoReferente = this.apcCore.getSoggettoOperativoDefault(ServletUtils.getUserLoginFromSession((HttpSession)this.session), tipoProtocollo);
            }
            int idAcc = 0;
            IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(nome, soggettoReferente, Integer.valueOf(Integer.parseInt(versione)));
            boolean esisteAS = this.apcCore.existsAccordoServizio(idAccordo);
            AccordoServizioParteComuneSintetico as = null;
            if (esisteAS) {
                as = this.apcCore.getAccordoServizioSintetico(idAccordo);
                idAcc = as.getId().intValue();
            }
            if (idAcc != 0 && (tipoOperazione.equals((Object)TipoOperazione.ADD) || tipoOperazione.equals((Object)TipoOperazione.CHANGE) && idInt != idAcc)) {
                if (soggettoReferente != null && checkReferente) {
                    this.pd.setMessage("Esiste gi&agrave; una API (versione " + versione + ") con nome " + nome + " del soggetto referente " + this.getLabelNomeSoggetto(tipoProtocollo, soggettoReferente));
                } else {
                    this.pd.setMessage("Esiste gi&agrave; una API (versione " + versione + ") con nome " + nome);
                }
                return false;
            }
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && ((as = this.apcCore.getAccordoServizioSintetico(idAccordoOLD)).getPrivato() == null || !as.getPrivato().booleanValue()) && as.getServizioComposto() != null) {
                for (int i = 0; i < as.getServizioComposto().getServizioComponente().size(); ++i) {
                    AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(((AccordoServizioParteComuneServizioCompostoServizioComponenteSintetico)as.getServizioComposto().getServizioComponente().get(i)).getIdServizioComponente());
                    if (asps.getPrivato() == null || !asps.getPrivato().booleanValue()) continue;
                    this.pd.setMessage("Non e' possibile impostare una visibilita' pubblica all'accordo di servizio, poiche' possiede un servizio componente [" + IDServizioFactory.getInstance().getUriFromAccordo(asps) + "] con visibilita' privata.");
                    return false;
                }
            }
            AccordoServizioParteComune accordoServizioParteComune = new AccordoServizioParteComune();
            accordoServizioParteComune.setNome(nome);
            accordoServizioParteComune.setDescrizione(descr);
            accordoServizioParteComune.setProfiloCollaborazione(ProfiloCollaborazione.toEnumConstant((String)profcoll));
            accordoServizioParteComune.setFiltroDuplicati(StatoFunzionalita.toEnumConstant((String)filtrodup));
            accordoServizioParteComune.setConfermaRicezione(StatoFunzionalita.toEnumConstant((String)confric));
            accordoServizioParteComune.setIdCollaborazione(StatoFunzionalita.toEnumConstant((String)idcoll));
            accordoServizioParteComune.setIdRiferimentoRichiesta(StatoFunzionalita.toEnumConstant((String)idRifRichiesta));
            accordoServizioParteComune.setConsegnaInOrdine(StatoFunzionalita.toEnumConstant((String)consord));
            accordoServizioParteComune.setScadenza(scadenza);
            if (sRef != null) {
                IdSoggetto soggRef = new IdSoggetto();
                soggRef.setTipo(sRef.getTipo());
                soggRef.setNome(sRef.getNome());
                accordoServizioParteComune.setSoggettoReferente(soggRef);
            }
            if (versione != null) {
                accordoServizioParteComune.setVersione(Integer.valueOf(Integer.parseInt(versione)));
            }
            accordoServizioParteComune.setServiceBinding(this.apcCore.fromMessageServiceBinding(serviceBinding));
            accordoServizioParteComune.setMessageType(this.apcCore.fromMessageMessageType(messageType));
            accordoServizioParteComune.setFormatoSpecifica(this.apcCore.interfaceType2FormatoSpecifica(formatoSpecifica));
            ValidazioneResult v = this.apcCore.validazione(accordoServizioParteComune, tipoProtocollo);
            if (!v.isEsito()) {
                this.pd.setMessage(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioErrore()));
                if (v.getException() != null) {
                    this.logError(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioErrore()), v.getException());
                } else {
                    this.logError(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioErrore()));
                }
                return false;
            }
            if (validazioneDocumenti && tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                FormatoSpecifica formato = null;
                if (accordoServizioParteComune != null) {
                    formato = accordoServizioParteComune.getFormatoSpecifica();
                }
                String wsdlDefinitorioS = wsdldef.getValue() != null ? new String(wsdldef.getValue()) : null;
                byte[] wsdlDefinitorio = this.apcCore.getInterfaceAsByteArray(formato, wsdlDefinitorioS);
                String wsdlconcS = wsdlconc.getValue() != null ? new String(wsdlconc.getValue()) : null;
                byte[] wsdlConcettuale = this.apcCore.getInterfaceAsByteArray(formato, wsdlconcS);
                String wsdlLogicoErogatoreS = wsdlserv.getValue() != null ? new String(wsdlserv.getValue()) : null;
                byte[] wsdlLogicoErogatore = this.apcCore.getInterfaceAsByteArray(formato, wsdlLogicoErogatoreS);
                String wsdlLogicoFruitoreS = wsdlservcorr.getValue() != null ? new String(wsdlservcorr.getValue()) : null;
                byte[] wsdlLogicoFruitore = this.apcCore.getInterfaceAsByteArray(formato, wsdlLogicoFruitoreS);
                String wsblConcettualeS = wsblconc.getValue() != null ? new String(wsblconc.getValue()) : null;
                byte[] wsblConcettuale = this.apcCore.getInterfaceAsByteArray(formato, wsblConcettualeS);
                String wsblLogicoErogatoreS = wsblserv.getValue() != null ? new String(wsblserv.getValue()) : null;
                byte[] wsblLogicoErogatore = this.apcCore.getInterfaceAsByteArray(formato, wsblLogicoErogatoreS);
                String wsblLogicoFruitoreS = wsblservcorr.getValue() != null ? new String(wsblservcorr.getValue()) : null;
                byte[] wsblLogicoFruitore = this.apcCore.getInterfaceAsByteArray(formato, wsblLogicoFruitoreS);
                accordoServizioParteComune.setByteWsdlDefinitorio(wsdlDefinitorio);
                accordoServizioParteComune.setByteWsdlConcettuale(wsdlConcettuale);
                accordoServizioParteComune.setByteWsdlLogicoErogatore(wsdlLogicoErogatore);
                accordoServizioParteComune.setByteWsdlLogicoFruitore(wsdlLogicoFruitore);
                accordoServizioParteComune.setByteSpecificaConversazioneConcettuale(wsblConcettuale);
                accordoServizioParteComune.setByteSpecificaConversazioneErogatore(wsblLogicoErogatore);
                accordoServizioParteComune.setByteSpecificaConversazioneFruitore(wsblLogicoFruitore);
                v = this.apcCore.validaInterfacciaWsdlParteComune(accordoServizioParteComune, tipoProtocollo);
                if (!v.isEsito()) {
                    String msgErroreHTML = v.getMessaggioErrore();
                    if (msgErroreHTML != null) {
                        msgErroreHTML = msgErroreHTML.replaceAll("\n", "<br/>");
                    }
                    this.pd.setMessage(this.getValidazionePrefixErrorMessage(tipoProtocollo, msgErroreHTML));
                    if (v.getException() != null) {
                        this.logError(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioErrore()), v.getException());
                    } else {
                        this.logError(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioErrore()));
                    }
                    return false;
                }
                if (v.getMessaggioWarning() != null && StringUtils.isNotEmpty((CharSequence)v.getMessaggioWarning())) {
                    String msgWarningHTML = v.getMessaggioWarning();
                    if (msgWarningHTML != null) {
                        msgWarningHTML = msgWarningHTML.replaceAll("\n", "<br/>");
                    }
                    this.pd.setMessage(this.getValidazionePrefixErrorMessage(tipoProtocollo, msgWarningHTML), org.openspcoop2.web.lib.mvc.MessageType.WARN);
                    if (v.getException() != null) {
                        this.log.warn(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioWarning()), (Throwable)v.getException());
                    } else {
                        this.log.warn(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioWarning()));
                    }
                }
                if (!(v = this.apcCore.validaSpecificaConversazione(accordoServizioParteComune, tipoProtocollo)).isEsito()) {
                    String msgErroreHTML = v.getMessaggioErrore();
                    if (msgErroreHTML != null) {
                        msgErroreHTML = msgErroreHTML.replaceAll("\n", "<br/>");
                    }
                    this.pd.setMessage(this.getValidazionePrefixErrorMessage(tipoProtocollo, msgErroreHTML));
                    if (v.getException() != null) {
                        this.logError(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioErrore()), v.getException());
                    } else {
                        this.logError(this.getValidazionePrefixErrorMessage(tipoProtocollo, v.getMessaggioErrore()));
                    }
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new ControlStationCoreException(e);
        }
    }

    private String getValidazionePrefixErrorMessage(String tipoProtocollo, String msg) {
        return "[validazione-" + tipoProtocollo + "] " + msg;
    }

    public IDAccordo getIDAccordoFromValues(String nome, String referente, String versione, boolean visibilitaAccordoServizio) throws Exception {
        IDSoggetto soggettoReferente = null;
        IDAccordo idAccordo = null;
        Soggetto sRef = null;
        if (referente != null && !referente.equals("") && !referente.equals("-")) {
            boolean trovatoProv = this.soggettiCore.existsSoggetto(Integer.parseInt(referente));
            if (trovatoProv) {
                sRef = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(referente));
                boolean visibile = false;
                if (visibilitaAccordoServizio == visibile && sRef.getPrivato() != null && sRef.getPrivato().booleanValue()) {
                    return null;
                }
                soggettoReferente = new IDSoggetto(sRef.getTipo(), sRef.getNome());
            }
            idAccordo = this.idAccordoFactory.getIDAccordoFromValues(nome, soggettoReferente, Integer.valueOf(Integer.parseInt(versione)));
        }
        return idAccordo;
    }

    public void prepareAccordiList(List<AccordoServizioParteComuneSintetico> lista, ISearch ricerca, String tipoAccordo) throws Exception {
        try {
            DataElement de;
            List<String> l;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComune", (Parameter[])new Parameter[]{new Parameter("tipoAccordo", tipoAccordo)});
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            boolean showServiceBinding = true;
            boolean showResources = true;
            boolean showServices = true;
            if (!showProtocolli && (l = this.core.getProtocolli(this.request, this.session)).size() > 0) {
                IProtocolFactory p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(l.get(0));
                if (p.getManifest().getBinding().getRest() == null) {
                    showResources = false;
                }
                if (p.getManifest().getBinding().getSoap() == null) {
                    showServices = false;
                }
                if (!showResources || !showServices) {
                    showServiceBinding = false;
                }
            }
            int idLista = Liste.ACCORDI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            this.addFilterProtocol(ricerca, idLista);
            String filterTipoAccordo = null;
            if (showServiceBinding) {
                filterTipoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroServiceBinding");
                this.addFilterServiceBinding(filterTipoAccordo, false, false);
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                String filterStatoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroStatoAccordo");
                this.addFilterStatoAccordo(filterStatoAccordo, false);
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ServiceBinding serviceBindingFilter = null;
            if (filterTipoAccordo != null) {
                serviceBindingFilter = ServiceBinding.toEnumConstant((String)filterTipoAccordo);
            }
            String termine = AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo);
            boolean showColonnaServizioComponenti = AccordiServizioParteComuneUtilities.showInformazioniServiziComponenti(tipoAccordo);
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(termine, "accordiServizioParteComuneList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(termine, "accordiServizioParteComuneList.do"), new Parameter("Risultati ricerca", null)});
            }
            Boolean gestioneInfoProtocollo = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"GestioneInfoProtocollo");
            Boolean showAccordiAzioni = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ShowAccordiAzioni");
            Boolean showAccordiCooperazione = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ShowAccordiCooperazione");
            Boolean showColonnaAccordiCooperazione = tipoAccordo != null && tipoAccordo.equals("asc");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)termine, (String)search);
            }
            int totEl = 1;
            if (showColonnaAccordiCooperazione.booleanValue()) {
                ++totEl;
            }
            if (showServiceBinding) {
                ++totEl;
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                ++totEl;
            }
            if (showResources && (serviceBindingFilter == null || ServiceBinding.REST.equals((Object)serviceBindingFilter))) {
                ++totEl;
            }
            if (showServices && (serviceBindingFilter == null || ServiceBinding.SOAP.equals((Object)serviceBindingFilter))) {
                if (gestioneInfoProtocollo.booleanValue() && showAccordiAzioni.booleanValue()) {
                    ++totEl;
                }
                ++totEl;
            }
            if (showAccordiCooperazione.booleanValue() && showColonnaServizioComponenti) {
                ++totEl;
            }
            if (showProtocolli) {
                ++totEl;
            }
            if (this.isModalitaCompleta()) {
                ++totEl;
            }
            String[] labels = new String[totEl + 1];
            labels[0] = "Nome";
            int index = 1;
            if (showProtocolli) {
                labels[index] = "Profilo";
                ++index;
            }
            if (showColonnaAccordiCooperazione.booleanValue()) {
                labels[index] = "Accordo Cooperazione";
                ++index;
            }
            if (showServiceBinding) {
                labels[index] = "Tipo";
                ++index;
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                labels[index] = "Stato";
                ++index;
            }
            if (showResources && (serviceBindingFilter == null || ServiceBinding.REST.equals((Object)serviceBindingFilter))) {
                labels[index] = "Risorse";
                ++index;
            }
            if (showServices && (serviceBindingFilter == null || ServiceBinding.SOAP.equals((Object)serviceBindingFilter))) {
                if (gestioneInfoProtocollo.booleanValue() && showAccordiAzioni.booleanValue()) {
                    labels[index] = "Azioni";
                    ++index;
                }
                labels[index] = "Servizi";
                ++index;
            }
            if (this.isModalitaCompleta()) {
                labels[index] = "Erogazioni";
                ++index;
            }
            if (showAccordiCooperazione.booleanValue() && showColonnaServizioComponenti) {
                labels[index] = "Servizi Componenti";
                ++index;
            }
            labels[index] = "Allegati";
            ++index;
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                Iterator<AccordoServizioParteComuneSintetico> it = lista.iterator();
                AccordoServizioParteComuneSintetico accordoServizio = null;
                while (it.hasNext()) {
                    ConsoleSearch searchForCount;
                    accordoServizio = it.next();
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.message.constants.ServiceBinding serviceBinding = this.apcCore.toMessageServiceBinding(accordoServizio.getServiceBinding());
                    String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(accordoServizio.getSoggettoReferente().getTipo());
                    de = new DataElement();
                    de.setUrl("accordiServizioParteComuneChange.do", new Parameter[]{new Parameter("id", "" + accordoServizio.getId()), new Parameter("nome", accordoServizio.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
                    de.setValue(this.getLabelIdAccordo(protocollo, idAccordo));
                    de.setIdToRemove("" + accordoServizio.getId());
                    de.setToolTip(accordoServizio.getDescrizione());
                    e.add(de);
                    if (showProtocolli) {
                        de = new DataElement();
                        de.setValue(this.getLabelProtocollo(protocollo));
                        e.add(de);
                    }
                    if (showColonnaAccordiCooperazione.booleanValue()) {
                        de = new DataElement();
                        AccordoServizioParteComuneServizioCompostoSintetico servizioComposto = accordoServizio.getServizioComposto();
                        if (servizioComposto != null) {
                            AccordoCooperazione accordoCooperazione = this.acCore.getAccordoCooperazione(servizioComposto.getIdAccordoCooperazione());
                            de.setUrl("accordiCooperazioneChange.do", new Parameter[]{new Parameter("id", "" + accordoCooperazione.getId()), new Parameter("nome", accordoCooperazione.getNome())});
                            de.setValue(this.getLabelIdAccordoCooperazione(accordoCooperazione));
                        }
                        e.add(de);
                    }
                    if (showServiceBinding) {
                        de = new DataElement();
                        switch (serviceBinding) {
                            case REST: {
                                de.setValue("Rest");
                                break;
                            }
                            default: {
                                de.setValue("Soap");
                            }
                        }
                        e.add(de);
                    }
                    if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                        de = new DataElement();
                        de.setValue(StatiAccordo.upper((String)accordoServizio.getStatoPackage()));
                        e.add(de);
                    }
                    if (showResources && (serviceBindingFilter == null || ServiceBinding.REST.equals((Object)serviceBindingFilter))) {
                        de = new DataElement();
                        switch (serviceBinding) {
                            case REST: {
                                de.setUrl("accordiServizioParteComuneResourcesList.do", new Parameter[]{new Parameter("id", "" + accordoServizio.getId()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                                if (contaListe.booleanValue()) {
                                    searchForCount = new ConsoleSearch(true, 1);
                                    this.apcCore.accordiResourceList(accordoServizio.getId().intValue(), (ISearch)searchForCount);
                                    int num = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES);
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(num));
                                    break;
                                }
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                                break;
                            }
                            default: {
                                de.setValue("--");
                            }
                        }
                        e.add(de);
                    }
                    if (showServices && (serviceBindingFilter == null || ServiceBinding.SOAP.equals((Object)serviceBindingFilter))) {
                        if (gestioneInfoProtocollo.booleanValue() && showAccordiAzioni.booleanValue()) {
                            de = new DataElement();
                            switch (serviceBinding) {
                                case REST: {
                                    de.setValue("--");
                                    break;
                                }
                                default: {
                                    de.setUrl("accordiServizioParteComuneAzioniList.do", new Parameter[]{new Parameter("id", "" + accordoServizio.getId()), new Parameter("nome", accordoServizio.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                                    if (contaListe.booleanValue()) {
                                        searchForCount = new ConsoleSearch(true, 1);
                                        this.apcCore.accordiAzioniList(accordoServizio.getId().intValue(), (ISearch)searchForCount);
                                        int num = searchForCount.getNumEntries(Liste.ACCORDI_AZIONI);
                                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(num));
                                        break;
                                    }
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                                }
                            }
                            e.add(de);
                        }
                        de = new DataElement();
                        switch (serviceBinding) {
                            case REST: {
                                de.setValue("--");
                                break;
                            }
                            default: {
                                de.setUrl("accordiServizioParteComunePortTypesList.do", new Parameter[]{new Parameter("id", "" + accordoServizio.getId()), new Parameter("nome", accordoServizio.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                                if (contaListe.booleanValue()) {
                                    searchForCount = new ConsoleSearch(true, 1);
                                    this.apcCore.accordiPorttypeList(accordoServizio.getId().intValue(), (ISearch)searchForCount);
                                    int num = searchForCount.getNumEntries(Liste.ACCORDI_PORTTYPE);
                                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(num));
                                    break;
                                }
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                        }
                        e.add(de);
                    }
                    if (this.isModalitaCompleta()) {
                        de = new DataElement();
                        de.setUrl("accordiServizioParteComuneErogatoriList.do", new Parameter[]{new Parameter("id", "" + accordoServizio.getId()), new Parameter("nome", accordoServizio.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                        if (contaListe.booleanValue()) {
                            searchForCount = new ConsoleSearch(true, 1);
                            this.apcCore.accordiErogatoriList(accordoServizio.getId().intValue(), (ISearch)searchForCount);
                            int num = searchForCount.getNumEntries(Liste.ACCORDI_EROGATORI);
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(num));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        e.add(de);
                    }
                    if (showAccordiCooperazione.booleanValue() && showColonnaServizioComponenti) {
                        de = new DataElement();
                        if (accordoServizio.getServizioComposto() != null) {
                            de.setUrl("accordiServizioParteComuneComponentiList.do", new Parameter[]{new Parameter("id", "" + accordoServizio.getId()), new Parameter("nome", accordoServizio.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                            if (contaListe.booleanValue()) {
                                AccordoServizioParteComuneServizioCompostoSintetico assc = accordoServizio.getServizioComposto();
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(assc.getServizioComponente().size()));
                            } else {
                                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                            }
                        } else {
                            de.setValue("");
                        }
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setUrl("accordiServizioParteComuneAllegatiList.do", new Parameter[]{new Parameter("id", "" + accordoServizio.getId()), new Parameter("nome", accordoServizio.getNome()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    if (contaListe.booleanValue()) {
                        searchForCount = new ConsoleSearch(true, 1);
                        this.apcCore.accordiAllegatiList(accordoServizio.getId().intValue(), (ISearch)searchForCount);
                        int num = searchForCount.getNumEntries(Liste.ACCORDI_ALLEGATI);
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(num));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport()) {
                ExporterUtils exporterUtils = new ExporterUtils(this.archiviCore);
                boolean exists = false;
                exists = "apc".equals(tipoAccordo) ? exporterUtils.existsAtLeastOneExportMode(ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE, this.request, this.session) : exporterUtils.existsAtLeastOneExportMode(ArchiveType.ACCORDO_SERVIZIO_COMPOSTO, this.request, this.session);
                if (exists) {
                    ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                    AreaBottoni ab = new AreaBottoni();
                    ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                    de = new DataElement();
                    de.setValue("Esporta");
                    if ("apc".equals(tipoAccordo)) {
                        de.setOnClick(AccordiServizioParteComuneCostanti.LABEL_APC_ESPORTA_SELEZIONATI_ONCLICK);
                    } else {
                        de.setOnClick(AccordiServizioParteComuneCostanti.LABEL_ASC_ESPORTA_SELEZIONATI_ONCLICK);
                    }
                    de.setDisabilitaAjaxStatus();
                    otherbott.add(de);
                    ab.setBottoni(otherbott);
                    bottoni.add(ab);
                    this.pd.setAreaBottoni(bottoni);
                }
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiComponentiCheckData(TipoOperazione tipoOp, String idServizioComponente) throws Exception {
        try {
            if (idServizioComponente == null || "".equals(idServizioComponente) || "-1".equals(idServizioComponente)) {
                this.pd.setMessage("&Egrave; necessario selezionare un componente.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiComponentiList(AccordoServizioParteComune as, ISearch ricerca, List<AccordoServizioParteComuneServizioCompostoServizioComponente> lista, String tipoAccordo) throws Exception {
        try {
            String labelASTitle = this.getLabelIdAccordo(as);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneComponenti", (Parameter[])new Parameter[]{new Parameter("id", "" + as.getId())});
            int idLista = Liste.ACCORDI_COMPONENTI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getSoggettoReferente().getTipo());
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter(AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo), "accordiServizioParteComuneList.do", new Parameter[]{AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)}));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("Componenti di " + labelASTitle, null));
            } else {
                lstParam.add(new Parameter("Componenti di " + labelASTitle, "accordiServizioParteComuneComponentiList.do", new Parameter[]{new Parameter("id", "" + as.getId()), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)}));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Componenti", (String)search);
            }
            String[] labels = new String[]{"Servizio", "Soggetto Erogatore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (AccordoServizioParteComuneServizioCompostoServizioComponente componente : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setValue(this.getLabelNomeServizio(protocollo, componente.getTipo(), componente.getNome(), componente.getVersione()));
                    de.setIdToRemove("" + componente.getIdServizioComponente());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(this.getLabelNomeSoggetto(protocollo, componente.getTipoSoggetto(), componente.getNomeSoggetto()));
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiServizioComponentiToDati(TipoOperazione tipoOp, String idAccordo, String idServizioComponente, String tipoAccordo, String[] serviziList, String[] serviziListLabel, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Componente");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setValue(idAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        de = new DataElement();
        de.setValue(tipoAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoSICA");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Servizio");
        de.setType(DataElementType.SELECT);
        de.setName("componente");
        de.setValues(serviziList);
        de.setLabels(serviziListLabel);
        if (idServizioComponente != null) {
            de.setSelected(idServizioComponente);
        }
        dati.add(de);
        return dati;
    }

    public void prepareAccordiPorttypeOperationMessagePartList(ISearch ricerca, List<MessagePart> lista, AccordoServizioParteComune as, String tipoAccordo, String nomePT, String nomeOp, boolean isMessageInput) throws Exception {
        try {
            String id = this.getParameter("id");
            int idLista = Liste.ACCORDI_PORTTYPE_AZIONI_MESSAGE_INPUT;
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pIdAccordo = new Parameter("id", id);
            Parameter pNomeAccordo = new Parameter("nome", as.getNome());
            Parameter pNomePt = new Parameter("nomept", nomePT);
            Parameter pNomeOp = new Parameter("nomeop", nomeOp);
            Parameter pTipoMsg = new Parameter("msgop", isMessageInput ? "i" : "o");
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            if (!isMessageInput) {
                idLista = Liste.ACCORDI_PORTTYPE_AZIONI_MESSAGE_OUTPUT;
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComunePortTypeOperationsMessage", (Parameter[])new Parameter[]{pIdAccordo, pTipoAccordo, pNomePt, pNomeOp, pTipoMsg});
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object labelPortTypes = isModalitaVistaApiCustom != false ? "Servizi" : "Servizi di " + labelASTitle;
            listaParams.add(new Parameter((String)labelPortTypes, "accordiServizioParteComunePortTypesList.do", new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo}));
            String labelOperations = "Azioni di " + nomePT;
            listaParams.add(new Parameter(labelOperations, "accordiServizioParteComunePortTypeOperationsList.do", new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo, pNomePt}));
            String labelOperation = nomeOp;
            listaParams.add(new Parameter(labelOperation, "accordiServizioParteComunePortTypeOperationsChange.do", new Parameter[]{pIdAccordo, pNomeOp, pNomePt, pTipoAccordo}));
            String labelMessage = "Message Input";
            if (!isMessageInput) {
                labelMessage = "Message Output";
            }
            labelMessage = isModalitaVistaApiCustom != false ? labelMessage : labelMessage + " di " + nomeOp;
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter(labelMessage, null));
            } else {
                listaParams.add(new Parameter(labelMessage, "accordiServizioParteComunePortTypeOperationsMessageList.do", new Parameter[]{pIdAccordo, pNomeAccordo, pNomePt, pNomePt, pTipoMsg, pTipoAccordo}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Azioni", (String)search);
            }
            String[] labels = new String[]{"Nome"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (MessagePart op : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    Parameter pPart = new Parameter("msgpartname", op.getName());
                    de.setUrl("accordiServizioParteComunePortTypeOperationsMessageChange.do", new Parameter[]{pIdAccordo, pNomeOp, pNomePt, pTipoMsg, pPart, AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    de.setValue(op.getName());
                    de.setIdToRemove(op.getName());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiPorttypeOperationMessageToDati(TipoOperazione tipoOp, List<DataElement> dati, String idAccordo, String tipoAccordo, String nomept, String nomeop, String messagePartName, String messagePartType, String messagePartLocalName, String messagePartNS, String tipoMessage) {
        DataElement de = new DataElement();
        de.setLabel("Informazioni WSDL Part");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("id");
        de.setValue(idAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        de = new DataElement();
        de.setValue(tipoAccordo);
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoAccordo");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(nomept);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomept");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(nomeop);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomeop");
        dati.add(de);
        de = new DataElement();
        de.setValue(tipoMessage);
        de.setType(DataElementType.HIDDEN);
        de.setName("msgop");
        dati.add(de);
        de = new DataElement();
        de.setValue(messagePartName);
        de.setLabel("Name");
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("msgpartname");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Type");
        de.setType(DataElementType.SELECT);
        de.setName("msgparttype");
        de.setValues(AccordiServizioParteComuneCostanti.PORT_TYPE_OPERATION_MESSAGE_PART_TYPE);
        de.setLabels(AccordiServizioParteComuneCostanti.LABEL_PORT_TYPE_OPERATION_MESSAGE_PART_TYPE);
        de.setSelected(messagePartType);
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(messagePartLocalName);
        de.setLabel("Local Name");
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setName("msgpartlocalname");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue(messagePartNS);
        de.setLabel("Namespace");
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setName("msgpartns");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public boolean accordiPorttypeOperationMessageCheckData(TipoOperazione tipoOperazione) throws Exception {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String nomept = this.getParameter("nomept");
            String nomeop = this.getParameter("nomeop");
            String tipoAccordo = this.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            String tipoMessage = this.getParameter("msgop");
            boolean isMessageInput = tipoMessage.equals("i");
            String messagePartName = this.getParameter("msgpartname");
            String messagePartLocalName = this.getParameter("msgpartlocalname");
            String messagePartNs = this.getParameter("msgpartns");
            AccordoServizioParteComune as = this.apcCore.getAccordoServizioFull(idInt);
            PortType pt = null;
            Operation operation = null;
            block4: for (int i = 0; i < as.sizePortTypeList(); ++i) {
                pt = as.getPortType(i);
                if (!nomept.equals(pt.getNome())) continue;
                for (Operation opTmp : pt.getAzioneList()) {
                    if (!opTmp.getNome().equals(nomeop)) continue;
                    operation = opTmp;
                    continue block4;
                }
            }
            Message m = null;
            m = isMessageInput ? operation.getMessageInput() : operation.getMessageOutput();
            if (messagePartName == null || messagePartName.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Name.");
                return false;
            }
            if (messagePartName.indexOf(" ") != -1) {
                this.pd.setMessage("Il campo Name non pu&ograve; contenere spazi");
                return false;
            }
            if (messagePartLocalName == null || messagePartLocalName.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Local Name.");
                return false;
            }
            if (messagePartLocalName.indexOf(" ") != -1) {
                this.pd.setMessage("Il campo Local Name non pu&ograve; contenere spazi");
                return false;
            }
            if (messagePartNs == null || messagePartNs.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Namespace.");
                return false;
            }
            if (messagePartNs.indexOf(" ") != -1) {
                this.pd.setMessage("Il campo Namespace non pu&ograve; contenere spazi");
                return false;
            }
            try {
                URI.create(messagePartNs);
            }
            catch (Exception e) {
                this.pd.setMessage("Il campo Namespace non contiene una URI valida");
                return false;
            }
            if (!this.checkLength255(messagePartName, "Name")) {
                return false;
            }
            if (!this.checkLength255(messagePartLocalName, "Local Name")) {
                return false;
            }
            if (!this.checkLength255(messagePartNs, "Namespace")) {
                return false;
            }
            if (tipoOperazione.equals((Object)TipoOperazione.ADD) && m != null) {
                for (MessagePart part : m.getPartList()) {
                    if (!part.getName().equals(messagePartName)) continue;
                    this.pd.setMessage("Il part '" + nomeop + "' &egrave; gi&agrave; stata associato al " + (isMessageInput ? "messaggio di input." : "messaggio di output."));
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean setMessageWarningStatoConsistenzaAccordo(boolean create, AccordoServizioParteComune as) {
        String msgError = null;
        if (create) {
            if (ServiceBinding.REST.equals((Object)as.getServiceBinding())) {
                if (as.sizeResourceList() <= 0) {
                    msgError = "Completare la configurazione dell'API appena creata definendo almeno una risorsa";
                }
            } else if (as.sizePortTypeList() <= 0) {
                msgError = "Completare la configurazione dell'API appena creata definendo almeno un servizio";
            } else if (as.sizePortTypeList() == 1) {
                if (as.getPortType(0).sizeAzioneList() <= 0) {
                    msgError = "Completare la configurazione dell'API appena creata definendo almeno un'azione per il servizio";
                }
            } else {
                for (PortType portType : as.getPortTypeList()) {
                    if (portType.sizeAzioneList() > 0) continue;
                    msgError = "Completare la configurazione dell'API appena creata definendo almeno un'azione nei servizi che non la possiedono";
                }
            }
        } else if (ServiceBinding.REST.equals((Object)as.getServiceBinding())) {
            if (as.sizeResourceList() <= 0) {
                msgError = "Completare la configurazione dell'API appena modificata definendo almeno una risorsa";
            }
        } else if (as.sizePortTypeList() <= 0) {
            msgError = "Completare la configurazione dell'API appena modificata definendo almeno un servizio";
        } else if (as.sizePortTypeList() == 1) {
            if (as.getPortType(0).sizeAzioneList() <= 0) {
                msgError = "Completare la configurazione dell'API appena modificata definendo almeno un'azione per il servizio";
            }
        } else {
            for (PortType portType : as.getPortTypeList()) {
                if (portType.sizeAzioneList() > 0) continue;
                msgError = "Completare la configurazione dell'API appena modificata definendo almeno un'azione nei servizi che non la possiedono";
            }
        }
        if (msgError != null) {
            Dialog dialog = new Dialog();
            dialog.setTitolo("Attenzione");
            dialog.setHeaderRiga1(msgError);
            String[][] bottoni = new String[][]{{"Chiudi", ""}};
            this.pd.setBottoni(bottoni);
            this.pd.setDialog(dialog);
            return true;
        }
        return false;
    }

    public void prepareAccordiResourcesList(String idApc, AccordoServizioParteComune as, List<Resource> lista, ISearch ricerca, String tipoAccordo) throws Exception {
        try {
            Object labelRisorse;
            String uri = null;
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", idApc);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneResources", (Parameter[])new Parameter[]{pIdAccordo, pTipoAccordo, pNomeAccordo});
            int idLista = Liste.ACCORDI_API_RESOURCES;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterHttpMethod = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroHttpMethod");
            this.addFilterHttpMethod(filterHttpMethod, false);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object object = labelRisorse = isModalitaVistaApiCustom != false ? "Risorse" : "Risorse di " + labelASTitle;
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter((String)labelRisorse, null));
            } else {
                listaParams.add(new Parameter((String)labelRisorse, "accordiServizioParteComuneResourcesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            this.pd.setSearchLabel("Path");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Risorse", (String)search);
            }
            ArrayList<String> labelList = new ArrayList<String>();
            labelList.add("Method");
            labelList.add("Path");
            labelList.add("Descrizione");
            labelList.add("Uso");
            String[] labels = labelList.toArray(new String[labelList.size()]);
            this.pd.setLabels(labels);
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            boolean existsBigDescription = false;
            if (lista != null) {
                for (Resource risorsa : lista) {
                    if (risorsa.getDescrizione() == null || risorsa.getDescrizione().length() <= 30) continue;
                    existsBigDescription = true;
                    break;
                }
                for (Resource risorsa : lista) {
                    String labelParametroApcResourcesHttpMethodQualsiasi = "Qualsiasi";
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    ArrayList<Parameter> parametriChangeRisorsa = new ArrayList<Parameter>();
                    parametriChangeRisorsa.add(new Parameter("id", idApc));
                    parametriChangeRisorsa.add(new Parameter("idRs", "" + risorsa.getId()));
                    parametriChangeRisorsa.add(AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo));
                    String nomeRisorsa = risorsa.getNome();
                    String detailURL = new Parameter("", "accordiServizioParteComuneResourcesChange.do", parametriChangeRisorsa.toArray(new Parameter[parametriChangeRisorsa.size()])).getValue();
                    DataElement de = this.getDataElementHTTPMethodResource(risorsa, labelParametroApcResourcesHttpMethodQualsiasi, detailURL);
                    de.setToolTip(nomeRisorsa);
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("accordiServizioParteComuneResourcesChange.do", parametriChangeRisorsa.toArray(new Parameter[parametriChangeRisorsa.size()]));
                    if (risorsa.getPath() == null || "".equals(risorsa.getPath())) {
                        de.setValue("*");
                    } else {
                        de.setValue(risorsa.getPath());
                    }
                    de.setToolTip(nomeRisorsa);
                    de.setCopyToClipboard(risorsa.getPath());
                    de.setIdToRemove(nomeRisorsa);
                    if (!existsBigDescription) {
                        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setValue(risorsa.getDescrizione());
                    e.add(de);
                    String methodPath = NamingUtils.getLabelResource((Resource)risorsa);
                    if (methodPath == null) {
                        methodPath = risorsa.getNome();
                    }
                    this.addInUsoButtonVisualizzazioneClassica(e, methodPath, risorsa.getNome() + "@" + this.idAccordoFactory.getUriFromAccordo(as), InUsoType.RISORSA);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiResourceToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String idAccordo, Long idRisorsa, String nomeRisorsa, String descrizione, String path, String httpMethod, MessageType messageType, String stato, String tipoAccordo, String protocollo, IProtocolFactory<?> protocolFactory, org.openspcoop2.message.constants.ServiceBinding serviceBinding, MessageType messageTypeRichiesta, MessageType messageTypeRisposta, String profProtocollo, String filtrodupaz, String deffiltrodupaz, String confricaz, String defconfricaz, String idcollaz, String defidcollaz, String idRifRichiestaAz, String defIdRifRichiestaAz, String consordaz, String defconsordaz, String scadenzaaz, String defscadenzaaz, boolean inUse) throws Exception {
        try {
            int num;
            ConsoleSearch searchForCount;
            boolean almostOneSupported;
            boolean modificheAbilitate = false;
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                modificheAbilitate = true;
            } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
                modificheAbilitate = true;
            } else if (!StatiAccordo.finale.toString().equals(stato)) {
                modificheAbilitate = true;
            }
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            DataElement de = new DataElement();
            de.setValue(idAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setValue(tipoAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoAccordo");
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Risorsa");
            dati.add(de);
            DataElement deHttpMethod = this.getHttpMethodDataElement(tipoOperazione, httpMethod);
            if (inUse) {
                deHttpMethod.setType(DataElementType.TEXT);
                deHttpMethod.setValue(httpMethod);
            }
            dati.add(deHttpMethod);
            boolean nameRequired = "ALL".equals(httpMethod) || httpMethod == null;
            de = new DataElement();
            de.setLabel("Path");
            de.setValue(path);
            de.setName("pathRs");
            if (inUse) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(!nameRequired);
                List<String> l = this.apcCore.getGetApiResourcePathQualsiasiSpecialChar();
                if (de.isRequired()) {
                    boolean httpMethodAndPathQualsiasi = this.apcCore.isApiResourceHttpMethodAndPathQualsiasiEnabled();
                    if (httpMethodAndPathQualsiasi && l != null && !l.isEmpty()) {
                        de.setInfo("Path", AccordiServizioParteComuneCostanti.getLABEL_PARAMETRO_APC_RESOURCES_PATH_INFO(l.get(0), true));
                    }
                } else if (l != null && !l.isEmpty()) {
                    de.setInfo("Path", AccordiServizioParteComuneCostanti.getLABEL_PARAMETRO_APC_RESOURCES_PATH_INFO(l.get(0), false));
                }
                de.setRequired(false);
            }
            if (!modificheAbilitate && (path == null || "".equals(path))) {
                de.setValue(" ");
            }
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nomeRisorsa);
            de.setName("nomeRs");
            if (inUse) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.TEXT_EDIT);
                if (!nameRequired) {
                    de.setNote("Se non definito verr&agrave; automaticamente generato un identificativo univoco");
                }
                de.setRequired(nameRequired);
            }
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Descrizione");
            de.setValue(descrizione);
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            if (!modificheAbilitate && (descrizione == null || "".equals(descrizione))) {
                de.setValue(" ");
            }
            de.setName("descrizioneRs");
            de.setSize(this.getSize());
            dati.add(de);
            boolean hiddenMessageType = this.isModalitaStandard();
            dati.add(this.getMessageTypeDataElement("messageType", protocolFactory, serviceBinding, messageType, hiddenMessageType));
            boolean filtroDuplicatiSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.FILTRO_DUPLICATI);
            boolean confermaRicezioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONFERMA_RICEZIONE);
            boolean collaborazioneSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.COLLABORAZIONE);
            boolean idRiferimentoRichiestaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA);
            boolean consegnaInOrdineSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.CONSEGNA_IN_ORDINE);
            boolean scadenzaSupportato = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.SCADENZA);
            boolean bl = almostOneSupported = filtroDuplicatiSupportato || confermaRicezioneSupportato || collaborazioneSupportato || idRiferimentoRichiestaSupportato || consegnaInOrdineSupportato || scadenzaSupportato;
            if (almostOneSupported) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Informazioni Protocollo");
                dati.add(de);
            }
            if (this.isModalitaStandard()) {
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("profBusta");
                de.setValue("ridefinito");
                dati.add(de);
                profProtocollo = "ridefinito";
            } else {
                de = new DataElement();
                de.setLabel("Profilo");
                de.setType(DataElementType.SELECT);
                de.setName("profBusta");
                if (modificheAbilitate && almostOneSupported) {
                    de.setValues(AccordiServizioParteComuneCostanti.INFORMAZIONI_PROTOCOLLO_MODALITA);
                    de.setLabels(AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO);
                    de.setSelected(profProtocollo);
                    de.setPostBack(true);
                } else {
                    if (almostOneSupported) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    if (profProtocollo.equals("default")) {
                        de.setValue("profilo API");
                    } else {
                        de.setValue("ridefinito");
                    }
                }
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Filtro Duplicati");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(deffiltrodupaz);
            } else if (profProtocollo.equals("ridefinito") && !filtroDuplicatiSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)filtrodupaz) || CostantiRegistroServizi.ABILITATO.equals(filtrodupaz)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)filtrodupaz) || CostantiRegistroServizi.ABILITATO.equals(filtrodupaz)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("filtrodupaz");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Conferma Ricezione");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defconfricaz);
            } else if (profProtocollo.equals("ridefinito") && !confermaRicezioneSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)confricaz) || CostantiRegistroServizi.ABILITATO.equals(confricaz)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)confricaz) || CostantiRegistroServizi.ABILITATO.equals(confricaz)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("confricaz");
            dati.add(de);
            de = new DataElement();
            de.setLabel("ID Conversazione");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defidcollaz);
            } else if (profProtocollo.equals("ridefinito") && !collaborazioneSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idcollaz) || CostantiRegistroServizi.ABILITATO.equals(idcollaz)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idcollaz) || CostantiRegistroServizi.ABILITATO.equals(idcollaz)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("idcollaz");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Riferimento ID Richiesta");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defIdRifRichiestaAz);
            } else if (profProtocollo.equals("ridefinito") && !idRiferimentoRichiestaSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaAz) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiestaAz)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)idRifRichiestaAz) || CostantiRegistroServizi.ABILITATO.equals(idRifRichiestaAz)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("idRifReqAz");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Consegna in Ordine");
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defconsordaz);
            } else if (profProtocollo.equals("ridefinito") && !consegnaInOrdineSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (modificheAbilitate) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)consordaz) || CostantiRegistroServizi.ABILITATO.equals(consordaz)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.TEXT);
                if (ServletUtils.isCheckBoxEnabled((String)consordaz) || CostantiRegistroServizi.ABILITATO.equals(consordaz)) {
                    de.setValue(CostantiRegistroServizi.ABILITATO.toString());
                } else {
                    de.setValue(CostantiRegistroServizi.DISABILITATO.toString());
                }
            }
            de.setName("consordaz");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Scadenza");
            de.setValue(scadenzaaz);
            if (profProtocollo.equals("default")) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defscadenzaaz);
            } else if (profProtocollo.equals("ridefinito") && !scadenzaSupportato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(defscadenzaaz);
            } else {
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(scadenzaaz);
                if (!modificheAbilitate && (scadenzaaz == null || "".equals(scadenzaaz))) {
                    de.setValue(" ");
                }
            }
            de.setName("scadenzaaz");
            de.setSize(this.getSize());
            dati.add(de);
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && !this.isModalitaStandard() || !hiddenMessageType) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Richiesta");
                dati.add(de);
            }
            dati.add(this.getMessageTypeDataElement("messageTypeReq", protocolFactory, serviceBinding, messageTypeRichiesta, hiddenMessageType));
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                de = new DataElement();
                de.setValue("" + idRisorsa.intValue());
                de.setType(DataElementType.HIDDEN);
                de.setName("idRs");
                dati.add(de);
            }
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && !this.isModalitaStandard()) {
                if (contaListe.booleanValue()) {
                    AccordoServizioParteComuneSintetico as = this.apcCore.getAccordoServizioSintetico(Integer.parseInt(idAccordo));
                    for (int i = 0; i < as.getResource().size(); ++i) {
                        ResourceSintetica res1 = (ResourceSintetica)as.getResource().get(i);
                        if (idRisorsa.intValue() == res1.getId().intValue()) break;
                    }
                }
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("accordiServizioParteComuneResourcesRepresentationList.do", new Parameter[]{new Parameter("id", idAccordo), new Parameter("nomeRs", nomeRisorsa), new Parameter("req", "true"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                if (contaListe.booleanValue()) {
                    searchForCount = new ConsoleSearch(true, 1);
                    this.apcCore.accordiResourceRepresentationsList(idRisorsa, true, null, (ISearch)searchForCount);
                    num = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES_REPRESENTATION_REQUEST);
                    de.setValue("Rappresentazione (" + num + ")");
                } else {
                    de.setValue("Rappresentazione");
                }
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("accordiServizioParteComuneResourcesParametersList.do", new Parameter[]{new Parameter("id", idAccordo), new Parameter("nomeRs", nomeRisorsa), new Parameter("req", "true"), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                if (contaListe.booleanValue()) {
                    searchForCount = new ConsoleSearch(true, 1);
                    this.apcCore.accordiResourceParametersList(idRisorsa, true, null, (ISearch)searchForCount);
                    num = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES_PARAMETERS_REQUEST);
                    de.setValue("Parametri (" + num + ")");
                } else {
                    de.setValue("Parametri");
                }
                dati.add(de);
            }
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && !this.isModalitaStandard() || !hiddenMessageType) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Risposta");
                dati.add(de);
            }
            dati.add(this.getMessageTypeDataElement("messageTypeRes", protocolFactory, serviceBinding, messageTypeRisposta, hiddenMessageType));
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && !this.isModalitaStandard()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("accordiServizioParteComuneResourcesRisposteList.do", new Parameter[]{new Parameter("id", idAccordo), new Parameter("nomeRs", nomeRisorsa), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                if (contaListe.booleanValue()) {
                    searchForCount = new ConsoleSearch(true, 1);
                    this.apcCore.accordiResourceResponseList(idRisorsa, (ISearch)searchForCount);
                    num = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES_RESPONSE);
                    de.setValue("Risposte (" + num + ")");
                } else {
                    de.setValue("Risposte");
                }
                dati.add(de);
            }
            return dati;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiResourceCheckData(TipoOperazione tipoOp, String id, String nomeRisorsa, String nomeRisorsaProposto, String path, String httpMethod, String descr, MessageType messageType, String oldNomeRisorsa, String oldNomeRisorsaProposto, String oldPath, String oldHttpMethod, String profProtocollo, String filtrodupaz, String confricaz, String idcollaz, String idRifRichiestaAz, String consordaz, String scadenzaaz) throws Exception {
        try {
            boolean httpMethodAndPathQualsiasi;
            if (filtrodupaz != null && (filtrodupaz.equals("null") || filtrodupaz.equals("no"))) {
                filtrodupaz = null;
            }
            if (confricaz != null && (confricaz.equals("null") || confricaz.equals("no"))) {
                confricaz = null;
            }
            if (idcollaz != null && (idcollaz.equals("null") || idcollaz.equals("no"))) {
                idcollaz = null;
            }
            if (idRifRichiestaAz != null && (idRifRichiestaAz.equals("null") || idRifRichiestaAz.equals("no"))) {
                idRifRichiestaAz = null;
            }
            if (consordaz != null && (consordaz.equals("null") || consordaz.equals("no"))) {
                consordaz = null;
            }
            if ((path == null || path.equals("")) && httpMethod != null && !(httpMethodAndPathQualsiasi = this.apcCore.isApiResourceHttpMethodAndPathQualsiasiEnabled())) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Path");
                return false;
            }
            if (path != null && path.contains(" ")) {
                this.pd.setMessage("Il campo Path non pu&ograve; contenere spazi bianchi");
                return false;
            }
            if (nomeRisorsa != null && !"".equals(nomeRisorsa)) {
                if (!this.checkLength255(nomeRisorsa, "Nome")) {
                    return false;
                }
            } else if (nomeRisorsaProposto != null && !"".equals(nomeRisorsaProposto)) {
                if (!this.checkLength255(nomeRisorsaProposto, "Nome")) {
                    this.pd.setMessage(this.pd.getMessage() + "<br/>Il nome auto-generato rispetto al path ed al method supera la lunghezza massima consentita; ridefinire un nome manualmente");
                    return false;
                }
            } else {
                HttpMethod http = HttpMethod.toEnumConstant((String)httpMethod);
                if (http == null) {
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Nome");
                    return false;
                }
            }
            if (descr != null && !"".equals(descr) && !this.checkLength255(descr, "Descrizione")) {
                return false;
            }
            if (path != null && !"".equals(path)) {
                if (!this.checkLength255(path, "Path")) {
                    return false;
                }
                if (this.apcCore.isApiResourcePathValidatorEnabled()) {
                    try {
                        ApiUtilities.validatePath((String)path);
                    }
                    catch (ValidatorException e) {
                        this.pd.setMessage(e.getMessage());
                        return false;
                    }
                }
            }
            if (!nomeRisorsa.equals("") && !this.checkNCName(nomeRisorsa, "Nome")) {
                return false;
            }
            if (!profProtocollo.equals("default") && !profProtocollo.equals("ridefinito")) {
                this.pd.setMessage("Il profilo  dev'essere \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO[0] + "\" o \"" + AccordiServizioParteComuneCostanti.LABEL_INFORMAZIONI_PROTOCOLLO_ACCORDO[1] + "\"");
                return false;
            }
            if (profProtocollo.equals("ridefinito")) {
                if (filtrodupaz != null && !filtrodupaz.equals("yes")) {
                    this.pd.setMessage("Filtro Duplicati dev'essere selezionato o deselezionato");
                    return false;
                }
                if (confricaz != null && !confricaz.equals("yes")) {
                    this.pd.setMessage("Conferma Ricezione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (idcollaz != null && !idcollaz.equals("yes")) {
                    this.pd.setMessage("ID Conversazione dev'essere selezionata o deselezionata");
                    return false;
                }
                if (idRifRichiestaAz != null && !idRifRichiestaAz.equals("yes")) {
                    this.pd.setMessage("Riferimento ID Richiesta dev'essere selezionata o deselezionata");
                    return false;
                }
                if (consordaz != null && !consordaz.equals("yes")) {
                    this.pd.setMessage("Consegna in Ordine dev'essere selezionata o deselezionata");
                    return false;
                }
                if (!scadenzaaz.equals("") && !this.checkNumber(scadenzaaz, "Scadenza", false)) {
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (!nomeRisorsa.equals("") && (giaRegistrato = this.apcCore.existsAccordoServizioResource(nomeRisorsaProposto, Integer.parseInt(id)))) {
                    this.pd.setMessage("La Risorsa " + nomeRisorsaProposto + " &egrave; gi&agrave; stata associata alla API");
                    return false;
                }
                if (!this.checkHttpMethodAndPath(httpMethod, path, id, null)) {
                    return false;
                }
            } else {
                if (!nomeRisorsaProposto.equals(oldNomeRisorsa) && !nomeRisorsaProposto.equals("") && (giaRegistrato = this.apcCore.existsAccordoServizioResource(nomeRisorsaProposto, Integer.parseInt(id)))) {
                    this.pd.setMessage("La Risorsa " + nomeRisorsaProposto + " &egrave; gi&agrave; stata associata alla API");
                    return false;
                }
                boolean modificatoPath = false;
                modificatoPath = oldPath != null ? !oldPath.equals(path) : path != null;
                boolean modificatoHttpMethod = false;
                if (oldHttpMethod != null) {
                    modificatoHttpMethod = !oldHttpMethod.equals(httpMethod);
                } else {
                    boolean bl = modificatoHttpMethod = httpMethod != null;
                }
                if ((modificatoPath || modificatoHttpMethod) && !this.checkHttpMethodAndPath(httpMethod, path, id, oldNomeRisorsa)) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    private boolean checkHttpMethodAndPath(String httpMethod, String path, String id, String nome) throws NumberFormatException, DriverRegistroServiziException {
        String p;
        String m = "Qualsiasi";
        if (httpMethod != null && !"".equals(httpMethod) && !"ALL".equals(httpMethod)) {
            m = httpMethod;
        }
        if ((p = path) == null || "".equals(p)) {
            p = "*";
        }
        String identificativoRisorsa = "HTTP Method: " + m + " , Path: " + p;
        boolean giaRegistrato = this.apcCore.existsAccordoServizioResource(httpMethod, path, Integer.parseInt(id), nome);
        if (giaRegistrato) {
            this.pd.setMessage("La Risorsa (" + identificativoRisorsa + ") &egrave; gi&agrave; stata associata alla API");
            return false;
        }
        boolean httpMethodAndPathQualsiasi = this.apcCore.isApiResourceHttpMethodAndPathQualsiasiEnabled();
        if (httpMethodAndPathQualsiasi && (path == null || "".equals(path))) {
            if (httpMethod != null && !"".equals(httpMethod) && !"ALL".equals(httpMethod)) {
                boolean registrataOperazioneQualsiasi = this.apcCore.existsAccordoServizioResource(null, path, Integer.parseInt(id), nome);
                if (registrataOperazioneQualsiasi) {
                    this.pd.setMessage("La Risorsa (" + identificativoRisorsa + ") \u00e8 in conflitto con una esistente (HTTP Method: Qualsiasi , Path: *)");
                    return false;
                }
            } else {
                HttpRequestMethod[] metodi;
                for (HttpRequestMethod httpRequestMethodCheck : metodi = HttpRequestMethod.values()) {
                    boolean registrataOperazioneMetodo = this.apcCore.existsAccordoServizioResource(httpRequestMethodCheck.toString(), path, Integer.parseInt(id), nome);
                    if (!registrataOperazioneMetodo) continue;
                    this.pd.setMessage("Non &egrave; possibile creare la Risorsa (" + identificativoRisorsa + ") \u00e8 in conflitto con una esistente (HTTP Method: " + httpRequestMethodCheck.toString() + " , Path: *)");
                    return false;
                }
            }
        }
        return true;
    }

    public DataElement getHttpMethodDataElement(TipoOperazione tipoOperazione, String httpMethod) {
        return this.getHttpMethodDataElement(tipoOperazione, httpMethod, "HTTP Method", "httpMethodRs", true, "Qualsiasi", "ALL");
    }

    public void prepareAccordiResourcesResponseList(ISearch ricerca, List<ResourceResponse> lista, String idApc, AccordoServizioParteComune as, String tipoAccordo, Resource risorsa) throws Exception {
        try {
            String uri = null;
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", idApc);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            Parameter pIdRisorsa = new Parameter("idRs", "" + risorsa.getId());
            Parameter pNomeRisorsa = new Parameter("nomeRs", risorsa.getNome());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneResourcesRisposte", (Parameter[])new Parameter[]{pIdAccordo, pTipoAccordo, pNomeAccordo, pNomeRisorsa, pIdRisorsa});
            int idLista = Liste.ACCORDI_API_RESOURCES_RESPONSE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object labelRisorse = isModalitaVistaApiCustom != false ? "Risorse" : "Risorse di " + labelASTitle;
            listaParams.add(new Parameter((String)labelRisorse, "accordiServizioParteComuneResourcesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
            String labelRisorsa = NamingUtils.getLabelResource((Resource)risorsa);
            listaParams.add(new Parameter(labelRisorsa, "accordiServizioParteComuneResourcesChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pIdRisorsa}));
            String labelResponse = "Risposte";
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter(labelResponse, null));
            } else {
                listaParams.add(new Parameter(labelResponse, "accordiServizioParteComuneResourcesRisposteList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Risposte", (String)search);
            }
            ArrayList<String> labelList = new ArrayList<String>();
            labelList.add("HTTP Status");
            labelList.add("Descrizione");
            String[] labels = labelList.toArray(new String[labelList.size()]);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (ResourceResponse risposta : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiServizioParteComuneResourcesRisposteChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa, new Parameter("statusResRisposta", "" + risposta.getStatus())});
                    if (ApiResponse.isDefaultHttpReturnCode((int)risposta.getStatus())) {
                        de.setValue("Default");
                    } else {
                        de.setValue("" + risposta.getStatus());
                    }
                    de.setIdToRemove("" + risposta.getStatus());
                    de.setWidthPx(90);
                    e.add(de);
                    de = new DataElement();
                    de.setValue(risposta.getDescrizione());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isModalitaStandard() || this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiResourceResponseCheckData(TipoOperazione tipoOp, String id, int idRisorsa, String nomeRisorsa, String status, String descr) throws Exception {
        try {
            boolean giaRegistrato;
            if (status != null && status.contains(" ")) {
                this.pd.setMessage("Il campo HTTP Status non pu&ograve; contenere spazi bianchi");
                return false;
            }
            int httpStatus = -1;
            if (status != null && !"".equals(status)) {
                try {
                    httpStatus = Integer.parseInt(status);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il formato del campo HTTP Status non &egrave; valido, indicare un HTTP Status valido");
                    return false;
                }
                if (!(httpStatus >= 200 && httpStatus <= 599 || ApiResponse.isDefaultHttpReturnCode((int)httpStatus))) {
                    this.pd.setMessage("Il formato del campo HTTP Status non &egrave; valido, indicare un HTTP Status compreso nell'intervallo [200-599]");
                    return false;
                }
            } else {
                httpStatus = ApiResponse.getDefaultHttpReturnCode();
            }
            if (descr != null && !"".equals(descr) && !this.checkLength255(descr, "Descrizione")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD) && (giaRegistrato = this.apcCore.existsAccordoServizioResourceResponse(idRisorsa, httpStatus))) {
                Object stato = "" + httpStatus;
                if (ApiResponse.isDefaultHttpReturnCode((int)httpStatus)) {
                    stato = "Default";
                }
                this.pd.setMessage("Una risposta con HTTP Status '" + (String)stato + "' &egrave; gi&agrave; stata associata alla Risorsa " + nomeRisorsa);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiResourcesRepresentationsList(String id, AccordoServizioParteComune as, List<ResourceRepresentation> lista, ConsoleSearch ricerca, String tipoAccordo, boolean isRequest, Resource risorsa, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            String uri = null;
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", id);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            Parameter pNomeRisorsa = new Parameter("nomeRs", risorsa.getNome());
            Parameter pIsRequest = new Parameter("req", "" + isRequest);
            Parameter pIdRisorsa = new Parameter("idRs", "" + risorsa.getId());
            String statusS = resourceResponse != null ? "" + resourceResponse.getStatus() : "";
            int status = resourceResponse != null ? resourceResponse.getStatus() : -1;
            Parameter pResponseStatus = new Parameter("statusResRisposta", statusS);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneResourcesRepresentation", (Parameter[])new Parameter[]{pIdAccordo, pTipoAccordo, pNomeAccordo, pNomeRisorsa, pIsRequest, pResponseStatus, pNomeRisorsa});
            int idLista = isRequest ? Liste.ACCORDI_API_RESOURCES_REPRESENTATION_REQUEST : Liste.ACCORDI_API_RESOURCES_REPRESENTATION_RESPONSE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object labelRisorse = isModalitaVistaApiCustom != false ? "Risorse" : "Risorse di " + labelASTitle;
            listaParams.add(new Parameter((String)labelRisorse, "accordiServizioParteComuneResourcesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
            String labelRisorsa = NamingUtils.getLabelResource((Resource)risorsa);
            listaParams.add(new Parameter(labelRisorsa, "accordiServizioParteComuneResourcesChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pIdRisorsa}));
            if (!isRequest) {
                String labelResponse = "Risposte";
                listaParams.add(new Parameter(labelResponse, "accordiServizioParteComuneResourcesRisposteList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa}));
                String labelRisposta = "HTTP Status " + (ApiResponse.isDefaultHttpReturnCode((int)status) ? "Default" : statusS);
                listaParams.add(new Parameter(labelRisposta, "accordiServizioParteComuneResourcesRisposteChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa, pResponseStatus}));
            }
            String labelRepresentation = "Rappresentazione";
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter(labelRepresentation, null));
            } else {
                listaParams.add(new Parameter(labelRepresentation, "accordiServizioParteComuneResourcesRepresentationList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa, pIsRequest, pResponseStatus}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            this.pd.setSearchLabel("Media Type");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Rappresentazione", (String)search);
            }
            ArrayList<String> labelList = new ArrayList<String>();
            labelList.add("Media Type");
            labelList.add("Nome");
            if (this.isModalitaAvanzata()) {
                labelList.add("Schema");
            }
            String[] labels = labelList.toArray(new String[labelList.size()]);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (ResourceRepresentation representation : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiServizioParteComuneResourcesRepresentationChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipoAccordo", tipoAccordo), pIsRequest, new Parameter("statusResRisposta", "" + status), new Parameter("nomeRs", risorsa.getNome()), new Parameter("idResRepres", "" + representation.getId())});
                    de.setValue(representation.getMediaType());
                    de.setIdToRemove(representation.getMediaType());
                    de.setToolTip(representation.getDescrizione());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(representation.getNome());
                    e.add(de);
                    if (this.isModalitaAvanzata()) {
                        de = new DataElement();
                        if (representation.getRepresentationType() != null) {
                            switch (representation.getRepresentationType()) {
                                case JSON: {
                                    de.setValue("Json");
                                    break;
                                }
                                default: {
                                    de.setValue("Xml");
                                    break;
                                }
                            }
                        } else {
                            de.setValue("Non Definito");
                        }
                        e.add(de);
                    }
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isModalitaStandard() || this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public void prepareAccordiResourcesParametersList(String id, AccordoServizioParteComune as, List<ResourceParameter> lista, ConsoleSearch ricerca, String tipoAccordo, boolean isRequest, Resource risorsa, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            String uri = null;
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            String labelASTitle = this.getLabelIdAccordo(as);
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", id);
            Parameter pNomeAccordo = new Parameter("nome", uri);
            Parameter pIsRequest = new Parameter("req", "" + isRequest);
            Parameter pIdRisorsa = new Parameter("idRs", "" + risorsa.getId());
            String statusS = resourceResponse != null ? "" + resourceResponse.getStatus() : "";
            int status = resourceResponse != null ? resourceResponse.getStatus() : -1;
            Parameter pResponseStatus = new Parameter("statusResRisposta", statusS);
            Parameter pNomeRisorsa = new Parameter("nomeRs", risorsa.getNome());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"accordiServizioParteComuneResourcesParameters", (Parameter[])new Parameter[]{pIdAccordo, pTipoAccordo, pNomeAccordo, pIsRequest, pResponseStatus, pNomeRisorsa});
            int idLista = isRequest ? Liste.ACCORDI_API_RESOURCES_PARAMETERS_REQUEST : Liste.ACCORDI_API_RESOURCES_PARAMETERS_RESPONSE;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
            List<Parameter> listaParams = this.getTitoloApc(TipoOperazione.LIST, as, tipoAccordo, labelASTitle, null, false);
            Object labelRisorse = isModalitaVistaApiCustom != false ? "Risorse" : "Risorse di " + labelASTitle;
            listaParams.add(new Parameter((String)labelRisorse, "accordiServizioParteComuneResourcesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
            String labelRisorsa = NamingUtils.getLabelResource((Resource)risorsa);
            listaParams.add(new Parameter(labelRisorsa, "accordiServizioParteComuneResourcesChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pIdRisorsa}));
            if (!isRequest) {
                String labelResponse = "Risposte";
                listaParams.add(new Parameter(labelResponse, "accordiServizioParteComuneResourcesRisposteList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa}));
                String labelRisposta = "HTTP Status " + (ApiResponse.isDefaultHttpReturnCode((int)status) ? "Default" : statusS);
                listaParams.add(new Parameter(labelRisposta, "accordiServizioParteComuneResourcesRisposteChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa, pResponseStatus}));
            }
            String labelParameters = "Parametri";
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                listaParams.add(new Parameter(labelParameters, null));
            } else {
                listaParams.add(new Parameter(labelParameters, "accordiServizioParteComuneResourcesParametersList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa, pIsRequest, pResponseStatus}));
                listaParams.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, listaParams);
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Parametri", (String)search);
            }
            ArrayList<String> labelList = new ArrayList<String>();
            labelList.add("Nome");
            labelList.add("Tipo Parametro");
            labelList.add("Obbligatorio");
            labelList.add("Tipo");
            labelList.add("Restrizioni");
            String[] labels = labelList.toArray(new String[labelList.size()]);
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (ResourceParameter parameter : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("accordiServizioParteComuneResourcesParametersChange.do", new Parameter[]{new Parameter("id", id), new Parameter("tipoAccordo", tipoAccordo), new Parameter("req", "" + isRequest), new Parameter("statusResRisposta", "" + status), pNomeRisorsa, new Parameter("idResParam", "" + parameter.getId())});
                    de.setValue(parameter.getNome());
                    de.setIdToRemove(parameter.getParameterType().toString() + "/" + parameter.getNome());
                    de.setToolTip(parameter.getDescrizione());
                    e.add(de);
                    de = new DataElement();
                    switch (parameter.getParameterType()) {
                        case COOKIE: {
                            de.setValue("Cookie");
                            break;
                        }
                        case DYNAMIC_PATH: {
                            de.setValue("Dynamic Path");
                            break;
                        }
                        case FORM: {
                            de.setValue("Form");
                            break;
                        }
                        case HEADER: {
                            de.setValue("Header");
                            break;
                        }
                        default: {
                            de.setValue("Query");
                        }
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setValue(parameter.getRequired() ? "Si" : "No");
                    e.add(de);
                    de = new DataElement();
                    de.setValue(parameter.getTipo());
                    e.add(de);
                    de = new DataElement();
                    if (parameter.getRestrizioni() != null) {
                        if (parameter.getRestrizioni().length() < 100) {
                            de.setValue(parameter.getRestrizioni());
                        } else {
                            de.setValue(parameter.getRestrizioni().substring(0, 97) + " ...");
                        }
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            if (this.isModalitaStandard() || this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiResourceResponseToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String id, String nomeAccordo, String tipoAccordo, String stato, String nomeRisorsa, String descrizione, String status) throws Exception {
        try {
            boolean modificheAbilitate = false;
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                modificheAbilitate = true;
            } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
                modificheAbilitate = true;
            } else if (!StatiAccordo.finale.toString().equals(stato)) {
                modificheAbilitate = true;
            }
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            DataElement de = new DataElement();
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setValue(tipoAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoAccordo");
            dati.add(de);
            de = new DataElement();
            de.setValue(nomeAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("nome");
            dati.add(de);
            de = new DataElement();
            de.setValue(nomeRisorsa);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomeRs");
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Risposta");
            dati.add(de);
            de = new DataElement();
            de.setName("statusResRisposta");
            de.setLabel("HTTP Status");
            int statoInt = -1;
            try {
                statoInt = Integer.parseInt(status);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ApiResponse.isDefaultHttpReturnCode((int)statoInt)) {
                de.setValue("Default");
            } else {
                de.setValue(status);
            }
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.setNote("Non fornire alcun valore per indicare uno stato di default");
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.TEXT);
                de.setName("statusResRisposta__label");
                DataElement deValue = new DataElement();
                deValue.setType(DataElementType.HIDDEN);
                deValue.setName("statusResRisposta");
                deValue.setValue(status);
                dati.add(deValue);
            }
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Descrizione");
            de.setValue(descrizione);
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            if (!modificheAbilitate && (descrizione == null || "".equals(descrizione))) {
                de.setValue(" ");
            }
            de.setName("descrizioneResRisposta");
            de.setSize(this.getSize());
            dati.add(de);
            Long idRisorsa = null;
            Long idResponse = null;
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                ConsoleSearch searchForCount;
                if (contaListe.booleanValue()) {
                    int i;
                    AccordoServizioParteComune as = this.apcCore.getAccordoServizioFull(Integer.parseInt(id));
                    Resource res1 = null;
                    for (i = 0; i < as.sizeResourceList(); ++i) {
                        res1 = as.getResource(i);
                        if (!nomeRisorsa.equals(res1.getNome())) continue;
                        idRisorsa = res1.getId();
                        break;
                    }
                    if (res1 != null) {
                        for (i = 0; i < res1.getResponseList().size(); ++i) {
                            ResourceResponse resourceResponse = res1.getResponse(i);
                            if (resourceResponse.getStatus() != Integer.parseInt(status)) continue;
                            idResponse = resourceResponse.getId();
                            break;
                        }
                    }
                }
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("accordiServizioParteComuneResourcesRepresentationList.do", new Parameter[]{new Parameter("id", id), new Parameter("nomeRs", nomeRisorsa), new Parameter("req", "false"), new Parameter("statusResRisposta", status), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                if (contaListe.booleanValue()) {
                    searchForCount = new ConsoleSearch(true, 1);
                    this.apcCore.accordiResourceRepresentationsList(idRisorsa, false, idResponse, (ISearch)searchForCount);
                    int num = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES_REPRESENTATION_RESPONSE);
                    de.setValue("Rappresentazione (" + num + ")");
                } else {
                    de.setValue("Rappresentazione");
                }
                dati.add(de);
                if (this.isModalitaAvanzata()) {
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl("accordiServizioParteComuneResourcesParametersList.do", new Parameter[]{new Parameter("id", id), new Parameter("nomeRs", nomeRisorsa), new Parameter("req", "false"), new Parameter("statusResRisposta", status), AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo)});
                    if (contaListe.booleanValue()) {
                        searchForCount = new ConsoleSearch(true, 1);
                        this.apcCore.accordiResourceParametersList(idRisorsa, false, idResponse, (ISearch)searchForCount);
                        int num = searchForCount.getNumEntries(Liste.ACCORDI_API_RESOURCES_PARAMETERS_RESPONSE);
                        de.setValue("Parametri (" + num + ")");
                    } else {
                        de.setValue("Parametri");
                    }
                    dati.add(de);
                }
            }
            return dati;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiResourceRepresentationToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String id, String stato, String tipoAccordo, String protocollo, IProtocolFactory<?> protocolFactory, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String nomeRisorsa, boolean isRequest, String statusS, Integer idRepInt, String mediaType, String nome, String descrizione, MessageType messageType, RepresentationType tipo, String tipoJson, String nomeXml, String namespaceXml, RepresentationXmlType xmlType) throws Exception {
        try {
            boolean modificheAbilitate = false;
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                modificheAbilitate = true;
            } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
                modificheAbilitate = true;
            } else if (!StatiAccordo.finale.toString().equals(stato)) {
                modificheAbilitate = true;
            }
            DataElement de = new DataElement();
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setValue(tipoAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoAccordo");
            dati.add(de);
            de = new DataElement();
            de.setValue(statusS);
            de.setType(DataElementType.HIDDEN);
            de.setName("statusResRisposta");
            dati.add(de);
            de = new DataElement();
            de.setValue("" + isRequest);
            de.setType(DataElementType.HIDDEN);
            de.setName("req");
            dati.add(de);
            de = new DataElement();
            de.setValue(nomeRisorsa);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomeRs");
            dati.add(de);
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                de = new DataElement();
                de.setValue("" + idRepInt);
                de.setType(DataElementType.HIDDEN);
                de.setName("idResRepres");
                dati.add(de);
            }
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Rappresentazione");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Media Type");
            de.setValue(mediaType);
            de.setRequired(true);
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.TEXT);
            }
            de.setName("mediaTypeResRepres");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nome);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("nomeResRepres");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Descrizione");
            de.setValue(descrizione);
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            if (!modificheAbilitate && (descrizione == null || "".equals(descrizione))) {
                de.setValue(" ");
            }
            de.setName("descrResRepres");
            de.setSize(this.getSize());
            dati.add(de);
            de = this.getMessageTypeDataElement("messageTypeResRepres", protocolFactory, serviceBinding, messageType, !this.core.isApiRestResourceRepresentationMessageTypeOverride());
            dati.add(de);
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) || this.isModalitaAvanzata()) {
                de = new DataElement();
                de.setType(DataElementType.SUBTITLE);
                de.setLabel("Definizione");
                dati.add(de);
                de = new DataElement();
                de.setLabel("Schema");
                de.setSelected(tipo != null ? tipo.getValue() : "nd");
                de.setType(DataElementType.SELECT);
                de.setName("tipoResRepres");
                de.setSize(this.getSize());
                de.setPostBack(true);
                RepresentationType[] representationTypes = RepresentationType.values();
                String[] values = new String[representationTypes.length + 1];
                String[] labels = new String[representationTypes.length + 1];
                labels[0] = "Non Definito";
                values[0] = "nd";
                block11: for (int i = 0; i < representationTypes.length; ++i) {
                    RepresentationType type = representationTypes[i];
                    switch (type) {
                        case JSON: {
                            labels[i + 1] = "Json";
                            values[i + 1] = "json";
                            continue block11;
                        }
                        default: {
                            labels[i + 1] = "Xml";
                            values[i + 1] = "xml";
                        }
                    }
                }
                de.setLabels(labels);
                de.setValues(values);
                dati.add(de);
                if (tipo != null) {
                    switch (tipo) {
                        case JSON: {
                            de = new DataElement();
                            de.setLabel("Tipo");
                            de.setValue(tipoJson);
                            de.setType(DataElementType.TEXT_EDIT);
                            de.setName("jsonTypeResRepres");
                            de.setSize(this.getSize());
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("Nome");
                            de.setValue(nomeXml);
                            de.setType(DataElementType.HIDDEN);
                            de.setName("xmlNameResRepres");
                            de.setSize(this.getSize());
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("Namespace");
                            de.setValue(namespaceXml);
                            de.setType(DataElementType.HIDDEN);
                            de.setName("xmlNamespaceResRepres");
                            de.setSize(this.getSize());
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("Tipo");
                            if (xmlType != null) {
                                de.setValue(xmlType.getValue());
                            }
                            de.setType(DataElementType.HIDDEN);
                            de.setName("xmlTipoResRepres");
                            de.setSize(this.getSize());
                            dati.add(de);
                            break;
                        }
                        default: {
                            de = new DataElement();
                            de.setLabel("Tipo");
                            de.setValue(tipoJson);
                            de.setType(DataElementType.HIDDEN);
                            de.setName("jsonTypeResRepres");
                            de.setSize(this.getSize());
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("Tipo");
                            if (xmlType != null) {
                                de.setSelected(xmlType.getValue());
                            }
                            de.setType(DataElementType.SELECT);
                            de.setName("xmlTipoResRepres");
                            de.setSize(this.getSize());
                            RepresentationXmlType[] representationXmlTypes = RepresentationXmlType.values();
                            String[] values2 = new String[representationXmlTypes.length];
                            String[] labels2 = new String[representationXmlTypes.length];
                            block12: for (int i = 0; i < representationXmlTypes.length; ++i) {
                                RepresentationXmlType type = representationXmlTypes[i];
                                switch (type) {
                                    case ELEMENT: {
                                        labels2[i] = "Element";
                                        values2[i] = "element";
                                        continue block12;
                                    }
                                    default: {
                                        labels2[i] = "Type";
                                        values2[i] = "type";
                                    }
                                }
                            }
                            de.setLabels(labels2);
                            de.setValues(values2);
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("Nome");
                            de.setValue(nomeXml);
                            de.setType(DataElementType.TEXT_EDIT);
                            de.setName("xmlNameResRepres");
                            de.setSize(this.getSize());
                            dati.add(de);
                            de = new DataElement();
                            de.setLabel("Namespace");
                            de.setValue(namespaceXml);
                            de.setType(DataElementType.TEXT_EDIT);
                            de.setName("xmlNamespaceResRepres");
                            de.setSize(this.getSize());
                            dati.add(de);
                            break;
                        }
                    }
                } else {
                    de = new DataElement();
                    de.setLabel("Tipo");
                    de.setValue(tipoJson);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("jsonTypeResRepres");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Nome");
                    de.setValue(nomeXml);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("xmlNameResRepres");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Namespace");
                    de.setValue(namespaceXml);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("xmlNamespaceResRepres");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Tipo");
                    de.setValue("");
                    de.setType(DataElementType.HIDDEN);
                    de.setName("xmlTipoResRepres");
                    de.setSize(this.getSize());
                    dati.add(de);
                }
            }
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(stato)) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
            return dati;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiResourceRepresentationCheckData(TipoOperazione tipoOp, String id, String nomeRisorsa, boolean isRequest, String statusS, String mediaType, String nome, String descr, MessageType messageType, RepresentationType tipo, String tipoJson, String nomeXml, String namespaceXml, RepresentationXmlType xmlType, Long idRisorsa, Long idResponse, String oldMediaType) throws Exception {
        try {
            boolean giaRegistrato;
            if (mediaType.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Media Type");
                return false;
            }
            if (!this.checkLength255(mediaType, "Media Type")) {
                return false;
            }
            if (nome != null && !"".equals(nome) && !this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (descr != null && !"".equals(descr) && !this.checkLength255(descr, "Descrizione")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato2 = this.apcCore.existsAccordoServizioResourceRepresentation(idRisorsa, isRequest, idResponse, mediaType);
                if (giaRegistrato2) {
                    String owner = isRequest ? "Risorsa " + nomeRisorsa : "Risposta  " + statusS;
                    this.pd.setMessage("La Response con Media Type: " + mediaType + " &egrave; gi&agrave; stata associata alla " + owner);
                    return false;
                }
            } else if (!oldMediaType.equals(mediaType) && (giaRegistrato = this.apcCore.existsAccordoServizioResourceRepresentation(idRisorsa, isRequest, idResponse, mediaType))) {
                String owner = isRequest ? "Risorsa " + nomeRisorsa : "Risposta  " + statusS;
                this.pd.setMessage("La Response con Media Type: " + mediaType + " &egrave; gi&agrave; stata associata alla " + owner);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<DataElement> addAccordiResourceParameterToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String id, String statoPackage, String tipoAccordo, String nomeRisorsa, boolean isRequest, String statusS, Integer idParInt, String nome, String descrizione, ParameterType tipoParametro, String tipo, String restrizioni, boolean required) throws Exception {
        try {
            boolean modificheAbilitate = false;
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                modificheAbilitate = true;
            } else if (!this.isShowGestioneWorkflowStatoDocumenti()) {
                modificheAbilitate = true;
            } else if (!StatiAccordo.finale.toString().equals(statoPackage)) {
                modificheAbilitate = true;
            }
            DataElement de = new DataElement();
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
            de = new DataElement();
            de.setValue(tipoAccordo);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoAccordo");
            dati.add(de);
            de = new DataElement();
            de.setValue(statusS);
            de.setType(DataElementType.HIDDEN);
            de.setName("statusResRisposta");
            dati.add(de);
            de = new DataElement();
            de.setValue("" + isRequest);
            de.setType(DataElementType.HIDDEN);
            de.setName("req");
            dati.add(de);
            de = new DataElement();
            de.setValue(nomeRisorsa);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomeRs");
            dati.add(de);
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                de = new DataElement();
                de.setValue("" + idParInt);
                de.setType(DataElementType.HIDDEN);
                de.setName("idResParam");
                dati.add(de);
            }
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Parametro");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo Parametro");
            de.setSize(this.getSize());
            de.setName("tipoParametroResParam");
            de.setSelected(tipoParametro.getValue());
            de.setType(DataElementType.SELECT);
            ParameterType[] parameterTypes = ParameterType.values();
            String[] values2 = new String[parameterTypes.length];
            String[] labels2 = new String[parameterTypes.length];
            block8: for (int i = 0; i < parameterTypes.length; ++i) {
                ParameterType type = parameterTypes[i];
                switch (type) {
                    case COOKIE: {
                        labels2[i] = "Cookie";
                        values2[i] = "cookie";
                        continue block8;
                    }
                    case DYNAMIC_PATH: {
                        labels2[i] = "Dynamic Path";
                        values2[i] = "dynamicPath";
                        continue block8;
                    }
                    case FORM: {
                        labels2[i] = "Form";
                        values2[i] = "form";
                        continue block8;
                    }
                    case HEADER: {
                        labels2[i] = "Header";
                        values2[i] = "header";
                        continue block8;
                    }
                    default: {
                        labels2[i] = "Query";
                        values2[i] = "query";
                    }
                }
            }
            de.setLabels(labels2);
            de.setValues(values2);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nome);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("nomeResParam");
            de.setSize(this.getSize());
            de.setRequired(true);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Descrizione");
            de.setValue(descrizione);
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            if (!modificheAbilitate && (descrizione == null || "".equals(descrizione))) {
                de.setValue(" ");
            }
            de.setName("descrResParam");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo");
            de.setValue(tipo);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("tipoResParam");
            de.setSize(this.getSize());
            de.setRequired(true);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Restrizioni");
            de.setValue(restrizioni);
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            de.setName("restrResParam");
            de.setSize(this.getSize());
            de.setRequired(false);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Obbligatorio");
            de.setType(DataElementType.CHECKBOX);
            de.setName("requiredResParam");
            de.setSize(this.getSize());
            de.setSelected(required);
            dati.add(de);
            this.pd.setDati(dati);
            if (this.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(statoPackage)) {
                this.pd.setAddButton(false);
                this.pd.setRemoveButton(false);
                this.pd.setSelect(false);
            } else {
                this.pd.setAddButton(true);
                this.pd.setRemoveButton(true);
                this.pd.setSelect(true);
            }
            return dati;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public boolean accordiResourceParameterCheckData(TipoOperazione tipoOp, String id, String nomeRisorsa, boolean isRequest, String statusS, String nome, String descr, ParameterType tipoParametro, String tipo, String restrizioni, boolean required, Long idResource, Long idResponse, ParameterType oldTipoParametro, String oldNome) throws Exception {
        try {
            boolean giaRegistrato;
            if (tipoParametro == null) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Tipo Parametro");
                return false;
            }
            if (nome == null || nome.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Nome");
                return false;
            }
            if (tipo == null || tipo.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Tipo");
                return false;
            }
            if (restrizioni != null && !"".equals(restrizioni)) {
                try {
                    ApiParameterSchema.toApiParameterSchema((String)restrizioni);
                }
                catch (Exception e) {
                    this.pd.setMessage("Restrizioni - " + e.getMessage());
                    return false;
                }
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(tipo, "Tipo")) {
                return false;
            }
            if (descr != null && !"".equals(descr) && !this.checkLength255(descr, "Descrizione")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato2 = this.apcCore.existsAccordoServizioResourceParameter(idResource, isRequest, idResponse, tipoParametro, nome);
                if (giaRegistrato2) {
                    String owner = isRequest ? "Risorsa " + nomeRisorsa : "Risposta " + statusS;
                    this.pd.setMessage("Il Parametro con Tipo Parametro: " + String.valueOf(tipoParametro) + " e Nome: " + nome + " &egrave; gi&agrave; stato associato alla " + owner);
                    return false;
                }
            } else if (!(oldTipoParametro.equals((Object)tipoParametro) && oldNome.equals(nome) || !(giaRegistrato = this.apcCore.existsAccordoServizioResourceParameter(idResource, isRequest, idResponse, tipoParametro, nome)))) {
                String owner = isRequest ? "Risorsa " + nomeRisorsa : "Risposta " + statusS;
                this.pd.setMessage("Il Parametro con Tipo Parametro: " + String.valueOf(tipoParametro) + " e Nome: " + nome + " &egrave; gi&agrave; stato associato alla " + owner);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public List<Parameter> getTitoloApc(TipoOperazione tipoOperazione, AccordoServizioParteComune as, String tipoAccordo, String labelASTitle, String servletNameApcChange, boolean addApcChange) throws Exception {
        return this.getTitoloApc(tipoOperazione, as, tipoAccordo, labelASTitle, servletNameApcChange, this.getParametroApiGestioneParziale("apiGestioneParziale"), addApcChange);
    }

    public List<Parameter> getTitoloApc(TipoOperazione tipoOperazione, AccordoServizioParteComune as, String tipoAccordo, String labelASTitle, String servletNameApcChange, String apiGestioneParziale, boolean addApcChange) throws Exception {
        String labelAccordoServizio = AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo);
        Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)this.session, (HttpServletRequest)this.request, (Boolean)false).getValue();
        String servletNameApcList = isModalitaVistaApiCustom != false ? "accordiServizioParteComuneApiList.do" : "accordiServizioParteComuneList.do";
        Parameter pIdAccordo = new Parameter("id", "" + as.getId());
        Parameter pNomeAccordo = new Parameter("nome", as.getNome());
        Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
        ArrayList<Parameter> listaParams = new ArrayList<Parameter>();
        listaParams.add(new Parameter(labelAccordoServizio, servletNameApcList, new Parameter[]{pTipoAccordo}));
        ArrayList<Parameter> listaParamsApcChange = new ArrayList<Parameter>();
        listaParamsApcChange.add(pIdAccordo);
        listaParamsApcChange.add(pNomeAccordo);
        listaParamsApcChange.add(pTipoAccordo);
        String labelApcChange = labelASTitle;
        if (isModalitaVistaApiCustom.booleanValue()) {
            Parameter parameterApcApiChange = new Parameter(labelASTitle, "accordiServizioParteComuneApiChange.do", new Parameter[]{pIdAccordo, pNomeAccordo, pTipoAccordo});
            listaParams.add(parameterApcApiChange);
            if ("apiInfoGenerali".equals(apiGestioneParziale)) {
                labelApcChange = "Informazioni Generali";
            } else if ("apiProfilo".equals(apiGestioneParziale)) {
                labelApcChange = "Profilo Interoperabilit\u00e0";
            } else if ("apiSoggettoReferente".equals(apiGestioneParziale)) {
                labelApcChange = "Soggetto Referente";
            } else if ("apiDescrizione".equals(apiGestioneParziale)) {
                labelApcChange = "Descrizione";
            } else if ("apiGestioneSpecificaInterfacce".equals(apiGestioneParziale)) {
                labelApcChange = "Interfaccia";
            } else if ("apiOpzioniAvanzate".equals(apiGestioneParziale)) {
                labelApcChange = "Opzioni Avanzate";
            } else if ("apiGruppi".equals(apiGestioneParziale)) {
                labelApcChange = "Tags";
            }
            if (apiGestioneParziale == null) {
                apiGestioneParziale = "";
            }
            listaParamsApcChange.add(new Parameter("apiGestioneParziale", apiGestioneParziale));
        }
        if (addApcChange) {
            Parameter parameterApcChange = servletNameApcChange != null ? new Parameter(labelApcChange, servletNameApcChange, listaParamsApcChange) : new Parameter(labelApcChange, servletNameApcChange);
            listaParams.add(parameterApcChange);
        }
        return listaParams;
    }

    public String normalizePathEmpty(String path) {
        if (path != null) {
            String s = path.trim();
            List<String> l = this.apcCore.getGetApiResourcePathQualsiasiSpecialChar();
            if (l != null && l.contains(s)) {
                return "";
            }
        }
        return path;
    }

    public String getParametroApiGestioneParziale(String parameterName) throws ValidationException, DriverControlStationException {
        return this.getParametroApiGestioneParziale(parameterName, true);
    }

    public String getParametroApiGestioneParziale(String parameterName, boolean validate) throws ValidationException, DriverControlStationException {
        if (validate && !this.validaParametroApiGestioneParziale(parameterName)) {
            throw new ValidationException("Il parametro [" + parameterName + "] contiene un valore non valido.");
        }
        return this.getParameter(parameterName);
    }

    private boolean validaParametroApiGestioneParziale(String parameterToCheck) {
        String parameterValueFiltrato = this.request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(this.request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        return "apiInfoGenerali".equals(parameterValueFiltrato) || "apiSoggettoReferente".equals(parameterValueFiltrato) || "apiProfilo".equals(parameterValueFiltrato) || "apiDescrizione".equals(parameterValueFiltrato) || "apiGruppi".equals(parameterValueFiltrato) || "apiCanale".equals(parameterValueFiltrato) || "apiGestioneSpecificaInterfacce".equals(parameterValueFiltrato) || "apiOpzioniAvanzate".equals(parameterValueFiltrato) || "apiWsdlChange".equals(parameterValueFiltrato);
    }

    public String getParametroPortTypeOperationMessageType(String parameterName) throws ValidationException, DriverControlStationException {
        return this.getParametroPortTypeOperationMessageType(parameterName, true);
    }

    public String getParametroPortTypeOperationMessageType(String parameterName, boolean validate) throws ValidationException, DriverControlStationException {
        if (validate && !this.validaParametroPortTypeOperationMessageType(parameterName)) {
            throw new ValidationException("Il parametro [" + parameterName + "] contiene un valore non valido.");
        }
        return this.getParameter(parameterName);
    }

    private boolean validaParametroPortTypeOperationMessageType(String parameterToCheck) {
        String parameterValueFiltrato = this.request.getParameter(parameterToCheck);
        String parameterValueOriginale = Validatore.getInstance().getParametroOriginale(this.request, parameterToCheck);
        if (StringUtils.isEmpty((CharSequence)parameterValueOriginale)) {
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)parameterValueFiltrato)) {
            return false;
        }
        return "i".equals(parameterValueFiltrato) || "o".equals(parameterValueFiltrato);
    }
}

