/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCostanti;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaFruitoriWSDLChangeStrutsBean;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteSpecificaFruitoriWSDLChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
        try {
            AccordiServizioParteSpecificaFruitoriWSDLChangeStrutsBean strutsBean = new AccordiServizioParteSpecificaFruitoriWSDLChangeStrutsBean();
            strutsBean.consoleOperationType = ConsoleOperationType.CHANGE;
            AccordiServizioParteSpecificaHelper apsHelper = new AccordiServizioParteSpecificaHelper(request, pd, session);
            apsHelper.makeMenu();
            strutsBean.editMode = apsHelper.getParametroEditMode("edit-mode");
            strutsBean.id = apsHelper.getParametroLong("id");
            strutsBean.tipo = apsHelper.getParameter("tipo");
            strutsBean.wsdl = apsHelper.getParameter("wsdl");
            strutsBean.idSoggettoErogatoreDelServizio = apsHelper.getParametroLong("idSoggErogatore");
            if (strutsBean.idSoggettoErogatoreDelServizio == null || strutsBean.idSoggettoErogatoreDelServizio.equals("")) {
                PageData oldPD = ServletUtils.getPageDataFromSession((HttpServletRequest)request, (HttpSession)session);
                strutsBean.idSoggettoErogatoreDelServizio = oldPD.getHidden("idSoggErogatore");
            }
            strutsBean.idSoggettoFruitore = apsHelper.getParametroLong("providerFruitore");
            if (apsHelper.isMultipart()) {
                strutsBean.decodeRequestValidazioneDocumenti = true;
            }
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode)) {
                strutsBean.validazioneDocumenti = true;
            } else if (!strutsBean.decodeRequestValidazioneDocumenti) {
                String tmpValidazioneDocumenti = apsHelper.getParameter("validazioneDocumenti");
                strutsBean.validazioneDocumenti = "true".equalsIgnoreCase(tmpValidazioneDocumenti) || "yes".equalsIgnoreCase(tmpValidazioneDocumenti);
            }
            long idFruitoreLong = Integer.parseInt(strutsBean.id);
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore();
            SoggettiCore soggettiCore = new SoggettiCore(apsCore);
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(apsCore);
            Fruitore myFru = apsCore.getServizioFruitore(idFruitoreLong);
            long idServizioLong = myFru.getIdServizio();
            long idSoggettoFruitoreLong = myFru.getIdSoggetto();
            String oldwsdl = "";
            byte[] wsdlbyte = null;
            String tipologiaDocumentoScaricare = null;
            if (strutsBean.tipo.equals("wsdlimpler")) {
                wsdlbyte = myFru.getByteWsdlImplementativoErogatore();
                tipologiaDocumentoScaricare = "wsdlImplementativoErogatore";
            }
            if (strutsBean.tipo.equals("wsdlimplfru")) {
                wsdlbyte = myFru.getByteWsdlImplementativoFruitore();
                tipologiaDocumentoScaricare = "wsdlImplementativoFruitore";
            }
            if (wsdlbyte != null) {
                oldwsdl = new String(wsdlbyte);
            }
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idServizioLong);
            String titleServizio = apsHelper.getLabelIdServizio(asps);
            AccordoServizioParteComune as = apcCore.getAccordoServizioFull(idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
            ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(as.getServiceBinding());
            IDServizio ids = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getSoggettoReferente().getTipo());
            Soggetto mySogg2 = soggettiCore.getSoggettoRegistro(idSoggettoFruitoreLong);
            String tmpTitle = apsHelper.getLabelNomeSoggetto(protocollo, mySogg2.getTipo(), mySogg2.getNome());
            String label = null;
            if (apcCore.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(protocollo, serviceBinding)) {
                if (strutsBean.tipo.equals("wsdlimpler")) {
                    label = "WSDL Implementativo Erogatore di " + tmpTitle;
                }
                if (strutsBean.tipo.equals("wsdlimplfru")) {
                    label = "WSDL Implementativo Fruitore di " + tmpTitle;
                }
            } else {
                label = "WSDL Implementativo di " + tmpTitle;
            }
            Parameter parameterFruitoreChange = new Parameter(tmpTitle, "accordiServizioParteSpecificaFruitoriChange.do", new Parameter[]{new Parameter("id", "" + idServizioLong), new Parameter("myId", strutsBean.id), new Parameter("idSoggErogatore", strutsBean.idSoggettoErogatoreDelServizio), new Parameter("providerFruitore", strutsBean.idSoggettoFruitore)});
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode)) {
                ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
                lstParm.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                lstParm.add(new Parameter("Fruizioni di " + titleServizio, "accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{new Parameter("id", "" + idServizioLong), new Parameter("idSoggErogatore", strutsBean.idSoggettoErogatoreDelServizio)}));
                lstParm.add(parameterFruitoreChange);
                lstParm.add(new Parameter(label, null));
                ServletUtils.setPageDataTitle((PageData)pd, lstParm);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = apsHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, strutsBean.id, null, null, dati);
                dati = apsHelper.addFruitoreWSDLToDati(TipoOperazione.OTHER, strutsBean.tipo, strutsBean.idSoggettoErogatoreDelServizio, strutsBean.idSoggettoFruitore, oldwsdl, strutsBean.validazioneDocumenti, myFru, dati, "" + idServizioLong, tipologiaDocumentoScaricare, false, label);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteSpecificaFruitori", (ForwardParams)AccordiServizioParteSpecificaCostanti.TIPO_OPERAZIONE_WSDL_CHANGE);
            }
            boolean isOk = apsHelper.accordiParteSpecificaFruitoreWSDLCheckData(pd, strutsBean.tipo, strutsBean.wsdl, myFru, asps, as, strutsBean.validazioneDocumenti);
            if (!isOk) {
                ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
                lstParm.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                lstParm.add(new Parameter("Fruizioni di " + titleServizio, "accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{new Parameter("id", "" + idServizioLong), new Parameter("idSoggErogatore", strutsBean.idSoggettoErogatoreDelServizio)}));
                lstParm.add(parameterFruitoreChange);
                lstParm.add(new Parameter(label, null));
                ServletUtils.setPageDataTitle((PageData)pd, lstParm);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = apsHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, strutsBean.id, null, null, dati);
                dati = apsHelper.addFruitoreWSDLToDati(TipoOperazione.OTHER, strutsBean.tipo, strutsBean.idSoggettoErogatoreDelServizio, strutsBean.idSoggettoFruitore, oldwsdl, strutsBean.validazioneDocumenti, myFru, dati, "" + idServizioLong, tipologiaDocumentoScaricare, false, label);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteSpecificaFruitori", (ForwardParams)AccordiServizioParteSpecificaCostanti.TIPO_OPERAZIONE_WSDL_CHANGE);
            }
            if (strutsBean.tipo.equals("wsdlimpler")) {
                myFru.setByteWsdlImplementativoErogatore(strutsBean.wsdl != null && !strutsBean.wsdl.equals("") ? strutsBean.wsdl.getBytes() : null);
            }
            if (strutsBean.tipo.equals("wsdlimplfru")) {
                myFru.setByteWsdlImplementativoFruitore(strutsBean.wsdl != null && !strutsBean.wsdl.equals("") ? strutsBean.wsdl.getBytes() : null);
            }
            for (int i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore tmpFru = asps.getFruitore(i);
                if (tmpFru.getId().longValue() != myFru.getId().longValue()) continue;
                asps.removeFruitore(i);
                break;
            }
            asps.addFruitore(myFru);
            apsCore.setDataAggiornamentoFruitore(myFru);
            String superUser = ServletUtils.getUserLoginFromSession((HttpSession)session);
            apsCore.performUpdateOperation(superUser, apsHelper.smista(), asps);
            strutsBean.id = "" + apsCore.getServizioFruitore(ids, idSoggettoFruitoreLong);
            parameterFruitoreChange = new Parameter(tmpTitle, "accordiServizioParteSpecificaFruitoriChange.do", new Parameter[]{new Parameter("id", "" + idServizioLong), new Parameter("myId", strutsBean.id), new Parameter("idSoggErogatore", strutsBean.idSoggettoErogatoreDelServizio), new Parameter("providerFruitore", strutsBean.idSoggettoFruitore)});
            ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
            lstParm.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
            lstParm.add(new Parameter("Fruizioni di " + titleServizio, "accordiServizioParteSpecificaFruitoriList.do", new Parameter[]{new Parameter("id", "" + idServizioLong), new Parameter("idSoggErogatore", strutsBean.idSoggettoErogatoreDelServizio)}));
            lstParm.add(parameterFruitoreChange);
            lstParm.add(new Parameter(label, null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParm);
            protocollo = apsCore.getProtocolloAssociatoTipoServizio(asps.getTipo());
            strutsBean.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            strutsBean.consoleDynamicConfiguration = strutsBean.protocolFactory.createDynamicConfigurationConsole();
            strutsBean.registryReader = soggettiCore.getRegistryReader(strutsBean.protocolFactory);
            strutsBean.configRegistryReader = soggettiCore.getConfigIntegrationReader(strutsBean.protocolFactory);
            IDServizio idAps = apsHelper.getIDServizioFromValues(asps.getTipo(), asps.getNome(), asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore(), "" + asps.getVersione());
            idAps.setPortType(asps.getPortType());
            strutsBean.consoleConfiguration = strutsBean.consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteSpecifica(strutsBean.consoleOperationType, (IConsoleHelper)apsHelper, strutsBean.registryReader, strutsBean.configRegistryReader, idAps);
            List oldProtocolPropertyList = as.getProtocolPropertyList();
            strutsBean.protocolProperties = apsHelper.estraiProtocolPropertiesDaRequest(strutsBean.consoleConfiguration, strutsBean.consoleOperationType);
            ProtocolPropertiesUtils.mergeProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (List)oldProtocolPropertyList, (ConsoleOperationType)strutsBean.consoleOperationType);
            Properties propertiesProprietario = new Properties();
            propertiesProprietario.setProperty("idProprietario", strutsBean.id);
            propertiesProprietario.setProperty("tipoProprietario", "FRUITORE");
            propertiesProprietario.setProperty("nomeProprietario", tmpTitle);
            propertiesProprietario.setProperty("urlOrigChange", URLEncoder.encode(parameterFruitoreChange.getValue(), "UTF-8"));
            propertiesProprietario.setProperty("protocollo", protocollo);
            propertiesProprietario.setProperty("tipoAccordo", "");
            List<DataElement> dati = new ArrayList<DataElement>();
            dati = apsHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, strutsBean.id, null, null, dati);
            dati = apsHelper.addFruitoreWSDLToDati(TipoOperazione.OTHER, strutsBean.tipo, strutsBean.idSoggettoErogatoreDelServizio, strutsBean.idSoggettoFruitore, strutsBean.wsdl, strutsBean.validazioneDocumenti, myFru, dati, "" + idServizioLong, tipologiaDocumentoScaricare, true, label);
            pd.setMessage("Modifica effettuata con successo", Costanti.MESSAGE_TYPE_INFO);
            pd.setDati(dati);
            pd.disableEditMode();
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteSpecificaFruitori", (ForwardParams)AccordiServizioParteSpecificaCostanti.TIPO_OPERAZIONE_WSDL_CHANGE);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteSpecificaFruitori", (ForwardParams)AccordiServizioParteSpecificaCostanti.TIPO_OPERAZIONE_WSDL_CHANGE);
        }
    }
}

