/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.ConfigurazionePortaHandler;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneSoggetto;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataLocalForward;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.PortaTracciamento;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.ScopeTipoMatch;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mvc.properties.utils.ConfigManager;
import org.openspcoop2.core.mvc.properties.utils.PropertiesSourceConfiguration;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.GruppoSintetico;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.protocol.utils.EsitiConfigUtils;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedListServlet;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public class ErogazioniDetailsUtilities {
    public static String getDetailsErogazione(IDServizio idServizio, SoggettiCore soggettiCore, ConsoleHelper consoleHelper) throws Exception {
        return ErogazioniDetailsUtilities._getDetails(idServizio, null, soggettiCore, consoleHelper, null, null);
    }

    public static String getDetailsErogazione(IDServizio idServizio, SoggettiCore soggettiCore, ConsoleHelper consoleHelper, String separator, String newLine) throws Exception {
        return ErogazioniDetailsUtilities._getDetails(idServizio, null, soggettiCore, consoleHelper, separator, newLine);
    }

    public static String getDetailsFruizione(IDServizio idServizio, IDSoggetto idSoggettoFruitore, SoggettiCore soggettiCore, ConsoleHelper consoleHelper) throws Exception {
        return ErogazioniDetailsUtilities._getDetails(idServizio, idSoggettoFruitore, soggettiCore, consoleHelper, null, null);
    }

    public static String getDetailsFruizione(IDServizio idServizio, IDSoggetto idSoggettoFruitore, SoggettiCore soggettiCore, ConsoleHelper consoleHelper, String separator, String newLine) throws Exception {
        return ErogazioniDetailsUtilities._getDetails(idServizio, idSoggettoFruitore, soggettiCore, consoleHelper, separator, newLine);
    }

    /*
     * WARNING - void declaration
     */
    private static String _getDetails(IDServizio idServizio, IDSoggetto idSoggettoFruitore, SoggettiCore soggettiCore, ConsoleHelper consoleHelper, String separator, String newLine) throws Exception {
        boolean modificaDatiProfilo;
        void var33_39;
        String labelServizio;
        if (separator == null) {
            separator = ": ";
        }
        if (newLine == null) {
            newLine = "\n";
        }
        StringBuilder sb = new StringBuilder();
        boolean gestioneFruitori = idSoggettoFruitore != null;
        boolean gestioneErogatori = !gestioneFruitori;
        PddCore pddCore = new PddCore(soggettiCore);
        AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(soggettiCore);
        AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(soggettiCore);
        ConfigurazioneCore confCore = new ConfigurazioneCore(soggettiCore);
        PorteApplicativeCore porteApplicativeCore = null;
        PorteDelegateCore porteDelegateCore = null;
        ServiziApplicativiCore saCore = null;
        if (gestioneErogatori) {
            porteApplicativeCore = new PorteApplicativeCore(soggettiCore);
            saCore = new ServiziApplicativiCore(soggettiCore);
        } else {
            porteDelegateCore = new PorteDelegateCore(soggettiCore);
        }
        boolean showSoggettoErogatoreInErogazioni = false;
        boolean showSoggettoFruitoreInFruizioni = false;
        if (gestioneErogatori) {
            showSoggettoErogatoreInErogazioni = soggettiCore.isMultitenant() && !consoleHelper.isSoggettoMultitenantSelezionato();
        } else {
            showSoggettoFruitoreInFruizioni = gestioneFruitori && soggettiCore.isMultitenant() && !consoleHelper.isSoggettoMultitenantSelezionato();
        }
        String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idServizio.getSoggettoErogatore().getTipo());
        String labelProtocollo = consoleHelper.getLabelProtocollo(protocollo);
        boolean showProtocolli = consoleHelper.getSession() != null ? soggettiCore.countProtocolli(consoleHelper.getRequest(), consoleHelper.getSession()) > 1 : true;
        AccordoServizioParteSpecifica asps = apsCore.getServizio(idServizio);
        AccordoServizioParteComuneSintetico as = apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
        AccordoServizioParteComune asFull = apcCore.getAccordoServizioFull(asps.getIdAccordo());
        org.openspcoop2.message.constants.ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(as.getServiceBinding());
        idServizio.setPortType(asps.getPortType());
        idServizio.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
        Soggetto sog = soggettiCore.getSoggettoRegistro(asps.getIdSoggetto());
        boolean isPddEsterna = pddCore.isPddEsterna(sog.getPortaDominio());
        List<Object> listaMappingErogazionePortaApplicativa = new ArrayList();
        ArrayList<PortaApplicativa> listaPorteApplicativeAssociate = new ArrayList<PortaApplicativa>();
        if (gestioneErogatori) {
            listaMappingErogazionePortaApplicativa = apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : listaMappingErogazionePortaApplicativa) {
                listaPorteApplicativeAssociate.add(porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa()));
            }
        }
        List<Object> listaMappingFruzionePortaDelegata = new ArrayList();
        ArrayList<PortaDelegata> arrayList = new ArrayList<PortaDelegata>();
        Fruitore fruitore = null;
        if (gestioneFruitori) {
            for (Fruitore fruitore2 : asps.getFruitoreList()) {
                if (!fruitore2.getTipo().equals(idSoggettoFruitore.getTipo()) || !fruitore2.getNome().equals(idSoggettoFruitore.getNome())) continue;
                fruitore = fruitore2;
                break;
            }
            if (fruitore != null) {
                listaMappingFruzionePortaDelegata = apsCore.serviziFruitoriMappingList(fruitore.getId(), idSoggettoFruitore, idServizio, null);
                for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : listaMappingFruzionePortaDelegata) {
                    arrayList.add(porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata()));
                }
            }
        }
        sb.append("=== Informazioni Generali ===");
        String string = labelServizio = consoleHelper.getLabelIdServizioSenzaErogatore(idServizio);
        if (asps.getPortType() != null && !"".equals(asps.getPortType()) && !asps.getNome().equals(asps.getPortType())) {
            String string2 = string + " (" + asps.getPortType() + ")";
        }
        sb.append(newLine);
        sb.append("Nome");
        sb.append(separator);
        sb.append((String)var33_39);
        if (gestioneErogatori && listaMappingErogazionePortaApplicativa.size() == 1) {
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(((MappingErogazionePortaApplicativa)listaMappingErogazionePortaApplicativa.get(0)).getIdPortaApplicativa());
            boolean statoPA = pa.getStato().equals((Object)StatoFunzionalita.ABILITATO);
            statoMapping = statoPA ? "Abilitato" : "Disabilitato";
            sb.append(newLine);
            sb.append("Stato");
            sb.append(separator);
            sb.append(statoMapping);
        } else if (gestioneFruitori && arrayList.size() == 1) {
            PortaDelegata pd = porteDelegateCore.getPortaDelegata(((MappingFruizionePortaDelegata)listaMappingFruzionePortaDelegata.get(0)).getIdPortaDelegata());
            boolean statoPD = pd.getStato().equals((Object)StatoFunzionalita.ABILITATO);
            statoMapping = statoPD ? "Abilitato" : "Disabilitato";
            sb.append(newLine);
            sb.append("Stato");
            sb.append(separator);
            sb.append(statoMapping);
        }
        if (gestioneFruitori || showSoggettoErogatoreInErogazioni) {
            String labelSoggetto = consoleHelper.getLabelNomeSoggetto(protocollo, asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            sb.append(newLine);
            sb.append("Soggetto Erogatore");
            sb.append(separator);
            sb.append(labelSoggetto);
        }
        String labelAPI = consoleHelper.getLabelIdAccordo(as);
        String labelServiceBinding = null;
        switch (serviceBinding) {
            case REST: {
                labelServiceBinding = "Rest";
                break;
            }
            default: {
                labelServiceBinding = "Soap";
            }
        }
        sb.append(newLine);
        sb.append("API");
        sb.append(separator);
        sb.append(MessageFormat.format("{1} ({0})", labelServiceBinding, labelAPI));
        List gruppi = as.getGruppo();
        if (gruppi != null && !gruppi.isEmpty()) {
            StringBuilder sbTags = new StringBuilder();
            for (int i = 0; i < gruppi.size(); ++i) {
                GruppoSintetico gruppo = (GruppoSintetico)gruppi.get(i);
                if (sbTags.length() > 0) {
                    sbTags.append(",");
                }
                sbTags.append(gruppo.getNome());
            }
            sb.append(newLine);
            sb.append("Tags");
            sb.append(separator);
            sb.append(sbTags.toString());
        }
        if (showProtocolli) {
            sb.append(newLine);
            sb.append("Profilo Interoperabilit\u00e0");
            sb.append(separator);
            sb.append(labelProtocollo);
        }
        if (showSoggettoFruitoreInFruizioni) {
            sb.append(newLine);
            sb.append("Soggetto Fruitore");
            sb.append(separator);
            sb.append(consoleHelper.getLabelNomeSoggetto(protocollo, fruitore.getTipo(), fruitore.getNome()));
        }
        boolean connettoreStatic = false;
        if (gestioneFruitori) {
            connettoreStatic = apsCore.isConnettoreStatic(protocollo);
        }
        String urlInvocazione = null;
        String urlConnettoreFruitoreModI = null;
        if (gestioneErogatori) {
            CanaliConfigurazione gestioneCanali;
            boolean gestioneCanaliEnabled;
            IDPortaApplicativa idPA = null;
            PortaApplicativa paDefault = null;
            canalePorta = null;
            if (!isPddEsterna) {
                idPA = porteApplicativeCore.getIDPortaApplicativaAssociataDefault(idServizio);
                paDefault = porteApplicativeCore.getPortaApplicativa(idPA);
                canalePorta = paDefault.getCanale();
                boolean analizeProxyPassRules = true;
                UrlInvocazioneAPI urlInvocazioneConfig = confCore.getConfigurazioneUrlInvocazione(protocollo, RuoloContesto.PORTA_APPLICATIVA, serviceBinding, paDefault.getNome(), new IDSoggetto(paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario()), as, paDefault.getCanale(), analizeProxyPassRules);
                urlInvocazione = urlInvocazioneConfig.getUrl();
            } else {
                urlInvocazione = "-";
            }
            sb.append(newLine);
            sb.append("URL Invocazione");
            sb.append(separator);
            sb.append(urlInvocazione);
            sb.append(newLine);
            sb.append("Gestione CORS");
            sb.append(separator);
            sb.append(consoleHelper.getStatoGestioneCorsPortaApplicativa(paDefault, false));
            for (int i = 0; i < listaPorteApplicativeAssociate.size(); ++i) {
                PortaApplicativa paAssociata = (PortaApplicativa)listaPorteApplicativeAssociate.get(i);
                MappingErogazionePortaApplicativa mapping = (MappingErogazionePortaApplicativa)listaMappingErogazionePortaApplicativa.get(i);
                if (!mapping.isDefault()) continue;
                canalePorta = paAssociata.getCanale();
                break;
            }
            boolean bl = gestioneCanaliEnabled = (gestioneCanali = confCore.getCanaliConfigurazione(false)) != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            if (gestioneCanaliEnabled) {
                sb.append(newLine);
                sb.append("Canale");
                sb.append(separator);
                String canaleNome = canalePorta;
                if (canaleNome == null) {
                    String canaleAPINome = as.getCanale();
                    if (canaleAPINome == null) {
                        List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
                        CanaleConfigurazione canaleConfigurazioneDefault = consoleHelper.getCanaleDefault(canaleList);
                        canaleNome = canaleConfigurazioneDefault.getNome();
                    } else {
                        canaleNome = canaleAPINome;
                    }
                }
                sb.append(canaleNome);
            }
            if (!consoleHelper.isModalitaStandard() && apsCore.getMessageEngines() != null && !apsCore.getMessageEngines().isEmpty()) {
                sb.append(newLine);
                sb.append("Opzioni Avanzate");
                sb.append(separator);
                sb.append(consoleHelper.getStatoOpzioniAvanzatePortaApplicativaDefault(paDefault));
            }
            sb.append(newLine);
            sb.append(newLine);
            sb.append("=== Connettore ===");
            ErogazioniDetailsUtilities.printConnettoreErogazione(paDefault, paDefault, saCore, consoleHelper, sb, separator, newLine);
        } else {
            boolean gestioneCanaliEnabled;
            IDPortaDelegata idPD = porteDelegateCore.getIDPortaDelegataAssociataDefault(idServizio, idSoggettoFruitore);
            PortaDelegata pdDefault = porteDelegateCore.getPortaDelegata(idPD);
            canalePorta = pdDefault.getCanale();
            boolean analizeProxyPassRules = true;
            UrlInvocazioneAPI urlInvocazioneConf = confCore.getConfigurazioneUrlInvocazione(protocollo, RuoloContesto.PORTA_DELEGATA, serviceBinding, pdDefault.getNome(), idSoggettoFruitore, as, pdDefault.getCanale(), analizeProxyPassRules);
            urlInvocazione = urlInvocazioneConf.getUrl();
            sb.append(newLine);
            sb.append("URL Invocazione");
            sb.append(separator);
            sb.append(urlInvocazione);
            sb.append(newLine);
            sb.append("Gestione CORS");
            sb.append(separator);
            sb.append(consoleHelper.getStatoGestioneCorsPortaDelegata(pdDefault, false));
            CanaliConfigurazione gestioneCanali = confCore.getCanaliConfigurazione(false);
            boolean bl = gestioneCanaliEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            if (gestioneCanaliEnabled) {
                sb.append(newLine);
                sb.append("Canale");
                sb.append(separator);
                Object canaleNome = canalePorta;
                if (canaleNome == null) {
                    String canaleAPINome = as.getCanale();
                    if (canaleAPINome == null) {
                        List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
                        CanaleConfigurazione canaleConfigurazioneDefault = canaleList.stream().filter(c -> c.isCanaleDefault()).findFirst().get();
                        canaleNome = canaleConfigurazioneDefault.getNome();
                    } else {
                        canaleNome = canaleAPINome;
                    }
                }
                sb.append((String)canaleNome);
            }
            if (!consoleHelper.isModalitaStandard() && apsCore.getMessageEngines() != null && !apsCore.getMessageEngines().isEmpty()) {
                sb.append(newLine);
                sb.append("Opzioni Avanzate");
                sb.append(separator);
                sb.append(consoleHelper.getStatoOpzioniAvanzatePortaDelegataDefault(pdDefault));
            }
            Connettore connettore = null;
            if (fruitore != null) {
                connettore = fruitore.getConnettore();
            }
            if (connettore != null && connettore.sizePropertyList() > 0) {
                for (Property p : connettore.getPropertyList()) {
                    if (!"location".equals(p.getNome())) continue;
                    urlConnettoreFruitoreModI = p.getValore();
                }
            }
            sb.append(newLine);
            sb.append(newLine);
            sb.append("=== Connettore ===");
            ErogazioniDetailsUtilities.printConnettoreFruizione(consoleHelper, connettore, null, connettoreStatic, sb, separator, newLine);
        }
        if (gestioneErogatori) {
            int i;
            PortaApplicativa paDefault = null;
            PortaApplicativaServizioApplicativo paSADefault = null;
            for (i = 0; i < listaPorteApplicativeAssociate.size(); ++i) {
                MappingErogazionePortaApplicativa mapping = (MappingErogazionePortaApplicativa)listaMappingErogazionePortaApplicativa.get(i);
                if (!mapping.isDefault()) continue;
                paDefault = (PortaApplicativa)listaPorteApplicativeAssociate.get(i);
                paSADefault = (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0);
                break;
            }
            for (i = 0; i < listaPorteApplicativeAssociate.size(); ++i) {
                PortaApplicativa paAssociata = (PortaApplicativa)listaPorteApplicativeAssociate.get(i);
                MappingErogazionePortaApplicativa mapping = (MappingErogazionePortaApplicativa)listaMappingErogazionePortaApplicativa.get(i);
                sb.append(newLine);
                sb.append(newLine);
                String labelGruppo = null;
                if (listaPorteApplicativeAssociate.size() == 1) {
                    sb.append("=== Configurazione ===");
                } else {
                    labelGruppo = mapping.getDescrizione();
                    if (mapping.isDefault() && (labelGruppo == null || StringUtils.isEmpty((CharSequence)labelGruppo))) {
                        labelGruppo = "Predefinito";
                    }
                    sb.append("=== Configurazione Gruppo '" + labelGruppo + "' ===");
                }
                ErogazioniDetailsUtilities.printConfigurazioneControlloAccessiErogazione(consoleHelper, soggettiCore, protocollo, paAssociata, sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneRateLimiting(consoleHelper, soggettiCore, false, paAssociata.getNome(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneValidazioneContenutiApplicativi(consoleHelper, soggettiCore, asFull, paAssociata.getValidazioneContenutiApplicativi(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneResponseCaching(consoleHelper, soggettiCore, paAssociata.getResponseCaching(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneMessageSecurity(consoleHelper, soggettiCore, paAssociata.getMessageSecurity(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneMTOM(consoleHelper, soggettiCore, paAssociata.getMtomProcessor(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneTrasformazioni(consoleHelper, soggettiCore, asFull, paAssociata.getTrasformazioni(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneTracciamento(consoleHelper, soggettiCore, paAssociata.getCorrelazioneApplicativa(), paAssociata.getCorrelazioneApplicativaRisposta(), paAssociata.getTracciamento(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneRegistrazioneMessaggi(consoleHelper, soggettiCore, paAssociata.getDump(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneAllarmi(consoleHelper, soggettiCore, false, paAssociata.getNome(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneProperties(consoleHelper, soggettiCore, paAssociata.getProprietaList(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazionePortaApplicativaExtended(consoleHelper, soggettiCore, protocollo, paAssociata, mapping, sb, separator, newLine);
                String behaviour = !soggettiCore.isConnettoriMultipliEnabled() && paAssociata.getBehaviour() != null ? paAssociata.getBehaviour().getNome() : null;
                ErogazioniDetailsUtilities.printConfigurazioneAltro(consoleHelper, soggettiCore, protocollo, asFull, paAssociata.getAllegaBody(), paAssociata.getScartaBody(), paAssociata.getIntegrazione(), behaviour, paAssociata.getProprietaRateLimitingList(), paAssociata.getStateless(), null, paAssociata.getRicevutaAsincronaSimmetrica(), paAssociata.getRicevutaAsincronaAsimmetrica(), paAssociata.getGestioneManifest(), paAssociata.getConfigurazioneHandler(), sb, separator, newLine);
                PortaApplicativaServizioApplicativo portaApplicativaAssociataServizioApplicativo = (PortaApplicativaServizioApplicativo)paAssociata.getServizioApplicativoList().get(0);
                boolean connettoreConfigurazioneRidefinito = consoleHelper.isConnettoreRidefinito(paDefault, paSADefault, paAssociata, portaApplicativaAssociataServizioApplicativo, paAssociata.getServizioApplicativoList());
                if (mapping.isDefault() || !connettoreConfigurazioneRidefinito) continue;
                sb.append(newLine);
                sb.append(newLine);
                sb.append("=== Connettore Gruppo '" + labelGruppo + "' ===");
                ErogazioniDetailsUtilities.printConnettoreErogazione(paDefault, paAssociata, saCore, consoleHelper, sb, separator, newLine);
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                PortaDelegata pdAssociata = (PortaDelegata)arrayList.get(i);
                MappingFruizionePortaDelegata mapping = (MappingFruizionePortaDelegata)listaMappingFruzionePortaDelegata.get(i);
                sb.append(newLine);
                sb.append(newLine);
                String labelGruppo = null;
                if (arrayList.size() == 1) {
                    sb.append("=== Configurazione ===");
                } else {
                    labelGruppo = mapping.getDescrizione();
                    if (mapping.isDefault() && (labelGruppo == null || StringUtils.isEmpty((CharSequence)labelGruppo))) {
                        labelGruppo = "Predefinito";
                    }
                    sb.append("=== Configurazione Gruppo '" + labelGruppo + "' ===");
                }
                ErogazioniDetailsUtilities.printConfigurazioneControlloAccessiFruizione(consoleHelper, soggettiCore, protocollo, pdAssociata, sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneRateLimiting(consoleHelper, soggettiCore, true, pdAssociata.getNome(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneValidazioneContenutiApplicativi(consoleHelper, soggettiCore, asFull, pdAssociata.getValidazioneContenutiApplicativi(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneResponseCaching(consoleHelper, soggettiCore, pdAssociata.getResponseCaching(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneMessageSecurity(consoleHelper, soggettiCore, pdAssociata.getMessageSecurity(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneMTOM(consoleHelper, soggettiCore, pdAssociata.getMtomProcessor(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneTrasformazioni(consoleHelper, soggettiCore, asFull, pdAssociata.getTrasformazioni(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneTracciamento(consoleHelper, soggettiCore, pdAssociata.getCorrelazioneApplicativa(), pdAssociata.getCorrelazioneApplicativaRisposta(), pdAssociata.getTracciamento(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneRegistrazioneMessaggi(consoleHelper, soggettiCore, pdAssociata.getDump(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneAllarmi(consoleHelper, soggettiCore, true, pdAssociata.getNome(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneProperties(consoleHelper, soggettiCore, pdAssociata.getProprietaList(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazioneAltro(consoleHelper, soggettiCore, protocollo, asFull, pdAssociata.getAllegaBody(), pdAssociata.getScartaBody(), pdAssociata.getIntegrazione(), null, pdAssociata.getProprietaRateLimitingList(), pdAssociata.getStateless(), pdAssociata.getLocalForward(), pdAssociata.getRicevutaAsincronaSimmetrica(), pdAssociata.getRicevutaAsincronaAsimmetrica(), pdAssociata.getGestioneManifest(), pdAssociata.getConfigurazioneHandler(), sb, separator, newLine);
                ErogazioniDetailsUtilities.printConfigurazionePortaDelegataExtended(consoleHelper, soggettiCore, protocollo, pdAssociata, mapping, sb, separator, newLine);
                boolean connettoreConfigurazioneRidefinito = false;
                Connettore connettore = fruitore.getConnettore();
                if (!mapping.isDefault()) {
                    List listaAzioni = pdAssociata.getAzione().getAzioneDelegataList();
                    String azioneConnettore = null;
                    if (listaAzioni != null && listaAzioni.size() > 0) {
                        azioneConnettore = (String)listaAzioni.get(0);
                    }
                    if (azioneConnettore != null && !"".equals(azioneConnettore)) {
                        for (ConfigurazioneServizioAzione check : fruitore.getConfigurazioneAzioneList()) {
                            if (!check.getAzioneList().contains(azioneConnettore)) continue;
                            connettore = check.getConnettore();
                            connettoreConfigurazioneRidefinito = true;
                            break;
                        }
                    }
                }
                if (mapping.isDefault() || !connettoreConfigurazioneRidefinito) continue;
                sb.append(newLine);
                sb.append(newLine);
                sb.append("=== Connettore Gruppo '" + labelGruppo + "' ===");
                ErogazioniDetailsUtilities.printConnettoreFruizione(consoleHelper, connettore, labelGruppo, connettoreStatic, sb, separator, newLine);
            }
        }
        if ((modificaDatiProfilo = true) && "modipa".equals(protocollo)) {
            Map map = ModIUtils.configToMap((AccordoServizioParteComune)asFull, (AccordoServizioParteSpecifica)asps, (String)urlInvocazione, (Fruitore)fruitore, (String)urlConnettoreFruitoreModI);
            boolean rest = ServiceBinding.REST.equals((Object)as.getServiceBinding());
            boolean digest = "true".equals(map.get("integrity"));
            boolean corniceSicurezza = "true".equals(map.get("user-info"));
            String patternDatiCorniceSicurezza = null;
            String schemaDatiCorniceSicurezza = null;
            if (corniceSicurezza) {
                patternDatiCorniceSicurezza = (String)map.get("user-info-pattern");
                schemaDatiCorniceSicurezza = (String)map.get("user-info-schema");
            }
            boolean headerDuplicati = "true".equals(map.get("contemporary-headers"));
            sb.append(newLine);
            sb.append(newLine);
            sb.append("=== " + labelProtocollo + " ===");
            sb.append(newLine);
            sb.append("Sicurezza Canale");
            sb.append(separator);
            String v = (String)map.get("api-channel-security-pattern");
            if (StringUtils.isNotEmpty((CharSequence)v)) {
                sb.append(v);
            } else {
                sb.append("-");
            }
            boolean sicurezzaMessaggio = false;
            sb.append(newLine);
            sb.append("Sicurezza Messaggio");
            sb.append(separator);
            v = (String)map.get("api-message-security-pattern");
            if (StringUtils.isNotEmpty((CharSequence)v)) {
                sb.append(v);
                sicurezzaMessaggio = true;
            } else {
                sb.append("-");
            }
            boolean sicurezzaMessaggioPdnd = false;
            if (sicurezzaMessaggio) {
                v = (String)map.get("api-message-security-sorgente-token-id-auth");
                if (StringUtils.isNotEmpty((CharSequence)v)) {
                    sb.append(newLine);
                    sb.append("Generazione Token");
                    sb.append(separator);
                    sb.append(v);
                    sicurezzaMessaggioPdnd = v.contains("Authorization PDND");
                }
                if (rest && StringUtils.isNotEmpty((CharSequence)(v = (String)map.get("api-message-security-http-header")))) {
                    sb.append(newLine);
                    sb.append("Header HTTP del Token");
                    sb.append(separator);
                    sb.append(v);
                }
                if (StringUtils.isNotEmpty((CharSequence)(v = (String)map.get("api-message-security-applicability")))) {
                    sb.append(newLine);
                    sb.append("Applicabilit\u00e0");
                    sb.append(separator);
                    sb.append(v);
                }
                sb.append(newLine);
                sb.append("Digest Richiesta");
                sb.append(separator);
                sb.append((String)map.get("api-message-security-request-digest"));
                sb.append(newLine);
                sb.append("DPoP");
                sb.append(separator);
                sb.append((String)map.get("api-message-security-dpop"));
                sb.append(newLine);
                sb.append("Informazioni Audit");
                sb.append(separator);
                sb.append((String)map.get("api-message-security-user-info"));
                boolean request = true;
                ErogazioniDetailsUtilities.addProfiloModISicurezza(sb, map, labelProtocollo, rest, gestioneFruitori, request, digest, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, separator, newLine);
                ErogazioniDetailsUtilities.addProfiloModISicurezza(sb, map, labelProtocollo, rest, gestioneFruitori, !request, digest, patternDatiCorniceSicurezza, schemaDatiCorniceSicurezza, headerDuplicati, separator, newLine);
            } else if (gestioneFruitori) {
                v = (String)map.get("oauth-id");
                if (StringUtils.isNotEmpty((CharSequence)v)) {
                    sb.append(newLine);
                    sb.append("Token ClientId");
                    sb.append(separator);
                    sb.append(v);
                }
                if (StringUtils.isNotEmpty((CharSequence)(v = (String)map.get("oauth-kid")))) {
                    sb.append(newLine);
                    sb.append("Key Id (kid) del Certificato");
                    sb.append(separator);
                    sb.append(v);
                }
                ErogazioniDetailsUtilities.addStore(sb, map, "", false, false, separator, newLine);
            }
            if (sicurezzaMessaggioPdnd && gestioneErogatori) {
                StringBuilder sbPDND = new StringBuilder();
                v = (String)map.get("info-eservice-id");
                if (StringUtils.isNotEmpty((CharSequence)v)) {
                    sbPDND.append(newLine);
                    sbPDND.append("Identificativo eService");
                    sbPDND.append(separator);
                    sbPDND.append(v);
                }
                if (StringUtils.isNotEmpty((CharSequence)(v = (String)map.get("info-descriptor-id")))) {
                    sbPDND.append(newLine);
                    sbPDND.append("Identificativo Descrittore");
                    sbPDND.append(separator);
                    sbPDND.append(v);
                }
                if (StringUtils.isNotEmpty((CharSequence)(v = (String)map.get("info-signal-hub")))) {
                    sbPDND.append(newLine);
                    sbPDND.append("Signal Hub");
                    sbPDND.append(separator);
                    sbPDND.append(v);
                }
                if (sbPDND.length() > 0) {
                    sb.append(newLine);
                    sb.append("- Informazioni Generali -");
                    sb.append(sbPDND.toString());
                }
            }
        }
        return sb.toString();
    }

    private static void printConfigurazioneControlloAccessiErogazione(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, String protocollo, PortaApplicativa paAssociata, StringBuilder sb, String separator, String newLine) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Properties properties;
        IDServizioApplicativo idSA;
        ArrayList<IDSoggetto> authzSoggetti = null;
        ArrayList<IDServizioApplicativo> authzApplicativi = null;
        ArrayList<String> authzRuoli = null;
        boolean allRuoli = false;
        boolean authzApplicativiTokenEnabled = false;
        ArrayList<IDServizioApplicativo> authzApplicativiToken = null;
        boolean authzRuoliTokenEnabled = false;
        ArrayList<String> authzRuoliToken = null;
        boolean allRuoliToken = false;
        boolean authzScopeTokenEnabled = false;
        ArrayList<String> authzScope = null;
        boolean allScope = false;
        ArrayList<String> authzTokenClaims = null;
        if (paAssociata.getSoggetti() != null && paAssociata.getSoggetti().sizeSoggettoList() > 0) {
            authzSoggetti = new ArrayList<IDSoggetto>();
            for (PortaApplicativaAutorizzazioneSoggetto soggetto : paAssociata.getSoggetti().getSoggettoList()) {
                authzSoggetti.add(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
            }
        }
        if (paAssociata.getServiziApplicativiAutorizzati() != null && paAssociata.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
            authzApplicativi = new ArrayList<IDServizioApplicativo>();
            for (PortaApplicativaAutorizzazioneServizioApplicativo sa : paAssociata.getServiziApplicativiAutorizzati().getServizioApplicativoList()) {
                idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                idSA.setNome(sa.getNome());
                authzApplicativi.add(idSA);
            }
        }
        if (paAssociata.getRuoli() != null) {
            boolean bl = allRuoli = paAssociata.getRuoli().getMatch() == null || RuoloTipoMatch.ALL.equals((Object)paAssociata.getRuoli().getMatch());
        }
        if (paAssociata.getRuoli() != null && paAssociata.getRuoli().sizeRuoloList() > 0) {
            authzRuoli = new ArrayList<String>();
            for (Ruolo ruolo : paAssociata.getRuoli().getRuoloList()) {
                authzRuoli.add(ruolo.getNome());
            }
        }
        if (paAssociata.getAutorizzazioneToken() != null) {
            authzApplicativiTokenEnabled = StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getAutorizzazioneToken().getAutorizzazioneApplicativi());
            if (authzApplicativiTokenEnabled && paAssociata.getAutorizzazioneToken().getServiziApplicativi() != null && paAssociata.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                authzApplicativiToken = new ArrayList<IDServizioApplicativo>();
                for (PortaApplicativaAutorizzazioneServizioApplicativo sa : paAssociata.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList()) {
                    idSA = new IDServizioApplicativo();
                    idSA.setIdSoggettoProprietario(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    idSA.setNome(sa.getNome());
                    authzApplicativiToken.add(idSA);
                }
            }
            if (authzRuoliTokenEnabled = StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                if (paAssociata.getAutorizzazioneToken().getRuoli() != null) {
                    boolean bl = allRuoliToken = paAssociata.getAutorizzazioneToken().getRuoli().getMatch() == null || RuoloTipoMatch.ALL.equals((Object)paAssociata.getAutorizzazioneToken().getRuoli().getMatch());
                }
                if (paAssociata.getAutorizzazioneToken().getRuoli() != null && paAssociata.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                    authzRuoliToken = new ArrayList<String>();
                    for (Ruolo ruolo : paAssociata.getAutorizzazioneToken().getRuoli().getRuoloList()) {
                        authzRuoliToken.add(ruolo.getNome());
                    }
                }
            }
        }
        if (paAssociata.getScope() != null && (authzScopeTokenEnabled = StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getScope().getStato()))) {
            boolean bl = allScope = paAssociata.getScope().getMatch() == null || ScopeTipoMatch.ALL.equals((Object)paAssociata.getScope().getMatch());
            if (paAssociata.getScope().sizeScopeList() > 0) {
                authzScope = new ArrayList<String>();
                for (Scope scope : paAssociata.getScope().getScopeList()) {
                    authzScope.add(scope.getNome());
                }
            }
        }
        if (paAssociata.getGestioneToken() != null && paAssociata.getGestioneToken().getOptions() != null && (properties = PropertiesUtilities.convertTextToProperties((String)paAssociata.getGestioneToken().getOptions())) != null && properties.size() > 0) {
            authzTokenClaims = new ArrayList<String>();
            for (Object key : properties.keySet()) {
                if (!(key instanceof String)) continue;
                authzTokenClaims.add((String)key);
            }
            Collections.sort(authzTokenClaims);
        }
        ErogazioniDetailsUtilities.printConfigurazioneControlloAccessi(consoleHelper, soggettiCore, false, protocollo, paAssociata.getGestioneToken(), paAssociata.getAutenticazione(), paAssociata.getAutenticazioneOpzionale(), paAssociata.getProprietaAutenticazioneList(), paAssociata.getAttributeAuthorityList(), paAssociata.getAutorizzazione(), authzSoggetti, authzApplicativi, authzRuoli, allRuoli, authzApplicativiTokenEnabled, authzApplicativiToken, authzRuoliTokenEnabled, authzRuoliToken, allRuoliToken, authzScopeTokenEnabled, authzScope, allScope, authzTokenClaims, paAssociata.getAutorizzazioneContenuto(), sb, separator, newLine);
    }

    private static void printConfigurazioneControlloAccessiFruizione(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, String protocollo, PortaDelegata pdAssociata, StringBuilder sb, String separator, String newLine) {
        Properties properties;
        IDServizioApplicativo idSA;
        List<IDSoggetto> authzSoggetti = null;
        ArrayList<IDServizioApplicativo> authzApplicativi = null;
        ArrayList<String> authzRuoli = null;
        boolean allRuoli = false;
        boolean authzApplicativiTokenEnabled = false;
        ArrayList<IDServizioApplicativo> authzApplicativiToken = null;
        boolean authzRuoliTokenEnabled = false;
        ArrayList<String> authzRuoliToken = null;
        boolean allRuoliToken = false;
        boolean authzScopeTokenEnabled = false;
        ArrayList<String> authzScope = null;
        boolean allScope = false;
        ArrayList<String> authzTokenClaims = null;
        if (pdAssociata.getServizioApplicativoList() != null && pdAssociata.sizeServizioApplicativoList() > 0) {
            authzApplicativi = new ArrayList<IDServizioApplicativo>();
            for (PortaDelegataServizioApplicativo sa : pdAssociata.getServizioApplicativoList()) {
                idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(new IDSoggetto(pdAssociata.getTipoSoggettoProprietario(), pdAssociata.getNomeSoggettoProprietario()));
                idSA.setNome(sa.getNome());
                authzApplicativi.add(idSA);
            }
        }
        if (pdAssociata.getRuoli() != null) {
            boolean bl = allRuoli = pdAssociata.getRuoli().getMatch() == null || RuoloTipoMatch.ALL.equals((Object)pdAssociata.getRuoli().getMatch());
        }
        if (pdAssociata.getRuoli() != null && pdAssociata.getRuoli().sizeRuoloList() > 0) {
            authzRuoli = new ArrayList<String>();
            for (Ruolo ruolo : pdAssociata.getRuoli().getRuoloList()) {
                authzRuoli.add(ruolo.getNome());
            }
        }
        if (pdAssociata.getAutorizzazioneToken() != null) {
            authzApplicativiTokenEnabled = StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getAutorizzazioneToken().getAutorizzazioneApplicativi());
            if (authzApplicativiTokenEnabled && pdAssociata.getAutorizzazioneToken().getServiziApplicativi() != null && pdAssociata.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                authzApplicativiToken = new ArrayList<IDServizioApplicativo>();
                for (PortaDelegataServizioApplicativo sa : pdAssociata.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList()) {
                    idSA = new IDServizioApplicativo();
                    idSA.setIdSoggettoProprietario(new IDSoggetto(pdAssociata.getTipoSoggettoProprietario(), pdAssociata.getNomeSoggettoProprietario()));
                    idSA.setNome(sa.getNome());
                    authzApplicativiToken.add(idSA);
                }
            }
            if (authzRuoliTokenEnabled = StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                if (pdAssociata.getAutorizzazioneToken().getRuoli() != null) {
                    boolean bl = allRuoliToken = pdAssociata.getAutorizzazioneToken().getRuoli().getMatch() == null || RuoloTipoMatch.ALL.equals((Object)pdAssociata.getAutorizzazioneToken().getRuoli().getMatch());
                }
                if (pdAssociata.getAutorizzazioneToken().getRuoli() != null && pdAssociata.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                    authzRuoliToken = new ArrayList<String>();
                    for (Ruolo ruolo : pdAssociata.getAutorizzazioneToken().getRuoli().getRuoloList()) {
                        authzRuoliToken.add(ruolo.getNome());
                    }
                }
            }
        }
        if (pdAssociata.getScope() != null && (authzScopeTokenEnabled = StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getScope().getStato()))) {
            boolean bl = allScope = pdAssociata.getScope().getMatch() == null || ScopeTipoMatch.ALL.equals((Object)pdAssociata.getScope().getMatch());
            if (pdAssociata.getScope().sizeScopeList() > 0) {
                authzScope = new ArrayList<String>();
                for (Scope scope : pdAssociata.getScope().getScopeList()) {
                    authzScope.add(scope.getNome());
                }
            }
        }
        if (pdAssociata.getGestioneToken() != null && pdAssociata.getGestioneToken().getOptions() != null && (properties = PropertiesUtilities.convertTextToProperties((String)pdAssociata.getGestioneToken().getOptions())) != null && properties.size() > 0) {
            authzTokenClaims = new ArrayList<String>();
            for (Object key : properties.keySet()) {
                if (key == null || !(key instanceof String)) continue;
                authzTokenClaims.add((String)key);
            }
            Collections.sort(authzTokenClaims);
        }
        ErogazioniDetailsUtilities.printConfigurazioneControlloAccessi(consoleHelper, soggettiCore, true, protocollo, pdAssociata.getGestioneToken(), pdAssociata.getAutenticazione(), pdAssociata.getAutenticazioneOpzionale(), pdAssociata.getProprietaAutenticazioneList(), pdAssociata.getAttributeAuthorityList(), pdAssociata.getAutorizzazione(), authzSoggetti, authzApplicativi, authzRuoli, allRuoli, authzApplicativiTokenEnabled, authzApplicativiToken, authzRuoliTokenEnabled, authzRuoliToken, allRuoliToken, authzScopeTokenEnabled, authzScope, allScope, authzTokenClaims, pdAssociata.getAutorizzazioneContenuto(), sb, separator, newLine);
    }

    private static void printConfigurazioneControlloAccessi(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, boolean gestioneFruitore, String protocollo, GestioneToken gestioneToken, String autenticazioneTrasporto, StatoFunzionalita autenticazioneTrasportoOpzionale, List<Proprieta> autenticazioneProprieta, List<AttributeAuthority> listAA, String autorizzazione, List<IDSoggetto> authzSoggetti, List<IDServizioApplicativo> authzApplicativi, List<String> authzRuoli, boolean allRuoli, boolean authzApplicativiTokenEnabled, List<IDServizioApplicativo> authzApplicativiToken, boolean authzRuoliTokenEnabled, List<String> authzRuoliToken, boolean allRuoliToken, boolean authzScopeTokenEnabled, List<String> authzScope, boolean allScope, List<String> authzTokenClaims, String autorizzazioneContenuti, StringBuilder sb, String separator, String newLine) {
        Plugin p;
        ConfigurazioneCore confCore;
        String label;
        boolean modipa = consoleHelper.isProfiloModIPA(protocollo);
        if (gestioneToken != null && gestioneToken.getPolicy() != null) {
            GestioneTokenAutenticazione gestioneTokenAutenticazione;
            String policy = gestioneToken.getPolicy();
            sb.append(newLine);
            sb.append("Token Policy");
            sb.append(separator);
            sb.append(policy);
            if (StatoFunzionalita.ABILITATO.equals((Object)gestioneToken.getTokenOpzionale())) {
                sb.append(newLine);
                sb.append("Token Opzionale");
                sb.append(separator);
                sb.append(gestioneToken.getTokenOpzionale());
            }
            StringBuilder bf = new StringBuilder();
            if (StatoFunzionalitaConWarning.ABILITATO.equals((Object)gestioneToken.getValidazione()) || StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)gestioneToken.getValidazione())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Validazione JWT");
                if (StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)gestioneToken.getValidazione())) {
                    bf.append(" [WarningOnly]");
                }
            }
            if (StatoFunzionalitaConWarning.ABILITATO.equals((Object)gestioneToken.getIntrospection()) || StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)gestioneToken.getIntrospection())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Introspection");
                if (StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)gestioneToken.getIntrospection())) {
                    bf.append(" [WarningOnly]");
                }
            }
            if (StatoFunzionalitaConWarning.ABILITATO.equals((Object)gestioneToken.getUserInfo()) || StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)gestioneToken.getUserInfo())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("User Info");
                if (StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)gestioneToken.getUserInfo())) {
                    bf.append(" [WarningOnly]");
                }
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)gestioneToken.getForward())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Token Forward");
            }
            if (bf.length() > 0) {
                sb.append(newLine);
                sb.append("Gestione Token");
                sb.append(separator);
                sb.append(bf.toString());
            }
            if ((gestioneTokenAutenticazione = gestioneToken.getAutenticazione()) != null) {
                StringBuilder bfAuth = new StringBuilder();
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getIssuer())) {
                    if (bfAuth.length() > 0) {
                        bfAuth.append(", ");
                    }
                    bfAuth.append("Issuer");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getSubject())) {
                    if (bfAuth.length() > 0) {
                        bfAuth.append(", ");
                    }
                    bfAuth.append("Subject");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getClientId())) {
                    if (bfAuth.length() > 0) {
                        bfAuth.append(", ");
                    }
                    bfAuth.append("ClientId");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getUsername())) {
                    if (bfAuth.length() > 0) {
                        bfAuth.append(", ");
                    }
                    bfAuth.append("Username");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getEmail())) {
                    if (bfAuth.length() > 0) {
                        bfAuth.append(", ");
                    }
                    bfAuth.append("eMail");
                }
                if (bfAuth.length() > 0) {
                    sb.append(newLine);
                    sb.append("Autenticazione Token");
                    sb.append(separator);
                    sb.append(bfAuth.toString());
                }
            }
        }
        if (autenticazioneTrasporto != null) {
            label = null;
            label = modipa && !gestioneFruitore ? "Autenticazione Canale" : "Autenticazione Trasporto";
            sb.append(newLine);
            sb.append(label);
            sb.append(separator);
            TipoAutenticazione tipoAutenticazione = TipoAutenticazione.toEnumConstant((String)autenticazioneTrasporto);
            if (TipoAutenticazione.PRINCIPAL.equals((Object)tipoAutenticazione)) {
                TipoAutenticazionePrincipal autenticazionePrincipal = consoleHelper.getCore().getTipoAutenticazionePrincipal(autenticazioneProprieta);
                sb.append(tipoAutenticazione.getLabel()).append(" - ").append(autenticazionePrincipal.getLabel());
            } else if (TipoAutenticazione.APIKEY.equals((Object)tipoAutenticazione)) {
                String appIdV = ErogazioniDetailsUtilities.getProprieta("appId", autenticazioneProprieta);
                boolean appId = ServletUtils.isCheckBoxEnabled((String)appIdV);
                if (appId) {
                    sb.append(tipoAutenticazione.getLabel()).append(" + ").append("app-id");
                } else {
                    sb.append(tipoAutenticazione.getLabel());
                }
            } else if (tipoAutenticazione != null) {
                sb.append(tipoAutenticazione.getLabel());
            } else {
                try {
                    confCore = new ConfigurazioneCore(consoleHelper.getCore());
                    p = confCore.getPlugin(TipoPlugin.AUTENTICAZIONE, autenticazioneTrasporto, false);
                    if (p != null) {
                        sb.append(p.getLabel());
                    } else {
                        sb.append(autenticazioneTrasporto);
                    }
                }
                catch (Throwable t) {
                    sb.append(autenticazioneTrasporto);
                }
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)autenticazioneTrasportoOpzionale)) {
                sb.append(newLine);
                sb.append("Autenticazione Opzionale");
                sb.append(separator);
                sb.append(autenticazioneTrasportoOpzionale);
            }
        }
        if (listAA != null && listAA.size() > 0) {
            StringBuilder sbAA = new StringBuilder();
            for (AttributeAuthority aa : listAA) {
                if (sbAA.length() > 0) {
                    sbAA.append(", ");
                }
                sbAA.append(aa.getNome());
            }
            if (sbAA.length() > 0) {
                sb.append(newLine);
                sb.append("Attribute Authority");
                sb.append(separator);
                sb.append(sbAA.toString());
            }
        }
        if (autorizzazione != null) {
            label = null;
            label = modipa && !gestioneFruitore ? "Autorizzazione Canale" : (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) || autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase()) ? "Autorizzazione Trasporto" : "Autorizzazione");
            Object value = null;
            if ("none".equals(autorizzazione)) {
                value = CostantiConfigurazione.DISABILITATO.getValue();
            } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.XACML_POLICY.getValue().toLowerCase())) {
                value = TipoAutorizzazione.XACML_POLICY.getValue();
            } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) || autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
                value = CostantiConfigurazione.ABILITATO.getValue();
                value = (String)value + " (";
                if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase())) {
                    value = (String)value + "Richiedente";
                    if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase())) {
                        value = (String)value + ", ";
                    }
                }
                if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase())) {
                    value = (String)value + "Ruoli";
                }
                value = (String)value + ")";
            } else {
                try {
                    confCore = new ConfigurazioneCore(consoleHelper.getCore());
                    p = confCore.getPlugin(TipoPlugin.AUTORIZZAZIONE, autorizzazione, false);
                    value = p != null ? p.getLabel() : autorizzazione;
                }
                catch (Throwable t) {
                    value = autorizzazione;
                }
            }
            sb.append(newLine);
            sb.append(label);
            sb.append(separator);
            sb.append((String)value);
            boolean richiedentiDefiniti = false;
            if (authzSoggetti != null && !authzSoggetti.isEmpty()) {
                StringBuilder sbSog = new StringBuilder();
                for (IDSoggetto iDSoggetto : authzSoggetti) {
                    if (sbSog.length() > 0) {
                        sb.append(", ");
                    }
                    try {
                        sbSog.append(consoleHelper.getLabelNomeSoggetto(protocollo, iDSoggetto.getTipo(), iDSoggetto.getNome()));
                    }
                    catch (Throwable t) {
                        sbSog.append(iDSoggetto.getTipo() + "/" + iDSoggetto.getNome());
                    }
                }
                if (sbSog.toString().length() > 0) {
                    sb.append(newLine);
                    sb.append("Soggetti").append(" autorizzati");
                    sb.append(separator);
                    sb.append(sbSog.toString());
                    richiedentiDefiniti = true;
                }
            }
            if (!(modipa && !gestioneFruitore || authzApplicativi == null || authzApplicativi.isEmpty())) {
                StringBuilder sbApp = new StringBuilder();
                for (IDServizioApplicativo iDServizioApplicativo : authzApplicativi) {
                    if (sbApp.length() > 0) {
                        sbApp.append(", ");
                    }
                    if (gestioneFruitore) {
                        sbApp.append(iDServizioApplicativo.getNome());
                        continue;
                    }
                    Object sog = null;
                    try {
                        sog = consoleHelper.getLabelNomeSoggetto(protocollo, iDServizioApplicativo.getIdSoggettoProprietario().getTipo(), iDServizioApplicativo.getIdSoggettoProprietario().getNome());
                    }
                    catch (Throwable t) {
                        sog = iDServizioApplicativo.getIdSoggettoProprietario().getTipo() + "/" + iDServizioApplicativo.getIdSoggettoProprietario().getNome();
                    }
                    sbApp.append(iDServizioApplicativo.getNome() + "@" + (String)sog);
                }
                if (sbApp.toString().length() > 0) {
                    sb.append(newLine);
                    sb.append("Applicativi").append(" autorizzati");
                    sb.append(separator);
                    sb.append(sbApp.toString());
                    richiedentiDefiniti = true;
                }
            }
            if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.AUTHENTICATED.getValue().toLowerCase()) && !richiedentiDefiniti) {
                sb.append(newLine);
                sb.append("Richiedenti").append(" autorizzati");
                sb.append(separator);
                sb.append("-");
            }
            if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase()) || autorizzazione.toLowerCase().contains(TipoAutorizzazione.XACML_POLICY.getValue().toLowerCase())) {
                StringBuilder sbRuoli = new StringBuilder();
                if (authzRuoli != null && !authzRuoli.isEmpty()) {
                    for (String string : authzRuoli) {
                        if (sbRuoli.length() > 0) {
                            sbRuoli.append(", ");
                        }
                        sbRuoli.append(string);
                    }
                } else if (autorizzazione.toLowerCase().contains(TipoAutorizzazione.ROLES.getValue().toLowerCase())) {
                    sbRuoli.append("-");
                }
                if (sbRuoli.toString().length() > 0) {
                    sb.append(newLine);
                    sb.append("Ruoli").append(" (").append(allRuoli ? "tutti" : "almeno uno").append(")");
                    sb.append(separator);
                    sb.append(sbRuoli.toString());
                }
            }
            if (modipa && !gestioneFruitore) {
                boolean autorizzazioneMessaggio;
                if (!authzApplicativiTokenEnabled && authzApplicativi != null && !authzApplicativi.isEmpty()) {
                    authzApplicativiTokenEnabled = true;
                }
                boolean bl = autorizzazioneMessaggio = authzApplicativiTokenEnabled || authzRuoliTokenEnabled;
                if (autorizzazioneMessaggio) {
                    label = "Autorizzazione Messaggio";
                    value = CostantiConfigurazione.ABILITATO.getValue();
                    value = (String)value + " (";
                    boolean first = true;
                    if (authzApplicativiTokenEnabled) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Richiedente";
                        first = false;
                    }
                    if (authzRuoliTokenEnabled) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Ruoli";
                        first = false;
                    }
                    value = (String)value + ")";
                    sb.append(newLine);
                    sb.append(label);
                    sb.append(separator);
                    sb.append((String)value);
                }
            } else {
                boolean autorizzazioneToken;
                boolean bl = autorizzazioneToken = authzApplicativiTokenEnabled || authzRuoliTokenEnabled || authzScopeTokenEnabled || authzTokenClaims != null && !authzTokenClaims.isEmpty();
                if (autorizzazioneToken) {
                    label = "Autorizzazione Token";
                    value = CostantiConfigurazione.ABILITATO.getValue();
                    value = (String)value + " (";
                    boolean first = true;
                    if (authzApplicativiTokenEnabled) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Richiedente";
                        first = false;
                    }
                    if (authzRuoliTokenEnabled) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Ruoli";
                        first = false;
                    }
                    if (authzScopeTokenEnabled) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Scope";
                        first = false;
                    }
                    if (authzTokenClaims != null && !authzTokenClaims.isEmpty()) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Token Claims";
                        first = false;
                    }
                    value = (String)value + ")";
                    sb.append(newLine);
                    sb.append(label);
                    sb.append(separator);
                    sb.append((String)value);
                }
            }
            if (authzApplicativiTokenEnabled) {
                StringBuilder sbApp = new StringBuilder();
                List<IDServizioApplicativo> ll = authzApplicativiToken;
                if (modipa && !gestioneFruitore) {
                    ll = authzApplicativi;
                }
                if (ll != null && !ll.isEmpty()) {
                    for (IDServizioApplicativo sa : ll) {
                        if (sbApp.length() > 0) {
                            sbApp.append(", ");
                        }
                        if (gestioneFruitore) {
                            sbApp.append(sa.getNome());
                            continue;
                        }
                        Object sog = null;
                        try {
                            sog = consoleHelper.getLabelNomeSoggetto(protocollo, sa.getIdSoggettoProprietario().getTipo(), sa.getIdSoggettoProprietario().getNome());
                        }
                        catch (Throwable t) {
                            sog = sa.getIdSoggettoProprietario().getTipo() + "/" + sa.getIdSoggettoProprietario().getNome();
                        }
                        sbApp.append(sa.getNome() + "@" + (String)sog);
                    }
                } else {
                    sbApp.append("-");
                }
                if (sbApp.toString().length() > 0) {
                    sb.append(newLine);
                    sb.append("Applicativi").append(" autorizzati");
                    sb.append(separator);
                    sb.append(sbApp.toString());
                }
            }
            if (authzRuoliTokenEnabled) {
                StringBuilder sbRuoli = new StringBuilder();
                if (authzRuoliToken != null && !authzRuoliToken.isEmpty()) {
                    for (String string : authzRuoliToken) {
                        if (sbRuoli.length() > 0) {
                            sbRuoli.append(", ");
                        }
                        sbRuoli.append(string);
                    }
                } else {
                    sbRuoli.append("-");
                }
                if (sbRuoli.toString().length() > 0) {
                    sb.append(newLine);
                    sb.append("Ruoli").append(" (").append(allRuoliToken ? "tutti" : "almeno uno").append(")");
                    sb.append(separator);
                    sb.append(sbRuoli.toString());
                }
            }
            if (modipa && !gestioneFruitore) {
                boolean autorizzazioneToken;
                boolean bl = autorizzazioneToken = authzScopeTokenEnabled || authzTokenClaims != null && !authzTokenClaims.isEmpty();
                if (autorizzazioneToken) {
                    label = "Autorizzazione Token";
                    value = CostantiConfigurazione.ABILITATO.getValue();
                    value = (String)value + " (";
                    boolean first = true;
                    if (authzScopeTokenEnabled) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Scope";
                        first = false;
                    }
                    if (authzTokenClaims != null && !authzTokenClaims.isEmpty()) {
                        if (!first) {
                            value = (String)value + ", ";
                        }
                        value = (String)value + "Token Claims";
                        first = false;
                    }
                    value = (String)value + ")";
                    sb.append(newLine);
                    sb.append(label);
                    sb.append(separator);
                    sb.append((String)value);
                }
            }
            if (authzScopeTokenEnabled) {
                StringBuilder sbScope = new StringBuilder();
                if (authzScope != null && !authzScope.isEmpty()) {
                    for (String string : authzScope) {
                        if (sbScope.length() > 0) {
                            sbScope.append(", ");
                        }
                        sbScope.append(string);
                    }
                } else {
                    sbScope.append("-");
                }
                if (sbScope.toString().length() > 0) {
                    sb.append(newLine);
                    sb.append("Scope").append(" (").append(allScope ? "tutti" : "almeno uno").append(")");
                    sb.append(separator);
                    sb.append(sbScope.toString());
                }
            }
            if (authzTokenClaims != null && !authzTokenClaims.isEmpty()) {
                StringBuilder sbTokenClaims = new StringBuilder();
                for (String string : authzTokenClaims) {
                    if (sbTokenClaims.length() > 0) {
                        sbTokenClaims.append(", ");
                    }
                    sbTokenClaims.append(string);
                }
                if (sbTokenClaims.toString().length() > 0) {
                    sb.append(newLine);
                    sb.append("Token Claims");
                    sb.append(separator);
                    sb.append(sbTokenClaims.toString());
                }
            }
        }
        if (autorizzazioneContenuti != null && !"none".equals(autorizzazioneContenuti)) {
            label = "Autorizzazione Contenuti";
            sb.append(newLine);
            sb.append(label);
            sb.append(separator);
            if ("builtIn".equals(autorizzazioneContenuti)) {
                sb.append(CostantiConfigurazione.ABILITATO.getValue());
            } else {
                try {
                    ConfigurazioneCore confCore2 = new ConfigurazioneCore(consoleHelper.getCore());
                    Plugin p2 = confCore2.getPlugin(TipoPlugin.AUTORIZZAZIONE_CONTENUTI, autorizzazioneContenuti, false);
                    if (p2 != null) {
                        sb.append(p2.getLabel());
                    } else {
                        sb.append(autorizzazioneContenuti);
                    }
                }
                catch (Throwable t) {
                    sb.append(autorizzazioneContenuti);
                }
            }
        }
    }

    private static void printConfigurazioneRateLimiting(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, boolean gestioneFruitore, String nomePorta, StringBuilder sb, String separator, String newLine) throws Exception {
        ConfigurazioneCore confCore = new ConfigurazioneCore(soggettiCore);
        ConsoleSearch searchPolicy = new ConsoleSearch(true);
        List<AttivazionePolicy> listaPolicy = confCore.attivazionePolicyList(searchPolicy, gestioneFruitore ? RuoloPolicy.DELEGATA : RuoloPolicy.APPLICATIVA, nomePorta);
        if (listaPolicy != null && !listaPolicy.isEmpty()) {
            DataElement de = new DataElement();
            consoleHelper.setStatoRateLimiting(de, listaPolicy, false);
            ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, "Rate Limiting", sb, separator, newLine);
        }
    }

    private static void printConfigurazioneValidazioneContenutiApplicativi(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, AccordoServizioParteComune aspc, ValidazioneContenutiApplicativi validazioneContenutiApplicativi, StringBuilder sb, String separator, String newLine) throws Exception {
        if (validazioneContenutiApplicativi != null && (StatoFunzionalitaConWarning.ABILITATO.equals((Object)validazioneContenutiApplicativi.getStato()) || StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)validazioneContenutiApplicativi.getStato()))) {
            Object value = null;
            switch (validazioneContenutiApplicativi.getTipo()) {
                case INTERFACE: {
                    switch (aspc.getFormatoSpecifica()) {
                        case OPEN_API_3: {
                            value = "Open API 3";
                            break;
                        }
                        case SWAGGER_2: {
                            value = "Swagger 2";
                            break;
                        }
                        case WSDL_11: {
                            value = "Wsdl 1.1";
                        }
                    }
                    break;
                }
                case XSD: {
                    value = "Schemi XSD";
                    break;
                }
                case OPENSPCOOP: {
                    value = "Registro API";
                }
            }
            if (StatoFunzionalitaConWarning.WARNING_ONLY.equals((Object)validazioneContenutiApplicativi.getStato())) {
                value = (String)value + " [WarningOnly]";
            }
            if (ServiceBinding.SOAP.equals((Object)aspc.getServiceBinding()) && validazioneContenutiApplicativi.getAcceptMtomMessage() != null && StatoFunzionalita.ABILITATO.equals((Object)validazioneContenutiApplicativi.getAcceptMtomMessage())) {
                value = (String)value + " [Accept-MTOM]";
            }
            sb.append(newLine);
            sb.append("Validazione Contenuti Applicativi");
            sb.append(separator);
            sb.append((String)value);
        }
    }

    private static void printConfigurazioneResponseCaching(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, ResponseCachingConfigurazione responseCachingConfigurazione, StringBuilder sb, String separator, String newLine) throws Exception {
        if (responseCachingConfigurazione != null && StatoFunzionalita.ABILITATO.equals((Object)responseCachingConfigurazione.getStato())) {
            sb.append(newLine);
            sb.append("Caching Risposta");
            sb.append(separator);
            sb.append(StatoFunzionalitaConWarning.ABILITATO.getValue());
        }
    }

    private static void printConfigurazioneMessageSecurity(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, MessageSecurity messageSecurity, StringBuilder sb, String separator, String newLine) throws Exception {
        if (messageSecurity != null && (messageSecurity.getRequestFlow() != null && messageSecurity.getRequestFlow().getMode() != null || messageSecurity.getResponseFlow() != null && messageSecurity.getResponseFlow().getMode() != null)) {
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(soggettiCore);
            PropertiesSourceConfiguration propertiesSourceConfiguration = apsCore.getMessageSecurityPropertiesSourceConfiguration();
            ConfigManager configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
            configManager.leggiConfigurazioni(propertiesSourceConfiguration, true);
            DataElement de = new DataElement();
            consoleHelper.setStatoSicurezzaMessaggio(de, messageSecurity, configManager, propertiesSourceConfiguration, false);
            ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, "Sicurezza Messaggio", sb, separator, newLine);
        }
    }

    private static void printConfigurazioneMTOM(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, MtomProcessor mtomProcessor, StringBuilder sb, String separator, String newLine) throws Exception {
        if (mtomProcessor != null && (mtomProcessor.getRequestFlow() != null && mtomProcessor.getRequestFlow().getMode() != null && !MTOMProcessorType.DISABLE.equals((Object)mtomProcessor.getRequestFlow().getMode()) || mtomProcessor.getResponseFlow() != null && mtomProcessor.getResponseFlow().getMode() != null && !MTOMProcessorType.DISABLE.equals((Object)mtomProcessor.getResponseFlow().getMode()))) {
            DataElement de = new DataElement();
            consoleHelper.setStatoMTOM(de, mtomProcessor, false);
            ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, "Configurazione MTOM", sb, separator, newLine);
        }
    }

    private static void printConfigurazioneTrasformazioni(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, AccordoServizioParteComune aspc, Trasformazioni trasformazioni, StringBuilder sb, String separator, String newLine) throws Exception {
        if (trasformazioni != null && trasformazioni.sizeRegolaList() > 0) {
            boolean almostOneEnable = false;
            for (TrasformazioneRegola tRegola : trasformazioni.getRegolaList()) {
                if (!StatoFunzionalita.ABILITATO.equals((Object)tRegola.getStato())) continue;
                almostOneEnable = true;
                break;
            }
            if (almostOneEnable) {
                DataElement de = new DataElement();
                consoleHelper.setStatoTrasformazioni(de, trasformazioni, org.openspcoop2.message.constants.ServiceBinding.valueOf((String)aspc.getServiceBinding().name()), false);
                ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, "Trasformazioni", sb, separator, newLine);
            }
        }
    }

    private static void printConfigurazioneTracciamento(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, CorrelazioneApplicativa correlazioneApplicativa, CorrelazioneApplicativaRisposta correlazioneApplicativaRisposta, PortaTracciamento tracciamentoConfig, StringBuilder sb, String separator, String newLine) throws Exception {
        boolean ridefinito = false;
        boolean enable = false;
        if (tracciamentoConfig != null && tracciamentoConfig.getEsiti() != null) {
            ridefinito = true;
            boolean bl = enable = !("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI).equals(tracciamentoConfig.getEsiti());
        }
        if (ridefinito) {
            sb.append(newLine);
            sb.append("Transazioni");
            sb.append(separator);
            sb.append(enable ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
        }
        ridefinito = false;
        enable = false;
        String labelDiagnostici = null;
        if (tracciamentoConfig != null && tracciamentoConfig.getSeverita() != null) {
            ridefinito = true;
            labelDiagnostici = "Severit\u00e0 " + tracciamentoConfig.getSeverita().getValue();
            boolean bl = enable = !"off".equals(tracciamentoConfig.getSeverita().getValue());
        }
        if (ridefinito) {
            sb.append(newLine);
            sb.append("Diagnostici");
            sb.append(separator);
            sb.append((String)(enable ? StatoFunzionalita.ABILITATO.getValue() + " [" + labelDiagnostici + "]" : StatoFunzionalita.DISABILITATO.getValue()));
        }
        boolean isCorrelazioneApplicativaAbilitataReq = false;
        if (correlazioneApplicativa != null) {
            isCorrelazioneApplicativaAbilitataReq = correlazioneApplicativa.sizeElementoList() > 0;
        }
        boolean isCorrelazioneApplicativaAbilitataRes = false;
        if (correlazioneApplicativaRisposta != null) {
            boolean bl = isCorrelazioneApplicativaAbilitataRes = correlazioneApplicativaRisposta.sizeElementoList() > 0;
        }
        if (isCorrelazioneApplicativaAbilitataReq || isCorrelazioneApplicativaAbilitataRes) {
            sb.append(newLine);
            sb.append("Correlazione Applicativa");
            sb.append(separator);
            StringBuilder sbCor = new StringBuilder();
            if (isCorrelazioneApplicativaAbilitataReq) {
                sb.append("Richiesta".toLowerCase());
                if (correlazioneApplicativa.sizeElementoList() > 1) {
                    sb.append(" (").append(correlazioneApplicativa.sizeElementoList()).append(")");
                }
            }
            if (isCorrelazioneApplicativaAbilitataRes) {
                if (isCorrelazioneApplicativaAbilitataReq) {
                    sb.append(", ");
                }
                sb.append("Risposta".toLowerCase());
                if (correlazioneApplicativaRisposta.sizeElementoList() > 1) {
                    sb.append(" (").append(correlazioneApplicativaRisposta.sizeElementoList()).append(")");
                }
            }
            sb.append(sbCor.toString());
        }
    }

    private static void printConfigurazioneRegistrazioneMessaggi(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, DumpConfigurazione dumpConfigurazione, StringBuilder sb, String separator, String newLine) throws Exception {
        if (dumpConfigurazione != null) {
            DataElement de = new DataElement();
            consoleHelper.setStatoDump(de, dumpConfigurazione, null, false, false);
            ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, "Registrazione Messaggi", sb, separator, newLine);
        }
    }

    private static void printConfigurazioneAllarmi(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, boolean gestioneFruitore, String nomePorta, StringBuilder sb, String separator, String newLine) throws Exception {
        boolean visualizzaAllarmi = soggettiCore.isConfigurazioneAllarmiEnabled();
        if (visualizzaAllarmi) {
            List<ConfigurazioneAllarmeBean> listaAllarmi = null;
            ConfigurazioneCore confCore = new ConfigurazioneCore(soggettiCore);
            ConsoleSearch searchPolicy = new ConsoleSearch(true);
            listaAllarmi = confCore.allarmiList(searchPolicy, gestioneFruitore ? RuoloPorta.DELEGATA : RuoloPorta.APPLICATIVA, nomePorta);
            if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                DataElement de = new DataElement();
                consoleHelper.setStatoAllarmi(de, listaAllarmi);
                ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, "Allarmi", sb, separator, newLine);
            }
        }
    }

    private static void printConfigurazioneProperties(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, List<Proprieta> list, StringBuilder sb, String separator, String newLine) throws Exception {
        if (list != null && list.size() > 0) {
            StringBuilder sbProp = new StringBuilder();
            if (list.size() <= 5) {
                for (Proprieta proprieta : list) {
                    if (sbProp.length() > 0) {
                        sbProp.append(", ");
                    }
                    sbProp.append(proprieta.getNome());
                    sbProp.append("=");
                    int limitValore = 30;
                    if (proprieta.getValore().length() < limitValore) {
                        sbProp.append(proprieta.getValore());
                        continue;
                    }
                    sbProp.append(proprieta.getValore().substring(0, limitValore - 3) + "...");
                }
            } else if (list.size() <= 10) {
                for (Proprieta proprieta : list) {
                    if (sbProp.length() > 0) {
                        sbProp.append(", ");
                    }
                    sbProp.append(proprieta.getNome());
                }
            } else {
                sbProp.append(StatoFunzionalita.ABILITATO.getValue()).append(" (").append(list.size()).append(")");
            }
            sb.append(newLine);
            sb.append("Propriet\u00e0");
            sb.append(separator);
            sb.append(sbProp.toString());
        }
    }

    private static void printConfigurazioneAltro(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, String protocollo, AccordoServizioParteComune aspc, StatoFunzionalita allegaBody, StatoFunzionalita scartaBody, String integrazione, String behaviour, List<Proprieta> proprietaRateLimiting, StatoFunzionalita stateless, PortaDelegataLocalForward localForward, StatoFunzionalita ricevutaAsincronaSimmetrica, StatoFunzionalita ricevutaAsincronaAsimmetrica, StatoFunzionalita gestioneManifest, ConfigurazionePortaHandler configPortaHandler, StringBuilder sb, String separator, String newLine) throws Exception {
        DataElement de = new DataElement();
        consoleHelper.setStatoOpzioniAvanzate(de, protocollo, org.openspcoop2.message.constants.ServiceBinding.valueOf((String)aspc.getServiceBinding().name()), allegaBody, scartaBody, integrazione, behaviour, proprietaRateLimiting, stateless, localForward, ricevutaAsincronaSimmetrica, ricevutaAsincronaAsimmetrica, gestioneManifest, configPortaHandler, false);
        List l = de.getStatusValuesAsList();
        boolean print = false;
        if (l != null && !l.isEmpty()) {
            if (l.size() > 1) {
                print = true;
            } else {
                String s = (String)l.get(0);
                if (s != null && !"".equalsIgnoreCase(s)) {
                    boolean bl = print = !CostantiConfigurazione.DISABILITATO.getValue().toLowerCase().equals(s.toLowerCase());
                }
            }
        }
        if (print) {
            ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, "Opzioni Avanzate", sb, separator, newLine);
        }
    }

    private static void printConfigurazionePortaDelegataExtended(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, String protocollo, PortaDelegata portaDelegata, MappingFruizionePortaDelegata mapping, StringBuilder sb, String separator, String newLine) throws Exception {
        IExtendedListServlet extendedServletList = soggettiCore.getExtendedServletPortaDelegata();
        if (extendedServletList != null && extendedServletList.showExtendedInfo(consoleHelper, protocollo)) {
            String stato = extendedServletList.getStatoTab(consoleHelper, portaDelegata, mapping.isDefault());
            String statoTooltip = extendedServletList.getStatoTab(consoleHelper, portaDelegata, mapping.isDefault());
            int numExtended = extendedServletList.sizeList(portaDelegata);
            DataElement de = new DataElement();
            consoleHelper.setStatoExtendedList(de, numExtended, stato, statoTooltip, false);
            String label = extendedServletList.getListTitle(consoleHelper);
            ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, label, sb, separator, newLine);
        }
    }

    private static void printConfigurazionePortaApplicativaExtended(ConsoleHelper consoleHelper, SoggettiCore soggettiCore, String protocollo, PortaApplicativa portaApplicativa, MappingErogazionePortaApplicativa mapping, StringBuilder sb, String separator, String newLine) throws Exception {
        IExtendedListServlet extendedServletList = soggettiCore.getExtendedServletPortaApplicativa();
        if (extendedServletList != null && extendedServletList.showExtendedInfo(consoleHelper, protocollo)) {
            String stato = extendedServletList.getStatoTab(consoleHelper, portaApplicativa, mapping.isDefault());
            String statoTooltip = extendedServletList.getStatoTab(consoleHelper, portaApplicativa, mapping.isDefault());
            int numExtended = extendedServletList.sizeList(portaApplicativa);
            DataElement de = new DataElement();
            consoleHelper.setStatoExtendedList(de, numExtended, stato, statoTooltip, false);
            String label = extendedServletList.getListTitle(consoleHelper);
            ErogazioniDetailsUtilities.printConfigurazioneFromStatusValues(de, label, sb, separator, newLine);
        }
    }

    private static void printConfigurazioneFromStatusValues(DataElement de, String label, StringBuilder sb, String separator, String newLine) {
        List l = de.getStatusValuesAsList();
        if (l != null && !l.isEmpty()) {
            StringBuilder sbRT = new StringBuilder();
            for (String s : l) {
                if (sbRT.length() > 0) {
                    sbRT.append(", ");
                }
                sbRT.append(s);
            }
            if (sbRT.length() > 0) {
                sb.append(newLine);
                sb.append(label);
                sb.append(separator);
                sb.append(sbRT.toString());
            }
        }
    }

    private static void printConnettoreErogazione(PortaApplicativa paDefault, PortaApplicativa paAssociata, ServiziApplicativiCore saCore, ConsoleHelper consoleHelper, StringBuilder sb, String separator, String newLine) throws Exception {
        boolean connettoreMultiploEnabled;
        if (paDefault == null) {
            throw new Exception("Param paDefault is null");
        }
        if (paAssociata == null) {
            throw new Exception("Param paAssociata is null");
        }
        if (saCore == null) {
            throw new Exception("Param saCore is null");
        }
        boolean bl = connettoreMultiploEnabled = paAssociata.getBehaviour() != null;
        if (connettoreMultiploEnabled) {
            sb.append(newLine);
            sb.append(consoleHelper.getNomiConnettoriMultipliPortaApplicativa(paAssociata));
            for (PortaApplicativaServizioApplicativo paSA : paAssociata.getServizioApplicativoList()) {
                String nomeConnettore = "Default";
                if (paSA.getDatiConnettore() != null && paSA.getDatiConnettore().getNome() != null) {
                    nomeConnettore = paSA.getDatiConnettore().getNome();
                }
                IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario()));
                idServizioApplicativo.setNome(paSA.getNome());
                ServizioApplicativo sa = saCore.getServizioApplicativo(idServizioApplicativo);
                InvocazioneServizio is = sa.getInvocazioneServizio();
                org.openspcoop2.core.config.Connettore connettore = is.getConnettore();
                ErogazioniDetailsUtilities.printConnettoreErogazione(consoleHelper, connettore, nomeConnettore, sa, sb, separator, newLine, true);
            }
        } else {
            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario()));
            idServizioApplicativo.setNome(paAssociata.getServizioApplicativo(0).getNome());
            ServizioApplicativo sa = saCore.getServizioApplicativo(idServizioApplicativo);
            InvocazioneServizio is = sa.getInvocazioneServizio();
            org.openspcoop2.core.config.Connettore connettore = is.getConnettore();
            ErogazioniDetailsUtilities.printConnettoreErogazione(consoleHelper, connettore, null, sa, sb, separator, newLine, false);
        }
    }

    private static void printConnettoreFruizione(ConsoleHelper consoleHelper, Connettore connettore, String labelNomeConnettore, boolean connettoreStatic, StringBuilder sb, String separator, String newLine) throws Exception {
        if (connettore == null) {
            throw new Exception("Param connettore is null");
        }
        ErogazioniDetailsUtilities._printConnettore(consoleHelper, connettore.mappingIntoConnettoreConfigurazione(), labelNomeConnettore, null, connettoreStatic, sb, separator, newLine, false);
    }

    private static void printConnettoreErogazione(ConsoleHelper consoleHelper, org.openspcoop2.core.config.Connettore connettore, String labelNomeConnettore, ServizioApplicativo sa, StringBuilder sb, String separator, String newLine, boolean printIntestazione) throws Exception {
        ErogazioniDetailsUtilities._printConnettore(consoleHelper, connettore, labelNomeConnettore, sa, false, sb, separator, newLine, printIntestazione);
    }

    private static void _printConnettore(ConsoleHelper consoleHelper, org.openspcoop2.core.config.Connettore connettore, String labelNomeConnettore, ServizioApplicativo sa, boolean connettoreStatic, StringBuilder sb, String separator, String newLine, boolean printIntestazione) throws Exception {
        if (connettore == null) {
            throw new Exception("Param connettore is null");
        }
        TipiConnettore tipo = TipiConnettore.toEnumFromName((String)connettore.getTipo());
        if (tipo == null) {
            tipo = TipiConnettore.CUSTOM;
        }
        String labelTipoConnettore = tipo.getLabel();
        if (TipiConnettore.CUSTOM.equals((Object)tipo)) {
            try {
                ConfigurazioneCore confCore = new ConfigurazioneCore(consoleHelper.getCore());
                Plugin p = confCore.getPlugin(TipoPlugin.CONNETTORE, connettore.getTipo(), false);
                labelTipoConnettore = p != null ? p.getLabel() : connettore.getTipo();
            }
            catch (Throwable t) {
                labelTipoConnettore = connettore.getTipo();
            }
        }
        ConnettoreUtils.printDatiConnettore((org.openspcoop2.core.config.Connettore)connettore, (String)labelTipoConnettore, (String)labelNomeConnettore, (ServizioApplicativo)sa, (boolean)connettoreStatic, (StringBuilder)sb, (String)separator, (String)newLine, (boolean)printIntestazione);
    }

    private static String getProprieta(String nome, List<Proprieta> list) {
        if (list != null && !list.isEmpty()) {
            for (Proprieta property : list) {
                if (!property.getNome().equals(nome)) continue;
                return property.getValore();
            }
        }
        return null;
    }

    private static void addProfiloModISicurezza(StringBuilder sbParam, Map<String, String> map, String labelProtocollo, boolean rest, boolean fruizione, boolean request, boolean digest, String patternDatiCorniceSicurezza, String schemaDatiCorniceSicurezza, boolean headerDuplicati, String separator, String newLine) {
        String v;
        String vAud;
        Iterator<Map.Entry<String, String>> label;
        String prefixKey = ModIUtils.getPrefixKey((boolean)fruizione, (boolean)request);
        StringBuilder sb = new StringBuilder();
        String ttlV = map.get(prefixKey + "ttl");
        if (StringUtils.isNotEmpty((CharSequence)ttlV)) {
            sb.append(newLine);
            sb.append("Time to Live");
            sb.append(separator);
            sb.append(ttlV);
        }
        boolean audit = false;
        if (request) {
            sb.append(newLine);
            label = rest ? "Audience" : "WSAddressing To";
            sb.append((String)((Object)label));
            sb.append(separator);
            sb.append(map.get(prefixKey + "audience"));
            audit = true;
        } else if (fruizione) {
            audit = true;
            String verificaAud = map.get(prefixKey + "audience-verify");
            if (StringUtils.isNotEmpty((CharSequence)verificaAud)) {
                sb.append(newLine);
                String label2 = rest ? "Verifica Audience" : "Verifica WSAddressing To";
                sb.append(label2);
                sb.append(separator);
                sb.append(verificaAud);
            }
            if (StringUtils.isNotEmpty((CharSequence)(vAud = map.get(prefixKey + "audience")))) {
                String label3 = rest ? "Audience" : "WSAddressing To";
                sb.append(newLine);
                sb.append(label3);
                sb.append(separator);
                sb.append(vAud);
            }
        }
        if (audit) {
            label = rest ? "Audience" : "WSAddressing To";
            label = "Integrity " + (String)((Object)label);
            vAud = map.get(prefixKey + "integrity-audience");
            if (StringUtils.isNotEmpty((CharSequence)vAud)) {
                sb.append(newLine);
                sb.append((String)((Object)label));
                sb.append(separator);
                sb.append(vAud);
            }
        }
        if (fruizione && !request || !fruizione && request) {
            ErogazioniDetailsUtilities.addStore(sb, map, prefixKey, false, true, separator, newLine);
            if (rest) {
                ErogazioniDetailsUtilities.addStore(sb, map, prefixKey, true, false, separator, newLine);
            }
        }
        if (!fruizione && !request) {
            ErogazioniDetailsUtilities.addStore(sb, map, prefixKey, false, false, separator, newLine);
        }
        if (fruizione && request && StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "fruizione-keystore-mode")))) {
            sb.append(newLine);
            sb.append("KeyStore");
            sb.append(separator);
            sb.append(v);
            if ("Definito nella fruizione".equals(v)) {
                ErogazioniDetailsUtilities.addStore(sb, map, prefixKey, false, false, separator, newLine);
            }
        }
        if (rest) {
            v = map.get(prefixKey + "signature-algorithm");
            if (StringUtils.isNotEmpty((CharSequence)v)) {
                sb.append(newLine);
                sb.append("Algoritmo");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "digest-encoding")))) {
                sb.append(newLine);
                sb.append("Codifica Digest");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "signed-http-headers")))) {
                sb.append(newLine);
                sb.append("HTTP Headers da firmare");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "x509-reference")))) {
                sb.append(newLine);
                sb.append("Riferimento X.509");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "x509-certificate-chain")))) {
                sb.append(newLine);
                sb.append("Certificate Chain");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "x5u-certificate-url")))) {
                sb.append(newLine);
                sb.append("URL (x5u)");
                sb.append(separator);
                sb.append(v);
            }
        } else {
            v = map.get(prefixKey + "signature-algorithm");
            if (StringUtils.isNotEmpty((CharSequence)v)) {
                sb.append(newLine);
                sb.append("Algoritmo");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "canonicalization-algorithm")))) {
                sb.append(newLine);
                sb.append("Forma Canonica XML");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "signed-soap-headers")))) {
                sb.append(newLine);
                sb.append("SOAP Headers da firmare");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "x509-reference")))) {
                sb.append(newLine);
                sb.append("Riferimento X.509");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "x509-certificate-chain")))) {
                sb.append(newLine);
                sb.append("Certificate Chain");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "include-signature-token")))) {
                sb.append(newLine);
                sb.append("Includi Signature Token");
                sb.append(separator);
                sb.append(v);
            }
        }
        if (patternDatiCorniceSicurezza != null) {
            if (!"old".equals(patternDatiCorniceSicurezza) && schemaDatiCorniceSicurezza != null) {
                label = "Audit Audience";
                vAud = map.get(prefixKey + "audit-audience");
                if (StringUtils.isNotEmpty((CharSequence)vAud)) {
                    sb.append(newLine);
                    sb.append((String)((Object)label));
                    sb.append(separator);
                    sb.append(vAud);
                }
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String sKey;
                String key = entry.getKey();
                if (!key.startsWith(sKey = prefixKey + "audit-info-")) continue;
                String claim = key.substring(sKey.length());
                sb.append(newLine);
                sb.append(claim);
                sb.append(separator);
                String v2 = entry.getValue();
                sb.append(v2);
            }
        }
        if (fruizione && request) {
            v = map.get(prefixKey + "oauth-id");
            if (StringUtils.isNotEmpty((CharSequence)v)) {
                sb.append(newLine);
                sb.append("Token ClientId");
                sb.append(separator);
                sb.append(v);
            }
            if (StringUtils.isNotEmpty((CharSequence)(v = map.get(prefixKey + "oauth-kid")))) {
                sb.append(newLine);
                sb.append("Key Id (kid) del Certificato");
                sb.append(separator);
                sb.append(v);
            }
        }
        if (sb.length() > 0) {
            sbParam.append(newLine);
            sbParam.append("- " + (request ? "Request" : "Response") + " -");
            sbParam.append(sb.toString());
        }
    }

    private static void addStore(StringBuilder sb, Map<String, String> map, String prefixKeyParam, boolean ssl, boolean truststore, String separator, String newLine) {
        String label = null;
        label = ssl ? "TrustStore SSL" : (truststore ? "TrustStore Certificati" : "KeyStore");
        String store = ModIUtils.getPrefixKeyStore((boolean)false, (String)prefixKeyParam, (boolean)ssl, (boolean)truststore);
        String mode = map.get(store);
        if ("Default".equals(mode)) {
            sb.append(newLine);
            sb.append(label);
            sb.append(separator);
            sb.append("Default");
        } else {
            String prefixKey = ModIUtils.getPrefixKeyStore((boolean)true, (String)prefixKeyParam, (boolean)ssl, (boolean)truststore);
            String type = map.get(prefixKey + "type");
            String path = map.get(prefixKey + "path");
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                String aliasKey;
                String crl;
                String ocsp;
                sb.append(newLine);
                sb.append(label);
                sb.append(separator);
                sb.append("(").append(type).append(")");
                if (StringUtils.isNotEmpty((CharSequence)path)) {
                    sb.append(" ").append(path);
                }
                if (StringUtils.isNotEmpty((CharSequence)(ocsp = map.get(prefixKey + "ocsp")))) {
                    sb.append(newLine);
                    sb.append(label).append(" ").append("OCSP Policy");
                    sb.append(separator);
                    try {
                        String labelOcsp = OCSPManager.getInstance().getOCSPConfig(ocsp).getLabel();
                        sb.append(labelOcsp != null && StringUtils.isNotEmpty((CharSequence)labelOcsp) ? labelOcsp : ocsp);
                    }
                    catch (Throwable t) {
                        sb.append(ocsp);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(crl = map.get(prefixKey + "crls")))) {
                    sb.append(newLine);
                    sb.append(label).append(" ").append("CRL File(s)");
                    sb.append(separator);
                    sb.append(crl);
                }
                if (StringUtils.isNotEmpty((CharSequence)(aliasKey = map.get(prefixKey + "key-alias")))) {
                    sb.append(newLine);
                    sb.append("Alias Chiave Privata");
                    sb.append(separator);
                    sb.append(aliasKey);
                }
            }
        }
    }
}

