/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.sdk.archive.ArchiveCascadeConfiguration;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCostanti;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class Exporter
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            boolean nonSonoPresentiScelteEsportazione;
            String exportMode;
            ArchiviHelper archiviHelper = new ArchiviHelper(request, pd, session);
            archiviHelper.makeMenu();
            ArchiviCore archiviCore = new ArchiviCore();
            SoggettiCore soggettiCore = new SoggettiCore(archiviCore);
            ExporterUtils exporterUtils = new ExporterUtils(archiviCore);
            String servletSourceExport = archiviHelper.getParametroArchiveType("tipoExport");
            ArchiveType archiveType = ArchiveType.valueOf((String)servletSourceExport);
            String objToExport = archiviHelper.getParameter("obj");
            String cascadePolicyConfig = archiviHelper.getParameter("cascadePolicyConfig");
            String cascadePluginConfig = archiviHelper.getParameter("cascadePluginConfig");
            String cascade = archiviHelper.getParameter("cascade");
            String cascadePdd = archiviHelper.getParameter("cascadePdd");
            String cascadeRuoli = archiviHelper.getParameter("cascadeRuoli");
            String cascadeScope = archiviHelper.getParameter("cascadeScope");
            String cascadeSoggetti = archiviHelper.getParameter("cascadeSoggetti");
            String cascadeServiziApplicativi = archiviHelper.getParameter("cascadeServiziApplicativi");
            String cascadePorteDelegate = archiviHelper.getParameter("cascadePorteDelegate");
            String cascadePorteApplicative = archiviHelper.getParameter("cascadePorteApplicative");
            String cascadeAccordiCooperazione = archiviHelper.getParameter("cascadeAc");
            String cascadeAccordiServizioComposto = archiviHelper.getParameter("cascadeAsc");
            String cascadeAccordiServizioParteComune = archiviHelper.getParameter("cascadeAspc");
            String cascadeAccordiServizioParteSpecifica = archiviHelper.getParameter("cascadeAsps");
            String cascadeFruizioni = archiviHelper.getParameter("cascadeFruizioni");
            String tipoConfigurazione = archiviHelper.getParameter("tipoDump");
            Parameter provenienza = null;
            String urlTitle = null;
            List<Object> identificativi = null;
            List<Object> protocolli = new ArrayList();
            switch (archiveType) {
                case SOGGETTO: {
                    provenienza = new Parameter("Soggetti", "soggettiList.do");
                    identificativi = exporterUtils.getIdsSoggetti(objToExport);
                    for (Object object : identificativi) {
                        IDSoggetto idSoggetto = (IDSoggetto)object;
                        String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idSoggetto.getTipo());
                        if (protocolli.contains(protocollo)) continue;
                        protocolli.add(protocollo);
                    }
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    Object protocollo;
                    IDAccordo idAccordo;
                    String servletApi = "accordiServizioParteComuneList.do";
                    if (!archiviHelper.isModalitaCompleta()) {
                        servletApi = "accordiServizioParteComuneApiList.do";
                    }
                    provenienza = new Parameter("API", servletApi, new Parameter[]{new Parameter("tipoAccordo", "apc")});
                    identificativi = exporterUtils.getIdsAccordiServizioParteComune(objToExport);
                    for (Object id : identificativi) {
                        idAccordo = (IDAccordo)id;
                        protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idAccordo.getSoggettoReferente().getTipo());
                        if (protocolli.contains(protocollo)) continue;
                        protocolli.add(protocollo);
                    }
                    break;
                }
                case ACCORDO_SERVIZIO_COMPOSTO: {
                    Object protocollo;
                    IDAccordo idAccordo;
                    provenienza = new Parameter("API (Servizio Composto)", "accordiServizioParteComuneList.do", new Parameter[]{new Parameter("tipoAccordo", "asc")});
                    identificativi = exporterUtils.getIdsAccordiServizioComposti(objToExport);
                    for (Object id : identificativi) {
                        idAccordo = (IDAccordo)id;
                        protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idAccordo.getSoggettoReferente().getTipo());
                        if (protocolli.contains(protocollo)) continue;
                        protocolli.add(protocollo);
                    }
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                case EROGAZIONE: 
                case FRUIZIONE: {
                    String protocollo;
                    Boolean vistaErogazioni;
                    String string = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
                    boolean gestioneFruitori = false;
                    if (string != null && "fruizione".equals(string)) {
                        gestioneFruitori = true;
                    }
                    provenienza = (vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)session, (HttpServletRequest)request).getValue()) != null && vistaErogazioni.booleanValue() ? (gestioneFruitori ? new Parameter("Fruizioni", "aspsErogazioniList.do") : new Parameter("Erogazioni", "aspsErogazioniList.do")) : (gestioneFruitori ? new Parameter("Fruizioni", "accordiServizioParteSpecificaList.do") : new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                    identificativi = exporterUtils.getIdsAccordiServizioParteSpecifica(objToExport, gestioneFruitori);
                    for (Object id : identificativi) {
                        IDServizio idServizio = null;
                        idServizio = gestioneFruitori ? ((IDFruizione)id).getIdServizio() : (IDServizio)id;
                        protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idServizio.getSoggettoErogatore().getTipo());
                        if (protocolli.contains(protocollo)) continue;
                        protocolli.add(protocollo);
                    }
                    break;
                }
                case ACCORDO_COOPERAZIONE: {
                    String protocollo;
                    provenienza = new Parameter("Accordi Cooperazione", "accordiCooperazioneList.do");
                    identificativi = exporterUtils.getIdsAccordiCooperazione(objToExport);
                    for (Object id : identificativi) {
                        IDAccordoCooperazione idAccordo = (IDAccordoCooperazione)id;
                        protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idAccordo.getSoggettoReferente().getTipo());
                        if (protocolli.contains(protocollo)) continue;
                        protocolli.add(protocollo);
                    }
                    break;
                }
                case SERVIZIO_APPLICATIVO: {
                    String protocollo;
                    provenienza = new Parameter("Applicativi", "serviziApplicativiList.do");
                    identificativi = exporterUtils.getIdsServiziApplicativi(objToExport);
                    for (Object id : identificativi) {
                        IDServizioApplicativo idServizioApplicativo = (IDServizioApplicativo)id;
                        protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                        if (protocolli.contains(protocollo)) continue;
                        protocolli.add(protocollo);
                    }
                    break;
                }
                case GRUPPO: {
                    provenienza = new Parameter("Tags", "gruppiList.do");
                    identificativi = exporterUtils.getIdsGruppi(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case RUOLO: {
                    provenienza = new Parameter("Ruoli", "ruoliList.do");
                    identificativi = exporterUtils.getIdsRuoli(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case SCOPE: {
                    provenienza = new Parameter("Scope", "scopeList.do");
                    identificativi = exporterUtils.getIdsScope(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY: {
                    provenienza = new Parameter("Registro Policy", "configurazioneControlloTrafficoConfigurazionePolicyList.do");
                    identificativi = exporterUtils.getIdsControlloTrafficoConfigPolicy(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE_CONTROLLO_TRAFFICO_ACTIVE_POLICY: {
                    provenienza = new Parameter("Policy Globali", "configurazioneControlloTrafficoAttivazionePolicyList.do");
                    identificativi = exporterUtils.getIdsControlloTrafficoActivePolicy(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case ALLARME: {
                    provenienza = new Parameter("Allarmi", "configurazioneAllarmiList.do");
                    identificativi = exporterUtils.getIdsAllarmi(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE_TOKEN_POLICY: {
                    provenienza = new Parameter("Token Policy", "configurazionePolicyGestioneTokenList.do?_tabKey_infoType=token");
                    identificativi = exporterUtils.getIdsTokenPolicy(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE_ATTRIBUTE_AUTHORITY: {
                    provenienza = new Parameter("Attribute Authority", "configurazionePolicyGestioneTokenList.do?_tabKey_infoType=aa");
                    identificativi = exporterUtils.getIdsTokenPolicy(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE_PLUGIN_CLASSE: {
                    provenienza = new Parameter("Registro Classi", "configurazionePluginsClassiList.do");
                    identificativi = exporterUtils.getIdsPluginClassi(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE_PLUGIN_ARCHVIO: {
                    provenienza = new Parameter("Registro Archivi", "configurazionePluginsArchiviList.do");
                    identificativi = exporterUtils.getIdsPluginArchivi(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA: {
                    provenienza = new Parameter("Regole di Proxy Pass", "configurazioneProxyPassRegolaList.do");
                    identificativi = exporterUtils.getIdsUrlInvocazioneRegole(objToExport);
                    protocolli = archiviCore.getProtocolli(request, session);
                    break;
                }
                case CONFIGURAZIONE: {
                    protocolli = archiviCore.getProtocolli(request, session);
                    if (tipoConfigurazione != null) break;
                    tipoConfigurazione = ArchiveType.ALL.toString();
                    break;
                }
                default: {
                    throw new Exception("Archive type [" + servletSourceExport + "] non supportato");
                }
            }
            String postBackElementName = archiviHelper.getPostBackElementName();
            String string = (String)protocolli.get(0);
            List<ExportMode> exportModes = exporterUtils.getExportModesCompatibleWithAllProtocol(protocolli, archiveType);
            boolean errore = false;
            String motivoErrore = null;
            if (exportModes.size() < 1) {
                errore = true;
                motivoErrore = protocolli.size() > 1 ? "&Egrave; stata richiesta una export di oggetti appartenenti a protocolli (" + protocolli.toString() + ") che non prevedono il medesimo formato di esportazione" : "&Egrave; stata richiesta una export di oggetti appartenenti a protocolli (" + protocolli.toString() + ") che non prevedono un formato di esportazione";
            }
            if ((exportMode = archiviHelper.getParameter("tipologiaArchivio")) != null && !exportModes.contains(new ExportMode(exportMode))) {
                exportMode = null;
            }
            if (exportMode == null && !errore) {
                exportMode = exportModes.contains(Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE) ? Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE.toString() : exportModes.get(0).toString();
            }
            boolean fineSceltaOpzioniEsportazione = !archiviHelper.isEditModeInProgress() && (postBackElementName == null || "".equals(postBackElementName));
            boolean configurationEnabled = ArchiveType.CONFIGURAZIONE.equals((Object)archiveType) && !archiviCore.isExportArchive_configurazione_soloDumpCompleto();
            boolean cascadeEnabled = !ArchiveType.CONFIGURAZIONE.equals((Object)archiveType) && archiviCore.isCascadeEnabled(exportModes, exportMode);
            boolean bl = nonSonoPresentiScelteEsportazione = exportModes.size() == 1 && !cascadeEnabled && !configurationEnabled;
            if (!errore && (fineSceltaOpzioniEsportazione || nonSonoPresentiScelteEsportazione)) {
                String send = "exporterArchivi?tipoExport=" + servletSourceExport;
                String prevIdTab = archiviHelper.getPrevTabId();
                if (prevIdTab != null) {
                    send = send + "&__tabKey__=" + prevIdTab;
                }
                if (objToExport != null && !"".equals(objToExport)) {
                    ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)objToExport, (String)"_tabKey_exportObjects");
                }
                if (string != null && !"".equals(string)) {
                    send = send + "&protocollo=" + string;
                }
                if (exportMode != null && !"".equals(exportMode)) {
                    send = send + "&tipologiaArchivio=" + exportMode;
                }
                if (tipoConfigurazione != null && !"".equals(tipoConfigurazione)) {
                    send = send + "&tipoDump=" + tipoConfigurazione;
                }
                if (cascadeEnabled) {
                    send = send + "&cascadePolicyConfig=" + (ServletUtils.isCheckBoxEnabled((String)cascadePolicyConfig) ? "yes" : "no");
                    send = send + "&cascadePluginConfig=" + (ServletUtils.isCheckBoxEnabled((String)cascadePluginConfig) ? "yes" : "no");
                    send = send + "&cascade=" + (ServletUtils.isCheckBoxEnabled((String)cascade) ? "yes" : "no");
                    ArchiveCascadeConfiguration cascadeConfig = archiviCore.getCascadeConfig(exportModes, exportMode);
                    if (cascadeConfig.isCascadePdd()) {
                        send = send + "&cascadePdd=" + (ServletUtils.isCheckBoxEnabled((String)cascadePdd) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeRuoli()) {
                        send = send + "&cascadeRuoli=" + (ServletUtils.isCheckBoxEnabled((String)cascadeRuoli) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeScope()) {
                        send = send + "&cascadeScope=" + (ServletUtils.isCheckBoxEnabled((String)cascadeScope) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeSoggetti()) {
                        send = send + "&cascadeSoggetti=" + (ServletUtils.isCheckBoxEnabled((String)cascadeSoggetti) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeServiziApplicativi()) {
                        send = send + "&cascadeServiziApplicativi=" + (ServletUtils.isCheckBoxEnabled((String)cascadeServiziApplicativi) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadePorteDelegate()) {
                        send = send + "&cascadePorteDelegate=" + (ServletUtils.isCheckBoxEnabled((String)cascadePorteDelegate) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadePorteApplicative()) {
                        send = send + "&cascadePorteApplicative=" + (ServletUtils.isCheckBoxEnabled((String)cascadePorteApplicative) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeAccordoCooperazione()) {
                        send = send + "&cascadeAc=" + (ServletUtils.isCheckBoxEnabled((String)cascadeAccordiCooperazione) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeAccordoServizioParteComune()) {
                        send = send + "&cascadeAspc=" + (ServletUtils.isCheckBoxEnabled((String)cascadeAccordiServizioParteComune) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeAccordoServizioComposto()) {
                        send = send + "&cascadeAsc=" + (ServletUtils.isCheckBoxEnabled((String)cascadeAccordiServizioComposto) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeAccordoServizioParteSpecifica()) {
                        send = send + "&cascadeAsps=" + (ServletUtils.isCheckBoxEnabled((String)cascadeAccordiServizioParteSpecifica) ? "yes" : "no");
                    }
                    if (cascadeConfig.isCascadeFruizioni()) {
                        send = send + "&cascadeFruizioni=" + (ServletUtils.isCheckBoxEnabled((String)cascadeFruizioni) ? "yes" : "no");
                    }
                }
                response.sendRedirect(send);
            }
            if (provenienza != null) {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{provenienza, new Parameter("Esporta", urlTitle)});
            } else {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Esporta", urlTitle)});
            }
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            if (ServletUtils.isCheckBoxEnabled((String)cascade) && ("cascade".equals(postBackElementName) || "tipologiaArchivio".equals(postBackElementName))) {
                cascadePdd = "yes";
                cascadeRuoli = "yes";
                cascadeScope = "yes";
                cascadeSoggetti = "yes";
                cascadeServiziApplicativi = "yes";
                cascadePorteDelegate = "yes";
                cascadePorteApplicative = "yes";
                cascadeAccordiCooperazione = "yes";
                cascadeAccordiServizioComposto = "yes";
                cascadeAccordiServizioParteComune = "yes";
                cascadeAccordiServizioParteSpecifica = "yes";
                cascadeFruizioni = "yes";
            }
            archiviHelper.addExportToDati(dati, protocolli, string, exportModes, exportMode, archiveType, objToExport, cascadePolicyConfig, cascadePluginConfig, cascade, tipoConfigurazione, cascadePdd, cascadeRuoli, cascadeScope, cascadeSoggetti, cascadeServiziApplicativi, cascadePorteDelegate, cascadePorteApplicative, cascadeAccordiCooperazione, cascadeAccordiServizioParteComune, cascadeAccordiServizioComposto, cascadeAccordiServizioParteSpecifica, cascadeFruizioni);
            pd.setDati(dati);
            pd.setLabelBottoneInvia("Esporta");
            pd.setDisabilitaAjaxStatusBottoneInvia();
            if (errore) {
                pd.setMessage(motivoErrore);
                pd.setMode("view-noeditbutton");
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"export", (ForwardParams)ArchiviCostanti.TIPO_OPERAZIONE_EXPORT);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"export", (ForwardParams)ArchiviCostanti.TIPO_OPERAZIONE_EXPORT);
        }
    }
}

