/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.controllo_traffico.policy.config.PolicyConfiguration;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ConfigurazioneControlloTrafficoAttivazionePolicyAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        TipoOperazione tipoOperazione = TipoOperazione.ADD;
        try {
            String errorAttivazione;
            String modalita;
            StringBuilder sbParsingError = new StringBuilder();
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            SoggettiCore soggettiCore = new SoggettiCore(confCore);
            PorteDelegateCore pdCore = new PorteDelegateCore(confCore);
            PorteApplicativeCore paCore = new PorteApplicativeCore(confCore);
            ConfigurazioneGenerale configurazioneControlloTraffico = confCore.getConfigurazioneControlloTraffico();
            AttivazionePolicy policy = new AttivazionePolicy();
            policy.setFiltro(new AttivazionePolicyFiltro());
            policy.getFiltro().setRuoloPorta(RuoloPolicy.ENTRAMBI);
            policy.setGroupBy(new AttivazionePolicyRaggruppamento());
            boolean first = confHelper.isFirstTimeFromHttpParameters("CTFirstTime");
            String ruoloPortaParam = confHelper.getParametroRuoloPolicy("CTPolicyRuoloPorta");
            RuoloPolicy ruoloPorta = null;
            if (ruoloPortaParam != null) {
                ruoloPorta = RuoloPolicy.toEnumConstant((String)ruoloPortaParam);
            }
            String nomePorta = confHelper.getParameter("CTPolicyNomePorta");
            ServiceBinding serviceBinding = null;
            String serviceBindingParam = confHelper.getParametroServiceBinding("CTPolicyServiceBinding");
            if (serviceBindingParam != null && !"".equals(serviceBindingParam)) {
                serviceBinding = ServiceBinding.valueOf((String)serviceBindingParam);
            }
            if ((modalita = confHelper.getParameter("CTPolicyActiveMode")) == null) {
                modalita = "Scegli criteri";
            }
            boolean builtIn = "Scegli criteri".equals(modalita);
            String idPolicy = confHelper.getParameter("CTPolicyActiveId");
            if (idPolicy != null && !"".equals(idPolicy) && !"-".equals(idPolicy)) {
                policy.setIdPolicy(idPolicy);
            } else if (!first) {
                policy.setIdPolicy(null);
            }
            InfoPolicy infoPolicy = null;
            if (policy.getIdPolicy() != null) {
                infoPolicy = confCore.getInfoPolicy(policy.getIdPolicy());
                if (TipoOperazione.ADD.equals((Object)tipoOperazione) && infoPolicy != null) {
                    String serialId = confCore.getNextPolicyInstanceSerialId(infoPolicy.getIdPolicy());
                    policy.setIdActivePolicy(ControlloTrafficoDriverUtils.buildIdActivePolicy((String)infoPolicy.getIdPolicy(), (String)serialId));
                }
            }
            if ((errorAttivazione = confHelper.readDatiAttivazionePolicyFromHttpParameters(policy, first, tipoOperazione, infoPolicy)) != null) {
                confHelper.addParsingError(sbParsingError, errorAttivazione);
            }
            PolicyGroupByActiveThreadsType type = null;
            if (ruoloPorta != null) {
                PolicyConfiguration pc;
                String protocollo = null;
                String tipoSoggettoProprietario = null;
                String nomeSoggettoProprietario = null;
                if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(nomePorta);
                    porta = pdCore.getPortaDelegata(idPD);
                    protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(porta.getTipoSoggettoProprietario());
                    tipoSoggettoProprietario = porta.getTipoSoggettoProprietario();
                    nomeSoggettoProprietario = porta.getNomeSoggettoProprietario();
                    config = new PolicyConfiguration(porta.getProprietaRateLimitingList(), confCore.getControlloTrafficoPolicyRateLimitingTipiGestori(), false);
                    type = config.getType();
                } else {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(nomePorta);
                    porta = paCore.getPortaApplicativa(idPA);
                    protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(porta.getTipoSoggettoProprietario());
                    config = new PolicyConfiguration(porta.getProprietaRateLimitingList(), confCore.getControlloTrafficoPolicyRateLimitingTipiGestori(), false);
                    type = config.getType();
                }
                policy.getFiltro().setEnabled(true);
                policy.getFiltro().setProtocollo(protocollo);
                policy.getFiltro().setRuoloPorta(ruoloPorta);
                policy.getFiltro().setNomePorta(nomePorta);
                if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                    policy.getFiltro().setTipoFruitore(tipoSoggettoProprietario);
                    policy.getFiltro().setNomeFruitore(nomeSoggettoProprietario);
                }
                if (type == null && (pc = confCore.getConfigurazioneControlloTrafficoRateLimitingProperties()) != null) {
                    type = pc.getType();
                }
            } else {
                PolicyConfiguration pc = confCore.getConfigurazioneControlloTrafficoRateLimitingProperties();
                if (pc != null) {
                    type = pc.getType();
                }
            }
            List<Parameter> lstParamPorta = null;
            if (ruoloPorta != null) {
                lstParamPorta = confHelper.getTitleListAttivazionePolicy(ruoloPorta, nomePorta, serviceBinding, "Aggiungi");
            }
            List<Parameter> lstParam = null;
            if (lstParamPorta != null) {
                lstParam = lstParamPorta;
            } else {
                lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Controllo del Traffico", "configurazioneControlloTraffico.do"));
                lstParam.add(new Parameter("Policy Globali", "configurazioneControlloTrafficoAttivazionePolicyList.do"));
                lstParam.add(ServletUtils.getParameterAggiungi());
            }
            List<InfoPolicy> infoPolicies = confCore.infoPolicyList(builtIn);
            if (confHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addAttivazionePolicyToDati(dati, tipoOperazione, policy, "Policy", infoPolicies, ruoloPorta, nomePorta, serviceBinding, modalita, type);
                confHelper.addToDatiFirstTimeDisabled(dati, "CTFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.attivazionePolicyCheckData(sbParsingError, tipoOperazione, configurazioneControlloTraffico, policy, infoPolicy, ruoloPorta, nomePorta, serviceBinding, modalita);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addAttivazionePolicyToDati(dati, tipoOperazione, policy, "Policy", infoPolicies, ruoloPorta, nomePorta, serviceBinding, modalita, type);
                confHelper.addToDatiFirstTimeDisabled(dati, "CTFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.ADD());
            }
            ConfigurazioneUtilities.updatePosizioneAttivazionePolicy(confCore, infoPolicy, policy, ruoloPorta, nomePorta);
            confCore.performCreateOperation(userLogin, confHelper.smista(), policy);
            String msgCompletato = confHelper.eseguiResetJmx(TipoOperazione.ADD, ruoloPorta, nomePorta);
            if (msgCompletato != null && !"".equals(msgCompletato)) {
                pd.setMessage(msgCompletato, Costanti.MESSAGE_TYPE_INFO);
            }
            int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<TipoRisorsaPolicyAttiva> listaTipoRisorsa = confHelper.gestisciCriteriFiltroRisorsaPolicy(ricerca, ruoloPorta, nomePorta);
            TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.getTipo((TipoRisorsa)infoPolicy.getTipoRisorsa(), (boolean)infoPolicy.isCheckRichiesteSimultanee());
            ricerca.addFilter(idLista, "filtroTipoRisorsaPolicy", tipoRisorsaPolicyAttiva.getValue());
            List<AttivazionePolicy> lista = confCore.attivazionePolicyList(ricerca, ruoloPorta, nomePorta);
            confHelper.prepareAttivazionePolicyList(ricerca, lista, listaTipoRisorsa, idLista, ruoloPorta, nomePorta, serviceBinding);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.ADD());
        }
    }
}

