/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public class ConfigurazioneControlloTrafficoConfigurazionePolicyDel
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            String objToRemove = confHelper.getParameter("obj");
            ArrayList<String> idsToRemove = Utilities.parseIdsToRemove(objToRemove);
            StringBuilder inUsoMessage = new StringBuilder();
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            boolean normalizeObjectIds = !confHelper.isModalitaCompleta();
            ArrayList<ConfigurazionePolicy> elemToRemove = new ArrayList<ConfigurazionePolicy>();
            boolean delBuiltIn = false;
            boolean delUtente = false;
            for (int i = 0; i < idsToRemove.size(); ++i) {
                boolean delete = true;
                long idPolicy = Long.parseLong(idsToRemove.get(i));
                ConfigurazionePolicy policy = confCore.getConfigurazionePolicy(idPolicy);
                IdPolicy idPolicyObject = new IdPolicy();
                idPolicyObject.setNome(policy.getIdPolicy());
                if (policy.isBuiltIn()) {
                    inUsoMessage.append("- ");
                    inUsoMessage.append(policy.getIdPolicy());
                    inUsoMessage.append(" non eliminabile");
                    inUsoMessage.append("<br/>");
                    delete = false;
                    delBuiltIn = true;
                } else {
                    boolean policyInUso = confCore.isRateLimitingPolicyInUso(idPolicyObject, whereIsInUso, normalizeObjectIds);
                    if (policyInUso) {
                        inUsoMessage.append(DBOggettiInUsoUtils.toString((IdPolicy)idPolicyObject, whereIsInUso, (boolean)true, (String)"<br/>"));
                        inUsoMessage.append("<br/>");
                        delete = false;
                    }
                }
                if (!delete) continue;
                elemToRemove.add(policy);
            }
            if (inUsoMessage.length() > 0) {
                inUsoMessage.append("<br/>");
                if (delBuiltIn) {
                    inUsoMessage.append("<br/>").append("!Attenzione! Le policy 'Built-in' non possono essere eliminate.");
                }
                if (delUtente) {
                    if (delBuiltIn) {
                        inUsoMessage.append("<br/>");
                    }
                    inUsoMessage.append("<br/>").append("Per poter eliminare una policy 'Utente' dal registro \u00e8 necessario prima eliminare tutte le sue istanze esistenti in Rate Limiting");
                }
            }
            if (elemToRemove.size() > 0) {
                confCore.performDeleteOperation(userLogin, confHelper.smista(), elemToRemove.toArray(new ConfigurazionePolicy[1]));
            }
            if (inUsoMessage.length() > 0) {
                pd.setMessage(inUsoMessage.toString());
            } else {
                pd.setMessage("Configurazione Controllo del Traffico modificata con successo", MessageType.INFO);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIGURAZIONE_POLICY;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<ConfigurazionePolicy> lista = confCore.configurazionePolicyList(ricerca);
            confHelper.prepareConfigurazionePolicyList(ricerca, lista, idLista);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"configurazioneControlloTrafficoConfigurazionePolicy", (ForwardParams)ForwardParams.DEL());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneControlloTrafficoConfigurazionePolicy", (ForwardParams)ForwardParams.DEL());
        }
    }
}

